
DROP TABLE IF EXISTS pgbench_warm_branches;
DROP TABLE IF EXISTS pgbench_warm_accounts;

CREATE TABLE pgbench_warm_branches (
	bid bigint,
	bbalance bigint);

CREATE TABLE pgbench_warm_accounts (
	aid bigint,
	bid bigint,
	abalance bigint,
	aid1 bigint ,
	aid2 bigint ,
	aid3 bigint ,
	aid4 bigint ,
	aid5 text DEFAULT md5(random()::text),
	aid6 text DEFAULT md5(random()::text),
	aid7 text DEFAULT md5(random()::text),
	aid8 text DEFAULT md5(random()::text),
	aid9 text DEFAULT md5(random()::text),
	aid10 text DEFAULT md5(random()::text),
	gistcol	polygon DEFAULT NULL
);

-- Update using aid1. aid1 should stay within the range (aid * 10 - 2 <= aid1 <= aid * 10 + 2) 
CREATE OR REPLACE FUNCTION pgbench_warm_update_using_aid1(chg integer, v_aid bigint, v_bid bigint, delta bigint)
RETURNS VOID AS $$
DECLARE
	qry VARCHAR;
	lower VARCHAR;
	upper VARCHAR;
	range integer;
	aid_updated bigint;
BEGIN
	range := 2;
	UPDATE pgbench_warm_accounts p SET aid1 = aid1 +  chg,  abalance = abalance +
delta  WHERE aid1 >= v_aid * 10 - range - chg AND aid1 <= v_aid * 10 + range - chg
RETURNING p.aid INTO aid_updated;
	IF aid_updated IS NOT NULL THEN
		UPDATE pgbench_warm_branches p SET bbalance = bbalance + delta WHERE p.bid = v_bid;
	ELSE
		SELECT aid INTO aid_updated FROM pgbench_warm_accounts p WHERE aid1 >=
v_aid * 10 - range AND aid1 <= v_aid * 10 + range;
		IF aid_updated IS NULL THEN
			RAISE EXCEPTION 'pgbench_warm_accounts row not found';
		END IF;
	END IF;
END
$$ LANGUAGE plpgsql;

-- Update using aid2. aid2 should stay within the range (aid * 20 - 4 <= aid2 <= aid * 20 + 4) 
CREATE OR REPLACE FUNCTION pgbench_warm_update_using_aid2(chg integer, v_aid bigint, v_bid bigint, delta bigint)
RETURNS VOID AS $$
DECLARE
	qry VARCHAR;
	lower VARCHAR;
	upper VARCHAR;
	range integer;
	aid_updated bigint;
BEGIN
	range := 4;
	UPDATE pgbench_warm_accounts p SET aid2 = aid2 +  chg,  abalance = abalance +
delta  WHERE aid2 >= v_aid * 20 - range - chg AND aid2 <= v_aid * 20 + range - chg
RETURNING p.aid INTO aid_updated;
	IF aid_updated IS NOT NULL THEN
		UPDATE pgbench_warm_branches p SET bbalance = bbalance + delta WHERE p.bid = v_bid;
	ELSE
		SELECT aid INTO aid_updated FROM pgbench_warm_accounts p WHERE aid2 >= v_aid * 20 - range AND aid2 <= v_aid * 20 + range;
		IF aid_updated IS NULL THEN
			RAISE EXCEPTION 'pgbench_warm_accounts row not found';
		END IF;
	END IF;
END
$$ LANGUAGE plpgsql;

-- Update using aid3. aid3 should stay within the range (aid * 30 - 6 <= aid3 <= aid * 30 + 6) 
CREATE OR REPLACE FUNCTION pgbench_warm_update_using_aid3(chg integer, v_aid bigint, v_bid bigint, delta bigint)
RETURNS VOID AS $$
DECLARE
	qry VARCHAR;
	lower VARCHAR;
	upper VARCHAR;
	range integer;
	aid_updated bigint;
BEGIN
	range := 6;
	UPDATE pgbench_warm_accounts p SET aid3 = aid3 +  chg,  abalance = abalance +
delta  WHERE aid3 >= v_aid * 30 - range - chg AND aid3 <= v_aid * 30 + range - chg
RETURNING p.aid INTO aid_updated;
	IF aid_updated IS NOT NULL THEN
		UPDATE pgbench_warm_branches p SET bbalance = bbalance + delta WHERE p.bid = v_bid;
	ELSE
		SELECT aid INTO aid_updated FROM pgbench_warm_accounts p WHERE aid3 >= v_aid * 30 - range AND aid3 <= v_aid * 30 + range;
		IF aid_updated IS NULL THEN
			RAISE EXCEPTION 'pgbench_warm_accounts row not found';
		END IF;
	END IF;
END
$$ LANGUAGE plpgsql;

-- Update using aid4. aid4 should stay within the range (aid * 40 - 8 <= aid4 <= aid * 40 + 8) 
CREATE OR REPLACE FUNCTION pgbench_warm_update_using_aid4(chg integer, v_aid bigint, v_bid bigint, delta bigint)
RETURNS VOID AS $$
DECLARE
	qry VARCHAR;
	lower VARCHAR;
	upper VARCHAR;
	range integer;
	aid_updated bigint;
BEGIN
	range := 8;
	UPDATE pgbench_warm_accounts p SET aid4 = aid4 +  chg,  abalance = abalance +
delta  WHERE aid4 >= v_aid * 40 - range - chg AND aid4 <= v_aid * 40 + range - chg
RETURNING p.aid INTO aid_updated;
	IF aid_updated IS NOT NULL THEN
		UPDATE pgbench_warm_branches p SET bbalance = bbalance + delta WHERE p.bid = v_bid;
	ELSE
		SELECT aid INTO aid_updated FROM pgbench_warm_accounts p WHERE aid4 >= v_aid * 40 - range AND aid4 <= v_aid * 40 + range;
		IF aid_updated IS NULL THEN
			RAISE EXCEPTION 'pgbench_warm_accounts row not found';
		END IF;
	END IF;
END
$$ LANGUAGE plpgsql;

-- Ensure that exactly one row exists within a given range. Use different
-- indexes to fetch the row
CREATE OR REPLACE FUNCTION pgbench_warm_check_row(v_aid bigint)
RETURNS VOID AS $$
DECLARE
	range integer;
	factor integer;
	ret_aid1 bigint;
	ret_aid2 bigint;
	ret_aid3 bigint;
	ret_aid4 bigint;
BEGIN
	range := 2;
	factor := 10;
	SELECT aid INTO ret_aid1 FROM pgbench_warm_accounts p WHERE aid1 >= v_aid *
		factor - range AND aid1 <= v_aid * factor + range;

	range := 4;
	factor := 20;
	SELECT aid INTO ret_aid2 FROM pgbench_warm_accounts p WHERE aid2 >= v_aid *
		factor - range AND aid2 <= v_aid * factor + range;

	range := 6;
	factor := 30;
	SELECT aid INTO ret_aid3 FROM pgbench_warm_accounts p WHERE aid3 >= v_aid *
		factor - range AND aid3 <= v_aid * factor + range;

	range := 8;
	factor := 40;
	SELECT aid INTO ret_aid4 FROM pgbench_warm_accounts p WHERE aid4 >= v_aid *
		factor - range AND aid4 <= v_aid * factor + range;
	
	IF ret_aid1 IS NULL OR ret_aid1 != v_aid THEN
		RAISE EXCEPTION 'pgbench_warm_accounts row (%) not found via aid1', v_aid;
	END IF;

	IF ret_aid2 IS NULL OR ret_aid2 != v_aid THEN
		RAISE EXCEPTION 'pgbench_warm_accounts row (%) not found via aid2', v_aid;
	END IF;
	
	IF ret_aid3 IS NULL OR ret_aid3 != v_aid THEN
		RAISE EXCEPTION 'pgbench_warm_accounts row (%) not found via aid3', v_aid;
	END IF;
	
	IF ret_aid4 IS NULL OR ret_aid4 != v_aid THEN
		RAISE EXCEPTION 'pgbench_warm_accounts row (%) not found via aid4', v_aid;
	END IF;
END
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION pgbench_warm_check_consistency()
RETURNS VOID AS $$
DECLARE
	sum_abalance bigint;
	sum_bbalance bigint;
BEGIN
	SELECT sum(abalance) INTO sum_abalance FROM pgbench_warm_accounts;
	SELECT sum(bbalance) INTO sum_bbalance FROM pgbench_warm_branches;
	IF sum_abalance != sum_bbalance THEN
		RAISE EXCEPTION 'Found inconsitency in sum (%, %)', sum_abalance, sum_bbalance;
	END IF;
END
$$ LANGUAGE plpgsql;

-- Does generate_series() leak memory. Had trouble inserting everything in a
-- single shot with large scale factor
\set end 0
\set start (:end + 1)
\set end (:start + (:scale * 100))
INSERT INTO pgbench_warm_branches SELECT
	generate_series(:start, :end ),
	0
	;

\set end 0
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
\set start (:end + 1)
\set end (:start + (:scale * 10000))
INSERT INTO pgbench_warm_accounts SELECT
	generate_series(:start, :end ),
	(random()::bigint) % :scale,
	0,
	generate_series(:start * 10, :end * 10, 10),
	generate_series(:start * 20, :end * 20, 20),
	generate_series(:start * 30, :end * 30, 30),
	generate_series(:start * 40, :end * 40, 40)
	;
	

CREATE UNIQUE INDEX pgb_a_aid ON pgbench_warm_accounts(aid);
CREATE INDEX pgb_a_aid1 ON pgbench_warm_accounts(aid1);
CREATE INDEX pgb_a_aid2 ON pgbench_warm_accounts(aid2);
CREATE INDEX pgb_a_aid3 ON pgbench_warm_accounts(aid3);
CREATE INDEX pgb_a_aid4 ON pgbench_warm_accounts(aid4);

CREATE UNIQUE INDEX pgb_b_bid ON pgbench_warm_branches(bid);
CREATE INDEX pgb_b_bbalance ON pgbench_warm_branches(bbalance);

VACUUM ANALYZE;
