
create_index=1
concurrent_index=0
gist_index=0

# number of clients for running each of the query sets
num_clients_set1=50
num_clients_set2=50

# scale factor for the tables
scale=100

# number of threads 
# (num_clients_set1 + num_clients_set2) should be a  multiple of this value
threads=20

# how long the main pgbench test should run, in seconds
test_duration=3600

# sleep for these many seconds in every step of parallel workload
step_sleep=6

# sleep for these many seconds after one complete round of parallel workload
loop_sleep=120

# long transaction runs for these many seconds
long_txn_sleep=120

let clients=$num_clients_set1+$num_clients_set2

testid=`date "+%Y_%m_%d_%H%M%S"`
echo "Running test $testid"

# Initialise
pgbench -n -c 1 -t 1 -f warm_stress_init.sql -s $scale postgres > pgbench_$testid.log 2>&1

for i in `seq 1 $num_clients_set1`; do
	options="$options -f warm_q1.sql "
done 

for i in `seq 1 $num_clients_set2`; do
	options="$options -f warm_q2.sql "
done 

end_time=`psql -At -c "select now() + '$test_duration seconds'" postgres`
pgbench -n -c $clients $options -T $test_duration -j $threads -s $scale postgres > pgbench_$testid.log 2>&1 &

while (true); do
	# Run consistency check
	pgbench -n -s $scale -c 1 -t 1 -f warm_check.sql postgres >> check_$testid.log 2>&1
	
	# Drop and recreate index on aid1
	if [ "$create_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid1" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX pgb_a_aid1 ON pgbench_warm_accounts(aid1);" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
	fi

	if [ "$concurrent_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid1" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX CONCURRENTLY pgb_a_aid1 ON pgbench_warm_accounts(aid1);" postgres >> check_$testid.log 2>&1
	fi
	sleep $step_sleep;
	
	# Drop and recreate index on aid1
	if [ "$create_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid2" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX pgb_a_aid2 ON pgbench_warm_accounts(aid2);" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
	fi

	if [ "$concurrent_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid2" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX CONCURRENTLY pgb_a_aid2 ON pgbench_warm_accounts(aid2);" postgres >> check_$testid.log 2>&1
	fi
	sleep $step_sleep;
	
	# Drop and recreate index on aid3
	if [ "$create_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid3" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX pgb_a_aid3 ON pgbench_warm_accounts(aid3);" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
	fi

	if [ "$concurrent_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid3" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX CONCURRENTLY pgb_a_aid3 ON pgbench_warm_accounts(aid3);" postgres >> check_$testid.log 2>&1
	fi
	sleep $step_sleep;
	
	# Drop and recreate index on aid4
	if [ "$create_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid4" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX pgb_a_aid4 ON pgbench_warm_accounts(aid4);" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
	fi

	if [ "$concurrent_index" == "1" ]; then
		psql -At -c "DROP INDEX pgb_a_aid4" postgres >> check_$testid.log 2>&1
		psql -At -c "CREATE INDEX CONCURRENTLY pgb_a_aid4 ON pgbench_warm_accounts(aid4);" postgres >> check_$testid.log 2>&1
	fi
	sleep $step_sleep;

	# Start a long running transaction
	psql -At -c "BEGIN; SELECT txid_current(); SELECT pg_sleep($long_txn_sleep); COMMIT;" postgres >> check_$testid.log 2>&1
	sleep $step_sleep;

	# Create GiST index
	if [ $gist_index == "1" ]; then
		psql -At -c "CREATE INDEX gistindx ON pgbench_warm_accounts USING gist(gistcol)" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
		psql -At -c "DROP INDEX gistindx" postgres >> check_$testid.log 2>&1
		sleep $step_sleep;
	fi
	
	# check if its time exit
	res=`psql -At -c "SELECT now() > '$end_time'::timestamp" postgres`
	if [ "$res" == "t" ]; then
		break;
	fi
	
	sleep $loop_sleep;
done

wait

psql -At -c "VACUUM FULL pgbench_warm_accounts" postgres >> check_$testid.log 2>&1
psql -At -c "VACUUM FULL pgbench_warm_branches" postgres >> check_$testid.log 2>&1
pgbench -n -s $scale -c 1 -t 1 -f warm_check.sql postgres >> check_$testid.log 2>&1

psql -At -c "SELECT * FROM pg_stat_user_tables" postgres >> check_$testid.log 2>&1
psql -At -c "SELECT * FROM pg_stat_user_indexes" postgres >> check_$testid.log 2>&1
psql -At -c "SELECT * FROM pg_statio_user_tables" postgres >> check_$testid.log 2>&1
psql -At -c "SELECT * FROM pg_statio_user_indexes" postgres >> check_$testid.log 2>&1

cat check_$testid.log pgbench_$testid.log | grep ERROR
if [ $? -ne 0 ]; then
	echo "Test PASS"
	echo ""
else
	echo "Test FAIL - check logs check_$testid.log and pgbench_$testid.log"
	echo ""
fi
