psql postgres < fsmtest.sql


psql postgres -c "DROP TABLE foo;"
psql postgres -c "CREATE TABLE foo (data text);"

function runtest {
  psql postgres -c "TRUNCATE foo; INSERT INTO foo SELECT (repeat('a', 300)) FROM generate_series(1, $1); DELETE FROM foo WHERE ctid < (SELECT max(ctid) FROM foo);"
  psql postgres -c "VACUUM foo;"
  psql postgres -c "SELECT pg_relation_size('foo')::text || ' bytes'"
  pgbench -n -f fsmbench.sql postgres -t 100 -c 1
  pgbench -n -f fsmbench.sql postgres -t 100 -c 2
}

# 10 tuples, fits in one page
runtest 10

# 1000 tuples
runtest 1000

# 10000 tuples, still fits in one FSM page
runtest 10000

# 100000 tuples, still fits in one FSM page
runtest 100000

# 1000000 tuples, Doesn't fit in one FSM page anymore
runtest 1000000

# 10000000 tuples
runtest 10000000

# 100000000, Doesn't fit in two FSM levels any more
runtest 100000000
