#include "postgres.h"

#include "storage/freespace.h"
#include "access/heapam.h"
#include "storage/bufmgr.h"
#include "utils/rel.h"

PG_MODULE_MAGIC;

Datum		fsmstresstest(PG_FUNCTION_ARGS);
PG_FUNCTION_INFO_V1(fsmstresstest);

static Size
randomSize()
{
	return random()%8100;
}

Datum
fsmstresstest(PG_FUNCTION_ARGS)
{
	Oid			relOid = PG_GETARG_OID(0);
	int32		iterations = PG_GETARG_INT32(1);
	Relation	rel;
	int			i;
	BlockNumber	nblocks;

	rel = relation_open(relOid, AccessShareLock);

	nblocks = RelationGetNumberOfBlocks(rel);

	for(i = 0; i < iterations; i++)
	{
		Size oldSize = randomSize();
		Size searchSize = randomSize();
		BlockNumber blk = random() % nblocks;
		//elog(NOTICE, "%d %d %d", blk, oldSize, searchSize);
#ifdef NEW_FSM
		RecordAndGetPageWithFreeSpace(rel, blk, oldSize, searchSize);
#else
		RecordAndGetPageWithFreeSpace(&rel->rd_node, blk, oldSize, searchSize);
#endif
	}

	relation_close(rel, AccessShareLock);
	PG_RETURN_VOID();
}
