/*-------------------------------------------------------------------------
 *
 * blackhole.c
 *		Set of functions for a minimal extension template
 *
 * Copyright (c) 2013-2015, Michael Paquier
 * Copyright (c) 1996-2015, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *		  blackhole/blackhole.c
 *
 *-------------------------------------------------------------------------
 */

#include "postgres.h"
#include "fmgr.h"
#include "utils/palloc.h"

PG_MODULE_MAGIC;

/*
 * This is the blackhole function.
 */
PG_FUNCTION_INFO_V1(blackhole_palloc);

Datum
blackhole_palloc(PG_FUNCTION_ARGS)
{
	Size alloc_size = PG_GETARG_UINT32(0);
	bool is_huge = PG_GETARG_BOOL(1);
	bool is_no_oom = PG_GETARG_BOOL(2);
	bool is_zero = PG_GETARG_BOOL(3);
	bool is_zero_aligned = PG_GETARG_BOOL(4);
	int flags = 0;
	char *ptr;

	if (is_huge)
		flags |= MCXT_ALLOC_HUGE;
	if (is_no_oom)
		flags |= MCXT_ALLOC_NO_OOM;
	if (is_zero)
		flags |= MCXT_ALLOC_ZERO;
	if (is_zero_aligned)
		flags |= MCXT_ALLOC_ZERO_ALIGNED;
	ptr = MemoryContextAllocExtended(CurrentMemoryContext,
									 alloc_size, flags);
	if (ptr)
		pfree(ptr);
	PG_RETURN_NULL();
}
