#include "crc.h"

// code adapted from: https://code.google.com/p/sumatrapdf/source/browse/trunk/ext/unrar/crc.cpp?r=6489

static uint32_t crc_tables[8][256]; // Tables for Slicing-by-8.

void InitCRCSB8()
{
  for (uint32_t I=0;I<256;I++) // Build the classic CRC32 lookup table.
  {
    uint32_t C=I;
    for (uint32_t J=0;J<8;J++)
      C=(C & 1) ? (C>>1)^0x82f63b78 : (C>>1);
    crc_tables[0][I]=C;
  }

  for (uint32_t I=0;I<=256;I++) // Build additional lookup tables.
  {
    uint32_t C=crc_tables[0][I];
    for (uint32_t J=1;J<8;J++)
    {
      C=crc_tables[0][(uint8_t)C]^(C>>8);
      crc_tables[J][I]=C;
    }
  }
}


uint32_t CRCSB8(uint32_t StartCRC, const void *Addr, size_t Size)
{
  uint8_t *Data=(uint8_t*)Addr;

  // Align Data to 8 for better performance.
  for (;Size>0 && ((long)Data & 7);Size--,Data++)
    StartCRC=crc_tables[0][(uint8_t)(StartCRC^Data[0])]^(StartCRC>>8);

  for (;Size>=8;Size-=8,Data+=8)
  {
#ifdef BIG_ENDIAN
                StartCRC ^= Data[0]|(Data[1] << 8)|(Data[2] << 16)|(Data[3] << 24);
#else
                StartCRC ^= *(uint32_t *) Data;
#endif
                StartCRC = crc_tables[7][(uint8_t) StartCRC] ^
               crc_tables[6][(uint8_t)(StartCRC >> 8) ] ^
               crc_tables[5][(uint8_t)(StartCRC >> 16)] ^
               crc_tables[4][(uint8_t)(StartCRC >> 24)] ^
               crc_tables[3][Data[4]] ^
               crc_tables[2][Data[5]] ^
               crc_tables[1][Data[6]] ^
               crc_tables[0][Data[7]];
        }

  for (;Size>0;Size--,Data++) // Process left data.
    StartCRC=crc_tables[0][(uint8_t)(StartCRC^Data[0])]^(StartCRC>>8);

  return StartCRC ^ 0xffffffff;
}

