--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

--
-- Name: sq_pk_buying_office; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_buying_office
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_buying_office OWNER TO postgres;

--
-- Name: sq_pk_department; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_department
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_department OWNER TO postgres;

--
-- Name: sq_pk_district; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_district
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_district OWNER TO postgres;

--
-- Name: sq_pk_entity_reset; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_entity_reset
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_entity_reset OWNER TO postgres;

--
-- Name: sq_pk_location; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_location
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_location OWNER TO postgres;

--
-- Name: sq_pk_market; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_market
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_market OWNER TO postgres;

--
-- Name: sq_pk_mregion; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_mregion
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_mregion OWNER TO postgres;

--
-- Name: sq_pk_ogrp; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_ogrp
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_ogrp OWNER TO postgres;

--
-- Name: sq_pk_order_location; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_order_location
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_order_location OWNER TO postgres;

--
-- Name: sq_pk_program; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_program
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_program OWNER TO postgres;

--
-- Name: sq_pk_program_location; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_program_location
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_program_location OWNER TO postgres;

--
-- Name: sq_pk_program_type; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_program_type
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_program_type OWNER TO postgres;

--
-- Name: sq_pk_project; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_project
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_project OWNER TO postgres;

--
-- Name: sq_pk_project_department; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_project_department
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_project_department OWNER TO postgres;

--
-- Name: sq_pk_project_participant; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_project_participant
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_project_participant OWNER TO postgres;

--
-- Name: sq_pk_project_status; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_project_status
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_project_status OWNER TO postgres;

--
-- Name: sq_pk_region; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_region
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_region OWNER TO postgres;

--
-- Name: sq_pk_reset; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_reset
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_reset OWNER TO postgres;

--
-- Name: sq_pk_reset_status; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_reset_status
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_reset_status OWNER TO postgres;

--
-- Name: sq_pk_reset_survey; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_reset_survey
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_reset_survey OWNER TO postgres;

--
-- Name: sq_pk_reset_team; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_reset_team
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_reset_team OWNER TO postgres;

--
-- Name: sq_pk_rollout_schedule; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_rollout_schedule
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_rollout_schedule OWNER TO postgres;

--
-- Name: sq_pk_vendor; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE sq_pk_vendor
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sq_pk_vendor OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: tb_buying_office; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_buying_office (
    buying_office integer DEFAULT nextval('sq_pk_buying_office'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(64) NOT NULL,
    short_name character varying(16) NOT NULL,
    abbreviation character varying(3) NOT NULL
);


ALTER TABLE public.tb_buying_office OWNER TO postgres;

--
-- Name: tb_department; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_department (
    department integer DEFAULT nextval('sq_pk_department'::regclass) NOT NULL,
    number character varying(3) NOT NULL,
    name character varying NOT NULL,
    parent integer,
    business_unit integer,
    deleted boolean DEFAULT false NOT NULL,
    email_address character varying(1024) DEFAULT NULL::character varying,
    surrogate_department integer
);


ALTER TABLE public.tb_department OWNER TO postgres;

--
-- Name: tb_district; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_district (
    district integer DEFAULT nextval('sq_pk_district'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(64) NOT NULL,
    short_name character varying(16) NOT NULL,
    abbreviation character varying(3) NOT NULL
);


ALTER TABLE public.tb_district OWNER TO postgres;

--
-- Name: tb_entity_reset; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_entity_reset (
    entity_reset integer DEFAULT nextval('sq_pk_entity_reset'::regclass) NOT NULL,
    entity integer NOT NULL,
    reset integer NOT NULL,
    role integer NOT NULL
);


ALTER TABLE public.tb_entity_reset OWNER TO postgres;

--
-- Name: tb_fiscal_calendar; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_fiscal_calendar (
    day date NOT NULL,
    week integer NOT NULL,
    month integer NOT NULL,
    quarter integer NOT NULL,
    year integer NOT NULL,
    week_start date NOT NULL,
    week_end date NOT NULL,
    month_week integer NOT NULL,
    CONSTRAINT tb_fiscal_calendar_month_check CHECK (((month >= 1) AND (month <= 12))),
    CONSTRAINT tb_fiscal_calendar_quarter_check CHECK (((quarter >= 1) AND (quarter <= 4))),
    CONSTRAINT tb_fiscal_calendar_week_check CHECK (((week >= 1) AND (week <= 53))),
    CONSTRAINT tb_fiscal_calendar_year_check CHECK (((year >= 1977) AND (year <= 2200)))
);


ALTER TABLE public.tb_fiscal_calendar OWNER TO postgres;

--
-- Name: tb_fiscal_month; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_fiscal_month (
    fiscal_month integer NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.tb_fiscal_month OWNER TO postgres;

--
-- Name: tb_location; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_location (
    location integer DEFAULT nextval('sq_pk_location'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(256) NOT NULL,
    short_name character varying(32),
    abbreviation character varying(6),
    address_line_one character varying(128),
    address_line_two character varying(128),
    city character varying(256),
    region integer,
    zip_postal character varying(10),
    market integer,
    buying_office integer,
    mregion integer,
    division integer,
    company integer DEFAULT 0 NOT NULL,
    district integer,
    ogrp integer,
    fedex_location integer,
    reset_team integer,
    sap_address_id integer,
    disabled boolean DEFAULT false NOT NULL,
    phone_number character varying(32),
    fax_number character varying(32),
    parent integer,
    location_type integer,
    modified timestamp without time zone DEFAULT now() NOT NULL,
    latitude numeric(10,7),
    longitude numeric(10,7),
    data_partner integer,
    vendor integer,
    final_execution_date date,
    dock_open_time time without time zone,
    dock_close_time time without time zone,
    dock_manager_name character varying(128) DEFAULT NULL::character varying,
    dock_manager_phone character varying(32) DEFAULT NULL::character varying,
    store_open_date timestamp without time zone,
    square_footage double precision
);


ALTER TABLE public.tb_location OWNER TO postgres;

--
-- Name: tb_market; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_market (
    market integer DEFAULT nextval('sq_pk_market'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(64) NOT NULL,
    short_name character varying(16) NOT NULL,
    abbreviation character varying(3) NOT NULL
);


ALTER TABLE public.tb_market OWNER TO postgres;

--
-- Name: tb_mregion; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_mregion (
    mregion integer DEFAULT nextval('sq_pk_mregion'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(64) NOT NULL,
    short_name character varying(16) NOT NULL,
    abbreviation character varying(3) NOT NULL
);


ALTER TABLE public.tb_mregion OWNER TO postgres;

--
-- Name: tb_ogrp; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_ogrp (
    ogrp integer DEFAULT nextval('sq_pk_ogrp'::regclass) NOT NULL,
    number integer NOT NULL,
    name character varying(64) NOT NULL,
    short_name character varying(16) NOT NULL,
    abbreviation character varying(3) NOT NULL
);


ALTER TABLE public.tb_ogrp OWNER TO postgres;

--
-- Name: tb_order_location; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_order_location (
    order_location integer DEFAULT nextval('sq_pk_order_location'::regclass) NOT NULL,
    orderid integer NOT NULL,
    location integer NOT NULL,
    requested_delivery_date timestamp without time zone NOT NULL,
    order_transmission_disabled timestamp without time zone
);


ALTER TABLE public.tb_order_location OWNER TO postgres;

--
-- Name: tb_program; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_program (
    program integer DEFAULT nextval('sq_pk_program'::regclass) NOT NULL,
    creator integer NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    modifier integer NOT NULL,
    modified timestamp without time zone DEFAULT now() NOT NULL,
    program_status integer NOT NULL,
    name character varying(256) NOT NULL,
    fiscal_year integer NOT NULL,
    wbse character varying(32),
    start_date date,
    end_date date,
    submitted timestamp without time zone,
    canceled timestamp without time zone,
    default_template integer,
    transmitted timestamp without time zone,
    archived timestamp without time zone,
    program_type integer DEFAULT 1 NOT NULL,
    system boolean DEFAULT false NOT NULL,
    ivr_code integer,
    scope_locked boolean DEFAULT false,
    entity_aipm integer,
    multiple_reset_dates_allowed boolean DEFAULT false,
    CONSTRAINT tb_program_default_template_check CHECK (
CASE
    WHEN (default_template IS NOT NULL) THEN (default_template < 0)
    ELSE true
END),
    CONSTRAINT tb_program_fiscal_year_check CHECK (((fiscal_year >= 2009) AND (fiscal_year <= 2050)))
);


ALTER TABLE public.tb_program OWNER TO postgres;

--
-- Name: tb_program_location; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_program_location (
    program_location integer DEFAULT nextval('sq_pk_program_location'::regclass) NOT NULL,
    program integer NOT NULL,
    location integer NOT NULL,
    execution_date date NOT NULL,
    labor_duration interval DEFAULT '00:00:00'::interval NOT NULL,
    reset_team integer,
    labor_days integer,
    prewalk_due_date date,
    prewalk_duration interval DEFAULT '00:00:00'::interval NOT NULL
);


ALTER TABLE public.tb_program_location OWNER TO postgres;

--
-- Name: tb_program_type; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_program_type (
    program_type integer DEFAULT nextval('sq_pk_program_type'::regclass) NOT NULL,
    name character varying(128) NOT NULL,
    default_template integer NOT NULL,
    article_number_prefix character(2),
    project_ui_config integer,
    allow_all_roles boolean DEFAULT true NOT NULL,
    allow_new_projects boolean DEFAULT true NOT NULL,
    require_execution_date boolean DEFAULT false NOT NULL,
    CONSTRAINT tb_program_type_default_template_check CHECK ((default_template < 0))
);


ALTER TABLE public.tb_program_type OWNER TO postgres;

--
-- Name: tb_project; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_project (
    project integer DEFAULT nextval('sq_pk_project'::regclass) NOT NULL,
    creator integer NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    modifier integer NOT NULL,
    modified timestamp without time zone DEFAULT now() NOT NULL,
    name character varying(256) NOT NULL,
    program integer,
    wbse character varying(32),
    sap_id integer,
    bay_count integer,
    description character varying(2058),
    electrical_required boolean,
    capital_thd numeric(11,2) DEFAULT 0,
    vendor_reimburse_thd numeric(11,2) DEFAULT 0,
    expense_thd numeric(11,2) DEFAULT 0,
    vendor_reimburse_3rd_party numeric(11,2) DEFAULT 0,
    start_date date,
    submitted timestamp without time zone,
    canceled timestamp without time zone,
    system boolean DEFAULT false NOT NULL,
    template integer,
    transmitted timestamp without time zone,
    archived timestamp without time zone,
    template_disabled boolean DEFAULT true NOT NULL,
    estimated_location_count integer,
    execution_begun timestamp without time zone,
    cba_approved boolean DEFAULT false NOT NULL,
    cba_file_path character varying(2048),
    cba_planned_store_count integer,
    cba_sales_per_store numeric(12,2),
    cba_target_sales_lift numeric(5,2),
    cba_net_preset_value numeric(12,2),
    cba_internal_rate_return numeric(7,2),
    cba_payback numeric(9,2),
    cba_discounted_payback numeric(9,2),
    cba_retail_inventory numeric(11,2),
    gross_margin_pre numeric(5,2),
    gross_margin_post numeric(5,2),
    charter_file_path character varying(2048),
    cba_project_name character varying(1024),
    earmark boolean DEFAULT false NOT NULL,
    strategic_initiative boolean DEFAULT false NOT NULL,
    held timestamp without time zone,
    holder integer,
    completed timestamp without time zone,
    completer integer,
    canceler integer,
    order_transmission_disabled timestamp without time zone,
    project_status integer DEFAULT 1 NOT NULL,
    reset_lift_reporting_start date,
    reset_lift_reporting_stop date,
    labor_team_type integer,
    in_epop boolean DEFAULT false NOT NULL,
    visual_rush boolean DEFAULT false NOT NULL,
    design_complexity integer,
    rollout_date date,
    article_sequence integer DEFAULT 1 NOT NULL,
    planogram_count integer,
    maximum_reset_requests integer,
    mst_ticket_number character varying(128),
    scope_locked boolean DEFAULT false,
    allow_bulk_order boolean DEFAULT true,
    signoff_appendix_file_name character varying(1024),
    signoff_appendix_file_path character varying(1024),
    project_type integer,
    extend_aisle_messaging boolean DEFAULT false,
    require_base_shelf boolean DEFAULT false,
    default_shelf_thickness integer,
    pallets_per_store integer,
    cost_per_pallet numeric(8,2),
    overhead_cost_per_store numeric(8,2),
    business_review integer,
    end_date date,
    expenditure_reason text,
    include_in_allocations_report boolean DEFAULT true NOT NULL,
    original_project integer,
    CONSTRAINT tb_project_capital_thd_check CHECK ((capital_thd >= (0)::numeric)),
    CONSTRAINT tb_project_capital_vendor_check CHECK ((vendor_reimburse_thd >= (0)::numeric)),
    CONSTRAINT tb_project_cba_discounted_payback_check CHECK ((cba_discounted_payback >= (0)::numeric)),
    CONSTRAINT tb_project_cba_payback_check CHECK ((cba_payback >= (0)::numeric)),
    CONSTRAINT tb_project_cba_planned_store_count_check CHECK ((cba_planned_store_count >= 0)),
    CONSTRAINT tb_project_cba_retail_inventory_check CHECK ((cba_retail_inventory >= (0)::numeric)),
    CONSTRAINT tb_project_cba_sales_per_store_check CHECK ((cba_sales_per_store >= (0)::numeric)),
    CONSTRAINT tb_project_cba_target_sales_lift_check CHECK ((cba_target_sales_lift >= (0)::numeric)),
    CONSTRAINT tb_project_cost_per_pallet_check CHECK ((cost_per_pallet > (0)::numeric)),
    CONSTRAINT tb_project_date_check CHECK ((((((rollout_date IS NOT NULL) AND (start_date IS NULL)) AND (system = false)) OR (((rollout_date IS NULL) AND (start_date IS NOT NULL)) AND (system = false))) OR (system = true))),
    CONSTRAINT tb_project_end_start_check CHECK (
CASE
    WHEN ((end_date IS NOT NULL) AND (rollout_date IS NOT NULL)) THEN (rollout_date < end_date)
    ELSE true
END),
    CONSTRAINT tb_project_estimated_store_count_check CHECK (((estimated_location_count IS NULL) OR (estimated_location_count > 0))),
    CONSTRAINT tb_project_expense_thd_check CHECK ((expense_thd >= (0)::numeric)),
    CONSTRAINT tb_project_expense_vendor_check CHECK ((vendor_reimburse_3rd_party >= (0)::numeric)),
    CONSTRAINT tb_project_gross_margin_pre_check CHECK ((gross_margin_pre >= (0)::numeric)),
    CONSTRAINT tb_project_maximum_reset_requests_check CHECK ((maximum_reset_requests > 0)),
    CONSTRAINT tb_project_overhead_cost_per_store_check CHECK ((overhead_cost_per_store > (0)::numeric)),
    CONSTRAINT tb_project_pallets_per_store_check CHECK ((pallets_per_store > 0)),
    CONSTRAINT tb_project_program_check CHECK (((project < 0) OR (program IS NOT NULL))),
    CONSTRAINT tb_project_template_check CHECK (((template IS NULL) OR (template < 0)))
);


ALTER TABLE public.tb_project OWNER TO postgres;

--
-- Name: tb_project_department; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_project_department (
    project_department integer DEFAULT nextval('sq_pk_project_department'::regclass) NOT NULL,
    project integer NOT NULL,
    department integer NOT NULL,
    project_rank integer,
    class integer
);


ALTER TABLE public.tb_project_department OWNER TO postgres;

--
-- Name: tb_project_participant; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_project_participant (
    project_participant integer DEFAULT nextval('sq_pk_project_participant'::regclass) NOT NULL,
    project integer NOT NULL,
    role integer NOT NULL,
    entity integer NOT NULL,
    role_rank integer,
    project_rank integer
);


ALTER TABLE public.tb_project_participant OWNER TO postgres;

--
-- Name: tb_project_status; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_project_status (
    project_status integer DEFAULT nextval('sq_pk_project_status'::regclass) NOT NULL,
    letters character varying(4),
    label character varying(16)
);


ALTER TABLE public.tb_project_status OWNER TO postgres;

--
-- Name: tb_region; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_region (
    region integer DEFAULT nextval('sq_pk_region'::regclass) NOT NULL,
    country integer NOT NULL,
    name character varying(128) NOT NULL,
    iso_two_letter character(2)
);


ALTER TABLE public.tb_region OWNER TO postgres;

--
-- Name: tb_reset; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_reset (
    reset integer DEFAULT nextval('sq_pk_reset'::regclass) NOT NULL,
    creator integer NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    modifier integer NOT NULL,
    modified timestamp without time zone DEFAULT now() NOT NULL,
    project integer NOT NULL,
    location integer NOT NULL,
    reset_team integer,
    execution_date date,
    program integer NOT NULL,
    wbse character varying(32),
    in_scope boolean DEFAULT true NOT NULL,
    bay_count integer,
    labor_duration interval,
    reset_status integer DEFAULT 1 NOT NULL,
    file_name character varying(2048),
    file_path character varying(2048),
    turned_red timestamp without time zone,
    turned_green timestamp without time zone,
    completed timestamp without time zone,
    planogram_url character varying(512),
    cet_wave_date date,
    transmitted timestamp without time zone,
    ext_comid character varying(64),
    labor_days integer,
    prewalk_due_date date,
    prewalk_duration interval DEFAULT '00:00:00'::interval NOT NULL,
    correct_material_on_order boolean,
    commodity_order_required boolean,
    correct_beam_count boolean,
    signoff_generated timestamp without time zone,
    signoff_generator integer,
    signoff_received timestamp without time zone,
    signoff_walk_date timestamp without time zone,
    reported_labor_duration interval,
    signoff_received_via_fax boolean,
    signoff_approver integer,
    signoff_approval_ip inet,
    signoff_rejected timestamp without time zone,
    signoff_rejector integer,
    signoff_rejection_ip inet,
    team_lead_name character varying(100),
    started timestamp without time zone,
    proof_of_concept boolean DEFAULT false NOT NULL,
    end_date date,
    archived timestamp without time zone,
    CONSTRAINT red_green_check CHECK (((((turned_red IS NULL) AND (turned_green IS NULL)) OR ((turned_red IS NOT NULL) AND (turned_green IS NULL))) OR ((turned_red IS NULL) AND (turned_green IS NOT NULL)))),
    CONSTRAINT tb_reset_bay_count_check CHECK ((bay_count > 0)),
    CONSTRAINT tb_reset_labor_duration_check CHECK (((labor_duration)::text > (0)::text))
);


ALTER TABLE public.tb_reset OWNER TO postgres;

--
-- Name: tb_reset_status; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_reset_status (
    reset_status integer DEFAULT nextval('sq_pk_reset_status'::regclass) NOT NULL,
    label character varying(64) NOT NULL,
    letters character varying(8) NOT NULL,
    color character varying(62) NOT NULL
);


ALTER TABLE public.tb_reset_status OWNER TO postgres;

--
-- Name: tb_reset_survey; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_reset_survey (
    reset_survey integer DEFAULT nextval('sq_pk_reset_survey'::regclass) NOT NULL,
    reset integer NOT NULL,
    survey integer NOT NULL,
    reset_survey_status integer NOT NULL,
    creator integer NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    submitter integer,
    submitted timestamp without time zone DEFAULT now(),
    reviewer integer,
    reviewed timestamp without time zone DEFAULT now(),
    rejected_reason character varying(2048),
    reset_survey_judgment_reason integer,
    started timestamp without time zone,
    starter integer,
    instructions_caused_issue boolean
);


ALTER TABLE public.tb_reset_survey OWNER TO postgres;

--
-- Name: tb_reset_team; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_reset_team (
    reset_team integer DEFAULT nextval('sq_pk_reset_team'::regclass) NOT NULL,
    number character varying(256) NOT NULL,
    labor_team_type integer NOT NULL,
    vendor integer NOT NULL
);


ALTER TABLE public.tb_reset_team OWNER TO postgres;

--
-- Name: tb_rollout_schedule; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_rollout_schedule (
    rollout_schedule integer DEFAULT nextval('sq_pk_rollout_schedule'::regclass) NOT NULL,
    program integer NOT NULL,
    rollout_week integer NOT NULL,
    fiscal_year integer NOT NULL,
    fiscal_week integer NOT NULL,
    CONSTRAINT tb_rollout_schedule_rollout_week_check CHECK ((rollout_week > 0))
);


ALTER TABLE public.tb_rollout_schedule OWNER TO postgres;

--
-- Name: tb_vendor; Type: TABLE; Schema: public; Owner: postgres; Tablespace: 
--

CREATE TABLE tb_vendor (
    vendor integer DEFAULT nextval('sq_pk_vendor'::regclass) NOT NULL,
    qb_inbound_order_mgt_rid integer,
    number character varying NOT NULL,
    name character varying(64) NOT NULL,
    address_line_one character varying(128),
    city character varying(256),
    region integer,
    zip_postal character varying(10),
    contact_name character varying(128),
    contact_phone character varying(32),
    contact_mobile character varying(32),
    contact_email_address character varying(128),
    vendor_status integer DEFAULT 1 NOT NULL,
    disabled timestamp without time zone,
    secondary_name character varying(64),
    contact_fax character varying(32),
    order_email_address character varying(128),
    prepaid boolean,
    CONSTRAINT tb_vendor_disabled_check CHECK ((((disabled IS NOT NULL) AND (vendor_status <> 1)) OR ((disabled IS NULL) AND (vendor_status = 1))))
);


ALTER TABLE public.tb_vendor OWNER TO postgres;

--
-- Name: sq_pk_buying_office; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_buying_office', 52, true);


--
-- Name: sq_pk_department; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_department', 24, true);


--
-- Name: sq_pk_district; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_district', 235, true);


--
-- Name: sq_pk_entity_reset; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_entity_reset', 3508, true);


--
-- Name: sq_pk_location; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_location', 93485, true);


--
-- Name: sq_pk_market; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_market', 249, true);


--
-- Name: sq_pk_mregion; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_mregion', 42, true);


--
-- Name: sq_pk_ogrp; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_ogrp', 451, true);


--
-- Name: sq_pk_order_location; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_order_location', 18499819, true);


--
-- Name: sq_pk_program; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_program', 380, true);


--
-- Name: sq_pk_program_location; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_program_location', 83057, true);


--
-- Name: sq_pk_program_type; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_program_type', 13, true);


--
-- Name: sq_pk_project; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_project', 11120, true);


--
-- Name: sq_pk_project_department; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_project_department', 11762, true);


--
-- Name: sq_pk_project_participant; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_project_participant', 44848, true);


--
-- Name: sq_pk_project_status; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_project_status', 5, true);


--
-- Name: sq_pk_region; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_region', 499, true);


--
-- Name: sq_pk_reset; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_reset', 2755272, true);


--
-- Name: sq_pk_reset_status; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_reset_status', 4, true);


--
-- Name: sq_pk_reset_survey; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_reset_survey', 60849, true);


--
-- Name: sq_pk_reset_team; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_reset_team', 612, true);


--
-- Name: sq_pk_rollout_schedule; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_rollout_schedule', 1485, true);


--
-- Name: sq_pk_vendor; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('sq_pk_vendor', 91463, true);


--
-- Data for Name: tb_buying_office; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_buying_office (buying_office, number, name, short_name, abbreviation) FROM stdin;
0	0	NO BUYING OFFICE	NO BYO	NBO
20	53	MEXICO	MEXICO	MEX
2	38	LOUISIANA	LOUISIANA	LOU
4	5	PACIFIC	PACIFIC	PAC
10	12	NORTHWEST	NORTHWEST	NW
1	1	SOUTHEAST	SOUTHEAST	S E
12	7	MIDWEST	MIDWEST	MID
3	11	SOUTHWEST	SOUTHWEST	SW
7	3	NORTHEAST	NORTHEAST	NE
11	42	GUAM	GUAM	GU
15	14	PUERTO RICO	PUERTORICO	PRC
18	31	CARIBBEAN	CARIBBEAN	CAR
8	33	ALASKA/HAWAII	AK/HI	AKH
\.


--
-- Data for Name: tb_department; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_department (department, number, name, parent, business_unit, deleted, email_address, surrogate_department) FROM stdin;
1	1	Automotive	\N	1	f	\N	\N
2	2	Infant	\N	1	f	\N	\N
3	3	Cosmetics	\N	1	f	\N	\N
4	4	Media	\N	1	f	\N	\N
5	5	Apparel	\N	1	f	\N	\N
6	6	Electronics	\N	1	f	\N	\N
7	7	Furniture	\N	1	f	\N	\N
8	8	Pharmacy	\N	1	f	\N	\N
9	9	Home Improvement	\N	1	f	\N	18
10	10	Housewares	\N	1	f	\N	\N
11	11	Jewelry	\N	1	f	\N	\N
12	12	Financial Services	\N	1	f	\N	\N
13	13	Office	\N	1	f	\N	\N
14	14	Pets	\N	1	f	\N	\N
15	15	Sporting Goods	\N	1	f	\N	\N
16	16	Toys	\N	1	f	\N	\N
17	17	Computers	\N	1	f	\N	\N
18	18	Snacks/ Impulse Items	\N	1	f	\N	\N
19	19	Paint	\N	1	f	\N	\N
20	20	Textiles	\N	1	f	\N	\N
21	21	Seasonal	\N	1	f	\N	\N
22	22	Party	\N	1	f	\N	\N
23	23	Grocery	\N	1	f	\N	\N
24	24	Gardening	\N	1	f	\N	\N
\.


--
-- Data for Name: tb_district; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_district (district, number, name, short_name, abbreviation) FROM stdin;
112	332	Roxanne Jast	Jast	Ja
116	247	Andy Johnson	Johnson	Jo
73	325	Bernhard D'Amore	D'Amore	D'
1	1	Rosie Kulas	Kulas	Ku
74	30	Carlotta Block	Block	Bl
8	235	Sasha Cummerata	Cummerata	Cu
28	232	Lenora Herman	Herman	He
113	190	Sophia Willms	Willms	Wi
75	26	Eleanore Erdman	Erdman	Er
106	148	Kenyatta Koepp	Koepp	Ko
107	35	Clementine DuBuque	DuBuque	Du
87	133	Ernestina Witting	Witting	Wi
89	14	Garry Jewess	Jewess	Je
61	25	Mariam Koepp	Koepp	Ko
25	115	Hobart Okuneva	Okuneva	Ok
79	327	Jodie Pollich	Pollich	Po
204	289	Norval Von	Von	Vo
153	262	Jerrell Christiansen	Christiansen	Ch
132	143	Wallace Sawayn	Sawayn	Sa
173	218	Alda Stanton	Stanton	St
194	117	Lelah Bogisich	Bogisich	Bo
200	314	Roman Hintz	Hintz	Hi
134	299	Hillary Johnston	Johnston	Jo
123	217	Tamia Cruickshank	Cruickshank	Cr
49	302	Ahmed Zulauf	Zulauf	Zu
187	116	Eldon Hirthe	Hirthe	Hi
82	73	Anissa Heaney	Heaney	He
165	123	Verla Hahn	Hahn	Ha
167	71	Melba Johnson	Johnson	Jo
166	17	Philip Harber	Harber	Ha
195	305	Immanuel Stokes	Stokes	St
151	175	Kristian Skiles	Skiles	Sk
183	150	Kali Stoltenberg	Stoltenberg	St
122	306	Queenie Bosco	Bosco	Bo
27	331	Eden Berge	Berge	Be
121	286	Hannah Collins	Collins	Co
78	21	Shana Jewess	Jewess	Je
210	318	Meggie Kulas	Kulas	Ku
110	36	Sandy Olson	Olson	Ol
71	51	Earnest Welch	Welch	We
80	23	Joannie Donnelly	Donnelly	Do
60	312	Juliet Rolfson	Rolfson	Ro
118	213	Katelin Kutch	Kutch	Ku
206	28	Chaya Keeling	Keeling	Ke
191	207	Lisa Hermiston	Hermiston	He
189	237	Alyson Reinger	Reinger	Re
67	209	Daphney Ferry	Ferry	Fe
86	319	Willie Hartmann	Hartmann	Ha
215	326	Mafalda Schroeder	Schroeder	Sc
3	261	Colten Reichert	Reichert	Re
72	172	Garret Schuppe	Schuppe	Sc
104	329	Jermain Okuneva	Okuneva	Ok
128	77	Moises Sawayn	Sawayn	Sa
109	82	Macy Kohler	Kohler	Ko
119	70	Chase Hand	Hand	Ha
117	146	Rosalee Kuphal	Kuphal	Ku
114	16	Concepcion Daugherty	Daugherty	Da
108	105	Chaim Nitzsche	Nitzsche	Ni
228	64	Amiya Koss	Koss	Ko
224	254	Carroll Johnston	Johnston	Jo
69	49	Rae Hermiston	Hermiston	He
77	199	Timmy Nitzsche	Nitzsche	Ni
140	257	Larry Little	Little	Li
43	292	Heaven O'Conner	O'Conner	O'
55	169	Colleen O'Kon	O'Kon	O'
57	90	Iva Ebert	Ebert	Eb
54	260	Nannie Terry	Terry	Te
51	137	Charlie Brown	Brown	Br
21	85	Luther Hane	Hane	Ha
50	307	Federico Herzog	Herzog	He
39	328	Enos Turner	Turner	Tu
95	293	Lon Ryan	Ryan	Ry
96	193	Marques Smitham	Smitham	Sm
97	276	Carmen Lowe	Lowe	Lo
141	98	Jairo Collins	Collins	Co
136	242	Adaline Pagac	Pagac	Pa
20	86	Wilfrid Carter	Carter	Ca
2	234	Anika Romaguera	Romaguera	Ro
34	130	Mikel Olson	Olson	Ol
15	165	Sandrine Swift	Swift	Sw
232	24	Eleazar Marks	Marks	Ma
6	87	Hudson Schoen	Schoen	Sc
142	48	Lamar Murazik	Murazik	Mu
230	303	Raymundo Eichmann	Eichmann	Ei
137	38	Wilber Rutherford	Rutherford	Ru
154	290	Kenya Crooks	Crooks	Cr
130	164	Kari Cartwright	Cartwright	Ca
131	284	Camille Schneider	Schneider	Sc
161	122	Maud Murphy	Murphy	Mu
218	251	Marilyne Hauck	Hauck	Ha
138	65	Leonor Predovic	Predovic	Pr
147	239	Luciano White	White	Wh
4	2	Lera Fay	Fay	Fa
222	19	Albert Wyman	Wyman	Wy
11	300	Jovany Harris	Harris	Ha
221	52	Giuseppe Hayes	Hayes	Ha
133	198	Flossie Runte	Runte	Ru
100	223	Fidel Macejkovic	Macejkovic	Ma
111	212	Leila Hickle	Hickle	Hi
103	136	Noemi Sanford	Sanford	Sa
76	20	Christy Ortiz	Ortiz	Or
64	67	Sonny Armstrong	Armstrong	Ar
68	295	Michale Goyette	Goyette	Go
66	171	Maximillia Casper	Casper	Ca
70	50	Meda Jaskolski	Jaskolski	Ja
65	62	Anais Witting	Witting	Wi
101	224	Maureen Veum	Veum	Ve
62	74	Rubye Stiedemann	Stiedemann	St
12	8	Marcella Weber	Weber	We
14	265	Lonny Reinger	Reinger	Re
59	47	Winona Heidenreich	Heidenreich	He
52	151	Jessica Sporer	Sporer	Sp
42	228	Karelle Lynch	Lynch	Ly
13	9	Doris Balistreri	Balistreri	Ba
38	60	Josefa Gorczany	Gorczany	Go
46	79	Jaquelin Willms	Willms	Wi
0	0	Aliyah Gaylord	Gaylord	Ga
9	301	Myrtle Stracke	Stracke	St
184	196	Odessa Douglas	Douglas	Do
208	57	Aaron Labadie	Labadie	La
120	285	Obie Stiedemann	Stiedemann	St
102	152	Alena Schroeder	Schroeder	Sc
157	227	Juliana Bahringer	Bahringer	Ba
227	32	Garrick Kertzmann	Kertzmann	Ke
63	174	Presley Senger	Senger	Se
5	88	Daisy Cummerata	Cummerata	Cu
58	7	Layla Brakus	Brakus	Br
40	92	Kennith Davis	Davis	Da
44	160	Raymond Kiehn	Kiehn	Ki
41	220	Morgan Schroeder	Schroeder	Sc
56	6	Stefan Wyman	Wyman	Wy
48	330	Alison Ledner	Ledner	Le
233	11	Wava Waelchi	Waelchi	Wa
23	96	Stanton Sporer	Sporer	Sp
31	282	Germaine Bahringer	Bahringer	Ba
19	128	Syble Weissnat	Weissnat	We
37	66	Molly Kunde	Kunde	Ku
17	84	Juliet Witting	Witting	Wi
22	12	Alvena Koelpin	Koelpin	Ko
53	37	Marty Kuhic	Kuhic	Ku
45	111	Natasha Koss	Koss	Ko
47	91	Juana Lehner	Lehner	Le
223	317	Cooper Murray	Murray	Mu
235	10	Andre Abshire	Abshire	Ab
234	5	Shanna Larkin	Larkin	La
143	112	Taurean Sawayn	Sawayn	Sa
26	83	Macie Herman	Herman	He
32	238	Antwan Ward	Ward	Wa
36	18	Julia Pouros	Pouros	Po
35	287	Lonny Erdman	Erdman	Er
29	4	Eugenia Collier	Collier	Co
85	102	Alayna Goodwin	Goodwin	Go
84	120	Verona Konopelski	Konopelski	Ko
83	338	Kennith Hoeger	Hoeger	Ho
88	78	Marley Yost	Yost	Yo
90	107	Gerda Gibson	Gibson	Gi
99	233	Silas McLaughlin	McLaughlin	Mc
98	138	Lorine Bartoletti	Bartoletti	Ba
92	15	Milo Shields	Shields	Sh
94	147	Natasha McKenzie	McKenzie	Mc
10	121	Laurie Schulist	Schulist	Sc
170	194	Richmond Towne	Towne	To
126	253	Lavon Oberbrunner	Oberbrunner	Ob
127	210	Oma O'Kon	O'Kon	O'
124	214	Doug Spinka	Spinka	Sp
125	166	Jamil Denesik	Denesik	De
201	219	Emelia Thiel	Thiel	Th
7	58	Libbie Dibbert	Dibbert	Di
139	145	Leatha Boehm	Boehm	Bo
152	259	Benton Sawayn	Sawayn	Sa
146	3	Laurence Parisian	Parisian	Pa
145	250	Elaina Bartoletti	Bartoletti	Ba
156	176	Kendra Watsica	Watsica	Wa
159	63	Shannon Paucek	Paucek	Pa
160	201	Elnora Beer	Beer	Be
158	27	Teagan Cremin	Cremin	Cr
149	288	Amalia Ruecker	Ruecker	Ru
179	184	Chloe Bechtelar	Bechtelar	Be
162	263	Shanon Adams	Adams	Ad
163	189	Ted Batz	Batz	Ba
164	316	Rafaela Stokes	Stokes	St
171	320	Turner Cole	Cole	Co
148	298	Kayley Cremin	Cremin	Cr
168	243	Jose Beer	Beer	Be
169	33	Mose Von	Von	Vo
174	244	Zakary Rippin	Rippin	Ri
175	275	Ivah Leuschke	Leuschke	Le
176	197	Brain Kuphal	Kuphal	Ku
144	179	Kevin Streich	Streich	St
30	132	Clint Breitenberg	Breitenberg	Br
33	93	Prince Lehner	Lehner	Le
182	80	Jamir Hane	Hane	Ha
185	255	Julius Considine	Considine	Co
186	106	Fabian Hane	Hane	Ha
188	264	Rod Bailey	Bailey	Ba
129	94	Kayla Smitham	Smitham	Sm
105	248	Granville Predovic	Predovic	Pr
190	31	Alyson Ondricka	Ondricka	On
192	323	Boyd Hirthe	Hirthe	Hi
181	61	Ross Smitham	Smitham	Sm
155	291	Beverly Grady	Grady	Gr
172	245	Angela Klocko	Klocko	Kl
199	187	Glenda Schaden	Schaden	Sc
198	141	Cornelius Windler	Windler	Wi
197	104	Torey Ullrich	Ullrich	Ul
202	216	Ransom Johnston	Johnston	Jo
213	75	Camren Becker	Becker	Be
93	277	Jana Frami	Frami	Fr
91	56	Kristofer Kassulke	Kassulke	Ka
211	153	Ansley Larkin	Larkin	La
196	177	Kitty Swift	Swift	Sw
212	170	Nella Connelly	Connelly	Co
207	188	Brennan Pfannerstill	Pfannerstill	Pf
209	95	Wilburn Romaguera	Romaguera	Ro
214	100	Kamille Daugherty	Daugherty	Da
150	226	Rozella Kuvalis	Kuvalis	Ku
216	53	Gunnar Prosacco	Prosacco	Pr
217	278	Velda Lubowitz	Lubowitz	Lu
177	195	Modesto Collier	Collier	Co
193	118	Estefania Hansen	Hansen	Ha
81	336	Brooks Robel	Robel	Ro
220	149	Brooks Macejkovic	Macejkovic	Ma
205	39	Arjun Corwin	Corwin	Co
203	274	Emilie Hermiston	Hermiston	He
180	267	Harry Batz	Batz	Ba
178	103	Rodrigo Parisian	Parisian	Pa
226	304	Kamille Kuhn	Kuhn	Ku
225	162	Dorcas Pouros	Pouros	Po
16	154	Burley Daniel	Daniel	Da
24	13	Maximillian Hayes	Hayes	Ha
18	266	Steve Runolfsdottir	Runolfsdottir	Ru
229	281	Katrine Morar	Morar	Mo
135	185	Cody Anderson	Anderson	An
115	294	Shakira Gorczany	Gorczany	Go
231	340	Rosemary Howell	Howell	Ho
219	34	Christine Schultz	Schultz	Sc
\.


--
-- Data for Name: tb_entity_reset; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_entity_reset (entity_reset, entity, reset, role) FROM stdin;
\.


--
-- Data for Name: tb_fiscal_calendar; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_fiscal_calendar (day, week, month, quarter, year, week_start, week_end, month_week) FROM stdin;
2024-10-25	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-26	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-27	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-28	40	10	3	2024	2024-10-28	2024-11-03	1
2024-10-29	40	10	3	2024	2024-10-28	2024-11-03	1
2024-10-30	40	10	3	2024	2024-10-28	2024-11-03	1
2024-10-31	40	10	3	2024	2024-10-28	2024-11-03	1
2024-11-01	40	10	3	2024	2024-10-28	2024-11-03	1
2024-11-02	40	10	3	2024	2024-10-28	2024-11-03	1
2024-11-03	40	10	3	2024	2024-10-28	2024-11-03	1
2024-11-04	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-05	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-06	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-07	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-08	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-09	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-10	41	10	3	2024	2024-11-04	2024-11-10	2
2024-11-11	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-12	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-13	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-14	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-15	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-16	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-17	42	10	3	2024	2024-11-11	2024-11-17	3
2024-11-18	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-19	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-20	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-21	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-22	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-23	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-24	43	10	3	2024	2024-11-18	2024-11-24	4
2024-11-25	44	11	3	2024	2024-11-25	2024-12-01	1
2024-11-26	44	11	3	2024	2024-11-25	2024-12-01	1
2024-11-27	44	11	3	2024	2024-11-25	2024-12-01	1
2024-11-28	44	11	3	2024	2024-11-25	2024-12-01	1
2024-11-29	44	11	3	2024	2024-11-25	2024-12-01	1
2024-11-30	44	11	3	2024	2024-11-25	2024-12-01	1
2024-12-01	44	11	3	2024	2024-11-25	2024-12-01	1
2024-12-02	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-03	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-04	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-05	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-06	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-07	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-08	45	11	3	2024	2024-12-02	2024-12-08	2
2024-12-09	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-10	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-11	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-12	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-13	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-14	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-15	46	11	3	2024	2024-12-09	2024-12-15	3
2024-12-16	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-17	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-18	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-19	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-20	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-21	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-22	47	11	3	2024	2024-12-16	2024-12-22	4
2024-12-23	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-24	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-25	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-26	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-27	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-28	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-29	48	12	4	2024	2024-12-23	2024-12-29	1
2024-12-30	49	12	4	2024	2024-12-30	2025-01-05	2
2024-12-31	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-01	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-02	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-03	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-04	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-05	49	12	4	2024	2024-12-30	2025-01-05	2
2025-01-06	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-07	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-08	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-09	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-10	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-11	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-12	50	12	4	2024	2025-01-06	2025-01-12	3
2025-01-13	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-14	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-15	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-16	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-17	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-18	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-19	51	12	4	2024	2025-01-13	2025-01-19	4
2025-01-20	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-21	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-22	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-23	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-24	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-25	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-26	52	12	4	2024	2025-01-20	2025-01-26	5
2025-01-27	53	12	4	2024	2025-01-27	2025-02-02	6
2025-01-28	53	12	4	2024	2025-01-27	2025-02-02	6
2025-01-29	53	12	4	2024	2025-01-27	2025-02-02	6
2025-01-30	53	12	4	2024	2025-01-27	2025-02-02	6
2025-01-31	53	12	4	2024	2025-01-27	2025-02-02	6
2025-02-01	53	12	4	2024	2025-01-27	2025-02-02	6
2025-02-02	53	12	4	2024	2025-01-27	2025-02-02	6
2024-06-11	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-12	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-13	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-14	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-15	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-16	20	5	2	2024	2024-06-10	2024-06-16	3
2024-06-17	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-18	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-19	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-20	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-21	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-22	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-23	21	5	2	2024	2024-06-17	2024-06-23	4
2024-06-24	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-25	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-26	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-27	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-28	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-29	22	6	2	2024	2024-06-24	2024-06-30	1
2024-06-30	22	6	2	2024	2024-06-24	2024-06-30	1
2024-07-01	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-02	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-03	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-04	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-05	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-06	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-07	23	6	2	2024	2024-07-01	2024-07-07	2
2024-07-08	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-09	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-10	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-11	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-12	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-13	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-14	24	6	2	2024	2024-07-08	2024-07-14	3
2024-07-15	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-16	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-17	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-18	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-19	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-20	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-21	25	6	2	2024	2024-07-15	2024-07-21	4
2024-07-22	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-23	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-24	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-25	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-26	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-27	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-28	26	6	2	2024	2024-07-22	2024-07-28	5
2024-07-29	27	7	2	2024	2024-07-29	2024-08-04	1
2024-07-30	27	7	2	2024	2024-07-29	2024-08-04	1
2024-07-31	27	7	2	2024	2024-07-29	2024-08-04	1
2024-08-01	27	7	2	2024	2024-07-29	2024-08-04	1
2024-08-02	27	7	2	2024	2024-07-29	2024-08-04	1
2024-08-03	27	7	2	2024	2024-07-29	2024-08-04	1
2024-08-04	27	7	2	2024	2024-07-29	2024-08-04	1
2024-08-05	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-06	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-07	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-08	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-09	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-10	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-11	28	7	2	2024	2024-08-05	2024-08-11	2
2024-08-12	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-13	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-14	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-15	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-16	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-17	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-18	29	7	2	2024	2024-08-12	2024-08-18	3
2024-08-19	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-20	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-21	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-22	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-23	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-24	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-25	30	7	2	2024	2024-08-19	2024-08-25	4
2024-08-26	31	8	3	2024	2024-08-26	2024-09-01	1
2024-08-27	31	8	3	2024	2024-08-26	2024-09-01	1
2024-08-28	31	8	3	2024	2024-08-26	2024-09-01	1
2024-08-29	31	8	3	2024	2024-08-26	2024-09-01	1
2024-08-30	31	8	3	2024	2024-08-26	2024-09-01	1
2024-08-31	31	8	3	2024	2024-08-26	2024-09-01	1
2024-09-01	31	8	3	2024	2024-08-26	2024-09-01	1
2024-09-02	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-03	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-04	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-05	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-06	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-07	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-08	32	8	3	2024	2024-09-02	2024-09-08	2
2024-09-09	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-10	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-11	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-12	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-13	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-14	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-15	33	8	3	2024	2024-09-09	2024-09-15	3
2024-09-16	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-17	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-18	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-19	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-20	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-21	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-22	34	8	3	2024	2024-09-16	2024-09-22	4
2024-09-23	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-24	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-25	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-26	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-27	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-28	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-29	35	9	3	2024	2024-09-23	2024-09-29	1
2024-09-30	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-01	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-02	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-03	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-04	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-05	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-06	36	9	3	2024	2024-09-30	2024-10-06	2
2024-10-07	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-08	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-09	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-10	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-11	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-12	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-13	37	9	3	2024	2024-10-07	2024-10-13	3
2024-10-14	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-15	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-16	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-17	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-18	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-19	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-20	38	9	3	2024	2024-10-14	2024-10-20	4
2024-10-21	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-22	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-23	39	9	3	2024	2024-10-21	2024-10-27	5
2024-10-24	39	9	3	2024	2024-10-21	2024-10-27	5
2024-01-27	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-28	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-29	1	1	1	2024	2024-01-29	2024-02-04	1
2024-01-30	1	1	1	2024	2024-01-29	2024-02-04	1
2024-01-31	1	1	1	2024	2024-01-29	2024-02-04	1
2024-02-01	1	1	1	2024	2024-01-29	2024-02-04	1
2024-02-02	1	1	1	2024	2024-01-29	2024-02-04	1
2024-02-03	1	1	1	2024	2024-01-29	2024-02-04	1
2024-02-04	1	1	1	2024	2024-01-29	2024-02-04	1
2024-02-05	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-06	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-07	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-08	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-09	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-10	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-11	2	1	1	2024	2024-02-05	2024-02-11	2
2024-02-12	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-13	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-14	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-15	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-16	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-17	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-18	3	1	1	2024	2024-02-12	2024-02-18	3
2024-02-19	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-20	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-21	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-22	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-23	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-24	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-25	4	1	1	2024	2024-02-19	2024-02-25	4
2024-02-26	5	2	1	2024	2024-02-26	2024-03-03	1
2024-02-27	5	2	1	2024	2024-02-26	2024-03-03	1
2024-02-28	5	2	1	2024	2024-02-26	2024-03-03	1
2024-02-29	5	2	1	2024	2024-02-26	2024-03-03	1
2024-03-01	5	2	1	2024	2024-02-26	2024-03-03	1
2024-03-02	5	2	1	2024	2024-02-26	2024-03-03	1
2024-03-03	5	2	1	2024	2024-02-26	2024-03-03	1
2024-03-04	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-05	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-06	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-07	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-08	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-09	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-10	6	2	1	2024	2024-03-04	2024-03-10	2
2024-03-11	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-12	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-13	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-14	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-15	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-16	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-17	7	2	1	2024	2024-03-11	2024-03-17	3
2024-03-18	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-19	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-20	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-21	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-22	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-23	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-24	8	2	1	2024	2024-03-18	2024-03-24	4
2024-03-25	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-26	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-27	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-28	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-29	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-30	9	3	1	2024	2024-03-25	2024-03-31	1
2024-03-31	9	3	1	2024	2024-03-25	2024-03-31	1
2024-04-01	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-02	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-03	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-04	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-05	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-06	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-07	10	3	1	2024	2024-04-01	2024-04-07	2
2024-04-08	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-09	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-10	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-11	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-12	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-13	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-14	11	3	1	2024	2024-04-08	2024-04-14	3
2024-04-15	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-16	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-17	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-18	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-19	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-20	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-21	12	3	1	2024	2024-04-15	2024-04-21	4
2024-04-22	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-23	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-24	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-25	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-26	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-27	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-28	13	3	1	2024	2024-04-22	2024-04-28	5
2024-04-29	14	4	2	2024	2024-04-29	2024-05-05	1
2024-04-30	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-01	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-02	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-03	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-04	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-05	14	4	2	2024	2024-04-29	2024-05-05	1
2024-05-06	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-07	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-08	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-09	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-10	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-11	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-12	15	4	2	2024	2024-05-06	2024-05-12	2
2024-05-13	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-14	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-15	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-16	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-17	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-18	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-19	16	4	2	2024	2024-05-13	2024-05-19	3
2024-05-20	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-21	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-22	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-23	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-24	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-25	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-26	17	4	2	2024	2024-05-20	2024-05-26	4
2024-05-27	18	5	2	2024	2024-05-27	2024-06-02	1
2024-05-28	18	5	2	2024	2024-05-27	2024-06-02	1
2024-05-29	18	5	2	2024	2024-05-27	2024-06-02	1
2024-05-30	18	5	2	2024	2024-05-27	2024-06-02	1
2024-05-31	18	5	2	2024	2024-05-27	2024-06-02	1
2024-06-01	18	5	2	2024	2024-05-27	2024-06-02	1
2024-06-02	18	5	2	2024	2024-05-27	2024-06-02	1
2024-06-03	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-04	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-05	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-06	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-07	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-08	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-09	19	5	2	2024	2024-06-03	2024-06-09	2
2024-06-10	20	5	2	2024	2024-06-10	2024-06-16	3
2023-09-13	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-14	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-15	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-16	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-17	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-18	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-19	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-20	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-21	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-22	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-23	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-24	34	8	3	2023	2023-09-18	2023-09-24	4
2023-09-25	35	9	3	2023	2023-09-25	2023-10-01	1
2023-09-26	35	9	3	2023	2023-09-25	2023-10-01	1
2023-09-27	35	9	3	2023	2023-09-25	2023-10-01	1
2023-09-28	35	9	3	2023	2023-09-25	2023-10-01	1
2023-09-29	35	9	3	2023	2023-09-25	2023-10-01	1
2023-09-30	35	9	3	2023	2023-09-25	2023-10-01	1
2023-10-01	35	9	3	2023	2023-09-25	2023-10-01	1
2023-10-02	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-03	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-04	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-05	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-06	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-07	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-08	36	9	3	2023	2023-10-02	2023-10-08	2
2023-10-09	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-10	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-11	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-12	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-13	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-14	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-15	37	9	3	2023	2023-10-09	2023-10-15	3
2023-10-16	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-17	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-18	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-19	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-20	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-21	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-22	38	9	3	2023	2023-10-16	2023-10-22	4
2023-10-23	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-24	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-25	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-26	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-27	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-28	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-29	39	9	3	2023	2023-10-23	2023-10-29	5
2023-10-30	40	10	3	2023	2023-10-30	2023-11-05	1
2023-10-31	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-01	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-02	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-03	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-04	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-05	40	10	3	2023	2023-10-30	2023-11-05	1
2023-11-06	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-07	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-08	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-09	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-10	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-11	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-12	41	10	3	2023	2023-11-06	2023-11-12	2
2023-11-13	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-14	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-15	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-16	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-17	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-18	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-19	42	10	3	2023	2023-11-13	2023-11-19	3
2023-11-20	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-21	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-22	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-23	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-24	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-25	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-26	43	10	3	2023	2023-11-20	2023-11-26	4
2023-11-27	44	11	3	2023	2023-11-27	2023-12-03	1
2023-11-28	44	11	3	2023	2023-11-27	2023-12-03	1
2023-11-29	44	11	3	2023	2023-11-27	2023-12-03	1
2023-11-30	44	11	3	2023	2023-11-27	2023-12-03	1
2023-12-01	44	11	3	2023	2023-11-27	2023-12-03	1
2023-12-02	44	11	3	2023	2023-11-27	2023-12-03	1
2023-12-03	44	11	3	2023	2023-11-27	2023-12-03	1
2023-12-04	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-05	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-06	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-07	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-08	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-09	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-10	45	11	3	2023	2023-12-04	2023-12-10	2
2023-12-11	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-12	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-13	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-14	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-15	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-16	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-17	46	11	3	2023	2023-12-11	2023-12-17	3
2023-12-18	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-19	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-20	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-21	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-22	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-23	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-24	47	11	3	2023	2023-12-18	2023-12-24	4
2023-12-25	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-26	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-27	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-28	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-29	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-30	48	12	4	2023	2023-12-25	2023-12-31	1
2023-12-31	48	12	4	2023	2023-12-25	2023-12-31	1
2024-01-01	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-02	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-03	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-04	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-05	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-06	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-07	49	12	4	2023	2024-01-01	2024-01-07	2
2024-01-08	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-09	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-10	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-11	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-12	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-13	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-14	50	12	4	2023	2024-01-08	2024-01-14	3
2024-01-15	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-16	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-17	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-18	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-19	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-20	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-21	51	12	4	2023	2024-01-15	2024-01-21	4
2024-01-22	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-23	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-24	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-25	52	12	4	2023	2024-01-22	2024-01-28	5
2024-01-26	52	12	4	2023	2024-01-22	2024-01-28	5
2023-04-30	13	3	1	2023	2023-04-24	2023-04-30	5
2023-05-01	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-02	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-03	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-04	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-05	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-06	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-07	14	4	2	2023	2023-05-01	2023-05-07	1
2023-05-08	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-09	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-10	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-11	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-12	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-13	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-14	15	4	2	2023	2023-05-08	2023-05-14	2
2023-05-15	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-16	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-17	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-18	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-19	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-20	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-21	16	4	2	2023	2023-05-15	2023-05-21	3
2023-05-22	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-23	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-24	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-25	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-26	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-27	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-28	17	4	2	2023	2023-05-22	2023-05-28	4
2023-05-29	18	5	2	2023	2023-05-29	2023-06-04	1
2023-05-30	18	5	2	2023	2023-05-29	2023-06-04	1
2023-05-31	18	5	2	2023	2023-05-29	2023-06-04	1
2023-06-01	18	5	2	2023	2023-05-29	2023-06-04	1
2023-06-02	18	5	2	2023	2023-05-29	2023-06-04	1
2023-06-03	18	5	2	2023	2023-05-29	2023-06-04	1
2023-06-04	18	5	2	2023	2023-05-29	2023-06-04	1
2023-06-05	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-06	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-07	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-08	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-09	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-10	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-11	19	5	2	2023	2023-06-05	2023-06-11	2
2023-06-12	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-13	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-14	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-15	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-16	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-17	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-18	20	5	2	2023	2023-06-12	2023-06-18	3
2023-06-19	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-20	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-21	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-22	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-23	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-24	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-25	21	5	2	2023	2023-06-19	2023-06-25	4
2023-06-26	22	6	2	2023	2023-06-26	2023-07-02	1
2023-06-27	22	6	2	2023	2023-06-26	2023-07-02	1
2023-06-28	22	6	2	2023	2023-06-26	2023-07-02	1
2023-06-29	22	6	2	2023	2023-06-26	2023-07-02	1
2023-06-30	22	6	2	2023	2023-06-26	2023-07-02	1
2023-07-01	22	6	2	2023	2023-06-26	2023-07-02	1
2023-07-02	22	6	2	2023	2023-06-26	2023-07-02	1
2023-07-03	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-04	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-05	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-06	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-07	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-08	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-09	23	6	2	2023	2023-07-03	2023-07-09	2
2023-07-10	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-11	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-12	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-13	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-14	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-15	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-16	24	6	2	2023	2023-07-10	2023-07-16	3
2023-07-17	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-18	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-19	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-20	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-21	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-22	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-23	25	6	2	2023	2023-07-17	2023-07-23	4
2023-07-24	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-25	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-26	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-27	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-28	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-29	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-30	26	6	2	2023	2023-07-24	2023-07-30	5
2023-07-31	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-01	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-02	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-03	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-04	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-05	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-06	27	7	2	2023	2023-07-31	2023-08-06	1
2023-08-07	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-08	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-09	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-10	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-11	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-12	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-13	28	7	2	2023	2023-08-07	2023-08-13	2
2023-08-14	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-15	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-16	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-17	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-18	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-19	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-20	29	7	2	2023	2023-08-14	2023-08-20	3
2023-08-21	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-22	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-23	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-24	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-25	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-26	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-27	30	7	2	2023	2023-08-21	2023-08-27	4
2023-08-28	31	8	3	2023	2023-08-28	2023-09-03	1
2023-08-29	31	8	3	2023	2023-08-28	2023-09-03	1
2023-08-30	31	8	3	2023	2023-08-28	2023-09-03	1
2023-08-31	31	8	3	2023	2023-08-28	2023-09-03	1
2023-09-01	31	8	3	2023	2023-08-28	2023-09-03	1
2023-09-02	31	8	3	2023	2023-08-28	2023-09-03	1
2023-09-03	31	8	3	2023	2023-08-28	2023-09-03	1
2023-09-04	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-05	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-06	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-07	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-08	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-09	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-10	32	8	3	2023	2023-09-04	2023-09-10	2
2023-09-11	33	8	3	2023	2023-09-11	2023-09-17	3
2023-09-12	33	8	3	2023	2023-09-11	2023-09-17	3
2022-12-15	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-16	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-17	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-18	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-19	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-20	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-21	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-22	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-23	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-24	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-25	47	11	3	2022	2022-12-19	2022-12-25	4
2022-12-26	48	12	4	2022	2022-12-26	2023-01-01	1
2022-12-27	48	12	4	2022	2022-12-26	2023-01-01	1
2022-12-28	48	12	4	2022	2022-12-26	2023-01-01	1
2022-12-29	48	12	4	2022	2022-12-26	2023-01-01	1
2022-12-30	48	12	4	2022	2022-12-26	2023-01-01	1
2022-12-31	48	12	4	2022	2022-12-26	2023-01-01	1
2023-01-01	48	12	4	2022	2022-12-26	2023-01-01	1
2023-01-02	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-03	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-04	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-05	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-06	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-07	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-08	49	12	4	2022	2023-01-02	2023-01-08	2
2023-01-09	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-10	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-11	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-12	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-13	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-14	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-15	50	12	4	2022	2023-01-09	2023-01-15	3
2023-01-16	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-17	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-18	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-19	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-20	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-21	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-22	51	12	4	2022	2023-01-16	2023-01-22	4
2023-01-23	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-24	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-25	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-26	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-27	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-28	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-29	52	12	4	2022	2023-01-23	2023-01-29	5
2023-01-30	1	1	1	2023	2023-01-30	2023-02-05	1
2023-01-31	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-01	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-02	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-03	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-04	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-05	1	1	1	2023	2023-01-30	2023-02-05	1
2023-02-06	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-07	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-08	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-09	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-10	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-11	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-12	2	1	1	2023	2023-02-06	2023-02-12	2
2023-02-13	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-14	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-15	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-16	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-17	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-18	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-19	3	1	1	2023	2023-02-13	2023-02-19	3
2023-02-20	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-21	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-22	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-23	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-24	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-25	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-26	4	1	1	2023	2023-02-20	2023-02-26	4
2023-02-27	5	2	1	2023	2023-02-27	2023-03-05	1
2023-02-28	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-01	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-02	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-03	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-04	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-05	5	2	1	2023	2023-02-27	2023-03-05	1
2023-03-06	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-07	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-08	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-09	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-10	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-11	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-12	6	2	1	2023	2023-03-06	2023-03-12	2
2023-03-13	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-14	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-15	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-16	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-17	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-18	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-19	7	2	1	2023	2023-03-13	2023-03-19	3
2023-03-20	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-21	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-22	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-23	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-24	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-25	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-26	8	2	1	2023	2023-03-20	2023-03-26	4
2023-03-27	9	3	1	2023	2023-03-27	2023-04-02	1
2023-03-28	9	3	1	2023	2023-03-27	2023-04-02	1
2023-03-29	9	3	1	2023	2023-03-27	2023-04-02	1
2023-03-30	9	3	1	2023	2023-03-27	2023-04-02	1
2023-03-31	9	3	1	2023	2023-03-27	2023-04-02	1
2023-04-01	9	3	1	2023	2023-03-27	2023-04-02	1
2023-04-02	9	3	1	2023	2023-03-27	2023-04-02	1
2023-04-03	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-04	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-05	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-06	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-07	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-08	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-09	10	3	1	2023	2023-04-03	2023-04-09	2
2023-04-10	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-11	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-12	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-13	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-14	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-15	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-16	11	3	1	2023	2023-04-10	2023-04-16	3
2023-04-17	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-18	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-19	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-20	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-21	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-22	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-23	12	3	1	2023	2023-04-17	2023-04-23	4
2023-04-24	13	3	1	2023	2023-04-24	2023-04-30	5
2023-04-25	13	3	1	2023	2023-04-24	2023-04-30	5
2023-04-26	13	3	1	2023	2023-04-24	2023-04-30	5
2023-04-27	13	3	1	2023	2023-04-24	2023-04-30	5
2023-04-28	13	3	1	2023	2023-04-24	2023-04-30	5
2023-04-29	13	3	1	2023	2023-04-24	2023-04-30	5
2022-08-01	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-02	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-03	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-04	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-05	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-06	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-07	27	7	2	2022	2022-08-01	2022-08-07	1
2022-08-08	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-09	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-10	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-11	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-12	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-13	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-14	28	7	2	2022	2022-08-08	2022-08-14	2
2022-08-15	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-16	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-17	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-18	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-19	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-20	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-21	29	7	2	2022	2022-08-15	2022-08-21	3
2022-08-22	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-23	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-24	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-25	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-26	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-27	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-28	30	7	2	2022	2022-08-22	2022-08-28	4
2022-08-29	31	8	3	2022	2022-08-29	2022-09-04	1
2022-08-30	31	8	3	2022	2022-08-29	2022-09-04	1
2022-08-31	31	8	3	2022	2022-08-29	2022-09-04	1
2022-09-01	31	8	3	2022	2022-08-29	2022-09-04	1
2022-09-02	31	8	3	2022	2022-08-29	2022-09-04	1
2022-09-03	31	8	3	2022	2022-08-29	2022-09-04	1
2022-09-04	31	8	3	2022	2022-08-29	2022-09-04	1
2022-09-05	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-06	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-07	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-08	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-09	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-10	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-11	32	8	3	2022	2022-09-05	2022-09-11	2
2022-09-12	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-13	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-14	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-15	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-16	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-17	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-18	33	8	3	2022	2022-09-12	2022-09-18	3
2022-09-19	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-20	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-21	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-22	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-23	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-24	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-25	34	8	3	2022	2022-09-19	2022-09-25	4
2022-09-26	35	9	3	2022	2022-09-26	2022-10-02	1
2022-09-27	35	9	3	2022	2022-09-26	2022-10-02	1
2022-09-28	35	9	3	2022	2022-09-26	2022-10-02	1
2022-09-29	35	9	3	2022	2022-09-26	2022-10-02	1
2022-09-30	35	9	3	2022	2022-09-26	2022-10-02	1
2022-10-01	35	9	3	2022	2022-09-26	2022-10-02	1
2022-10-02	35	9	3	2022	2022-09-26	2022-10-02	1
2022-10-03	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-04	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-05	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-06	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-07	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-08	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-09	36	9	3	2022	2022-10-03	2022-10-09	2
2022-10-10	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-11	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-12	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-13	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-14	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-15	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-16	37	9	3	2022	2022-10-10	2022-10-16	3
2022-10-17	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-18	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-19	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-20	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-21	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-22	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-23	38	9	3	2022	2022-10-17	2022-10-23	4
2022-10-24	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-25	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-26	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-27	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-28	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-29	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-30	39	9	3	2022	2022-10-24	2022-10-30	5
2022-10-31	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-01	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-02	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-03	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-04	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-05	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-06	40	10	3	2022	2022-10-31	2022-11-06	1
2022-11-07	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-08	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-09	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-10	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-11	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-12	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-13	41	10	3	2022	2022-11-07	2022-11-13	2
2022-11-14	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-15	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-16	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-17	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-18	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-19	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-20	42	10	3	2022	2022-11-14	2022-11-20	3
2022-11-21	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-22	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-23	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-24	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-25	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-26	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-27	43	10	3	2022	2022-11-21	2022-11-27	4
2022-11-28	44	11	3	2022	2022-11-28	2022-12-04	1
2022-11-29	44	11	3	2022	2022-11-28	2022-12-04	1
2022-11-30	44	11	3	2022	2022-11-28	2022-12-04	1
2022-12-01	44	11	3	2022	2022-11-28	2022-12-04	1
2022-12-02	44	11	3	2022	2022-11-28	2022-12-04	1
2022-12-03	44	11	3	2022	2022-11-28	2022-12-04	1
2022-12-04	44	11	3	2022	2022-11-28	2022-12-04	1
2022-12-05	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-06	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-07	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-08	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-09	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-10	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-11	45	11	3	2022	2022-12-05	2022-12-11	2
2022-12-12	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-13	46	11	3	2022	2022-12-12	2022-12-18	3
2022-12-14	46	11	3	2022	2022-12-12	2022-12-18	3
2022-03-18	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-19	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-20	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-21	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-22	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-23	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-24	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-25	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-26	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-27	8	2	1	2022	2022-03-21	2022-03-27	4
2022-03-28	9	3	1	2022	2022-03-28	2022-04-03	1
2022-03-29	9	3	1	2022	2022-03-28	2022-04-03	1
2022-03-30	9	3	1	2022	2022-03-28	2022-04-03	1
2022-03-31	9	3	1	2022	2022-03-28	2022-04-03	1
2022-04-01	9	3	1	2022	2022-03-28	2022-04-03	1
2022-04-02	9	3	1	2022	2022-03-28	2022-04-03	1
2022-04-03	9	3	1	2022	2022-03-28	2022-04-03	1
2022-04-04	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-05	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-06	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-07	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-08	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-09	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-10	10	3	1	2022	2022-04-04	2022-04-10	2
2022-04-11	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-12	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-13	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-14	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-15	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-16	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-17	11	3	1	2022	2022-04-11	2022-04-17	3
2022-04-18	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-19	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-20	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-21	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-22	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-23	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-24	12	3	1	2022	2022-04-18	2022-04-24	4
2022-04-25	13	3	1	2022	2022-04-25	2022-05-01	5
2022-04-26	13	3	1	2022	2022-04-25	2022-05-01	5
2022-04-27	13	3	1	2022	2022-04-25	2022-05-01	5
2022-04-28	13	3	1	2022	2022-04-25	2022-05-01	5
2022-04-29	13	3	1	2022	2022-04-25	2022-05-01	5
2022-04-30	13	3	1	2022	2022-04-25	2022-05-01	5
2022-05-01	13	3	1	2022	2022-04-25	2022-05-01	5
2022-05-02	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-03	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-04	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-05	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-06	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-07	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-08	14	4	2	2022	2022-05-02	2022-05-08	1
2022-05-09	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-10	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-11	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-12	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-13	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-14	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-15	15	4	2	2022	2022-05-09	2022-05-15	2
2022-05-16	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-17	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-18	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-19	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-20	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-21	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-22	16	4	2	2022	2022-05-16	2022-05-22	3
2022-05-23	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-24	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-25	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-26	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-27	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-28	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-29	17	4	2	2022	2022-05-23	2022-05-29	4
2022-05-30	18	5	2	2022	2022-05-30	2022-06-05	1
2022-05-31	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-01	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-02	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-03	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-04	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-05	18	5	2	2022	2022-05-30	2022-06-05	1
2022-06-06	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-07	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-08	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-09	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-10	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-11	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-12	19	5	2	2022	2022-06-06	2022-06-12	2
2022-06-13	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-14	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-15	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-16	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-17	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-18	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-19	20	5	2	2022	2022-06-13	2022-06-19	3
2022-06-20	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-21	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-22	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-23	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-24	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-25	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-26	21	5	2	2022	2022-06-20	2022-06-26	4
2022-06-27	22	6	2	2022	2022-06-27	2022-07-03	1
2022-06-28	22	6	2	2022	2022-06-27	2022-07-03	1
2022-06-29	22	6	2	2022	2022-06-27	2022-07-03	1
2022-06-30	22	6	2	2022	2022-06-27	2022-07-03	1
2022-07-01	22	6	2	2022	2022-06-27	2022-07-03	1
2022-07-02	22	6	2	2022	2022-06-27	2022-07-03	1
2022-07-03	22	6	2	2022	2022-06-27	2022-07-03	1
2022-07-04	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-05	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-06	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-07	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-08	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-09	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-10	23	6	2	2022	2022-07-04	2022-07-10	2
2022-07-11	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-12	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-13	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-14	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-15	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-16	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-17	24	6	2	2022	2022-07-11	2022-07-17	3
2022-07-18	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-19	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-20	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-21	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-22	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-23	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-24	25	6	2	2022	2022-07-18	2022-07-24	4
2022-07-25	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-26	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-27	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-28	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-29	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-30	26	6	2	2022	2022-07-25	2022-07-31	5
2022-07-31	26	6	2	2022	2022-07-25	2022-07-31	5
2021-11-02	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-03	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-04	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-05	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-06	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-07	40	10	3	2021	2021-11-01	2021-11-07	1
2021-11-08	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-09	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-10	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-11	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-12	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-13	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-14	41	10	3	2021	2021-11-08	2021-11-14	2
2021-11-15	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-16	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-17	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-18	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-19	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-20	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-21	42	10	3	2021	2021-11-15	2021-11-21	3
2021-11-22	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-23	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-24	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-25	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-26	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-27	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-28	43	10	3	2021	2021-11-22	2021-11-28	4
2021-11-29	44	11	3	2021	2021-11-29	2021-12-05	1
2021-11-30	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-01	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-02	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-03	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-04	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-05	44	11	3	2021	2021-11-29	2021-12-05	1
2021-12-06	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-07	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-08	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-09	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-10	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-11	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-12	45	11	3	2021	2021-12-06	2021-12-12	2
2021-12-13	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-14	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-15	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-16	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-17	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-18	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-19	46	11	3	2021	2021-12-13	2021-12-19	3
2021-12-20	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-21	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-22	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-23	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-24	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-25	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-26	47	11	3	2021	2021-12-20	2021-12-26	4
2021-12-27	48	12	4	2021	2021-12-27	2022-01-02	1
2021-12-28	48	12	4	2021	2021-12-27	2022-01-02	1
2021-12-29	48	12	4	2021	2021-12-27	2022-01-02	1
2021-12-30	48	12	4	2021	2021-12-27	2022-01-02	1
2021-12-31	48	12	4	2021	2021-12-27	2022-01-02	1
2022-01-01	48	12	4	2021	2021-12-27	2022-01-02	1
2022-01-02	48	12	4	2021	2021-12-27	2022-01-02	1
2022-01-03	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-04	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-05	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-06	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-07	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-08	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-09	49	12	4	2021	2022-01-03	2022-01-09	2
2022-01-10	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-11	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-12	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-13	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-14	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-15	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-16	50	12	4	2021	2022-01-10	2022-01-16	3
2022-01-17	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-18	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-19	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-20	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-21	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-22	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-23	51	12	4	2021	2022-01-17	2022-01-23	4
2022-01-24	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-25	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-26	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-27	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-28	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-29	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-30	52	12	4	2021	2022-01-24	2022-01-30	5
2022-01-31	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-01	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-02	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-03	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-04	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-05	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-06	1	1	1	2022	2022-01-31	2022-02-06	1
2022-02-07	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-08	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-09	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-10	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-11	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-12	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-13	2	1	1	2022	2022-02-07	2022-02-13	2
2022-02-14	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-15	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-16	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-17	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-18	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-19	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-20	3	1	1	2022	2022-02-14	2022-02-20	3
2022-02-21	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-22	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-23	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-24	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-25	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-26	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-27	4	1	1	2022	2022-02-21	2022-02-27	4
2022-02-28	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-01	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-02	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-03	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-04	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-05	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-06	5	2	1	2022	2022-02-28	2022-03-06	1
2022-03-07	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-08	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-09	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-10	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-11	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-12	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-13	6	2	1	2022	2022-03-07	2022-03-13	2
2022-03-14	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-15	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-16	7	2	1	2022	2022-03-14	2022-03-20	3
2022-03-17	7	2	1	2022	2022-03-14	2022-03-20	3
2021-06-19	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-20	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-21	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-22	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-23	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-24	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-25	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-26	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-27	21	5	2	2021	2021-06-21	2021-06-27	4
2021-06-28	22	6	2	2021	2021-06-28	2021-07-04	1
2021-06-29	22	6	2	2021	2021-06-28	2021-07-04	1
2021-06-30	22	6	2	2021	2021-06-28	2021-07-04	1
2021-07-01	22	6	2	2021	2021-06-28	2021-07-04	1
2021-07-02	22	6	2	2021	2021-06-28	2021-07-04	1
2021-07-03	22	6	2	2021	2021-06-28	2021-07-04	1
2021-07-04	22	6	2	2021	2021-06-28	2021-07-04	1
2021-07-05	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-06	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-07	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-08	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-09	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-10	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-11	23	6	2	2021	2021-07-05	2021-07-11	2
2021-07-12	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-13	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-14	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-15	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-16	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-17	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-18	24	6	2	2021	2021-07-12	2021-07-18	3
2021-07-19	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-20	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-21	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-22	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-23	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-24	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-25	25	6	2	2021	2021-07-19	2021-07-25	4
2021-07-26	26	6	2	2021	2021-07-26	2021-08-01	5
2021-07-27	26	6	2	2021	2021-07-26	2021-08-01	5
2021-07-28	26	6	2	2021	2021-07-26	2021-08-01	5
2021-07-29	26	6	2	2021	2021-07-26	2021-08-01	5
2021-07-30	26	6	2	2021	2021-07-26	2021-08-01	5
2021-07-31	26	6	2	2021	2021-07-26	2021-08-01	5
2021-08-01	26	6	2	2021	2021-07-26	2021-08-01	5
2021-08-02	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-03	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-04	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-05	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-06	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-07	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-08	27	7	2	2021	2021-08-02	2021-08-08	1
2021-08-09	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-10	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-11	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-12	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-13	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-14	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-15	28	7	2	2021	2021-08-09	2021-08-15	2
2021-08-16	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-17	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-18	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-19	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-20	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-21	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-22	29	7	2	2021	2021-08-16	2021-08-22	3
2021-08-23	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-24	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-25	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-26	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-27	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-28	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-29	30	7	2	2021	2021-08-23	2021-08-29	4
2021-08-30	31	8	3	2021	2021-08-30	2021-09-05	1
2021-08-31	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-01	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-02	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-03	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-04	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-05	31	8	3	2021	2021-08-30	2021-09-05	1
2021-09-06	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-07	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-08	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-09	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-10	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-11	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-12	32	8	3	2021	2021-09-06	2021-09-12	2
2021-09-13	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-14	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-15	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-16	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-17	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-18	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-19	33	8	3	2021	2021-09-13	2021-09-19	3
2021-09-20	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-21	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-22	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-23	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-24	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-25	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-26	34	8	3	2021	2021-09-20	2021-09-26	4
2021-09-27	35	9	3	2021	2021-09-27	2021-10-03	1
2021-09-28	35	9	3	2021	2021-09-27	2021-10-03	1
2021-09-29	35	9	3	2021	2021-09-27	2021-10-03	1
2021-09-30	35	9	3	2021	2021-09-27	2021-10-03	1
2021-10-01	35	9	3	2021	2021-09-27	2021-10-03	1
2021-10-02	35	9	3	2021	2021-09-27	2021-10-03	1
2021-10-03	35	9	3	2021	2021-09-27	2021-10-03	1
2021-10-04	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-05	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-06	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-07	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-08	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-09	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-10	36	9	3	2021	2021-10-04	2021-10-10	2
2021-10-11	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-12	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-13	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-14	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-15	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-16	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-17	37	9	3	2021	2021-10-11	2021-10-17	3
2021-10-18	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-19	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-20	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-21	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-22	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-23	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-24	38	9	3	2021	2021-10-18	2021-10-24	4
2021-10-25	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-26	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-27	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-28	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-29	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-30	39	9	3	2021	2021-10-25	2021-10-31	5
2021-10-31	39	9	3	2021	2021-10-25	2021-10-31	5
2021-11-01	40	10	3	2021	2021-11-01	2021-11-07	1
2021-02-03	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-04	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-05	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-06	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-07	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-08	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-09	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-10	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-11	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-12	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-13	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-14	2	1	1	2021	2021-02-08	2021-02-14	2
2021-02-15	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-16	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-17	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-18	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-19	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-20	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-21	3	1	1	2021	2021-02-15	2021-02-21	3
2021-02-22	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-23	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-24	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-25	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-26	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-27	4	1	1	2021	2021-02-22	2021-02-28	4
2021-02-28	4	1	1	2021	2021-02-22	2021-02-28	4
2021-03-01	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-02	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-03	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-04	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-05	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-06	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-07	5	2	1	2021	2021-03-01	2021-03-07	1
2021-03-08	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-09	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-10	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-11	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-12	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-13	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-14	6	2	1	2021	2021-03-08	2021-03-14	2
2021-03-15	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-16	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-17	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-18	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-19	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-20	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-21	7	2	1	2021	2021-03-15	2021-03-21	3
2021-03-22	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-23	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-24	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-25	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-26	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-27	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-28	8	2	1	2021	2021-03-22	2021-03-28	4
2021-03-29	9	3	1	2021	2021-03-29	2021-04-04	1
2021-03-30	9	3	1	2021	2021-03-29	2021-04-04	1
2021-03-31	9	3	1	2021	2021-03-29	2021-04-04	1
2021-04-01	9	3	1	2021	2021-03-29	2021-04-04	1
2021-04-02	9	3	1	2021	2021-03-29	2021-04-04	1
2021-04-03	9	3	1	2021	2021-03-29	2021-04-04	1
2021-04-04	9	3	1	2021	2021-03-29	2021-04-04	1
2021-04-05	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-06	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-07	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-08	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-09	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-10	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-11	10	3	1	2021	2021-04-05	2021-04-11	2
2021-04-12	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-13	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-14	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-15	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-16	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-17	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-18	11	3	1	2021	2021-04-12	2021-04-18	3
2021-04-19	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-20	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-21	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-22	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-23	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-24	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-25	12	3	1	2021	2021-04-19	2021-04-25	4
2021-04-26	13	3	1	2021	2021-04-26	2021-05-02	5
2021-04-27	13	3	1	2021	2021-04-26	2021-05-02	5
2021-04-28	13	3	1	2021	2021-04-26	2021-05-02	5
2021-04-29	13	3	1	2021	2021-04-26	2021-05-02	5
2021-04-30	13	3	1	2021	2021-04-26	2021-05-02	5
2021-05-01	13	3	1	2021	2021-04-26	2021-05-02	5
2021-05-02	13	3	1	2021	2021-04-26	2021-05-02	5
2021-05-03	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-04	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-05	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-06	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-07	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-08	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-09	14	4	2	2021	2021-05-03	2021-05-09	1
2021-05-10	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-11	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-12	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-13	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-14	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-15	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-16	15	4	2	2021	2021-05-10	2021-05-16	2
2021-05-17	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-18	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-19	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-20	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-21	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-22	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-23	16	4	2	2021	2021-05-17	2021-05-23	3
2021-05-24	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-25	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-26	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-27	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-28	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-29	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-30	17	4	2	2021	2021-05-24	2021-05-30	4
2021-05-31	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-01	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-02	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-03	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-04	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-05	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-06	18	5	2	2021	2021-05-31	2021-06-06	1
2021-06-07	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-08	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-09	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-10	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-11	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-12	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-13	19	5	2	2021	2021-06-07	2021-06-13	2
2021-06-14	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-15	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-16	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-17	20	5	2	2021	2021-06-14	2021-06-20	3
2021-06-18	20	5	2	2021	2021-06-14	2021-06-20	3
2020-09-20	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-21	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-22	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-23	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-24	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-25	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-26	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-27	34	8	3	2020	2020-09-21	2020-09-27	4
2020-09-28	35	9	3	2020	2020-09-28	2020-10-04	1
2020-09-29	35	9	3	2020	2020-09-28	2020-10-04	1
2020-09-30	35	9	3	2020	2020-09-28	2020-10-04	1
2020-10-01	35	9	3	2020	2020-09-28	2020-10-04	1
2020-10-02	35	9	3	2020	2020-09-28	2020-10-04	1
2020-10-03	35	9	3	2020	2020-09-28	2020-10-04	1
2020-10-04	35	9	3	2020	2020-09-28	2020-10-04	1
2020-10-05	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-06	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-07	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-08	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-09	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-10	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-11	36	9	3	2020	2020-10-05	2020-10-11	2
2020-10-12	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-13	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-14	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-15	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-16	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-17	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-18	37	9	3	2020	2020-10-12	2020-10-18	3
2020-10-19	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-20	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-21	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-22	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-23	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-24	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-25	38	9	3	2020	2020-10-19	2020-10-25	4
2020-10-26	39	9	3	2020	2020-10-26	2020-11-01	5
2020-10-27	39	9	3	2020	2020-10-26	2020-11-01	5
2020-10-28	39	9	3	2020	2020-10-26	2020-11-01	5
2020-10-29	39	9	3	2020	2020-10-26	2020-11-01	5
2020-10-30	39	9	3	2020	2020-10-26	2020-11-01	5
2020-10-31	39	9	3	2020	2020-10-26	2020-11-01	5
2020-11-01	39	9	3	2020	2020-10-26	2020-11-01	5
2020-11-02	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-03	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-04	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-05	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-06	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-07	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-08	40	10	3	2020	2020-11-02	2020-11-08	1
2020-11-09	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-10	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-11	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-12	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-13	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-14	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-15	41	10	3	2020	2020-11-09	2020-11-15	2
2020-11-16	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-17	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-18	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-19	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-20	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-21	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-22	42	10	3	2020	2020-11-16	2020-11-22	3
2020-11-23	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-24	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-25	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-26	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-27	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-28	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-29	43	10	3	2020	2020-11-23	2020-11-29	4
2020-11-30	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-01	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-02	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-03	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-04	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-05	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-06	44	11	3	2020	2020-11-30	2020-12-06	1
2020-12-07	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-08	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-09	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-10	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-11	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-12	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-13	45	11	3	2020	2020-12-07	2020-12-13	2
2020-12-14	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-15	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-16	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-17	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-18	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-19	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-20	46	11	3	2020	2020-12-14	2020-12-20	3
2020-12-21	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-22	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-23	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-24	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-25	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-26	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-27	47	11	3	2020	2020-12-21	2020-12-27	4
2020-12-28	48	12	4	2020	2020-12-28	2021-01-03	1
2020-12-29	48	12	4	2020	2020-12-28	2021-01-03	1
2020-12-30	48	12	4	2020	2020-12-28	2021-01-03	1
2020-12-31	48	12	4	2020	2020-12-28	2021-01-03	1
2021-01-01	48	12	4	2020	2020-12-28	2021-01-03	1
2021-01-02	48	12	4	2020	2020-12-28	2021-01-03	1
2021-01-03	48	12	4	2020	2020-12-28	2021-01-03	1
2021-01-04	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-05	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-06	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-07	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-08	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-09	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-10	49	12	4	2020	2021-01-04	2021-01-10	2
2021-01-11	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-12	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-13	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-14	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-15	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-16	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-17	50	12	4	2020	2021-01-11	2021-01-17	3
2021-01-18	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-19	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-20	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-21	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-22	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-23	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-24	51	12	4	2020	2021-01-18	2021-01-24	4
2021-01-25	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-26	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-27	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-28	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-29	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-30	52	12	4	2020	2021-01-25	2021-01-31	5
2021-01-31	52	12	4	2020	2021-01-25	2021-01-31	5
2021-02-01	1	1	1	2021	2021-02-01	2021-02-07	1
2021-02-02	1	1	1	2021	2021-02-01	2021-02-07	1
2020-05-07	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-08	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-09	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-10	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-11	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-12	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-13	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-14	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-15	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-16	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-17	15	4	2	2020	2020-05-11	2020-05-17	2
2020-05-18	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-19	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-20	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-21	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-22	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-23	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-24	16	4	2	2020	2020-05-18	2020-05-24	3
2020-05-25	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-26	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-27	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-28	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-29	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-30	17	4	2	2020	2020-05-25	2020-05-31	4
2020-05-31	17	4	2	2020	2020-05-25	2020-05-31	4
2020-06-01	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-02	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-03	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-04	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-05	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-06	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-07	18	5	2	2020	2020-06-01	2020-06-07	1
2020-06-08	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-09	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-10	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-11	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-12	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-13	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-14	19	5	2	2020	2020-06-08	2020-06-14	2
2020-06-15	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-16	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-17	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-18	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-19	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-20	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-21	20	5	2	2020	2020-06-15	2020-06-21	3
2020-06-22	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-23	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-24	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-25	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-26	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-27	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-28	21	5	2	2020	2020-06-22	2020-06-28	4
2020-06-29	22	6	2	2020	2020-06-29	2020-07-05	1
2020-06-30	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-01	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-02	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-03	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-04	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-05	22	6	2	2020	2020-06-29	2020-07-05	1
2020-07-06	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-07	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-08	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-09	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-10	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-11	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-12	23	6	2	2020	2020-07-06	2020-07-12	2
2020-07-13	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-14	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-15	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-16	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-17	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-18	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-19	24	6	2	2020	2020-07-13	2020-07-19	3
2020-07-20	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-21	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-22	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-23	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-24	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-25	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-26	25	6	2	2020	2020-07-20	2020-07-26	4
2020-07-27	26	6	2	2020	2020-07-27	2020-08-02	5
2020-07-28	26	6	2	2020	2020-07-27	2020-08-02	5
2020-07-29	26	6	2	2020	2020-07-27	2020-08-02	5
2020-07-30	26	6	2	2020	2020-07-27	2020-08-02	5
2020-07-31	26	6	2	2020	2020-07-27	2020-08-02	5
2020-08-01	26	6	2	2020	2020-07-27	2020-08-02	5
2020-08-02	26	6	2	2020	2020-07-27	2020-08-02	5
2020-08-03	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-04	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-05	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-06	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-07	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-08	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-09	27	7	2	2020	2020-08-03	2020-08-09	1
2020-08-10	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-11	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-12	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-13	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-14	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-15	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-16	28	7	2	2020	2020-08-10	2020-08-16	2
2020-08-17	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-18	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-19	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-20	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-21	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-22	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-23	29	7	2	2020	2020-08-17	2020-08-23	3
2020-08-24	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-25	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-26	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-27	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-28	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-29	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-30	30	7	2	2020	2020-08-24	2020-08-30	4
2020-08-31	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-01	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-02	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-03	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-04	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-05	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-06	31	8	3	2020	2020-08-31	2020-09-06	1
2020-09-07	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-08	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-09	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-10	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-11	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-12	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-13	32	8	3	2020	2020-09-07	2020-09-13	2
2020-09-14	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-15	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-16	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-17	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-18	33	8	3	2020	2020-09-14	2020-09-20	3
2020-09-19	33	8	3	2020	2020-09-14	2020-09-20	3
2019-12-23	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-24	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-25	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-26	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-27	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-28	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-29	47	11	3	2019	2019-12-23	2019-12-29	4
2019-12-30	48	12	4	2019	2019-12-30	2020-01-05	1
2019-12-31	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-01	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-02	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-03	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-04	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-05	48	12	4	2019	2019-12-30	2020-01-05	1
2020-01-06	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-07	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-08	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-09	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-10	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-11	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-12	49	12	4	2019	2020-01-06	2020-01-12	2
2020-01-13	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-14	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-15	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-16	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-17	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-18	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-19	50	12	4	2019	2020-01-13	2020-01-19	3
2020-01-20	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-21	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-22	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-23	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-24	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-25	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-26	51	12	4	2019	2020-01-20	2020-01-26	4
2020-01-27	52	12	4	2019	2020-01-27	2020-02-02	5
2020-01-28	52	12	4	2019	2020-01-27	2020-02-02	5
2020-01-29	52	12	4	2019	2020-01-27	2020-02-02	5
2020-01-30	52	12	4	2019	2020-01-27	2020-02-02	5
2020-01-31	52	12	4	2019	2020-01-27	2020-02-02	5
2020-02-01	52	12	4	2019	2020-01-27	2020-02-02	5
2020-02-02	52	12	4	2019	2020-01-27	2020-02-02	5
2020-02-03	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-04	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-05	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-06	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-07	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-08	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-09	1	1	1	2020	2020-02-03	2020-02-09	1
2020-02-10	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-11	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-12	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-13	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-14	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-15	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-16	2	1	1	2020	2020-02-10	2020-02-16	2
2020-02-17	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-18	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-19	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-20	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-21	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-22	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-23	3	1	1	2020	2020-02-17	2020-02-23	3
2020-02-24	4	1	1	2020	2020-02-24	2020-03-01	4
2020-02-25	4	1	1	2020	2020-02-24	2020-03-01	4
2020-02-26	4	1	1	2020	2020-02-24	2020-03-01	4
2020-02-27	4	1	1	2020	2020-02-24	2020-03-01	4
2020-02-28	4	1	1	2020	2020-02-24	2020-03-01	4
2020-02-29	4	1	1	2020	2020-02-24	2020-03-01	4
2020-03-01	4	1	1	2020	2020-02-24	2020-03-01	4
2020-03-02	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-03	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-04	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-05	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-06	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-07	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-08	5	2	1	2020	2020-03-02	2020-03-08	1
2020-03-09	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-10	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-11	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-12	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-13	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-14	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-15	6	2	1	2020	2020-03-09	2020-03-15	2
2020-03-16	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-17	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-18	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-19	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-20	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-21	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-22	7	2	1	2020	2020-03-16	2020-03-22	3
2020-03-23	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-24	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-25	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-26	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-27	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-28	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-29	8	2	1	2020	2020-03-23	2020-03-29	4
2020-03-30	9	3	1	2020	2020-03-30	2020-04-05	1
2020-03-31	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-01	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-02	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-03	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-04	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-05	9	3	1	2020	2020-03-30	2020-04-05	1
2020-04-06	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-07	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-08	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-09	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-10	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-11	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-12	10	3	1	2020	2020-04-06	2020-04-12	2
2020-04-13	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-14	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-15	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-16	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-17	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-18	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-19	11	3	1	2020	2020-04-13	2020-04-19	3
2020-04-20	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-21	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-22	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-23	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-24	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-25	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-26	12	3	1	2020	2020-04-20	2020-04-26	4
2020-04-27	13	3	1	2020	2020-04-27	2020-05-03	5
2020-04-28	13	3	1	2020	2020-04-27	2020-05-03	5
2020-04-29	13	3	1	2020	2020-04-27	2020-05-03	5
2020-04-30	13	3	1	2020	2020-04-27	2020-05-03	5
2020-05-01	13	3	1	2020	2020-04-27	2020-05-03	5
2020-05-02	13	3	1	2020	2020-04-27	2020-05-03	5
2020-05-03	13	3	1	2020	2020-04-27	2020-05-03	5
2020-05-04	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-05	14	4	2	2020	2020-05-04	2020-05-10	1
2020-05-06	14	4	2	2020	2020-05-04	2020-05-10	1
2019-08-09	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-10	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-11	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-12	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-13	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-14	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-15	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-16	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-17	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-18	28	7	2	2019	2019-08-12	2019-08-18	2
2019-08-19	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-20	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-21	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-22	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-23	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-24	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-25	29	7	2	2019	2019-08-19	2019-08-25	3
2019-08-26	30	7	2	2019	2019-08-26	2019-09-01	4
2019-08-27	30	7	2	2019	2019-08-26	2019-09-01	4
2019-08-28	30	7	2	2019	2019-08-26	2019-09-01	4
2019-08-29	30	7	2	2019	2019-08-26	2019-09-01	4
2019-08-30	30	7	2	2019	2019-08-26	2019-09-01	4
2019-08-31	30	7	2	2019	2019-08-26	2019-09-01	4
2019-09-01	30	7	2	2019	2019-08-26	2019-09-01	4
2019-09-02	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-03	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-04	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-05	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-06	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-07	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-08	31	8	3	2019	2019-09-02	2019-09-08	1
2019-09-09	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-10	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-11	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-12	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-13	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-14	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-15	32	8	3	2019	2019-09-09	2019-09-15	2
2019-09-16	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-17	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-18	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-19	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-20	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-21	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-22	33	8	3	2019	2019-09-16	2019-09-22	3
2019-09-23	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-24	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-25	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-26	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-27	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-28	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-29	34	8	3	2019	2019-09-23	2019-09-29	4
2019-09-30	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-01	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-02	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-03	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-04	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-05	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-06	35	9	3	2019	2019-09-30	2019-10-06	1
2019-10-07	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-08	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-09	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-10	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-11	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-12	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-13	36	9	3	2019	2019-10-07	2019-10-13	2
2019-10-14	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-15	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-16	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-17	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-18	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-19	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-20	37	9	3	2019	2019-10-14	2019-10-20	3
2019-10-21	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-22	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-23	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-24	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-25	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-26	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-27	38	9	3	2019	2019-10-21	2019-10-27	4
2019-10-28	39	9	3	2019	2019-10-28	2019-11-03	5
2019-10-29	39	9	3	2019	2019-10-28	2019-11-03	5
2019-10-30	39	9	3	2019	2019-10-28	2019-11-03	5
2019-10-31	39	9	3	2019	2019-10-28	2019-11-03	5
2019-11-01	39	9	3	2019	2019-10-28	2019-11-03	5
2019-11-02	39	9	3	2019	2019-10-28	2019-11-03	5
2019-11-03	39	9	3	2019	2019-10-28	2019-11-03	5
2019-11-04	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-05	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-06	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-07	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-08	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-09	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-10	40	10	3	2019	2019-11-04	2019-11-10	1
2019-11-11	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-12	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-13	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-14	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-15	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-16	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-17	41	10	3	2019	2019-11-11	2019-11-17	2
2019-11-18	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-19	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-20	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-21	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-22	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-23	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-24	42	10	3	2019	2019-11-18	2019-11-24	3
2019-11-25	43	10	3	2019	2019-11-25	2019-12-01	4
2019-11-26	43	10	3	2019	2019-11-25	2019-12-01	4
2019-11-27	43	10	3	2019	2019-11-25	2019-12-01	4
2019-11-28	43	10	3	2019	2019-11-25	2019-12-01	4
2019-11-29	43	10	3	2019	2019-11-25	2019-12-01	4
2019-11-30	43	10	3	2019	2019-11-25	2019-12-01	4
2019-12-01	43	10	3	2019	2019-11-25	2019-12-01	4
2019-12-02	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-03	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-04	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-05	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-06	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-07	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-08	44	11	3	2019	2019-12-02	2019-12-08	1
2019-12-09	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-10	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-11	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-12	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-13	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-14	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-15	45	11	3	2019	2019-12-09	2019-12-15	2
2019-12-16	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-17	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-18	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-19	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-20	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-21	46	11	3	2019	2019-12-16	2019-12-22	3
2019-12-22	46	11	3	2019	2019-12-16	2019-12-22	3
2019-03-26	8	2	1	2019	2019-03-25	2019-03-31	4
2019-03-27	8	2	1	2019	2019-03-25	2019-03-31	4
2019-03-28	8	2	1	2019	2019-03-25	2019-03-31	4
2019-03-29	8	2	1	2019	2019-03-25	2019-03-31	4
2019-03-30	8	2	1	2019	2019-03-25	2019-03-31	4
2019-03-31	8	2	1	2019	2019-03-25	2019-03-31	4
2019-04-01	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-02	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-03	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-04	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-05	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-06	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-07	9	3	1	2019	2019-04-01	2019-04-07	1
2019-04-08	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-09	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-10	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-11	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-12	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-13	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-14	10	3	1	2019	2019-04-08	2019-04-14	2
2019-04-15	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-16	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-17	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-18	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-19	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-20	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-21	11	3	1	2019	2019-04-15	2019-04-21	3
2019-04-22	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-23	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-24	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-25	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-26	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-27	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-28	12	3	1	2019	2019-04-22	2019-04-28	4
2019-04-29	13	3	1	2019	2019-04-29	2019-05-05	5
2019-04-30	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-01	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-02	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-03	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-04	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-05	13	3	1	2019	2019-04-29	2019-05-05	5
2019-05-06	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-07	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-08	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-09	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-10	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-11	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-12	14	4	2	2019	2019-05-06	2019-05-12	1
2019-05-13	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-14	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-15	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-16	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-17	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-18	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-19	15	4	2	2019	2019-05-13	2019-05-19	2
2019-05-20	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-21	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-22	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-23	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-24	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-25	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-26	16	4	2	2019	2019-05-20	2019-05-26	3
2019-05-27	17	4	2	2019	2019-05-27	2019-06-02	4
2019-05-28	17	4	2	2019	2019-05-27	2019-06-02	4
2019-05-29	17	4	2	2019	2019-05-27	2019-06-02	4
2019-05-30	17	4	2	2019	2019-05-27	2019-06-02	4
2019-05-31	17	4	2	2019	2019-05-27	2019-06-02	4
2019-06-01	17	4	2	2019	2019-05-27	2019-06-02	4
2019-06-02	17	4	2	2019	2019-05-27	2019-06-02	4
2019-06-03	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-04	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-05	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-06	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-07	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-08	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-09	18	5	2	2019	2019-06-03	2019-06-09	1
2019-06-10	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-11	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-12	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-13	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-14	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-15	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-16	19	5	2	2019	2019-06-10	2019-06-16	2
2019-06-17	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-18	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-19	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-20	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-21	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-22	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-23	20	5	2	2019	2019-06-17	2019-06-23	3
2019-06-24	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-25	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-26	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-27	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-28	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-29	21	5	2	2019	2019-06-24	2019-06-30	4
2019-06-30	21	5	2	2019	2019-06-24	2019-06-30	4
2019-07-01	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-02	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-03	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-04	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-05	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-06	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-07	22	6	2	2019	2019-07-01	2019-07-07	1
2019-07-08	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-09	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-10	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-11	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-12	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-13	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-14	23	6	2	2019	2019-07-08	2019-07-14	2
2019-07-15	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-16	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-17	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-18	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-19	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-20	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-21	24	6	2	2019	2019-07-15	2019-07-21	3
2019-07-22	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-23	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-24	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-25	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-26	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-27	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-28	25	6	2	2019	2019-07-22	2019-07-28	4
2019-07-29	26	6	2	2019	2019-07-29	2019-08-04	5
2019-07-30	26	6	2	2019	2019-07-29	2019-08-04	5
2019-07-31	26	6	2	2019	2019-07-29	2019-08-04	5
2019-08-01	26	6	2	2019	2019-07-29	2019-08-04	5
2019-08-02	26	6	2	2019	2019-07-29	2019-08-04	5
2019-08-03	26	6	2	2019	2019-07-29	2019-08-04	5
2019-08-04	26	6	2	2019	2019-07-29	2019-08-04	5
2019-08-05	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-06	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-07	27	7	2	2019	2019-08-05	2019-08-11	1
2019-08-08	27	7	2	2019	2019-08-05	2019-08-11	1
2018-11-10	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-11	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-12	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-13	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-14	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-15	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-16	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-17	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-18	42	10	3	2018	2018-11-12	2018-11-18	3
2018-11-19	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-20	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-21	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-22	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-23	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-24	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-25	43	10	3	2018	2018-11-19	2018-11-25	4
2018-11-26	44	11	3	2018	2018-11-26	2018-12-02	1
2018-11-27	44	11	3	2018	2018-11-26	2018-12-02	1
2018-11-28	44	11	3	2018	2018-11-26	2018-12-02	1
2018-11-29	44	11	3	2018	2018-11-26	2018-12-02	1
2018-11-30	44	11	3	2018	2018-11-26	2018-12-02	1
2018-12-01	44	11	3	2018	2018-11-26	2018-12-02	1
2018-12-02	44	11	3	2018	2018-11-26	2018-12-02	1
2018-12-03	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-04	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-05	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-06	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-07	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-08	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-09	45	11	3	2018	2018-12-03	2018-12-09	2
2018-12-10	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-11	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-12	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-13	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-14	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-15	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-16	46	11	3	2018	2018-12-10	2018-12-16	3
2018-12-17	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-18	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-19	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-20	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-21	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-22	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-23	47	11	3	2018	2018-12-17	2018-12-23	4
2018-12-24	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-25	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-26	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-27	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-28	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-29	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-30	48	12	4	2018	2018-12-24	2018-12-30	1
2018-12-31	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-01	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-02	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-03	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-04	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-05	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-06	49	12	4	2018	2018-12-31	2019-01-06	2
2019-01-07	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-08	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-09	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-10	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-11	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-12	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-13	50	12	4	2018	2019-01-07	2019-01-13	3
2019-01-14	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-15	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-16	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-17	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-18	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-19	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-20	51	12	4	2018	2019-01-14	2019-01-20	4
2019-01-21	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-22	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-23	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-24	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-25	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-26	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-27	52	12	4	2018	2019-01-21	2019-01-27	5
2019-01-28	53	12	4	2018	2019-01-28	2019-02-03	6
2019-01-29	53	12	4	2018	2019-01-28	2019-02-03	6
2019-01-30	53	12	4	2018	2019-01-28	2019-02-03	6
2019-01-31	53	12	4	2018	2019-01-28	2019-02-03	6
2019-02-01	53	12	4	2018	2019-01-28	2019-02-03	6
2019-02-02	53	12	4	2018	2019-01-28	2019-02-03	6
2019-02-03	53	12	4	2018	2019-01-28	2019-02-03	6
2019-02-04	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-05	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-06	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-07	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-08	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-09	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-10	1	1	1	2019	2019-02-04	2019-02-10	1
2019-02-11	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-12	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-13	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-14	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-15	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-16	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-17	2	1	1	2019	2019-02-11	2019-02-17	2
2019-02-18	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-19	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-20	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-21	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-22	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-23	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-24	3	1	1	2019	2019-02-18	2019-02-24	3
2019-02-25	4	1	1	2019	2019-02-25	2019-03-03	4
2019-02-26	4	1	1	2019	2019-02-25	2019-03-03	4
2019-02-27	4	1	1	2019	2019-02-25	2019-03-03	4
2019-02-28	4	1	1	2019	2019-02-25	2019-03-03	4
2019-03-01	4	1	1	2019	2019-02-25	2019-03-03	4
2019-03-02	4	1	1	2019	2019-02-25	2019-03-03	4
2019-03-03	4	1	1	2019	2019-02-25	2019-03-03	4
2019-03-04	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-05	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-06	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-07	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-08	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-09	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-10	5	2	1	2019	2019-03-04	2019-03-10	1
2019-03-11	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-12	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-13	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-14	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-15	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-16	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-17	6	2	1	2019	2019-03-11	2019-03-17	2
2019-03-18	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-19	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-20	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-21	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-22	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-23	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-24	7	2	1	2019	2019-03-18	2019-03-24	3
2019-03-25	8	2	1	2019	2019-03-25	2019-03-31	4
2018-06-27	22	6	2	2018	2018-06-25	2018-07-01	1
2018-06-28	22	6	2	2018	2018-06-25	2018-07-01	1
2018-06-29	22	6	2	2018	2018-06-25	2018-07-01	1
2018-06-30	22	6	2	2018	2018-06-25	2018-07-01	1
2018-07-01	22	6	2	2018	2018-06-25	2018-07-01	1
2018-07-02	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-03	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-04	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-05	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-06	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-07	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-08	23	6	2	2018	2018-07-02	2018-07-08	2
2018-07-09	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-10	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-11	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-12	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-13	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-14	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-15	24	6	2	2018	2018-07-09	2018-07-15	3
2018-07-16	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-17	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-18	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-19	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-20	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-21	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-22	25	6	2	2018	2018-07-16	2018-07-22	4
2018-07-23	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-24	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-25	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-26	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-27	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-28	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-29	26	6	2	2018	2018-07-23	2018-07-29	5
2018-07-30	27	7	2	2018	2018-07-30	2018-08-05	1
2018-07-31	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-01	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-02	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-03	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-04	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-05	27	7	2	2018	2018-07-30	2018-08-05	1
2018-08-06	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-07	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-08	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-09	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-10	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-11	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-12	28	7	2	2018	2018-08-06	2018-08-12	2
2018-08-13	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-14	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-15	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-16	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-17	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-18	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-19	29	7	2	2018	2018-08-13	2018-08-19	3
2018-08-20	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-21	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-22	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-23	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-24	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-25	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-26	30	7	2	2018	2018-08-20	2018-08-26	4
2018-08-27	31	8	3	2018	2018-08-27	2018-09-02	1
2018-08-28	31	8	3	2018	2018-08-27	2018-09-02	1
2018-08-29	31	8	3	2018	2018-08-27	2018-09-02	1
2018-08-30	31	8	3	2018	2018-08-27	2018-09-02	1
2018-08-31	31	8	3	2018	2018-08-27	2018-09-02	1
2018-09-01	31	8	3	2018	2018-08-27	2018-09-02	1
2018-09-02	31	8	3	2018	2018-08-27	2018-09-02	1
2018-09-03	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-04	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-05	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-06	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-07	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-08	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-09	32	8	3	2018	2018-09-03	2018-09-09	2
2018-09-10	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-11	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-12	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-13	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-14	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-15	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-16	33	8	3	2018	2018-09-10	2018-09-16	3
2018-09-17	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-18	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-19	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-20	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-21	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-22	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-23	34	8	3	2018	2018-09-17	2018-09-23	4
2018-09-24	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-25	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-26	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-27	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-28	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-29	35	9	3	2018	2018-09-24	2018-09-30	1
2018-09-30	35	9	3	2018	2018-09-24	2018-09-30	1
2018-10-01	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-02	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-03	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-04	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-05	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-06	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-07	36	9	3	2018	2018-10-01	2018-10-07	2
2018-10-08	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-09	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-10	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-11	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-12	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-13	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-14	37	9	3	2018	2018-10-08	2018-10-14	3
2018-10-15	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-16	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-17	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-18	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-19	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-20	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-21	38	9	3	2018	2018-10-15	2018-10-21	4
2018-10-22	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-23	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-24	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-25	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-26	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-27	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-28	39	9	3	2018	2018-10-22	2018-10-28	5
2018-10-29	40	10	3	2018	2018-10-29	2018-11-04	1
2018-10-30	40	10	3	2018	2018-10-29	2018-11-04	1
2018-10-31	40	10	3	2018	2018-10-29	2018-11-04	1
2018-11-01	40	10	3	2018	2018-10-29	2018-11-04	1
2018-11-02	40	10	3	2018	2018-10-29	2018-11-04	1
2018-11-03	40	10	3	2018	2018-10-29	2018-11-04	1
2018-11-04	40	10	3	2018	2018-10-29	2018-11-04	1
2018-11-05	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-06	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-07	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-08	41	10	3	2018	2018-11-05	2018-11-11	2
2018-11-09	41	10	3	2018	2018-11-05	2018-11-11	2
2018-02-11	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-12	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-13	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-14	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-15	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-16	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-17	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-18	3	1	1	2018	2018-02-12	2018-02-18	3
2018-02-19	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-20	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-21	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-22	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-23	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-24	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-25	4	1	1	2018	2018-02-19	2018-02-25	4
2018-02-26	5	2	1	2018	2018-02-26	2018-03-04	1
2018-02-27	5	2	1	2018	2018-02-26	2018-03-04	1
2018-02-28	5	2	1	2018	2018-02-26	2018-03-04	1
2018-03-01	5	2	1	2018	2018-02-26	2018-03-04	1
2018-03-02	5	2	1	2018	2018-02-26	2018-03-04	1
2018-03-03	5	2	1	2018	2018-02-26	2018-03-04	1
2018-03-04	5	2	1	2018	2018-02-26	2018-03-04	1
2018-03-05	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-06	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-07	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-08	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-09	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-10	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-11	6	2	1	2018	2018-03-05	2018-03-11	2
2018-03-12	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-13	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-14	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-15	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-16	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-17	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-18	7	2	1	2018	2018-03-12	2018-03-18	3
2018-03-19	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-20	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-21	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-22	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-23	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-24	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-25	8	2	1	2018	2018-03-19	2018-03-25	4
2018-03-26	9	3	1	2018	2018-03-26	2018-04-01	1
2018-03-27	9	3	1	2018	2018-03-26	2018-04-01	1
2018-03-28	9	3	1	2018	2018-03-26	2018-04-01	1
2018-03-29	9	3	1	2018	2018-03-26	2018-04-01	1
2018-03-30	9	3	1	2018	2018-03-26	2018-04-01	1
2018-03-31	9	3	1	2018	2018-03-26	2018-04-01	1
2018-04-01	9	3	1	2018	2018-03-26	2018-04-01	1
2018-04-02	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-03	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-04	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-05	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-06	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-07	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-08	10	3	1	2018	2018-04-02	2018-04-08	2
2018-04-09	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-10	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-11	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-12	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-13	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-14	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-15	11	3	1	2018	2018-04-09	2018-04-15	3
2018-04-16	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-17	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-18	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-19	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-20	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-21	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-22	12	3	1	2018	2018-04-16	2018-04-22	4
2018-04-23	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-24	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-25	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-26	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-27	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-28	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-29	13	3	1	2018	2018-04-23	2018-04-29	5
2018-04-30	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-01	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-02	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-03	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-04	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-05	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-06	14	4	2	2018	2018-04-30	2018-05-06	1
2018-05-07	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-08	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-09	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-10	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-11	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-12	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-13	15	4	2	2018	2018-05-07	2018-05-13	2
2018-05-14	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-15	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-16	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-17	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-18	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-19	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-20	16	4	2	2018	2018-05-14	2018-05-20	3
2018-05-21	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-22	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-23	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-24	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-25	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-26	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-27	17	4	2	2018	2018-05-21	2018-05-27	4
2018-05-28	18	5	2	2018	2018-05-28	2018-06-03	1
2018-05-29	18	5	2	2018	2018-05-28	2018-06-03	1
2018-05-30	18	5	2	2018	2018-05-28	2018-06-03	1
2018-05-31	18	5	2	2018	2018-05-28	2018-06-03	1
2018-06-01	18	5	2	2018	2018-05-28	2018-06-03	1
2018-06-02	18	5	2	2018	2018-05-28	2018-06-03	1
2018-06-03	18	5	2	2018	2018-05-28	2018-06-03	1
2018-06-04	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-05	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-06	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-07	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-08	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-09	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-10	19	5	2	2018	2018-06-04	2018-06-10	2
2018-06-11	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-12	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-13	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-14	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-15	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-16	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-17	20	5	2	2018	2018-06-11	2018-06-17	3
2018-06-18	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-19	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-20	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-21	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-22	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-23	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-24	21	5	2	2018	2018-06-18	2018-06-24	4
2018-06-25	22	6	2	2018	2018-06-25	2018-07-01	1
2018-06-26	22	6	2	2018	2018-06-25	2018-07-01	1
2017-09-28	35	9	3	2017	2017-09-25	2017-10-01	1
2017-09-29	35	9	3	2017	2017-09-25	2017-10-01	1
1989-01-30	1	1	1	1989	1989-01-30	1989-02-05	1
1989-01-31	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-01	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-02	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-03	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-04	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-05	1	1	1	1989	1989-01-30	1989-02-05	1
1989-02-06	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-07	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-08	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-09	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-10	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-11	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-12	2	1	1	1989	1989-02-06	1989-02-12	2
1989-02-13	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-14	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-15	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-16	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-17	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-18	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-19	3	1	1	1989	1989-02-13	1989-02-19	3
1989-02-20	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-21	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-22	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-23	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-24	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-25	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-26	4	1	1	1989	1989-02-20	1989-02-26	4
1989-02-27	5	2	1	1989	1989-02-27	1989-03-05	1
1989-02-28	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-01	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-02	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-03	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-04	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-05	5	2	1	1989	1989-02-27	1989-03-05	1
1989-03-06	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-07	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-08	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-09	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-10	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-11	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-12	6	2	1	1989	1989-03-06	1989-03-12	2
1989-03-13	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-14	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-15	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-16	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-17	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-18	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-19	7	2	1	1989	1989-03-13	1989-03-19	3
1989-03-20	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-21	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-22	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-23	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-24	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-25	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-26	8	2	1	1989	1989-03-20	1989-03-26	4
1989-03-27	9	3	1	1989	1989-03-27	1989-04-02	1
1989-03-28	9	3	1	1989	1989-03-27	1989-04-02	1
1989-03-29	9	3	1	1989	1989-03-27	1989-04-02	1
1989-03-30	9	3	1	1989	1989-03-27	1989-04-02	1
1989-03-31	9	3	1	1989	1989-03-27	1989-04-02	1
1989-04-01	9	3	1	1989	1989-03-27	1989-04-02	1
1989-04-02	9	3	1	1989	1989-03-27	1989-04-02	1
1989-04-03	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-04	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-05	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-06	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-07	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-08	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-09	10	3	1	1989	1989-04-03	1989-04-09	2
1989-04-10	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-11	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-12	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-13	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-14	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-15	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-16	11	3	1	1989	1989-04-10	1989-04-16	3
1989-04-17	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-18	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-19	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-20	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-21	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-22	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-23	12	3	1	1989	1989-04-17	1989-04-23	4
1989-04-24	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-25	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-26	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-27	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-28	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-29	13	3	1	1989	1989-04-24	1989-04-30	5
1989-04-30	13	3	1	1989	1989-04-24	1989-04-30	5
1989-05-01	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-02	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-03	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-04	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-05	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-06	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-07	14	4	2	1989	1989-05-01	1989-05-07	1
1989-05-08	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-09	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-10	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-11	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-12	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-13	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-14	15	4	2	1989	1989-05-08	1989-05-14	2
1989-05-15	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-16	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-17	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-18	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-19	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-20	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-21	16	4	2	1989	1989-05-15	1989-05-21	3
1989-05-22	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-23	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-24	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-25	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-26	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-27	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-28	17	4	2	1989	1989-05-22	1989-05-28	4
1989-05-29	18	5	2	1989	1989-05-29	1989-06-04	1
1989-05-30	18	5	2	1989	1989-05-29	1989-06-04	1
1989-05-31	18	5	2	1989	1989-05-29	1989-06-04	1
1989-06-01	18	5	2	1989	1989-05-29	1989-06-04	1
1989-06-02	18	5	2	1989	1989-05-29	1989-06-04	1
1989-06-03	18	5	2	1989	1989-05-29	1989-06-04	1
1989-06-04	18	5	2	1989	1989-05-29	1989-06-04	1
1989-06-05	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-06	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-07	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-08	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-09	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-10	19	5	2	1989	1989-06-05	1989-06-11	2
2017-09-30	35	9	3	2017	2017-09-25	2017-10-01	1
2017-10-01	35	9	3	2017	2017-09-25	2017-10-01	1
2017-10-02	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-03	36	9	3	2017	2017-10-02	2017-10-08	2
1989-06-11	19	5	2	1989	1989-06-05	1989-06-11	2
1989-06-12	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-13	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-14	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-15	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-16	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-17	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-18	20	5	2	1989	1989-06-12	1989-06-18	2
1989-06-19	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-20	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-21	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-22	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-23	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-24	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-25	21	5	2	1989	1989-06-19	1989-06-25	3
1989-06-26	22	6	2	1989	1989-06-26	1989-07-02	1
1989-06-27	22	6	2	1989	1989-06-26	1989-07-02	1
1989-06-28	22	6	2	1989	1989-06-26	1989-07-02	1
1989-06-29	22	6	2	1989	1989-06-26	1989-07-02	1
1989-06-30	22	6	2	1989	1989-06-26	1989-07-02	1
1989-07-01	22	6	2	1989	1989-06-26	1989-07-02	1
1989-07-02	22	6	2	1989	1989-06-26	1989-07-02	1
1989-07-03	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-04	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-05	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-06	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-07	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-08	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-09	23	6	2	1989	1989-07-03	1989-07-09	2
1989-07-10	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-11	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-12	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-13	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-14	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-15	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-16	24	6	2	1989	1989-07-10	1989-07-16	3
1989-07-17	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-18	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-19	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-20	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-21	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-22	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-23	25	6	2	1989	1989-07-17	1989-07-23	4
1989-07-24	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-25	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-26	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-27	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-28	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-29	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-30	26	6	2	1989	1989-07-24	1989-07-30	5
1989-07-31	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-01	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-02	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-03	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-04	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-05	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-06	27	7	2	1989	1989-07-31	1989-08-06	1
1989-08-07	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-08	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-09	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-10	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-11	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-12	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-13	28	7	2	1989	1989-08-07	1989-08-13	2
1989-08-14	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-15	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-16	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-17	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-18	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-19	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-20	29	7	2	1989	1989-08-14	1989-08-20	3
1989-08-21	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-22	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-23	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-24	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-25	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-26	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-27	30	7	2	1989	1989-08-21	1989-08-27	4
1989-08-28	31	8	3	1989	1989-08-28	1989-09-03	1
1989-08-29	31	8	3	1989	1989-08-28	1989-09-03	1
1989-08-30	31	8	3	1989	1989-08-28	1989-09-03	1
1989-08-31	31	8	3	1989	1989-08-28	1989-09-03	1
1989-09-01	31	8	3	1989	1989-08-28	1989-09-03	1
1989-09-02	31	8	3	1989	1989-08-28	1989-09-03	1
1989-09-03	31	8	3	1989	1989-08-28	1989-09-03	1
1989-09-04	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-05	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-06	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-07	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-08	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-09	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-10	32	8	3	1989	1989-09-04	1989-09-10	2
1989-09-11	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-12	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-13	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-14	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-15	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-16	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-17	33	8	3	1989	1989-09-11	1989-09-17	3
1989-09-18	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-19	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-20	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-21	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-22	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-23	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-24	34	8	3	1989	1989-09-18	1989-09-24	4
1989-09-25	35	9	3	1989	1989-09-25	1989-10-01	1
1989-09-26	35	9	3	1989	1989-09-25	1989-10-01	1
1989-09-27	35	9	3	1989	1989-09-25	1989-10-01	1
1989-09-28	35	9	3	1989	1989-09-25	1989-10-01	1
1989-09-29	35	9	3	1989	1989-09-25	1989-10-01	1
1989-09-30	35	9	3	1989	1989-09-25	1989-10-01	1
1989-10-01	35	9	3	1989	1989-09-25	1989-10-01	1
1989-10-02	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-03	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-04	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-05	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-06	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-07	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-08	36	9	3	1989	1989-10-02	1989-10-08	2
1989-10-09	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-10	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-11	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-12	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-13	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-14	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-15	37	9	3	1989	1989-10-09	1989-10-15	3
1989-10-16	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-17	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-18	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-19	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-20	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-21	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-22	38	9	3	1989	1989-10-16	1989-10-22	4
1989-10-23	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-24	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-25	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-26	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-27	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-28	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-29	39	9	3	1989	1989-10-23	1989-10-29	5
1989-10-30	40	10	3	1989	1989-10-30	1989-11-05	1
1989-10-31	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-01	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-02	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-03	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-04	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-05	40	10	3	1989	1989-10-30	1989-11-05	1
1989-11-06	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-07	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-08	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-09	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-10	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-11	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-12	41	10	3	1989	1989-11-06	1989-11-12	2
1989-11-13	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-14	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-15	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-16	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-17	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-18	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-19	42	10	3	1989	1989-11-13	1989-11-19	3
1989-11-20	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-21	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-22	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-23	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-24	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-25	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-26	43	10	3	1989	1989-11-20	1989-11-26	4
1989-11-27	44	11	3	1989	1989-11-27	1989-12-03	1
1989-11-28	44	11	3	1989	1989-11-27	1989-12-03	1
1989-11-29	44	11	3	1989	1989-11-27	1989-12-03	1
1989-11-30	44	11	3	1989	1989-11-27	1989-12-03	1
1989-12-01	44	11	3	1989	1989-11-27	1989-12-03	1
1989-12-02	44	11	3	1989	1989-11-27	1989-12-03	1
1989-12-03	44	11	3	1989	1989-11-27	1989-12-03	1
1989-12-04	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-05	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-06	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-07	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-08	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-09	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-10	45	11	3	1989	1989-12-04	1989-12-10	2
1989-12-11	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-12	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-13	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-14	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-15	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-16	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-17	46	11	3	1989	1989-12-11	1989-12-17	3
1989-12-18	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-19	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-20	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-21	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-22	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-23	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-24	47	11	3	1989	1989-12-18	1989-12-24	4
1989-12-25	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-26	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-27	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-28	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-29	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-30	48	12	4	1989	1989-12-25	1989-12-31	1
1989-12-31	48	12	4	1989	1989-12-25	1989-12-31	1
1990-01-01	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-02	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-03	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-04	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-05	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-06	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-07	49	12	4	1989	1990-01-01	1990-01-07	2
1990-01-08	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-09	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-10	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-11	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-12	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-13	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-14	50	12	4	1989	1990-01-08	1990-01-14	3
1990-01-15	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-16	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-17	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-18	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-19	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-20	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-21	51	12	4	1989	1990-01-15	1990-01-21	4
1990-01-22	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-23	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-24	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-25	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-26	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-27	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-28	52	12	4	1989	1990-01-22	1990-01-28	5
1990-01-29	1	1	1	1990	1990-01-29	1990-02-04	1
1990-01-30	1	1	1	1990	1990-01-29	1990-02-04	1
1990-01-31	1	1	1	1990	1990-01-29	1990-02-04	1
1990-02-01	1	1	1	1990	1990-01-29	1990-02-04	1
1990-02-02	1	1	1	1990	1990-01-29	1990-02-04	1
1990-02-03	1	1	1	1990	1990-01-29	1990-02-04	1
1990-02-04	1	1	1	1990	1990-01-29	1990-02-04	1
1990-02-05	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-06	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-07	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-08	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-09	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-10	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-11	2	1	1	1990	1990-02-05	1990-02-11	2
1990-02-12	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-13	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-14	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-15	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-16	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-17	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-18	3	1	1	1990	1990-02-12	1990-02-18	3
1990-02-19	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-20	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-21	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-22	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-23	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-24	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-25	4	1	1	1990	1990-02-19	1990-02-25	4
1990-02-26	5	2	1	1990	1990-02-26	1990-03-04	1
1990-02-27	5	2	1	1990	1990-02-26	1990-03-04	1
1990-02-28	5	2	1	1990	1990-02-26	1990-03-04	1
1990-03-01	5	2	1	1990	1990-02-26	1990-03-04	1
1990-03-02	5	2	1	1990	1990-02-26	1990-03-04	1
1990-03-03	5	2	1	1990	1990-02-26	1990-03-04	1
1990-03-04	5	2	1	1990	1990-02-26	1990-03-04	1
1990-03-05	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-06	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-07	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-08	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-09	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-10	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-11	6	2	1	1990	1990-03-05	1990-03-11	2
1990-03-12	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-13	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-14	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-15	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-16	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-17	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-18	7	2	1	1990	1990-03-12	1990-03-18	3
1990-03-19	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-20	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-21	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-22	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-23	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-24	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-25	8	2	1	1990	1990-03-19	1990-03-25	4
1990-03-26	9	3	1	1990	1990-03-26	1990-04-01	1
1990-03-27	9	3	1	1990	1990-03-26	1990-04-01	1
1990-03-28	9	3	1	1990	1990-03-26	1990-04-01	1
1990-03-29	9	3	1	1990	1990-03-26	1990-04-01	1
1990-03-30	9	3	1	1990	1990-03-26	1990-04-01	1
1990-03-31	9	3	1	1990	1990-03-26	1990-04-01	1
1990-04-01	9	3	1	1990	1990-03-26	1990-04-01	1
1990-04-02	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-03	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-04	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-05	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-06	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-07	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-08	10	3	1	1990	1990-04-02	1990-04-08	2
1990-04-09	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-10	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-11	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-12	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-13	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-14	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-15	11	3	1	1990	1990-04-09	1990-04-15	3
1990-04-16	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-17	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-18	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-19	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-20	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-21	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-22	12	3	1	1990	1990-04-16	1990-04-22	4
1990-04-23	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-24	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-25	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-26	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-27	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-28	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-29	13	3	1	1990	1990-04-23	1990-04-29	5
1990-04-30	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-01	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-02	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-03	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-04	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-05	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-06	14	4	2	1990	1990-04-30	1990-05-06	1
1990-05-07	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-08	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-09	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-10	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-11	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-12	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-13	15	4	2	1990	1990-05-07	1990-05-13	2
1990-05-14	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-15	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-16	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-17	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-18	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-19	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-20	16	4	2	1990	1990-05-14	1990-05-20	3
1990-05-21	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-22	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-23	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-24	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-25	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-26	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-27	17	4	2	1990	1990-05-21	1990-05-27	4
1990-05-28	18	5	2	1990	1990-05-28	1990-06-03	1
1990-05-29	18	5	2	1990	1990-05-28	1990-06-03	1
1990-05-30	18	5	2	1990	1990-05-28	1990-06-03	1
1990-05-31	18	5	2	1990	1990-05-28	1990-06-03	1
1990-06-01	18	5	2	1990	1990-05-28	1990-06-03	1
1990-06-02	18	5	2	1990	1990-05-28	1990-06-03	1
1990-06-03	18	5	2	1990	1990-05-28	1990-06-03	1
1990-06-04	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-05	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-06	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-07	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-08	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-09	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-10	19	5	2	1990	1990-06-04	1990-06-10	2
1990-06-11	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-12	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-13	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-14	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-15	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-16	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-17	20	5	2	1990	1990-06-11	1990-06-17	2
1990-06-18	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-19	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-20	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-21	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-22	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-23	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-24	21	5	2	1990	1990-06-18	1990-06-24	3
1990-06-25	22	6	2	1990	1990-06-25	1990-07-01	1
1990-06-26	22	6	2	1990	1990-06-25	1990-07-01	1
1990-06-27	22	6	2	1990	1990-06-25	1990-07-01	1
1990-06-28	22	6	2	1990	1990-06-25	1990-07-01	1
1990-06-29	22	6	2	1990	1990-06-25	1990-07-01	1
1990-06-30	22	6	2	1990	1990-06-25	1990-07-01	1
1990-07-01	22	6	2	1990	1990-06-25	1990-07-01	1
1990-07-02	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-03	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-04	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-05	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-06	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-07	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-08	23	6	2	1990	1990-07-02	1990-07-08	2
1990-07-09	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-10	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-11	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-12	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-13	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-14	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-15	24	6	2	1990	1990-07-09	1990-07-15	3
1990-07-16	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-17	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-18	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-19	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-20	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-21	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-22	25	6	2	1990	1990-07-16	1990-07-22	4
1990-07-23	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-24	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-25	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-26	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-27	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-28	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-29	26	6	2	1990	1990-07-23	1990-07-29	5
1990-07-30	27	7	2	1990	1990-07-30	1990-08-05	1
1990-07-31	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-01	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-02	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-03	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-04	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-05	27	7	2	1990	1990-07-30	1990-08-05	1
1990-08-06	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-07	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-08	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-09	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-10	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-11	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-12	28	7	2	1990	1990-08-06	1990-08-12	2
1990-08-13	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-14	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-15	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-16	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-17	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-18	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-19	29	7	2	1990	1990-08-13	1990-08-19	3
1990-08-20	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-21	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-22	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-23	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-24	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-25	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-26	30	7	2	1990	1990-08-20	1990-08-26	4
1990-08-27	31	8	3	1990	1990-08-27	1990-09-02	1
1990-08-28	31	8	3	1990	1990-08-27	1990-09-02	1
1990-08-29	31	8	3	1990	1990-08-27	1990-09-02	1
1990-08-30	31	8	3	1990	1990-08-27	1990-09-02	1
1990-08-31	31	8	3	1990	1990-08-27	1990-09-02	1
1990-09-01	31	8	3	1990	1990-08-27	1990-09-02	1
1990-09-02	31	8	3	1990	1990-08-27	1990-09-02	1
1990-09-03	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-04	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-05	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-06	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-07	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-08	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-09	32	8	3	1990	1990-09-03	1990-09-09	2
1990-09-10	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-11	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-12	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-13	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-14	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-15	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-16	33	8	3	1990	1990-09-10	1990-09-16	3
1990-09-17	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-18	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-19	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-20	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-21	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-22	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-23	34	8	3	1990	1990-09-17	1990-09-23	4
1990-09-24	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-25	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-26	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-27	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-28	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-29	35	9	3	1990	1990-09-24	1990-09-30	1
1990-09-30	35	9	3	1990	1990-09-24	1990-09-30	1
1990-10-01	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-02	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-03	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-04	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-05	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-06	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-07	36	9	3	1990	1990-10-01	1990-10-07	2
1990-10-08	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-09	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-10	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-11	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-12	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-13	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-14	37	9	3	1990	1990-10-08	1990-10-14	3
1990-10-15	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-16	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-17	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-18	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-19	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-20	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-21	38	9	3	1990	1990-10-15	1990-10-21	4
1990-10-22	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-23	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-24	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-25	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-26	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-27	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-28	39	9	3	1990	1990-10-22	1990-10-28	5
1990-10-29	40	10	3	1990	1990-10-29	1990-11-04	1
1990-10-30	40	10	3	1990	1990-10-29	1990-11-04	1
1990-10-31	40	10	3	1990	1990-10-29	1990-11-04	1
1990-11-01	40	10	3	1990	1990-10-29	1990-11-04	1
1990-11-02	40	10	3	1990	1990-10-29	1990-11-04	1
1990-11-03	40	10	3	1990	1990-10-29	1990-11-04	1
1990-11-04	40	10	3	1990	1990-10-29	1990-11-04	1
1990-11-05	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-06	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-07	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-08	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-09	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-10	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-11	41	10	3	1990	1990-11-05	1990-11-11	2
1990-11-12	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-13	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-14	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-15	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-16	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-17	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-18	42	10	3	1990	1990-11-12	1990-11-18	3
1990-11-19	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-20	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-21	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-22	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-23	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-24	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-25	43	10	3	1990	1990-11-19	1990-11-25	4
1990-11-26	44	11	3	1990	1990-11-26	1990-12-02	1
1990-11-27	44	11	3	1990	1990-11-26	1990-12-02	1
1990-11-28	44	11	3	1990	1990-11-26	1990-12-02	1
1990-11-29	44	11	3	1990	1990-11-26	1990-12-02	1
1990-11-30	44	11	3	1990	1990-11-26	1990-12-02	1
1990-12-01	44	11	3	1990	1990-11-26	1990-12-02	1
1990-12-02	44	11	3	1990	1990-11-26	1990-12-02	1
1990-12-03	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-04	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-05	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-06	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-07	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-08	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-09	45	11	3	1990	1990-12-03	1990-12-09	2
1990-12-10	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-11	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-12	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-13	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-14	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-15	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-16	46	11	3	1990	1990-12-10	1990-12-16	3
1990-12-17	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-18	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-19	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-20	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-21	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-22	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-23	47	11	3	1990	1990-12-17	1990-12-23	4
1990-12-24	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-25	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-26	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-27	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-28	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-29	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-30	48	12	4	1990	1990-12-24	1990-12-30	1
1990-12-31	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-01	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-02	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-03	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-04	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-05	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-06	49	12	4	1990	1990-12-31	1991-01-06	2
1991-01-07	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-08	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-09	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-10	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-11	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-12	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-13	50	12	4	1990	1991-01-07	1991-01-13	3
1991-01-14	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-15	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-16	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-17	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-18	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-19	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-20	51	12	4	1990	1991-01-14	1991-01-20	4
1991-01-21	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-22	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-23	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-24	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-25	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-26	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-27	52	12	4	1990	1991-01-21	1991-01-27	5
1991-01-28	53	12	4	1990	1991-01-28	1991-02-03	6
1991-01-29	53	12	4	1990	1991-01-28	1991-02-03	6
1991-01-30	53	12	4	1990	1991-01-28	1991-02-03	6
1991-01-31	53	12	4	1990	1991-01-28	1991-02-03	6
1991-02-01	53	12	4	1990	1991-01-28	1991-02-03	6
1991-02-02	53	12	4	1990	1991-01-28	1991-02-03	6
1991-02-03	53	12	4	1990	1991-01-28	1991-02-03	6
1991-02-04	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-05	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-06	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-07	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-08	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-09	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-10	1	1	1	1991	1991-02-04	1991-02-10	1
1991-02-11	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-12	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-13	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-14	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-15	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-16	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-17	2	1	1	1991	1991-02-11	1991-02-17	2
1991-02-18	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-19	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-20	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-21	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-22	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-23	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-24	3	1	1	1991	1991-02-18	1991-02-24	3
1991-02-25	4	1	1	1991	1991-02-25	1991-03-03	4
1991-02-26	4	1	1	1991	1991-02-25	1991-03-03	4
1991-02-27	4	1	1	1991	1991-02-25	1991-03-03	4
1991-02-28	4	1	1	1991	1991-02-25	1991-03-03	4
1991-03-01	4	1	1	1991	1991-02-25	1991-03-03	4
1991-03-02	4	1	1	1991	1991-02-25	1991-03-03	4
1991-03-03	4	1	1	1991	1991-02-25	1991-03-03	4
1991-03-04	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-05	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-06	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-07	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-08	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-09	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-10	5	2	1	1991	1991-03-04	1991-03-10	1
1991-03-11	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-12	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-13	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-14	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-15	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-16	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-17	6	2	1	1991	1991-03-11	1991-03-17	2
1991-03-18	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-19	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-20	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-21	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-22	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-23	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-24	7	2	1	1991	1991-03-18	1991-03-24	3
1991-03-25	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-26	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-27	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-28	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-29	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-30	8	2	1	1991	1991-03-25	1991-03-31	4
1991-03-31	8	2	1	1991	1991-03-25	1991-03-31	4
1991-04-01	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-02	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-03	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-04	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-05	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-06	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-07	9	3	1	1991	1991-04-01	1991-04-07	1
1991-04-08	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-09	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-10	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-11	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-12	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-13	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-14	10	3	1	1991	1991-04-08	1991-04-14	2
1991-04-15	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-16	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-17	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-18	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-19	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-20	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-21	11	3	1	1991	1991-04-15	1991-04-21	3
1991-04-22	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-23	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-24	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-25	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-26	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-27	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-28	12	3	1	1991	1991-04-22	1991-04-28	4
1991-04-29	13	3	1	1991	1991-04-29	1991-05-05	5
1991-04-30	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-01	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-02	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-03	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-04	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-05	13	3	1	1991	1991-04-29	1991-05-05	5
1991-05-06	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-07	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-08	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-09	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-10	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-11	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-12	14	4	2	1991	1991-05-06	1991-05-12	1
1991-05-13	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-14	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-15	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-16	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-17	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-18	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-19	15	4	2	1991	1991-05-13	1991-05-19	2
1991-05-20	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-21	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-22	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-23	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-24	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-25	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-26	16	4	2	1991	1991-05-20	1991-05-26	3
1991-05-27	17	4	2	1991	1991-05-27	1991-06-02	4
1991-05-28	17	4	2	1991	1991-05-27	1991-06-02	4
1991-05-29	17	4	2	1991	1991-05-27	1991-06-02	4
1991-05-30	17	4	2	1991	1991-05-27	1991-06-02	4
1991-05-31	17	4	2	1991	1991-05-27	1991-06-02	4
1991-06-01	17	4	2	1991	1991-05-27	1991-06-02	4
1991-06-02	17	4	2	1991	1991-05-27	1991-06-02	4
1991-06-03	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-04	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-05	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-06	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-07	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-08	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-09	18	5	2	1991	1991-06-03	1991-06-09	1
1991-06-10	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-11	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-12	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-13	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-14	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-15	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-16	19	5	2	1991	1991-06-10	1991-06-16	2
1991-06-17	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-18	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-19	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-20	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-21	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-22	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-23	20	5	2	1991	1991-06-17	1991-06-23	3
1991-06-24	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-25	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-26	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-27	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-28	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-29	21	5	2	1991	1991-06-24	1991-06-30	4
1991-06-30	21	5	2	1991	1991-06-24	1991-06-30	4
1991-07-01	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-02	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-03	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-04	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-05	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-06	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-07	22	6	2	1991	1991-07-01	1991-07-07	1
1991-07-08	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-09	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-10	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-11	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-12	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-13	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-14	23	6	2	1991	1991-07-08	1991-07-14	2
1991-07-15	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-16	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-17	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-18	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-19	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-20	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-21	24	6	2	1991	1991-07-15	1991-07-21	3
1991-07-22	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-23	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-24	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-25	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-26	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-27	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-28	25	6	2	1991	1991-07-22	1991-07-28	4
1991-07-29	26	6	2	1991	1991-07-29	1991-08-04	5
1991-07-30	26	6	2	1991	1991-07-29	1991-08-04	5
1991-07-31	26	6	2	1991	1991-07-29	1991-08-04	5
1991-08-01	26	6	2	1991	1991-07-29	1991-08-04	5
1991-08-02	26	6	2	1991	1991-07-29	1991-08-04	5
1991-08-03	26	6	2	1991	1991-07-29	1991-08-04	5
1991-08-04	26	6	2	1991	1991-07-29	1991-08-04	5
1991-08-05	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-06	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-07	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-08	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-09	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-10	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-11	27	7	2	1991	1991-08-05	1991-08-11	1
1991-08-12	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-13	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-14	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-15	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-16	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-17	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-18	28	7	2	1991	1991-08-12	1991-08-18	2
1991-08-19	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-20	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-21	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-22	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-23	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-24	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-25	29	7	2	1991	1991-08-19	1991-08-25	3
1991-08-26	30	7	2	1991	1991-08-26	1991-09-01	4
1991-08-27	30	7	2	1991	1991-08-26	1991-09-01	4
1991-08-28	30	7	2	1991	1991-08-26	1991-09-01	4
1991-08-29	30	7	2	1991	1991-08-26	1991-09-01	4
1991-08-30	30	7	2	1991	1991-08-26	1991-09-01	4
1991-08-31	30	7	2	1991	1991-08-26	1991-09-01	4
1991-09-01	30	7	2	1991	1991-08-26	1991-09-01	4
1991-09-02	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-03	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-04	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-05	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-06	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-07	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-08	31	8	3	1991	1991-09-02	1991-09-08	1
1991-09-09	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-10	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-11	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-12	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-13	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-14	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-15	32	8	3	1991	1991-09-09	1991-09-15	2
1991-09-16	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-17	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-18	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-19	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-20	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-21	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-22	33	8	3	1991	1991-09-16	1991-09-22	3
1991-09-23	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-24	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-25	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-26	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-27	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-28	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-29	34	8	3	1991	1991-09-23	1991-09-29	4
1991-09-30	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-01	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-02	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-03	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-04	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-05	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-06	35	9	3	1991	1991-09-30	1991-10-06	1
1991-10-07	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-08	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-09	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-10	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-11	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-12	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-13	36	9	3	1991	1991-10-07	1991-10-13	2
1991-10-14	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-15	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-16	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-17	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-18	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-19	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-20	37	9	3	1991	1991-10-14	1991-10-20	3
1991-10-21	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-22	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-23	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-24	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-25	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-26	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-27	38	9	3	1991	1991-10-21	1991-10-27	4
1991-10-28	39	9	3	1991	1991-10-28	1991-11-03	5
1991-10-29	39	9	3	1991	1991-10-28	1991-11-03	5
1991-10-30	39	9	3	1991	1991-10-28	1991-11-03	5
1991-10-31	39	9	3	1991	1991-10-28	1991-11-03	5
1991-11-01	39	9	3	1991	1991-10-28	1991-11-03	5
1991-11-02	39	9	3	1991	1991-10-28	1991-11-03	5
1991-11-03	39	9	3	1991	1991-10-28	1991-11-03	5
1991-11-04	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-05	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-06	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-07	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-08	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-09	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-10	40	10	3	1991	1991-11-04	1991-11-10	1
1991-11-11	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-12	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-13	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-14	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-15	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-16	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-17	41	10	3	1991	1991-11-11	1991-11-17	2
1991-11-18	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-19	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-20	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-21	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-22	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-23	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-24	42	10	3	1991	1991-11-18	1991-11-24	3
1991-11-25	43	10	3	1991	1991-11-25	1991-12-01	4
1991-11-26	43	10	3	1991	1991-11-25	1991-12-01	4
1991-11-27	43	10	3	1991	1991-11-25	1991-12-01	4
1991-11-28	43	10	3	1991	1991-11-25	1991-12-01	4
1991-11-29	43	10	3	1991	1991-11-25	1991-12-01	4
1991-11-30	43	10	3	1991	1991-11-25	1991-12-01	4
1991-12-01	43	10	3	1991	1991-11-25	1991-12-01	4
1991-12-02	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-03	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-04	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-05	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-06	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-07	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-08	44	11	3	1991	1991-12-02	1991-12-08	1
1991-12-09	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-10	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-11	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-12	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-13	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-14	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-15	45	11	3	1991	1991-12-09	1991-12-15	2
1991-12-16	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-17	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-18	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-19	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-20	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-21	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-22	46	11	3	1991	1991-12-16	1991-12-22	3
1991-12-23	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-24	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-25	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-26	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-27	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-28	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-29	47	11	3	1991	1991-12-23	1991-12-29	4
1991-12-30	48	12	4	1991	1991-12-30	1992-01-05	1
1991-12-31	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-01	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-02	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-03	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-04	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-05	48	12	4	1991	1991-12-30	1992-01-05	1
1992-01-06	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-07	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-08	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-09	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-10	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-11	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-12	49	12	4	1991	1992-01-06	1992-01-12	2
1992-01-13	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-14	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-15	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-16	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-17	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-18	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-19	50	12	4	1991	1992-01-13	1992-01-19	3
1992-01-20	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-21	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-22	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-23	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-24	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-25	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-26	51	12	4	1991	1992-01-20	1992-01-26	4
1992-01-27	52	12	4	1991	1992-01-27	1992-02-02	5
1992-01-28	52	12	4	1991	1992-01-27	1992-02-02	5
1992-01-29	52	12	4	1991	1992-01-27	1992-02-02	5
1992-01-30	52	12	4	1991	1992-01-27	1992-02-02	5
1992-01-31	52	12	4	1991	1992-01-27	1992-02-02	5
1992-02-01	52	12	4	1991	1992-01-27	1992-02-02	5
1992-02-02	52	12	4	1991	1992-01-27	1992-02-02	5
1992-02-03	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-04	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-05	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-06	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-07	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-08	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-09	1	1	1	1992	1992-02-03	1992-02-09	1
1992-02-10	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-11	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-12	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-13	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-14	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-15	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-16	2	1	1	1992	1992-02-10	1992-02-16	2
1992-02-17	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-18	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-19	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-20	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-21	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-22	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-23	3	1	1	1992	1992-02-17	1992-02-23	3
1992-02-24	4	1	1	1992	1992-02-24	1992-03-01	4
1992-02-25	4	1	1	1992	1992-02-24	1992-03-01	4
1992-02-26	4	1	1	1992	1992-02-24	1992-03-01	4
1992-02-27	4	1	1	1992	1992-02-24	1992-03-01	4
1992-02-28	4	1	1	1992	1992-02-24	1992-03-01	4
1992-02-29	4	1	1	1992	1992-02-24	1992-03-01	4
1992-03-01	4	1	1	1992	1992-02-24	1992-03-01	4
1992-03-02	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-03	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-04	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-05	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-06	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-07	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-08	5	2	1	1992	1992-03-02	1992-03-08	1
1992-03-09	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-10	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-11	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-12	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-13	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-14	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-15	6	2	1	1992	1992-03-09	1992-03-15	2
1992-03-16	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-17	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-18	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-19	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-20	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-21	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-22	7	2	1	1992	1992-03-16	1992-03-22	3
1992-03-23	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-24	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-25	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-26	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-27	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-28	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-29	8	2	1	1992	1992-03-23	1992-03-29	4
1992-03-30	9	3	1	1992	1992-03-30	1992-04-05	1
1992-03-31	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-01	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-02	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-03	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-04	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-05	9	3	1	1992	1992-03-30	1992-04-05	1
1992-04-06	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-07	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-08	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-09	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-10	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-11	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-12	10	3	1	1992	1992-04-06	1992-04-12	2
1992-04-13	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-14	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-15	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-16	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-17	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-18	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-19	11	3	1	1992	1992-04-13	1992-04-19	3
1992-04-20	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-21	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-22	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-23	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-24	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-25	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-26	12	3	1	1992	1992-04-20	1992-04-26	4
1992-04-27	13	3	1	1992	1992-04-27	1992-05-03	5
1992-04-28	13	3	1	1992	1992-04-27	1992-05-03	5
1992-04-29	13	3	1	1992	1992-04-27	1992-05-03	5
1992-04-30	13	3	1	1992	1992-04-27	1992-05-03	5
1992-05-01	13	3	1	1992	1992-04-27	1992-05-03	5
1992-05-02	13	3	1	1992	1992-04-27	1992-05-03	5
1992-05-03	13	3	1	1992	1992-04-27	1992-05-03	5
1992-05-04	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-05	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-06	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-07	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-08	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-09	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-10	14	4	2	1992	1992-05-04	1992-05-10	1
1992-05-11	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-12	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-13	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-14	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-15	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-16	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-17	15	4	2	1992	1992-05-11	1992-05-17	2
1992-05-18	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-19	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-20	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-21	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-22	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-23	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-24	16	4	2	1992	1992-05-18	1992-05-24	3
1992-05-25	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-26	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-27	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-28	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-29	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-30	17	4	2	1992	1992-05-25	1992-05-31	4
1992-05-31	17	4	2	1992	1992-05-25	1992-05-31	4
1992-06-01	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-02	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-03	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-04	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-05	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-06	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-07	18	5	2	1992	1992-06-01	1992-06-07	1
1992-06-08	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-09	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-10	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-11	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-12	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-13	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-14	19	5	2	1992	1992-06-08	1992-06-14	2
1992-06-15	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-16	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-17	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-18	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-19	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-20	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-21	20	5	2	1992	1992-06-15	1992-06-21	3
1992-06-22	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-23	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-24	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-25	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-26	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-27	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-28	21	5	2	1992	1992-06-22	1992-06-28	4
1992-06-29	22	6	2	1992	1992-06-29	1992-07-05	1
1992-06-30	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-01	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-02	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-03	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-04	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-05	22	6	2	1992	1992-06-29	1992-07-05	1
1992-07-06	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-07	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-08	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-09	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-10	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-11	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-12	23	6	2	1992	1992-07-06	1992-07-12	2
1992-07-13	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-14	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-15	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-16	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-17	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-18	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-19	24	6	2	1992	1992-07-13	1992-07-19	3
1992-07-20	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-21	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-22	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-23	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-24	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-25	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-26	25	6	2	1992	1992-07-20	1992-07-26	4
1992-07-27	26	6	2	1992	1992-07-27	1992-08-02	5
1992-07-28	26	6	2	1992	1992-07-27	1992-08-02	5
1992-07-29	26	6	2	1992	1992-07-27	1992-08-02	5
1992-07-30	26	6	2	1992	1992-07-27	1992-08-02	5
1992-07-31	26	6	2	1992	1992-07-27	1992-08-02	5
1992-08-01	26	6	2	1992	1992-07-27	1992-08-02	5
1992-08-02	26	6	2	1992	1992-07-27	1992-08-02	5
1992-08-03	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-04	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-05	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-06	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-07	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-08	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-09	27	7	2	1992	1992-08-03	1992-08-09	1
1992-08-10	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-11	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-12	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-13	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-14	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-15	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-16	28	7	2	1992	1992-08-10	1992-08-16	2
1992-08-17	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-18	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-19	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-20	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-21	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-22	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-23	29	7	2	1992	1992-08-17	1992-08-23	3
1992-08-24	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-25	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-26	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-27	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-28	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-29	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-30	30	7	2	1992	1992-08-24	1992-08-30	4
1992-08-31	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-01	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-02	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-03	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-04	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-05	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-06	31	8	3	1992	1992-08-31	1992-09-06	1
1992-09-07	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-08	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-09	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-10	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-11	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-12	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-13	32	8	3	1992	1992-09-07	1992-09-13	2
1992-09-14	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-15	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-16	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-17	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-18	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-19	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-20	33	8	3	1992	1992-09-14	1992-09-20	3
1992-09-21	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-22	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-23	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-24	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-25	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-26	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-27	34	8	3	1992	1992-09-21	1992-09-27	4
1992-09-28	35	9	3	1992	1992-09-28	1992-10-04	1
1992-09-29	35	9	3	1992	1992-09-28	1992-10-04	1
1992-09-30	35	9	3	1992	1992-09-28	1992-10-04	1
1992-10-01	35	9	3	1992	1992-09-28	1992-10-04	1
1992-10-02	35	9	3	1992	1992-09-28	1992-10-04	1
1992-10-03	35	9	3	1992	1992-09-28	1992-10-04	1
1992-10-04	35	9	3	1992	1992-09-28	1992-10-04	1
1992-10-05	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-06	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-07	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-08	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-09	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-10	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-11	36	9	3	1992	1992-10-05	1992-10-11	2
1992-10-12	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-13	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-14	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-15	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-16	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-17	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-18	37	9	3	1992	1992-10-12	1992-10-18	3
1992-10-19	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-20	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-21	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-22	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-23	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-24	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-25	38	9	3	1992	1992-10-19	1992-10-25	4
1992-10-26	39	9	3	1992	1992-10-26	1992-11-01	5
1992-10-27	39	9	3	1992	1992-10-26	1992-11-01	5
1992-10-28	39	9	3	1992	1992-10-26	1992-11-01	5
1992-10-29	39	9	3	1992	1992-10-26	1992-11-01	5
1992-10-30	39	9	3	1992	1992-10-26	1992-11-01	5
1992-10-31	39	9	3	1992	1992-10-26	1992-11-01	5
1992-11-01	39	9	3	1992	1992-10-26	1992-11-01	5
1992-11-02	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-03	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-04	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-05	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-06	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-07	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-08	40	10	3	1992	1992-11-02	1992-11-08	1
1992-11-09	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-10	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-11	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-12	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-13	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-14	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-15	41	10	3	1992	1992-11-09	1992-11-15	2
1992-11-16	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-17	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-18	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-19	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-20	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-21	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-22	42	10	3	1992	1992-11-16	1992-11-22	3
1992-11-23	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-24	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-25	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-26	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-27	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-28	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-29	43	10	3	1992	1992-11-23	1992-11-29	4
1992-11-30	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-01	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-02	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-03	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-04	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-05	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-06	44	11	3	1992	1992-11-30	1992-12-06	1
1992-12-07	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-08	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-09	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-10	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-11	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-12	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-13	45	11	3	1992	1992-12-07	1992-12-13	2
1992-12-14	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-15	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-16	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-17	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-18	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-19	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-20	46	11	3	1992	1992-12-14	1992-12-20	3
1992-12-21	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-22	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-23	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-24	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-25	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-26	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-27	47	11	3	1992	1992-12-21	1992-12-27	4
1992-12-28	48	12	4	1992	1992-12-28	1993-01-03	1
1992-12-29	48	12	4	1992	1992-12-28	1993-01-03	1
1992-12-30	48	12	4	1992	1992-12-28	1993-01-03	1
1992-12-31	48	12	4	1992	1992-12-28	1993-01-03	1
1993-01-01	48	12	4	1992	1992-12-28	1993-01-03	1
1993-01-02	48	12	4	1992	1992-12-28	1993-01-03	1
1993-01-03	48	12	4	1992	1992-12-28	1993-01-03	1
1993-01-04	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-05	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-06	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-07	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-08	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-09	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-10	49	12	4	1992	1993-01-04	1993-01-10	2
1993-01-11	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-12	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-13	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-14	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-15	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-16	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-17	50	12	4	1992	1993-01-11	1993-01-17	3
1993-01-18	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-19	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-20	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-21	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-22	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-23	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-24	51	12	4	1992	1993-01-18	1993-01-24	4
1993-01-25	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-26	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-27	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-28	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-29	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-30	52	12	4	1992	1993-01-25	1993-01-31	5
1993-01-31	52	12	4	1992	1993-01-25	1993-01-31	5
1993-02-01	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-02	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-03	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-04	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-05	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-06	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-07	1	1	1	1993	1993-02-01	1993-02-07	1
1993-02-08	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-09	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-10	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-11	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-12	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-13	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-14	2	1	1	1993	1993-02-08	1993-02-14	2
1993-02-15	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-16	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-17	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-18	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-19	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-20	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-21	3	1	1	1993	1993-02-15	1993-02-21	3
1993-02-22	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-23	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-24	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-25	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-26	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-27	4	1	1	1993	1993-02-22	1993-02-28	4
1993-02-28	4	1	1	1993	1993-02-22	1993-02-28	4
1993-03-01	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-02	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-03	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-04	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-05	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-06	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-07	5	2	1	1993	1993-03-01	1993-03-07	1
1993-03-08	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-09	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-10	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-11	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-12	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-13	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-14	6	2	1	1993	1993-03-08	1993-03-14	2
1993-03-15	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-16	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-17	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-18	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-19	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-20	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-21	7	2	1	1993	1993-03-15	1993-03-21	3
1993-03-22	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-23	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-24	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-25	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-26	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-27	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-28	8	2	1	1993	1993-03-22	1993-03-28	4
1993-03-29	9	3	1	1993	1993-03-29	1993-04-04	1
1993-03-30	9	3	1	1993	1993-03-29	1993-04-04	1
1993-03-31	9	3	1	1993	1993-03-29	1993-04-04	1
1993-04-01	9	3	1	1993	1993-03-29	1993-04-04	1
1993-04-02	9	3	1	1993	1993-03-29	1993-04-04	1
1993-04-03	9	3	1	1993	1993-03-29	1993-04-04	1
1993-04-04	9	3	1	1993	1993-03-29	1993-04-04	1
1993-04-05	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-06	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-07	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-08	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-09	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-10	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-11	10	3	1	1993	1993-04-05	1993-04-11	2
1993-04-12	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-13	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-14	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-15	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-16	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-17	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-18	11	3	1	1993	1993-04-12	1993-04-18	3
1993-04-19	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-20	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-21	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-22	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-23	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-24	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-25	12	3	1	1993	1993-04-19	1993-04-25	4
1993-04-26	13	3	1	1993	1993-04-26	1993-05-02	5
1993-04-27	13	3	1	1993	1993-04-26	1993-05-02	5
1993-04-28	13	3	1	1993	1993-04-26	1993-05-02	5
1993-04-29	13	3	1	1993	1993-04-26	1993-05-02	5
1993-04-30	13	3	1	1993	1993-04-26	1993-05-02	5
1993-05-01	13	3	1	1993	1993-04-26	1993-05-02	5
1993-05-02	13	3	1	1993	1993-04-26	1993-05-02	5
1993-05-03	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-04	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-05	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-06	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-07	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-08	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-09	14	4	2	1993	1993-05-03	1993-05-09	1
1993-05-10	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-11	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-12	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-13	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-14	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-15	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-16	15	4	2	1993	1993-05-10	1993-05-16	2
1993-05-17	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-18	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-19	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-20	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-21	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-22	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-23	16	4	2	1993	1993-05-17	1993-05-23	3
1993-05-24	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-25	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-26	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-27	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-28	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-29	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-30	17	4	2	1993	1993-05-24	1993-05-30	4
1993-05-31	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-01	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-02	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-03	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-04	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-05	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-06	18	5	2	1993	1993-05-31	1993-06-06	1
1993-06-07	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-08	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-09	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-10	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-11	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-12	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-13	19	5	2	1993	1993-06-07	1993-06-13	2
1993-06-14	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-15	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-16	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-17	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-18	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-19	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-20	20	5	2	1993	1993-06-14	1993-06-20	3
1993-06-21	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-22	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-23	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-24	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-25	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-26	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-27	21	5	2	1993	1993-06-21	1993-06-27	4
1993-06-28	22	6	2	1993	1993-06-28	1993-07-04	1
1993-06-29	22	6	2	1993	1993-06-28	1993-07-04	1
1993-06-30	22	6	2	1993	1993-06-28	1993-07-04	1
1993-07-01	22	6	2	1993	1993-06-28	1993-07-04	1
1993-07-02	22	6	2	1993	1993-06-28	1993-07-04	1
1993-07-03	22	6	2	1993	1993-06-28	1993-07-04	1
1993-07-04	22	6	2	1993	1993-06-28	1993-07-04	1
1993-07-05	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-06	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-07	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-08	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-09	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-10	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-11	23	6	2	1993	1993-07-05	1993-07-11	2
1993-07-12	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-13	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-14	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-15	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-16	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-17	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-18	24	6	2	1993	1993-07-12	1993-07-18	3
1993-07-19	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-20	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-21	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-22	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-23	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-24	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-25	25	6	2	1993	1993-07-19	1993-07-25	4
1993-07-26	26	6	2	1993	1993-07-26	1993-08-01	5
1993-07-27	26	6	2	1993	1993-07-26	1993-08-01	5
1993-07-28	26	6	2	1993	1993-07-26	1993-08-01	5
1993-07-29	26	6	2	1993	1993-07-26	1993-08-01	5
1993-07-30	26	6	2	1993	1993-07-26	1993-08-01	5
1993-07-31	26	6	2	1993	1993-07-26	1993-08-01	5
1993-08-01	26	6	2	1993	1993-07-26	1993-08-01	5
1993-08-02	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-03	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-04	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-05	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-06	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-07	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-08	27	7	2	1993	1993-08-02	1993-08-08	1
1993-08-09	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-10	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-11	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-12	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-13	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-14	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-15	28	7	2	1993	1993-08-09	1993-08-15	2
1993-08-16	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-17	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-18	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-19	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-20	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-21	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-22	29	7	2	1993	1993-08-16	1993-08-22	3
1993-08-23	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-24	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-25	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-26	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-27	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-28	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-29	30	7	2	1993	1993-08-23	1993-08-29	4
1993-08-30	31	8	3	1993	1993-08-30	1993-09-05	1
1993-08-31	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-01	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-02	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-03	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-04	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-05	31	8	3	1993	1993-08-30	1993-09-05	1
1993-09-06	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-07	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-08	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-09	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-10	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-11	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-12	32	8	3	1993	1993-09-06	1993-09-12	2
1993-09-13	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-14	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-15	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-16	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-17	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-18	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-19	33	8	3	1993	1993-09-13	1993-09-19	3
1993-09-20	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-21	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-22	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-23	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-24	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-25	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-26	34	8	3	1993	1993-09-20	1993-09-26	4
1993-09-27	35	9	3	1993	1993-09-27	1993-10-03	1
1993-09-28	35	9	3	1993	1993-09-27	1993-10-03	1
1993-09-29	35	9	3	1993	1993-09-27	1993-10-03	1
1993-09-30	35	9	3	1993	1993-09-27	1993-10-03	1
1993-10-01	35	9	3	1993	1993-09-27	1993-10-03	1
1993-10-02	35	9	3	1993	1993-09-27	1993-10-03	1
1993-10-03	35	9	3	1993	1993-09-27	1993-10-03	1
1993-10-04	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-05	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-06	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-07	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-08	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-09	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-10	36	9	3	1993	1993-10-04	1993-10-10	2
1993-10-11	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-12	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-13	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-14	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-15	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-16	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-17	37	9	3	1993	1993-10-11	1993-10-17	3
1993-10-18	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-19	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-20	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-21	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-22	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-23	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-24	38	9	3	1993	1993-10-18	1993-10-24	4
1993-10-25	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-26	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-27	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-28	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-29	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-30	39	9	3	1993	1993-10-25	1993-10-31	5
1993-10-31	39	9	3	1993	1993-10-25	1993-10-31	5
1993-11-01	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-02	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-03	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-04	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-05	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-06	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-07	40	10	3	1993	1993-11-01	1993-11-07	1
1993-11-08	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-09	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-10	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-11	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-12	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-13	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-14	41	10	3	1993	1993-11-08	1993-11-14	2
1993-11-15	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-16	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-17	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-18	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-19	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-20	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-21	42	10	3	1993	1993-11-15	1993-11-21	3
1993-11-22	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-23	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-24	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-25	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-26	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-27	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-28	43	10	3	1993	1993-11-22	1993-11-28	4
1993-11-29	44	11	3	1993	1993-11-29	1993-12-05	1
1993-11-30	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-01	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-02	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-03	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-04	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-05	44	11	3	1993	1993-11-29	1993-12-05	1
1993-12-06	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-07	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-08	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-09	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-10	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-11	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-12	45	11	3	1993	1993-12-06	1993-12-12	2
1993-12-13	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-14	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-15	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-16	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-17	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-18	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-19	46	11	3	1993	1993-12-13	1993-12-19	3
1993-12-20	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-21	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-22	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-23	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-24	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-25	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-26	47	11	3	1993	1993-12-20	1993-12-26	4
1993-12-27	48	12	4	1993	1993-12-27	1994-01-02	1
1993-12-28	48	12	4	1993	1993-12-27	1994-01-02	1
1993-12-29	48	12	4	1993	1993-12-27	1994-01-02	1
1993-12-30	48	12	4	1993	1993-12-27	1994-01-02	1
1993-12-31	48	12	4	1993	1993-12-27	1994-01-02	1
1994-01-01	48	12	4	1993	1993-12-27	1994-01-02	1
1994-01-02	48	12	4	1993	1993-12-27	1994-01-02	1
1994-01-03	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-04	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-05	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-06	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-07	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-08	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-09	49	12	4	1993	1994-01-03	1994-01-09	2
1994-01-10	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-11	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-12	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-13	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-14	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-15	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-16	50	12	4	1993	1994-01-10	1994-01-16	3
1994-01-17	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-18	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-19	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-20	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-21	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-22	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-23	51	12	4	1993	1994-01-17	1994-01-23	4
1994-01-24	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-25	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-26	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-27	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-28	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-29	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-30	52	12	4	1993	1994-01-24	1994-01-30	5
1994-01-31	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-01	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-02	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-03	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-04	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-05	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-06	1	1	1	1994	1994-01-31	1994-02-06	1
1994-02-07	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-08	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-09	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-10	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-11	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-12	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-13	2	1	1	1994	1994-02-07	1994-02-13	2
1994-02-14	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-15	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-16	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-17	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-18	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-19	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-20	3	1	1	1994	1994-02-14	1994-02-20	3
1994-02-21	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-22	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-23	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-24	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-25	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-26	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-27	4	1	1	1994	1994-02-21	1994-02-27	4
1994-02-28	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-01	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-02	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-03	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-04	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-05	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-06	5	2	1	1994	1994-02-28	1994-03-06	1
1994-03-07	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-08	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-09	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-10	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-11	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-12	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-13	6	2	1	1994	1994-03-07	1994-03-13	2
1994-03-14	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-15	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-16	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-17	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-18	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-19	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-20	7	2	1	1994	1994-03-14	1994-03-20	3
1994-03-21	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-22	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-23	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-24	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-25	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-26	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-27	8	2	1	1994	1994-03-21	1994-03-27	4
1994-03-28	9	3	1	1994	1994-03-28	1994-04-03	1
1994-03-29	9	3	1	1994	1994-03-28	1994-04-03	1
1994-03-30	9	3	1	1994	1994-03-28	1994-04-03	1
1994-03-31	9	3	1	1994	1994-03-28	1994-04-03	1
1994-04-01	9	3	1	1994	1994-03-28	1994-04-03	1
1994-04-02	9	3	1	1994	1994-03-28	1994-04-03	1
1994-04-03	9	3	1	1994	1994-03-28	1994-04-03	1
1994-04-04	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-05	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-06	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-07	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-08	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-09	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-10	10	3	1	1994	1994-04-04	1994-04-10	2
1994-04-11	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-12	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-13	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-14	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-15	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-16	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-17	11	3	1	1994	1994-04-11	1994-04-17	3
1994-04-18	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-19	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-20	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-21	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-22	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-23	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-24	12	3	1	1994	1994-04-18	1994-04-24	4
1994-04-25	13	3	1	1994	1994-04-25	1994-05-01	5
1994-04-26	13	3	1	1994	1994-04-25	1994-05-01	5
1994-04-27	13	3	1	1994	1994-04-25	1994-05-01	5
1994-04-28	13	3	1	1994	1994-04-25	1994-05-01	5
1994-04-29	13	3	1	1994	1994-04-25	1994-05-01	5
1994-04-30	13	3	1	1994	1994-04-25	1994-05-01	5
1994-05-01	13	3	1	1994	1994-04-25	1994-05-01	5
1994-05-02	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-03	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-04	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-05	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-06	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-07	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-08	14	4	2	1994	1994-05-02	1994-05-08	1
1994-05-09	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-10	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-11	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-12	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-13	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-14	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-15	15	4	2	1994	1994-05-09	1994-05-15	2
1994-05-16	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-17	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-18	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-19	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-20	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-21	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-22	16	4	2	1994	1994-05-16	1994-05-22	3
1994-05-23	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-24	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-25	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-26	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-27	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-28	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-29	17	4	2	1994	1994-05-23	1994-05-29	4
1994-05-30	18	5	2	1994	1994-05-30	1994-06-05	1
1994-05-31	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-01	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-02	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-03	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-04	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-05	18	5	2	1994	1994-05-30	1994-06-05	1
1994-06-06	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-07	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-08	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-09	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-10	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-11	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-12	19	5	2	1994	1994-06-06	1994-06-12	2
1994-06-13	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-14	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-15	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-16	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-17	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-18	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-19	20	5	2	1994	1994-06-13	1994-06-19	3
1994-06-20	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-21	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-22	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-23	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-24	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-25	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-26	21	5	2	1994	1994-06-20	1994-06-26	4
1994-06-27	22	6	2	1994	1994-06-27	1994-07-03	1
1994-06-28	22	6	2	1994	1994-06-27	1994-07-03	1
1994-06-29	22	6	2	1994	1994-06-27	1994-07-03	1
1994-06-30	22	6	2	1994	1994-06-27	1994-07-03	1
1994-07-01	22	6	2	1994	1994-06-27	1994-07-03	1
1994-07-02	22	6	2	1994	1994-06-27	1994-07-03	1
1994-07-03	22	6	2	1994	1994-06-27	1994-07-03	1
1994-07-04	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-05	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-06	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-07	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-08	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-09	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-10	23	6	2	1994	1994-07-04	1994-07-10	2
1994-07-11	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-12	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-13	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-14	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-15	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-16	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-17	24	6	2	1994	1994-07-11	1994-07-17	3
1994-07-18	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-19	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-20	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-21	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-22	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-23	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-24	25	6	2	1994	1994-07-18	1994-07-24	4
1994-07-25	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-26	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-27	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-28	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-29	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-30	26	6	2	1994	1994-07-25	1994-07-31	5
1994-07-31	26	6	2	1994	1994-07-25	1994-07-31	5
1994-08-01	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-02	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-03	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-04	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-05	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-06	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-07	27	7	2	1994	1994-08-01	1994-08-07	1
1994-08-08	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-09	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-10	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-11	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-12	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-13	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-14	28	7	2	1994	1994-08-08	1994-08-14	2
1994-08-15	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-16	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-17	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-18	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-19	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-20	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-21	29	7	2	1994	1994-08-15	1994-08-21	3
1994-08-22	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-23	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-24	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-25	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-26	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-27	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-28	30	7	2	1994	1994-08-22	1994-08-28	4
1994-08-29	31	8	3	1994	1994-08-29	1994-09-04	1
1994-08-30	31	8	3	1994	1994-08-29	1994-09-04	1
1994-08-31	31	8	3	1994	1994-08-29	1994-09-04	1
1994-09-01	31	8	3	1994	1994-08-29	1994-09-04	1
1994-09-02	31	8	3	1994	1994-08-29	1994-09-04	1
1994-09-03	31	8	3	1994	1994-08-29	1994-09-04	1
1994-09-04	31	8	3	1994	1994-08-29	1994-09-04	1
1994-09-05	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-06	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-07	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-08	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-09	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-10	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-11	32	8	3	1994	1994-09-05	1994-09-11	2
1994-09-12	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-13	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-14	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-15	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-16	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-17	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-18	33	8	3	1994	1994-09-12	1994-09-18	3
1994-09-19	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-20	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-21	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-22	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-23	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-24	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-25	34	8	3	1994	1994-09-19	1994-09-25	4
1994-09-26	35	9	3	1994	1994-09-26	1994-10-02	1
1994-09-27	35	9	3	1994	1994-09-26	1994-10-02	1
1994-09-28	35	9	3	1994	1994-09-26	1994-10-02	1
1994-09-29	35	9	3	1994	1994-09-26	1994-10-02	1
1994-09-30	35	9	3	1994	1994-09-26	1994-10-02	1
1994-10-01	35	9	3	1994	1994-09-26	1994-10-02	1
1994-10-02	35	9	3	1994	1994-09-26	1994-10-02	1
1994-10-03	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-04	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-05	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-06	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-07	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-08	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-09	36	9	3	1994	1994-10-03	1994-10-09	2
1994-10-10	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-11	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-12	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-13	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-14	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-15	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-16	37	9	3	1994	1994-10-10	1994-10-16	3
1994-10-17	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-18	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-19	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-20	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-21	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-22	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-23	38	9	3	1994	1994-10-17	1994-10-23	4
1994-10-24	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-25	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-26	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-27	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-28	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-29	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-30	39	9	3	1994	1994-10-24	1994-10-30	5
1994-10-31	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-01	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-02	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-03	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-04	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-05	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-06	40	10	3	1994	1994-10-31	1994-11-06	1
1994-11-07	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-08	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-09	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-10	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-11	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-12	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-13	41	10	3	1994	1994-11-07	1994-11-13	2
1994-11-14	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-15	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-16	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-17	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-18	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-19	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-20	42	10	3	1994	1994-11-14	1994-11-20	3
1994-11-21	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-22	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-23	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-24	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-25	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-26	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-27	43	10	3	1994	1994-11-21	1994-11-27	4
1994-11-28	44	11	3	1994	1994-11-28	1994-12-04	1
1994-11-29	44	11	3	1994	1994-11-28	1994-12-04	1
1994-11-30	44	11	3	1994	1994-11-28	1994-12-04	1
1994-12-01	44	11	3	1994	1994-11-28	1994-12-04	1
1994-12-02	44	11	3	1994	1994-11-28	1994-12-04	1
1994-12-03	44	11	3	1994	1994-11-28	1994-12-04	1
1994-12-04	44	11	3	1994	1994-11-28	1994-12-04	1
1994-12-05	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-06	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-07	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-08	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-09	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-10	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-11	45	11	3	1994	1994-12-05	1994-12-11	2
1994-12-12	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-13	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-14	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-15	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-16	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-17	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-18	46	11	3	1994	1994-12-12	1994-12-18	3
1994-12-19	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-20	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-21	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-22	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-23	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-24	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-25	47	11	3	1994	1994-12-19	1994-12-25	4
1994-12-26	48	12	4	1994	1994-12-26	1995-01-01	1
1994-12-27	48	12	4	1994	1994-12-26	1995-01-01	1
1994-12-28	48	12	4	1994	1994-12-26	1995-01-01	1
1994-12-29	48	12	4	1994	1994-12-26	1995-01-01	1
1994-12-30	48	12	4	1994	1994-12-26	1995-01-01	1
1994-12-31	48	12	4	1994	1994-12-26	1995-01-01	1
1995-01-01	48	12	4	1994	1994-12-26	1995-01-01	1
1995-01-02	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-03	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-04	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-05	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-06	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-07	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-08	49	12	4	1994	1995-01-02	1995-01-08	2
1995-01-09	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-10	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-11	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-12	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-13	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-14	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-15	50	12	4	1994	1995-01-09	1995-01-15	3
1995-01-16	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-17	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-18	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-19	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-20	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-21	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-22	51	12	4	1994	1995-01-16	1995-01-22	4
1995-01-23	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-24	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-25	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-26	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-27	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-28	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-29	52	12	4	1994	1995-01-23	1995-01-29	5
1995-01-30	1	1	1	1995	1995-01-30	1995-02-05	1
1995-01-31	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-01	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-02	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-03	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-04	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-05	1	1	1	1995	1995-01-30	1995-02-05	1
1995-02-06	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-07	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-08	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-09	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-10	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-11	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-12	2	1	1	1995	1995-02-06	1995-02-12	2
1995-02-13	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-14	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-15	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-16	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-17	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-18	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-19	3	1	1	1995	1995-02-13	1995-02-19	3
1995-02-20	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-21	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-22	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-23	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-24	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-25	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-26	4	1	1	1995	1995-02-20	1995-02-26	4
1995-02-27	5	2	1	1995	1995-02-27	1995-03-05	1
1995-02-28	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-01	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-02	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-03	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-04	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-05	5	2	1	1995	1995-02-27	1995-03-05	1
1995-03-06	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-07	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-08	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-09	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-10	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-11	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-12	6	2	1	1995	1995-03-06	1995-03-12	2
1995-03-13	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-14	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-15	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-16	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-17	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-18	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-19	7	2	1	1995	1995-03-13	1995-03-19	3
1995-03-20	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-21	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-22	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-23	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-24	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-25	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-26	8	2	1	1995	1995-03-20	1995-03-26	4
1995-03-27	9	3	1	1995	1995-03-27	1995-04-02	1
1995-03-28	9	3	1	1995	1995-03-27	1995-04-02	1
1995-03-29	9	3	1	1995	1995-03-27	1995-04-02	1
1995-03-30	9	3	1	1995	1995-03-27	1995-04-02	1
1995-03-31	9	3	1	1995	1995-03-27	1995-04-02	1
1995-04-01	9	3	1	1995	1995-03-27	1995-04-02	1
1995-04-02	9	3	1	1995	1995-03-27	1995-04-02	1
1995-04-03	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-04	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-05	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-06	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-07	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-08	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-09	10	3	1	1995	1995-04-03	1995-04-09	2
1995-04-10	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-11	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-12	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-13	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-14	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-15	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-16	11	3	1	1995	1995-04-10	1995-04-16	3
1995-04-17	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-18	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-19	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-20	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-21	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-22	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-23	12	3	1	1995	1995-04-17	1995-04-23	4
1995-04-24	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-25	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-26	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-27	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-28	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-29	13	3	1	1995	1995-04-24	1995-04-30	5
1995-04-30	13	3	1	1995	1995-04-24	1995-04-30	5
1995-05-01	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-02	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-03	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-04	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-05	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-06	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-07	14	4	2	1995	1995-05-01	1995-05-07	1
1995-05-08	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-09	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-10	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-11	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-12	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-13	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-14	15	4	2	1995	1995-05-08	1995-05-14	2
1995-05-15	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-16	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-17	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-18	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-19	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-20	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-21	16	4	2	1995	1995-05-15	1995-05-21	3
1995-05-22	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-23	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-24	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-25	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-26	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-27	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-28	17	4	2	1995	1995-05-22	1995-05-28	4
1995-05-29	18	5	2	1995	1995-05-29	1995-06-04	1
1995-05-30	18	5	2	1995	1995-05-29	1995-06-04	1
1995-05-31	18	5	2	1995	1995-05-29	1995-06-04	1
1995-06-01	18	5	2	1995	1995-05-29	1995-06-04	1
1995-06-02	18	5	2	1995	1995-05-29	1995-06-04	1
1995-06-03	18	5	2	1995	1995-05-29	1995-06-04	1
1995-06-04	18	5	2	1995	1995-05-29	1995-06-04	1
1995-06-05	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-06	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-07	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-08	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-09	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-10	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-11	19	5	2	1995	1995-06-05	1995-06-11	2
1995-06-12	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-13	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-14	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-15	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-16	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-17	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-18	20	5	2	1995	1995-06-12	1995-06-18	3
1995-06-19	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-20	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-21	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-22	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-23	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-24	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-25	21	5	2	1995	1995-06-19	1995-06-25	4
1995-06-26	22	6	2	1995	1995-06-26	1995-07-02	1
1995-06-27	22	6	2	1995	1995-06-26	1995-07-02	1
1995-06-28	22	6	2	1995	1995-06-26	1995-07-02	1
1995-06-29	22	6	2	1995	1995-06-26	1995-07-02	1
1995-06-30	22	6	2	1995	1995-06-26	1995-07-02	1
1995-07-01	22	6	2	1995	1995-06-26	1995-07-02	1
1995-07-02	22	6	2	1995	1995-06-26	1995-07-02	1
1995-07-03	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-04	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-05	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-06	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-07	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-08	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-09	23	6	2	1995	1995-07-03	1995-07-09	2
1995-07-10	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-11	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-12	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-13	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-14	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-15	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-16	24	6	2	1995	1995-07-10	1995-07-16	3
1995-07-17	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-18	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-19	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-20	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-21	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-22	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-23	25	6	2	1995	1995-07-17	1995-07-23	4
1995-07-24	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-25	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-26	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-27	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-28	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-29	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-30	26	6	2	1995	1995-07-24	1995-07-30	5
1995-07-31	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-01	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-02	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-03	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-04	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-05	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-06	27	7	2	1995	1995-07-31	1995-08-06	1
1995-08-07	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-08	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-09	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-10	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-11	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-12	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-13	28	7	2	1995	1995-08-07	1995-08-13	2
1995-08-14	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-15	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-16	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-17	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-18	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-19	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-20	29	7	2	1995	1995-08-14	1995-08-20	3
1995-08-21	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-22	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-23	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-24	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-25	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-26	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-27	30	7	2	1995	1995-08-21	1995-08-27	4
1995-08-28	31	8	3	1995	1995-08-28	1995-09-03	1
1995-08-29	31	8	3	1995	1995-08-28	1995-09-03	1
1995-08-30	31	8	3	1995	1995-08-28	1995-09-03	1
1995-08-31	31	8	3	1995	1995-08-28	1995-09-03	1
1995-09-01	31	8	3	1995	1995-08-28	1995-09-03	1
1995-09-02	31	8	3	1995	1995-08-28	1995-09-03	1
1995-09-03	31	8	3	1995	1995-08-28	1995-09-03	1
1995-09-04	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-05	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-06	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-07	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-08	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-09	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-10	32	8	3	1995	1995-09-04	1995-09-10	2
1995-09-11	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-12	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-13	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-14	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-15	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-16	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-17	33	8	3	1995	1995-09-11	1995-09-17	3
1995-09-18	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-19	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-20	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-21	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-22	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-23	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-24	34	8	3	1995	1995-09-18	1995-09-24	4
1995-09-25	35	9	3	1995	1995-09-25	1995-10-01	1
1995-09-26	35	9	3	1995	1995-09-25	1995-10-01	1
1995-09-27	35	9	3	1995	1995-09-25	1995-10-01	1
1995-09-28	35	9	3	1995	1995-09-25	1995-10-01	1
1995-09-29	35	9	3	1995	1995-09-25	1995-10-01	1
1995-09-30	35	9	3	1995	1995-09-25	1995-10-01	1
1995-10-01	35	9	3	1995	1995-09-25	1995-10-01	1
1995-10-02	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-03	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-04	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-05	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-06	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-07	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-08	36	9	3	1995	1995-10-02	1995-10-08	2
1995-10-09	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-10	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-11	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-12	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-13	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-14	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-15	37	9	3	1995	1995-10-09	1995-10-15	3
1995-10-16	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-17	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-18	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-19	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-20	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-21	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-22	38	9	3	1995	1995-10-16	1995-10-22	4
1995-10-23	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-24	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-25	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-26	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-27	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-28	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-29	39	9	3	1995	1995-10-23	1995-10-29	5
1995-10-30	40	10	3	1995	1995-10-30	1995-11-05	1
1995-10-31	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-01	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-02	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-03	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-04	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-05	40	10	3	1995	1995-10-30	1995-11-05	1
1995-11-06	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-07	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-08	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-09	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-10	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-11	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-12	41	10	3	1995	1995-11-06	1995-11-12	2
1995-11-13	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-14	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-15	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-16	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-17	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-18	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-19	42	10	3	1995	1995-11-13	1995-11-19	3
1995-11-20	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-21	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-22	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-23	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-24	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-25	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-26	43	10	3	1995	1995-11-20	1995-11-26	4
1995-11-27	44	11	3	1995	1995-11-27	1995-12-03	1
1995-11-28	44	11	3	1995	1995-11-27	1995-12-03	1
1995-11-29	44	11	3	1995	1995-11-27	1995-12-03	1
1995-11-30	44	11	3	1995	1995-11-27	1995-12-03	1
1995-12-01	44	11	3	1995	1995-11-27	1995-12-03	1
1995-12-02	44	11	3	1995	1995-11-27	1995-12-03	1
1995-12-03	44	11	3	1995	1995-11-27	1995-12-03	1
1995-12-04	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-05	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-06	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-07	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-08	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-09	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-10	45	11	3	1995	1995-12-04	1995-12-10	2
1995-12-11	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-12	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-13	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-14	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-15	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-16	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-17	46	11	3	1995	1995-12-11	1995-12-17	3
1995-12-18	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-19	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-20	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-21	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-22	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-23	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-24	47	11	3	1995	1995-12-18	1995-12-24	4
1995-12-25	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-26	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-27	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-28	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-29	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-30	48	12	4	1995	1995-12-25	1995-12-31	1
1995-12-31	48	12	4	1995	1995-12-25	1995-12-31	1
1996-01-01	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-02	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-03	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-04	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-05	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-06	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-07	49	12	4	1995	1996-01-01	1996-01-07	2
1996-01-08	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-09	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-10	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-11	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-12	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-13	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-14	50	12	4	1995	1996-01-08	1996-01-14	3
1996-01-15	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-16	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-17	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-18	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-19	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-20	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-21	51	12	4	1995	1996-01-15	1996-01-21	4
1996-01-22	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-23	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-24	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-25	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-26	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-27	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-28	52	12	4	1995	1996-01-22	1996-01-28	5
1996-01-29	1	1	1	1996	1996-01-29	1996-02-04	1
1996-01-30	1	1	1	1996	1996-01-29	1996-02-04	1
1996-01-31	1	1	1	1996	1996-01-29	1996-02-04	1
1996-02-01	1	1	1	1996	1996-01-29	1996-02-04	1
1996-02-02	1	1	1	1996	1996-01-29	1996-02-04	1
1996-02-03	1	1	1	1996	1996-01-29	1996-02-04	1
1996-02-04	1	1	1	1996	1996-01-29	1996-02-04	1
1996-02-05	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-06	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-07	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-08	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-09	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-10	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-11	2	1	1	1996	1996-02-05	1996-02-11	2
1996-02-12	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-13	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-14	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-15	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-16	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-17	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-18	3	1	1	1996	1996-02-12	1996-02-18	3
1996-02-19	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-20	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-21	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-22	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-23	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-24	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-25	4	1	1	1996	1996-02-19	1996-02-25	4
1996-02-26	5	2	1	1996	1996-02-26	1996-03-03	1
1996-02-27	5	2	1	1996	1996-02-26	1996-03-03	1
1996-02-28	5	2	1	1996	1996-02-26	1996-03-03	1
1996-02-29	5	2	1	1996	1996-02-26	1996-03-03	1
1996-03-01	5	2	1	1996	1996-02-26	1996-03-03	1
1996-03-02	5	2	1	1996	1996-02-26	1996-03-03	1
1996-03-03	5	2	1	1996	1996-02-26	1996-03-03	1
1996-03-04	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-05	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-06	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-07	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-08	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-09	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-10	6	2	1	1996	1996-03-04	1996-03-10	2
1996-03-11	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-12	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-13	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-14	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-15	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-16	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-17	7	2	1	1996	1996-03-11	1996-03-17	3
1996-03-18	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-19	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-20	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-21	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-22	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-23	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-24	8	2	1	1996	1996-03-18	1996-03-24	4
1996-03-25	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-26	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-27	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-28	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-29	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-30	9	3	1	1996	1996-03-25	1996-03-31	1
1996-03-31	9	3	1	1996	1996-03-25	1996-03-31	1
1996-04-01	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-02	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-03	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-04	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-05	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-06	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-07	10	3	1	1996	1996-04-01	1996-04-07	2
1996-04-08	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-09	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-10	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-11	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-12	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-13	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-14	11	3	1	1996	1996-04-08	1996-04-14	3
1996-04-15	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-16	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-17	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-18	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-19	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-20	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-21	12	3	1	1996	1996-04-15	1996-04-21	4
1996-04-22	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-23	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-24	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-25	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-26	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-27	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-28	13	3	1	1996	1996-04-22	1996-04-28	5
1996-04-29	14	4	2	1996	1996-04-29	1996-05-05	1
1996-04-30	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-01	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-02	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-03	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-04	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-05	14	4	2	1996	1996-04-29	1996-05-05	1
1996-05-06	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-07	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-08	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-09	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-10	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-11	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-12	15	4	2	1996	1996-05-06	1996-05-12	2
1996-05-13	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-14	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-15	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-16	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-17	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-18	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-19	16	4	2	1996	1996-05-13	1996-05-19	3
1996-05-20	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-21	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-22	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-23	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-24	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-25	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-26	17	4	2	1996	1996-05-20	1996-05-26	4
1996-05-27	18	5	2	1996	1996-05-27	1996-06-02	1
1996-05-28	18	5	2	1996	1996-05-27	1996-06-02	1
1996-05-29	18	5	2	1996	1996-05-27	1996-06-02	1
1996-05-30	18	5	2	1996	1996-05-27	1996-06-02	1
1996-05-31	18	5	2	1996	1996-05-27	1996-06-02	1
1996-06-01	18	5	2	1996	1996-05-27	1996-06-02	1
1996-06-02	18	5	2	1996	1996-05-27	1996-06-02	1
1996-06-03	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-04	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-05	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-06	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-07	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-08	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-09	19	5	2	1996	1996-06-03	1996-06-09	2
1996-06-10	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-11	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-12	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-13	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-14	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-15	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-16	20	5	2	1996	1996-06-10	1996-06-16	3
1996-06-17	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-18	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-19	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-20	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-21	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-22	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-23	21	5	2	1996	1996-06-17	1996-06-23	4
1996-06-24	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-25	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-26	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-27	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-28	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-29	22	6	2	1996	1996-06-24	1996-06-30	1
1996-06-30	22	6	2	1996	1996-06-24	1996-06-30	1
1996-07-01	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-02	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-03	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-04	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-05	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-06	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-07	23	6	2	1996	1996-07-01	1996-07-07	2
1996-07-08	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-09	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-10	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-11	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-12	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-13	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-14	24	6	2	1996	1996-07-08	1996-07-14	3
1996-07-15	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-16	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-17	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-18	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-19	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-20	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-21	25	6	2	1996	1996-07-15	1996-07-21	4
1996-07-22	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-23	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-24	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-25	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-26	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-27	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-28	26	6	2	1996	1996-07-22	1996-07-28	5
1996-07-29	27	7	2	1996	1996-07-29	1996-08-04	1
1996-07-30	27	7	2	1996	1996-07-29	1996-08-04	1
1996-07-31	27	7	2	1996	1996-07-29	1996-08-04	1
1996-08-01	27	7	2	1996	1996-07-29	1996-08-04	1
1996-08-02	27	7	2	1996	1996-07-29	1996-08-04	1
1996-08-03	27	7	2	1996	1996-07-29	1996-08-04	1
1996-08-04	27	7	2	1996	1996-07-29	1996-08-04	1
1996-08-05	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-06	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-07	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-08	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-09	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-10	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-11	28	7	2	1996	1996-08-05	1996-08-11	2
1996-08-12	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-13	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-14	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-15	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-16	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-17	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-18	29	7	2	1996	1996-08-12	1996-08-18	3
1996-08-19	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-20	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-21	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-22	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-23	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-24	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-25	30	7	2	1996	1996-08-19	1996-08-25	4
1996-08-26	31	8	3	1996	1996-08-26	1996-09-01	1
1996-08-27	31	8	3	1996	1996-08-26	1996-09-01	1
1996-08-28	31	8	3	1996	1996-08-26	1996-09-01	1
1996-08-29	31	8	3	1996	1996-08-26	1996-09-01	1
1996-08-30	31	8	3	1996	1996-08-26	1996-09-01	1
1996-08-31	31	8	3	1996	1996-08-26	1996-09-01	1
1996-09-01	31	8	3	1996	1996-08-26	1996-09-01	1
1996-09-02	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-03	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-04	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-05	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-06	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-07	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-08	32	8	3	1996	1996-09-02	1996-09-08	2
1996-09-09	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-10	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-11	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-12	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-13	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-14	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-15	33	8	3	1996	1996-09-09	1996-09-15	3
1996-09-16	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-17	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-18	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-19	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-20	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-21	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-22	34	8	3	1996	1996-09-16	1996-09-22	4
1996-09-23	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-24	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-25	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-26	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-27	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-28	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-29	35	9	3	1996	1996-09-23	1996-09-29	1
1996-09-30	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-01	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-02	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-03	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-04	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-05	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-06	36	9	3	1996	1996-09-30	1996-10-06	2
1996-10-07	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-08	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-09	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-10	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-11	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-12	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-13	37	9	3	1996	1996-10-07	1996-10-13	3
1996-10-14	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-15	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-16	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-17	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-18	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-19	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-20	38	9	3	1996	1996-10-14	1996-10-20	4
1996-10-21	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-22	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-23	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-24	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-25	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-26	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-27	39	9	3	1996	1996-10-21	1996-10-27	5
1996-10-28	40	10	3	1996	1996-10-28	1996-11-03	1
1996-10-29	40	10	3	1996	1996-10-28	1996-11-03	1
1996-10-30	40	10	3	1996	1996-10-28	1996-11-03	1
1996-10-31	40	10	3	1996	1996-10-28	1996-11-03	1
1996-11-01	40	10	3	1996	1996-10-28	1996-11-03	1
1996-11-02	40	10	3	1996	1996-10-28	1996-11-03	1
1996-11-03	40	10	3	1996	1996-10-28	1996-11-03	1
1996-11-04	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-05	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-06	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-07	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-08	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-09	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-10	41	10	3	1996	1996-11-04	1996-11-10	2
1996-11-11	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-12	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-13	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-14	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-15	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-16	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-17	42	10	3	1996	1996-11-11	1996-11-17	3
1996-11-18	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-19	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-20	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-21	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-22	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-23	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-24	43	10	3	1996	1996-11-18	1996-11-24	4
1996-11-25	44	11	3	1996	1996-11-25	1996-12-01	1
1996-11-26	44	11	3	1996	1996-11-25	1996-12-01	1
1996-11-27	44	11	3	1996	1996-11-25	1996-12-01	1
1996-11-28	44	11	3	1996	1996-11-25	1996-12-01	1
1996-11-29	44	11	3	1996	1996-11-25	1996-12-01	1
1996-11-30	44	11	3	1996	1996-11-25	1996-12-01	1
1996-12-01	44	11	3	1996	1996-11-25	1996-12-01	1
1996-12-02	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-03	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-04	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-05	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-06	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-07	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-08	45	11	3	1996	1996-12-02	1996-12-08	2
1996-12-09	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-10	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-11	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-12	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-13	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-14	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-15	46	11	3	1996	1996-12-09	1996-12-15	3
1996-12-16	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-17	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-18	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-19	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-20	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-21	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-22	47	11	3	1996	1996-12-16	1996-12-22	4
1996-12-23	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-24	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-25	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-26	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-27	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-28	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-29	48	12	4	1996	1996-12-23	1996-12-29	1
1996-12-30	49	12	4	1996	1996-12-30	1997-01-05	2
1996-12-31	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-01	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-02	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-03	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-04	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-05	49	12	4	1996	1996-12-30	1997-01-05	2
1997-01-06	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-07	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-08	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-09	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-10	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-11	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-12	50	12	4	1996	1997-01-06	1997-01-12	3
1997-01-13	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-14	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-15	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-16	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-17	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-18	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-19	51	12	4	1996	1997-01-13	1997-01-19	4
1997-01-20	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-21	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-22	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-23	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-24	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-25	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-26	52	12	4	1996	1997-01-20	1997-01-26	5
1997-01-27	53	12	4	1996	1997-01-27	1997-02-02	6
1997-01-28	53	12	4	1996	1997-01-27	1997-02-02	6
1997-01-29	53	12	4	1996	1997-01-27	1997-02-02	6
1997-01-30	53	12	4	1996	1997-01-27	1997-02-02	6
1997-01-31	53	12	4	1996	1997-01-27	1997-02-02	6
1997-02-01	53	12	4	1996	1997-01-27	1997-02-02	6
1997-02-02	53	12	4	1996	1997-01-27	1997-02-02	6
1997-02-03	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-04	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-05	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-06	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-07	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-08	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-09	1	1	1	1997	1997-02-03	1997-02-09	1
1997-02-10	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-11	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-12	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-13	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-14	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-15	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-16	2	1	1	1997	1997-02-10	1997-02-16	2
1997-02-17	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-18	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-19	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-20	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-21	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-22	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-23	3	1	1	1997	1997-02-17	1997-02-23	3
1997-02-24	4	1	1	1997	1997-02-24	1997-03-02	4
1997-02-25	4	1	1	1997	1997-02-24	1997-03-02	4
1997-02-26	4	1	1	1997	1997-02-24	1997-03-02	4
1997-02-27	4	1	1	1997	1997-02-24	1997-03-02	4
1997-02-28	4	1	1	1997	1997-02-24	1997-03-02	4
1997-03-01	4	1	1	1997	1997-02-24	1997-03-02	4
1997-03-02	4	1	1	1997	1997-02-24	1997-03-02	4
1997-03-03	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-04	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-05	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-06	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-07	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-08	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-09	5	2	1	1997	1997-03-03	1997-03-09	1
1997-03-10	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-11	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-12	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-13	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-14	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-15	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-16	6	2	1	1997	1997-03-10	1997-03-16	2
1997-03-17	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-18	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-19	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-20	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-21	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-22	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-23	7	2	1	1997	1997-03-17	1997-03-23	3
1997-03-24	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-25	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-26	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-27	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-28	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-29	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-30	8	2	1	1997	1997-03-24	1997-03-30	4
1997-03-31	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-01	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-02	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-03	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-04	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-05	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-06	9	3	1	1997	1997-03-31	1997-04-06	1
1997-04-07	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-08	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-09	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-10	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-11	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-12	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-13	10	3	1	1997	1997-04-07	1997-04-13	2
1997-04-14	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-15	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-16	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-17	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-18	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-19	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-20	11	3	1	1997	1997-04-14	1997-04-20	3
1997-04-21	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-22	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-23	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-24	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-25	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-26	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-27	12	3	1	1997	1997-04-21	1997-04-27	4
1997-04-28	13	3	1	1997	1997-04-28	1997-05-04	5
1997-04-29	13	3	1	1997	1997-04-28	1997-05-04	5
1997-04-30	13	3	1	1997	1997-04-28	1997-05-04	5
1997-05-01	13	3	1	1997	1997-04-28	1997-05-04	5
1997-05-02	13	3	1	1997	1997-04-28	1997-05-04	5
1997-05-03	13	3	1	1997	1997-04-28	1997-05-04	5
1997-05-04	13	3	1	1997	1997-04-28	1997-05-04	5
1997-05-05	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-06	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-07	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-08	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-09	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-10	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-11	14	4	2	1997	1997-05-05	1997-05-11	1
1997-05-12	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-13	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-14	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-15	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-16	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-17	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-18	15	4	2	1997	1997-05-12	1997-05-18	2
1997-05-19	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-20	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-21	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-22	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-23	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-24	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-25	16	4	2	1997	1997-05-19	1997-05-25	3
1997-05-26	17	4	2	1997	1997-05-26	1997-06-01	4
1997-05-27	17	4	2	1997	1997-05-26	1997-06-01	4
1997-05-28	17	4	2	1997	1997-05-26	1997-06-01	4
1997-05-29	17	4	2	1997	1997-05-26	1997-06-01	4
1997-05-30	17	4	2	1997	1997-05-26	1997-06-01	4
1997-05-31	17	4	2	1997	1997-05-26	1997-06-01	4
1997-06-01	17	4	2	1997	1997-05-26	1997-06-01	4
1997-06-02	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-03	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-04	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-05	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-06	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-07	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-08	18	5	2	1997	1997-06-02	1997-06-08	1
1997-06-09	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-10	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-11	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-12	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-13	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-14	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-15	19	5	2	1997	1997-06-09	1997-06-15	2
1997-06-16	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-17	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-18	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-19	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-20	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-21	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-22	20	5	2	1997	1997-06-16	1997-06-22	3
1997-06-23	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-24	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-25	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-26	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-27	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-28	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-29	21	5	2	1997	1997-06-23	1997-06-29	4
1997-06-30	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-01	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-02	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-03	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-04	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-05	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-06	22	6	2	1997	1997-06-30	1997-07-06	1
1997-07-07	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-08	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-09	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-10	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-11	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-12	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-13	23	6	2	1997	1997-07-07	1997-07-13	2
1997-07-14	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-15	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-16	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-17	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-18	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-19	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-20	24	6	2	1997	1997-07-14	1997-07-20	3
1997-07-21	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-22	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-23	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-24	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-25	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-26	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-27	25	6	2	1997	1997-07-21	1997-07-27	4
1997-07-28	26	6	2	1997	1997-07-28	1997-08-03	5
1997-07-29	26	6	2	1997	1997-07-28	1997-08-03	5
1997-07-30	26	6	2	1997	1997-07-28	1997-08-03	5
1997-07-31	26	6	2	1997	1997-07-28	1997-08-03	5
1997-08-01	26	6	2	1997	1997-07-28	1997-08-03	5
1997-08-02	26	6	2	1997	1997-07-28	1997-08-03	5
1997-08-03	26	6	2	1997	1997-07-28	1997-08-03	5
1997-08-04	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-05	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-06	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-07	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-08	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-09	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-10	27	7	2	1997	1997-08-04	1997-08-10	1
1997-08-11	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-12	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-13	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-14	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-15	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-16	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-17	28	7	2	1997	1997-08-11	1997-08-17	2
1997-08-18	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-19	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-20	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-21	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-22	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-23	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-24	29	7	2	1997	1997-08-18	1997-08-24	3
1997-08-25	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-26	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-27	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-28	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-29	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-30	30	7	2	1997	1997-08-25	1997-08-31	4
1997-08-31	30	7	2	1997	1997-08-25	1997-08-31	4
1997-09-01	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-02	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-03	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-04	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-05	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-06	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-07	31	8	3	1997	1997-09-01	1997-09-07	1
1997-09-08	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-09	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-10	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-11	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-12	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-13	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-14	32	8	3	1997	1997-09-08	1997-09-14	2
1997-09-15	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-16	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-17	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-18	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-19	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-20	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-21	33	8	3	1997	1997-09-15	1997-09-21	3
1997-09-22	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-23	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-24	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-25	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-26	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-27	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-28	34	8	3	1997	1997-09-22	1997-09-28	4
1997-09-29	35	9	3	1997	1997-09-29	1997-10-05	1
1997-09-30	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-01	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-02	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-03	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-04	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-05	35	9	3	1997	1997-09-29	1997-10-05	1
1997-10-06	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-07	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-08	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-09	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-10	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-11	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-12	36	9	3	1997	1997-10-06	1997-10-12	2
1997-10-13	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-14	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-15	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-16	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-17	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-18	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-19	37	9	3	1997	1997-10-13	1997-10-19	3
1997-10-20	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-21	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-22	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-23	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-24	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-25	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-26	38	9	3	1997	1997-10-20	1997-10-26	4
1997-10-27	39	9	3	1997	1997-10-27	1997-11-02	5
1997-10-28	39	9	3	1997	1997-10-27	1997-11-02	5
1997-10-29	39	9	3	1997	1997-10-27	1997-11-02	5
1997-10-30	39	9	3	1997	1997-10-27	1997-11-02	5
1997-10-31	39	9	3	1997	1997-10-27	1997-11-02	5
1997-11-01	39	9	3	1997	1997-10-27	1997-11-02	5
1997-11-02	39	9	3	1997	1997-10-27	1997-11-02	5
1997-11-03	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-04	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-05	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-06	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-07	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-08	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-09	40	10	3	1997	1997-11-03	1997-11-09	1
1997-11-10	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-11	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-12	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-13	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-14	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-15	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-16	41	10	3	1997	1997-11-10	1997-11-16	2
1997-11-17	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-18	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-19	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-20	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-21	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-22	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-23	42	10	3	1997	1997-11-17	1997-11-23	3
1997-11-24	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-25	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-26	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-27	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-28	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-29	43	10	3	1997	1997-11-24	1997-11-30	4
1997-11-30	43	10	3	1997	1997-11-24	1997-11-30	4
1997-12-01	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-02	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-03	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-04	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-05	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-06	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-07	44	11	3	1997	1997-12-01	1997-12-07	1
1997-12-08	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-09	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-10	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-11	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-12	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-13	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-14	45	11	3	1997	1997-12-08	1997-12-14	2
1997-12-15	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-16	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-17	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-18	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-19	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-20	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-21	46	11	3	1997	1997-12-15	1997-12-21	3
1997-12-22	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-23	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-24	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-25	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-26	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-27	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-28	47	11	3	1997	1997-12-22	1997-12-28	4
1997-12-29	48	12	4	1997	1997-12-29	1998-01-04	1
1997-12-30	48	12	4	1997	1997-12-29	1998-01-04	1
1997-12-31	48	12	4	1997	1997-12-29	1998-01-04	1
1998-01-01	48	12	4	1997	1997-12-29	1998-01-04	1
1998-01-02	48	12	4	1997	1997-12-29	1998-01-04	1
1998-01-03	48	12	4	1997	1997-12-29	1998-01-04	1
1998-01-04	48	12	4	1997	1997-12-29	1998-01-04	1
1998-01-05	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-06	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-07	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-08	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-09	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-10	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-11	49	12	4	1997	1998-01-05	1998-01-11	2
1998-01-12	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-13	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-14	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-15	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-16	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-17	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-18	50	12	4	1997	1998-01-12	1998-01-18	3
1998-01-19	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-20	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-21	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-22	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-23	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-24	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-25	51	12	4	1997	1998-01-19	1998-01-25	4
1998-01-26	52	12	4	1997	1998-01-26	1998-02-01	5
1998-01-27	52	12	4	1997	1998-01-26	1998-02-01	5
1998-01-28	52	12	4	1997	1998-01-26	1998-02-01	5
1998-01-29	52	12	4	1997	1998-01-26	1998-02-01	5
1998-01-30	52	12	4	1997	1998-01-26	1998-02-01	5
1998-01-31	52	12	4	1997	1998-01-26	1998-02-01	5
1998-02-01	52	12	4	1997	1998-01-26	1998-02-01	5
1998-02-02	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-03	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-04	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-05	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-06	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-07	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-08	1	1	1	1998	1998-02-02	1998-02-08	1
1998-02-09	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-10	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-11	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-12	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-13	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-14	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-15	2	1	1	1998	1998-02-09	1998-02-15	2
1998-02-16	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-17	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-18	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-19	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-20	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-21	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-22	3	1	1	1998	1998-02-16	1998-02-22	3
1998-02-23	4	1	1	1998	1998-02-23	1998-03-01	4
1998-02-24	4	1	1	1998	1998-02-23	1998-03-01	4
1998-02-25	4	1	1	1998	1998-02-23	1998-03-01	4
1998-02-26	4	1	1	1998	1998-02-23	1998-03-01	4
1998-02-27	4	1	1	1998	1998-02-23	1998-03-01	4
1998-02-28	4	1	1	1998	1998-02-23	1998-03-01	4
1998-03-01	4	1	1	1998	1998-02-23	1998-03-01	4
1998-03-02	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-03	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-04	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-05	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-06	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-07	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-08	5	2	1	1998	1998-03-02	1998-03-08	1
1998-03-09	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-10	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-11	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-12	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-13	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-14	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-15	6	2	1	1998	1998-03-09	1998-03-15	2
1998-03-16	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-17	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-18	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-19	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-20	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-21	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-22	7	2	1	1998	1998-03-16	1998-03-22	3
1998-03-23	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-24	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-25	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-26	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-27	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-28	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-29	8	2	1	1998	1998-03-23	1998-03-29	4
1998-03-30	9	3	1	1998	1998-03-30	1998-04-05	1
1998-03-31	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-01	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-02	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-03	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-04	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-05	9	3	1	1998	1998-03-30	1998-04-05	1
1998-04-06	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-07	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-08	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-09	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-10	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-11	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-12	10	3	1	1998	1998-04-06	1998-04-12	2
1998-04-13	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-14	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-15	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-16	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-17	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-18	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-19	11	3	1	1998	1998-04-13	1998-04-19	3
1998-04-20	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-21	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-22	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-23	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-24	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-25	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-26	12	3	1	1998	1998-04-20	1998-04-26	4
1998-04-27	13	3	1	1998	1998-04-27	1998-05-03	5
1998-04-28	13	3	1	1998	1998-04-27	1998-05-03	5
1998-04-29	13	3	1	1998	1998-04-27	1998-05-03	5
1998-04-30	13	3	1	1998	1998-04-27	1998-05-03	5
1998-05-01	13	3	1	1998	1998-04-27	1998-05-03	5
1998-05-02	13	3	1	1998	1998-04-27	1998-05-03	5
1998-05-03	13	3	1	1998	1998-04-27	1998-05-03	5
1998-05-04	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-05	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-06	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-07	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-08	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-09	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-10	14	4	2	1998	1998-05-04	1998-05-10	1
1998-05-11	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-12	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-13	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-14	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-15	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-16	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-17	15	4	2	1998	1998-05-11	1998-05-17	2
1998-05-18	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-19	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-20	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-21	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-22	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-23	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-24	16	4	2	1998	1998-05-18	1998-05-24	3
1998-05-25	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-26	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-27	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-28	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-29	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-30	17	4	2	1998	1998-05-25	1998-05-31	4
1998-05-31	17	4	2	1998	1998-05-25	1998-05-31	4
1998-06-01	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-02	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-03	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-04	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-05	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-06	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-07	18	5	2	1998	1998-06-01	1998-06-07	1
1998-06-08	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-09	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-10	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-11	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-12	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-13	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-14	19	5	2	1998	1998-06-08	1998-06-14	2
1998-06-15	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-16	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-17	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-18	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-19	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-20	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-21	20	5	2	1998	1998-06-15	1998-06-21	3
1998-06-22	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-23	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-24	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-25	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-26	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-27	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-28	21	5	2	1998	1998-06-22	1998-06-28	4
1998-06-29	22	6	2	1998	1998-06-29	1998-07-05	1
1998-06-30	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-01	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-02	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-03	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-04	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-05	22	6	2	1998	1998-06-29	1998-07-05	1
1998-07-06	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-07	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-08	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-09	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-10	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-11	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-12	23	6	2	1998	1998-07-06	1998-07-12	2
1998-07-13	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-14	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-15	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-16	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-17	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-18	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-19	24	6	2	1998	1998-07-13	1998-07-19	3
1998-07-20	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-21	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-22	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-23	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-24	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-25	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-26	25	6	2	1998	1998-07-20	1998-07-26	4
1998-07-27	26	6	2	1998	1998-07-27	1998-08-02	5
1998-07-28	26	6	2	1998	1998-07-27	1998-08-02	5
1998-07-29	26	6	2	1998	1998-07-27	1998-08-02	5
1998-07-30	26	6	2	1998	1998-07-27	1998-08-02	5
1998-07-31	26	6	2	1998	1998-07-27	1998-08-02	5
1998-08-01	26	6	2	1998	1998-07-27	1998-08-02	5
1998-08-02	26	6	2	1998	1998-07-27	1998-08-02	5
1998-08-03	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-04	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-05	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-06	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-07	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-08	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-09	27	7	2	1998	1998-08-03	1998-08-09	1
1998-08-10	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-11	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-12	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-13	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-14	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-15	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-16	28	7	2	1998	1998-08-10	1998-08-16	2
1998-08-17	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-18	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-19	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-20	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-21	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-22	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-23	29	7	2	1998	1998-08-17	1998-08-23	3
1998-08-24	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-25	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-26	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-27	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-28	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-29	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-30	30	7	2	1998	1998-08-24	1998-08-30	4
1998-08-31	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-01	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-02	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-03	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-04	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-05	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-06	31	8	3	1998	1998-08-31	1998-09-06	1
1998-09-07	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-08	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-09	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-10	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-11	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-12	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-13	32	8	3	1998	1998-09-07	1998-09-13	2
1998-09-14	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-15	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-16	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-17	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-18	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-19	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-20	33	8	3	1998	1998-09-14	1998-09-20	3
1998-09-21	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-22	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-23	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-24	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-25	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-26	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-27	34	8	3	1998	1998-09-21	1998-09-27	4
1998-09-28	35	9	3	1998	1998-09-28	1998-10-04	1
1998-09-29	35	9	3	1998	1998-09-28	1998-10-04	1
1998-09-30	35	9	3	1998	1998-09-28	1998-10-04	1
1998-10-01	35	9	3	1998	1998-09-28	1998-10-04	1
1998-10-02	35	9	3	1998	1998-09-28	1998-10-04	1
1998-10-03	35	9	3	1998	1998-09-28	1998-10-04	1
1998-10-04	35	9	3	1998	1998-09-28	1998-10-04	1
1998-10-05	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-06	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-07	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-08	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-09	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-10	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-11	36	9	3	1998	1998-10-05	1998-10-11	2
1998-10-12	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-13	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-14	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-15	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-16	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-17	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-18	37	9	3	1998	1998-10-12	1998-10-18	3
1998-10-19	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-20	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-21	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-22	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-23	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-24	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-25	38	9	3	1998	1998-10-19	1998-10-25	4
1998-10-26	39	9	3	1998	1998-10-26	1998-11-01	5
1998-10-27	39	9	3	1998	1998-10-26	1998-11-01	5
1998-10-28	39	9	3	1998	1998-10-26	1998-11-01	5
1998-10-29	39	9	3	1998	1998-10-26	1998-11-01	5
1998-10-30	39	9	3	1998	1998-10-26	1998-11-01	5
1998-10-31	39	9	3	1998	1998-10-26	1998-11-01	5
1998-11-01	39	9	3	1998	1998-10-26	1998-11-01	5
1998-11-02	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-03	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-04	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-05	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-06	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-07	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-08	40	10	3	1998	1998-11-02	1998-11-08	1
1998-11-09	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-10	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-11	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-12	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-13	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-14	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-15	41	10	3	1998	1998-11-09	1998-11-15	2
1998-11-16	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-17	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-18	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-19	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-20	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-21	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-22	42	10	3	1998	1998-11-16	1998-11-22	3
1998-11-23	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-24	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-25	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-26	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-27	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-28	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-29	43	10	3	1998	1998-11-23	1998-11-29	4
1998-11-30	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-01	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-02	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-03	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-04	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-05	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-06	44	11	3	1998	1998-11-30	1998-12-06	1
1998-12-07	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-08	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-09	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-10	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-11	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-12	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-13	45	11	3	1998	1998-12-07	1998-12-13	2
1998-12-14	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-15	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-16	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-17	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-18	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-19	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-20	46	11	3	1998	1998-12-14	1998-12-20	3
1998-12-21	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-22	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-23	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-24	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-25	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-26	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-27	47	11	3	1998	1998-12-21	1998-12-27	4
1998-12-28	48	12	4	1998	1998-12-28	1999-01-03	1
1998-12-29	48	12	4	1998	1998-12-28	1999-01-03	1
1998-12-30	48	12	4	1998	1998-12-28	1999-01-03	1
1998-12-31	48	12	4	1998	1998-12-28	1999-01-03	1
1999-01-01	48	12	4	1998	1998-12-28	1999-01-03	1
1999-01-02	48	12	4	1998	1998-12-28	1999-01-03	1
1999-01-03	48	12	4	1998	1998-12-28	1999-01-03	1
1999-01-04	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-05	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-06	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-07	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-08	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-09	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-10	49	12	4	1998	1999-01-04	1999-01-10	2
1999-01-11	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-12	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-13	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-14	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-15	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-16	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-17	50	12	4	1998	1999-01-11	1999-01-17	3
1999-01-18	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-19	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-20	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-21	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-22	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-23	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-24	51	12	4	1998	1999-01-18	1999-01-24	4
1999-01-25	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-26	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-27	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-28	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-29	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-30	52	12	4	1998	1999-01-25	1999-01-31	5
1999-01-31	52	12	4	1998	1999-01-25	1999-01-31	5
1999-02-01	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-02	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-03	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-04	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-05	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-06	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-07	1	1	1	1999	1999-02-01	1999-02-07	1
1999-02-08	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-09	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-10	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-11	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-12	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-13	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-14	2	1	1	1999	1999-02-08	1999-02-14	2
1999-02-15	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-16	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-17	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-18	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-19	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-20	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-21	3	1	1	1999	1999-02-15	1999-02-21	3
1999-02-22	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-23	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-24	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-25	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-26	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-27	4	1	1	1999	1999-02-22	1999-02-28	4
1999-02-28	4	1	1	1999	1999-02-22	1999-02-28	4
1999-03-01	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-02	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-03	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-04	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-05	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-06	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-07	5	2	1	1999	1999-03-01	1999-03-07	1
1999-03-08	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-09	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-10	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-11	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-12	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-13	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-14	6	2	1	1999	1999-03-08	1999-03-14	2
1999-03-15	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-16	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-17	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-18	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-19	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-20	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-21	7	2	1	1999	1999-03-15	1999-03-21	3
1999-03-22	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-23	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-24	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-25	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-26	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-27	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-28	8	2	1	1999	1999-03-22	1999-03-28	4
1999-03-29	9	3	1	1999	1999-03-29	1999-04-04	1
1999-03-30	9	3	1	1999	1999-03-29	1999-04-04	1
1999-03-31	9	3	1	1999	1999-03-29	1999-04-04	1
1999-04-01	9	3	1	1999	1999-03-29	1999-04-04	1
1999-04-02	9	3	1	1999	1999-03-29	1999-04-04	1
1999-04-03	9	3	1	1999	1999-03-29	1999-04-04	1
1999-04-04	9	3	1	1999	1999-03-29	1999-04-04	1
1999-04-05	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-06	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-07	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-08	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-09	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-10	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-11	10	3	1	1999	1999-04-05	1999-04-11	2
1999-04-12	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-13	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-14	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-15	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-16	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-17	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-18	11	3	1	1999	1999-04-12	1999-04-18	3
1999-04-19	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-20	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-21	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-22	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-23	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-24	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-25	12	3	1	1999	1999-04-19	1999-04-25	4
1999-04-26	13	3	1	1999	1999-04-26	1999-05-02	5
1999-04-27	13	3	1	1999	1999-04-26	1999-05-02	5
1999-04-28	13	3	1	1999	1999-04-26	1999-05-02	5
1999-04-29	13	3	1	1999	1999-04-26	1999-05-02	5
1999-04-30	13	3	1	1999	1999-04-26	1999-05-02	5
1999-05-01	13	3	1	1999	1999-04-26	1999-05-02	5
1999-05-02	13	3	1	1999	1999-04-26	1999-05-02	5
1999-05-03	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-04	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-05	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-06	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-07	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-08	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-09	14	4	2	1999	1999-05-03	1999-05-09	1
1999-05-10	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-11	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-12	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-13	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-14	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-15	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-16	15	4	2	1999	1999-05-10	1999-05-16	2
1999-05-17	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-18	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-19	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-20	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-21	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-22	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-23	16	4	2	1999	1999-05-17	1999-05-23	3
1999-05-24	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-25	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-26	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-27	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-28	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-29	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-30	17	4	2	1999	1999-05-24	1999-05-30	4
1999-05-31	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-01	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-02	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-03	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-04	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-05	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-06	18	5	2	1999	1999-05-31	1999-06-06	1
1999-06-07	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-08	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-09	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-10	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-11	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-12	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-13	19	5	2	1999	1999-06-07	1999-06-13	2
1999-06-14	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-15	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-16	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-17	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-18	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-19	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-20	20	5	2	1999	1999-06-14	1999-06-20	3
1999-06-21	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-22	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-23	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-24	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-25	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-26	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-27	21	5	2	1999	1999-06-21	1999-06-27	4
1999-06-28	22	6	2	1999	1999-06-28	1999-07-04	1
1999-06-29	22	6	2	1999	1999-06-28	1999-07-04	1
1999-06-30	22	6	2	1999	1999-06-28	1999-07-04	1
1999-07-01	22	6	2	1999	1999-06-28	1999-07-04	1
1999-07-02	22	6	2	1999	1999-06-28	1999-07-04	1
1999-07-03	22	6	2	1999	1999-06-28	1999-07-04	1
1999-07-04	22	6	2	1999	1999-06-28	1999-07-04	1
1999-07-05	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-06	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-07	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-08	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-09	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-10	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-11	23	6	2	1999	1999-07-05	1999-07-11	2
1999-07-12	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-13	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-14	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-15	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-16	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-17	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-18	24	6	2	1999	1999-07-12	1999-07-18	3
1999-07-19	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-20	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-21	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-22	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-23	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-24	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-25	25	6	2	1999	1999-07-19	1999-07-25	4
1999-07-26	26	6	2	1999	1999-07-26	1999-08-01	5
1999-07-27	26	6	2	1999	1999-07-26	1999-08-01	5
1999-07-28	26	6	2	1999	1999-07-26	1999-08-01	5
1999-07-29	26	6	2	1999	1999-07-26	1999-08-01	5
1999-07-30	26	6	2	1999	1999-07-26	1999-08-01	5
1999-07-31	26	6	2	1999	1999-07-26	1999-08-01	5
1999-08-01	26	6	2	1999	1999-07-26	1999-08-01	5
1999-08-02	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-03	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-04	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-05	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-06	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-07	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-08	27	7	2	1999	1999-08-02	1999-08-08	1
1999-08-09	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-10	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-11	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-12	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-13	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-14	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-15	28	7	2	1999	1999-08-09	1999-08-15	2
1999-08-16	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-17	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-18	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-19	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-20	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-21	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-22	29	7	2	1999	1999-08-16	1999-08-22	3
1999-08-23	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-24	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-25	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-26	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-27	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-28	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-29	30	7	2	1999	1999-08-23	1999-08-29	4
1999-08-30	31	8	3	1999	1999-08-30	1999-09-05	1
1999-08-31	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-01	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-02	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-03	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-04	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-05	31	8	3	1999	1999-08-30	1999-09-05	1
1999-09-06	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-07	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-08	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-09	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-10	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-11	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-12	32	8	3	1999	1999-09-06	1999-09-12	2
1999-09-13	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-14	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-15	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-16	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-17	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-18	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-19	33	8	3	1999	1999-09-13	1999-09-19	3
1999-09-20	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-21	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-22	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-23	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-24	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-25	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-26	34	8	3	1999	1999-09-20	1999-09-26	4
1999-09-27	35	9	3	1999	1999-09-27	1999-10-03	1
1999-09-28	35	9	3	1999	1999-09-27	1999-10-03	1
1999-09-29	35	9	3	1999	1999-09-27	1999-10-03	1
1999-09-30	35	9	3	1999	1999-09-27	1999-10-03	1
1999-10-01	35	9	3	1999	1999-09-27	1999-10-03	1
1999-10-02	35	9	3	1999	1999-09-27	1999-10-03	1
1999-10-03	35	9	3	1999	1999-09-27	1999-10-03	1
1999-10-04	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-05	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-06	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-07	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-08	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-09	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-10	36	9	3	1999	1999-10-04	1999-10-10	2
1999-10-11	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-12	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-13	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-14	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-15	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-16	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-17	37	9	3	1999	1999-10-11	1999-10-17	3
1999-10-18	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-19	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-20	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-21	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-22	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-23	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-24	38	9	3	1999	1999-10-18	1999-10-24	4
1999-10-25	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-26	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-27	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-28	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-29	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-30	39	9	3	1999	1999-10-25	1999-10-31	5
1999-10-31	39	9	3	1999	1999-10-25	1999-10-31	5
1999-11-01	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-02	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-03	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-04	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-05	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-06	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-07	40	10	3	1999	1999-11-01	1999-11-07	1
1999-11-08	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-09	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-10	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-11	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-12	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-13	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-14	41	10	3	1999	1999-11-08	1999-11-14	2
1999-11-15	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-16	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-17	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-18	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-19	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-20	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-21	42	10	3	1999	1999-11-15	1999-11-21	3
1999-11-22	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-23	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-24	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-25	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-26	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-27	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-28	43	10	3	1999	1999-11-22	1999-11-28	4
1999-11-29	44	11	3	1999	1999-11-29	1999-12-05	1
1999-11-30	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-01	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-02	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-03	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-04	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-05	44	11	3	1999	1999-11-29	1999-12-05	1
1999-12-06	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-07	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-08	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-09	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-10	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-11	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-12	45	11	3	1999	1999-12-06	1999-12-12	2
1999-12-13	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-14	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-15	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-16	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-17	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-18	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-19	46	11	3	1999	1999-12-13	1999-12-19	3
1999-12-20	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-21	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-22	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-23	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-24	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-25	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-26	47	11	3	1999	1999-12-20	1999-12-26	4
1999-12-27	48	12	4	1999	1999-12-27	2000-01-02	1
1999-12-28	48	12	4	1999	1999-12-27	2000-01-02	1
1999-12-29	48	12	4	1999	1999-12-27	2000-01-02	1
1999-12-30	48	12	4	1999	1999-12-27	2000-01-02	1
1999-12-31	48	12	4	1999	1999-12-27	2000-01-02	1
2000-01-01	48	12	4	1999	1999-12-27	2000-01-02	1
2000-01-02	48	12	4	1999	1999-12-27	2000-01-02	1
2000-01-03	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-04	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-05	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-06	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-07	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-08	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-09	49	12	4	1999	2000-01-03	2000-01-09	2
2000-01-10	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-11	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-12	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-13	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-14	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-15	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-16	50	12	4	1999	2000-01-10	2000-01-16	3
2000-01-17	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-18	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-19	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-20	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-21	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-22	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-23	51	12	4	1999	2000-01-17	2000-01-23	4
2000-01-24	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-25	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-26	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-27	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-28	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-29	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-30	52	12	4	1999	2000-01-24	2000-01-30	5
2000-01-31	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-01	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-02	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-03	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-04	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-05	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-06	1	1	1	2000	2000-01-31	2000-02-06	1
2000-02-07	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-08	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-09	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-10	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-11	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-12	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-13	2	1	1	2000	2000-02-07	2000-02-13	2
2000-02-14	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-15	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-16	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-17	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-18	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-19	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-20	3	1	1	2000	2000-02-14	2000-02-20	3
2000-02-21	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-22	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-23	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-24	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-25	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-26	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-27	4	1	1	2000	2000-02-21	2000-02-27	4
2000-02-28	5	2	1	2000	2000-02-28	2000-03-05	1
2000-02-29	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-01	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-02	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-03	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-04	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-05	5	2	1	2000	2000-02-28	2000-03-05	1
2000-03-06	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-07	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-08	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-09	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-10	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-11	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-12	6	2	1	2000	2000-03-06	2000-03-12	2
2000-03-13	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-14	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-15	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-16	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-17	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-18	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-19	7	2	1	2000	2000-03-13	2000-03-19	3
2000-03-20	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-21	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-22	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-23	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-24	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-25	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-26	8	2	1	2000	2000-03-20	2000-03-26	4
2000-03-27	9	3	1	2000	2000-03-27	2000-04-02	1
2000-03-28	9	3	1	2000	2000-03-27	2000-04-02	1
2000-03-29	9	3	1	2000	2000-03-27	2000-04-02	1
2000-03-30	9	3	1	2000	2000-03-27	2000-04-02	1
2000-03-31	9	3	1	2000	2000-03-27	2000-04-02	1
2000-04-01	9	3	1	2000	2000-03-27	2000-04-02	1
2000-04-02	9	3	1	2000	2000-03-27	2000-04-02	1
2000-04-03	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-04	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-05	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-06	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-07	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-08	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-09	10	3	1	2000	2000-04-03	2000-04-09	2
2000-04-10	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-11	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-12	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-13	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-14	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-15	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-16	11	3	1	2000	2000-04-10	2000-04-16	3
2000-04-17	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-18	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-19	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-20	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-21	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-22	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-23	12	3	1	2000	2000-04-17	2000-04-23	4
2000-04-24	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-25	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-26	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-27	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-28	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-29	13	3	1	2000	2000-04-24	2000-04-30	5
2000-04-30	13	3	1	2000	2000-04-24	2000-04-30	5
2000-05-01	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-02	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-03	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-04	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-05	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-06	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-07	14	4	2	2000	2000-05-01	2000-05-07	1
2000-05-08	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-09	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-10	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-11	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-12	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-13	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-14	15	4	2	2000	2000-05-08	2000-05-14	2
2000-05-15	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-16	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-17	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-18	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-19	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-20	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-21	16	4	2	2000	2000-05-15	2000-05-21	3
2000-05-22	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-23	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-24	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-25	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-26	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-27	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-28	17	4	2	2000	2000-05-22	2000-05-28	4
2000-05-29	18	5	2	2000	2000-05-29	2000-06-04	1
2000-05-30	18	5	2	2000	2000-05-29	2000-06-04	1
2000-05-31	18	5	2	2000	2000-05-29	2000-06-04	1
2000-06-01	18	5	2	2000	2000-05-29	2000-06-04	1
2000-06-02	18	5	2	2000	2000-05-29	2000-06-04	1
2000-06-03	18	5	2	2000	2000-05-29	2000-06-04	1
2000-06-04	18	5	2	2000	2000-05-29	2000-06-04	1
2000-06-05	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-06	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-07	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-08	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-09	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-10	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-11	19	5	2	2000	2000-06-05	2000-06-11	2
2000-06-12	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-13	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-14	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-15	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-16	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-17	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-18	20	5	2	2000	2000-06-12	2000-06-18	3
2000-06-19	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-20	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-21	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-22	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-23	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-24	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-25	21	5	2	2000	2000-06-19	2000-06-25	4
2000-06-26	22	6	2	2000	2000-06-26	2000-07-02	1
2000-06-27	22	6	2	2000	2000-06-26	2000-07-02	1
2000-06-28	22	6	2	2000	2000-06-26	2000-07-02	1
2000-06-29	22	6	2	2000	2000-06-26	2000-07-02	1
2000-06-30	22	6	2	2000	2000-06-26	2000-07-02	1
2000-07-01	22	6	2	2000	2000-06-26	2000-07-02	1
2000-07-02	22	6	2	2000	2000-06-26	2000-07-02	1
2000-07-03	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-04	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-05	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-06	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-07	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-08	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-09	23	6	2	2000	2000-07-03	2000-07-09	2
2000-07-10	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-11	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-12	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-13	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-14	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-15	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-16	24	6	2	2000	2000-07-10	2000-07-16	3
2000-07-17	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-18	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-19	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-20	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-21	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-22	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-23	25	6	2	2000	2000-07-17	2000-07-23	4
2000-07-24	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-25	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-26	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-27	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-28	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-29	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-30	26	6	2	2000	2000-07-24	2000-07-30	5
2000-07-31	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-01	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-02	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-03	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-04	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-05	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-06	27	7	2	2000	2000-07-31	2000-08-06	1
2000-08-07	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-08	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-09	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-10	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-11	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-12	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-13	28	7	2	2000	2000-08-07	2000-08-13	2
2000-08-14	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-15	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-16	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-17	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-18	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-19	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-20	29	7	2	2000	2000-08-14	2000-08-20	3
2000-08-21	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-22	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-23	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-24	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-25	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-26	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-27	30	7	2	2000	2000-08-21	2000-08-27	4
2000-08-28	31	8	3	2000	2000-08-28	2000-09-03	1
2000-08-29	31	8	3	2000	2000-08-28	2000-09-03	1
2000-08-30	31	8	3	2000	2000-08-28	2000-09-03	1
2000-08-31	31	8	3	2000	2000-08-28	2000-09-03	1
2000-09-01	31	8	3	2000	2000-08-28	2000-09-03	1
2000-09-02	31	8	3	2000	2000-08-28	2000-09-03	1
2000-09-03	31	8	3	2000	2000-08-28	2000-09-03	1
2000-09-04	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-05	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-06	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-07	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-08	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-09	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-10	32	8	3	2000	2000-09-04	2000-09-10	2
2000-09-11	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-12	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-13	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-14	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-15	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-16	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-17	33	8	3	2000	2000-09-11	2000-09-17	3
2000-09-18	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-19	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-20	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-21	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-22	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-23	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-24	34	8	3	2000	2000-09-18	2000-09-24	4
2000-09-25	35	9	3	2000	2000-09-25	2000-10-01	1
2000-09-26	35	9	3	2000	2000-09-25	2000-10-01	1
2000-09-27	35	9	3	2000	2000-09-25	2000-10-01	1
2000-09-28	35	9	3	2000	2000-09-25	2000-10-01	1
2000-09-29	35	9	3	2000	2000-09-25	2000-10-01	1
2000-09-30	35	9	3	2000	2000-09-25	2000-10-01	1
2000-10-01	35	9	3	2000	2000-09-25	2000-10-01	1
2000-10-02	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-03	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-04	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-05	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-06	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-07	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-08	36	9	3	2000	2000-10-02	2000-10-08	2
2000-10-09	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-10	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-11	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-12	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-13	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-14	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-15	37	9	3	2000	2000-10-09	2000-10-15	3
2000-10-16	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-17	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-18	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-19	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-20	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-21	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-22	38	9	3	2000	2000-10-16	2000-10-22	4
2000-10-23	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-24	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-25	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-26	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-27	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-28	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-29	39	9	3	2000	2000-10-23	2000-10-29	5
2000-10-30	40	10	3	2000	2000-10-30	2000-11-05	1
2000-10-31	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-01	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-02	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-03	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-04	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-05	40	10	3	2000	2000-10-30	2000-11-05	1
2000-11-06	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-07	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-08	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-09	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-10	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-11	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-12	41	10	3	2000	2000-11-06	2000-11-12	2
2000-11-13	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-14	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-15	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-16	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-17	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-18	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-19	42	10	3	2000	2000-11-13	2000-11-19	3
2000-11-20	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-21	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-22	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-23	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-24	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-25	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-26	43	10	3	2000	2000-11-20	2000-11-26	4
2000-11-27	44	11	3	2000	2000-11-27	2000-12-03	1
2000-11-28	44	11	3	2000	2000-11-27	2000-12-03	1
2000-11-29	44	11	3	2000	2000-11-27	2000-12-03	1
2000-11-30	44	11	3	2000	2000-11-27	2000-12-03	1
2000-12-01	44	11	3	2000	2000-11-27	2000-12-03	1
2000-12-02	44	11	3	2000	2000-11-27	2000-12-03	1
2000-12-03	44	11	3	2000	2000-11-27	2000-12-03	1
2000-12-04	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-05	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-06	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-07	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-08	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-09	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-10	45	11	3	2000	2000-12-04	2000-12-10	2
2000-12-11	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-12	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-13	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-14	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-15	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-16	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-17	46	11	3	2000	2000-12-11	2000-12-17	3
2000-12-18	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-19	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-20	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-21	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-22	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-23	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-24	47	11	3	2000	2000-12-18	2000-12-24	4
2000-12-25	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-26	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-27	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-28	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-29	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-30	48	12	4	2000	2000-12-25	2000-12-31	1
2000-12-31	48	12	4	2000	2000-12-25	2000-12-31	1
2001-01-01	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-02	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-03	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-04	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-05	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-06	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-07	49	12	4	2000	2001-01-01	2001-01-07	2
2001-01-08	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-09	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-10	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-11	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-12	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-13	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-14	50	12	4	2000	2001-01-08	2001-01-14	3
2001-01-15	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-16	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-17	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-18	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-19	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-20	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-21	51	12	4	2000	2001-01-15	2001-01-21	4
2001-01-22	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-23	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-24	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-25	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-26	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-27	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-28	52	12	4	2000	2001-01-22	2001-01-28	5
2001-01-29	1	1	1	2001	2001-01-29	2001-02-04	1
2001-01-30	1	1	1	2001	2001-01-29	2001-02-04	1
2001-01-31	1	1	1	2001	2001-01-29	2001-02-04	1
2001-02-01	1	1	1	2001	2001-01-29	2001-02-04	1
2001-02-02	1	1	1	2001	2001-01-29	2001-02-04	1
2001-02-03	1	1	1	2001	2001-01-29	2001-02-04	1
2001-02-04	1	1	1	2001	2001-01-29	2001-02-04	1
2001-02-05	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-06	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-07	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-08	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-09	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-10	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-11	2	1	1	2001	2001-02-05	2001-02-11	2
2001-02-12	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-13	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-14	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-15	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-16	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-17	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-18	3	1	1	2001	2001-02-12	2001-02-18	3
2001-02-19	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-20	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-21	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-22	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-23	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-24	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-25	4	1	1	2001	2001-02-19	2001-02-25	4
2001-02-26	5	2	1	2001	2001-02-26	2001-03-04	1
2001-02-27	5	2	1	2001	2001-02-26	2001-03-04	1
2001-02-28	5	2	1	2001	2001-02-26	2001-03-04	1
2001-03-01	5	2	1	2001	2001-02-26	2001-03-04	1
2001-03-02	5	2	1	2001	2001-02-26	2001-03-04	1
2001-03-03	5	2	1	2001	2001-02-26	2001-03-04	1
2001-03-04	5	2	1	2001	2001-02-26	2001-03-04	1
2001-03-05	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-06	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-07	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-08	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-09	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-10	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-11	6	2	1	2001	2001-03-05	2001-03-11	2
2001-03-12	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-13	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-14	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-15	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-16	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-17	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-18	7	2	1	2001	2001-03-12	2001-03-18	3
2001-03-19	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-20	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-21	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-22	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-23	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-24	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-25	8	2	1	2001	2001-03-19	2001-03-25	4
2001-03-26	9	3	1	2001	2001-03-26	2001-04-01	1
2001-03-27	9	3	1	2001	2001-03-26	2001-04-01	1
2001-03-28	9	3	1	2001	2001-03-26	2001-04-01	1
2001-03-29	9	3	1	2001	2001-03-26	2001-04-01	1
2001-03-30	9	3	1	2001	2001-03-26	2001-04-01	1
2001-03-31	9	3	1	2001	2001-03-26	2001-04-01	1
2001-04-01	9	3	1	2001	2001-03-26	2001-04-01	1
2001-04-02	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-03	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-04	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-05	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-06	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-07	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-08	10	3	1	2001	2001-04-02	2001-04-08	2
2001-04-09	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-10	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-11	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-12	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-13	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-14	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-15	11	3	1	2001	2001-04-09	2001-04-15	3
2001-04-16	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-17	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-18	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-19	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-20	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-21	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-22	12	3	1	2001	2001-04-16	2001-04-22	4
2001-04-23	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-24	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-25	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-26	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-27	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-28	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-29	13	3	1	2001	2001-04-23	2001-04-29	5
2001-04-30	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-01	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-02	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-03	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-04	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-05	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-06	14	4	2	2001	2001-04-30	2001-05-06	1
2001-05-07	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-08	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-09	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-10	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-11	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-12	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-13	15	4	2	2001	2001-05-07	2001-05-13	2
2001-05-14	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-15	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-16	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-17	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-18	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-19	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-20	16	4	2	2001	2001-05-14	2001-05-20	3
2001-05-21	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-22	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-23	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-24	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-25	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-26	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-27	17	4	2	2001	2001-05-21	2001-05-27	4
2001-05-28	18	5	2	2001	2001-05-28	2001-06-03	1
2001-05-29	18	5	2	2001	2001-05-28	2001-06-03	1
2001-05-30	18	5	2	2001	2001-05-28	2001-06-03	1
2001-05-31	18	5	2	2001	2001-05-28	2001-06-03	1
2001-06-01	18	5	2	2001	2001-05-28	2001-06-03	1
2001-06-02	18	5	2	2001	2001-05-28	2001-06-03	1
2001-06-03	18	5	2	2001	2001-05-28	2001-06-03	1
2001-06-04	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-05	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-06	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-07	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-08	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-09	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-10	19	5	2	2001	2001-06-04	2001-06-10	2
2001-06-11	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-12	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-13	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-14	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-15	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-16	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-17	20	5	2	2001	2001-06-11	2001-06-17	3
2001-06-18	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-19	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-20	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-21	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-22	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-23	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-24	21	5	2	2001	2001-06-18	2001-06-24	4
2001-06-25	22	6	2	2001	2001-06-25	2001-07-01	1
2001-06-26	22	6	2	2001	2001-06-25	2001-07-01	1
2001-06-27	22	6	2	2001	2001-06-25	2001-07-01	1
2001-06-28	22	6	2	2001	2001-06-25	2001-07-01	1
2001-06-29	22	6	2	2001	2001-06-25	2001-07-01	1
2001-06-30	22	6	2	2001	2001-06-25	2001-07-01	1
2001-07-01	22	6	2	2001	2001-06-25	2001-07-01	1
2001-07-02	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-03	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-04	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-05	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-06	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-07	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-08	23	6	2	2001	2001-07-02	2001-07-08	2
2001-07-09	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-10	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-11	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-12	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-13	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-14	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-15	24	6	2	2001	2001-07-09	2001-07-15	3
2001-07-16	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-17	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-18	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-19	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-20	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-21	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-22	25	6	2	2001	2001-07-16	2001-07-22	4
2001-07-23	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-24	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-25	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-26	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-27	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-28	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-29	26	6	2	2001	2001-07-23	2001-07-29	5
2001-07-30	27	7	2	2001	2001-07-30	2001-08-05	1
2001-07-31	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-01	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-02	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-03	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-04	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-05	27	7	2	2001	2001-07-30	2001-08-05	1
2001-08-06	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-07	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-08	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-09	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-10	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-11	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-12	28	7	2	2001	2001-08-06	2001-08-12	2
2001-08-13	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-14	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-15	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-16	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-17	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-18	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-19	29	7	2	2001	2001-08-13	2001-08-19	3
2001-08-20	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-21	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-22	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-23	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-24	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-25	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-26	30	7	2	2001	2001-08-20	2001-08-26	4
2001-08-27	31	8	3	2001	2001-08-27	2001-09-02	1
2001-08-28	31	8	3	2001	2001-08-27	2001-09-02	1
2001-08-29	31	8	3	2001	2001-08-27	2001-09-02	1
2001-08-30	31	8	3	2001	2001-08-27	2001-09-02	1
2001-08-31	31	8	3	2001	2001-08-27	2001-09-02	1
2001-09-01	31	8	3	2001	2001-08-27	2001-09-02	1
2001-09-02	31	8	3	2001	2001-08-27	2001-09-02	1
2001-09-03	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-04	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-05	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-06	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-07	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-08	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-09	32	8	3	2001	2001-09-03	2001-09-09	2
2001-09-10	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-11	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-12	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-13	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-14	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-15	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-16	33	8	3	2001	2001-09-10	2001-09-16	3
2001-09-17	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-18	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-19	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-20	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-21	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-22	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-23	34	8	3	2001	2001-09-17	2001-09-23	4
2001-09-24	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-25	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-26	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-27	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-28	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-29	35	9	3	2001	2001-09-24	2001-09-30	1
2001-09-30	35	9	3	2001	2001-09-24	2001-09-30	1
2001-10-01	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-02	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-03	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-04	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-05	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-06	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-07	36	9	3	2001	2001-10-01	2001-10-07	2
2001-10-08	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-09	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-10	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-11	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-12	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-13	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-14	37	9	3	2001	2001-10-08	2001-10-14	3
2001-10-15	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-16	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-17	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-18	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-19	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-20	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-21	38	9	3	2001	2001-10-15	2001-10-21	4
2001-10-22	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-23	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-24	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-25	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-26	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-27	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-28	39	9	3	2001	2001-10-22	2001-10-28	5
2001-10-29	40	10	3	2001	2001-10-29	2001-11-04	1
2001-10-30	40	10	3	2001	2001-10-29	2001-11-04	1
2001-10-31	40	10	3	2001	2001-10-29	2001-11-04	1
2001-11-01	40	10	3	2001	2001-10-29	2001-11-04	1
2001-11-02	40	10	3	2001	2001-10-29	2001-11-04	1
2001-11-03	40	10	3	2001	2001-10-29	2001-11-04	1
2001-11-04	40	10	3	2001	2001-10-29	2001-11-04	1
2001-11-05	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-06	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-07	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-08	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-09	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-10	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-11	41	10	3	2001	2001-11-05	2001-11-11	2
2001-11-12	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-13	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-14	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-15	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-16	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-17	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-18	42	10	3	2001	2001-11-12	2001-11-18	3
2001-11-19	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-20	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-21	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-22	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-23	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-24	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-25	43	10	3	2001	2001-11-19	2001-11-25	4
2001-11-26	44	11	3	2001	2001-11-26	2001-12-02	1
2001-11-27	44	11	3	2001	2001-11-26	2001-12-02	1
2001-11-28	44	11	3	2001	2001-11-26	2001-12-02	1
2001-11-29	44	11	3	2001	2001-11-26	2001-12-02	1
2001-11-30	44	11	3	2001	2001-11-26	2001-12-02	1
2001-12-01	44	11	3	2001	2001-11-26	2001-12-02	1
2001-12-02	44	11	3	2001	2001-11-26	2001-12-02	1
2001-12-03	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-04	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-05	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-06	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-07	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-08	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-09	45	11	3	2001	2001-12-03	2001-12-09	2
2001-12-10	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-11	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-12	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-13	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-14	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-15	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-16	46	11	3	2001	2001-12-10	2001-12-16	3
2001-12-17	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-18	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-19	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-20	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-21	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-22	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-23	47	11	3	2001	2001-12-17	2001-12-23	4
2001-12-24	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-25	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-26	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-27	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-28	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-29	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-30	48	12	4	2001	2001-12-24	2001-12-30	1
2001-12-31	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-01	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-02	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-03	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-04	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-05	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-06	49	12	4	2001	2001-12-31	2002-01-06	2
2002-01-07	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-08	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-09	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-10	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-11	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-12	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-13	50	12	4	2001	2002-01-07	2002-01-13	3
2002-01-14	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-15	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-16	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-17	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-18	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-19	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-20	51	12	4	2001	2002-01-14	2002-01-20	4
2002-01-21	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-22	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-23	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-24	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-25	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-26	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-27	52	12	4	2001	2002-01-21	2002-01-27	5
2002-01-28	53	12	4	2001	2002-01-28	2002-02-03	6
2002-01-29	53	12	4	2001	2002-01-28	2002-02-03	6
2002-01-30	53	12	4	2001	2002-01-28	2002-02-03	6
2002-01-31	53	12	4	2001	2002-01-28	2002-02-03	6
2002-02-01	53	12	4	2001	2002-01-28	2002-02-03	6
2002-02-02	53	12	4	2001	2002-01-28	2002-02-03	6
2002-02-03	53	12	4	2001	2002-01-28	2002-02-03	6
2002-02-04	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-05	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-06	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-07	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-08	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-09	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-10	1	1	1	2002	2002-02-04	2002-02-10	1
2002-02-11	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-12	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-13	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-14	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-15	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-16	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-17	2	1	1	2002	2002-02-11	2002-02-17	2
2002-02-18	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-19	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-20	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-21	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-22	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-23	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-24	3	1	1	2002	2002-02-18	2002-02-24	3
2002-02-25	4	1	1	2002	2002-02-25	2002-03-03	4
2002-02-26	4	1	1	2002	2002-02-25	2002-03-03	4
2002-02-27	4	1	1	2002	2002-02-25	2002-03-03	4
2002-02-28	4	1	1	2002	2002-02-25	2002-03-03	4
2002-03-01	4	1	1	2002	2002-02-25	2002-03-03	4
2002-03-02	4	1	1	2002	2002-02-25	2002-03-03	4
2002-03-03	4	1	1	2002	2002-02-25	2002-03-03	4
2002-03-04	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-05	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-06	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-07	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-08	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-09	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-10	5	2	1	2002	2002-03-04	2002-03-10	1
2002-03-11	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-12	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-13	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-14	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-15	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-16	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-17	6	2	1	2002	2002-03-11	2002-03-17	2
2002-03-18	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-19	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-20	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-21	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-22	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-23	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-24	7	2	1	2002	2002-03-18	2002-03-24	3
2002-03-25	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-26	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-27	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-28	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-29	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-30	8	2	1	2002	2002-03-25	2002-03-31	4
2002-03-31	8	2	1	2002	2002-03-25	2002-03-31	4
2002-04-01	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-02	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-03	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-04	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-05	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-06	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-07	9	3	1	2002	2002-04-01	2002-04-07	1
2002-04-08	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-09	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-10	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-11	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-12	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-13	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-14	10	3	1	2002	2002-04-08	2002-04-14	2
2002-04-15	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-16	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-17	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-18	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-19	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-20	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-21	11	3	1	2002	2002-04-15	2002-04-21	3
2002-04-22	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-23	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-24	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-25	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-26	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-27	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-28	12	3	1	2002	2002-04-22	2002-04-28	4
2002-04-29	13	3	1	2002	2002-04-29	2002-05-05	5
2002-04-30	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-01	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-02	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-03	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-04	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-05	13	3	1	2002	2002-04-29	2002-05-05	5
2002-05-06	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-07	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-08	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-09	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-10	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-11	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-12	14	4	2	2002	2002-05-06	2002-05-12	1
2002-05-13	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-14	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-15	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-16	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-17	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-18	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-19	15	4	2	2002	2002-05-13	2002-05-19	2
2002-05-20	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-21	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-22	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-23	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-24	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-25	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-26	16	4	2	2002	2002-05-20	2002-05-26	3
2002-05-27	17	4	2	2002	2002-05-27	2002-06-02	4
2002-05-28	17	4	2	2002	2002-05-27	2002-06-02	4
2002-05-29	17	4	2	2002	2002-05-27	2002-06-02	4
2002-05-30	17	4	2	2002	2002-05-27	2002-06-02	4
2002-05-31	17	4	2	2002	2002-05-27	2002-06-02	4
2002-06-01	17	4	2	2002	2002-05-27	2002-06-02	4
2002-06-02	17	4	2	2002	2002-05-27	2002-06-02	4
2002-06-03	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-04	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-05	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-06	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-07	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-08	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-09	18	5	2	2002	2002-06-03	2002-06-09	1
2002-06-10	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-11	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-12	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-13	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-14	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-15	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-16	19	5	2	2002	2002-06-10	2002-06-16	2
2002-06-17	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-18	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-19	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-20	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-21	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-22	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-23	20	5	2	2002	2002-06-17	2002-06-23	3
2002-06-24	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-25	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-26	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-27	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-28	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-29	21	5	2	2002	2002-06-24	2002-06-30	4
2002-06-30	21	5	2	2002	2002-06-24	2002-06-30	4
2002-07-01	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-02	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-03	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-04	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-05	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-06	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-07	22	6	2	2002	2002-07-01	2002-07-07	1
2002-07-08	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-09	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-10	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-11	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-12	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-13	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-14	23	6	2	2002	2002-07-08	2002-07-14	2
2002-07-15	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-16	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-17	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-18	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-19	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-20	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-21	24	6	2	2002	2002-07-15	2002-07-21	3
2002-07-22	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-23	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-24	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-25	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-26	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-27	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-28	25	6	2	2002	2002-07-22	2002-07-28	4
2002-07-29	26	6	2	2002	2002-07-29	2002-08-04	5
2002-07-30	26	6	2	2002	2002-07-29	2002-08-04	5
2002-07-31	26	6	2	2002	2002-07-29	2002-08-04	5
2002-08-01	26	6	2	2002	2002-07-29	2002-08-04	5
2002-08-02	26	6	2	2002	2002-07-29	2002-08-04	5
2002-08-03	26	6	2	2002	2002-07-29	2002-08-04	5
2002-08-04	26	6	2	2002	2002-07-29	2002-08-04	5
2002-08-05	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-06	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-07	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-08	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-09	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-10	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-11	27	7	2	2002	2002-08-05	2002-08-11	1
2002-08-12	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-13	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-14	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-15	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-16	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-17	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-18	28	7	2	2002	2002-08-12	2002-08-18	2
2002-08-19	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-20	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-21	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-22	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-23	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-24	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-25	29	7	2	2002	2002-08-19	2002-08-25	3
2002-08-26	30	7	2	2002	2002-08-26	2002-09-01	4
2002-08-27	30	7	2	2002	2002-08-26	2002-09-01	4
2002-08-28	30	7	2	2002	2002-08-26	2002-09-01	4
2002-08-29	30	7	2	2002	2002-08-26	2002-09-01	4
2002-08-30	30	7	2	2002	2002-08-26	2002-09-01	4
2002-08-31	30	7	2	2002	2002-08-26	2002-09-01	4
2002-09-01	30	7	2	2002	2002-08-26	2002-09-01	4
2002-09-02	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-03	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-04	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-05	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-06	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-07	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-08	31	8	3	2002	2002-09-02	2002-09-08	1
2002-09-09	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-10	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-11	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-12	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-13	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-14	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-15	32	8	3	2002	2002-09-09	2002-09-15	2
2002-09-16	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-17	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-18	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-19	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-20	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-21	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-22	33	8	3	2002	2002-09-16	2002-09-22	3
2002-09-23	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-24	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-25	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-26	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-27	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-28	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-29	34	8	3	2002	2002-09-23	2002-09-29	4
2002-09-30	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-01	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-02	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-03	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-04	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-05	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-06	35	9	3	2002	2002-09-30	2002-10-06	1
2002-10-07	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-08	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-09	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-10	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-11	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-12	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-13	36	9	3	2002	2002-10-07	2002-10-13	2
2002-10-14	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-15	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-16	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-17	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-18	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-19	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-20	37	9	3	2002	2002-10-14	2002-10-20	3
2002-10-21	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-22	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-23	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-24	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-25	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-26	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-27	38	9	3	2002	2002-10-21	2002-10-27	4
2002-10-28	39	9	3	2002	2002-10-28	2002-11-03	5
2002-10-29	39	9	3	2002	2002-10-28	2002-11-03	5
2002-10-30	39	9	3	2002	2002-10-28	2002-11-03	5
2002-10-31	39	9	3	2002	2002-10-28	2002-11-03	5
2002-11-01	39	9	3	2002	2002-10-28	2002-11-03	5
2002-11-02	39	9	3	2002	2002-10-28	2002-11-03	5
2002-11-03	39	9	3	2002	2002-10-28	2002-11-03	5
2002-11-04	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-05	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-06	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-07	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-08	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-09	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-10	40	10	3	2002	2002-11-04	2002-11-10	1
2002-11-11	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-12	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-13	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-14	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-15	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-16	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-17	41	10	3	2002	2002-11-11	2002-11-17	2
2002-11-18	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-19	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-20	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-21	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-22	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-23	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-24	42	10	3	2002	2002-11-18	2002-11-24	3
2002-11-25	43	10	3	2002	2002-11-25	2002-12-01	4
2002-11-26	43	10	3	2002	2002-11-25	2002-12-01	4
2002-11-27	43	10	3	2002	2002-11-25	2002-12-01	4
2002-11-28	43	10	3	2002	2002-11-25	2002-12-01	4
2002-11-29	43	10	3	2002	2002-11-25	2002-12-01	4
2002-11-30	43	10	3	2002	2002-11-25	2002-12-01	4
2002-12-01	43	10	3	2002	2002-11-25	2002-12-01	4
2002-12-02	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-03	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-04	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-05	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-06	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-07	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-08	44	11	3	2002	2002-12-02	2002-12-08	1
2002-12-09	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-10	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-11	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-12	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-13	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-14	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-15	45	11	3	2002	2002-12-09	2002-12-15	2
2002-12-16	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-17	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-18	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-19	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-20	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-21	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-22	46	11	3	2002	2002-12-16	2002-12-22	3
2002-12-23	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-24	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-25	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-26	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-27	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-28	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-29	47	11	3	2002	2002-12-23	2002-12-29	4
2002-12-30	48	12	4	2002	2002-12-30	2003-01-05	1
2002-12-31	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-01	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-02	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-03	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-04	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-05	48	12	4	2002	2002-12-30	2003-01-05	1
2003-01-06	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-07	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-08	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-09	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-10	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-11	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-12	49	12	4	2002	2003-01-06	2003-01-12	2
2003-01-13	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-14	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-15	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-16	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-17	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-18	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-19	50	12	4	2002	2003-01-13	2003-01-19	3
2003-01-20	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-21	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-22	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-23	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-24	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-25	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-26	51	12	4	2002	2003-01-20	2003-01-26	4
2003-01-27	52	12	4	2002	2003-01-27	2003-02-02	5
2003-01-28	52	12	4	2002	2003-01-27	2003-02-02	5
2003-01-29	52	12	4	2002	2003-01-27	2003-02-02	5
2003-01-30	52	12	4	2002	2003-01-27	2003-02-02	5
2003-01-31	52	12	4	2002	2003-01-27	2003-02-02	5
2003-02-01	52	12	4	2002	2003-01-27	2003-02-02	5
2003-02-02	52	12	4	2002	2003-01-27	2003-02-02	5
2003-02-03	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-04	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-05	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-06	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-07	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-08	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-09	1	1	1	2003	2003-02-03	2003-02-09	1
2003-02-10	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-11	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-12	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-13	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-14	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-15	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-16	2	1	1	2003	2003-02-10	2003-02-16	2
2003-02-17	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-18	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-19	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-20	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-21	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-22	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-23	3	1	1	2003	2003-02-17	2003-02-23	3
2003-02-24	4	1	1	2003	2003-02-24	2003-03-02	4
2003-02-25	4	1	1	2003	2003-02-24	2003-03-02	4
2003-02-26	4	1	1	2003	2003-02-24	2003-03-02	4
2003-02-27	4	1	1	2003	2003-02-24	2003-03-02	4
2003-02-28	4	1	1	2003	2003-02-24	2003-03-02	4
2003-03-01	4	1	1	2003	2003-02-24	2003-03-02	4
2003-03-02	4	1	1	2003	2003-02-24	2003-03-02	4
2003-03-03	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-04	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-05	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-06	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-07	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-08	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-09	5	2	1	2003	2003-03-03	2003-03-09	1
2003-03-10	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-11	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-12	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-13	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-14	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-15	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-16	6	2	1	2003	2003-03-10	2003-03-16	2
2003-03-17	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-18	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-19	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-20	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-21	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-22	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-23	7	2	1	2003	2003-03-17	2003-03-23	3
2003-03-24	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-25	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-26	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-27	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-28	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-29	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-30	8	2	1	2003	2003-03-24	2003-03-30	4
2003-03-31	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-01	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-02	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-03	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-04	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-05	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-06	9	3	1	2003	2003-03-31	2003-04-06	1
2003-04-07	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-08	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-09	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-10	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-11	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-12	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-13	10	3	1	2003	2003-04-07	2003-04-13	2
2003-04-14	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-15	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-16	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-17	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-18	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-19	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-20	11	3	1	2003	2003-04-14	2003-04-20	3
2003-04-21	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-22	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-23	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-24	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-25	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-26	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-27	12	3	1	2003	2003-04-21	2003-04-27	4
2003-04-28	13	3	1	2003	2003-04-28	2003-05-04	5
2003-04-29	13	3	1	2003	2003-04-28	2003-05-04	5
2003-04-30	13	3	1	2003	2003-04-28	2003-05-04	5
2003-05-01	13	3	1	2003	2003-04-28	2003-05-04	5
2003-05-02	13	3	1	2003	2003-04-28	2003-05-04	5
2003-05-03	13	3	1	2003	2003-04-28	2003-05-04	5
2003-05-04	13	3	1	2003	2003-04-28	2003-05-04	5
2003-05-05	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-06	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-07	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-08	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-09	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-10	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-11	14	4	2	2003	2003-05-05	2003-05-11	1
2003-05-12	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-13	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-14	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-15	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-16	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-17	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-18	15	4	2	2003	2003-05-12	2003-05-18	2
2003-05-19	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-20	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-21	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-22	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-23	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-24	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-25	16	4	2	2003	2003-05-19	2003-05-25	3
2003-05-26	17	4	2	2003	2003-05-26	2003-06-01	4
2003-05-27	17	4	2	2003	2003-05-26	2003-06-01	4
2003-05-28	17	4	2	2003	2003-05-26	2003-06-01	4
2003-05-29	17	4	2	2003	2003-05-26	2003-06-01	4
2003-05-30	17	4	2	2003	2003-05-26	2003-06-01	4
2003-05-31	17	4	2	2003	2003-05-26	2003-06-01	4
2003-06-01	17	4	2	2003	2003-05-26	2003-06-01	4
2003-06-02	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-03	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-04	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-05	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-06	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-07	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-08	18	5	2	2003	2003-06-02	2003-06-08	1
2003-06-09	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-10	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-11	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-12	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-13	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-14	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-15	19	5	2	2003	2003-06-09	2003-06-15	2
2003-06-16	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-17	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-18	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-19	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-20	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-21	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-22	20	5	2	2003	2003-06-16	2003-06-22	3
2003-06-23	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-24	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-25	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-26	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-27	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-28	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-29	21	5	2	2003	2003-06-23	2003-06-29	4
2003-06-30	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-01	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-02	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-03	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-04	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-05	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-06	22	6	2	2003	2003-06-30	2003-07-06	1
2003-07-07	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-08	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-09	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-10	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-11	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-12	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-13	23	6	2	2003	2003-07-07	2003-07-13	2
2003-07-14	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-15	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-16	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-17	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-18	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-19	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-20	24	6	2	2003	2003-07-14	2003-07-20	3
2003-07-21	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-22	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-23	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-24	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-25	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-26	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-27	25	6	2	2003	2003-07-21	2003-07-27	4
2003-07-28	26	6	2	2003	2003-07-28	2003-08-03	5
2003-07-29	26	6	2	2003	2003-07-28	2003-08-03	5
2003-07-30	26	6	2	2003	2003-07-28	2003-08-03	5
2003-07-31	26	6	2	2003	2003-07-28	2003-08-03	5
2003-08-01	26	6	2	2003	2003-07-28	2003-08-03	5
2003-08-02	26	6	2	2003	2003-07-28	2003-08-03	5
2003-08-03	26	6	2	2003	2003-07-28	2003-08-03	5
2003-08-04	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-05	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-06	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-07	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-08	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-09	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-10	27	7	2	2003	2003-08-04	2003-08-10	1
2003-08-11	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-12	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-13	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-14	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-15	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-16	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-17	28	7	2	2003	2003-08-11	2003-08-17	2
2003-08-18	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-19	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-20	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-21	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-22	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-23	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-24	29	7	2	2003	2003-08-18	2003-08-24	3
2003-08-25	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-26	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-27	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-28	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-29	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-30	30	7	2	2003	2003-08-25	2003-08-31	4
2003-08-31	30	7	2	2003	2003-08-25	2003-08-31	4
2003-09-01	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-02	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-03	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-04	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-05	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-06	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-07	31	8	3	2003	2003-09-01	2003-09-07	1
2003-09-08	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-09	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-10	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-11	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-12	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-13	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-14	32	8	3	2003	2003-09-08	2003-09-14	2
2003-09-15	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-16	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-17	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-18	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-19	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-20	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-21	33	8	3	2003	2003-09-15	2003-09-21	3
2003-09-22	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-23	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-24	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-25	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-26	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-27	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-28	34	8	3	2003	2003-09-22	2003-09-28	4
2003-09-29	35	9	3	2003	2003-09-29	2003-10-05	1
2003-09-30	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-01	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-02	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-03	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-04	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-05	35	9	3	2003	2003-09-29	2003-10-05	1
2003-10-06	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-07	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-08	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-09	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-10	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-11	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-12	36	9	3	2003	2003-10-06	2003-10-12	2
2003-10-13	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-14	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-15	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-16	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-17	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-18	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-19	37	9	3	2003	2003-10-13	2003-10-19	3
2003-10-20	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-21	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-22	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-23	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-24	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-25	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-26	38	9	3	2003	2003-10-20	2003-10-26	4
2003-10-27	39	9	3	2003	2003-10-27	2003-11-02	5
2003-10-28	39	9	3	2003	2003-10-27	2003-11-02	5
2003-10-29	39	9	3	2003	2003-10-27	2003-11-02	5
2003-10-30	39	9	3	2003	2003-10-27	2003-11-02	5
2003-10-31	39	9	3	2003	2003-10-27	2003-11-02	5
2003-11-01	39	9	3	2003	2003-10-27	2003-11-02	5
2003-11-02	39	9	3	2003	2003-10-27	2003-11-02	5
2003-11-03	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-04	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-05	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-06	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-07	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-08	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-09	40	10	3	2003	2003-11-03	2003-11-09	1
2003-11-10	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-11	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-12	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-13	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-14	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-15	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-16	41	10	3	2003	2003-11-10	2003-11-16	2
2003-11-17	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-18	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-19	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-20	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-21	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-22	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-23	42	10	3	2003	2003-11-17	2003-11-23	3
2003-11-24	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-25	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-26	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-27	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-28	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-29	43	10	3	2003	2003-11-24	2003-11-30	4
2003-11-30	43	10	3	2003	2003-11-24	2003-11-30	4
2003-12-01	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-02	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-03	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-04	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-05	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-06	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-07	44	11	3	2003	2003-12-01	2003-12-07	1
2003-12-08	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-09	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-10	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-11	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-12	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-13	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-14	45	11	3	2003	2003-12-08	2003-12-14	2
2003-12-15	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-16	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-17	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-18	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-19	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-20	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-21	46	11	3	2003	2003-12-15	2003-12-21	3
2003-12-22	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-23	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-24	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-25	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-26	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-27	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-28	47	11	3	2003	2003-12-22	2003-12-28	4
2003-12-29	48	12	4	2003	2003-12-29	2004-01-04	1
2003-12-30	48	12	4	2003	2003-12-29	2004-01-04	1
2003-12-31	48	12	4	2003	2003-12-29	2004-01-04	1
2004-01-01	48	12	4	2003	2003-12-29	2004-01-04	1
2004-01-02	48	12	4	2003	2003-12-29	2004-01-04	1
2004-01-03	48	12	4	2003	2003-12-29	2004-01-04	1
2004-01-04	48	12	4	2003	2003-12-29	2004-01-04	1
2004-01-05	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-06	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-07	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-08	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-09	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-10	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-11	49	12	4	2003	2004-01-05	2004-01-11	2
2004-01-12	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-13	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-14	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-15	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-16	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-17	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-18	50	12	4	2003	2004-01-12	2004-01-18	3
2004-01-19	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-20	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-21	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-22	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-23	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-24	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-25	51	12	4	2003	2004-01-19	2004-01-25	4
2004-01-26	52	12	4	2003	2004-01-26	2004-02-01	5
2004-01-27	52	12	4	2003	2004-01-26	2004-02-01	5
2004-01-28	52	12	4	2003	2004-01-26	2004-02-01	5
2004-01-29	52	12	4	2003	2004-01-26	2004-02-01	5
2004-01-30	52	12	4	2003	2004-01-26	2004-02-01	5
2004-01-31	52	12	4	2003	2004-01-26	2004-02-01	5
2004-02-01	52	12	4	2003	2004-01-26	2004-02-01	5
2004-02-02	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-03	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-04	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-05	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-06	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-07	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-08	1	1	1	2004	2004-02-02	2004-02-08	1
2004-02-09	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-10	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-11	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-12	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-13	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-14	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-15	2	1	1	2004	2004-02-09	2004-02-15	2
2004-02-16	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-17	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-18	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-19	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-20	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-21	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-22	3	1	1	2004	2004-02-16	2004-02-22	3
2004-02-23	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-24	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-25	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-26	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-27	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-28	4	1	1	2004	2004-02-23	2004-02-29	4
2004-02-29	4	1	1	2004	2004-02-23	2004-02-29	4
2004-03-01	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-02	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-03	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-04	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-05	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-06	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-07	5	2	1	2004	2004-03-01	2004-03-07	1
2004-03-08	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-09	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-10	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-11	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-12	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-13	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-14	6	2	1	2004	2004-03-08	2004-03-14	2
2004-03-15	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-16	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-17	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-18	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-19	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-20	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-21	7	2	1	2004	2004-03-15	2004-03-21	3
2004-03-22	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-23	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-24	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-25	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-26	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-27	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-28	8	2	1	2004	2004-03-22	2004-03-28	4
2004-03-29	9	3	1	2004	2004-03-29	2004-04-04	1
2004-03-30	9	3	1	2004	2004-03-29	2004-04-04	1
2004-03-31	9	3	1	2004	2004-03-29	2004-04-04	1
2004-04-01	9	3	1	2004	2004-03-29	2004-04-04	1
2004-04-02	9	3	1	2004	2004-03-29	2004-04-04	1
2004-04-03	9	3	1	2004	2004-03-29	2004-04-04	1
2004-04-04	9	3	1	2004	2004-03-29	2004-04-04	1
2004-04-05	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-06	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-07	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-08	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-09	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-10	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-11	10	3	1	2004	2004-04-05	2004-04-11	2
2004-04-12	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-13	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-14	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-15	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-16	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-17	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-18	11	3	1	2004	2004-04-12	2004-04-18	3
2004-04-19	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-20	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-21	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-22	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-23	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-24	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-25	12	3	1	2004	2004-04-19	2004-04-25	4
2004-04-26	13	3	1	2004	2004-04-26	2004-05-02	5
2004-04-27	13	3	1	2004	2004-04-26	2004-05-02	5
2004-04-28	13	3	1	2004	2004-04-26	2004-05-02	5
2004-04-29	13	3	1	2004	2004-04-26	2004-05-02	5
2004-04-30	13	3	1	2004	2004-04-26	2004-05-02	5
2004-05-01	13	3	1	2004	2004-04-26	2004-05-02	5
2004-05-02	13	3	1	2004	2004-04-26	2004-05-02	5
2004-05-03	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-04	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-05	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-06	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-07	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-08	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-09	14	4	2	2004	2004-05-03	2004-05-09	1
2004-05-10	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-11	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-12	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-13	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-14	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-15	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-16	15	4	2	2004	2004-05-10	2004-05-16	2
2004-05-17	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-18	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-19	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-20	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-21	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-22	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-23	16	4	2	2004	2004-05-17	2004-05-23	3
2004-05-24	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-25	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-26	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-27	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-28	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-29	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-30	17	4	2	2004	2004-05-24	2004-05-30	4
2004-05-31	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-01	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-02	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-03	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-04	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-05	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-06	18	5	2	2004	2004-05-31	2004-06-06	1
2004-06-07	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-08	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-09	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-10	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-11	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-12	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-13	19	5	2	2004	2004-06-07	2004-06-13	2
2004-06-14	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-15	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-16	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-17	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-18	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-19	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-20	20	5	2	2004	2004-06-14	2004-06-20	3
2004-06-21	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-22	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-23	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-24	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-25	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-26	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-27	21	5	2	2004	2004-06-21	2004-06-27	4
2004-06-28	22	6	2	2004	2004-06-28	2004-07-04	1
2004-06-29	22	6	2	2004	2004-06-28	2004-07-04	1
2004-06-30	22	6	2	2004	2004-06-28	2004-07-04	1
2004-07-01	22	6	2	2004	2004-06-28	2004-07-04	1
2004-07-02	22	6	2	2004	2004-06-28	2004-07-04	1
2004-07-03	22	6	2	2004	2004-06-28	2004-07-04	1
2004-07-04	22	6	2	2004	2004-06-28	2004-07-04	1
2004-07-05	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-06	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-07	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-08	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-09	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-10	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-11	23	6	2	2004	2004-07-05	2004-07-11	2
2004-07-12	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-13	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-14	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-15	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-16	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-17	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-18	24	6	2	2004	2004-07-12	2004-07-18	3
2004-07-19	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-20	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-21	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-22	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-23	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-24	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-25	25	6	2	2004	2004-07-19	2004-07-25	4
2004-07-26	26	6	2	2004	2004-07-26	2004-08-01	5
2004-07-27	26	6	2	2004	2004-07-26	2004-08-01	5
2004-07-28	26	6	2	2004	2004-07-26	2004-08-01	5
2004-07-29	26	6	2	2004	2004-07-26	2004-08-01	5
2004-07-30	26	6	2	2004	2004-07-26	2004-08-01	5
2004-07-31	26	6	2	2004	2004-07-26	2004-08-01	5
2004-08-01	26	6	2	2004	2004-07-26	2004-08-01	5
2004-08-02	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-03	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-04	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-05	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-06	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-07	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-08	27	7	2	2004	2004-08-02	2004-08-08	1
2004-08-09	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-10	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-11	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-12	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-13	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-14	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-15	28	7	2	2004	2004-08-09	2004-08-15	2
2004-08-16	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-17	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-18	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-19	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-20	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-21	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-22	29	7	2	2004	2004-08-16	2004-08-22	3
2004-08-23	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-24	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-25	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-26	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-27	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-28	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-29	30	7	2	2004	2004-08-23	2004-08-29	4
2004-08-30	31	8	3	2004	2004-08-30	2004-09-05	1
2004-08-31	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-01	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-02	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-03	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-04	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-05	31	8	3	2004	2004-08-30	2004-09-05	1
2004-09-06	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-07	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-08	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-09	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-10	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-11	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-12	32	8	3	2004	2004-09-06	2004-09-12	2
2004-09-13	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-14	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-15	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-16	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-17	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-18	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-19	33	8	3	2004	2004-09-13	2004-09-19	3
2004-09-20	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-21	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-22	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-23	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-24	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-25	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-26	34	8	3	2004	2004-09-20	2004-09-26	4
2004-09-27	35	9	3	2004	2004-09-27	2004-10-03	1
2004-09-28	35	9	3	2004	2004-09-27	2004-10-03	1
2004-09-29	35	9	3	2004	2004-09-27	2004-10-03	1
2004-09-30	35	9	3	2004	2004-09-27	2004-10-03	1
2004-10-01	35	9	3	2004	2004-09-27	2004-10-03	1
2004-10-02	35	9	3	2004	2004-09-27	2004-10-03	1
2004-10-03	35	9	3	2004	2004-09-27	2004-10-03	1
2004-10-04	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-05	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-06	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-07	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-08	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-09	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-10	36	9	3	2004	2004-10-04	2004-10-10	2
2004-10-11	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-12	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-13	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-14	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-15	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-16	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-17	37	9	3	2004	2004-10-11	2004-10-17	3
2004-10-18	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-19	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-20	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-21	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-22	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-23	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-24	38	9	3	2004	2004-10-18	2004-10-24	4
2004-10-25	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-26	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-27	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-28	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-29	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-30	39	9	3	2004	2004-10-25	2004-10-31	5
2004-10-31	39	9	3	2004	2004-10-25	2004-10-31	5
2004-11-01	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-02	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-03	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-04	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-05	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-06	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-07	40	10	3	2004	2004-11-01	2004-11-07	1
2004-11-08	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-09	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-10	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-11	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-12	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-13	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-14	41	10	3	2004	2004-11-08	2004-11-14	2
2004-11-15	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-16	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-17	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-18	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-19	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-20	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-21	42	10	3	2004	2004-11-15	2004-11-21	3
2004-11-22	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-23	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-24	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-25	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-26	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-27	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-28	43	10	3	2004	2004-11-22	2004-11-28	4
2004-11-29	44	11	3	2004	2004-11-29	2004-12-05	1
2004-11-30	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-01	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-02	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-03	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-04	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-05	44	11	3	2004	2004-11-29	2004-12-05	1
2004-12-06	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-07	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-08	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-09	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-10	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-11	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-12	45	11	3	2004	2004-12-06	2004-12-12	2
2004-12-13	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-14	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-15	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-16	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-17	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-18	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-19	46	11	3	2004	2004-12-13	2004-12-19	3
2004-12-20	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-21	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-22	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-23	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-24	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-25	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-26	47	11	3	2004	2004-12-20	2004-12-26	4
2004-12-27	48	12	4	2004	2004-12-27	2005-01-02	1
2004-12-28	48	12	4	2004	2004-12-27	2005-01-02	1
2004-12-29	48	12	4	2004	2004-12-27	2005-01-02	1
2004-12-30	48	12	4	2004	2004-12-27	2005-01-02	1
2004-12-31	48	12	4	2004	2004-12-27	2005-01-02	1
2005-01-01	48	12	4	2004	2004-12-27	2005-01-02	1
2005-01-02	48	12	4	2004	2004-12-27	2005-01-02	1
2005-01-03	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-04	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-05	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-06	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-07	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-08	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-09	49	12	4	2004	2005-01-03	2005-01-09	2
2005-01-10	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-11	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-12	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-13	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-14	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-15	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-16	50	12	4	2004	2005-01-10	2005-01-16	3
2005-01-17	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-18	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-19	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-20	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-21	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-22	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-23	51	12	4	2004	2005-01-17	2005-01-23	4
2005-01-24	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-25	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-26	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-27	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-28	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-29	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-30	52	12	4	2004	2005-01-24	2005-01-30	5
2005-01-31	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-01	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-02	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-03	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-04	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-05	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-06	1	1	1	2005	2005-01-31	2005-02-06	1
2005-02-07	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-08	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-09	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-10	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-11	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-12	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-13	2	1	1	2005	2005-02-07	2005-02-13	2
2005-02-14	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-15	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-16	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-17	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-18	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-19	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-20	3	1	1	2005	2005-02-14	2005-02-20	3
2005-02-21	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-22	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-23	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-24	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-25	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-26	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-27	4	1	1	2005	2005-02-21	2005-02-27	4
2005-02-28	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-01	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-02	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-03	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-04	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-05	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-06	5	2	1	2005	2005-02-28	2005-03-06	1
2005-03-07	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-08	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-09	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-10	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-11	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-12	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-13	6	2	1	2005	2005-03-07	2005-03-13	2
2005-03-14	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-15	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-16	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-17	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-18	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-19	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-20	7	2	1	2005	2005-03-14	2005-03-20	3
2005-03-21	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-22	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-23	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-24	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-25	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-26	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-27	8	2	1	2005	2005-03-21	2005-03-27	4
2005-03-28	9	3	1	2005	2005-03-28	2005-04-03	1
2005-03-29	9	3	1	2005	2005-03-28	2005-04-03	1
2005-03-30	9	3	1	2005	2005-03-28	2005-04-03	1
2005-03-31	9	3	1	2005	2005-03-28	2005-04-03	1
2005-04-01	9	3	1	2005	2005-03-28	2005-04-03	1
2005-04-02	9	3	1	2005	2005-03-28	2005-04-03	1
2005-04-03	9	3	1	2005	2005-03-28	2005-04-03	1
2005-04-04	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-05	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-06	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-07	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-08	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-09	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-10	10	3	1	2005	2005-04-04	2005-04-10	2
2005-04-11	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-12	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-13	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-14	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-15	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-16	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-17	11	3	1	2005	2005-04-11	2005-04-17	3
2005-04-18	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-19	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-20	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-21	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-22	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-23	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-24	12	3	1	2005	2005-04-18	2005-04-24	4
2005-04-25	13	3	1	2005	2005-04-25	2005-05-01	5
2005-04-26	13	3	1	2005	2005-04-25	2005-05-01	5
2005-04-27	13	3	1	2005	2005-04-25	2005-05-01	5
2005-04-28	13	3	1	2005	2005-04-25	2005-05-01	5
2005-04-29	13	3	1	2005	2005-04-25	2005-05-01	5
2005-04-30	13	3	1	2005	2005-04-25	2005-05-01	5
2005-05-01	13	3	1	2005	2005-04-25	2005-05-01	5
2005-05-02	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-03	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-04	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-05	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-06	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-07	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-08	14	4	2	2005	2005-05-02	2005-05-08	1
2005-05-09	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-10	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-11	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-12	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-13	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-14	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-15	15	4	2	2005	2005-05-09	2005-05-15	2
2005-05-16	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-17	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-18	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-19	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-20	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-21	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-22	16	4	2	2005	2005-05-16	2005-05-22	3
2005-05-23	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-24	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-25	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-26	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-27	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-28	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-29	17	4	2	2005	2005-05-23	2005-05-29	4
2005-05-30	18	5	2	2005	2005-05-30	2005-06-05	1
2005-05-31	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-01	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-02	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-03	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-04	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-05	18	5	2	2005	2005-05-30	2005-06-05	1
2005-06-06	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-07	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-08	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-09	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-10	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-11	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-12	19	5	2	2005	2005-06-06	2005-06-12	2
2005-06-13	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-14	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-15	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-16	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-17	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-18	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-19	20	5	2	2005	2005-06-13	2005-06-19	3
2005-06-20	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-21	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-22	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-23	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-24	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-25	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-26	21	5	2	2005	2005-06-20	2005-06-26	4
2005-06-27	22	6	2	2005	2005-06-27	2005-07-03	1
2005-06-28	22	6	2	2005	2005-06-27	2005-07-03	1
2005-06-29	22	6	2	2005	2005-06-27	2005-07-03	1
2005-06-30	22	6	2	2005	2005-06-27	2005-07-03	1
2005-07-01	22	6	2	2005	2005-06-27	2005-07-03	1
2005-07-02	22	6	2	2005	2005-06-27	2005-07-03	1
2005-07-03	22	6	2	2005	2005-06-27	2005-07-03	1
2005-07-04	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-05	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-06	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-07	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-08	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-09	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-10	23	6	2	2005	2005-07-04	2005-07-10	2
2005-07-11	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-12	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-13	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-14	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-15	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-16	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-17	24	6	2	2005	2005-07-11	2005-07-17	3
2005-07-18	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-19	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-20	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-21	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-22	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-23	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-24	25	6	2	2005	2005-07-18	2005-07-24	4
2005-07-25	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-26	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-27	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-28	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-29	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-30	26	6	2	2005	2005-07-25	2005-07-31	5
2005-07-31	26	6	2	2005	2005-07-25	2005-07-31	5
2005-08-01	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-02	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-03	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-04	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-05	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-06	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-07	27	7	2	2005	2005-08-01	2005-08-07	1
2005-08-08	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-09	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-10	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-11	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-12	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-13	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-14	28	7	2	2005	2005-08-08	2005-08-14	2
2005-08-15	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-16	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-17	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-18	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-19	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-20	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-21	29	7	2	2005	2005-08-15	2005-08-21	3
2005-08-22	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-23	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-24	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-25	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-26	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-27	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-28	30	7	2	2005	2005-08-22	2005-08-28	4
2005-08-29	31	8	3	2005	2005-08-29	2005-09-04	1
2005-08-30	31	8	3	2005	2005-08-29	2005-09-04	1
2005-08-31	31	8	3	2005	2005-08-29	2005-09-04	1
2005-09-01	31	8	3	2005	2005-08-29	2005-09-04	1
2005-09-02	31	8	3	2005	2005-08-29	2005-09-04	1
2005-09-03	31	8	3	2005	2005-08-29	2005-09-04	1
2005-09-04	31	8	3	2005	2005-08-29	2005-09-04	1
2005-09-05	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-06	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-07	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-08	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-09	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-10	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-11	32	8	3	2005	2005-09-05	2005-09-11	2
2005-09-12	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-13	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-14	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-15	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-16	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-17	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-18	33	8	3	2005	2005-09-12	2005-09-18	3
2005-09-19	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-20	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-21	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-22	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-23	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-24	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-25	34	8	3	2005	2005-09-19	2005-09-25	4
2005-09-26	35	9	3	2005	2005-09-26	2005-10-02	1
2005-09-27	35	9	3	2005	2005-09-26	2005-10-02	1
2005-09-28	35	9	3	2005	2005-09-26	2005-10-02	1
2005-09-29	35	9	3	2005	2005-09-26	2005-10-02	1
2005-09-30	35	9	3	2005	2005-09-26	2005-10-02	1
2005-10-01	35	9	3	2005	2005-09-26	2005-10-02	1
2005-10-02	35	9	3	2005	2005-09-26	2005-10-02	1
2005-10-03	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-04	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-05	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-06	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-07	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-08	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-09	36	9	3	2005	2005-10-03	2005-10-09	2
2005-10-10	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-11	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-12	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-13	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-14	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-15	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-16	37	9	3	2005	2005-10-10	2005-10-16	3
2005-10-17	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-18	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-19	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-20	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-21	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-22	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-23	38	9	3	2005	2005-10-17	2005-10-23	4
2005-10-24	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-25	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-26	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-27	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-28	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-29	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-30	39	9	3	2005	2005-10-24	2005-10-30	5
2005-10-31	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-01	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-02	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-03	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-04	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-05	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-06	40	10	3	2005	2005-10-31	2005-11-06	1
2005-11-07	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-08	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-09	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-10	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-11	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-12	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-13	41	10	3	2005	2005-11-07	2005-11-13	2
2005-11-14	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-15	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-16	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-17	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-18	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-19	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-20	42	10	3	2005	2005-11-14	2005-11-20	3
2005-11-21	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-22	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-23	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-24	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-25	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-26	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-27	43	10	3	2005	2005-11-21	2005-11-27	4
2005-11-28	44	11	3	2005	2005-11-28	2005-12-04	1
2005-11-29	44	11	3	2005	2005-11-28	2005-12-04	1
2005-11-30	44	11	3	2005	2005-11-28	2005-12-04	1
2005-12-01	44	11	3	2005	2005-11-28	2005-12-04	1
2005-12-02	44	11	3	2005	2005-11-28	2005-12-04	1
2005-12-03	44	11	3	2005	2005-11-28	2005-12-04	1
2005-12-04	44	11	3	2005	2005-11-28	2005-12-04	1
2005-12-05	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-06	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-07	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-08	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-09	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-10	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-11	45	11	3	2005	2005-12-05	2005-12-11	2
2005-12-12	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-13	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-14	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-15	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-16	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-17	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-18	46	11	3	2005	2005-12-12	2005-12-18	3
2005-12-19	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-20	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-21	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-22	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-23	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-24	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-25	47	11	3	2005	2005-12-19	2005-12-25	4
2005-12-26	48	12	4	2005	2005-12-26	2006-01-01	1
2005-12-27	48	12	4	2005	2005-12-26	2006-01-01	1
2005-12-28	48	12	4	2005	2005-12-26	2006-01-01	1
2005-12-29	48	12	4	2005	2005-12-26	2006-01-01	1
2005-12-30	48	12	4	2005	2005-12-26	2006-01-01	1
2005-12-31	48	12	4	2005	2005-12-26	2006-01-01	1
2006-01-01	48	12	4	2005	2005-12-26	2006-01-01	1
2006-01-02	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-03	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-04	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-05	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-06	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-07	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-08	49	12	4	2005	2006-01-02	2006-01-08	2
2006-01-09	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-10	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-11	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-12	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-13	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-14	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-15	50	12	4	2005	2006-01-09	2006-01-15	3
2006-01-16	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-17	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-18	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-19	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-20	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-21	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-22	51	12	4	2005	2006-01-16	2006-01-22	4
2006-01-23	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-24	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-25	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-26	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-27	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-28	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-29	52	12	4	2005	2006-01-23	2006-01-29	5
2006-01-30	1	1	1	2006	2006-01-30	2006-02-05	1
2006-01-31	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-01	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-02	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-03	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-04	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-05	1	1	1	2006	2006-01-30	2006-02-05	1
2006-02-06	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-07	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-08	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-09	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-10	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-11	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-12	2	1	1	2006	2006-02-06	2006-02-12	2
2006-02-13	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-14	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-15	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-16	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-17	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-18	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-19	3	1	1	2006	2006-02-13	2006-02-19	3
2006-02-20	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-21	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-22	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-23	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-24	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-25	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-26	4	1	1	2006	2006-02-20	2006-02-26	4
2006-02-27	5	2	1	2006	2006-02-27	2006-03-05	1
2006-02-28	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-01	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-02	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-03	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-04	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-05	5	2	1	2006	2006-02-27	2006-03-05	1
2006-03-06	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-07	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-08	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-09	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-10	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-11	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-12	6	2	1	2006	2006-03-06	2006-03-12	2
2006-03-13	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-14	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-15	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-16	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-17	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-18	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-19	7	2	1	2006	2006-03-13	2006-03-19	3
2006-03-20	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-21	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-22	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-23	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-24	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-25	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-26	8	2	1	2006	2006-03-20	2006-03-26	4
2006-03-27	9	3	1	2006	2006-03-27	2006-04-02	1
2006-03-28	9	3	1	2006	2006-03-27	2006-04-02	1
2006-03-29	9	3	1	2006	2006-03-27	2006-04-02	1
2006-03-30	9	3	1	2006	2006-03-27	2006-04-02	1
2006-03-31	9	3	1	2006	2006-03-27	2006-04-02	1
2006-04-01	9	3	1	2006	2006-03-27	2006-04-02	1
2006-04-02	9	3	1	2006	2006-03-27	2006-04-02	1
2006-04-03	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-04	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-05	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-06	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-07	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-08	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-09	10	3	1	2006	2006-04-03	2006-04-09	2
2006-04-10	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-11	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-12	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-13	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-14	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-15	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-16	11	3	1	2006	2006-04-10	2006-04-16	3
2006-04-17	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-18	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-19	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-20	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-21	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-22	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-23	12	3	1	2006	2006-04-17	2006-04-23	4
2006-04-24	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-25	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-26	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-27	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-28	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-29	13	3	1	2006	2006-04-24	2006-04-30	5
2006-04-30	13	3	1	2006	2006-04-24	2006-04-30	5
2006-05-01	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-02	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-03	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-04	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-05	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-06	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-07	14	4	2	2006	2006-05-01	2006-05-07	1
2006-05-08	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-09	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-10	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-11	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-12	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-13	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-14	15	4	2	2006	2006-05-08	2006-05-14	2
2006-05-15	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-16	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-17	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-18	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-19	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-20	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-21	16	4	2	2006	2006-05-15	2006-05-21	3
2006-05-22	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-23	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-24	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-25	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-26	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-27	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-28	17	4	2	2006	2006-05-22	2006-05-28	4
2006-05-29	18	5	2	2006	2006-05-29	2006-06-04	1
2006-05-30	18	5	2	2006	2006-05-29	2006-06-04	1
2006-05-31	18	5	2	2006	2006-05-29	2006-06-04	1
2006-06-01	18	5	2	2006	2006-05-29	2006-06-04	1
2006-06-02	18	5	2	2006	2006-05-29	2006-06-04	1
2006-06-03	18	5	2	2006	2006-05-29	2006-06-04	1
2006-06-04	18	5	2	2006	2006-05-29	2006-06-04	1
2006-06-05	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-06	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-07	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-08	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-09	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-10	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-11	19	5	2	2006	2006-06-05	2006-06-11	2
2006-06-12	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-13	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-14	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-15	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-16	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-17	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-18	20	5	2	2006	2006-06-12	2006-06-18	3
2006-06-19	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-20	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-21	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-22	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-23	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-24	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-25	21	5	2	2006	2006-06-19	2006-06-25	4
2006-06-26	22	6	2	2006	2006-06-26	2006-07-02	1
2006-06-27	22	6	2	2006	2006-06-26	2006-07-02	1
2006-06-28	22	6	2	2006	2006-06-26	2006-07-02	1
2006-06-29	22	6	2	2006	2006-06-26	2006-07-02	1
2006-06-30	22	6	2	2006	2006-06-26	2006-07-02	1
2006-07-01	22	6	2	2006	2006-06-26	2006-07-02	1
2006-07-02	22	6	2	2006	2006-06-26	2006-07-02	1
2006-07-03	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-04	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-05	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-06	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-07	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-08	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-09	23	6	2	2006	2006-07-03	2006-07-09	2
2006-07-10	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-11	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-12	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-13	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-14	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-15	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-16	24	6	2	2006	2006-07-10	2006-07-16	3
2006-07-17	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-18	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-19	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-20	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-21	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-22	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-23	25	6	2	2006	2006-07-17	2006-07-23	4
2006-07-24	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-25	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-26	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-27	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-28	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-29	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-30	26	6	2	2006	2006-07-24	2006-07-30	5
2006-07-31	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-01	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-02	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-03	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-04	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-05	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-06	27	7	2	2006	2006-07-31	2006-08-06	1
2006-08-07	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-08	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-09	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-10	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-11	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-12	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-13	28	7	2	2006	2006-08-07	2006-08-13	2
2006-08-14	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-15	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-16	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-17	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-18	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-19	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-20	29	7	2	2006	2006-08-14	2006-08-20	3
2006-08-21	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-22	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-23	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-24	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-25	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-26	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-27	30	7	2	2006	2006-08-21	2006-08-27	4
2006-08-28	31	8	3	2006	2006-08-28	2006-09-03	1
2006-08-29	31	8	3	2006	2006-08-28	2006-09-03	1
2006-08-30	31	8	3	2006	2006-08-28	2006-09-03	1
2006-08-31	31	8	3	2006	2006-08-28	2006-09-03	1
2006-09-01	31	8	3	2006	2006-08-28	2006-09-03	1
2006-09-02	31	8	3	2006	2006-08-28	2006-09-03	1
2006-09-03	31	8	3	2006	2006-08-28	2006-09-03	1
2006-09-04	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-05	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-06	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-07	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-08	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-09	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-10	32	8	3	2006	2006-09-04	2006-09-10	2
2006-09-11	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-12	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-13	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-14	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-15	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-16	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-17	33	8	3	2006	2006-09-11	2006-09-17	3
2006-09-18	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-19	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-20	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-21	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-22	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-23	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-24	34	8	3	2006	2006-09-18	2006-09-24	4
2006-09-25	35	9	3	2006	2006-09-25	2006-10-01	1
2006-09-26	35	9	3	2006	2006-09-25	2006-10-01	1
2006-09-27	35	9	3	2006	2006-09-25	2006-10-01	1
2006-09-28	35	9	3	2006	2006-09-25	2006-10-01	1
2006-09-29	35	9	3	2006	2006-09-25	2006-10-01	1
2006-09-30	35	9	3	2006	2006-09-25	2006-10-01	1
2006-10-01	35	9	3	2006	2006-09-25	2006-10-01	1
2006-10-02	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-03	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-04	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-05	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-06	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-07	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-08	36	9	3	2006	2006-10-02	2006-10-08	2
2006-10-09	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-10	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-11	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-12	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-13	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-14	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-15	37	9	3	2006	2006-10-09	2006-10-15	3
2006-10-16	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-17	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-18	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-19	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-20	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-21	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-22	38	9	3	2006	2006-10-16	2006-10-22	4
2006-10-23	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-24	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-25	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-26	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-27	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-28	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-29	39	9	3	2006	2006-10-23	2006-10-29	5
2006-10-30	40	10	3	2006	2006-10-30	2006-11-05	1
2006-10-31	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-01	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-02	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-03	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-04	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-05	40	10	3	2006	2006-10-30	2006-11-05	1
2006-11-06	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-07	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-08	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-09	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-10	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-11	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-12	41	10	3	2006	2006-11-06	2006-11-12	2
2006-11-13	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-14	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-15	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-16	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-17	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-18	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-19	42	10	3	2006	2006-11-13	2006-11-19	3
2006-11-20	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-21	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-22	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-23	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-24	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-25	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-26	43	10	3	2006	2006-11-20	2006-11-26	4
2006-11-27	44	11	3	2006	2006-11-27	2006-12-03	1
2006-11-28	44	11	3	2006	2006-11-27	2006-12-03	1
2006-11-29	44	11	3	2006	2006-11-27	2006-12-03	1
2006-11-30	44	11	3	2006	2006-11-27	2006-12-03	1
2006-12-01	44	11	3	2006	2006-11-27	2006-12-03	1
2006-12-02	44	11	3	2006	2006-11-27	2006-12-03	1
2006-12-03	44	11	3	2006	2006-11-27	2006-12-03	1
2006-12-04	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-05	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-06	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-07	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-08	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-09	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-10	45	11	3	2006	2006-12-04	2006-12-10	2
2006-12-11	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-12	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-13	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-14	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-15	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-16	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-17	46	11	3	2006	2006-12-11	2006-12-17	3
2006-12-18	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-19	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-20	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-21	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-22	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-23	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-24	47	11	3	2006	2006-12-18	2006-12-24	4
2006-12-25	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-26	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-27	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-28	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-29	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-30	48	12	4	2006	2006-12-25	2006-12-31	1
2006-12-31	48	12	4	2006	2006-12-25	2006-12-31	1
2007-01-01	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-02	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-03	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-04	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-05	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-06	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-07	49	12	4	2006	2007-01-01	2007-01-07	2
2007-01-08	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-09	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-10	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-11	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-12	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-13	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-14	50	12	4	2006	2007-01-08	2007-01-14	3
2007-01-15	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-16	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-17	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-18	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-19	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-20	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-21	51	12	4	2006	2007-01-15	2007-01-21	4
2007-01-22	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-23	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-24	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-25	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-26	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-27	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-28	52	12	4	2006	2007-01-22	2007-01-28	5
2007-01-29	1	1	1	2007	2007-01-29	2007-02-04	1
2007-01-30	1	1	1	2007	2007-01-29	2007-02-04	1
2007-01-31	1	1	1	2007	2007-01-29	2007-02-04	1
2007-02-01	1	1	1	2007	2007-01-29	2007-02-04	1
2007-02-02	1	1	1	2007	2007-01-29	2007-02-04	1
2007-02-03	1	1	1	2007	2007-01-29	2007-02-04	1
2007-02-04	1	1	1	2007	2007-01-29	2007-02-04	1
2007-02-05	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-06	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-07	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-08	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-09	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-10	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-11	2	1	1	2007	2007-02-05	2007-02-11	2
2007-02-12	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-13	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-14	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-15	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-16	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-17	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-18	3	1	1	2007	2007-02-12	2007-02-18	3
2007-02-19	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-20	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-21	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-22	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-23	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-24	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-25	4	1	1	2007	2007-02-19	2007-02-25	4
2007-02-26	5	2	1	2007	2007-02-26	2007-03-04	1
2007-02-27	5	2	1	2007	2007-02-26	2007-03-04	1
2007-02-28	5	2	1	2007	2007-02-26	2007-03-04	1
2007-03-01	5	2	1	2007	2007-02-26	2007-03-04	1
2007-03-02	5	2	1	2007	2007-02-26	2007-03-04	1
2007-03-03	5	2	1	2007	2007-02-26	2007-03-04	1
2007-03-04	5	2	1	2007	2007-02-26	2007-03-04	1
2007-03-05	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-06	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-07	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-08	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-09	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-10	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-11	6	2	1	2007	2007-03-05	2007-03-11	2
2007-03-12	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-13	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-14	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-15	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-16	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-17	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-18	7	2	1	2007	2007-03-12	2007-03-18	3
2007-03-19	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-20	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-21	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-22	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-23	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-24	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-25	8	2	1	2007	2007-03-19	2007-03-25	4
2007-03-26	9	3	1	2007	2007-03-26	2007-04-01	1
2007-03-27	9	3	1	2007	2007-03-26	2007-04-01	1
2007-03-28	9	3	1	2007	2007-03-26	2007-04-01	1
2007-03-29	9	3	1	2007	2007-03-26	2007-04-01	1
2007-03-30	9	3	1	2007	2007-03-26	2007-04-01	1
2007-03-31	9	3	1	2007	2007-03-26	2007-04-01	1
2007-04-01	9	3	1	2007	2007-03-26	2007-04-01	1
2007-04-02	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-03	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-04	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-05	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-06	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-07	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-08	10	3	1	2007	2007-04-02	2007-04-08	2
2007-04-09	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-10	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-11	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-12	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-13	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-14	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-15	11	3	1	2007	2007-04-09	2007-04-15	3
2007-04-16	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-17	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-18	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-19	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-20	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-21	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-22	12	3	1	2007	2007-04-16	2007-04-22	4
2007-04-23	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-24	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-25	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-26	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-27	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-28	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-29	13	3	1	2007	2007-04-23	2007-04-29	5
2007-04-30	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-01	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-02	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-03	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-04	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-05	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-06	14	4	2	2007	2007-04-30	2007-05-06	1
2007-05-07	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-08	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-09	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-10	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-11	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-12	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-13	15	4	2	2007	2007-05-07	2007-05-13	2
2007-05-14	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-15	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-16	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-17	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-18	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-19	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-20	16	4	2	2007	2007-05-14	2007-05-20	3
2007-05-21	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-22	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-23	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-24	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-25	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-26	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-27	17	4	2	2007	2007-05-21	2007-05-27	4
2007-05-28	18	5	2	2007	2007-05-28	2007-06-03	1
2007-05-29	18	5	2	2007	2007-05-28	2007-06-03	1
2007-05-30	18	5	2	2007	2007-05-28	2007-06-03	1
2007-05-31	18	5	2	2007	2007-05-28	2007-06-03	1
2007-06-01	18	5	2	2007	2007-05-28	2007-06-03	1
2007-06-02	18	5	2	2007	2007-05-28	2007-06-03	1
2007-06-03	18	5	2	2007	2007-05-28	2007-06-03	1
2007-06-04	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-05	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-06	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-07	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-08	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-09	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-10	19	5	2	2007	2007-06-04	2007-06-10	2
2007-06-11	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-12	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-13	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-14	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-15	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-16	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-17	20	5	2	2007	2007-06-11	2007-06-17	3
2007-06-18	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-19	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-20	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-21	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-22	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-23	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-24	21	5	2	2007	2007-06-18	2007-06-24	4
2007-06-25	22	6	2	2007	2007-06-25	2007-07-01	1
2007-06-26	22	6	2	2007	2007-06-25	2007-07-01	1
2007-06-27	22	6	2	2007	2007-06-25	2007-07-01	1
2007-06-28	22	6	2	2007	2007-06-25	2007-07-01	1
2007-06-29	22	6	2	2007	2007-06-25	2007-07-01	1
2007-06-30	22	6	2	2007	2007-06-25	2007-07-01	1
2007-07-01	22	6	2	2007	2007-06-25	2007-07-01	1
2007-07-02	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-03	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-04	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-05	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-06	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-07	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-08	23	6	2	2007	2007-07-02	2007-07-08	2
2007-07-09	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-10	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-11	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-12	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-13	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-14	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-15	24	6	2	2007	2007-07-09	2007-07-15	3
2007-07-16	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-17	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-18	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-19	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-20	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-21	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-22	25	6	2	2007	2007-07-16	2007-07-22	4
2007-07-23	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-24	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-25	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-26	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-27	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-28	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-29	26	6	2	2007	2007-07-23	2007-07-29	5
2007-07-30	27	7	2	2007	2007-07-30	2007-08-05	1
2007-07-31	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-01	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-02	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-03	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-04	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-05	27	7	2	2007	2007-07-30	2007-08-05	1
2007-08-06	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-07	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-08	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-09	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-10	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-11	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-12	28	7	2	2007	2007-08-06	2007-08-12	2
2007-08-13	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-14	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-15	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-16	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-17	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-18	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-19	29	7	2	2007	2007-08-13	2007-08-19	3
2007-08-20	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-21	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-22	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-23	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-24	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-25	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-26	30	7	2	2007	2007-08-20	2007-08-26	4
2007-08-27	31	8	3	2007	2007-08-27	2007-09-02	1
2007-08-28	31	8	3	2007	2007-08-27	2007-09-02	1
2007-08-29	31	8	3	2007	2007-08-27	2007-09-02	1
2007-08-30	31	8	3	2007	2007-08-27	2007-09-02	1
2007-08-31	31	8	3	2007	2007-08-27	2007-09-02	1
2007-09-01	31	8	3	2007	2007-08-27	2007-09-02	1
2007-09-02	31	8	3	2007	2007-08-27	2007-09-02	1
2007-09-03	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-04	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-05	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-06	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-07	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-08	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-09	32	8	3	2007	2007-09-03	2007-09-09	2
2007-09-10	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-11	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-12	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-13	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-14	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-15	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-16	33	8	3	2007	2007-09-10	2007-09-16	3
2007-09-17	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-18	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-19	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-20	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-21	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-22	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-23	34	8	3	2007	2007-09-17	2007-09-23	4
2007-09-24	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-25	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-26	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-27	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-28	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-29	35	9	3	2007	2007-09-24	2007-09-30	1
2007-09-30	35	9	3	2007	2007-09-24	2007-09-30	1
2007-10-01	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-02	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-03	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-04	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-05	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-06	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-07	36	9	3	2007	2007-10-01	2007-10-07	2
2007-10-08	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-09	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-10	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-11	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-12	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-13	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-14	37	9	3	2007	2007-10-08	2007-10-14	3
2007-10-15	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-16	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-17	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-18	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-19	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-20	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-21	38	9	3	2007	2007-10-15	2007-10-21	4
2007-10-22	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-23	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-24	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-25	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-26	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-27	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-28	39	9	3	2007	2007-10-22	2007-10-28	5
2007-10-29	40	10	3	2007	2007-10-29	2007-11-04	1
2007-10-30	40	10	3	2007	2007-10-29	2007-11-04	1
2007-10-31	40	10	3	2007	2007-10-29	2007-11-04	1
2007-11-01	40	10	3	2007	2007-10-29	2007-11-04	1
2007-11-02	40	10	3	2007	2007-10-29	2007-11-04	1
2007-11-03	40	10	3	2007	2007-10-29	2007-11-04	1
2007-11-04	40	10	3	2007	2007-10-29	2007-11-04	1
2007-11-05	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-06	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-07	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-08	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-09	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-10	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-11	41	10	3	2007	2007-11-05	2007-11-11	2
2007-11-12	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-13	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-14	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-15	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-16	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-17	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-18	42	10	3	2007	2007-11-12	2007-11-18	3
2007-11-19	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-20	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-21	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-22	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-23	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-24	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-25	43	10	3	2007	2007-11-19	2007-11-25	4
2007-11-26	44	11	3	2007	2007-11-26	2007-12-02	1
2007-11-27	44	11	3	2007	2007-11-26	2007-12-02	1
2007-11-28	44	11	3	2007	2007-11-26	2007-12-02	1
2007-11-29	44	11	3	2007	2007-11-26	2007-12-02	1
2007-11-30	44	11	3	2007	2007-11-26	2007-12-02	1
2007-12-01	44	11	3	2007	2007-11-26	2007-12-02	1
2007-12-02	44	11	3	2007	2007-11-26	2007-12-02	1
2007-12-03	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-04	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-05	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-06	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-07	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-08	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-09	45	11	3	2007	2007-12-03	2007-12-09	2
2007-12-10	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-11	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-12	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-13	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-14	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-15	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-16	46	11	3	2007	2007-12-10	2007-12-16	3
2007-12-17	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-18	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-19	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-20	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-21	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-22	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-23	47	11	3	2007	2007-12-17	2007-12-23	4
2007-12-24	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-25	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-26	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-27	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-28	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-29	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-30	48	12	4	2007	2007-12-24	2007-12-30	1
2007-12-31	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-01	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-02	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-03	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-04	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-05	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-06	49	12	4	2007	2007-12-31	2008-01-06	2
2008-01-07	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-08	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-09	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-10	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-11	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-12	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-13	50	12	4	2007	2008-01-07	2008-01-13	3
2008-01-14	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-15	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-16	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-17	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-18	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-19	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-20	51	12	4	2007	2008-01-14	2008-01-20	4
2008-01-21	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-22	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-23	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-24	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-25	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-26	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-27	52	12	4	2007	2008-01-21	2008-01-27	5
2008-01-28	53	12	4	2007	2008-01-28	2008-02-03	6
2008-01-29	53	12	4	2007	2008-01-28	2008-02-03	6
2008-01-30	53	12	4	2007	2008-01-28	2008-02-03	6
2008-01-31	53	12	4	2007	2008-01-28	2008-02-03	6
2008-02-01	53	12	4	2007	2008-01-28	2008-02-03	6
2008-02-02	53	12	4	2007	2008-01-28	2008-02-03	6
2008-02-03	53	12	4	2007	2008-01-28	2008-02-03	6
2008-02-04	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-05	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-06	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-07	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-08	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-09	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-10	1	1	1	2008	2008-02-04	2008-02-10	1
2008-02-11	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-12	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-13	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-14	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-15	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-16	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-17	2	1	1	2008	2008-02-11	2008-02-17	2
2008-02-18	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-19	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-20	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-21	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-22	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-23	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-24	3	1	1	2008	2008-02-18	2008-02-24	3
2008-02-25	4	1	1	2008	2008-02-25	2008-03-02	4
2008-02-26	4	1	1	2008	2008-02-25	2008-03-02	4
2008-02-27	4	1	1	2008	2008-02-25	2008-03-02	4
2008-02-28	4	1	1	2008	2008-02-25	2008-03-02	4
2008-02-29	4	1	1	2008	2008-02-25	2008-03-02	4
2008-03-01	4	1	1	2008	2008-02-25	2008-03-02	4
2008-03-02	4	1	1	2008	2008-02-25	2008-03-02	4
2008-03-03	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-04	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-05	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-06	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-07	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-08	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-09	5	2	1	2008	2008-03-03	2008-03-09	1
2008-03-10	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-11	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-12	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-13	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-14	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-15	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-16	6	2	1	2008	2008-03-10	2008-03-16	2
2008-03-17	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-18	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-19	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-20	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-21	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-22	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-23	7	2	1	2008	2008-03-17	2008-03-23	3
2008-03-24	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-25	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-26	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-27	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-28	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-29	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-30	8	2	1	2008	2008-03-24	2008-03-30	4
2008-03-31	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-01	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-02	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-03	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-04	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-05	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-06	9	3	1	2008	2008-03-31	2008-04-06	1
2008-04-07	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-08	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-09	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-10	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-11	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-12	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-13	10	3	1	2008	2008-04-07	2008-04-13	2
2008-04-14	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-15	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-16	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-17	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-18	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-19	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-20	11	3	1	2008	2008-04-14	2008-04-20	3
2008-04-21	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-22	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-23	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-24	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-25	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-26	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-27	12	3	1	2008	2008-04-21	2008-04-27	4
2008-04-28	13	3	1	2008	2008-04-28	2008-05-04	5
2008-04-29	13	3	1	2008	2008-04-28	2008-05-04	5
2008-04-30	13	3	1	2008	2008-04-28	2008-05-04	5
2008-05-01	13	3	1	2008	2008-04-28	2008-05-04	5
2008-05-02	13	3	1	2008	2008-04-28	2008-05-04	5
2008-05-03	13	3	1	2008	2008-04-28	2008-05-04	5
2008-05-04	13	3	1	2008	2008-04-28	2008-05-04	5
2008-05-05	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-06	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-07	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-08	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-09	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-10	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-11	14	4	2	2008	2008-05-05	2008-05-11	1
2008-05-12	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-13	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-14	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-15	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-16	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-17	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-18	15	4	2	2008	2008-05-12	2008-05-18	2
2008-05-19	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-20	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-21	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-22	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-23	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-24	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-25	16	4	2	2008	2008-05-19	2008-05-25	3
2008-05-26	17	4	2	2008	2008-05-26	2008-06-01	4
2008-05-27	17	4	2	2008	2008-05-26	2008-06-01	4
2008-05-28	17	4	2	2008	2008-05-26	2008-06-01	4
2008-05-29	17	4	2	2008	2008-05-26	2008-06-01	4
2008-05-30	17	4	2	2008	2008-05-26	2008-06-01	4
2008-05-31	17	4	2	2008	2008-05-26	2008-06-01	4
2008-06-01	17	4	2	2008	2008-05-26	2008-06-01	4
2008-06-02	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-03	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-04	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-05	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-06	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-07	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-08	18	5	2	2008	2008-06-02	2008-06-08	1
2008-06-09	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-10	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-11	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-12	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-13	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-14	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-15	19	5	2	2008	2008-06-09	2008-06-15	2
2008-06-16	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-17	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-18	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-19	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-20	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-21	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-22	20	5	2	2008	2008-06-16	2008-06-22	3
2008-06-23	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-24	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-25	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-26	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-27	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-28	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-29	21	5	2	2008	2008-06-23	2008-06-29	4
2008-06-30	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-01	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-02	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-03	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-04	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-05	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-06	22	6	2	2008	2008-06-30	2008-07-06	1
2008-07-07	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-08	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-09	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-10	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-11	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-12	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-13	23	6	2	2008	2008-07-07	2008-07-13	2
2008-07-14	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-15	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-16	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-17	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-18	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-19	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-20	24	6	2	2008	2008-07-14	2008-07-20	3
2008-07-21	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-22	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-23	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-24	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-25	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-26	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-27	25	6	2	2008	2008-07-21	2008-07-27	4
2008-07-28	26	6	2	2008	2008-07-28	2008-08-03	5
2008-07-29	26	6	2	2008	2008-07-28	2008-08-03	5
2008-07-30	26	6	2	2008	2008-07-28	2008-08-03	5
2008-07-31	26	6	2	2008	2008-07-28	2008-08-03	5
2008-08-01	26	6	2	2008	2008-07-28	2008-08-03	5
2008-08-02	26	6	2	2008	2008-07-28	2008-08-03	5
2008-08-03	26	6	2	2008	2008-07-28	2008-08-03	5
2008-08-04	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-05	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-06	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-07	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-08	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-09	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-10	27	7	2	2008	2008-08-04	2008-08-10	1
2008-08-11	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-12	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-13	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-14	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-15	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-16	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-17	28	7	2	2008	2008-08-11	2008-08-17	2
2008-08-18	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-19	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-20	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-21	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-22	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-23	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-24	29	7	2	2008	2008-08-18	2008-08-24	3
2008-08-25	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-26	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-27	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-28	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-29	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-30	30	7	2	2008	2008-08-25	2008-08-31	4
2008-08-31	30	7	2	2008	2008-08-25	2008-08-31	4
2008-09-01	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-02	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-03	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-04	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-05	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-06	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-07	31	8	3	2008	2008-09-01	2008-09-07	1
2008-09-08	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-09	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-10	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-11	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-12	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-13	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-14	32	8	3	2008	2008-09-08	2008-09-14	2
2008-09-15	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-16	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-17	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-18	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-19	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-20	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-21	33	8	3	2008	2008-09-15	2008-09-21	3
2008-09-22	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-23	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-24	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-25	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-26	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-27	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-28	34	8	3	2008	2008-09-22	2008-09-28	4
2008-09-29	35	9	3	2008	2008-09-29	2008-10-05	1
2008-09-30	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-01	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-02	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-03	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-04	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-05	35	9	3	2008	2008-09-29	2008-10-05	1
2008-10-06	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-07	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-08	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-09	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-10	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-11	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-12	36	9	3	2008	2008-10-06	2008-10-12	2
2008-10-13	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-14	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-15	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-16	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-17	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-18	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-19	37	9	3	2008	2008-10-13	2008-10-19	3
2008-10-20	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-21	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-22	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-23	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-24	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-25	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-26	38	9	3	2008	2008-10-20	2008-10-26	4
2008-10-27	39	9	3	2008	2008-10-27	2008-11-02	5
2008-10-28	39	9	3	2008	2008-10-27	2008-11-02	5
2008-10-29	39	9	3	2008	2008-10-27	2008-11-02	5
2008-10-30	39	9	3	2008	2008-10-27	2008-11-02	5
2008-10-31	39	9	3	2008	2008-10-27	2008-11-02	5
2008-11-01	39	9	3	2008	2008-10-27	2008-11-02	5
2008-11-02	39	9	3	2008	2008-10-27	2008-11-02	5
2008-11-03	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-04	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-05	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-06	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-07	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-08	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-09	40	10	3	2008	2008-11-03	2008-11-09	1
2008-11-10	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-11	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-12	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-13	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-14	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-15	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-16	41	10	3	2008	2008-11-10	2008-11-16	2
2008-11-17	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-18	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-19	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-20	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-21	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-22	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-23	42	10	3	2008	2008-11-17	2008-11-23	3
2008-11-24	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-25	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-26	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-27	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-28	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-29	43	10	3	2008	2008-11-24	2008-11-30	4
2008-11-30	43	10	3	2008	2008-11-24	2008-11-30	4
2008-12-01	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-02	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-03	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-04	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-05	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-06	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-07	44	11	3	2008	2008-12-01	2008-12-07	1
2008-12-08	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-09	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-10	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-11	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-12	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-13	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-14	45	11	3	2008	2008-12-08	2008-12-14	2
2008-12-15	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-16	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-17	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-18	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-19	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-20	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-21	46	11	3	2008	2008-12-15	2008-12-21	3
2008-12-22	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-23	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-24	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-25	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-26	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-27	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-28	47	11	3	2008	2008-12-22	2008-12-28	4
2008-12-29	48	12	4	2008	2008-12-29	2009-01-04	1
2008-12-30	48	12	4	2008	2008-12-29	2009-01-04	1
2008-12-31	48	12	4	2008	2008-12-29	2009-01-04	1
2009-01-01	48	12	4	2008	2008-12-29	2009-01-04	1
2009-01-02	48	12	4	2008	2008-12-29	2009-01-04	1
2009-01-03	48	12	4	2008	2008-12-29	2009-01-04	1
2009-01-04	48	12	4	2008	2008-12-29	2009-01-04	1
2009-01-05	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-06	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-07	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-08	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-09	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-10	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-11	49	12	4	2008	2009-01-05	2009-01-11	2
2009-01-12	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-13	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-14	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-15	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-16	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-17	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-18	50	12	4	2008	2009-01-12	2009-01-18	3
2009-01-19	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-20	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-21	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-22	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-23	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-24	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-25	51	12	4	2008	2009-01-19	2009-01-25	4
2009-01-26	52	12	4	2008	2009-01-26	2009-02-01	5
2009-01-27	52	12	4	2008	2009-01-26	2009-02-01	5
2009-01-28	52	12	4	2008	2009-01-26	2009-02-01	5
2009-01-29	52	12	4	2008	2009-01-26	2009-02-01	5
2009-01-30	52	12	4	2008	2009-01-26	2009-02-01	5
2009-01-31	52	12	4	2008	2009-01-26	2009-02-01	5
2009-02-01	52	12	4	2008	2009-01-26	2009-02-01	5
2009-02-02	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-03	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-04	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-05	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-06	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-07	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-08	1	1	1	2009	2009-02-02	2009-02-08	1
2009-02-09	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-10	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-11	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-12	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-13	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-14	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-15	2	1	1	2009	2009-02-09	2009-02-15	2
2009-02-16	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-17	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-18	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-19	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-20	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-21	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-22	3	1	1	2009	2009-02-16	2009-02-22	3
2009-02-23	4	1	1	2009	2009-02-23	2009-03-01	4
2009-02-24	4	1	1	2009	2009-02-23	2009-03-01	4
2009-02-25	4	1	1	2009	2009-02-23	2009-03-01	4
2009-02-26	4	1	1	2009	2009-02-23	2009-03-01	4
2009-02-27	4	1	1	2009	2009-02-23	2009-03-01	4
2009-02-28	4	1	1	2009	2009-02-23	2009-03-01	4
2009-03-01	4	1	1	2009	2009-02-23	2009-03-01	4
2009-03-02	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-03	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-04	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-05	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-06	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-07	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-08	5	2	1	2009	2009-03-02	2009-03-08	1
2009-03-09	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-10	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-11	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-12	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-13	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-14	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-15	6	2	1	2009	2009-03-09	2009-03-15	2
2009-03-16	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-17	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-18	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-19	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-20	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-21	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-22	7	2	1	2009	2009-03-16	2009-03-22	3
2009-03-23	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-24	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-25	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-26	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-27	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-28	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-29	8	2	1	2009	2009-03-23	2009-03-29	4
2009-03-30	9	3	1	2009	2009-03-30	2009-04-05	1
2009-03-31	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-01	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-02	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-03	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-04	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-05	9	3	1	2009	2009-03-30	2009-04-05	1
2009-04-06	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-07	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-08	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-09	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-10	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-11	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-12	10	3	1	2009	2009-04-06	2009-04-12	2
2009-04-13	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-14	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-15	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-16	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-17	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-18	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-19	11	3	1	2009	2009-04-13	2009-04-19	3
2009-04-20	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-21	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-22	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-23	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-24	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-25	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-26	12	3	1	2009	2009-04-20	2009-04-26	4
2009-04-27	13	3	1	2009	2009-04-27	2009-05-03	5
2009-04-28	13	3	1	2009	2009-04-27	2009-05-03	5
2009-04-29	13	3	1	2009	2009-04-27	2009-05-03	5
2009-04-30	13	3	1	2009	2009-04-27	2009-05-03	5
2009-05-01	13	3	1	2009	2009-04-27	2009-05-03	5
2009-05-02	13	3	1	2009	2009-04-27	2009-05-03	5
2009-05-03	13	3	1	2009	2009-04-27	2009-05-03	5
2009-05-04	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-05	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-06	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-07	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-08	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-09	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-10	14	4	2	2009	2009-05-04	2009-05-10	1
2009-05-11	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-12	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-13	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-14	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-15	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-16	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-17	15	4	2	2009	2009-05-11	2009-05-17	2
2009-05-18	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-19	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-20	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-21	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-22	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-23	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-24	16	4	2	2009	2009-05-18	2009-05-24	3
2009-05-25	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-26	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-27	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-28	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-29	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-30	17	4	2	2009	2009-05-25	2009-05-31	4
2009-05-31	17	4	2	2009	2009-05-25	2009-05-31	4
2009-06-01	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-02	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-03	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-04	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-05	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-06	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-07	18	5	2	2009	2009-06-01	2009-06-07	1
2009-06-08	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-09	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-10	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-11	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-12	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-13	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-14	19	5	2	2009	2009-06-08	2009-06-14	2
2009-06-15	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-16	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-17	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-18	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-19	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-20	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-21	20	5	2	2009	2009-06-15	2009-06-21	3
2009-06-22	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-23	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-24	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-25	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-26	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-27	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-28	21	5	2	2009	2009-06-22	2009-06-28	4
2009-06-29	22	6	2	2009	2009-06-29	2009-07-05	1
2009-06-30	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-01	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-02	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-03	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-04	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-05	22	6	2	2009	2009-06-29	2009-07-05	1
2009-07-06	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-07	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-08	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-09	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-10	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-11	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-12	23	6	2	2009	2009-07-06	2009-07-12	2
2009-07-13	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-14	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-15	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-16	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-17	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-18	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-19	24	6	2	2009	2009-07-13	2009-07-19	3
2009-07-20	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-21	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-22	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-23	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-24	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-25	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-26	25	6	2	2009	2009-07-20	2009-07-26	4
2009-07-27	26	6	2	2009	2009-07-27	2009-08-02	5
2009-07-28	26	6	2	2009	2009-07-27	2009-08-02	5
2009-07-29	26	6	2	2009	2009-07-27	2009-08-02	5
2009-07-30	26	6	2	2009	2009-07-27	2009-08-02	5
2009-07-31	26	6	2	2009	2009-07-27	2009-08-02	5
2009-08-01	26	6	2	2009	2009-07-27	2009-08-02	5
2009-08-02	26	6	2	2009	2009-07-27	2009-08-02	5
2009-08-03	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-04	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-05	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-06	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-07	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-08	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-09	27	7	2	2009	2009-08-03	2009-08-09	1
2009-08-10	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-11	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-12	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-13	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-14	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-15	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-16	28	7	2	2009	2009-08-10	2009-08-16	2
2009-08-17	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-18	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-19	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-20	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-21	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-22	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-23	29	7	2	2009	2009-08-17	2009-08-23	3
2009-08-24	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-25	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-26	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-27	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-28	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-29	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-30	30	7	2	2009	2009-08-24	2009-08-30	4
2009-08-31	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-01	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-02	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-03	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-04	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-05	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-06	31	8	3	2009	2009-08-31	2009-09-06	1
2009-09-07	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-08	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-09	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-10	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-11	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-12	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-13	32	8	3	2009	2009-09-07	2009-09-13	2
2009-09-14	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-15	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-16	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-17	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-18	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-19	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-20	33	8	3	2009	2009-09-14	2009-09-20	3
2009-09-21	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-22	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-23	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-24	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-25	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-26	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-27	34	8	3	2009	2009-09-21	2009-09-27	4
2009-09-28	35	9	3	2009	2009-09-28	2009-10-04	1
2009-09-29	35	9	3	2009	2009-09-28	2009-10-04	1
2009-09-30	35	9	3	2009	2009-09-28	2009-10-04	1
2009-10-01	35	9	3	2009	2009-09-28	2009-10-04	1
2009-10-02	35	9	3	2009	2009-09-28	2009-10-04	1
2009-10-03	35	9	3	2009	2009-09-28	2009-10-04	1
2009-10-04	35	9	3	2009	2009-09-28	2009-10-04	1
2009-10-05	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-06	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-07	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-08	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-09	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-10	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-11	36	9	3	2009	2009-10-05	2009-10-11	2
2009-10-12	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-13	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-14	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-15	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-16	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-17	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-18	37	9	3	2009	2009-10-12	2009-10-18	3
2009-10-19	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-20	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-21	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-22	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-23	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-24	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-25	38	9	3	2009	2009-10-19	2009-10-25	4
2009-10-26	39	9	3	2009	2009-10-26	2009-11-01	5
2009-10-27	39	9	3	2009	2009-10-26	2009-11-01	5
2009-10-28	39	9	3	2009	2009-10-26	2009-11-01	5
2009-10-29	39	9	3	2009	2009-10-26	2009-11-01	5
2009-10-30	39	9	3	2009	2009-10-26	2009-11-01	5
2009-10-31	39	9	3	2009	2009-10-26	2009-11-01	5
2009-11-01	39	9	3	2009	2009-10-26	2009-11-01	5
2009-11-02	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-03	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-04	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-05	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-06	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-07	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-08	40	10	3	2009	2009-11-02	2009-11-08	1
2009-11-09	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-10	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-11	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-12	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-13	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-14	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-15	41	10	3	2009	2009-11-09	2009-11-15	2
2009-11-16	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-17	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-18	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-19	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-20	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-21	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-22	42	10	3	2009	2009-11-16	2009-11-22	3
2009-11-23	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-24	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-25	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-26	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-27	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-28	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-29	43	10	3	2009	2009-11-23	2009-11-29	4
2009-11-30	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-01	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-02	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-03	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-04	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-05	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-06	44	11	3	2009	2009-11-30	2009-12-06	1
2009-12-07	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-08	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-09	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-10	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-11	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-12	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-13	45	11	3	2009	2009-12-07	2009-12-13	2
2009-12-14	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-15	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-16	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-17	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-18	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-19	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-20	46	11	3	2009	2009-12-14	2009-12-20	3
2009-12-21	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-22	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-23	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-24	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-25	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-26	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-27	47	11	3	2009	2009-12-21	2009-12-27	4
2009-12-28	48	12	4	2009	2009-12-28	2010-01-03	1
2009-12-29	48	12	4	2009	2009-12-28	2010-01-03	1
2009-12-30	48	12	4	2009	2009-12-28	2010-01-03	1
2009-12-31	48	12	4	2009	2009-12-28	2010-01-03	1
2010-01-01	48	12	4	2009	2009-12-28	2010-01-03	1
2010-01-02	48	12	4	2009	2009-12-28	2010-01-03	1
2010-01-03	48	12	4	2009	2009-12-28	2010-01-03	1
2010-01-04	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-05	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-06	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-07	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-08	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-09	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-10	49	12	4	2009	2010-01-04	2010-01-10	2
2010-01-11	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-12	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-13	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-14	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-15	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-16	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-17	50	12	4	2009	2010-01-11	2010-01-17	3
2010-01-18	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-19	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-20	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-21	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-22	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-23	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-24	51	12	4	2009	2010-01-18	2010-01-24	4
2010-01-25	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-26	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-27	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-28	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-29	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-30	52	12	4	2009	2010-01-25	2010-01-31	5
2010-01-31	52	12	4	2009	2010-01-25	2010-01-31	5
2010-02-01	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-02	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-03	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-04	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-05	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-06	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-07	1	1	1	2010	2010-02-01	2010-02-07	1
2010-02-08	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-09	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-10	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-11	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-12	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-13	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-14	2	1	1	2010	2010-02-08	2010-02-14	2
2010-02-15	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-16	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-17	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-18	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-19	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-20	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-21	3	1	1	2010	2010-02-15	2010-02-21	3
2010-02-22	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-23	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-24	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-25	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-26	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-27	4	1	1	2010	2010-02-22	2010-02-28	4
2010-02-28	4	1	1	2010	2010-02-22	2010-02-28	4
2010-03-01	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-02	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-03	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-04	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-05	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-06	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-07	5	2	1	2010	2010-03-01	2010-03-07	1
2010-03-08	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-09	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-10	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-11	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-12	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-13	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-14	6	2	1	2010	2010-03-08	2010-03-14	2
2010-03-15	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-16	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-17	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-18	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-19	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-20	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-21	7	2	1	2010	2010-03-15	2010-03-21	3
2010-03-22	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-23	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-24	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-25	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-26	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-27	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-28	8	2	1	2010	2010-03-22	2010-03-28	4
2010-03-29	9	3	1	2010	2010-03-29	2010-04-04	1
2010-03-30	9	3	1	2010	2010-03-29	2010-04-04	1
2010-03-31	9	3	1	2010	2010-03-29	2010-04-04	1
2010-04-01	9	3	1	2010	2010-03-29	2010-04-04	1
2010-04-02	9	3	1	2010	2010-03-29	2010-04-04	1
2010-04-03	9	3	1	2010	2010-03-29	2010-04-04	1
2010-04-04	9	3	1	2010	2010-03-29	2010-04-04	1
2010-04-05	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-06	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-07	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-08	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-09	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-10	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-11	10	3	1	2010	2010-04-05	2010-04-11	2
2010-04-12	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-13	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-14	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-15	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-16	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-17	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-18	11	3	1	2010	2010-04-12	2010-04-18	3
2010-04-19	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-20	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-21	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-22	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-23	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-24	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-25	12	3	1	2010	2010-04-19	2010-04-25	4
2010-04-26	13	3	1	2010	2010-04-26	2010-05-02	5
2010-04-27	13	3	1	2010	2010-04-26	2010-05-02	5
2010-04-28	13	3	1	2010	2010-04-26	2010-05-02	5
2010-04-29	13	3	1	2010	2010-04-26	2010-05-02	5
2010-04-30	13	3	1	2010	2010-04-26	2010-05-02	5
2010-05-01	13	3	1	2010	2010-04-26	2010-05-02	5
2010-05-02	13	3	1	2010	2010-04-26	2010-05-02	5
2010-05-03	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-04	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-05	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-06	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-07	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-08	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-09	14	4	2	2010	2010-05-03	2010-05-09	1
2010-05-10	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-11	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-12	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-13	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-14	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-15	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-16	15	4	2	2010	2010-05-10	2010-05-16	2
2010-05-17	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-18	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-19	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-20	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-21	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-22	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-23	16	4	2	2010	2010-05-17	2010-05-23	3
2010-05-24	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-25	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-26	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-27	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-28	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-29	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-30	17	4	2	2010	2010-05-24	2010-05-30	4
2010-05-31	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-01	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-02	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-03	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-04	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-05	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-06	18	5	2	2010	2010-05-31	2010-06-06	1
2010-06-07	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-08	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-09	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-10	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-11	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-12	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-13	19	5	2	2010	2010-06-07	2010-06-13	2
2010-06-14	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-15	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-16	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-17	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-18	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-19	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-20	20	5	2	2010	2010-06-14	2010-06-20	3
2010-06-21	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-22	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-23	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-24	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-25	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-26	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-27	21	5	2	2010	2010-06-21	2010-06-27	4
2010-06-28	22	6	2	2010	2010-06-28	2010-07-04	1
2010-06-29	22	6	2	2010	2010-06-28	2010-07-04	1
2010-06-30	22	6	2	2010	2010-06-28	2010-07-04	1
2010-07-01	22	6	2	2010	2010-06-28	2010-07-04	1
2010-07-02	22	6	2	2010	2010-06-28	2010-07-04	1
2010-07-03	22	6	2	2010	2010-06-28	2010-07-04	1
2010-07-04	22	6	2	2010	2010-06-28	2010-07-04	1
2010-07-05	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-06	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-07	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-08	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-09	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-10	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-11	23	6	2	2010	2010-07-05	2010-07-11	2
2010-07-12	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-13	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-14	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-15	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-16	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-17	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-18	24	6	2	2010	2010-07-12	2010-07-18	3
2010-07-19	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-20	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-21	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-22	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-23	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-24	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-25	25	6	2	2010	2010-07-19	2010-07-25	4
2010-07-26	26	6	2	2010	2010-07-26	2010-08-01	5
2010-07-27	26	6	2	2010	2010-07-26	2010-08-01	5
2010-07-28	26	6	2	2010	2010-07-26	2010-08-01	5
2010-07-29	26	6	2	2010	2010-07-26	2010-08-01	5
2010-07-30	26	6	2	2010	2010-07-26	2010-08-01	5
2010-07-31	26	6	2	2010	2010-07-26	2010-08-01	5
2010-08-01	26	6	2	2010	2010-07-26	2010-08-01	5
2010-08-02	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-03	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-04	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-05	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-06	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-07	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-08	27	7	2	2010	2010-08-02	2010-08-08	1
2010-08-09	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-10	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-11	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-12	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-13	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-14	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-15	28	7	2	2010	2010-08-09	2010-08-15	2
2010-08-16	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-17	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-18	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-19	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-20	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-21	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-22	29	7	2	2010	2010-08-16	2010-08-22	3
2010-08-23	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-24	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-25	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-26	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-27	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-28	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-29	30	7	2	2010	2010-08-23	2010-08-29	4
2010-08-30	31	8	3	2010	2010-08-30	2010-09-05	1
2010-08-31	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-01	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-02	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-03	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-04	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-05	31	8	3	2010	2010-08-30	2010-09-05	1
2010-09-06	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-07	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-08	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-09	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-10	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-11	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-12	32	8	3	2010	2010-09-06	2010-09-12	2
2010-09-13	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-14	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-15	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-16	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-17	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-18	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-19	33	8	3	2010	2010-09-13	2010-09-19	3
2010-09-20	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-21	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-22	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-23	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-24	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-25	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-26	34	8	3	2010	2010-09-20	2010-09-26	4
2010-09-27	35	9	3	2010	2010-09-27	2010-10-03	1
2010-09-28	35	9	3	2010	2010-09-27	2010-10-03	1
2010-09-29	35	9	3	2010	2010-09-27	2010-10-03	1
2010-09-30	35	9	3	2010	2010-09-27	2010-10-03	1
2010-10-01	35	9	3	2010	2010-09-27	2010-10-03	1
2010-10-02	35	9	3	2010	2010-09-27	2010-10-03	1
2010-10-03	35	9	3	2010	2010-09-27	2010-10-03	1
2010-10-04	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-05	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-06	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-07	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-08	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-09	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-10	36	9	3	2010	2010-10-04	2010-10-10	2
2010-10-11	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-12	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-13	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-14	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-15	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-16	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-17	37	9	3	2010	2010-10-11	2010-10-17	3
2010-10-18	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-19	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-20	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-21	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-22	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-23	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-24	38	9	3	2010	2010-10-18	2010-10-24	4
2010-10-25	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-26	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-27	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-28	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-29	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-30	39	9	3	2010	2010-10-25	2010-10-31	5
2010-10-31	39	9	3	2010	2010-10-25	2010-10-31	5
2010-11-01	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-02	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-03	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-04	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-05	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-06	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-07	40	10	3	2010	2010-11-01	2010-11-07	1
2010-11-08	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-09	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-10	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-11	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-12	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-13	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-14	41	10	3	2010	2010-11-08	2010-11-14	2
2010-11-15	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-16	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-17	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-18	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-19	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-20	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-21	42	10	3	2010	2010-11-15	2010-11-21	3
2010-11-22	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-23	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-24	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-25	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-26	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-27	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-28	43	10	3	2010	2010-11-22	2010-11-28	4
2010-11-29	44	11	3	2010	2010-11-29	2010-12-05	1
2010-11-30	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-01	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-02	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-03	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-04	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-05	44	11	3	2010	2010-11-29	2010-12-05	1
2010-12-06	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-07	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-08	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-09	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-10	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-11	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-12	45	11	3	2010	2010-12-06	2010-12-12	2
2010-12-13	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-14	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-15	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-16	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-17	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-18	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-19	46	11	3	2010	2010-12-13	2010-12-19	3
2010-12-20	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-21	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-22	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-23	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-24	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-25	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-26	47	11	3	2010	2010-12-20	2010-12-26	4
2010-12-27	48	12	4	2010	2010-12-27	2011-01-02	1
2010-12-28	48	12	4	2010	2010-12-27	2011-01-02	1
2010-12-29	48	12	4	2010	2010-12-27	2011-01-02	1
2010-12-30	48	12	4	2010	2010-12-27	2011-01-02	1
2010-12-31	48	12	4	2010	2010-12-27	2011-01-02	1
2011-01-01	48	12	4	2010	2010-12-27	2011-01-02	1
2011-01-02	48	12	4	2010	2010-12-27	2011-01-02	1
2011-01-03	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-04	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-05	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-06	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-07	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-08	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-09	49	12	4	2010	2011-01-03	2011-01-09	2
2011-01-10	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-11	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-12	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-13	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-14	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-15	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-16	50	12	4	2010	2011-01-10	2011-01-16	3
2011-01-17	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-18	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-19	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-20	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-21	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-22	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-23	51	12	4	2010	2011-01-17	2011-01-23	4
2011-01-24	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-25	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-26	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-27	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-28	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-29	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-30	52	12	4	2010	2011-01-24	2011-01-30	5
2011-01-31	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-01	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-02	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-03	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-04	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-05	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-06	1	1	1	2011	2011-01-31	2011-02-06	1
2011-02-07	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-08	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-09	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-10	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-11	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-12	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-13	2	1	1	2011	2011-02-07	2011-02-13	2
2011-02-14	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-15	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-16	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-17	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-18	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-19	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-20	3	1	1	2011	2011-02-14	2011-02-20	3
2011-02-21	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-22	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-23	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-24	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-25	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-26	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-27	4	1	1	2011	2011-02-21	2011-02-27	4
2011-02-28	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-01	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-02	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-03	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-04	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-05	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-06	5	2	1	2011	2011-02-28	2011-03-06	1
2011-03-07	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-08	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-09	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-10	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-11	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-12	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-13	6	2	1	2011	2011-03-07	2011-03-13	2
2011-03-14	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-15	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-16	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-17	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-18	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-19	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-20	7	2	1	2011	2011-03-14	2011-03-20	3
2011-03-21	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-22	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-23	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-24	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-25	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-26	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-27	8	2	1	2011	2011-03-21	2011-03-27	4
2011-03-28	9	3	1	2011	2011-03-28	2011-04-03	1
2011-03-29	9	3	1	2011	2011-03-28	2011-04-03	1
2011-03-30	9	3	1	2011	2011-03-28	2011-04-03	1
2011-03-31	9	3	1	2011	2011-03-28	2011-04-03	1
2011-04-01	9	3	1	2011	2011-03-28	2011-04-03	1
2011-04-02	9	3	1	2011	2011-03-28	2011-04-03	1
2011-04-03	9	3	1	2011	2011-03-28	2011-04-03	1
2011-04-04	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-05	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-06	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-07	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-08	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-09	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-10	10	3	1	2011	2011-04-04	2011-04-10	2
2011-04-11	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-12	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-13	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-14	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-15	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-16	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-17	11	3	1	2011	2011-04-11	2011-04-17	3
2011-04-18	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-19	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-20	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-21	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-22	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-23	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-24	12	3	1	2011	2011-04-18	2011-04-24	4
2011-04-25	13	3	1	2011	2011-04-25	2011-05-01	5
2011-04-26	13	3	1	2011	2011-04-25	2011-05-01	5
2011-04-27	13	3	1	2011	2011-04-25	2011-05-01	5
2011-04-28	13	3	1	2011	2011-04-25	2011-05-01	5
2011-04-29	13	3	1	2011	2011-04-25	2011-05-01	5
2011-04-30	13	3	1	2011	2011-04-25	2011-05-01	5
2011-05-01	13	3	1	2011	2011-04-25	2011-05-01	5
2011-05-02	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-03	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-04	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-05	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-06	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-07	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-08	14	4	2	2011	2011-05-02	2011-05-08	1
2011-05-09	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-10	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-11	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-12	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-13	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-14	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-15	15	4	2	2011	2011-05-09	2011-05-15	2
2011-05-16	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-17	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-18	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-19	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-20	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-21	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-22	16	4	2	2011	2011-05-16	2011-05-22	3
2011-05-23	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-24	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-25	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-26	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-27	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-28	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-29	17	4	2	2011	2011-05-23	2011-05-29	4
2011-05-30	18	5	2	2011	2011-05-30	2011-06-05	1
2011-05-31	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-01	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-02	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-03	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-04	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-05	18	5	2	2011	2011-05-30	2011-06-05	1
2011-06-06	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-07	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-08	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-09	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-10	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-11	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-12	19	5	2	2011	2011-06-06	2011-06-12	2
2011-06-13	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-14	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-15	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-16	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-17	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-18	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-19	20	5	2	2011	2011-06-13	2011-06-19	3
2011-06-20	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-21	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-22	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-23	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-24	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-25	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-26	21	5	2	2011	2011-06-20	2011-06-26	4
2011-06-27	22	6	2	2011	2011-06-27	2011-07-03	1
2011-06-28	22	6	2	2011	2011-06-27	2011-07-03	1
2011-06-29	22	6	2	2011	2011-06-27	2011-07-03	1
2011-06-30	22	6	2	2011	2011-06-27	2011-07-03	1
2011-07-01	22	6	2	2011	2011-06-27	2011-07-03	1
2011-07-02	22	6	2	2011	2011-06-27	2011-07-03	1
2011-07-03	22	6	2	2011	2011-06-27	2011-07-03	1
2011-07-04	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-05	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-06	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-07	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-08	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-09	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-10	23	6	2	2011	2011-07-04	2011-07-10	2
2011-07-11	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-12	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-13	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-14	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-15	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-16	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-17	24	6	2	2011	2011-07-11	2011-07-17	3
2011-07-18	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-19	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-20	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-21	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-22	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-23	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-24	25	6	2	2011	2011-07-18	2011-07-24	4
2011-07-25	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-26	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-27	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-28	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-29	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-30	26	6	2	2011	2011-07-25	2011-07-31	5
2011-07-31	26	6	2	2011	2011-07-25	2011-07-31	5
2011-08-01	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-02	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-03	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-04	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-05	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-06	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-07	27	7	2	2011	2011-08-01	2011-08-07	1
2011-08-08	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-09	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-10	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-11	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-12	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-13	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-14	28	7	2	2011	2011-08-08	2011-08-14	2
2011-08-15	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-16	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-17	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-18	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-19	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-20	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-21	29	7	2	2011	2011-08-15	2011-08-21	3
2011-08-22	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-23	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-24	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-25	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-26	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-27	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-28	30	7	2	2011	2011-08-22	2011-08-28	4
2011-08-29	31	8	3	2011	2011-08-29	2011-09-04	1
2011-08-30	31	8	3	2011	2011-08-29	2011-09-04	1
2011-08-31	31	8	3	2011	2011-08-29	2011-09-04	1
2011-09-01	31	8	3	2011	2011-08-29	2011-09-04	1
2011-09-02	31	8	3	2011	2011-08-29	2011-09-04	1
2011-09-03	31	8	3	2011	2011-08-29	2011-09-04	1
2011-09-04	31	8	3	2011	2011-08-29	2011-09-04	1
2011-09-05	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-06	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-07	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-08	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-09	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-10	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-11	32	8	3	2011	2011-09-05	2011-09-11	2
2011-09-12	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-13	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-14	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-15	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-16	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-17	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-18	33	8	3	2011	2011-09-12	2011-09-18	3
2011-09-19	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-20	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-21	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-22	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-23	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-24	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-25	34	8	3	2011	2011-09-19	2011-09-25	4
2011-09-26	35	9	3	2011	2011-09-26	2011-10-02	1
2011-09-27	35	9	3	2011	2011-09-26	2011-10-02	1
2011-09-28	35	9	3	2011	2011-09-26	2011-10-02	1
2011-09-29	35	9	3	2011	2011-09-26	2011-10-02	1
2011-09-30	35	9	3	2011	2011-09-26	2011-10-02	1
2011-10-01	35	9	3	2011	2011-09-26	2011-10-02	1
2011-10-02	35	9	3	2011	2011-09-26	2011-10-02	1
2011-10-03	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-04	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-05	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-06	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-07	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-08	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-09	36	9	3	2011	2011-10-03	2011-10-09	2
2011-10-10	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-11	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-12	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-13	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-14	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-15	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-16	37	9	3	2011	2011-10-10	2011-10-16	3
2011-10-17	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-18	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-19	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-20	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-21	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-22	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-23	38	9	3	2011	2011-10-17	2011-10-23	4
2011-10-24	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-25	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-26	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-27	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-28	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-29	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-30	39	9	3	2011	2011-10-24	2011-10-30	5
2011-10-31	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-01	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-02	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-03	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-04	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-05	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-06	40	10	3	2011	2011-10-31	2011-11-06	1
2011-11-07	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-08	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-09	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-10	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-11	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-12	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-13	41	10	3	2011	2011-11-07	2011-11-13	2
2011-11-14	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-15	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-16	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-17	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-18	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-19	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-20	42	10	3	2011	2011-11-14	2011-11-20	3
2011-11-21	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-22	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-23	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-24	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-25	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-26	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-27	43	10	3	2011	2011-11-21	2011-11-27	4
2011-11-28	44	11	3	2011	2011-11-28	2011-12-04	1
2011-11-29	44	11	3	2011	2011-11-28	2011-12-04	1
2011-11-30	44	11	3	2011	2011-11-28	2011-12-04	1
2011-12-01	44	11	3	2011	2011-11-28	2011-12-04	1
2011-12-02	44	11	3	2011	2011-11-28	2011-12-04	1
2011-12-03	44	11	3	2011	2011-11-28	2011-12-04	1
2011-12-04	44	11	3	2011	2011-11-28	2011-12-04	1
2011-12-05	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-06	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-07	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-08	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-09	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-10	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-11	45	11	3	2011	2011-12-05	2011-12-11	2
2011-12-12	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-13	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-14	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-15	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-16	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-17	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-18	46	11	3	2011	2011-12-12	2011-12-18	3
2011-12-19	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-20	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-21	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-22	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-23	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-24	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-25	47	11	3	2011	2011-12-19	2011-12-25	4
2011-12-26	48	12	4	2011	2011-12-26	2012-01-01	1
2011-12-27	48	12	4	2011	2011-12-26	2012-01-01	1
2011-12-28	48	12	4	2011	2011-12-26	2012-01-01	1
2011-12-29	48	12	4	2011	2011-12-26	2012-01-01	1
2011-12-30	48	12	4	2011	2011-12-26	2012-01-01	1
2011-12-31	48	12	4	2011	2011-12-26	2012-01-01	1
2012-01-01	48	12	4	2011	2011-12-26	2012-01-01	1
2012-01-02	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-03	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-04	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-05	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-06	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-07	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-08	49	12	4	2011	2012-01-02	2012-01-08	2
2012-01-09	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-10	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-11	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-12	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-13	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-14	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-15	50	12	4	2011	2012-01-09	2012-01-15	3
2012-01-16	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-17	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-18	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-19	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-20	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-21	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-22	51	12	4	2011	2012-01-16	2012-01-22	4
2012-01-23	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-24	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-25	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-26	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-27	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-28	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-29	52	12	4	2011	2012-01-23	2012-01-29	5
2012-01-30	1	1	1	2012	2012-01-30	2012-02-05	1
2012-01-31	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-01	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-02	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-03	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-04	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-05	1	1	1	2012	2012-01-30	2012-02-05	1
2012-02-06	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-07	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-08	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-09	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-10	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-11	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-12	2	1	1	2012	2012-02-06	2012-02-12	2
2012-02-13	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-14	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-15	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-16	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-17	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-18	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-19	3	1	1	2012	2012-02-13	2012-02-19	3
2012-02-20	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-21	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-22	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-23	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-24	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-25	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-26	4	1	1	2012	2012-02-20	2012-02-26	4
2012-02-27	5	2	1	2012	2012-02-27	2012-03-04	1
2012-02-28	5	2	1	2012	2012-02-27	2012-03-04	1
2012-02-29	5	2	1	2012	2012-02-27	2012-03-04	1
2012-03-01	5	2	1	2012	2012-02-27	2012-03-04	1
2012-03-02	5	2	1	2012	2012-02-27	2012-03-04	1
2012-03-03	5	2	1	2012	2012-02-27	2012-03-04	1
2012-03-04	5	2	1	2012	2012-02-27	2012-03-04	1
2012-03-05	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-06	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-07	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-08	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-09	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-10	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-11	6	2	1	2012	2012-03-05	2012-03-11	2
2012-03-12	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-13	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-14	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-15	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-16	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-17	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-18	7	2	1	2012	2012-03-12	2012-03-18	3
2012-03-19	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-20	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-21	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-22	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-23	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-24	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-25	8	2	1	2012	2012-03-19	2012-03-25	4
2012-03-26	9	3	1	2012	2012-03-26	2012-04-01	1
2012-03-27	9	3	1	2012	2012-03-26	2012-04-01	1
2012-03-28	9	3	1	2012	2012-03-26	2012-04-01	1
2012-03-29	9	3	1	2012	2012-03-26	2012-04-01	1
2012-03-30	9	3	1	2012	2012-03-26	2012-04-01	1
2012-03-31	9	3	1	2012	2012-03-26	2012-04-01	1
2012-04-01	9	3	1	2012	2012-03-26	2012-04-01	1
2012-04-02	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-03	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-04	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-05	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-06	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-07	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-08	10	3	1	2012	2012-04-02	2012-04-08	2
2012-04-09	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-10	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-11	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-12	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-13	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-14	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-15	11	3	1	2012	2012-04-09	2012-04-15	3
2012-04-16	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-17	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-18	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-19	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-20	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-21	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-22	12	3	1	2012	2012-04-16	2012-04-22	4
2012-04-23	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-24	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-25	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-26	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-27	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-28	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-29	13	3	1	2012	2012-04-23	2012-04-29	5
2012-04-30	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-01	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-02	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-03	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-04	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-05	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-06	14	4	2	2012	2012-04-30	2012-05-06	1
2012-05-07	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-08	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-09	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-10	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-11	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-12	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-13	15	4	2	2012	2012-05-07	2012-05-13	2
2012-05-14	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-15	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-16	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-17	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-18	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-19	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-20	16	4	2	2012	2012-05-14	2012-05-20	3
2012-05-21	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-22	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-23	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-24	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-25	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-26	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-27	17	4	2	2012	2012-05-21	2012-05-27	4
2012-05-28	18	5	2	2012	2012-05-28	2012-06-03	1
2012-05-29	18	5	2	2012	2012-05-28	2012-06-03	1
2012-05-30	18	5	2	2012	2012-05-28	2012-06-03	1
2012-05-31	18	5	2	2012	2012-05-28	2012-06-03	1
2012-06-01	18	5	2	2012	2012-05-28	2012-06-03	1
2012-06-02	18	5	2	2012	2012-05-28	2012-06-03	1
2012-06-03	18	5	2	2012	2012-05-28	2012-06-03	1
2012-06-04	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-05	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-06	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-07	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-08	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-09	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-10	19	5	2	2012	2012-06-04	2012-06-10	2
2012-06-11	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-12	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-13	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-14	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-15	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-16	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-17	20	5	2	2012	2012-06-11	2012-06-17	3
2012-06-18	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-19	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-20	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-21	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-22	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-23	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-24	21	5	2	2012	2012-06-18	2012-06-24	4
2012-06-25	22	6	2	2012	2012-06-25	2012-07-01	1
2012-06-26	22	6	2	2012	2012-06-25	2012-07-01	1
2012-06-27	22	6	2	2012	2012-06-25	2012-07-01	1
2012-06-28	22	6	2	2012	2012-06-25	2012-07-01	1
2012-06-29	22	6	2	2012	2012-06-25	2012-07-01	1
2012-06-30	22	6	2	2012	2012-06-25	2012-07-01	1
2012-07-01	22	6	2	2012	2012-06-25	2012-07-01	1
2012-07-02	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-03	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-04	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-05	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-06	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-07	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-08	23	6	2	2012	2012-07-02	2012-07-08	2
2012-07-09	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-10	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-11	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-12	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-13	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-14	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-15	24	6	2	2012	2012-07-09	2012-07-15	3
2012-07-16	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-17	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-18	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-19	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-20	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-21	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-22	25	6	2	2012	2012-07-16	2012-07-22	4
2012-07-23	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-24	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-25	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-26	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-27	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-28	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-29	26	6	2	2012	2012-07-23	2012-07-29	5
2012-07-30	27	7	2	2012	2012-07-30	2012-08-05	1
2012-07-31	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-01	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-02	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-03	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-04	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-05	27	7	2	2012	2012-07-30	2012-08-05	1
2012-08-06	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-07	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-08	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-09	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-10	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-11	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-12	28	7	2	2012	2012-08-06	2012-08-12	2
2012-08-13	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-14	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-15	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-16	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-17	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-18	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-19	29	7	2	2012	2012-08-13	2012-08-19	3
2012-08-20	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-21	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-22	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-23	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-24	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-25	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-26	30	7	2	2012	2012-08-20	2012-08-26	4
2012-08-27	31	8	3	2012	2012-08-27	2012-09-02	1
2012-08-28	31	8	3	2012	2012-08-27	2012-09-02	1
2012-08-29	31	8	3	2012	2012-08-27	2012-09-02	1
2012-08-30	31	8	3	2012	2012-08-27	2012-09-02	1
2012-08-31	31	8	3	2012	2012-08-27	2012-09-02	1
2012-09-01	31	8	3	2012	2012-08-27	2012-09-02	1
2012-09-02	31	8	3	2012	2012-08-27	2012-09-02	1
2012-09-03	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-04	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-05	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-06	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-07	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-08	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-09	32	8	3	2012	2012-09-03	2012-09-09	2
2012-09-10	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-11	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-12	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-13	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-14	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-15	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-16	33	8	3	2012	2012-09-10	2012-09-16	3
2012-09-17	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-18	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-19	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-20	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-21	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-22	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-23	34	8	3	2012	2012-09-17	2012-09-23	4
2012-09-24	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-25	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-26	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-27	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-28	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-29	35	9	3	2012	2012-09-24	2012-09-30	1
2012-09-30	35	9	3	2012	2012-09-24	2012-09-30	1
2012-10-01	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-02	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-03	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-04	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-05	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-06	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-07	36	9	3	2012	2012-10-01	2012-10-07	2
2012-10-08	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-09	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-10	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-11	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-12	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-13	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-14	37	9	3	2012	2012-10-08	2012-10-14	3
2012-10-15	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-16	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-17	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-18	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-19	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-20	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-21	38	9	3	2012	2012-10-15	2012-10-21	4
2012-10-22	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-23	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-24	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-25	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-26	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-27	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-28	39	9	3	2012	2012-10-22	2012-10-28	5
2012-10-29	40	10	3	2012	2012-10-29	2012-11-04	1
2012-10-30	40	10	3	2012	2012-10-29	2012-11-04	1
2012-10-31	40	10	3	2012	2012-10-29	2012-11-04	1
2012-11-01	40	10	3	2012	2012-10-29	2012-11-04	1
2012-11-02	40	10	3	2012	2012-10-29	2012-11-04	1
2012-11-03	40	10	3	2012	2012-10-29	2012-11-04	1
2012-11-04	40	10	3	2012	2012-10-29	2012-11-04	1
2012-11-05	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-06	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-07	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-08	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-09	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-10	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-11	41	10	3	2012	2012-11-05	2012-11-11	2
2012-11-12	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-13	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-14	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-15	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-16	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-17	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-18	42	10	3	2012	2012-11-12	2012-11-18	3
2012-11-19	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-20	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-21	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-22	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-23	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-24	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-25	43	10	3	2012	2012-11-19	2012-11-25	4
2012-11-26	44	11	3	2012	2012-11-26	2012-12-02	1
2012-11-27	44	11	3	2012	2012-11-26	2012-12-02	1
2012-11-28	44	11	3	2012	2012-11-26	2012-12-02	1
2012-11-29	44	11	3	2012	2012-11-26	2012-12-02	1
2012-11-30	44	11	3	2012	2012-11-26	2012-12-02	1
2012-12-01	44	11	3	2012	2012-11-26	2012-12-02	1
2012-12-02	44	11	3	2012	2012-11-26	2012-12-02	1
2012-12-03	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-04	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-05	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-06	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-07	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-08	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-09	45	11	3	2012	2012-12-03	2012-12-09	2
2012-12-10	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-11	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-12	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-13	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-14	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-15	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-16	46	11	3	2012	2012-12-10	2012-12-16	3
2012-12-17	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-18	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-19	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-20	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-21	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-22	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-23	47	11	3	2012	2012-12-17	2012-12-23	4
2012-12-24	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-25	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-26	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-27	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-28	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-29	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-30	48	12	4	2012	2012-12-24	2012-12-30	1
2012-12-31	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-01	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-02	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-03	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-04	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-05	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-06	49	12	4	2012	2012-12-31	2013-01-06	2
2013-01-07	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-08	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-09	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-10	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-11	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-12	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-13	50	12	4	2012	2013-01-07	2013-01-13	3
2013-01-14	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-15	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-16	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-17	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-18	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-19	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-20	51	12	4	2012	2013-01-14	2013-01-20	4
2013-01-21	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-22	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-23	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-24	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-25	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-26	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-27	52	12	4	2012	2013-01-21	2013-01-27	5
2013-01-28	53	12	4	2012	2013-01-28	2013-02-03	6
2013-01-29	53	12	4	2012	2013-01-28	2013-02-03	6
2013-01-30	53	12	4	2012	2013-01-28	2013-02-03	6
2013-01-31	53	12	4	2012	2013-01-28	2013-02-03	6
2013-02-01	53	12	4	2012	2013-01-28	2013-02-03	6
2013-02-02	53	12	4	2012	2013-01-28	2013-02-03	6
2013-02-03	53	12	4	2012	2013-01-28	2013-02-03	6
2013-02-04	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-05	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-06	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-07	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-08	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-09	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-10	1	1	1	2013	2013-02-04	2013-02-10	1
2013-02-11	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-12	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-13	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-14	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-15	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-16	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-17	2	1	1	2013	2013-02-11	2013-02-17	2
2013-02-18	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-19	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-20	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-21	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-22	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-23	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-24	3	1	1	2013	2013-02-18	2013-02-24	3
2013-02-25	4	1	1	2013	2013-02-25	2013-03-03	4
2013-02-26	4	1	1	2013	2013-02-25	2013-03-03	4
2013-02-27	4	1	1	2013	2013-02-25	2013-03-03	4
2013-02-28	4	1	1	2013	2013-02-25	2013-03-03	4
2013-03-01	4	1	1	2013	2013-02-25	2013-03-03	4
2013-03-02	4	1	1	2013	2013-02-25	2013-03-03	4
2013-03-03	4	1	1	2013	2013-02-25	2013-03-03	4
2013-03-04	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-05	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-06	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-07	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-08	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-09	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-10	5	2	1	2013	2013-03-04	2013-03-10	1
2013-03-11	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-12	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-13	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-14	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-15	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-16	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-17	6	2	1	2013	2013-03-11	2013-03-17	2
2013-03-18	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-19	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-20	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-21	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-22	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-23	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-24	7	2	1	2013	2013-03-18	2013-03-24	3
2013-03-25	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-26	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-27	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-28	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-29	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-30	8	2	1	2013	2013-03-25	2013-03-31	4
2013-03-31	8	2	1	2013	2013-03-25	2013-03-31	4
2013-04-01	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-02	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-03	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-04	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-05	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-06	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-07	9	3	1	2013	2013-04-01	2013-04-07	1
2013-04-08	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-09	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-10	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-11	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-12	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-13	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-14	10	3	1	2013	2013-04-08	2013-04-14	2
2013-04-15	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-16	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-17	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-18	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-19	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-20	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-21	11	3	1	2013	2013-04-15	2013-04-21	3
2013-04-22	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-23	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-24	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-25	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-26	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-27	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-28	12	3	1	2013	2013-04-22	2013-04-28	4
2013-04-29	13	3	1	2013	2013-04-29	2013-05-05	5
2013-04-30	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-01	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-02	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-03	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-04	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-05	13	3	1	2013	2013-04-29	2013-05-05	5
2013-05-06	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-07	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-08	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-09	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-10	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-11	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-12	14	4	2	2013	2013-05-06	2013-05-12	1
2013-05-13	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-14	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-15	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-16	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-17	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-18	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-19	15	4	2	2013	2013-05-13	2013-05-19	2
2013-05-20	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-21	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-22	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-23	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-24	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-25	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-26	16	4	2	2013	2013-05-20	2013-05-26	3
2013-05-27	17	4	2	2013	2013-05-27	2013-06-02	4
2013-05-28	17	4	2	2013	2013-05-27	2013-06-02	4
2013-05-29	17	4	2	2013	2013-05-27	2013-06-02	4
2013-05-30	17	4	2	2013	2013-05-27	2013-06-02	4
2013-05-31	17	4	2	2013	2013-05-27	2013-06-02	4
2013-06-01	17	4	2	2013	2013-05-27	2013-06-02	4
2013-06-02	17	4	2	2013	2013-05-27	2013-06-02	4
2013-06-03	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-04	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-05	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-06	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-07	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-08	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-09	18	5	2	2013	2013-06-03	2013-06-09	1
2013-06-10	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-11	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-12	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-13	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-14	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-15	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-16	19	5	2	2013	2013-06-10	2013-06-16	2
2013-06-17	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-18	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-19	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-20	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-21	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-22	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-23	20	5	2	2013	2013-06-17	2013-06-23	3
2013-06-24	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-25	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-26	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-27	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-28	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-29	21	5	2	2013	2013-06-24	2013-06-30	4
2013-06-30	21	5	2	2013	2013-06-24	2013-06-30	4
2013-07-01	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-02	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-03	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-04	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-05	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-06	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-07	22	6	2	2013	2013-07-01	2013-07-07	1
2013-07-08	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-09	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-10	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-11	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-12	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-13	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-14	23	6	2	2013	2013-07-08	2013-07-14	2
2013-07-15	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-16	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-17	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-18	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-19	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-20	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-21	24	6	2	2013	2013-07-15	2013-07-21	3
2013-07-22	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-23	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-24	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-25	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-26	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-27	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-28	25	6	2	2013	2013-07-22	2013-07-28	4
2013-07-29	26	6	2	2013	2013-07-29	2013-08-04	5
2013-07-30	26	6	2	2013	2013-07-29	2013-08-04	5
2013-07-31	26	6	2	2013	2013-07-29	2013-08-04	5
2013-08-01	26	6	2	2013	2013-07-29	2013-08-04	5
2013-08-02	26	6	2	2013	2013-07-29	2013-08-04	5
2013-08-03	26	6	2	2013	2013-07-29	2013-08-04	5
2013-08-04	26	6	2	2013	2013-07-29	2013-08-04	5
2013-08-05	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-06	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-07	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-08	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-09	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-10	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-11	27	7	2	2013	2013-08-05	2013-08-11	1
2013-08-12	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-13	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-14	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-15	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-16	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-17	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-18	28	7	2	2013	2013-08-12	2013-08-18	2
2013-08-19	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-20	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-21	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-22	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-23	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-24	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-25	29	7	2	2013	2013-08-19	2013-08-25	3
2013-08-26	30	7	2	2013	2013-08-26	2013-09-01	4
2013-08-27	30	7	2	2013	2013-08-26	2013-09-01	4
2013-08-28	30	7	2	2013	2013-08-26	2013-09-01	4
2013-08-29	30	7	2	2013	2013-08-26	2013-09-01	4
2013-08-30	30	7	2	2013	2013-08-26	2013-09-01	4
2013-08-31	30	7	2	2013	2013-08-26	2013-09-01	4
2013-09-01	30	7	2	2013	2013-08-26	2013-09-01	4
2013-09-02	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-03	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-04	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-05	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-06	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-07	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-08	31	8	3	2013	2013-09-02	2013-09-08	1
2013-09-09	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-10	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-11	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-12	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-13	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-14	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-15	32	8	3	2013	2013-09-09	2013-09-15	2
2013-09-16	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-17	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-18	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-19	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-20	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-21	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-22	33	8	3	2013	2013-09-16	2013-09-22	3
2013-09-23	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-24	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-25	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-26	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-27	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-28	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-29	34	8	3	2013	2013-09-23	2013-09-29	4
2013-09-30	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-01	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-02	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-03	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-04	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-05	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-06	35	9	3	2013	2013-09-30	2013-10-06	1
2013-10-07	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-08	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-09	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-10	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-11	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-12	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-13	36	9	3	2013	2013-10-07	2013-10-13	2
2013-10-14	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-15	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-16	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-17	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-18	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-19	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-20	37	9	3	2013	2013-10-14	2013-10-20	3
2013-10-21	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-22	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-23	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-24	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-25	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-26	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-27	38	9	3	2013	2013-10-21	2013-10-27	4
2013-10-28	39	9	3	2013	2013-10-28	2013-11-03	5
2013-10-29	39	9	3	2013	2013-10-28	2013-11-03	5
2013-10-30	39	9	3	2013	2013-10-28	2013-11-03	5
2013-10-31	39	9	3	2013	2013-10-28	2013-11-03	5
2013-11-01	39	9	3	2013	2013-10-28	2013-11-03	5
2013-11-02	39	9	3	2013	2013-10-28	2013-11-03	5
2013-11-03	39	9	3	2013	2013-10-28	2013-11-03	5
2013-11-04	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-05	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-06	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-07	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-08	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-09	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-10	40	10	3	2013	2013-11-04	2013-11-10	1
2013-11-11	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-12	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-13	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-14	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-15	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-16	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-17	41	10	3	2013	2013-11-11	2013-11-17	2
2013-11-18	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-19	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-20	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-21	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-22	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-23	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-24	42	10	3	2013	2013-11-18	2013-11-24	3
2013-11-25	43	10	3	2013	2013-11-25	2013-12-01	4
2013-11-26	43	10	3	2013	2013-11-25	2013-12-01	4
2013-11-27	43	10	3	2013	2013-11-25	2013-12-01	4
2013-11-28	43	10	3	2013	2013-11-25	2013-12-01	4
2013-11-29	43	10	3	2013	2013-11-25	2013-12-01	4
2013-11-30	43	10	3	2013	2013-11-25	2013-12-01	4
2013-12-01	43	10	3	2013	2013-11-25	2013-12-01	4
2013-12-02	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-03	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-04	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-05	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-06	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-07	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-08	44	11	3	2013	2013-12-02	2013-12-08	1
2013-12-09	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-10	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-11	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-12	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-13	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-14	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-15	45	11	3	2013	2013-12-09	2013-12-15	2
2013-12-16	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-17	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-18	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-19	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-20	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-21	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-22	46	11	3	2013	2013-12-16	2013-12-22	3
2013-12-23	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-24	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-25	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-26	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-27	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-28	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-29	47	11	3	2013	2013-12-23	2013-12-29	4
2013-12-30	48	12	4	2013	2013-12-30	2014-01-05	1
2013-12-31	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-01	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-02	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-03	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-04	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-05	48	12	4	2013	2013-12-30	2014-01-05	1
2014-01-06	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-07	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-08	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-09	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-10	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-11	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-12	49	12	4	2013	2014-01-06	2014-01-12	2
2014-01-13	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-14	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-15	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-16	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-17	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-18	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-19	50	12	4	2013	2014-01-13	2014-01-19	3
2014-01-20	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-21	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-22	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-23	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-24	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-25	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-26	51	12	4	2013	2014-01-20	2014-01-26	4
2014-01-27	52	12	4	2013	2014-01-27	2014-02-02	5
2014-01-28	52	12	4	2013	2014-01-27	2014-02-02	5
2014-01-29	52	12	4	2013	2014-01-27	2014-02-02	5
2014-01-30	52	12	4	2013	2014-01-27	2014-02-02	5
2014-01-31	52	12	4	2013	2014-01-27	2014-02-02	5
2014-02-01	52	12	4	2013	2014-01-27	2014-02-02	5
2014-02-02	52	12	4	2013	2014-01-27	2014-02-02	5
2014-02-03	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-04	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-05	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-06	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-07	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-08	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-09	1	1	1	2014	2014-02-03	2014-02-09	1
2014-02-10	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-11	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-12	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-13	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-14	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-15	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-16	2	1	1	2014	2014-02-10	2014-02-16	2
2014-02-17	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-18	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-19	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-20	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-21	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-22	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-23	3	1	1	2014	2014-02-17	2014-02-23	3
2014-02-24	4	1	1	2014	2014-02-24	2014-03-02	4
2014-02-25	4	1	1	2014	2014-02-24	2014-03-02	4
2014-02-26	4	1	1	2014	2014-02-24	2014-03-02	4
2014-02-27	4	1	1	2014	2014-02-24	2014-03-02	4
2014-02-28	4	1	1	2014	2014-02-24	2014-03-02	4
2014-03-01	4	1	1	2014	2014-02-24	2014-03-02	4
2014-03-02	4	1	1	2014	2014-02-24	2014-03-02	4
2014-03-03	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-04	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-05	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-06	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-07	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-08	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-09	5	2	1	2014	2014-03-03	2014-03-09	1
2014-03-10	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-11	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-12	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-13	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-14	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-15	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-16	6	2	1	2014	2014-03-10	2014-03-16	2
2014-03-17	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-18	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-19	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-20	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-21	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-22	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-23	7	2	1	2014	2014-03-17	2014-03-23	3
2014-03-24	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-25	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-26	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-27	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-28	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-29	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-30	8	2	1	2014	2014-03-24	2014-03-30	4
2014-03-31	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-01	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-02	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-03	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-04	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-05	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-06	9	3	1	2014	2014-03-31	2014-04-06	1
2014-04-07	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-08	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-09	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-10	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-11	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-12	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-13	10	3	1	2014	2014-04-07	2014-04-13	2
2014-04-14	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-15	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-16	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-17	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-18	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-19	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-20	11	3	1	2014	2014-04-14	2014-04-20	3
2014-04-21	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-22	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-23	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-24	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-25	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-26	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-27	12	3	1	2014	2014-04-21	2014-04-27	4
2014-04-28	13	3	1	2014	2014-04-28	2014-05-04	5
2014-04-29	13	3	1	2014	2014-04-28	2014-05-04	5
2014-04-30	13	3	1	2014	2014-04-28	2014-05-04	5
2014-05-01	13	3	1	2014	2014-04-28	2014-05-04	5
2014-05-02	13	3	1	2014	2014-04-28	2014-05-04	5
2014-05-03	13	3	1	2014	2014-04-28	2014-05-04	5
2014-05-04	13	3	1	2014	2014-04-28	2014-05-04	5
2014-05-05	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-06	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-07	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-08	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-09	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-10	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-11	14	4	2	2014	2014-05-05	2014-05-11	1
2014-05-12	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-13	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-14	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-15	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-16	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-17	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-18	15	4	2	2014	2014-05-12	2014-05-18	2
2014-05-19	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-20	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-21	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-22	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-23	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-24	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-25	16	4	2	2014	2014-05-19	2014-05-25	3
2014-05-26	17	4	2	2014	2014-05-26	2014-06-01	4
2014-05-27	17	4	2	2014	2014-05-26	2014-06-01	4
2014-05-28	17	4	2	2014	2014-05-26	2014-06-01	4
2014-05-29	17	4	2	2014	2014-05-26	2014-06-01	4
2014-05-30	17	4	2	2014	2014-05-26	2014-06-01	4
2014-05-31	17	4	2	2014	2014-05-26	2014-06-01	4
2014-06-01	17	4	2	2014	2014-05-26	2014-06-01	4
2014-06-02	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-03	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-04	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-05	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-06	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-07	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-08	18	5	2	2014	2014-06-02	2014-06-08	1
2014-06-09	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-10	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-11	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-12	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-13	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-14	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-15	19	5	2	2014	2014-06-09	2014-06-15	2
2014-06-16	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-17	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-18	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-19	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-20	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-21	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-22	20	5	2	2014	2014-06-16	2014-06-22	3
2014-06-23	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-24	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-25	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-26	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-27	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-28	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-29	21	5	2	2014	2014-06-23	2014-06-29	4
2014-06-30	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-01	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-02	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-03	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-04	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-05	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-06	22	6	2	2014	2014-06-30	2014-07-06	1
2014-07-07	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-08	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-09	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-10	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-11	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-12	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-13	23	6	2	2014	2014-07-07	2014-07-13	2
2014-07-14	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-15	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-16	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-17	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-18	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-19	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-20	24	6	2	2014	2014-07-14	2014-07-20	3
2014-07-21	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-22	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-23	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-24	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-25	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-26	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-27	25	6	2	2014	2014-07-21	2014-07-27	4
2014-07-28	26	6	2	2014	2014-07-28	2014-08-03	5
2014-07-29	26	6	2	2014	2014-07-28	2014-08-03	5
2014-07-30	26	6	2	2014	2014-07-28	2014-08-03	5
2014-07-31	26	6	2	2014	2014-07-28	2014-08-03	5
2014-08-01	26	6	2	2014	2014-07-28	2014-08-03	5
2014-08-02	26	6	2	2014	2014-07-28	2014-08-03	5
2014-08-03	26	6	2	2014	2014-07-28	2014-08-03	5
2014-08-04	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-05	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-06	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-07	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-08	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-09	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-10	27	7	2	2014	2014-08-04	2014-08-10	1
2014-08-11	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-12	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-13	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-14	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-15	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-16	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-17	28	7	2	2014	2014-08-11	2014-08-17	2
2014-08-18	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-19	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-20	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-21	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-22	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-23	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-24	29	7	2	2014	2014-08-18	2014-08-24	3
2014-08-25	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-26	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-27	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-28	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-29	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-30	30	7	2	2014	2014-08-25	2014-08-31	4
2014-08-31	30	7	2	2014	2014-08-25	2014-08-31	4
2014-09-01	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-02	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-03	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-04	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-05	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-06	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-07	31	8	3	2014	2014-09-01	2014-09-07	1
2014-09-08	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-09	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-10	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-11	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-12	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-13	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-14	32	8	3	2014	2014-09-08	2014-09-14	2
2014-09-15	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-16	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-17	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-18	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-19	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-20	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-21	33	8	3	2014	2014-09-15	2014-09-21	3
2014-09-22	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-23	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-24	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-25	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-26	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-27	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-28	34	8	3	2014	2014-09-22	2014-09-28	4
2014-09-29	35	9	3	2014	2014-09-29	2014-10-05	1
2014-09-30	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-01	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-02	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-03	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-04	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-05	35	9	3	2014	2014-09-29	2014-10-05	1
2014-10-06	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-07	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-08	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-09	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-10	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-11	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-12	36	9	3	2014	2014-10-06	2014-10-12	2
2014-10-13	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-14	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-15	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-16	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-17	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-18	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-19	37	9	3	2014	2014-10-13	2014-10-19	3
2014-10-20	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-21	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-22	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-23	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-24	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-25	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-26	38	9	3	2014	2014-10-20	2014-10-26	4
2014-10-27	39	9	3	2014	2014-10-27	2014-11-02	5
2014-10-28	39	9	3	2014	2014-10-27	2014-11-02	5
2014-10-29	39	9	3	2014	2014-10-27	2014-11-02	5
2014-10-30	39	9	3	2014	2014-10-27	2014-11-02	5
2014-10-31	39	9	3	2014	2014-10-27	2014-11-02	5
2014-11-01	39	9	3	2014	2014-10-27	2014-11-02	5
2014-11-02	39	9	3	2014	2014-10-27	2014-11-02	5
2014-11-03	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-04	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-05	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-06	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-07	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-08	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-09	40	10	3	2014	2014-11-03	2014-11-09	1
2014-11-10	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-11	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-12	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-13	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-14	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-15	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-16	41	10	3	2014	2014-11-10	2014-11-16	2
2014-11-17	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-18	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-19	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-20	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-21	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-22	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-23	42	10	3	2014	2014-11-17	2014-11-23	3
2014-11-24	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-25	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-26	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-27	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-28	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-29	43	10	3	2014	2014-11-24	2014-11-30	4
2014-11-30	43	10	3	2014	2014-11-24	2014-11-30	4
2014-12-01	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-02	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-03	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-04	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-05	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-06	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-07	44	11	3	2014	2014-12-01	2014-12-07	1
2014-12-08	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-09	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-10	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-11	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-12	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-13	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-14	45	11	3	2014	2014-12-08	2014-12-14	2
2014-12-15	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-16	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-17	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-18	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-19	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-20	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-21	46	11	3	2014	2014-12-15	2014-12-21	3
2014-12-22	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-23	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-24	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-25	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-26	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-27	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-28	47	11	3	2014	2014-12-22	2014-12-28	4
2014-12-29	48	12	4	2014	2014-12-29	2015-01-04	1
2014-12-30	48	12	4	2014	2014-12-29	2015-01-04	1
2014-12-31	48	12	4	2014	2014-12-29	2015-01-04	1
2015-01-01	48	12	4	2014	2014-12-29	2015-01-04	1
2015-01-02	48	12	4	2014	2014-12-29	2015-01-04	1
2015-01-03	48	12	4	2014	2014-12-29	2015-01-04	1
2015-01-04	48	12	4	2014	2014-12-29	2015-01-04	1
2015-01-05	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-06	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-07	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-08	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-09	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-10	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-11	49	12	4	2014	2015-01-05	2015-01-11	2
2015-01-12	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-13	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-14	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-15	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-16	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-17	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-18	50	12	4	2014	2015-01-12	2015-01-18	3
2015-01-19	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-20	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-21	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-22	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-23	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-24	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-25	51	12	4	2014	2015-01-19	2015-01-25	4
2015-01-26	52	12	4	2014	2015-01-26	2015-02-01	5
2015-01-27	52	12	4	2014	2015-01-26	2015-02-01	5
2015-01-28	52	12	4	2014	2015-01-26	2015-02-01	5
2015-01-29	52	12	4	2014	2015-01-26	2015-02-01	5
2015-01-30	52	12	4	2014	2015-01-26	2015-02-01	5
2015-01-31	52	12	4	2014	2015-01-26	2015-02-01	5
2015-02-01	52	12	4	2014	2015-01-26	2015-02-01	5
2015-02-02	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-03	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-04	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-05	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-06	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-07	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-08	1	1	1	2015	2015-02-02	2015-02-08	1
2015-02-09	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-10	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-11	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-12	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-13	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-14	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-15	2	1	1	2015	2015-02-09	2015-02-15	2
2015-02-16	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-17	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-18	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-19	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-20	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-21	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-22	3	1	1	2015	2015-02-16	2015-02-22	3
2015-02-23	4	1	1	2015	2015-02-23	2015-03-01	4
2015-02-24	4	1	1	2015	2015-02-23	2015-03-01	4
2015-02-25	4	1	1	2015	2015-02-23	2015-03-01	4
2015-02-26	4	1	1	2015	2015-02-23	2015-03-01	4
2015-02-27	4	1	1	2015	2015-02-23	2015-03-01	4
2015-02-28	4	1	1	2015	2015-02-23	2015-03-01	4
2015-03-01	4	1	1	2015	2015-02-23	2015-03-01	4
2015-03-02	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-03	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-04	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-05	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-06	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-07	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-08	5	2	1	2015	2015-03-02	2015-03-08	1
2015-03-09	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-10	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-11	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-12	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-13	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-14	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-15	6	2	1	2015	2015-03-09	2015-03-15	2
2015-03-16	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-17	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-18	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-19	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-20	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-21	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-22	7	2	1	2015	2015-03-16	2015-03-22	3
2015-03-23	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-24	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-25	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-26	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-27	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-28	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-29	8	2	1	2015	2015-03-23	2015-03-29	4
2015-03-30	9	3	1	2015	2015-03-30	2015-04-05	1
2015-03-31	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-01	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-02	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-03	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-04	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-05	9	3	1	2015	2015-03-30	2015-04-05	1
2015-04-06	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-07	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-08	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-09	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-10	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-11	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-12	10	3	1	2015	2015-04-06	2015-04-12	2
2015-04-13	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-14	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-15	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-16	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-17	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-18	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-19	11	3	1	2015	2015-04-13	2015-04-19	3
2015-04-20	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-21	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-22	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-23	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-24	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-25	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-26	12	3	1	2015	2015-04-20	2015-04-26	4
2015-04-27	13	3	1	2015	2015-04-27	2015-05-03	5
2015-04-28	13	3	1	2015	2015-04-27	2015-05-03	5
2015-04-29	13	3	1	2015	2015-04-27	2015-05-03	5
2015-04-30	13	3	1	2015	2015-04-27	2015-05-03	5
2015-05-01	13	3	1	2015	2015-04-27	2015-05-03	5
2015-05-02	13	3	1	2015	2015-04-27	2015-05-03	5
2015-05-03	13	3	1	2015	2015-04-27	2015-05-03	5
2015-05-04	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-05	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-06	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-07	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-08	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-09	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-10	14	4	2	2015	2015-05-04	2015-05-10	1
2015-05-11	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-12	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-13	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-14	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-15	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-16	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-17	15	4	2	2015	2015-05-11	2015-05-17	2
2015-05-18	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-19	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-20	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-21	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-22	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-23	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-24	16	4	2	2015	2015-05-18	2015-05-24	3
2015-05-25	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-26	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-27	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-28	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-29	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-30	17	4	2	2015	2015-05-25	2015-05-31	4
2015-05-31	17	4	2	2015	2015-05-25	2015-05-31	4
2015-06-01	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-02	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-03	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-04	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-05	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-06	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-07	18	5	2	2015	2015-06-01	2015-06-07	1
2015-06-08	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-09	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-10	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-11	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-12	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-13	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-14	19	5	2	2015	2015-06-08	2015-06-14	2
2015-06-15	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-16	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-17	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-18	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-19	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-20	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-21	20	5	2	2015	2015-06-15	2015-06-21	3
2015-06-22	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-23	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-24	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-25	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-26	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-27	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-28	21	5	2	2015	2015-06-22	2015-06-28	4
2015-06-29	22	6	2	2015	2015-06-29	2015-07-05	1
2015-06-30	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-01	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-02	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-03	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-04	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-05	22	6	2	2015	2015-06-29	2015-07-05	1
2015-07-06	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-07	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-08	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-09	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-10	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-11	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-12	23	6	2	2015	2015-07-06	2015-07-12	2
2015-07-13	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-14	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-15	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-16	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-17	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-18	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-19	24	6	2	2015	2015-07-13	2015-07-19	3
2015-07-20	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-21	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-22	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-23	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-24	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-25	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-26	25	6	2	2015	2015-07-20	2015-07-26	4
2015-07-27	26	6	2	2015	2015-07-27	2015-08-02	5
2015-07-28	26	6	2	2015	2015-07-27	2015-08-02	5
2015-07-29	26	6	2	2015	2015-07-27	2015-08-02	5
2015-07-30	26	6	2	2015	2015-07-27	2015-08-02	5
2015-07-31	26	6	2	2015	2015-07-27	2015-08-02	5
2015-08-01	26	6	2	2015	2015-07-27	2015-08-02	5
2015-08-02	26	6	2	2015	2015-07-27	2015-08-02	5
2015-08-03	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-04	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-05	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-06	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-07	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-08	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-09	27	7	2	2015	2015-08-03	2015-08-09	1
2015-08-10	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-11	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-12	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-13	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-14	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-15	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-16	28	7	2	2015	2015-08-10	2015-08-16	2
2015-08-17	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-18	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-19	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-20	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-21	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-22	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-23	29	7	2	2015	2015-08-17	2015-08-23	3
2015-08-24	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-25	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-26	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-27	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-28	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-29	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-30	30	7	2	2015	2015-08-24	2015-08-30	4
2015-08-31	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-01	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-02	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-03	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-04	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-05	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-06	31	8	3	2015	2015-08-31	2015-09-06	1
2015-09-07	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-08	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-09	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-10	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-11	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-12	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-13	32	8	3	2015	2015-09-07	2015-09-13	2
2015-09-14	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-15	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-16	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-17	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-18	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-19	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-20	33	8	3	2015	2015-09-14	2015-09-20	3
2015-09-21	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-22	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-23	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-24	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-25	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-26	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-27	34	8	3	2015	2015-09-21	2015-09-27	4
2015-09-28	35	9	3	2015	2015-09-28	2015-10-04	1
2015-09-29	35	9	3	2015	2015-09-28	2015-10-04	1
2015-09-30	35	9	3	2015	2015-09-28	2015-10-04	1
2015-10-01	35	9	3	2015	2015-09-28	2015-10-04	1
2015-10-02	35	9	3	2015	2015-09-28	2015-10-04	1
2015-10-03	35	9	3	2015	2015-09-28	2015-10-04	1
2015-10-04	35	9	3	2015	2015-09-28	2015-10-04	1
2015-10-05	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-06	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-07	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-08	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-09	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-10	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-11	36	9	3	2015	2015-10-05	2015-10-11	2
2015-10-12	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-13	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-14	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-15	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-16	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-17	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-18	37	9	3	2015	2015-10-12	2015-10-18	3
2015-10-19	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-20	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-21	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-22	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-23	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-24	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-25	38	9	3	2015	2015-10-19	2015-10-25	4
2015-10-26	39	9	3	2015	2015-10-26	2015-11-01	5
2015-10-27	39	9	3	2015	2015-10-26	2015-11-01	5
2015-10-28	39	9	3	2015	2015-10-26	2015-11-01	5
2015-10-29	39	9	3	2015	2015-10-26	2015-11-01	5
2015-10-30	39	9	3	2015	2015-10-26	2015-11-01	5
2015-10-31	39	9	3	2015	2015-10-26	2015-11-01	5
2015-11-01	39	9	3	2015	2015-10-26	2015-11-01	5
2015-11-02	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-03	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-04	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-05	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-06	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-07	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-08	40	10	3	2015	2015-11-02	2015-11-08	1
2015-11-09	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-10	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-11	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-12	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-13	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-14	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-15	41	10	3	2015	2015-11-09	2015-11-15	2
2015-11-16	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-17	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-18	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-19	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-20	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-21	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-22	42	10	3	2015	2015-11-16	2015-11-22	3
2015-11-23	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-24	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-25	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-26	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-27	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-28	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-29	43	10	3	2015	2015-11-23	2015-11-29	4
2015-11-30	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-01	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-02	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-03	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-04	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-05	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-06	44	11	3	2015	2015-11-30	2015-12-06	1
2015-12-07	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-08	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-09	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-10	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-11	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-12	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-13	45	11	3	2015	2015-12-07	2015-12-13	2
2015-12-14	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-15	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-16	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-17	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-18	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-19	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-20	46	11	3	2015	2015-12-14	2015-12-20	3
2015-12-21	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-22	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-23	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-24	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-25	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-26	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-27	47	11	3	2015	2015-12-21	2015-12-27	4
2015-12-28	48	12	4	2015	2015-12-28	2016-01-03	1
2015-12-29	48	12	4	2015	2015-12-28	2016-01-03	1
2015-12-30	48	12	4	2015	2015-12-28	2016-01-03	1
2015-12-31	48	12	4	2015	2015-12-28	2016-01-03	1
2016-01-01	48	12	4	2015	2015-12-28	2016-01-03	1
2016-01-02	48	12	4	2015	2015-12-28	2016-01-03	1
2016-01-03	48	12	4	2015	2015-12-28	2016-01-03	1
2016-01-04	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-05	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-06	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-07	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-08	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-09	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-10	49	12	4	2015	2016-01-04	2016-01-10	2
2016-01-11	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-12	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-13	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-14	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-15	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-16	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-17	50	12	4	2015	2016-01-11	2016-01-17	3
2016-01-18	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-19	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-20	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-21	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-22	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-23	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-24	51	12	4	2015	2016-01-18	2016-01-24	4
2016-01-25	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-26	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-27	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-28	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-29	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-30	52	12	4	2015	2016-01-25	2016-01-31	5
2016-01-31	52	12	4	2015	2016-01-25	2016-01-31	5
2016-02-01	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-02	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-03	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-04	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-05	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-06	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-07	1	1	1	2016	2016-02-01	2016-02-07	1
2016-02-08	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-09	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-10	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-11	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-12	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-13	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-14	2	1	1	2016	2016-02-08	2016-02-14	2
2016-02-15	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-16	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-17	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-18	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-19	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-20	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-21	3	1	1	2016	2016-02-15	2016-02-21	3
2016-02-22	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-23	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-24	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-25	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-26	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-27	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-28	4	1	1	2016	2016-02-22	2016-02-28	4
2016-02-29	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-01	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-02	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-03	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-04	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-05	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-06	5	2	1	2016	2016-02-29	2016-03-06	1
2016-03-07	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-08	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-09	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-10	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-11	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-12	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-13	6	2	1	2016	2016-03-07	2016-03-13	2
2016-03-14	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-15	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-16	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-17	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-18	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-19	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-20	7	2	1	2016	2016-03-14	2016-03-20	3
2016-03-21	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-22	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-23	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-24	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-25	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-26	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-27	8	2	1	2016	2016-03-21	2016-03-27	4
2016-03-28	9	3	1	2016	2016-03-28	2016-04-03	1
2016-03-29	9	3	1	2016	2016-03-28	2016-04-03	1
2016-03-30	9	3	1	2016	2016-03-28	2016-04-03	1
2016-03-31	9	3	1	2016	2016-03-28	2016-04-03	1
2016-04-01	9	3	1	2016	2016-03-28	2016-04-03	1
2016-04-02	9	3	1	2016	2016-03-28	2016-04-03	1
2016-04-03	9	3	1	2016	2016-03-28	2016-04-03	1
2016-04-04	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-05	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-06	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-07	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-08	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-09	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-10	10	3	1	2016	2016-04-04	2016-04-10	2
2016-04-11	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-12	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-13	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-14	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-15	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-16	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-17	11	3	1	2016	2016-04-11	2016-04-17	3
2016-04-18	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-19	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-20	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-21	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-22	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-23	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-24	12	3	1	2016	2016-04-18	2016-04-24	4
2016-04-25	13	3	1	2016	2016-04-25	2016-05-01	5
2016-04-26	13	3	1	2016	2016-04-25	2016-05-01	5
2016-04-27	13	3	1	2016	2016-04-25	2016-05-01	5
2016-04-28	13	3	1	2016	2016-04-25	2016-05-01	5
2016-04-29	13	3	1	2016	2016-04-25	2016-05-01	5
2016-04-30	13	3	1	2016	2016-04-25	2016-05-01	5
2016-05-01	13	3	1	2016	2016-04-25	2016-05-01	5
2016-05-02	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-03	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-04	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-05	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-06	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-07	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-08	14	4	2	2016	2016-05-02	2016-05-08	1
2016-05-09	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-10	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-11	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-12	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-13	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-14	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-15	15	4	2	2016	2016-05-09	2016-05-15	2
2016-05-16	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-17	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-18	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-19	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-20	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-21	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-22	16	4	2	2016	2016-05-16	2016-05-22	3
2016-05-23	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-24	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-25	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-26	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-27	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-28	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-29	17	4	2	2016	2016-05-23	2016-05-29	4
2016-05-30	18	5	2	2016	2016-05-30	2016-06-05	1
2016-05-31	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-01	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-02	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-03	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-04	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-05	18	5	2	2016	2016-05-30	2016-06-05	1
2016-06-06	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-07	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-08	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-09	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-10	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-11	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-12	19	5	2	2016	2016-06-06	2016-06-12	2
2016-06-13	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-14	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-15	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-16	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-17	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-18	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-19	20	5	2	2016	2016-06-13	2016-06-19	3
2016-06-20	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-21	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-22	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-23	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-24	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-25	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-26	21	5	2	2016	2016-06-20	2016-06-26	4
2016-06-27	22	6	2	2016	2016-06-27	2016-07-03	1
2016-06-28	22	6	2	2016	2016-06-27	2016-07-03	1
2016-06-29	22	6	2	2016	2016-06-27	2016-07-03	1
2016-06-30	22	6	2	2016	2016-06-27	2016-07-03	1
2016-07-01	22	6	2	2016	2016-06-27	2016-07-03	1
2016-07-02	22	6	2	2016	2016-06-27	2016-07-03	1
2016-07-03	22	6	2	2016	2016-06-27	2016-07-03	1
2016-07-04	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-05	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-06	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-07	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-08	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-09	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-10	23	6	2	2016	2016-07-04	2016-07-10	2
2016-07-11	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-12	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-13	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-14	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-15	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-16	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-17	24	6	2	2016	2016-07-11	2016-07-17	3
2016-07-18	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-19	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-20	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-21	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-22	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-23	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-24	25	6	2	2016	2016-07-18	2016-07-24	4
2016-07-25	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-26	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-27	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-28	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-29	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-30	26	6	2	2016	2016-07-25	2016-07-31	5
2016-07-31	26	6	2	2016	2016-07-25	2016-07-31	5
2016-08-01	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-02	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-03	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-04	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-05	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-06	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-07	27	7	2	2016	2016-08-01	2016-08-07	1
2016-08-08	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-09	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-10	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-11	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-12	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-13	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-14	28	7	2	2016	2016-08-08	2016-08-14	2
2016-08-15	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-16	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-17	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-18	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-19	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-20	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-21	29	7	2	2016	2016-08-15	2016-08-21	3
2016-08-22	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-23	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-24	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-25	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-26	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-27	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-28	30	7	2	2016	2016-08-22	2016-08-28	4
2016-08-29	31	8	3	2016	2016-08-29	2016-09-04	1
2016-08-30	31	8	3	2016	2016-08-29	2016-09-04	1
2016-08-31	31	8	3	2016	2016-08-29	2016-09-04	1
2016-09-01	31	8	3	2016	2016-08-29	2016-09-04	1
2016-09-02	31	8	3	2016	2016-08-29	2016-09-04	1
2016-09-03	31	8	3	2016	2016-08-29	2016-09-04	1
2016-09-04	31	8	3	2016	2016-08-29	2016-09-04	1
2016-09-05	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-06	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-07	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-08	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-09	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-10	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-11	32	8	3	2016	2016-09-05	2016-09-11	2
2016-09-12	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-13	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-14	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-15	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-16	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-17	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-18	33	8	3	2016	2016-09-12	2016-09-18	3
2016-09-19	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-20	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-21	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-22	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-23	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-24	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-25	34	8	3	2016	2016-09-19	2016-09-25	4
2016-09-26	35	9	3	2016	2016-09-26	2016-10-02	1
2016-09-27	35	9	3	2016	2016-09-26	2016-10-02	1
2016-09-28	35	9	3	2016	2016-09-26	2016-10-02	1
2016-09-29	35	9	3	2016	2016-09-26	2016-10-02	1
2016-09-30	35	9	3	2016	2016-09-26	2016-10-02	1
2016-10-01	35	9	3	2016	2016-09-26	2016-10-02	1
2016-10-02	35	9	3	2016	2016-09-26	2016-10-02	1
2016-10-03	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-04	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-05	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-06	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-07	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-08	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-09	36	9	3	2016	2016-10-03	2016-10-09	2
2016-10-10	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-11	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-12	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-13	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-14	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-15	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-16	37	9	3	2016	2016-10-10	2016-10-16	3
2016-10-17	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-18	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-19	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-20	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-21	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-22	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-23	38	9	3	2016	2016-10-17	2016-10-23	4
2016-10-24	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-25	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-26	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-27	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-28	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-29	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-30	39	9	3	2016	2016-10-24	2016-10-30	5
2016-10-31	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-01	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-02	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-03	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-04	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-05	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-06	40	10	3	2016	2016-10-31	2016-11-06	1
2016-11-07	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-08	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-09	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-10	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-11	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-12	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-13	41	10	3	2016	2016-11-07	2016-11-13	2
2016-11-14	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-15	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-16	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-17	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-18	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-19	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-20	42	10	3	2016	2016-11-14	2016-11-20	3
2016-11-21	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-22	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-23	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-24	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-25	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-26	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-27	43	10	3	2016	2016-11-21	2016-11-27	4
2016-11-28	44	11	3	2016	2016-11-28	2016-12-04	1
2016-11-29	44	11	3	2016	2016-11-28	2016-12-04	1
2016-11-30	44	11	3	2016	2016-11-28	2016-12-04	1
2016-12-01	44	11	3	2016	2016-11-28	2016-12-04	1
2016-12-02	44	11	3	2016	2016-11-28	2016-12-04	1
2016-12-03	44	11	3	2016	2016-11-28	2016-12-04	1
2016-12-04	44	11	3	2016	2016-11-28	2016-12-04	1
2016-12-05	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-06	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-07	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-08	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-09	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-10	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-11	45	11	3	2016	2016-12-05	2016-12-11	2
2016-12-12	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-13	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-14	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-15	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-16	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-17	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-18	46	11	3	2016	2016-12-12	2016-12-18	3
2016-12-19	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-20	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-21	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-22	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-23	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-24	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-25	47	11	3	2016	2016-12-19	2016-12-25	4
2016-12-26	48	12	4	2016	2016-12-26	2017-01-01	1
2016-12-27	48	12	4	2016	2016-12-26	2017-01-01	1
2016-12-28	48	12	4	2016	2016-12-26	2017-01-01	1
2016-12-29	48	12	4	2016	2016-12-26	2017-01-01	1
2016-12-30	48	12	4	2016	2016-12-26	2017-01-01	1
2016-12-31	48	12	4	2016	2016-12-26	2017-01-01	1
2017-01-01	48	12	4	2016	2016-12-26	2017-01-01	1
2017-01-02	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-03	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-04	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-05	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-06	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-07	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-08	49	12	4	2016	2017-01-02	2017-01-08	2
2017-01-09	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-10	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-11	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-12	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-13	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-14	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-15	50	12	4	2016	2017-01-09	2017-01-15	3
2017-01-16	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-17	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-18	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-19	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-20	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-21	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-22	51	12	4	2016	2017-01-16	2017-01-22	4
2017-01-23	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-24	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-25	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-26	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-27	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-28	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-29	52	12	4	2016	2017-01-23	2017-01-29	5
2017-01-30	1	1	1	2017	2017-01-30	2017-02-05	1
2017-01-31	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-01	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-02	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-03	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-04	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-05	1	1	1	2017	2017-01-30	2017-02-05	1
2017-02-06	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-07	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-08	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-09	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-10	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-11	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-12	2	1	1	2017	2017-02-06	2017-02-12	2
2017-02-13	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-14	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-15	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-16	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-17	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-18	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-19	3	1	1	2017	2017-02-13	2017-02-19	3
2017-02-20	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-21	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-22	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-23	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-24	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-25	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-26	4	1	1	2017	2017-02-20	2017-02-26	4
2017-02-27	5	2	1	2017	2017-02-27	2017-03-05	1
2017-02-28	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-01	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-02	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-03	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-04	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-05	5	2	1	2017	2017-02-27	2017-03-05	1
2017-03-06	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-07	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-08	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-09	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-10	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-11	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-12	6	2	1	2017	2017-03-06	2017-03-12	2
2017-03-13	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-14	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-15	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-16	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-17	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-18	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-19	7	2	1	2017	2017-03-13	2017-03-19	3
2017-03-20	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-21	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-22	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-23	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-24	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-25	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-26	8	2	1	2017	2017-03-20	2017-03-26	4
2017-03-27	9	3	1	2017	2017-03-27	2017-04-02	1
2017-03-28	9	3	1	2017	2017-03-27	2017-04-02	1
2017-03-29	9	3	1	2017	2017-03-27	2017-04-02	1
2017-03-30	9	3	1	2017	2017-03-27	2017-04-02	1
2017-03-31	9	3	1	2017	2017-03-27	2017-04-02	1
2017-04-01	9	3	1	2017	2017-03-27	2017-04-02	1
2017-04-02	9	3	1	2017	2017-03-27	2017-04-02	1
2017-04-03	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-04	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-05	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-06	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-07	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-08	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-09	10	3	1	2017	2017-04-03	2017-04-09	2
2017-04-10	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-11	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-12	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-13	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-14	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-15	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-16	11	3	1	2017	2017-04-10	2017-04-16	3
2017-04-17	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-18	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-19	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-20	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-21	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-22	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-23	12	3	1	2017	2017-04-17	2017-04-23	4
2017-04-24	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-25	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-26	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-27	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-28	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-29	13	3	1	2017	2017-04-24	2017-04-30	5
2017-04-30	13	3	1	2017	2017-04-24	2017-04-30	5
2017-05-01	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-02	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-03	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-04	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-05	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-06	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-07	14	4	2	2017	2017-05-01	2017-05-07	1
2017-05-08	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-09	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-10	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-11	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-12	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-13	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-14	15	4	2	2017	2017-05-08	2017-05-14	2
2017-05-15	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-16	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-17	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-18	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-19	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-20	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-21	16	4	2	2017	2017-05-15	2017-05-21	3
2017-05-22	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-23	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-24	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-25	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-26	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-27	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-28	17	4	2	2017	2017-05-22	2017-05-28	4
2017-05-29	18	5	2	2017	2017-05-29	2017-06-04	1
2017-05-30	18	5	2	2017	2017-05-29	2017-06-04	1
2017-05-31	18	5	2	2017	2017-05-29	2017-06-04	1
2017-06-01	18	5	2	2017	2017-05-29	2017-06-04	1
2017-06-02	18	5	2	2017	2017-05-29	2017-06-04	1
2017-06-03	18	5	2	2017	2017-05-29	2017-06-04	1
2017-06-04	18	5	2	2017	2017-05-29	2017-06-04	1
2017-06-05	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-06	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-07	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-08	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-09	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-10	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-11	19	5	2	2017	2017-06-05	2017-06-11	2
2017-06-12	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-13	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-14	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-15	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-16	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-17	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-18	20	5	2	2017	2017-06-12	2017-06-18	3
2017-06-19	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-20	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-21	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-22	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-23	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-24	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-25	21	5	2	2017	2017-06-19	2017-06-25	4
2017-06-26	22	6	2	2017	2017-06-26	2017-07-02	1
2017-06-27	22	6	2	2017	2017-06-26	2017-07-02	1
2017-06-28	22	6	2	2017	2017-06-26	2017-07-02	1
2017-06-29	22	6	2	2017	2017-06-26	2017-07-02	1
2017-06-30	22	6	2	2017	2017-06-26	2017-07-02	1
2017-07-01	22	6	2	2017	2017-06-26	2017-07-02	1
2017-07-02	22	6	2	2017	2017-06-26	2017-07-02	1
2017-07-03	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-04	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-05	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-06	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-07	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-08	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-09	23	6	2	2017	2017-07-03	2017-07-09	2
2017-07-10	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-11	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-12	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-13	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-14	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-15	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-16	24	6	2	2017	2017-07-10	2017-07-16	3
2017-07-17	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-18	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-19	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-20	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-21	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-22	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-23	25	6	2	2017	2017-07-17	2017-07-23	4
2017-07-24	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-25	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-26	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-27	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-28	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-29	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-30	26	6	2	2017	2017-07-24	2017-07-30	5
2017-07-31	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-01	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-02	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-03	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-04	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-05	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-06	27	7	2	2017	2017-07-31	2017-08-06	1
2017-08-07	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-08	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-09	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-10	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-11	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-12	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-13	28	7	2	2017	2017-08-07	2017-08-13	2
2017-08-14	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-15	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-16	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-17	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-18	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-19	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-20	29	7	2	2017	2017-08-14	2017-08-20	3
2017-08-21	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-22	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-23	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-24	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-25	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-26	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-27	30	7	2	2017	2017-08-21	2017-08-27	4
2017-08-28	31	8	3	2017	2017-08-28	2017-09-03	1
2017-08-29	31	8	3	2017	2017-08-28	2017-09-03	1
2017-08-30	31	8	3	2017	2017-08-28	2017-09-03	1
2017-08-31	31	8	3	2017	2017-08-28	2017-09-03	1
2017-09-01	31	8	3	2017	2017-08-28	2017-09-03	1
2017-09-02	31	8	3	2017	2017-08-28	2017-09-03	1
2017-09-03	31	8	3	2017	2017-08-28	2017-09-03	1
2017-09-04	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-05	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-06	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-07	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-08	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-09	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-10	32	8	3	2017	2017-09-04	2017-09-10	2
2017-09-11	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-12	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-13	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-14	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-15	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-16	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-17	33	8	3	2017	2017-09-11	2017-09-17	3
2017-09-18	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-19	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-20	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-21	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-22	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-23	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-24	34	8	3	2017	2017-09-18	2017-09-24	4
2017-09-25	35	9	3	2017	2017-09-25	2017-10-01	1
2017-09-26	35	9	3	2017	2017-09-25	2017-10-01	1
2017-09-27	35	9	3	2017	2017-09-25	2017-10-01	1
2017-10-04	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-05	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-06	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-07	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-08	36	9	3	2017	2017-10-02	2017-10-08	2
2017-10-09	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-10	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-11	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-12	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-13	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-14	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-15	37	9	3	2017	2017-10-09	2017-10-15	3
2017-10-16	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-17	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-18	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-19	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-20	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-21	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-22	38	9	3	2017	2017-10-16	2017-10-22	4
2017-10-23	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-24	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-25	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-26	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-27	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-28	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-29	39	9	3	2017	2017-10-23	2017-10-29	5
2017-10-30	40	10	3	2017	2017-10-30	2017-11-05	1
2017-10-31	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-01	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-02	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-03	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-04	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-05	40	10	3	2017	2017-10-30	2017-11-05	1
2017-11-06	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-07	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-08	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-09	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-10	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-11	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-12	41	10	3	2017	2017-11-06	2017-11-12	2
2017-11-13	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-14	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-15	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-16	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-17	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-18	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-19	42	10	3	2017	2017-11-13	2017-11-19	3
2017-11-20	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-21	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-22	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-23	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-24	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-25	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-26	43	10	3	2017	2017-11-20	2017-11-26	4
2017-11-27	44	11	3	2017	2017-11-27	2017-12-03	1
2017-11-28	44	11	3	2017	2017-11-27	2017-12-03	1
2017-11-29	44	11	3	2017	2017-11-27	2017-12-03	1
2017-11-30	44	11	3	2017	2017-11-27	2017-12-03	1
2017-12-01	44	11	3	2017	2017-11-27	2017-12-03	1
2017-12-02	44	11	3	2017	2017-11-27	2017-12-03	1
2017-12-03	44	11	3	2017	2017-11-27	2017-12-03	1
2017-12-04	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-05	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-06	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-07	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-08	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-09	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-10	45	11	3	2017	2017-12-04	2017-12-10	2
2017-12-11	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-12	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-13	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-14	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-15	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-16	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-17	46	11	3	2017	2017-12-11	2017-12-17	3
2017-12-18	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-19	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-20	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-21	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-22	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-23	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-24	47	11	3	2017	2017-12-18	2017-12-24	4
2017-12-25	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-26	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-27	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-28	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-29	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-30	48	12	4	2017	2017-12-25	2017-12-31	1
2017-12-31	48	12	4	2017	2017-12-25	2017-12-31	1
2018-01-01	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-02	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-03	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-04	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-05	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-06	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-07	49	12	4	2017	2018-01-01	2018-01-07	2
2018-01-08	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-09	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-10	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-11	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-12	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-13	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-14	50	12	4	2017	2018-01-08	2018-01-14	3
2018-01-15	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-16	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-17	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-18	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-19	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-20	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-21	51	12	4	2017	2018-01-15	2018-01-21	4
2018-01-22	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-23	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-24	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-25	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-26	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-27	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-28	52	12	4	2017	2018-01-22	2018-01-28	5
2018-01-29	1	1	1	2018	2018-01-29	2018-02-04	1
2018-01-30	1	1	1	2018	2018-01-29	2018-02-04	1
2018-01-31	1	1	1	2018	2018-01-29	2018-02-04	1
2018-02-01	1	1	1	2018	2018-01-29	2018-02-04	1
2018-02-02	1	1	1	2018	2018-01-29	2018-02-04	1
2018-02-03	1	1	1	2018	2018-01-29	2018-02-04	1
2018-02-04	1	1	1	2018	2018-01-29	2018-02-04	1
2018-02-05	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-06	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-07	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-08	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-09	2	1	1	2018	2018-02-05	2018-02-11	2
2018-02-10	2	1	1	2018	2018-02-05	2018-02-11	2
\.


--
-- Data for Name: tb_fiscal_month; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_fiscal_month (fiscal_month, name) FROM stdin;
1	February
2	March
3	April
4	May
5	June
6	July
7	August
8	September
9	October
10	November
11	December
12	January
\.


--
-- Data for Name: tb_location; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY tb_location (location, number, name, short_name, abbreviation, address_line_one, address_line_two, city, region, zip_postal, market, buying_office, mregion, division, company, district, ogrp, fedex_location, reset_team, sap_address_id, disabled, phone_number, fax_number, parent, location_type, modified, latitude, longitude, data_partner, vendor, final_execution_date, dock_open_time, dock_close_time, dock_manager_name, dock_manager_phone, store_open_date, square_footage) FROM stdin;
82	82	Tucson Location	Tucson	\N	89302 Doyle Crest #683	\N	Tucson	441	59016	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.891388	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
83	83	Seward Location	Seward	\N	31621 Kris Lock Suite 037	\N	Seward	443	19080	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.894789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
86	86	Redding Location	Redding	\N	46626 Reva Drive Suite 942	\N	Redding	460	70335-0391	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.902889	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
89	89	Huntington Beach Location	Huntington Beach	\N	39149 Koch Mount	\N	Huntington Beach	451	68768	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.911144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
91	91	Two Rivers Location	Two Rivers	\N	84875 Devon Crossroad Suite 492	\N	Two Rivers	440	65792-2209	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.916509	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
94	94	Sierra Vista Location	Sierra Vista	\N	68345 Tanya Crossing Suite 976	\N	Sierra Vista	\N	36907-1521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.937464	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
97	97	Delta Junction Location	Delta Junction	\N	04026 Bahringer Summit Apt. 092	\N	Delta Junction	427	87983	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.94671	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
100	100	La Puente Location	La Puente	\N	77563 Floor 634	\N	La Puente	451	41185	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.964971	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
102	102	Bakersfield Location	Bakersfield	\N	75103 Ralph Court #871	\N	Bakersfield	418	95095-5006	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.973265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
105	105	Bell Gardens Location	Bell Gardens	\N	93765 Diana Unions	\N	Bell Gardens	426	35783-5996	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.988922	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
108	108	City of Industry Location	City of Industry	\N	84262 Lucinda Courts	\N	City of Industry	425	44215	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.003748	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
111	111	Concord Location	Concord	\N	74709 Blick Lock Apt. 986	\N	Concord	413	71773	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.018932	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
113	113	Hollywood Location	Hollywood	\N	98543 Bailee Shoals Apt. 034	\N	Hollywood	412	36479-4352	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.025042	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
116	116	Covina Location	Covina	\N	30364 Quitzon Passage	\N	Covina	421	70713	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.033686	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
120	120	El Monte Location	El Monte	\N	94945 McLaughlin Crescent #472	\N	El Monte	429	47796	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.057858	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
124	124	Terre Haute Location	Terre Haute	\N	52142 Floor 552	\N	Terre Haute	450	35914	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.103738	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
127	127	La Jolla Location	La Jolla	\N	48752 Rear	\N	La Jolla	441	35669	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.112006	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
129	129	Santa Cruz Location	Santa Cruz	\N	11725 Robel Knoll Apt. 248	\N	Santa Cruz	459	20689-1758	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.117353	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
132	132	Huntington Park Location	Huntington Park	\N	77833 Barbara Mountain Suite 128	\N	Huntington Park	435	22222-7908	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.12534	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
135	135	Escondido Location	Escondido	\N	94282 Hudson Via	\N	Escondido	426	71447	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.133354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
138	138	Fresno Location	Fresno	\N	79384 Kari Cape Apt. 556	\N	Fresno	427	09903	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.151871	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
140	140	Zanesville Location	Zanesville	\N	80848 Zemlak Stravenue	\N	Zanesville	464	08383	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.157281	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
143	143	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	19721 Kreiger Prairie Suite 348	\N	Rancho Santa Margarita	462	51723	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.165209	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
146	146	Troy Location	Troy	\N	69730 Hyatt Overpass	\N	Troy	\N	50615-6506	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.172949	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
148	148	Corona Location	Corona	\N	59082 Iva Drive Suite 207	\N	Corona	419	88280	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.187799	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
151	151	Lafayette Location	Lafayette	\N	58412 Korbin Field Suite 221	\N	Lafayette	429	71312-7920	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.199113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
153	153	North Little Rock Location	North Little Rock	\N	26509 Frankie Key	\N	North Little Rock	458	06539-4529	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.204593	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
157	157	Texarkana Location	Texarkana	\N	42972 Beahan Cliffs #440	\N	Texarkana	442	56717	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.215818	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
160	160	Jeffersontown Location	Jeffersontown	\N	34393 Lot 48-A	\N	Jeffersontown	455	38875-4455	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.223937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
162	162	Placentia Location	Placentia	\N	30049 Wolff Forest	\N	Placentia	413	55627-5759	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.229332	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
165	165	Bloomington Location	Bloomington	\N	81049 Norma Station	\N	Bloomington	\N	72791	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.237376	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
169	169	Beverly Hills Location	Beverly Hills	\N	53707 Hagenes Mountains	\N	Beverly Hills	461	44146	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.261167	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
170	170	Bell Location	Bell	\N	82301 Franz Flats	\N	Bell	459	97937	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.265548	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
171	171	Little Rock Location	Little Rock	\N	30625 Graham Mission	\N	Little Rock	423	20025	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.271577	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
173	173	North Pole Location	North Pole	\N	49636 Ziemann Brooks	\N	North Pole	424	92501-0774	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.284846	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
177	177	La Verne Location	La Verne	\N	97143 Camden Route Apt. 736	\N	La Verne	442	09091	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.303714	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
179	179	Palos Verdes Estates Location	Palos Verdes Estates	\N	57075 Dibbert Pines Suite 182	\N	Palos Verdes Estates	465	40612-9779	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.309152	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
183	183	Chandler Location	Chandler	\N	82062 Monte Club	\N	Chandler	413	76500-5751	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.319548	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
185	185	San Francisco Location	San Francisco	\N	85737 Emard Spurs Apt. 778	\N	San Francisco	438	68638	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.324756	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
188	188	Compton Location	Compton	\N	81193 Stanton Parks	\N	Compton	418	32476-1952	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.332436	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
190	190	El Monte Location	El Monte	\N	63888 Cartwright Estates Suite 624	\N	El Monte	458	50497-5378	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.340985	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
193	193	Canton Location	Canton	\N	10635 Annetta Mill Apt. 838	\N	Canton	414	32412-9182	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.349574	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
196	196	Orange Location	Orange	\N	97175 Queenie Parkway Suite 986	\N	Orange	424	94670	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.357741	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
198	198	Springfield Location	Springfield	\N	65991 Jarvis Club Suite 942	\N	Springfield	427	97025	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.363121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
201	201	Covina Location	Covina	\N	65476 Bryon Light	\N	Covina	442	61833-4179	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.371505	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
204	204	Sacramento Location	Sacramento	\N	06144 Sporer Dale	\N	Sacramento	436	52225-6550	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.39915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
206	206	Vincennes Location	Vincennes	\N	47649 Shea Plains	\N	Vincennes	418	75877	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.404451	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
209	209	Pasadena Location	Pasadena	\N	73955 Miller Brook	\N	Pasadena	452	04023-7291	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.412161	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
212	212	Riverside Location	Riverside	\N	04466 Hilpert Track	\N	Riverside	430	36927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.420271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
215	215	Mentor Location	Mentor	\N	73444 Jammie Run	\N	Mentor	454	06737	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.428237	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
217	217	Roseville Location	Roseville	\N	37326 Reynolds Circle #571	\N	Roseville	454	21201-2010	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.434012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
220	220	Moreno Valley Location	Moreno Valley	\N	48719 Basement	\N	Moreno Valley	\N	57179-2167	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.448759	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
223	223	Chandler Location	Chandler	\N	31093 Spencer Mission	\N	Chandler	425	83708-5707	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.460813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
227	227	Artesia Location	Artesia	\N	95516 Rice Mountains	\N	Artesia	416	94143-6855	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.472877	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
229	229	Roseville Location	Roseville	\N	75456 Office	\N	Roseville	450	40578-3851	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.484824	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
232	232	Burlingame Location	Burlingame	\N	83577 Abbott Creek	\N	Burlingame	446	50339	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.502894	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
234	234	Tustin Location	Tustin	\N	83413 O'Conner Islands	\N	Tustin	418	14438	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.516316	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
237	237	San Francisco Location	San Francisco	\N	04588 Nelson Loaf Suite 793	\N	San Francisco	430	94514-2363	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.53294	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
239	239	Tuscaloosa Location	Tuscaloosa	\N	44107 Gorczany Pike #339	\N	Tuscaloosa	443	39209-4090	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.542521	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
242	242	Hope Location	Hope	\N	15630 Heidi Mountains #427	\N	Hope	433	55775	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.554759	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
244	244	Newport Beach Location	Newport Beach	\N	36839 Sabrina Field	\N	Newport Beach	440	49951	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.566361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
248	248	La Palma Location	La Palma	\N	84166 Cartwright Village	\N	La Palma	\N	64298-5860	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.584425	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
250	250	Cudahy Location	Cudahy	\N	56509 Karlee Islands	\N	Cudahy	461	10399	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.599536	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
253	253	Maywood Location	Maywood	\N	13671 Gus Locks #677	\N	Maywood	447	11961-0371	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.608534	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
256	256	Parma Location	Parma	\N	09134 Unit 97-F	\N	Parma	\N	34070-7931	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.617488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
258	258	Aliso Viejo Location	Aliso Viejo	\N	36077 Torrance Cape Suite 664	\N	Aliso Viejo	435	58804-3341	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.623398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
259	259	Terre Haute Location	Terre Haute	\N	83678 Elyssa Route Apt. 162	\N	Terre Haute	421	83181-2029	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.6268	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
262	262	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	17472 Pagac Island #181	\N	Rancho Palos Verdes	412	55512	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.635541	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
265	265	Rancho Cordova Location	Rancho Cordova	\N	85924 Roberts Lodge #616	\N	Rancho Cordova	438	78024-1879	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.651087	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
268	268	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	29868 Tatyana Cape	\N	Mentor-on-the-Lake	\N	90269-2290	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.665857	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
271	271	Michigan City Location	Michigan City	\N	05384 Anderson Way #158	\N	Michigan City	422	51002-5389	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.681115	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
274	274	Los Angeles Location	Los Angeles	\N	55848 Serena Ranch	\N	Los Angeles	456	29843-9635	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.689944	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
277	277	Florence Location	Florence	\N	68721 Jacquelyn Motorway	\N	Florence	\N	55695	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.705405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
280	280	Glendora Location	Glendora	\N	63459 Brycen Mountains	\N	Glendora	425	11438-1524	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.723079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
283	283	Laguna Niguel Location	Laguna Niguel	\N	06192 Apartment G	\N	Laguna Niguel	453	53613	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.735881	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
286	286	Monrovia Location	Monrovia	\N	99496 Schumm Inlet Apt. 863	\N	Monrovia	449	88809-1131	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.74717	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
289	289	Elkhart Location	Elkhart	\N	93525 Roberts Heights	\N	Elkhart	414	13038-3340	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.755957	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
291	291	Palos Verdes Estates Location	Palos Verdes Estates	\N	87696 Kaley Port	\N	Palos Verdes Estates	425	45598-9538	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.762006	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
294	294	San Dimas Location	San Dimas	\N	96190 Bashirian Flat	\N	San Dimas	447	54990-5316	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.778066	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
296	296	Temple City Location	Temple City	\N	16388 Herta Drives	\N	Temple City	417	99792-3578	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.788531	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
299	299	Prescott Location	Prescott	\N	01783 Torp Rest #849	\N	Prescott	453	39089-3472	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.796341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
302	302	Hollywood Location	Hollywood	\N	85042 Cindy Estate	\N	Hollywood	435	80975	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.804284	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
305	305	Louisville Location	Louisville	\N	95298 O'Reilly Stream #817	\N	Louisville	419	38515-3350	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.812132	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
307	307	South El Monte Location	South El Monte	\N	86066 Cortney Drives	\N	South El Monte	414	96680-2127	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.817383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
310	310	Lynwood Location	Lynwood	\N	02069 Aniyah Via Apt. 382	\N	Lynwood	\N	88190-4793	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.825184	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
313	313	Lakewood Location	Lakewood	\N	91134 Nicolas Pines	\N	Lakewood	458	64990-2515	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:07.83343	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
315	315	Placentia Location	Placentia	\N	57298 Dietrich Mill Suite 233	\N	Placentia	\N	09039-1927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.838664	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
318	318	South Bend Location	South Bend	\N	23383 Stephania Overpass	\N	South Bend	\N	85890	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.846405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
321	321	Monterey Location	Monterey	\N	36915 Lenora Port	\N	Monterey	421	24484	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.853906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
325	325	Riverside Location	Riverside	\N	34470 Clemmie Alley #585	\N	Riverside	459	97020	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.873142	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
327	327	Costa Mesa Location	Costa Mesa	\N	69584 Josianne Summit	\N	Costa Mesa	451	83202-2954	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.883552	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
330	330	Bell Gardens Location	Bell Gardens	\N	13631 Armstrong Extension Apt. 597	\N	Bell Gardens	453	95767-0288	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.891837	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
333	333	Bentonville Location	Bentonville	\N	23857 Daryl Ways	\N	Bentonville	424	66348	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.900443	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
335	335	Mission Viejo Location	Mission Viejo	\N	21389 Braun Island Apt. 649	\N	Mission Viejo	463	03487-2250	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.906156	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
338	338	Tucson Location	Tucson	\N	75624 Rutherford Brooks Apt. 813	\N	Tucson	\N	55171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.914761	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
341	341	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	61351 Breanne Ports	\N	Rancho Santa Margarita	\N	74893	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.922957	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
344	344	Oxnard Location	Oxnard	\N	30103 Howell Lodge	\N	Oxnard	418	38519-0191	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.946902	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
346	346	Redlands Location	Redlands	\N	63906 Alford Forges	\N	Redlands	\N	58428-5822	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.955541	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
347	347	Santa Monica Location	Santa Monica	\N	74832 Toby Wall	\N	Santa Monica	415	98302-0154	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.961608	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
350	350	Villa Park Location	Villa Park	\N	97013 Lehner Drive	\N	Villa Park	423	60821-6785	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.971172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
353	353	Valencia Location	Valencia	\N	76183 Gleichner Islands #963	\N	Valencia	439	35105-5014	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.986604	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
355	355	San Juan Capistrano Location	San Juan Capistrano	\N	97337 Tamia Neck	\N	San Juan Capistrano	454	24836-2634	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.992691	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
358	358	Terre Haute Location	Terre Haute	\N	84684 Peggie Brook Suite 093	\N	Terre Haute	432	89940-4182	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.016865	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
361	361	Rialto Location	Rialto	\N	49350 Side	\N	Rialto	414	13057	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.03174	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
363	363	San Luis Obispo Location	San Luis Obispo	\N	64687 Christ Ramp	\N	San Luis Obispo	449	05493-0632	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.037695	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
366	366	Auburn Location	Auburn	\N	07457 Melyna Mountains Apt. 298	\N	Auburn	435	20487-5881	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.047054	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
368	368	Demopolis Location	Demopolis	\N	76756 Moore Avenue Apt. 715	\N	Demopolis	436	51582-6619	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.055796	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
371	371	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	06789 Rohan Crest Suite 410	\N	Rancho Palos Verdes	\N	77659	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.06794	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
374	374	Tustin Location	Tustin	\N	94349 Champlin Mission Suite 733	\N	Tustin	431	36819-5492	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.094076	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
377	377	Gilbert Location	Gilbert	\N	72981 Daugherty Street Suite 009	\N	Gilbert	413	35391	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.113255	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
380	380	Delta Junction Location	Delta Junction	\N	84006 Price Groves	\N	Delta Junction	416	69957	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.127519	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
383	383	Los Angeles Location	Los Angeles	\N	76362 Fadel Stravenue	\N	Los Angeles	412	09337-2268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.137055	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
385	385	Fullerton Location	Fullerton	\N	41924 Haleigh Meadows	\N	Fullerton	456	91098-1284	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.143152	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
388	388	Peoria Location	Peoria	\N	37997 Jewess Loop	\N	Peoria	442	23739	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.151866	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
390	390	Rolling Hills Estates Location	Rolling Hills Estates	\N	58252 Zoey Turnpike #561	\N	Rolling Hills Estates	417	44705-9247	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.158303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
394	394	Eufaula Location	Eufaula	\N	01515 Penthouse	\N	Eufaula	417	91032-6832	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.183973	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
397	397	Claremont Location	Claremont	\N	52508 Barton Pike	\N	Claremont	412	16256-5619	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.202999	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
400	400	Simi Valley Location	Simi Valley	\N	85734 Bins Ports Suite 637	\N	Simi Valley	414	17216-1869	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.220877	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
403	403	Gadsden Location	Gadsden	\N	56076 Kevin Ranch #245	\N	Gadsden	441	77482-1523	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.229895	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
405	405	Huntington Park Location	Huntington Park	\N	00656 Ardella Divide #946	\N	Huntington Park	462	30527-3839	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.235827	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
408	408	Roseville Location	Roseville	\N	30871 Hamill Row Apt. 904	\N	Roseville	430	53418	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.251526	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
411	411	South El Monte Location	South El Monte	\N	78414 Kenyatta Course #093	\N	South El Monte	449	22415-4848	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.260074	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
415	415	Athens Location	Athens	\N	83908 Bertram Meadow Suite 612	\N	Athens	\N	31230-4750	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.272212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
417	417	Los Angeles Location	Los Angeles	\N	41806 Norval Mill Suite 550	\N	Los Angeles	426	69754	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.278303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
420	420	Dothan Location	Dothan	\N	40972 Boyer Neck	\N	Dothan	\N	32605-8154	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.287704	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
422	422	Vernon Location	Vernon	\N	49231 Room E	\N	Vernon	431	29378-4086	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.299484	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
425	425	Scottsdale Location	Scottsdale	\N	41772 Pier 67-H	\N	Scottsdale	445	22220	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.317503	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
428	428	Sutter Creek Location	Sutter Creek	\N	41701 Abshire Wells	\N	Sutter Creek	428	48996	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.325527	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
431	431	Irwindale Location	Irwindale	\N	36279 Bins Isle #014	\N	Irwindale	422	98276-1337	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.33348	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
433	433	Hawthorne Location	Hawthorne	\N	12659 Hangar 289	\N	Hawthorne	426	33706	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.338965	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
434	434	Richmond Location	Richmond	\N	05421 Imelda Views	\N	Richmond	446	26367-1254	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.341684	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
435	435	Birmingham Location	Birmingham	\N	77580 Franecki Junction Apt. 407	\N	Birmingham	422	34811	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.344401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
438	438	Seal Beach Location	Seal Beach	\N	46241 Willms Pass Suite 205	\N	Seal Beach	432	69896-3640	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.363055	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
442	442	Montebello Location	Montebello	\N	95648 Frami Stravenue Apt. 896	\N	Montebello	448	00768-6521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.373857	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
445	445	Lynwood Location	Lynwood	\N	67620 Arlo Courts Apt. 949	\N	Lynwood	450	73155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.381806	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
448	448	Phenix City Location	Phenix City	\N	43170 Hangar V	\N	Phenix City	438	55471	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.389708	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
451	451	Nenana Location	Nenana	\N	34551 Kelly Falls Apt. 916	\N	Nenana	448	30952	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.410401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
454	454	Elkhart Location	Elkhart	\N	89975 West Plains	\N	Elkhart	\N	93975-0612	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.419111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
457	457	Stanton Location	Stanton	\N	70590 Kenyatta Haven	\N	Stanton	423	35098	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.427215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
459	459	La Mirada Location	La Mirada	\N	26977 Reta Flat	\N	La Mirada	434	43345-2936	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.432603	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
462	462	Stanton Location	Stanton	\N	62480 Anne Avenue #541	\N	Stanton	427	47889	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.440925	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
464	464	Mobile Location	Mobile	\N	93273 Lurline Summit	\N	Mobile	463	73709-2126	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.446779	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
466	466	Crown Point Location	Crown Point	\N	60467 Rolando Plaza #057	\N	Crown Point	451	64749-0625	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.462068	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
469	469	Hawthorne Location	Hawthorne	\N	86841 Sincere Loaf	\N	Hawthorne	\N	08685-5460	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.476485	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
472	472	Oxnard Location	Oxnard	\N	22135 Floor 8	\N	Oxnard	433	68450-1660	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.488519	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
475	475	Calabasas Location	Calabasas	\N	73322 August Field #780	\N	Calabasas	429	88938-0054	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.498111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
478	478	Pico Rivera Location	Pico Rivera	\N	72561 Cole Trail	\N	Pico Rivera	415	74889-7912	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.506905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
481	481	Bloomington Location	Bloomington	\N	72205 Kellie Trail Apt. 855	\N	Bloomington	432	41524	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.52227	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
484	484	Temple City Location	Temple City	\N	84258 Klocko Squares	\N	Temple City	447	29978	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.542363	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
486	486	Newport Beach Location	Newport Beach	\N	75229 Bailey Crossroad	\N	Newport Beach	418	50925-6957	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.548242	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
489	489	Sierra Madre Location	Sierra Madre	\N	85922 Bogan Villages	\N	Sierra Madre	424	24887	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.556157	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
492	492	Monterey Park Location	Monterey Park	\N	72368 Roberts Pass #912	\N	Monterey Park	434	41387	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.563897	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
495	495	Laguna Niguel Location	Laguna Niguel	\N	66976 Natalie Fork	\N	Laguna Niguel	423	76662-7182	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.571929	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
497	497	Tustin Location	Tustin	\N	75048 Kutch Dale	\N	Tustin	418	18391-3806	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.577239	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
500	500	Simi Valley Location	Simi Valley	\N	32359 Hoppe Manor Apt. 822	\N	Simi Valley	455	51090	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.590913	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
502	502	Delta Junction Location	Delta Junction	\N	49845 Christelle Turnpike #819	\N	Delta Junction	462	73235-8272	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.596391	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
506	506	San Luis Obispo Location	San Luis Obispo	\N	06756 Gislason Shores #765	\N	San Luis Obispo	\N	07002-3539	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.607306	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
509	509	Eufaula Location	Eufaula	\N	96821 Cydney Island	\N	Eufaula	436	93839	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.615439	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
512	512	Cypress Location	Cypress	\N	96035 Evert Stravenue #643	\N	Cypress	450	54966	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.623639	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
514	514	Muncie Location	Muncie	\N	52754 Florine Forge Suite 418	\N	Muncie	413	46078-3099	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.648055	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
517	517	Laguna Woods Location	Laguna Woods	\N	17524 Ari Key	\N	Laguna Woods	\N	33627	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.657406	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
520	520	Springfield Location	Springfield	\N	57193 Suzanne Port	\N	Springfield	434	48668	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.665007	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
523	523	Oakland Location	Oakland	\N	98449 Raynor Lodge #348	\N	Oakland	443	97963	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.681167	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
524	524	Inglewood Location	Inglewood	\N	25235 Meda Fort Suite 542	\N	Inglewood	413	71245-0693	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.687464	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
526	526	Steubenville Location	Steubenville	\N	47849 Johnston Avenue	\N	Steubenville	453	67440	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.693139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
529	529	West Hollywood Location	West Hollywood	\N	15672 Wendy Hill	\N	West Hollywood	447	49751	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.708767	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
531	531	Forrest City Location	Forrest City	\N	35240 Shaina Mountains	\N	Forrest City	429	08201-6901	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.7147	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
533	533	Laguna Beach Location	Laguna Beach	\N	57620 Reichert Harbor #615	\N	Laguna Beach	441	04859	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.720707	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
536	536	Lexington Location	Lexington	\N	21252 Micaela Street	\N	Lexington	432	49956	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.729397	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
539	539	Hammond Location	Hammond	\N	09935 Bogan Manor	\N	Hammond	438	30551	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.738896	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
542	542	Whittier Location	Whittier	\N	29176 Williamson Crest	\N	Whittier	422	47515-7174	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.751138	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
545	545	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	37310 Hermann Trafficway	\N	Rancho Santa Margarita	455	83163	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.759754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
548	548	Redlands Location	Redlands	\N	44932 Schiller Ports Apt. 064	\N	Redlands	427	04835	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.783936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
551	551	Norwalk Location	Norwalk	\N	98263 Mariane Unions	\N	Norwalk	440	56798-7325	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.793308	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
554	554	Glendale Location	Glendale	\N	39643 Gregorio Oval	\N	Glendale	452	37309-8743	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.802118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
556	556	San Marino Location	San Marino	\N	84528 Jimmy Green #744	\N	San Marino	454	04932-8038	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.834163	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
559	559	Nogales Location	Nogales	\N	04118 Lind Flats Apt. 834	\N	Nogales	459	93367	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.847032	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
562	562	Pico Rivera Location	Pico Rivera	\N	98359 Kunze Ridge #519	\N	Pico Rivera	\N	28121-0826	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.855864	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
565	565	Rolling Hills Location	Rolling Hills	\N	38334 Deckow Cove	\N	Rolling Hills	\N	13050	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.870452	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
568	568	Homer Location	Homer	\N	07666 Bailey Run	\N	Homer	450	08659	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.88341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
571	571	Irvine Location	Irvine	\N	89374 Unit 8-C	\N	Irvine	447	66867	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.900881	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
573	573	Fort Wayne Location	Fort Wayne	\N	99141 Amy Brooks	\N	Fort Wayne	416	62932	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.912851	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
576	576	Canton Location	Canton	\N	02834 Floor 271	\N	Canton	421	50749	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.9211	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
578	578	Palmdale Location	Palmdale	\N	50757 Strosin Plains #104	\N	Palmdale	439	54417	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.926362	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
581	581	Blythe Location	Blythe	\N	58948 Carter Fort	\N	Blythe	434	78400	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.93467	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
583	583	Fort Wayne Location	Fort Wayne	\N	40562 Randal Wall Apt. 538	\N	Fort Wayne	412	37796-2631	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.940119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
586	586	Rialto Location	Rialto	\N	84923 Bayer Isle	\N	Rialto	460	49431-1322	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.948524	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
588	588	San Jose Location	San Jose	\N	77740 Blanca Trail Suite 359	\N	San Jose	\N	75006	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.967511	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
592	592	Richmond Location	Richmond	\N	87718 Rickey Fort Suite 956	\N	Richmond	428	33683-2864	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.981615	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
594	594	Thousand Oaks Location	Thousand Oaks	\N	58116 Hansen Corners	\N	Thousand Oaks	432	08411-7623	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.987837	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
596	596	Beverly Hills Location	Beverly Hills	\N	04193 Murphy Estate	\N	Beverly Hills	\N	37799-1818	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.993797	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
599	599	Calabasas Location	Calabasas	\N	27377 Kris Ville #280	\N	Calabasas	442	55806	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.018126	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
602	602	Stanton Location	Stanton	\N	19635 Raymundo Court	\N	Stanton	430	78871	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.033337	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
604	604	San Dimas Location	San Dimas	\N	38109 Grimes Forge	\N	San Dimas	465	25412-2226	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.0455	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
607	607	Chula Vista Location	Chula Vista	\N	51358 Little Forge Apt. 290	\N	Chula Vista	419	69022-2085	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.053827	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
609	609	Irwindale Location	Irwindale	\N	43084 Moshe Shoals	\N	Irwindale	415	94929-1705	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.059074	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
611	611	Lancaster Location	Lancaster	\N	35222 McClure Path Apt. 065	\N	Lancaster	460	38841-7335	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.064324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
613	613	Pine Bluff Location	Pine Bluff	\N	97738 Lubowitz Plain Suite 181	\N	Pine Bluff	428	25205-0325	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.069624	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
616	616	La Cañada Flintridge Location	La Cañada Flintridge	\N	47210 Maude Unions Suite 768	\N	La Cañada Flintridge	444	18795-9578	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.077538	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
618	618	Signal Hill Location	Signal Hill	\N	21115 Enrico Junction #784	\N	Signal Hill	417	48536	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.087295	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
622	622	Auburn Location	Auburn	\N	60478 Wiza Parkways	\N	Auburn	464	56274	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.098111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
624	624	Cincinnati Location	Cincinnati	\N	27531 Rodrigo Vista Apt. 192	\N	Cincinnati	428	73319-6803	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.103963	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
627	627	Hidden Hills Location	Hidden Hills	\N	87168 Gottlieb Village #638	\N	Hidden Hills	430	80183-1021	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.113532	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
630	630	Ventura Location	Ventura	\N	99187 Elizabeth Ramp #640	\N	Ventura	434	54199	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.124038	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
632	632	San Juan Capistrano Location	San Juan Capistrano	\N	89889 Nadia Ford	\N	San Juan Capistrano	439	81506-4081	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.12954	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
635	635	Monterey Location	Monterey	\N	07602 O'Reilly Grove	\N	Monterey	465	14704-5818	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.159494	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
637	637	Lakewood Location	Lakewood	\N	61806 Botsford Mills #817	\N	Lakewood	\N	54546	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.164952	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
640	640	Seal Beach Location	Seal Beach	\N	00461 Akeem Underpass	\N	Seal Beach	452	44927-5661	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.173123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
644	644	Lafayette Location	Lafayette	\N	13822 Dortha Drive	\N	Lafayette	422	11462	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.183375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
646	646	Garden Grove Location	Garden Grove	\N	75945 Lionel Brook Suite 104	\N	Garden Grove	465	11411	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.188534	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
649	649	Visalia Location	Visalia	\N	27625 Schaden Cove Apt. 464	\N	Visalia	429	56400-5426	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.196468	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
652	652	Carson Location	Carson	\N	74538 Langworth Square	\N	Carson	456	83589-2497	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.220099	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
655	655	Ontario Location	Ontario	\N	49228 Alba Well Suite 522	\N	Ontario	\N	76289	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.231568	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
657	657	West Lafayette Location	West Lafayette	\N	54324 Kuhlman Plains Apt. 573	\N	West Lafayette	433	61968-4022	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.237669	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
660	660	Oxnard Location	Oxnard	\N	87562 Savion Park	\N	Oxnard	455	90765-1900	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.246095	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
663	663	Glendale Location	Glendale	\N	93943 Bernier Well	\N	Glendale	462	00325	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.255858	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
665	665	Mesa Location	Mesa	\N	60143 Hollie Hollow Apt. 024	\N	Mesa	431	14178-5676	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.261936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
668	668	Lynwood Location	Lynwood	\N	53278 Chad Forge	\N	Lynwood	429	81504-1614	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.282522	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
670	670	Huntington Park Location	Huntington Park	\N	91780 Rubye Court	\N	Huntington Park	420	15437-6028	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.295469	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
674	674	Mobile Location	Mobile	\N	06589 Vivien Field Apt. 589	\N	Mobile	426	80593	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.312965	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
677	677	Cincinnati Location	Cincinnati	\N	75452 Sigmund Terrace #723	\N	Cincinnati	430	92918-4837	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.322315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
681	681	Calabasas Location	Calabasas	\N	47427 Connelly Road Apt. 763	\N	Calabasas	438	66281	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.343817	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
683	683	Laguna Woods Location	Laguna Woods	\N	82154 Elyssa Manors	\N	Laguna Woods	463	40406	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.35864	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
686	686	Pine Bluff Location	Pine Bluff	\N	67089 Marquardt Causeway	\N	Pine Bluff	454	60845	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.37609	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
689	689	Nenana Location	Nenana	\N	64127 Reichel Garden	\N	Nenana	\N	18835-7442	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.394144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
692	692	Stockton Location	Stockton	\N	23036 Dessie Land	\N	Stockton	432	14924-3817	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.406296	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
695	695	Los Angeles Location	Los Angeles	\N	72971 Genesis Station #246	\N	Los Angeles	451	76198-1073	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.421108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
698	698	Half Moon Bay Location	Half Moon Bay	\N	71623 Amalia Loop	\N	Half Moon Bay	421	61800	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.435854	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
700	700	Ventura Location	Ventura	\N	71749 Rear	\N	Ventura	453	49786	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.447939	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
702	702	Agoura Hills Location	Agoura Hills	\N	70134 Farrell Land	\N	Agoura Hills	453	26847	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.456961	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
705	705	Rancho Cordova Location	Rancho Cordova	\N	92638 Stop 6-I	\N	Rancho Cordova	464	15464	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.478294	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
707	707	Jeffersontown Location	Jeffersontown	\N	37175 Nicolette Groves	\N	Jeffersontown	458	18242-7884	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.484356	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
710	710	Sierra Madre Location	Sierra Madre	\N	59618 Williamson Trail	\N	Sierra Madre	419	34535-5391	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.492869	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
712	712	Palmdale Location	Palmdale	\N	59026 Hangar 04-H	\N	Palmdale	444	64750-9983	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.50839	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
716	716	Delta Junction Location	Delta Junction	\N	02198 Maritza Lakes	\N	Delta Junction	455	03920-8827	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.522937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
718	718	Santa Clara Location	Santa Clara	\N	13083 Wehner Tunnel #185	\N	Santa Clara	415	81440-1700	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.532789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
722	722	Oxnard Location	Oxnard	\N	32604 Floor 236	\N	Oxnard	425	89655	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.550808	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
725	725	Calabasas Location	Calabasas	\N	89790 Timmy Mall #249	\N	Calabasas	465	39487-7005	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.562928	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
728	728	El Segundo Location	El Segundo	\N	78264 Stracke Junctions	\N	El Segundo	423	83217	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.577847	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
730	730	Temecula Location	Temecula	\N	11765 Connelly Ford #644	\N	Temecula	458	24622-3101	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.586338	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
733	733	Hayward Location	Hayward	\N	45007 Stroman Stream	\N	Hayward	451	02684	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.593597	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
735	735	Monterey Location	Monterey	\N	09956 Shane Villages Apt. 180	\N	Monterey	428	00802	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.598736	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
738	738	Hamilton Location	Hamilton	\N	45104 Slip S	\N	Hamilton	440	61882-6139	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.60786	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
742	742	Bradbury Location	Bradbury	\N	37987 Parisian Cove	\N	Bradbury	443	03271	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.620606	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
744	744	Signal Hill Location	Signal Hill	\N	23018 Tre Radial	\N	Signal Hill	418	41208	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.62596	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
747	747	Eureka Location	Eureka	\N	52102 Trailer M	\N	Eureka	455	18518-8268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.63381	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
750	750	Long Beach Location	Long Beach	\N	72424 Lobby	\N	Long Beach	459	95582	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.641113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
752	752	San Mateo Location	San Mateo	\N	40098 Rutherford Bridge Suite 970	\N	San Mateo	423	62583-0134	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.646053	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
756	756	Athens Location	Athens	\N	77336 Brown Court Apt. 836	\N	Athens	430	63850	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.656114	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
759	759	Decatur Location	Decatur	\N	43281 Trailer N	\N	Decatur	449	85685-2303	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.668367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
762	762	Palm Springs Location	Palm Springs	\N	09388 Bettie Landing Suite 412	\N	Palm Springs	417	17921	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.67589	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
764	764	Carson Location	Carson	\N	25777 Laverne Spurs Suite 579	\N	Carson	435	41873	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.680923	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
767	767	Lomita Location	Lomita	\N	71145 Stop D	\N	Lomita	439	52754	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.688488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
769	769	Sunnyvale Location	Sunnyvale	\N	07312 Michaela Wall	\N	Sunnyvale	423	28888-8041	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.693556	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
772	772	Springdale Location	Springdale	\N	98301 Unit 539	\N	Springdale	\N	27487	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.701208	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
774	774	North Little Rock Location	North Little Rock	\N	83709 Hartmann Underpass #441	\N	North Little Rock	427	24568-9054	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.713396	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
777	777	Citrus Heights Location	Citrus Heights	\N	71647 Turner Crossroad #404	\N	Citrus Heights	\N	35155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.72508	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
780	780	Tuskegee Location	Tuskegee	\N	06767 Reichel Haven #305	\N	Tuskegee	430	04930-0005	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.737172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
783	783	Beverly Hills Location	Beverly Hills	\N	87083 Suite C	\N	Beverly Hills	\N	21788-8559	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.745813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
785	785	Huntington Park Location	Huntington Park	\N	67634 Romaine Forges	\N	Huntington Park	\N	64403	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.751886	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
787	787	La Habra Location	La Habra	\N	38557 Stiedemann Extension #663	\N	La Habra	416	22811-8316	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.757995	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
789	789	Huntington Beach Location	Huntington Beach	\N	25929 Vivian Parkway Suite 713	\N	Huntington Beach	412	90319	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.764122	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
793	793	Claremont Location	Claremont	\N	72668 Tanya Run #701	\N	Claremont	463	56509-3717	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.784876	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
796	796	Prescott Location	Prescott	\N	14000 Will Ridge	\N	Prescott	462	44863	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.792281	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
799	799	San Juan Capistrano Location	San Juan Capistrano	\N	39775 Waelchi Islands	\N	San Juan Capistrano	465	61650	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.799964	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
802	802	Chino Location	Chino	\N	56273 Glenna Plains Suite 064	\N	Chino	453	82766-6932	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.807544	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
805	805	Seward Location	Seward	\N	31037 Letitia Village #408	\N	Seward	436	10556	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.815163	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
809	809	Pasadena Location	Pasadena	\N	54334 Jennyfer Extensions	\N	Pasadena	464	60008-9939	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.825115	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
811	811	San Gabriel Location	San Gabriel	\N	40968 Olson Estates	\N	San Gabriel	446	04662-6434	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.83007	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
814	814	Westminster Location	Westminster	\N	28586 Timothy Bypass	\N	Westminster	424	95394	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.837415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
817	817	Sierra Madre Location	Sierra Madre	\N	11336 Golda Rapid	\N	Sierra Madre	\N	46788-6130	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.844943	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
819	819	Beverly Hills Location	Beverly Hills	\N	52498 Runolfsdottir Avenue	\N	Beverly Hills	424	78939-8034	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.852974	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
823	823	Cleveland Location	Cleveland	\N	78022 Vena Lodge #969	\N	Cleveland	423	61020-0293	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.86334	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
826	826	La Habra Location	La Habra	\N	86903 Wilkinson Junction #978	\N	La Habra	457	38294	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.87091	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
829	829	San Bernardino Location	San Bernardino	\N	03101 Bergstrom Valley	\N	San Bernardino	419	36334	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.878584	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
832	832	Laguna Niguel Location	Laguna Niguel	\N	64998 Kris Shoals	\N	Laguna Niguel	426	60078	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.886108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
835	835	Mission Viejo Location	Mission Viejo	\N	41768 Floor 375	\N	Mission Viejo	451	11742	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.902448	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
837	837	West Lafayette Location	West Lafayette	\N	96075 Dickens Spurs Apt. 987	\N	West Lafayette	460	46211	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.913692	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
840	840	Downey Location	Downey	\N	19951 Unit 49-E	\N	Downey	433	55873-5519	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.928314	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
843	843	Concord Location	Concord	\N	90688 Stop 91-E	\N	Concord	445	16634-0648	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.937864	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
845	845	Lake Forest Location	Lake Forest	\N	69726 Deckow Point #730	\N	Lake Forest	437	43541-7140	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.943993	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
849	849	Hawaiian Gardens Location	Hawaiian Gardens	\N	66571 Floor 69	\N	Hawaiian Gardens	460	25338-4461	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.962334	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
851	851	Oro Valley Location	Oro Valley	\N	58971 Ryan Drives	\N	Oro Valley	454	97734	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.970571	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
854	854	Los Angeles Location	Los Angeles	\N	99222 Ralph Plains	\N	Los Angeles	454	42749-7482	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.98096	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
857	857	Mesa Location	Mesa	\N	91840 Lindsey Court Suite 610	\N	Mesa	\N	71784-9714	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.98854	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
860	860	Santa Cruz Location	Santa Cruz	\N	23060 Abagail Parkway Apt. 897	\N	Santa Cruz	459	87460-1903	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.996036	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
863	863	Louisville Location	Louisville	\N	73526 Stop B	\N	Louisville	464	31597	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.004254	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
867	867	San Fernando Location	San Fernando	\N	68616 Ana Via #816	\N	San Fernando	418	64616-4748	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.014795	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
870	870	West Hollywood Location	West Hollywood	\N	24924 Aliya Loop Suite 237	\N	West Hollywood	427	26343-1269	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.027919	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
873	873	Monrovia Location	Monrovia	\N	79204 Huel Extensions	\N	Monrovia	418	68353	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.035822	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
875	875	Paramount Location	Paramount	\N	76356 Donnelly Camp	\N	Paramount	449	34207-5861	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.041277	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
878	878	Jeffersontown Location	Jeffersontown	\N	79283 Lorine Crossroad	\N	Jeffersontown	438	41587	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.04912	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
881	881	Mesa Location	Mesa	\N	62768 Reilly Row	\N	Mesa	\N	09925-7593	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.057012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
884	884	Oakland Location	Oakland	\N	05419 Shields Crossroad	\N	Oakland	423	28488	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.07645	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
886	886	La Habra Heights Location	La Habra Heights	\N	52862 Karelle Vista	\N	La Habra Heights	425	15320	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.085102	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
890	890	Valparaiso Location	Valparaiso	\N	35922 Madeline Freeway Apt. 162	\N	Valparaiso	454	45519-3397	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.095372	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
894	894	Simi Valley Location	Simi Valley	\N	86359 Maximus Spurs Suite 668	\N	Simi Valley	433	35402-1768	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.105783	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
896	896	Hawaiian Gardens Location	Hawaiian Gardens	\N	19976 Karina Trail	\N	Hawaiian Gardens	445	50364-9826	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.110955	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
899	899	Gadsden Location	Gadsden	\N	56269 Davon Walks #928	\N	Gadsden	430	78239-8268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.119162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
902	902	Parma Location	Parma	\N	36957 Hope Shore	\N	Parma	426	28415-7298	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.130241	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
904	904	Alhambra Location	Alhambra	\N	13887 Bahringer Port	\N	Alhambra	420	45313-5223	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.136307	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
906	906	Rancho Cucamonga Location	Rancho Cucamonga	\N	29862 Tomas Summit	\N	Rancho Cucamonga	413	99671	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.145031	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
909	909	Two Rivers Location	Two Rivers	\N	14539 Rudy Prairie	\N	Two Rivers	446	13477-9906	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.154462	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
912	912	Eufaula Location	Eufaula	\N	34234 Yundt Point Suite 511	\N	Eufaula	427	97749	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.179231	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
914	914	Signal Hill Location	Signal Hill	\N	96177 Johnston Isle	\N	Signal Hill	445	95239	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.196833	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
918	918	Roseville Location	Roseville	\N	73199 Douglas Canyon	\N	Roseville	432	62704	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.214842	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
921	921	Agoura Hills Location	Agoura Hills	\N	82945 Rogahn Ports	\N	Agoura Hills	426	96464	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.22689	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
924	924	Muncie Location	Muncie	\N	38232 Metz Meadows	\N	Muncie	441	14399	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.244963	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
927	927	Lakewood Location	Lakewood	\N	18367 Emmerich Passage	\N	Lakewood	451	92639	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.262354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
929	929	Huntington Beach Location	Huntington Beach	\N	65254 Kautzer Port #062	\N	Huntington Beach	427	27725	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.26807	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
932	932	Hermosa Beach Location	Hermosa Beach	\N	07532 Considine Divide Suite 863	\N	Hermosa Beach	\N	54624	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.292389	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
934	934	Santa Fe Springs Location	Santa Fe Springs	\N	81334 Huels Manor	\N	Santa Fe Springs	440	24315-9412	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.302627	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
938	938	Nenana Location	Nenana	\N	88806 Carter Plains Suite 830	\N	Nenana	452	13477	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.325608	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
940	940	Union City Location	Union City	\N	14972 Kassulke Row	\N	Union City	413	00364-0887	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.331683	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
943	943	Redondo Beach Location	Redondo Beach	\N	75817 Waelchi Haven #711	\N	Redondo Beach	465	31062	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.347073	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
947	947	Half Moon Bay Location	Half Moon Bay	\N	14288 Enos Village Suite 606	\N	Half Moon Bay	443	68997-3285	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.365397	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
950	950	Monterey Park Location	Monterey Park	\N	84410 Leslie Run	\N	Monterey Park	\N	93366	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.380037	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
952	952	Rancho Cucamonga Location	Rancho Cucamonga	\N	54932 Andrew Lane Apt. 343	\N	Rancho Cucamonga	433	32928	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.395237	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
955	955	Moreno Valley Location	Moreno Valley	\N	32063 Green Street	\N	Moreno Valley	459	45561-9834	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.432906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
957	957	South Bend Location	South Bend	\N	90640 Bernhard Parkway	\N	South Bend	436	31343-0793	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.443028	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
962	962	Daly City Location	Daly City	\N	80514 Norwood Stream Suite 771	\N	Daly City	413	79425	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.47079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
964	964	Rolling Hills Location	Rolling Hills	\N	58233 Gleichner Garden	\N	Rolling Hills	423	81426	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.493972	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
966	966	Hollywood Location	Hollywood	\N	89761 Wilfredo Lodge	\N	Hollywood	435	54133	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.506048	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
969	969	Muncie Location	Muncie	\N	35447 Breitenberg Pass	\N	Muncie	450	51155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.545451	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
971	971	Florence Location	Florence	\N	05130 Consuelo Camp Apt. 466	\N	Florence	444	58365-5148	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.563521	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
975	975	Little Rock Location	Little Rock	\N	55608 Schiller Burg	\N	Little Rock	430	62834	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.591044	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
977	977	Lake Forest Location	Lake Forest	\N	19044 Candelario Springs	\N	Lake Forest	448	83789-1562	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.610923	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
980	980	Fayetteville Location	Fayetteville	\N	64635 Antwon Lock #818	\N	Fayetteville	\N	48901	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.621676	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
983	983	Glendora Location	Glendora	\N	28469 Jackson Route #532	\N	Glendora	457	78292	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.629349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
985	985	Thousand Oaks Location	Thousand Oaks	\N	72445 Goldner Place	\N	Thousand Oaks	416	83113-1882	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.634609	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
988	988	Pico Rivera Location	Pico Rivera	\N	49456 Ritchie Ville	\N	Pico Rivera	452	06302-0072	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.6424	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
991	991	Placentia Location	Placentia	\N	60150 O'Hara Drive Apt. 705	\N	Placentia	\N	61758-2328	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.650675	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
993	993	Alhambra Location	Alhambra	\N	31863 Armando Port Apt. 745	\N	Alhambra	439	84806-8112	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.655936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
996	996	Blythe Location	Blythe	\N	66868 Kuhlman Lane	\N	Blythe	\N	03839	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.663502	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
999	999	Huntington Park Location	Huntington Park	\N	15725 Carey Isle	\N	Huntington Park	436	58825	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.670915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1002	1002	San Francisco Location	San Francisco	\N	07744 Holly Drive	\N	San Francisco	442	73116-9951	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.678606	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1005	1005	Sierra Vista Location	Sierra Vista	\N	72831 Lind Bypass Suite 110	\N	Sierra Vista	438	07585	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.686248	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1007	1007	Jonesboro Location	Jonesboro	\N	84676 Ritchie Fields #210	\N	Jonesboro	452	42679	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.694972	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1010	1010	Lancaster Location	Lancaster	\N	10038 Marilyne Cove Apt. 583	\N	Lancaster	\N	61171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.702837	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1013	1013	Peoria Location	Peoria	\N	33141 Heller Station Suite 434	\N	Peoria	\N	95350	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.710794	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1015	1015	Nogales Location	Nogales	\N	86037 Department 17-D	\N	Nogales	418	92410-8440	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.715909	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1018	1018	Westlake Village Location	Westlake Village	\N	95722 Carter Loop	\N	Westlake Village	\N	10857	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.723702	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1020	1020	Riverside Location	Riverside	\N	11030 Royce Turnpike Suite 051	\N	Riverside	434	29073-0978	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.728844	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1023	1023	La Puente Location	La Puente	\N	97854 Brandyn Pass Apt. 949	\N	La Puente	\N	36581-3330	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.75677	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1027	1027	Athens Location	Athens	\N	69166 Shields Port #197	\N	Athens	447	65928-5769	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.768598	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1029	1029	Florence Location	Florence	\N	41438 Osinski Lane	\N	Florence	\N	26561-6034	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.774759	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1032	1032	Villa Park Location	Villa Park	\N	32453 Denis Flats	\N	Villa Park	417	92285-4488	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.783361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1036	1036	San Bernardino Location	San Bernardino	\N	77944 Apartment 8-C	\N	San Bernardino	\N	27648-4324	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.798915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1038	1038	Covina Location	Covina	\N	58992 Gottlieb Islands	\N	Covina	447	05570-7855	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.804942	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1041	1041	North Little Rock Location	North Little Rock	\N	63061 Leilani Walks #147	\N	North Little Rock	465	42469-0004	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.813634	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1044	1044	Hidden Hills Location	Hidden Hills	\N	40796 Alessandra Ramp	\N	Hidden Hills	462	66504	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.821934	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1047	1047	Los Angeles Location	Los Angeles	\N	03703 Grant Inlet Suite 322	\N	Los Angeles	422	03213	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.829587	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1049	1049	San Clemente Location	San Clemente	\N	50772 Alexandre Trafficway	\N	San Clemente	446	78416-4855	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.83446	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1050	1050	Bellflower Location	Bellflower	\N	26903 Giles Pass Suite 651	\N	Bellflower	423	64070	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.837121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1052	1052	Hollywood Location	Hollywood	\N	46514 Marilou Estate Suite 653	\N	Hollywood	433	43461	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.851495	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1054	1054	Fairfield Location	Fairfield	\N	56133 Kaleb Circles	\N	Fairfield	462	31906-0496	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.856943	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1058	1058	Jonesboro Location	Jonesboro	\N	64621 Sawayn Flat	\N	Jonesboro	455	63518	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.867357	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1060	1060	Palmdale Location	Palmdale	\N	46312 Gusikowski Wall	\N	Palmdale	423	94394	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.872498	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1063	1063	Lynwood Location	Lynwood	\N	70945 Jamie Viaduct	\N	Lynwood	424	14225-4740	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.880303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1066	1066	Hawthorne Location	Hawthorne	\N	17416 Norbert Forges	\N	Hawthorne	\N	85196-6514	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.88794	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1068	1068	Huntington Beach Location	Huntington Beach	\N	28226 Kunze Island	\N	Huntington Beach	425	98941	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.906816	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1070	1070	Fresno Location	Fresno	\N	39701 Suite Q	\N	Fresno	421	38369-9076	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.915906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1073	1073	Atwater Location	Atwater	\N	71516 Kreiger Parkways	\N	Atwater	438	80585-2338	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.92689	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1076	1076	Texarkana Location	Texarkana	\N	23118 Jalon Roads	\N	Texarkana	\N	67862	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.936792	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1078	1078	San Juan Capistrano Location	San Juan Capistrano	\N	77402 Noemi Highway Apt. 324	\N	San Juan Capistrano	441	18511	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.941813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1081	1081	Thousand Oaks Location	Thousand Oaks	\N	05205 Cleta Trail	\N	Thousand Oaks	441	08359	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.949447	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1084	1084	Jonesboro Location	Jonesboro	\N	96327 Kenny Club	\N	Jonesboro	428	27766	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.957786	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1086	1086	Terre Haute Location	Terre Haute	\N	71712 Hirthe Ports	\N	Terre Haute	433	99414	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.971908	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1088	1088	Anaheim Location	Anaheim	\N	04482 Einar Square Apt. 783	\N	Anaheim	446	66833-0269	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.977133	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1091	1091	Chino Hills Location	Chino Hills	\N	38614 Katharina Well	\N	Chino Hills	420	85366	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.985459	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1094	1094	Anchorage Location	Anchorage	\N	71484 Carolina Inlet	\N	Anchorage	462	86867-2548	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.994025	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1096	1096	La Cañada Flintridge Location	La Cañada Flintridge	\N	86819 Floor 97	\N	La Cañada Flintridge	420	47064	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.999991	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1100	1100	Lakewood Location	Lakewood	\N	53146 Schiller Avenue #601	\N	Lakewood	426	41206	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.022099	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1102	1102	Laguna Woods Location	Laguna Woods	\N	79363 Treutel Land	\N	Laguna Woods	460	26997-8672	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.027961	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1104	1104	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	90008 Haven Haven Apt. 770	\N	Rancho Palos Verdes	436	07264	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.033878	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1107	1107	Redondo Beach Location	Redondo Beach	\N	54639 Kaela Row	\N	Redondo Beach	444	52800-4057	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.050638	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1110	1110	El Monte Location	El Monte	\N	97185 Huel Forge	\N	El Monte	440	30302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.065659	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1113	1113	West Lafayette Location	West Lafayette	\N	38118 Gibson Squares #132	\N	West Lafayette	464	41286-3995	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.079398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1115	1115	Kokomo Location	Kokomo	\N	06932 Amiya Walk #669	\N	Kokomo	460	90870	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.085114	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1117	1117	San Rafael Location	San Rafael	\N	58282 Luz Shore	\N	San Rafael	443	81081	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.107812	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1120	1120	Sunnyvale Location	Sunnyvale	\N	56956 Adolfo Lights	\N	Sunnyvale	457	34208-7070	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.124166	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1124	1124	Kent Location	Kent	\N	30409 Hackett Union	\N	Kent	423	98234	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.1479	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1127	1127	San Fernando Location	San Fernando	\N	07402 Jana Path #333	\N	San Fernando	427	12104-6999	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.162473	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1129	1129	South El Monte Location	South El Monte	\N	29793 Lobby	\N	South El Monte	\N	18275-3144	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.17882	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1133	1133	Hayward Location	Hayward	\N	90350 Wolff Fort #422	\N	Hayward	434	51086-9038	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.196321	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1135	1135	Mission Viejo Location	Mission Viejo	\N	32920 Augustus Club	\N	Mission Viejo	463	60779	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.208297	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1138	1138	Fairfield Location	Fairfield	\N	62325 Jadon Ways	\N	Fairfield	440	55768	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.226828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1139	1139	Lexington Location	Lexington	\N	91960 Adams Harbors Suite 561	\N	Lexington	423	08285	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.232231	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1142	1142	Glendale Location	Glendale	\N	55292 Fredrick Lakes Apt. 373	\N	Glendale	438	55412-8801	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.248854	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1145	1145	La Cañada Flintridge Location	La Cañada Flintridge	\N	13305 Fadel Summit Suite 717	\N	La Cañada Flintridge	462	43235	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.276488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1148	1148	Seward Location	Seward	\N	68403 Kozey Lane #905	\N	Seward	418	78211	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.286293	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1150	1150	Mission Viejo Location	Mission Viejo	\N	28674 Foster Square Suite 287	\N	Mission Viejo	451	36821-0761	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.292404	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1154	1154	Irvine Location	Irvine	\N	40514 Schowalter Viaduct	\N	Irvine	462	52553	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.304431	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1157	1157	Sahuarita Location	Sahuarita	\N	20231 Rice Views Suite 564	\N	Sahuarita	435	85186-7167	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.316556	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1160	1160	Elkhart Location	Elkhart	\N	81296 Nora Orchard Apt. 775	\N	Elkhart	421	53241-2212	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.325352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1164	1164	Tucson Location	Tucson	\N	38868 Cormier Ferry	\N	Tucson	434	18566-4990	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.335548	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1167	1167	Oxford Location	Oxford	\N	04028 Jewell Estates	\N	Oxford	412	70660	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.343346	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1170	1170	Alhambra Location	Alhambra	\N	92388 Room 3-I	\N	Alhambra	431	32841-1051	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.351203	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1173	1173	La Cañada Flintridge Location	La Cañada Flintridge	\N	72390 Gislason Divide	\N	La Cañada Flintridge	460	31589-5981	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.356339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1176	1176	Hammond Location	Hammond	\N	55126 Floor 72	\N	Hammond	433	30018-5633	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.364117	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1179	1179	Terre Haute Location	Terre Haute	\N	13676 Kautzer Hollow	\N	Terre Haute	442	08929-1199	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.372269	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1182	1182	Prescott Location	Prescott	\N	16181 Freida Coves	\N	Prescott	455	91454	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.380277	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1185	1185	Hayward Location	Hayward	\N	91759 Parker Lake #733	\N	Hayward	413	34341	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.388089	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1188	1188	San Fernando Location	San Fernando	\N	94749 Dach Mission Suite 983	\N	San Fernando	418	12745-8129	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.395917	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1190	1190	Oakland Location	Oakland	\N	01968 Stroman Place Apt. 587	\N	Oakland	\N	02650	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.401063	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1192	1192	Hawaiian Gardens Location	Hawaiian Gardens	\N	28894 Klein Forge #459	\N	Hawaiian Gardens	420	07862-5750	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.406087	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1195	1195	Texarkana Location	Texarkana	\N	60707 Davis Ford Apt. 864	\N	Texarkana	433	71299-8526	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.420813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1199	1199	Garden Grove Location	Garden Grove	\N	07547 Schultz Shoal #925	\N	Garden Grove	424	70177-0678	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.436831	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1201	1201	San Dimas Location	San Dimas	\N	91801 Building M	\N	San Dimas	438	67398	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.443882	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1204	1204	Sierra Vista Location	Sierra Vista	\N	00226 Fahey Shore	\N	Sierra Vista	438	97717	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.455824	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1206	1206	Texarkana Location	Texarkana	\N	69992 Monroe Cliffs Suite 628	\N	Texarkana	423	54494	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.463602	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1210	1210	Nenana Location	Nenana	\N	58120 Suite C	\N	Nenana	452	42829-8253	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.479819	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1213	1213	Scottsdale Location	Scottsdale	\N	15815 Ahmed Causeway Apt. 171	\N	Scottsdale	447	54655-9575	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.503611	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1215	1215	Agoura Hills Location	Agoura Hills	\N	15782 Ola Ramp	\N	Agoura Hills	449	51254-0140	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.514828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1218	1218	Chula Vista Location	Chula Vista	\N	83274 Hickle Shoal	\N	Chula Vista	420	59145-5862	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.528823	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1221	1221	Fontana Location	Fontana	\N	65492 Doyle Walk Suite 782	\N	Fontana	464	40458-9280	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.540826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1223	1223	Rancho Cordova Location	Rancho Cordova	\N	89439 Pier Z	\N	Rancho Cordova	461	15688	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.551813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1227	1227	Sierra Madre Location	Sierra Madre	\N	12384 Floor 18	\N	Sierra Madre	460	54356-7564	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.569826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1228	1228	Nenana Location	Nenana	\N	10178 Malcolm Islands Suite 218	\N	Nenana	461	44215-0949	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.573679	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1230	1230	San Juan Capistrano Location	San Juan Capistrano	\N	41550 Savanna Fields	\N	San Juan Capistrano	415	42657-3219	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.581834	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1233	1233	Ketchikan Location	Ketchikan	\N	33972 Rhett Islands Suite 259	\N	Ketchikan	\N	30486	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.593602	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1236	1236	Jeffersontown Location	Jeffersontown	\N	38263 Reynolds Course	\N	Jeffersontown	432	66749	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.60582	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1238	1238	Flagstaff Location	Flagstaff	\N	33647 Charles Spring	\N	Flagstaff	460	81733-1595	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.613599	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1241	1241	Lexington Location	Lexington	\N	17602 Floor 6831	\N	Lexington	454	48562-7679	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.629375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1244	1244	Rialto Location	Rialto	\N	35964 Geovanny Overpass Apt. 140	\N	Rialto	430	71750-1133	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.639519	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1247	1247	Bessemer Location	Bessemer	\N	36437 Parisian Plains	\N	Bessemer	420	20248-2233	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.647912	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1250	1250	Laguna Hills Location	Laguna Hills	\N	34947 Raynor Lodge Suite 641	\N	Laguna Hills	430	26408	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.656385	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1253	1253	Bakersfield Location	Bakersfield	\N	89451 Zackery Point	\N	Bakersfield	460	64478-2002	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.664552	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1256	1256	San Marino Location	San Marino	\N	12340 Schmeler Streets	\N	San Marino	424	00286	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.687324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1259	1259	Nome Location	Nome	\N	01371 Estrella Brook	\N	Nome	412	96468-8731	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.702959	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1262	1262	Glendale Location	Glendale	\N	27390 Kub Stravenue Apt. 903	\N	Glendale	\N	02566	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.710999	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1265	1265	Bakersfield Location	Bakersfield	\N	93119 Keith Mills	\N	Bakersfield	\N	53736	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.718359	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1267	1267	Santa Cruz Location	Santa Cruz	\N	65034 Heaney Shores Suite 325	\N	Santa Cruz	424	72272	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.723365	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1271	1271	Alhambra Location	Alhambra	\N	28115 Chadrick Row Suite 320	\N	Alhambra	465	97769	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.736529	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1273	1273	Arcadia Location	Arcadia	\N	07801 Lucius Square	\N	Arcadia	436	01091	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.748515	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1276	1276	Frankfort Location	Frankfort	\N	43842 Sarah Rue	\N	Frankfort	415	62906-0514	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.761435	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1279	1279	Santa Fe Springs Location	Santa Fe Springs	\N	03962 Hagenes Summit	\N	Santa Fe Springs	426	57822-4528	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.77952	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1282	1282	Forrest City Location	Forrest City	\N	33547 Thiel Views Suite 163	\N	Forrest City	421	51827-0232	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.789321	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1285	1285	Lexington Location	Lexington	\N	46553 Kemmer Trail #528	\N	Lexington	435	48793	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.804681	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1287	1287	San Mateo Location	San Mateo	\N	06329 Murphy Lakes	\N	San Mateo	456	51502-3197	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.812341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1290	1290	Prescott Location	Prescott	\N	89866 Oberbrunner Squares Apt. 702	\N	Prescott	455	52462	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.826594	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1292	1292	Roseville Location	Roseville	\N	19914 Rear	\N	Roseville	432	22362-4568	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.832174	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1295	1295	Mobile Location	Mobile	\N	06300 Jade Islands Suite 222	\N	Mobile	441	30294-1900	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.840667	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1299	1299	Valparaiso Location	Valparaiso	\N	68878 Kling Expressway	\N	Valparaiso	454	13691-9435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.852297	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1301	1301	San Dimas Location	San Dimas	\N	44122 Cortez Ville	\N	San Dimas	421	62912-2847	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.868917	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1304	1304	Moreno Valley Location	Moreno Valley	\N	54769 Jensen Junction	\N	Moreno Valley	457	06887	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.89336	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1306	1306	Rolling Hills Estates Location	Rolling Hills Estates	\N	06024 Opal Locks Apt. 769	\N	Rolling Hills Estates	428	44823-3482	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.912751	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1311	1311	Westminster Location	Westminster	\N	64051 Deckow Extensions #268	\N	Westminster	424	07086-8058	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.930139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1314	1314	Terre Haute Location	Terre Haute	\N	48071 Gaylord Burgs	\N	Terre Haute	440	97202-9290	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.938935	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1316	1316	Santa Clara Location	Santa Clara	\N	17858 Basement	\N	Santa Clara	455	61223-6461	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.94537	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1318	1318	Santa Clara Location	Santa Clara	\N	28514 Connelly Ways Apt. 258	\N	Santa Clara	459	08883	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.951168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1321	1321	Buena Park Location	Buena Park	\N	89859 Dane River	\N	Buena Park	456	30606	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.959969	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1324	1324	Montgomery Location	Montgomery	\N	32494 Stop 1-D	\N	Montgomery	462	32972-1337	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.968496	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1326	1326	Forrest City Location	Forrest City	\N	99530 Halle Greens Apt. 402	\N	Forrest City	438	72301-3161	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.974794	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1330	1330	Stanton Location	Stanton	\N	93574 Dare Fords Apt. 208	\N	Stanton	431	74946	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.986959	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1333	1333	San Marino Location	San Marino	\N	95895 Modesto Summit	\N	San Marino	\N	48166-8348	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.005433	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1335	1335	San Fernando Location	San Fernando	\N	38209 Cassie Inlet Apt. 554	\N	San Fernando	414	65435-2374	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.010874	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1338	1338	South Pasadena Location	South Pasadena	\N	55319 Shanahan Gardens	\N	South Pasadena	453	53625-2568	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.020514	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1342	1342	Palm Springs Location	Palm Springs	\N	19697 Beaulah Neck	\N	Palm Springs	432	83224	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.032673	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1344	1344	Manhattan Beach Location	Manhattan Beach	\N	73176 Janessa Views	\N	Manhattan Beach	434	17839-0561	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.038746	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1349	1349	Cincinnati Location	Cincinnati	\N	93541 Marina Cape	\N	Cincinnati	423	46437	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.066953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1352	1352	Santa Monica Location	Santa Monica	\N	50111 Zemlak Streets Apt. 503	\N	Santa Monica	462	03166-6650	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.078425	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1355	1355	Bakersfield Location	Bakersfield	\N	60776 Mavis Shoal	\N	Bakersfield	425	71873-8989	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.08624	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1358	1358	Fort Wayne Location	Fort Wayne	\N	23375 Lang Hill Apt. 151	\N	Fort Wayne	434	72026	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.094024	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1361	1361	South El Monte Location	South El Monte	\N	84036 Alvera Skyway Apt. 123	\N	South El Monte	428	76613	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.102028	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1364	1364	Juneau Location	Juneau	\N	50637 Oswaldo Spur	\N	Juneau	430	02313-0282	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.11037	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1367	1367	Covina Location	Covina	\N	39671 Terry Rue	\N	Covina	412	35385	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.118488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1370	1370	Lake Forest Location	Lake Forest	\N	60905 Ondricka Summit Suite 656	\N	Lake Forest	431	20237-9368	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.1265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1373	1373	Tuscaloosa Location	Tuscaloosa	\N	69896 Terrill Mount	\N	Tuscaloosa	421	28133-6927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.13453	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1376	1376	Lakewood Location	Lakewood	\N	47355 Veum Harbor #304	\N	Lakewood	\N	21239	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.142473	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1379	1379	Richmond Location	Richmond	\N	60154 Jenkins Extension Apt. 423	\N	Richmond	432	53343-8946	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.150393	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1382	1382	Duarte Location	Duarte	\N	73073 Kuphal Trafficway	\N	Duarte	450	23881-0096	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.159956	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1384	1384	Sierra Vista Location	Sierra Vista	\N	24459 Clementine Lodge Suite 540	\N	Sierra Vista	464	04806-4775	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.165279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1388	1388	Tucson Location	Tucson	\N	17062 Destiny Station Suite 928	\N	Tucson	444	53632	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.175782	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1392	1392	Baldwin Park Location	Baldwin Park	\N	79669 Mayer Court	\N	Baldwin Park	451	11329	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.186309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1395	1395	West Covina Location	West Covina	\N	96629 Russel Neck Suite 577	\N	West Covina	455	96329	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.194363	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1398	1398	Los Angeles Location	Los Angeles	\N	83339 Quentin Lake	\N	Los Angeles	\N	00940	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.218905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1401	1401	Huntsville Location	Huntsville	\N	78614 Avery Mission #354	\N	Huntsville	412	39058-2124	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.236951	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1402	1402	Gulf Shores Location	Gulf Shores	\N	94095 Ruthe Track	\N	Gulf Shores	443	21750	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.239578	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1403	1403	Fountain Valley Location	Fountain Valley	\N	78446 Rolfson Shore	\N	Fountain Valley	453	61219-8061	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.249075	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1405	1405	Kettering Location	Kettering	\N	09146 Jameson Spur #684	\N	Kettering	464	02791	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.258613	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1407	1407	Laguna Woods Location	Laguna Woods	\N	20062 June Heights	\N	Laguna Woods	438	26318	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.264156	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1410	1410	Richmond Location	Richmond	\N	14857 Cassin Passage	\N	Richmond	430	93298	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.274186	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1412	1412	Santa Fe Springs Location	Santa Fe Springs	\N	57644 Trever Union	\N	Santa Fe Springs	464	11181	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.279898	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1416	1416	Vernon Location	Vernon	\N	53471 Erick Branch #011	\N	Vernon	435	86399-3889	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.290016	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1419	1419	Phoenix Location	Phoenix	\N	30881 Front	\N	Phoenix	416	32366	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.297766	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1421	1421	Hayward Location	Hayward	\N	60248 Schneider Green Apt. 780	\N	Hayward	443	58757	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.302953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1423	1423	La Cañada Flintridge Location	La Cañada Flintridge	\N	47763 Clotilde Streets	\N	La Cañada Flintridge	459	11800	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.30825	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1427	1427	Bellflower Location	Bellflower	\N	56879 Schimmel Dale #486	\N	Bellflower	419	28342	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.32149	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1429	1429	Lomita Location	Lomita	\N	06695 Orland Hill #207	\N	Lomita	\N	65697-2947	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.326937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1432	1432	Sahuarita Location	Sahuarita	\N	20963 Dario Roads Apt. 730	\N	Sahuarita	461	65637-3186	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.334757	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1435	1435	Tucson Location	Tucson	\N	11420 Natasha Roads	\N	Tucson	436	83387	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.34265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1438	1438	Bowling Green Location	Bowling Green	\N	18977 Meghan Hill Apt. 883	\N	Bowling Green	436	04787	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.350488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1440	1440	Oro Valley Location	Oro Valley	\N	54700 Santino Overpass Suite 806	\N	Oro Valley	439	72953-4766	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.355968	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1443	1443	San Juan Capistrano Location	San Juan Capistrano	\N	71283 Tromp Field Apt. 397	\N	San Juan Capistrano	\N	99546-0556	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.363976	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1446	1446	Scottsdale Location	Scottsdale	\N	98023 Leanna Gateway	\N	Scottsdale	433	65526-8474	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.387512	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1449	1449	Gadsden Location	Gadsden	\N	26490 Theresia Stravenue	\N	Gadsden	437	58440	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.395269	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1452	1452	San Marino Location	San Marino	\N	92026 Lemke Plaza Suite 898	\N	San Marino	456	52707-6352	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.403196	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1454	1454	Laguna Hills Location	Laguna Hills	\N	86817 Annetta Rapids	\N	Laguna Hills	461	36204	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.408762	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1458	1458	Irvine Location	Irvine	\N	22219 Taurean Neck Apt. 752	\N	Irvine	426	12929	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.419707	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1460	1460	Downey Location	Downey	\N	01475 Maryam Estates	\N	Downey	460	13166-0572	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.429465	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1463	1463	Hollywood Location	Hollywood	\N	51503 Hand Plain Suite 802	\N	Hollywood	434	77767-7952	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.439952	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1466	1466	Atwater Location	Atwater	\N	64539 Jett Forges	\N	Atwater	414	30181	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.447915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1469	1469	Bentonville Location	Bentonville	\N	37863 Lyla Bridge	\N	Bentonville	463	03049	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.459759	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1472	1472	Louisville Location	Louisville	\N	69711 Willy Plain	\N	Louisville	412	93451-7427	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.471882	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1475	1475	Evansville Location	Evansville	\N	95236 Franz Hills	\N	Evansville	465	04301-5876	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.487472	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1477	1477	Lafayette Location	Lafayette	\N	63273 Basement	\N	Lafayette	452	20490	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.501948	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1480	1480	Athens Location	Athens	\N	32973 Harris Pike #064	\N	Athens	433	25758	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.510686	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1483	1483	Sierra Vista Location	Sierra Vista	\N	76261 Sydnee Rapid #484	\N	Sierra Vista	456	93730-1370	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.526213	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1487	1487	Brea Location	Brea	\N	58054 Trailer Q	\N	Brea	438	09723-9995	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.551266	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1489	1489	Zanesville Location	Zanesville	\N	33562 Breitenberg Circle Suite 298	\N	Zanesville	454	15049	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.556808	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1490	1490	Cerritos Location	Cerritos	\N	53400 Britney Cliff	\N	Cerritos	412	45792	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.559424	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1491	1491	Santa Clarita Location	Santa Clarita	\N	11348 Christ Turnpike	\N	Santa Clarita	459	44739-4803	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.572904	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1494	1494	City of Industry Location	City of Industry	\N	11593 Floor 67	\N	City of Industry	\N	79801-0849	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.58258	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1497	1497	Dayton Location	Dayton	\N	89535 Kohler Points Apt. 277	\N	Dayton	451	17736-0677	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.594852	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1499	1499	Prescott Location	Prescott	\N	13248 Kessler Squares #045	\N	Prescott	458	05172-9021	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.600869	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1502	1502	Barrow Location	Barrow	\N	17944 Kelvin Radial Suite 154	\N	Barrow	464	54144	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.622341	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1505	1505	Tempe Location	Tempe	\N	28462 Gillian Harbors	\N	Tempe	459	45749-5182	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.63708	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1508	1508	West Lafayette Location	West Lafayette	\N	15280 Burdette Hills	\N	West Lafayette	428	87720-6818	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.653199	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1511	1511	Citrus Heights Location	Citrus Heights	\N	51382 Howell Cliff Apt. 998	\N	Citrus Heights	426	09647-1123	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.676264	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1514	1514	Sunnyvale Location	Sunnyvale	\N	44856 McKenzie Creek	\N	Sunnyvale	413	10156	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.684918	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1517	1517	Nome Location	Nome	\N	39823 Hilll Mountains Apt. 560	\N	Nome	452	41677-3269	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.706437	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1520	1520	Texarkana Location	Texarkana	\N	37743 Blanda Crescent	\N	Texarkana	441	74897-7850	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.729	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1523	1523	Cypress Location	Cypress	\N	68201 Basement	\N	Cypress	433	55512	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.749383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1526	1526	Palo Alto Location	Palo Alto	\N	01691 Gerardo Fork Suite 585	\N	Palo Alto	453	63170	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.758245	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1529	1529	Anaheim Location	Anaheim	\N	30919 Pfannerstill Overpass #037	\N	Anaheim	419	56334-5487	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.776233	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1532	1532	Berkeley Location	Berkeley	\N	73928 Room E	\N	Berkeley	429	20547-7341	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.785711	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1535	1535	Fort Wayne Location	Fort Wayne	\N	20832 Brady Fields Suite 629	\N	Fort Wayne	420	97885-4466	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.801016	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1538	1538	Santa Fe Springs Location	Santa Fe Springs	\N	80417 Floor 3520	\N	Santa Fe Springs	449	46134	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.808677	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1541	1541	Bell Gardens Location	Bell Gardens	\N	00082 Lakin Ferry	\N	Bell Gardens	430	89011-2244	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.816563	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1544	1544	West Lafayette Location	West Lafayette	\N	94742 Ryan Centers Apt. 211	\N	West Lafayette	436	61576-1443	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.824254	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1547	1547	Indianapolis Location	Indianapolis	\N	57953 Sanford Mews	\N	Indianapolis	428	83591-7729	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.831856	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1550	1550	Decatur Location	Decatur	\N	48406 Floor 722	\N	Decatur	437	03729-7967	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.839709	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1553	1553	Fountain Valley Location	Fountain Valley	\N	72557 Hodkiewicz Stream	\N	Fountain Valley	436	00053-5277	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.847839	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1555	1555	Los Angeles Location	Los Angeles	\N	34066 McCullough Point Suite 658	\N	Los Angeles	426	85645	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.853181	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1558	1558	Forrest City Location	Forrest City	\N	87101 Jakubowski Drives	\N	Forrest City	446	46382-8277	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.860953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1562	1562	El Cerrito Location	El Cerrito	\N	28911 Gusikowski Divide	\N	El Cerrito	454	03658-0197	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.871118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1564	1564	Costa Mesa Location	Costa Mesa	\N	41423 Jacobs Springs	\N	Costa Mesa	433	87026	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.876212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1567	1567	Visalia Location	Visalia	\N	81622 Tromp Fields Apt. 275	\N	Visalia	444	31143-0527	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.888141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1570	1570	Pasadena Location	Pasadena	\N	52730 Ratke Forges	\N	Pasadena	437	65893-3793	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.896159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1572	1572	Bell Gardens Location	Bell Gardens	\N	51572 Sandrine Landing	\N	Bell Gardens	420	13597	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.901485	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1575	1575	Hamilton Location	Hamilton	\N	88982 Simonis Spur	\N	Hamilton	425	82548	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.909295	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1578	1578	Daly City Location	Daly City	\N	54271 Johnny Oval	\N	Daly City	461	90697	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.917198	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1579	1579	Fontana Location	Fontana	\N	30153 Borer Inlet	\N	Fontana	423	41171-3159	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.922525	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1582	1582	Calabasas Location	Calabasas	\N	31626 Kariane Station	\N	Calabasas	441	12270-3891	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.961042	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1584	1584	Springfield Location	Springfield	\N	98444 Demarco Isle Apt. 547	\N	Springfield	432	98948-3777	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.978132	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1586	1586	Lexington Location	Lexington	\N	36223 Eleanora Port	\N	Lexington	423	63873	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.99262	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1590	1590	Huntington Park Location	Huntington Park	\N	78621 Hettinger Manors #217	\N	Huntington Park	441	18523	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.004795	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1592	1592	Riverside Location	Riverside	\N	21361 Virginia Forges Apt. 238	\N	Riverside	439	01646	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.010778	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1595	1595	Chino Location	Chino	\N	16528 Irma Mills Apt. 258	\N	Chino	\N	47995-3259	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.020184	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1597	1597	Sutter Creek Location	Sutter Creek	\N	10665 Towne Mills	\N	Sutter Creek	438	63162-8590	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.032236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1600	1600	Roseville Location	Roseville	\N	72281 Lakin Key	\N	Roseville	430	90246-1373	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.040955	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1603	1603	Newport Beach Location	Newport Beach	\N	35402 Junius Extensions	\N	Newport Beach	\N	80200-1572	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.048872	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1607	1607	Huntington Park Location	Huntington Park	\N	94378 Stroman Ports	\N	Huntington Park	\N	75756	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.059231	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1610	1610	Fremont Location	Fremont	\N	81700 Sauer Plain Apt. 126	\N	Fremont	433	36625-3057	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.06699	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1612	1612	Cincinnati Location	Cincinnati	\N	96613 Murazik Vista	\N	Cincinnati	462	68867	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:13.072062	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1614	1614	La Habra Heights Location	La Habra Heights	\N	33879 Bartoletti Creek Suite 510	\N	La Habra Heights	454	89611	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.080067	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1618	1618	Baldwin Park Location	Baldwin Park	\N	58423 Maxwell Hill #763	\N	Baldwin Park	427	73895	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.091026	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1621	1621	Tucson Location	Tucson	\N	87079 Maya Lane Suite 227	\N	Tucson	418	91375	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.099062	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1623	1623	Dothan Location	Dothan	\N	62323 Wiegand Parks Suite 175	\N	Dothan	\N	36901-9672	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.104429	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1626	1626	Cypress Location	Cypress	\N	47070 Kohler Meadows	\N	Cypress	\N	02254	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.112315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1629	1629	Monterey Park Location	Monterey Park	\N	50073 Dach Extensions	\N	Monterey Park	465	08757-5073	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.12021	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1632	1632	Arcadia Location	Arcadia	\N	10002 Considine Loaf	\N	Arcadia	446	17931	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.144501	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1635	1635	Lakewood Location	Lakewood	\N	53879 Stop 6-F	\N	Lakewood	450	84684-5682	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.152346	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1638	1638	Elkhart Location	Elkhart	\N	72970 Suite V	\N	Elkhart	419	91029-3894	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.160049	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1640	1640	La Verne Location	La Verne	\N	51618 Schimmel Coves Suite 611	\N	La Verne	443	36479-7240	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.165336	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1644	1644	Westlake Village Location	Westlake Village	\N	60831 Wunsch Isle	\N	Westlake Village	449	17542	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.175578	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1646	1646	Hawaiian Gardens Location	Hawaiian Gardens	\N	48368 Floor 1438	\N	Hawaiian Gardens	448	93443	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.180876	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1650	1650	South Bend Location	South Bend	\N	16841 Glenna Highway	\N	South Bend	428	29408-2904	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.197049	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1652	1652	Valparaiso Location	Valparaiso	\N	06663 Melany Course	\N	Valparaiso	425	61742-0848	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.203059	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1655	1655	Cleveland Location	Cleveland	\N	14343 Upper	\N	Cleveland	460	86410-3295	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.222057	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1658	1658	Corona Location	Corona	\N	58407 Jocelyn Trace	\N	Corona	452	83067-0186	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.236706	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1661	1661	Artesia Location	Artesia	\N	80843 Bartell Mountain	\N	Artesia	446	72999	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.245473	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1663	1663	Tuscaloosa Location	Tuscaloosa	\N	14586 Roxanne Pike	\N	Tuscaloosa	423	83544-5703	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.266909	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1665	1665	Rancho Cucamonga Location	Rancho Cucamonga	\N	99595 Upper	\N	Rancho Cucamonga	460	26770	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.278948	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1667	1667	Sunnyvale Location	Sunnyvale	\N	67616 Office	\N	Sunnyvale	437	05217-6390	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.291042	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1670	1670	Corona Location	Corona	\N	45664 Kasandra Harbors	\N	Corona	447	18685	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.300814	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1672	1672	Monterey Park Location	Monterey Park	\N	85580 Madison Rapid	\N	Monterey Park	420	96056-5028	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.306426	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1674	1674	Hermosa Beach Location	Hermosa Beach	\N	03184 Renner Square Apt. 261	\N	Hermosa Beach	\N	08947	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.312058	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1678	1678	North Pole Location	North Pole	\N	82484 Sheldon Parkway Suite 911	\N	North Pole	452	70218	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.340017	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1681	1681	Dothan Location	Dothan	\N	01798 Marquardt Mall Suite 162	\N	Dothan	442	95436-5733	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.353952	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1684	1684	Bell Gardens Location	Bell Gardens	\N	30462 Dominique Roads	\N	Bell Gardens	442	96073	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.381137	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1687	1687	La Palma Location	La Palma	\N	21070 Abbott Parkway #430	\N	La Palma	442	59585-3927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.404504	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1690	1690	Gilbert Location	Gilbert	\N	93422 Orland Dam #789	\N	Gilbert	432	60743	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.429383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1694	1694	Irwindale Location	Irwindale	\N	72009 Osbaldo Skyway Apt. 147	\N	Irwindale	464	93897-5561	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.471198	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1696	1696	Lynwood Location	Lynwood	\N	57575 Orion Fields Apt. 885	\N	Lynwood	425	57574	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.489042	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1698	1698	Artesia Location	Artesia	\N	15311 Hazle Mountains	\N	Artesia	432	75869	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.497367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1701	1701	Nome Location	Nome	\N	82094 Shanon Station	\N	Nome	453	26068-6958	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.512922	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1703	1703	Santa Clarita Location	Santa Clarita	\N	88153 Eichmann Overpass	\N	Santa Clarita	435	96577	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.52522	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1706	1706	San Bernardino Location	San Bernardino	\N	74471 Kuhn Springs #210	\N	San Bernardino	446	90352	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.539918	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1708	1708	Bellflower Location	Bellflower	\N	96316 Lemuel Coves	\N	Bellflower	458	25139	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.546039	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1711	1711	Inglewood Location	Inglewood	\N	76458 McLaughlin Mountains	\N	Inglewood	430	19778-4541	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.561602	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1714	1714	San Dimas Location	San Dimas	\N	05255 Suite K	\N	San Dimas	424	45286-2576	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.570017	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1716	1716	Two Rivers Location	Two Rivers	\N	62990 Runolfsdottir Forges	\N	Two Rivers	413	22714-6783	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.576079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1719	1719	Jasper Location	Jasper	\N	83972 Sabryna Port	\N	Jasper	430	55318-9829	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.585664	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1722	1722	Commerce Location	Commerce	\N	48461 Kristoffer Point	\N	Commerce	431	45691-0565	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.594158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1724	1724	Pico Rivera Location	Pico Rivera	\N	99446 Carlotta Junctions #140	\N	Pico Rivera	419	42690-3499	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.600334	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1727	1727	Temecula Location	Temecula	\N	30052 Sydnie Shore Apt. 021	\N	Temecula	434	89083	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.613387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1730	1730	Forrest City Location	Forrest City	\N	12144 Steuber Turnpike Apt. 000	\N	Forrest City	415	63607	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.620946	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1733	1733	Paducah Location	Paducah	\N	92137 Yost Row Apt. 828	\N	Paducah	419	89297-3265	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.628351	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1736	1736	Troy Location	Troy	\N	96090 Schaden Extension	\N	Troy	419	27988	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.636072	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1740	1740	Vincennes Location	Vincennes	\N	08170 Department R	\N	Vincennes	464	38925-2833	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.646039	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1742	1742	Fremont Location	Fremont	\N	28731 Ebert Turnpike	\N	Fremont	\N	04145	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.651418	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1745	1745	Sacramento Location	Sacramento	\N	50720 Cecil Mountain Apt. 936	\N	Sacramento	459	68330-1260	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.658977	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1748	1748	Hollywood Location	Hollywood	\N	47551 Roberts Overpass Apt. 389	\N	Hollywood	\N	29495-2318	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.666512	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1751	1751	Costa Mesa Location	Costa Mesa	\N	49399 Alycia Forks	\N	Costa Mesa	447	19894	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.67402	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1753	1753	San Clemente Location	San Clemente	\N	58539 Floor 757	\N	San Clemente	436	96763-4844	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.679043	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1754	1754	Riverside Location	Riverside	\N	16973 Pier F	\N	Riverside	428	98358	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.68159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1756	1756	Nogales Location	Nogales	\N	46899 Rolfson Vista	\N	Nogales	416	90946	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.688357	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1759	1759	Whittier Location	Whittier	\N	76511 Reinger Expressway Apt. 848	\N	Whittier	451	97516	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.696062	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1762	1762	Hammond Location	Hammond	\N	01113 Hirthe View Suite 039	\N	Hammond	461	38565	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.703839	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1765	1765	Fullerton Location	Fullerton	\N	75298 Lavon Plains Suite 886	\N	Fullerton	420	14919	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.711888	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1768	1768	Michigan City Location	Michigan City	\N	51832 Torphy Ridges Apt. 046	\N	Michigan City	447	87629	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.719622	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1770	1770	Santa Clara Location	Santa Clara	\N	16872 Elaina Courts #662	\N	Santa Clara	432	25059	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.724793	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1773	1773	Murrieta Location	Murrieta	\N	21007 Gleason Courts	\N	Murrieta	455	76738-2244	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.751024	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1776	1776	La Verne Location	La Verne	\N	97440 Rosendo Squares	\N	La Verne	464	02415-7329	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.759991	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1778	1778	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	75740 Hilpert Dam	\N	Rancho Santa Margarita	426	00549	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.772147	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1783	1783	Torrance Location	Torrance	\N	80191 Lowe Cliff	\N	Torrance	429	67637	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.790232	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1786	1786	Vincennes Location	Vincennes	\N	80774 Baby Ranch Suite 780	\N	Vincennes	425	79777	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.798938	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1788	1788	Salinas Location	Salinas	\N	29702 Bogisich Estate #927	\N	Salinas	450	85343	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.804961	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1791	1791	Gary Location	Gary	\N	01091 Shanon Run	\N	Gary	463	69317	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.826526	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1794	1794	Oro Valley Location	Oro Valley	\N	03155 Lot 2-C	\N	Oro Valley	429	35269	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.833999	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1798	1798	Bowling Green Location	Bowling Green	\N	11744 Hodkiewicz Mountain	\N	Bowling Green	428	88298-2039	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.84158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1800	1800	Gilbert Location	Gilbert	\N	08371 Office	\N	Gilbert	425	47169-1529	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.846624	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1803	1803	Dana Point Location	Dana Point	\N	84360 Deondre Squares	\N	Dana Point	449	75635-9867	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.854236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1807	1807	Sahuarita Location	Sahuarita	\N	34554 Stop M	\N	Sahuarita	465	64515	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.86732	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1810	1810	San Diego Location	San Diego	\N	12339 Floor 61	\N	San Diego	425	56312-0791	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.875006	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1812	1812	Redding Location	Redding	\N	27343 Wiegand Plaza #348	\N	Redding	450	63816	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.880076	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1814	1814	Paramount Location	Paramount	\N	00259 Henri Club	\N	Paramount	448	40226-5629	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.885179	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1818	1818	Bellflower Location	Bellflower	\N	25080 Claudia Path #899	\N	Bellflower	437	21626	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.895417	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1820	1820	San Juan Capistrano Location	San Juan Capistrano	\N	50549 Skiles Coves Suite 705	\N	San Juan Capistrano	418	86184-9730	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.900583	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1824	1824	Hope Location	Hope	\N	50542 Marquardt Radial	\N	Hope	457	34864-8382	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.950482	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1826	1826	West Hollywood Location	West Hollywood	\N	21740 Mraz Field #080	\N	West Hollywood	\N	83546-0242	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:14.020571	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1830	1830	Hammond Location	Hammond	\N	01541 Wiza Fork Apt. 710	\N	Hammond	453	72601-2355	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:14.271261	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1833	1833	South Bend Location	South Bend	\N	87402 Lot 96-D	\N	South Bend	462	23583-4401	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:14.818279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1835	1835	Florence Location	Florence	\N	83448 Weber Greens Apt. 078	\N	Florence	436	09984	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.398046	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1837	1837	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	21238 Herman Summit	\N	Rancho Santa Margarita	\N	76732-2767	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.439016	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1841	1841	Chino Location	Chino	\N	86662 Department I	\N	Chino	427	43897-7148	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.488792	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1842	1842	Barrow Location	Barrow	\N	32303 Aida Mountains	\N	Barrow	437	11803-3941	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.494849	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1845	1845	Pasadena Location	Pasadena	\N	56863 Evan Field Suite 385	\N	Pasadena	435	84120-8808	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.508051	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1848	1848	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	71364 Floor 4	\N	Rancho Palos Verdes	452	35233	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.526063	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1851	1851	Toledo Location	Toledo	\N	57271 Carter View	\N	Toledo	\N	10334	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.594309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1854	1854	Hawaiian Gardens Location	Hawaiian Gardens	\N	99757 Lobby	\N	Hawaiian Gardens	458	42595-1155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.627361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1856	1856	Bessemer Location	Bessemer	\N	02413 Floor 34	\N	Bessemer	439	26334-3974	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.651417	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1859	1859	Irvine Location	Irvine	\N	49694 Vivianne Loop	\N	Irvine	425	49935	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.675531	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1862	1862	San Juan Capistrano Location	San Juan Capistrano	\N	44357 Murray Pass Apt. 626	\N	San Juan Capistrano	438	06919-5929	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.753845	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1865	1865	Scottsdale Location	Scottsdale	\N	94127 Sydni Overpass	\N	Scottsdale	\N	08750-9357	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.872656	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1868	1868	Montgomery Location	Montgomery	\N	83695 Huels Dam #490	\N	Montgomery	464	78543-7354	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.949661	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1870	1870	Daly City Location	Daly City	\N	28361 Destinee Locks Apt. 494	\N	Daly City	458	05550-1589	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.966541	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1873	1873	Santa Barbara Location	Santa Barbara	\N	55472 Cheyenne Summit	\N	Santa Barbara	462	27914	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.982032	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1876	1876	Westlake Village Location	Westlake Village	\N	78603 Mohr Bypass	\N	Westlake Village	446	54330-0058	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:15.996662	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1880	1880	Bell Gardens Location	Bell Gardens	\N	52899 Hickle Crescent Suite 029	\N	Bell Gardens	431	62263	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.017735	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1883	1883	Oxnard Location	Oxnard	\N	36404 Eunice Garden	\N	Oxnard	451	61085	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.077111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1885	1885	Vincennes Location	Vincennes	\N	51386 Building 25-A	\N	Vincennes	\N	45623	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.09572	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1888	1888	North Little Rock Location	North Little Rock	\N	88031 Space K	\N	North Little Rock	452	01457	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.107955	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1890	1890	Chico Location	Chico	\N	87136 Trailer M	\N	Chico	456	33996	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.122049	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1893	1893	Moraga Location	Moraga	\N	10930 Velda Viaduct	\N	Moraga	412	32873	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.13754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1895	1895	San Clemente Location	San Clemente	\N	18398 Julien Burgs #211	\N	San Clemente	438	33070-9348	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.14631	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1898	1898	Richmond Location	Richmond	\N	25357 Marquis Cliff	\N	Richmond	415	67636-9380	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.164852	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1901	1901	City of Industry Location	City of Industry	\N	07935 Alana Overpass	\N	City of Industry	460	80726-4908	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.288073	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1904	1904	La Palma Location	La Palma	\N	54879 Floor 04	\N	La Palma	425	77498-3080	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.301386	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1907	1907	Atwater Location	Atwater	\N	76026 Schultz Locks	\N	Atwater	450	76656-7138	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.4126	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1910	1910	Apple Valley Location	Apple Valley	\N	28272 Katelyn Corners	\N	Apple Valley	456	52634	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.47813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1913	1913	Cerritos Location	Cerritos	\N	64643 Johnson Key	\N	Cerritos	454	16601-3885	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.543365	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1916	1916	Santa Monica Location	Santa Monica	\N	29691 Bashirian Fords Suite 714	\N	Santa Monica	448	76392-2334	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.607697	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1919	1919	Tok Location	Tok	\N	31295 Dooley Row #071	\N	Tok	454	71849-3110	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.783829	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1921	1921	Birmingham Location	Birmingham	\N	65361 Vernice Glen	\N	Birmingham	417	48872-7239	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.789798	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1924	1924	Seal Beach Location	Seal Beach	\N	60752 Gerardo Grove Apt. 043	\N	Seal Beach	439	55204-5684	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.851371	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1927	1927	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	61115 Alisa Mission	\N	Rancho Palos Verdes	427	01282	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.85982	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1928	1928	Santa Fe Springs Location	Santa Fe Springs	\N	27144 Jones Forks	\N	Santa Fe Springs	425	72343-0564	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.862671	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1929	1929	Rancho Cucamonga Location	Rancho Cucamonga	\N	39035 Gage Garden	\N	Rancho Cucamonga	462	69403-1790	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.865666	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1932	1932	Fountain Valley Location	Fountain Valley	\N	94592 Floor 287	\N	Fountain Valley	465	57516-3141	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.936242	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1935	1935	Sierra Madre Location	Sierra Madre	\N	09282 Stanton Rue	\N	Sierra Madre	459	90123	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.944505	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1938	1938	Auburn Location	Auburn	\N	25908 Jerde Lights Suite 355	\N	Auburn	\N	14259	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:16.95278	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1941	1941	Laguna Hills Location	Laguna Hills	\N	86152 VonRueden Burg	\N	Laguna Hills	431	17462	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.071859	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1944	1944	Murray Location	Murray	\N	17167 Breitenberg Groves	\N	Murray	432	43572	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.083716	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1947	1947	Kent Location	Kent	\N	43420 Rickie Falls	\N	Kent	437	93119-4317	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.157764	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1950	1950	Concord Location	Concord	\N	72586 Burdette Roads	\N	Concord	\N	70321-5810	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.180712	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1953	1953	Covington Location	Covington	\N	86055 Tiana Ville	\N	Covington	434	21826-8545	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.19273	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1956	1956	Hawaiian Gardens Location	Hawaiian Gardens	\N	47944 Side	\N	Hawaiian Gardens	446	00877-9943	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.202027	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1958	1958	Steubenville Location	Steubenville	\N	14846 Marcelo Spur	\N	Steubenville	426	49501	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.207365	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1961	1961	Sahuarita Location	Sahuarita	\N	83612 Lobby	\N	Sahuarita	412	95487	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.24272	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1964	1964	Bellflower Location	Bellflower	\N	51747 Nienow Shoal #783	\N	Bellflower	446	94561-0670	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.361905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1967	1967	Kent Location	Kent	\N	86811 Corine Mountain	\N	Kent	412	35265	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.681526	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1970	1970	Oro Valley Location	Oro Valley	\N	63756 Stamm Glen Apt. 300	\N	Oro Valley	451	84279-5861	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:17.926884	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1972	1972	Gary Location	Gary	\N	44839 Carey Plaza #101	\N	Gary	462	57648-7052	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.261052	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1975	1975	Merced Location	Merced	\N	34761 Building 5-A	\N	Merced	415	45372-7633	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.455925	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1978	1978	Monrovia Location	Monrovia	\N	40654 Schroeder Rapids Suite 754	\N	Monrovia	433	77563-6594	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.511432	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1980	1980	Sitka Location	Sitka	\N	90296 Monahan Street Apt. 556	\N	Sitka	416	68881-5571	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.579691	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1983	1983	Irwindale Location	Irwindale	\N	51822 Keebler View	\N	Irwindale	428	60993-0407	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:18.589386	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1986	1986	Citrus Heights Location	Citrus Heights	\N	36593 Jazlyn Curve	\N	Citrus Heights	435	12514-6614	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:18.594948	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1989	1989	Orange Location	Orange	\N	29527 Heaney Rest Apt. 828	\N	Orange	417	02905-0655	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.603489	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1993	1993	Pasadena Location	Pasadena	\N	25405 David Lodge Suite 929	\N	Pasadena	428	65880-1958	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:18.614513	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1995	1995	Salinas Location	Salinas	\N	92719 Dorthy Meadow Apt. 333	\N	Salinas	415	12456-8038	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.659936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1998	1998	North Little Rock Location	North Little Rock	\N	44289 Auer View	\N	North Little Rock	427	12851-7150	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.668866	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2000	2000	Rosemead Location	Rosemead	\N	79957 Side	\N	Rosemead	422	83514	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:18.674279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2003	2003	Stanton Location	Stanton	\N	81664 Carroll Track Apt. 489	\N	Stanton	459	63083-1582	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.707221	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2006	2006	Decatur Location	Decatur	\N	38121 Rear	\N	Decatur	463	18188	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.780373	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2009	2009	Huntington Park Location	Huntington Park	\N	54752 Veronica Road	\N	Huntington Park	436	89259	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.788322	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2011	2011	Atwater Location	Atwater	\N	62163 Edmond Junctions	\N	Atwater	\N	81913-8117	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.793893	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2014	2014	Tuscaloosa Location	Tuscaloosa	\N	29362 Gerhold Summit Apt. 341	\N	Tuscaloosa	413	46308	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.829826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2017	2017	Palos Verdes Estates Location	Palos Verdes Estates	\N	51788 Bruen Light Apt. 467	\N	Palos Verdes Estates	445	81271-8313	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.850662	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2018	2018	Richmond Location	Richmond	\N	28467 Fay Causeway	\N	Richmond	426	86458-6646	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.853608	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2019	2019	Redding Location	Redding	\N	69164 Schuster Summit #622	\N	Redding	458	43149	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.868811	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2021	2021	Ashland Location	Ashland	\N	01059 Mills Walks #598	\N	Ashland	412	07191	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:18.98022	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2023	2023	Los Angeles Location	Los Angeles	\N	98294 Nikolas Place Apt. 052	\N	Los Angeles	420	12888-5398	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.046413	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2027	2027	Monrovia Location	Monrovia	\N	02553 Wayne Cove	\N	Monrovia	435	96120	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.085048	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2029	2029	Bell Gardens Location	Bell Gardens	\N	26301 Ava Street	\N	Bell Gardens	431	39301-8527	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.091794	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2031	2031	Carson Location	Carson	\N	55039 Lillie Key	\N	Carson	413	94091-3948	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.103228	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2032	2032	Homer Location	Homer	\N	13848 Upper	\N	Homer	450	64035	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.106084	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2035	2035	Phoenix Location	Phoenix	\N	41713 Wilfrid Courts	\N	Phoenix	413	28142	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.115316	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2037	2037	Inglewood Location	Inglewood	\N	88597 Casimir Keys	\N	Inglewood	449	07958-8622	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.12139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2039	2039	Sacramento Location	Sacramento	\N	94596 Ansel Knoll Apt. 391	\N	Sacramento	416	90103-0521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.128028	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2040	2040	Monterey Park Location	Monterey Park	\N	11900 Heaney Ways	\N	Monterey Park	425	95338	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.130667	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2043	2043	Fullerton Location	Fullerton	\N	32612 Kirlin Lodge #295	\N	Fullerton	441	08687-1405	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.234096	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2045	2045	Rancho Santa Margarita Location	Rancho Santa Margarita	\N	72669 Annabell Unions	\N	Rancho Santa Margarita	425	95823	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.298673	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2047	2047	Santa Barbara Location	Santa Barbara	\N	75151 Natasha Skyway	\N	Santa Barbara	438	69197-9121	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.363217	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2050	2050	Placentia Location	Placentia	\N	84471 Cordie Unions	\N	Placentia	457	03427	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.381223	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2054	2054	Mobile Location	Mobile	\N	75126 Lower	\N	Mobile	419	10527-5078	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.510339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2056	2056	La Mirada Location	La Mirada	\N	88361 Side	\N	La Mirada	449	79092-8474	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.542979	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2060	2060	Bentonville Location	Bentonville	\N	71557 Dorothy Inlet	\N	Bentonville	\N	33347	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.579124	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2073	2073	Redondo Beach Location	Redondo Beach	\N	59186 Corwin Oval	\N	Redondo Beach	453	34892-2471	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.632555	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2246	2246	Hawaiian Gardens Location	Hawaiian Gardens	\N	21254 Langworth Run #097	\N	Hawaiian Gardens	415	63303	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.650577	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2285	2285	Buena Park Location	Buena Park	\N	16333 DuBuque Valley Suite 411	\N	Buena Park	429	45872-4527	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.674663	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2445	2445	Rohnert Park Location	Rohnert Park	\N	58527 Nedra Loop	\N	Rohnert Park	422	80581	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.698754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2578	2578	Diamond Bar Location	Diamond Bar	\N	21408 Earl Trail #924	\N	Diamond Bar	\N	58660-7327	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.741271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2629	2629	Sahuarita Location	Sahuarita	\N	65745 Morar Mission	\N	Sahuarita	415	28398-4872	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.82496	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2631	2631	Montgomery Location	Montgomery	\N	50862 Rashawn Oval Suite 793	\N	Montgomery	437	64910-7511	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.83049	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2634	2634	Laguna Niguel Location	Laguna Niguel	\N	58862 Penthouse	\N	Laguna Niguel	447	77283	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.839131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2636	2636	Marana Location	Marana	\N	08460 Wintheiser Locks	\N	Marana	414	88269	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.844732	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2639	2639	Ketchikan Location	Ketchikan	\N	42244 Bartoletti Rapid #882	\N	Ketchikan	426	70776	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.853109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2642	2642	Baldwin Park Location	Baldwin Park	\N	50168 Viviane Greens	\N	Baldwin Park	440	26628-7276	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.939141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2645	2645	Dayton Location	Dayton	\N	42437 Jovany Passage Suite 007	\N	Dayton	458	05495-8027	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.028992	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2648	2648	North Little Rock Location	North Little Rock	\N	34648 Hoeger Mews	\N	North Little Rock	465	07880	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.083141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2652	2652	Santa Rosa Location	Santa Rosa	\N	22180 Conner Lodge Suite 159	\N	Santa Rosa	454	71570	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.115816	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2656	2656	Vincennes Location	Vincennes	\N	73015 Damion Lodge Apt. 970	\N	Vincennes	463	81020	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.164142	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2658	2658	San Fernando Location	San Fernando	\N	41134 Elinore Springs Apt. 896	\N	San Fernando	427	66637	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.173388	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2661	2661	Indio Location	Indio	\N	77674 Hartmann Dam #434	\N	Indio	463	89863-1462	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.224807	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2663	2663	San Rafael Location	San Rafael	\N	21066 Schimmel Springs	\N	San Rafael	455	81928-7484	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.234003	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2665	2665	Rancho Cordova Location	Rancho Cordova	\N	26004 Arvel Cove Suite 274	\N	Rancho Cordova	432	86124	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.23936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2669	2669	Columbus Location	Columbus	\N	90114 Stark Crescent	\N	Columbus	446	20335	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.250291	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2672	2672	Muncie Location	Muncie	\N	21161 Abbott Wall #668	\N	Muncie	413	18394	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.274606	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2676	2676	Westminster Location	Westminster	\N	08473 Building 20-H	\N	Westminster	414	75045-5899	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.300165	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2732	2732	Palos Verdes Estates Location	Palos Verdes Estates	\N	77494 Building H	\N	Palos Verdes Estates	424	51481	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.567925	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2734	2734	Union City Location	Union City	\N	29052 Feest Turnpike Apt. 232	\N	Union City	459	94745-2808	\N	\N	\N	\N	5	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:20.573286	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
14	14	Yorba Linda Location	Yorba Linda	\N	79052 Carter Street	\N	Yorba Linda	446	75409-5367	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.622429	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
55	55	Nome Location	Nome	\N	95884 Apartment Q	\N	Nome	\N	05008	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.785533	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
56	56	Murrieta Location	Murrieta	\N	26731 Dibbert Fords Apt. 992	\N	Murrieta	463	41433-9670	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.792503	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
57	57	San Luis Obispo Location	San Luis Obispo	\N	34729 Vladimir Point Apt. 051	\N	San Luis Obispo	461	26173-5897	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.795372	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
58	58	Two Rivers Location	Two Rivers	\N	31241 Bernhard Drive	\N	Two Rivers	460	38791	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.804567	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
59	59	Cypress Location	Cypress	\N	40535 Von Turnpike #812	\N	Cypress	412	80487-0290	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.807418	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
60	60	Modesto Location	Modesto	\N	14406 Trailer 1-D	\N	Modesto	454	12111-8633	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.816606	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
61	61	Paducah Location	Paducah	\N	56220 Marks Junction #989	\N	Paducah	428	80254-7447	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.8227	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
62	62	Baldwin Park Location	Baldwin Park	\N	36998 Cicero Orchard #241	\N	Baldwin Park	445	84326	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.830829	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
439	439	Anaheim Location	Anaheim	\N	75880 Berenice Summit #614	\N	Anaheim	462	64409	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.365742	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
63	63	Lakewood Location	Lakewood	\N	36882 Slip 14-I	\N	Lakewood	450	35464	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.840515	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
64	64	Phoenix Location	Phoenix	\N	49718 Conroy Expressway	\N	Phoenix	451	28852-5026	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.843615	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
65	65	San Rafael Location	San Rafael	\N	02098 Tia Pines	\N	San Rafael	429	49197-8573	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.846256	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
679	679	Cudahy Location	Cudahy	\N	99811 Floor 627	\N	Cudahy	430	37431	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.328356	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
66	66	Oakland Location	Oakland	\N	37614 Beau Plaza	\N	Oakland	449	37183-8852	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.848916	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
821	821	Gulf Shores Location	Gulf Shores	\N	92598 Lot 437	\N	Gulf Shores	417	31313-2237	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.858223	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
868	868	Hollywood Location	Hollywood	\N	53526 Wyman Dale	\N	Hollywood	460	71594	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.022471	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
891	891	Juneau Location	Juneau	\N	37467 Georgiana Greens #391	\N	Juneau	\N	18757	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.098013	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
960	960	Covina Location	Covina	\N	82451 Jarvis Curve	\N	Covina	427	45408-2768	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.463838	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
67	67	Kent Location	Kent	\N	30013 Tristian Pass Apt. 130	\N	Kent	438	89575	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.851463	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
68	68	Citrus Heights Location	Citrus Heights	\N	28186 Jake Corner	\N	Citrus Heights	428	02155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.85415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
69	69	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	32849 Pedro Hills	\N	Mentor-on-the-Lake	460	88860	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.856741	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
70	70	Ketchikan Location	Ketchikan	\N	01679 Neal Gardens Suite 346	\N	Ketchikan	433	42949-2119	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.859369	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
71	71	South Bend Location	South Bend	\N	47066 Lesly Roads Suite 020	\N	South Bend	454	40216-6050	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.861991	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
72	72	Lawndale Location	Lawndale	\N	25826 Pier 4-I	\N	Lawndale	437	52166-8182	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.864689	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
73	73	Hawthorne Location	Hawthorne	\N	34069 Yost Parks Apt. 535	\N	Hawthorne	423	68928-9994	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.867327	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
74	74	North Little Rock Location	North Little Rock	\N	01631 Runte Road	\N	North Little Rock	413	76488	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.869941	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1346	1346	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	95868 Aiden Lodge Apt. 647	\N	Mentor-on-the-Lake	453	93197	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.050804	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
75	75	Salinas Location	Salinas	\N	93383 Kirlin Alley #428	\N	Salinas	436	70713-2206	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.872618	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
76	76	Laguna Niguel Location	Laguna Niguel	\N	64810 Art Locks Suite 361	\N	Laguna Niguel	462	11858-3104	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.875407	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
77	77	San Clemente Location	San Clemente	\N	57009 Tia Streets	\N	San Clemente	441	13895	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.878128	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
78	78	San Mateo Location	San Mateo	\N	33170 VonRueden Station Apt. 659	\N	San Mateo	428	79048-8661	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.88082	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
79	79	Thousand Oaks Location	Thousand Oaks	\N	67723 Nitzsche Brook #964	\N	Thousand Oaks	436	85585-2928	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.883513	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
80	80	Cudahy Location	Cudahy	\N	63825 Collins Tunnel #456	\N	Cudahy	446	07959	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.886143	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1731	1731	West Covina Location	West Covina	\N	97758 Floor 33	\N	West Covina	452	07230	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:13.623466	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
81	81	Huntington Park Location	Huntington Park	\N	86940 Conn Pass #276	\N	Huntington Park	456	04937-2055	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.888797	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
51	51	Santa Monica Location	Santa Monica	\N	15389 Zion Common	\N	Santa Monica	460	71038	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.762339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
52	52	Rancho Palos Verdes Location	Rancho Palos Verdes	\N	22580 Alicia Spring #004	\N	Rancho Palos Verdes	453	89055	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.768385	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
53	53	Lakewood Location	Lakewood	\N	73090 Pete Pine #467	\N	Lakewood	\N	21696-3913	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.774463	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
54	54	Youngstown Location	Youngstown	\N	13815 Reichel Circles	\N	Youngstown	433	42083	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.78268	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1	1	El Cerrito Location	El Cerrito	\N	43653 Gislason Alley Suite 676	\N	El Cerrito	455	16200-2922	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.462953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	2	Vernon Location	Vernon	\N	63448 Connelly Flat Suite 385	\N	Vernon	441	10194	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.56504	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
3	3	San Marino Location	San Marino	\N	69768 Alene Camp Suite 108	\N	San Marino	\N	82649	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.570247	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
4	4	Modesto Location	Modesto	\N	17927 Nikolas Dale #938	\N	Modesto	462	22413	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.583121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
5	5	Eufaula Location	Eufaula	\N	27293 Grant Curve #905	\N	Eufaula	\N	00432	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.586417	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
6	6	Villa Park Location	Villa Park	\N	59796 Maximillia Turnpike	\N	Villa Park	438	03841-0244	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.594065	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
7	7	Tuscaloosa Location	Tuscaloosa	\N	71984 Mikayla Street	\N	Tuscaloosa	420	51863-9200	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.601048	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
8	8	Middletown Location	Middletown	\N	11068 Harber Mission	\N	Middletown	456	82179-1268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.606162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
9	9	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	99426 Crooks Course Suite 715	\N	Mentor-on-the-Lake	427	71435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.60899	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
10	10	Canton Location	Canton	\N	83014 Yessenia Isle	\N	Canton	\N	37503-4407	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.611803	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
11	11	Rolling Hills Location	Rolling Hills	\N	01623 Bartell Locks Suite 210	\N	Rolling Hills	436	69267	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.61435	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
12	12	Ventura Location	Ventura	\N	01742 O'Conner Walks	\N	Ventura	432	90155-4942	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.617158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
13	13	Vallejo Location	Vallejo	\N	27123 Weimann Village	\N	Vallejo	428	10927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.619872	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
15	15	Fremont Location	Fremont	\N	28540 Trailer 21-D	\N	Fremont	458	44481-0302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.625233	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
16	16	Jasper Location	Jasper	\N	15705 Glennie Meadow #591	\N	Jasper	425	11823-3636	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.628036	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
17	17	Gulf Shores Location	Gulf Shores	\N	44723 Green Prairie Apt. 011	\N	Gulf Shores	\N	61286-3866	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.630604	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
18	18	Villa Park Location	Villa Park	\N	96659 Enrique Rapid	\N	Villa Park	436	93028	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.633193	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
19	19	Thousand Oaks Location	Thousand Oaks	\N	10217 Weissnat Prairie	\N	Thousand Oaks	447	14783-3761	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.643123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
20	20	Union City Location	Union City	\N	15518 Michael Roads	\N	Union City	463	88950	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.655559	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
21	21	Santa Ana Location	Santa Ana	\N	22223 Floy Isle	\N	Santa Ana	459	21753	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.658226	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
22	22	Fremont Location	Fremont	\N	57109 Ward Port	\N	Fremont	415	65598-3943	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.660888	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
23	23	Murrieta Location	Murrieta	\N	71885 Kihn Mount	\N	Murrieta	433	49013	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.663444	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
24	24	Hollister Location	Hollister	\N	99992 Kayli Inlet #415	\N	Hollister	444	14887-0210	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.666208	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
25	25	Fayetteville Location	Fayetteville	\N	03180 Adalberto Tunnel #142	\N	Fayetteville	449	68763	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.668802	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
26	26	San Dimas Location	San Dimas	\N	55216 Celine Forges Suite 895	\N	San Dimas	445	79354-6678	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.671453	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
27	27	Glendale Location	Glendale	\N	61573 Alexys Walks Suite 100	\N	Glendale	448	24644-3299	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.67413	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
28	28	San Bernardino Location	San Bernardino	\N	54698 Clinton Fort Suite 094	\N	San Bernardino	428	88563	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.676843	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
29	29	Springdale Location	Springdale	\N	81289 Basement	\N	Springdale	461	78270-8604	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.67976	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
30	30	Vernon Location	Vernon	\N	07160 Odessa Burgs	\N	Vernon	422	42753-2692	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.684548	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
31	31	Tok Location	Tok	\N	67791 Mayert Rest	\N	Tok	435	06236	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.687215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
32	32	Santa Monica Location	Santa Monica	\N	76267 Lexi Hills	\N	Santa Monica	461	55013	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.689935	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
33	33	Bessemer Location	Bessemer	\N	86500 Emerson Vista	\N	Bessemer	430	16508	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.692844	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
34	34	Santa Barbara Location	Santa Barbara	\N	55449 Jamey Light	\N	Santa Barbara	426	27653-2737	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.695546	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
35	35	Delta Junction Location	Delta Junction	\N	69181 Earnestine Circles	\N	Delta Junction	429	22184-1396	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.698784	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
36	36	Pomona Location	Pomona	\N	65499 Johnson Branch Apt. 322	\N	Pomona	442	45666-5166	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.701523	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
37	37	Two Rivers Location	Two Rivers	\N	79688 Quitzon Overpass	\N	Two Rivers	432	82815-8497	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.705068	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
38	38	San Rafael Location	San Rafael	\N	56454 Little Groves	\N	San Rafael	431	15601-3703	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.708079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
39	39	Palmdale Location	Palmdale	\N	93019 Rudy Plaza	\N	Palmdale	431	94864	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.711071	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
40	40	Pasadena Location	Pasadena	\N	83741 Conor Crossing	\N	Pasadena	449	63536	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.713813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
41	41	Hoover Location	Hoover	\N	90519 Rolfson Divide Apt. 565	\N	Hoover	422	28208-1588	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.716705	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
42	42	West Memphis Location	West Memphis	\N	98524 Isai Union	\N	West Memphis	435	41600-5868	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.719338	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
43	43	Parma Location	Parma	\N	19783 Bogan Trace	\N	Parma	461	25054	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.722153	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
44	44	Florence Location	Florence	\N	06226 Gleason Stravenue	\N	Florence	432	81656	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.724833	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
45	45	Sunnyvale Location	Sunnyvale	\N	30631 Ferry River	\N	Sunnyvale	443	75447	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.727816	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
46	46	Cerritos Location	Cerritos	\N	40686 Layla Park	\N	Cerritos	444	47123-2600	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.730397	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
47	47	San Clemente Location	San Clemente	\N	48444 Gordon Point Suite 716	\N	San Clemente	437	25505-0410	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.746975	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
48	48	Hidden Hills Location	Hidden Hills	\N	00310 Ebert Fords	\N	Hidden Hills	461	06667-6010	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.75023	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
49	49	Oakland Location	Oakland	\N	77593 Helena Loaf	\N	Oakland	416	03216-0256	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.756251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
50	50	Mesa Location	Mesa	\N	16246 Norwood Stream Apt. 266	\N	Mesa	420	10468-9302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.759008	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1990	1990	Homer Location	Homer	\N	35593 Chet Burgs #770	\N	Homer	\N	22599-8553	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	t	\N	\N	\N	\N	2014-06-25 15:08:18.606377	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
84	84	Santa Cruz Location	Santa Cruz	\N	98818 Lesch Vista #224	\N	Santa Cruz	423	13153	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.89752	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
85	85	Hawthorne Location	Hawthorne	\N	71538 Suite 5-B	\N	Hawthorne	414	67901-0482	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.900245	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
87	87	Oxnard Location	Oxnard	\N	90468 Department N	\N	Oxnard	449	17802-8601	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.9057	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
88	88	Dana Point Location	Dana Point	\N	44719 Hulda Cove Suite 960	\N	Dana Point	452	43884	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.908377	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
90	90	Forrest City Location	Forrest City	\N	18216 Alvina Trail	\N	Forrest City	423	91316	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.913864	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
92	92	Gulf Shores Location	Gulf Shores	\N	23793 Schneider Islands #142	\N	Gulf Shores	426	11038-2442	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.919293	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
93	93	Alameda Location	Alameda	\N	93532 Pier Q	\N	Alameda	456	70045	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.928207	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
95	95	Rolling Hills Location	Rolling Hills	\N	02568 Quitzon Junction	\N	Rolling Hills	440	14157-1219	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.94087	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
96	96	Toledo Location	Toledo	\N	01694 Bins Shores #829	\N	Toledo	432	92754-0840	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.943899	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
98	98	Alhambra Location	Alhambra	\N	02053 Herzog Summit	\N	Alhambra	456	18418	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.949387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
99	99	Birmingham Location	Birmingham	\N	45056 Floor 062	\N	Birmingham	439	29661	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.95244	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
101	101	Oakland Location	Oakland	\N	71982 D'angelo Village Apt. 040	\N	Oakland	\N	15423-7636	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.970685	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
103	103	Bloomington Location	Bloomington	\N	96726 Kian Valley Apt. 128	\N	Bloomington	453	00061	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.976744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
104	104	La Habra Heights Location	La Habra Heights	\N	98452 Hermann Walks	\N	La Habra Heights	440	08349-2076	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.979444	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
106	106	Homer Location	Homer	\N	15530 Julio Square	\N	Homer	433	53537-1977	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:06.991669	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
107	107	La Palma Location	La Palma	\N	68331 Upton Grove	\N	La Palma	452	91154-3247	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.000982	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
109	109	Corona Location	Corona	\N	43168 Lot S	\N	Corona	414	46517-7588	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.012906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
110	110	Norwalk Location	Norwalk	\N	10370 Nienow Radial Apt. 258	\N	Norwalk	424	53855	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.015679	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
112	112	Fairbanks Location	Fairbanks	\N	81951 Bins Wall Suite 857	\N	Fairbanks	454	57761	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.021663	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
114	114	Monterey Park Location	Monterey Park	\N	78752 Arch Prairie	\N	Monterey Park	444	48737	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.027764	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
115	115	Danville Location	Danville	\N	46590 Gaston Route	\N	Danville	\N	64276-3857	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.031123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
118	118	La Jolla Location	La Jolla	\N	65416 Kenyon Spring	\N	La Jolla	450	03136	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.049164	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
119	119	Dothan Location	Dothan	\N	03815 Morissette Junction	\N	Dothan	418	29072-8747	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.0552	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
121	121	Dayton Location	Dayton	\N	94293 Room U	\N	Dayton	418	66214	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.086309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
122	122	Fresno Location	Fresno	\N	99712 Hessel Center	\N	Fresno	415	01171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.089125	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
123	123	El Monte Location	El Monte	\N	75137 Burley Viaduct #855	\N	El Monte	425	14562	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.097178	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
125	125	Kettering Location	Kettering	\N	54273 Trace Meadow	\N	Kettering	443	87303-7484	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.106426	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
126	126	Rialto Location	Rialto	\N	12779 Lot 6-B	\N	Rialto	463	70880-7430	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.109099	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
128	128	Brea Location	Brea	\N	59416 Smith Cape #100	\N	Brea	418	71791	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.11473	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
130	130	Avalon Location	Avalon	\N	46584 Lacy Mountain	\N	Avalon	457	69182-6029	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.12	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
131	131	Salinas Location	Salinas	\N	64568 Cathryn Cape #489	\N	Salinas	416	79836	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.122784	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
133	133	West Lafayette Location	West Lafayette	\N	39107 Unit X	\N	West Lafayette	415	28827	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.127956	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
134	134	Kent Location	Kent	\N	57622 Kaylee Stream #888	\N	Kent	448	46942	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.130518	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
136	136	Redding Location	Redding	\N	47264 Konopelski Knolls Apt. 820	\N	Redding	412	85003-5677	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.135992	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
137	137	Visalia Location	Visalia	\N	40581 Haskell Prairie	\N	Visalia	\N	95814	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.14593	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
139	139	Laguna Niguel Location	Laguna Niguel	\N	43698 Karelle Plains	\N	Laguna Niguel	414	56244-9295	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.154708	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
141	141	Vincennes Location	Vincennes	\N	02536 Roma Mews Apt. 665	\N	Vincennes	419	42717-5778	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.15996	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
142	142	Valdez Location	Valdez	\N	98920 Rubye Summit	\N	Valdez	415	05313	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.162539	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
144	144	Redondo Beach Location	Redondo Beach	\N	83726 Trevion Pine	\N	Redondo Beach	415	46238-4843	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.167867	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
145	145	Florence Location	Florence	\N	32325 Alec Mills Apt. 696	\N	Florence	\N	12846-7155	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.170444	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
147	147	Lancaster Location	Lancaster	\N	10135 Zemlak Knolls Apt. 868	\N	Lancaster	436	00191	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.175408	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
149	149	Sahuarita Location	Sahuarita	\N	30136 Giovanni Junctions Suite 294	\N	Sahuarita	464	47808	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.190433	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
150	150	Santa Cruz Location	Santa Cruz	\N	12235 Grimes Street	\N	Santa Cruz	424	45335	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.193125	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
152	152	Lodi Location	Lodi	\N	92560 Space W	\N	Lodi	429	49716	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.201779	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
154	154	Tuscaloosa Location	Tuscaloosa	\N	96830 Bogan Orchard	\N	Tuscaloosa	449	03259	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.207369	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
155	155	Chino Location	Chino	\N	13494 Willis Via #939	\N	Chino	413	14217	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.210196	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
156	156	Barrow Location	Barrow	\N	24660 Kennith Rapid Apt. 635	\N	Barrow	441	69376	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.212975	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
158	158	Lafayette Location	Lafayette	\N	16105 Cameron Meadow	\N	Lafayette	443	22137	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.218598	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
159	159	Sitka Location	Sitka	\N	42776 Mertz Spur #024	\N	Sitka	457	91344	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.221185	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
161	161	Dana Point Location	Dana Point	\N	35164 Mante Trail Apt. 004	\N	Dana Point	451	47034-6655	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.226537	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
163	163	Two Rivers Location	Two Rivers	\N	57715 Rath Coves Apt. 674	\N	Two Rivers	449	26817-9912	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.231904	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
164	164	San Gabriel Location	San Gabriel	\N	20607 Goldner Ford	\N	San Gabriel	455	50028	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.234798	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
166	166	Walnut Location	Walnut	\N	30128 Ford Court	\N	Walnut	433	52434-3087	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.248322	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
167	167	Yuma Location	Yuma	\N	65830 Hills Springs Suite 282	\N	Yuma	446	15406-6312	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.254951	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
168	168	Homer Location	Homer	\N	21879 Davis Grove	\N	Homer	\N	52257-4736	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.258584	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2026	2026	Bellflower Location	Bellflower	\N	09201 Darrel Trafficway #938	\N	Bellflower	424	48382-5986	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.078978	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
172	172	Redlands Location	Redlands	\N	57964 Raynor Parkways	\N	Redlands	427	79890-4774	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.277711	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
174	174	Sahuarita Location	Sahuarita	\N	76641 Gibson Junction	\N	Sahuarita	459	60525	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.287834	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
175	175	Yuma Location	Yuma	\N	35079 Side	\N	Yuma	\N	64901-3820	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.296969	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
176	176	Columbus Location	Columbus	\N	73543 Penthouse	\N	Columbus	421	57940-1910	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.300929	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
178	178	Bell Location	Bell	\N	62722 Dayton Union	\N	Bell	424	08127-5609	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.306475	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
180	180	Zanesville Location	Zanesville	\N	49663 Gorczany Street	\N	Zanesville	459	95642-7381	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.311781	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
181	181	Fairfield Location	Fairfield	\N	36255 Department J	\N	Fairfield	459	03642-7404	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.314401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
182	182	San Mateo Location	San Mateo	\N	57578 Paige Hills	\N	San Mateo	448	53504-2652	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.31696	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
184	184	Springfield Location	Springfield	\N	45846 Armstrong Corners	\N	Springfield	440	68575	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.32212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
186	186	Youngstown Location	Youngstown	\N	71758 Glover Haven Apt. 272	\N	Youngstown	\N	84839	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.32735	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
187	187	Half Moon Bay Location	Half Moon Bay	\N	18260 Rogahn Curve Suite 032	\N	Half Moon Bay	460	80842	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.329832	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
189	189	San Luis Obispo Location	San Luis Obispo	\N	33544 Paucek Lodge #575	\N	San Luis Obispo	415	35447	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.338375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
191	191	Oxnard Location	Oxnard	\N	75821 Schuppe Hills	\N	Oxnard	415	38635	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.343801	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
192	192	Hot Springs Location	Hot Springs	\N	15890 Loyal Flat Suite 672	\N	Hot Springs	418	48675-8389	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.346534	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
194	194	Gary Location	Gary	\N	34692 Cristopher Plain Apt. 021	\N	Gary	428	07942	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.352245	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
195	195	Scottsdale Location	Scottsdale	\N	29029 Gleason Rapid #890	\N	Scottsdale	462	18902	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.355066	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
197	197	Louisville Location	Louisville	\N	64380 Gusikowski Glens #302	\N	Louisville	433	35878-8631	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.360497	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
199	199	Agoura Hills Location	Agoura Hills	\N	24734 Sierra Locks	\N	Agoura Hills	454	03057	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.365921	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
200	200	Mobile Location	Mobile	\N	22476 Milton Well #948	\N	Mobile	432	52389-3108	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.368638	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
202	202	Oxnard Location	Oxnard	\N	48126 Ankunding Common	\N	Oxnard	438	29919	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.393388	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
203	203	Santa Cruz Location	Santa Cruz	\N	08143 Daniel Pines	\N	Santa Cruz	435	45059	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.396427	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
205	205	Murrieta Location	Murrieta	\N	80823 Ayden Forks Apt. 348	\N	Murrieta	421	56287-9497	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.401797	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
207	207	West Hollywood Location	West Hollywood	\N	78416 Albina Keys Apt. 856	\N	West Hollywood	416	32470-8244	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.407056	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
208	208	Calabasas Location	Calabasas	\N	47948 Brakus Meadows #381	\N	Calabasas	\N	53541	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.409754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
210	210	Auburn Location	Auburn	\N	29527 Kuhn Tunnel	\N	Auburn	433	82359-7645	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.41499	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
211	211	Bell Gardens Location	Bell Gardens	\N	17137 Conn Plains Suite 350	\N	Bell Gardens	412	02483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.417645	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
213	213	Fairfield Location	Fairfield	\N	82762 Abe Isle	\N	Fairfield	462	36488	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.422888	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
214	214	Carson Location	Carson	\N	71469 Torp Trafficway Suite 394	\N	Carson	439	40536-6075	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.425628	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
216	216	Fairbanks Location	Fairbanks	\N	01436 Greenfelder Pass	\N	Fairbanks	457	14594-6218	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.431054	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
218	218	Malibu Location	Malibu	\N	26394 Chyna Rue #877	\N	Malibu	424	77177-6402	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.439876	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
219	219	Santa Rosa Location	Santa Rosa	\N	91035 Fletcher Motorway	\N	Santa Rosa	427	44006-8777	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.445935	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
221	221	Azusa Location	Azusa	\N	73063 Mozell Hollow Apt. 153	\N	Azusa	447	04735-0407	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.45205	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
222	222	Richmond Location	Richmond	\N	06700 Witting Knolls Apt. 120	\N	Richmond	465	64316	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.458013	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
224	224	Ventura Location	Ventura	\N	47639 Maybell Greens	\N	Ventura	\N	66214	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.464144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
225	225	Kettering Location	Kettering	\N	30930 Gleason Course Suite 768	\N	Kettering	450	08820	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.46669	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
226	226	Murrieta Location	Murrieta	\N	01490 Nicolas Trace	\N	Murrieta	460	80811	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.470168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
228	228	Villa Park Location	Villa Park	\N	51188 Dolores Loop	\N	Villa Park	\N	98176-4569	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.482244	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
230	230	Monterey Location	Monterey	\N	28953 McKenzie Common	\N	Monterey	416	76338	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.494226	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
231	231	Delta Junction Location	Delta Junction	\N	37548 Delmer Gardens	\N	Delta Junction	453	04149-9519	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.500263	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
233	233	Buena Park Location	Buena Park	\N	88509 Apartment X	\N	Buena Park	419	55809-7868	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.513522	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
235	235	Middletown Location	Middletown	\N	85403 Floor 576	\N	Middletown	424	02312-1186	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.524545	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
236	236	Two Rivers Location	Two Rivers	\N	68038 Hangar 0	\N	Two Rivers	424	71618-7104	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.53004	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
238	238	Fullerton Location	Fullerton	\N	32431 Schowalter Summit Suite 616	\N	Fullerton	427	48135	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.536514	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
240	240	Rolling Hills Location	Rolling Hills	\N	78586 Altenwerth Common #295	\N	Rolling Hills	436	70088-6935	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.548211	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
241	241	Santa Rosa Location	Santa Rosa	\N	25793 Trailer 26-B	\N	Santa Rosa	464	17816	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.551192	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
243	243	Hidden Hills Location	Hidden Hills	\N	59019 Kunze Ville	\N	Hidden Hills	432	69557	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.560684	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
245	245	Maywood Location	Maywood	\N	66440 Filomena Pine Suite 831	\N	Maywood	415	49370	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.569329	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
246	246	Nenana Location	Nenana	\N	25732 Ebert River Suite 983	\N	Nenana	414	96292	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.572803	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
247	247	Lakewood Location	Lakewood	\N	12410 Teagan Roads	\N	Lakewood	\N	93767-9765	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.57883	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
249	249	South El Monte Location	South El Monte	\N	16943 Ritchie Hollow Suite 074	\N	South El Monte	419	40831-8869	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.596419	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
251	251	Los Angeles Location	Los Angeles	\N	46280 Maximillian Parks Suite 952	\N	Los Angeles	420	04464-1345	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.602876	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
252	252	Whittier Location	Whittier	\N	52519 Keshawn Shores Suite 948	\N	Whittier	414	20289	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.605549	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
254	254	Jonesboro Location	Jonesboro	\N	34696 Tremblay Underpass	\N	Jonesboro	\N	80657	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.611296	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
255	255	Anchorage Location	Anchorage	\N	59723 Rowe Plaza	\N	Anchorage	432	02063	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.614698	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
257	257	Hawthorne Location	Hawthorne	\N	78778 Vivian Inlet Apt. 163	\N	Hawthorne	435	11082-4477	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.620674	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
260	260	La Habra Location	La Habra	\N	58828 Johnathon Cape	\N	La Habra	\N	13281-8504	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.629457	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
261	261	South Bend Location	South Bend	\N	91045 Alessia Junction Apt. 434	\N	South Bend	443	17498	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.632867	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
263	263	La Palma Location	La Palma	\N	66241 Asa Harbors	\N	La Palma	446	93762	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.639094	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
264	264	Florence Location	Florence	\N	33038 Shawna Mission	\N	Florence	\N	68588-0901	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.642034	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
266	266	Compton Location	Compton	\N	78373 Arnulfo Drives Suite 502	\N	Compton	425	61519-7459	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.656996	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
267	267	Tustin Location	Tustin	\N	46175 Annabell Turnpike #822	\N	Tustin	461	41485-3801	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.662951	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
269	269	Rancho Cucamonga Location	Rancho Cucamonga	\N	93578 Breitenberg Trafficway	\N	Rancho Cucamonga	\N	78128-9873	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.668759	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
270	270	Garden Grove Location	Garden Grove	\N	08565 Office	\N	Garden Grove	448	47293-9874	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.67457	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
272	272	Dothan Location	Dothan	\N	96765 Ruecker Roads	\N	Dothan	461	74121-3951	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.684011	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
273	273	Oxnard Location	Oxnard	\N	13745 DuBuque Pines Suite 356	\N	Oxnard	452	28283-8599	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.687121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
275	275	Bellflower Location	Bellflower	\N	73408 Lorenz Walk	\N	Bellflower	424	77565	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.692969	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
276	276	Whittier Location	Whittier	\N	97449 Friesen Club	\N	Whittier	437	53074-5890	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.698915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
278	278	Valencia Location	Valencia	\N	70467 Selena Locks Apt. 439	\N	Valencia	453	54618	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.712495	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
279	279	Paducah Location	Paducah	\N	86896 Bernier Green	\N	Paducah	459	82680	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.715685	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
281	281	San Gabriel Location	San Gabriel	\N	85069 Hamill Freeway Apt. 106	\N	San Gabriel	425	79226	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.729714	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
282	282	Fullerton Location	Fullerton	\N	83440 Schaefer Forest	\N	Fullerton	426	09473-8723	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.73295	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
284	284	Fullerton Location	Fullerton	\N	59263 Nicolas Lights Suite 863	\N	Fullerton	453	04894-2665	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.741216	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
285	285	La Mirada Location	La Mirada	\N	15288 Penthouse	\N	La Mirada	444	26687	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.744023	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
287	287	Toledo Location	Toledo	\N	91196 Koss Grove #105	\N	Toledo	433	03892-2188	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.749879	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
288	288	Sitka Location	Sitka	\N	07578 Carolyne Falls	\N	Sitka	424	88036	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.753256	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
290	290	Brea Location	Brea	\N	38904 Lorenza Rapids	\N	Brea	464	59855	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.759315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
292	292	Villa Park Location	Villa Park	\N	12137 Jerde Forest Apt. 986	\N	Villa Park	412	95203	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.765423	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
293	293	Bell Gardens Location	Bell Gardens	\N	28789 Breitenberg Streets	\N	Bell Gardens	\N	90327	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.768187	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
295	295	La Habra Heights Location	La Habra Heights	\N	77255 Alexander Center	\N	La Habra Heights	465	07931-2353	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.78249	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
297	297	Azusa Location	Azusa	\N	65033 Russel Route Suite 888	\N	Azusa	429	13635-6548	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.791109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
298	298	San Dimas Location	San Dimas	\N	21704 Front	\N	San Dimas	422	04462-3520	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.793744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
300	300	Alameda Location	Alameda	\N	54184 Pier K	\N	Alameda	444	02356-0991	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.799032	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
301	301	Lakewood Location	Lakewood	\N	86132 Edyth Harbor Apt. 124	\N	Lakewood	414	49165-7235	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.801596	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
303	303	Valencia Location	Valencia	\N	24845 Lang Ports	\N	Valencia	\N	35376	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.806937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
304	304	City of Industry Location	City of Industry	\N	38168 Chris Point	\N	City of Industry	443	56189-4229	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.809432	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
306	306	Wynne Location	Wynne	\N	21515 Roxanne Skyway Apt. 732	\N	Wynne	419	01121-5073	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.814799	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
308	308	Paramount Location	Paramount	\N	66199 Schultz Island Apt. 813	\N	Paramount	444	86592	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.819946	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
309	309	Visalia Location	Visalia	\N	58809 Hammes Islands Suite 513	\N	Visalia	461	99940-0837	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.822517	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
311	311	Richmond Location	Richmond	\N	64923 Jarod Springs	\N	Richmond	446	66143	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.827854	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
312	312	Canton Location	Canton	\N	35279 Alycia Terrace Apt. 850	\N	Canton	446	38656	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.830594	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
314	314	Fullerton Location	Fullerton	\N	72467 Allen Curve #619	\N	Fullerton	459	28255-3177	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.836009	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
316	316	Monrovia Location	Monrovia	\N	36392 Ruben Spurs	\N	Monrovia	450	14127	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.841095	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
317	317	Eureka Location	Eureka	\N	15350 Littel Flats	\N	Eureka	426	54621	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.843835	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
319	319	Placentia Location	Placentia	\N	86494 Rashawn Fall	\N	Placentia	425	29622	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.848858	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
320	320	Bloomington Location	Bloomington	\N	77083 Dena Island Suite 465	\N	Bloomington	\N	60233	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.851378	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
322	322	Hollister Location	Hollister	\N	72630 Alexandrea Groves	\N	Hollister	414	70657	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.856419	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
323	323	Lakewood Location	Lakewood	\N	79267 Travon Canyon	\N	Lakewood	433	29244	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.867955	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
324	324	Marana Location	Marana	\N	33002 Royce Locks	\N	Marana	416	28711-1202	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.870487	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
326	326	Hawthorne Location	Hawthorne	\N	48896 Herzog Neck Suite 723	\N	Hawthorne	463	83110-4024	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.875815	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
328	328	Kettering Location	Kettering	\N	14245 Braeden Street	\N	Kettering	435	37091	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.886219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
329	329	Tok Location	Tok	\N	51996 Hansen Mills	\N	Tok	447	34371	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.88905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
331	331	Chino Hills Location	Chino Hills	\N	15988 Rutherford Isle	\N	Chino Hills	463	44639	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.894424	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
332	332	West Memphis Location	West Memphis	\N	99254 Dina Crescent Apt. 885	\N	West Memphis	436	62966	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.897506	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
334	334	Jonesboro Location	Jonesboro	\N	89280 Tromp Roads	\N	Jonesboro	441	21462	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.903445	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
336	336	Dana Point Location	Dana Point	\N	12296 Carter Isle	\N	Dana Point	453	08686-3645	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.90906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
337	337	Lodi Location	Lodi	\N	30285 Alexa Cliff	\N	Lodi	433	53008	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.911828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
339	339	Michigan City Location	Michigan City	\N	53551 Side	\N	Michigan City	441	13697-2970	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.917386	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
340	340	Palmdale Location	Palmdale	\N	75837 Clay Common Apt. 969	\N	Palmdale	444	53121	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.920347	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
342	342	Sahuarita Location	Sahuarita	\N	49442 Casper Crest	\N	Sahuarita	425	18632	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.925521	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
343	343	Athens Location	Athens	\N	38437 Dooley Springs	\N	Athens	436	89314-6424	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.944033	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
345	345	Gadsden Location	Gadsden	\N	50194 Bechtelar Port Suite 459	\N	Gadsden	418	04311-6215	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.949605	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
348	348	Sonoma Location	Sonoma	\N	35546 Marshall Roads Suite 145	\N	Sonoma	442	89867-3099	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.964416	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
349	349	Artesia Location	Artesia	\N	72816 Pearline Dale	\N	Artesia	434	88074	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.968422	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
351	351	Costa Mesa Location	Costa Mesa	\N	14502 Leffler Ways	\N	Costa Mesa	415	71866-2857	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.980511	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
352	352	Hoover Location	Hoover	\N	29453 Hansen Shores	\N	Hoover	460	58137	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.983461	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
354	354	Lake Forest Location	Lake Forest	\N	52497 Kassulke Knolls Suite 192	\N	Lake Forest	414	57144-4730	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.989358	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
356	356	Huntsville Location	Huntsville	\N	79546 Bahringer Walks	\N	Huntsville	\N	77912-9902	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:07.995446	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
357	357	South Bend Location	South Bend	\N	09581 Jaskolski Estates	\N	South Bend	427	17143-3495	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.004251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
359	359	Elkhart Location	Elkhart	\N	71741 Gerhold Harbor	\N	Elkhart	431	21822	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.019704	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
360	360	Laguna Beach Location	Laguna Beach	\N	94592 Room T	\N	Laguna Beach	441	60721	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.028862	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
362	362	Hawthorne Location	Hawthorne	\N	18931 Boyer Square	\N	Hawthorne	429	71225-7475	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.034935	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
364	364	El Segundo Location	El Segundo	\N	10544 Dach Alley	\N	El Segundo	430	95534-9987	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.041029	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
365	365	Palos Verdes Estates Location	Palos Verdes Estates	\N	21431 Franecki Burg	\N	Palos Verdes Estates	418	82383-1422	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.043707	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
367	367	Sahuarita Location	Sahuarita	\N	47659 Monserrate Union	\N	Sahuarita	420	90325	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.053109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
369	369	San Rafael Location	San Rafael	\N	84617 Graham Green	\N	San Rafael	455	12603-0087	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.059127	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
370	370	Murrieta Location	Murrieta	\N	61295 Wilderman Lakes	\N	Murrieta	436	50896	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.065178	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
372	372	Downey Location	Downey	\N	90888 Wilderman Landing	\N	Downey	423	83477	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.071899	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
373	373	Riverside Location	Riverside	\N	06696 Cruickshank Row #734	\N	Riverside	444	24937-3135	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.089428	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
375	375	Wynne Location	Wynne	\N	90574 Trevor Place	\N	Wynne	\N	99543	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.10144	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
376	376	Yorba Linda Location	Yorba Linda	\N	05295 Grady Roads	\N	Yorba Linda	443	90062	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.103928	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
378	378	Corona Location	Corona	\N	69652 Friesen Freeway	\N	Corona	414	41801-9753	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.118158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
379	379	Youngstown Location	Youngstown	\N	83565 Conn Inlet	\N	Youngstown	422	12598	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.124923	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
381	381	Michigan City Location	Michigan City	\N	88188 Chyna Coves	\N	Michigan City	\N	46931	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.130994	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
382	382	Gilbert Location	Gilbert	\N	06015 Laney View #315	\N	Gilbert	415	67848	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.133529	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
384	384	La Cañada Flintridge Location	La Cañada Flintridge	\N	00498 Auer Pine	\N	La Cañada Flintridge	427	69887	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.139796	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
386	386	Visalia Location	Visalia	\N	59527 Room W	\N	Visalia	415	86054-2672	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.145953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
387	387	Montebello Location	Montebello	\N	03226 Rolfson Field Apt. 802	\N	Montebello	425	20097	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.14925	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
389	389	Orange Location	Orange	\N	10374 Cody Trail #992	\N	Orange	\N	06267-6632	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.15545	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
391	391	Bell Location	Bell	\N	06670 Ankunding Ways	\N	Bell	445	87007	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.167402	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
392	392	Burlingame Location	Burlingame	\N	28695 Wintheiser Lake	\N	Burlingame	441	95194	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.178565	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
393	393	Beverly Hills Location	Beverly Hills	\N	56600 Penthouse	\N	Beverly Hills	453	29758	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.181262	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
395	395	Huntington Beach Location	Huntington Beach	\N	73307 Chance Keys Suite 236	\N	Huntington Beach	438	66462-9466	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.190965	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
396	396	Duarte Location	Duarte	\N	66105 Willow Mission Apt. 320	\N	Duarte	444	50675-7803	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.196692	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
398	398	Chico Location	Chico	\N	98187 Rosenbaum Manors	\N	Chico	433	56328	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.205588	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
399	399	Burbank Location	Burbank	\N	50168 Katlyn Crest	\N	Burbank	420	22353-4224	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.215232	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
401	401	Covina Location	Covina	\N	70045 Thompson Club	\N	Covina	461	10650-1573	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.223547	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
402	402	Birmingham Location	Birmingham	\N	69931 Deckow Cliff #127	\N	Birmingham	459	42715	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.227168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
404	404	Seal Beach Location	Seal Beach	\N	89276 Zula Harbor Apt. 610	\N	Seal Beach	\N	74882-1229	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.233259	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
406	406	Santa Cruz Location	Santa Cruz	\N	01574 Cole Motorway	\N	Santa Cruz	\N	84033	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.244744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
407	407	La Verne Location	La Verne	\N	55065 Leann Field Apt. 148	\N	La Verne	417	84270-7370	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.247445	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
409	409	Whittier Location	Whittier	\N	51156 Dibbert Underpass Apt. 955	\N	Whittier	427	16171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.25427	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
410	410	Kent Location	Kent	\N	68346 Kling Camp Apt. 981	\N	Kent	421	07662	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.257394	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
412	412	Santa Ana Location	Santa Ana	\N	22131 Nikolaus Valley	\N	Santa Ana	457	25436	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.26347	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
413	413	Flagstaff Location	Flagstaff	\N	05903 Klein Ports Apt. 701	\N	Flagstaff	452	53511-0820	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.266215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
414	414	Brea Location	Brea	\N	84598 Huels Pike	\N	Brea	414	62840	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.269517	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
416	416	Hammond Location	Hammond	\N	08259 Reese Shores Apt. 088	\N	Hammond	447	75378	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.275584	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
418	418	Santa Clarita Location	Santa Clarita	\N	07456 Torrance Parkway	\N	Santa Clarita	415	86515	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.281753	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
419	419	Bowling Green Location	Bowling Green	\N	93307 Reynolds Union	\N	Bowling Green	\N	25740	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.284381	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
421	421	Redding Location	Redding	\N	94620 Kathryne Overpass #997	\N	Redding	458	73446-5883	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.293748	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
423	423	Florence Location	Florence	\N	65598 Bonita Circles Apt. 346	\N	Florence	436	81344-9865	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.305704	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
424	424	Temecula Location	Temecula	\N	15045 Trudie Mews #670	\N	Temecula	437	72126-1996	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.313936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
426	426	Concord Location	Concord	\N	27438 Altenwerth Motorway	\N	Concord	418	41950-7904	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.320241	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
427	427	Bradbury Location	Bradbury	\N	52729 Marisol Lodge	\N	Bradbury	435	16932-1516	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.322865	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
429	429	Irwindale Location	Irwindale	\N	50848 O'Kon Ferry	\N	Irwindale	458	26891	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.32814	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
430	430	Nome Location	Nome	\N	52813 Reinger Ridges	\N	Nome	445	72296	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.33085	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
432	432	Beverly Hills Location	Beverly Hills	\N	16996 Konopelski Ville Apt. 312	\N	Beverly Hills	444	22780	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.336252	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
436	436	Ontario Location	Ontario	\N	40338 Jacobs Shore #351	\N	Ontario	450	09423	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.353679	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
437	437	Dothan Location	Dothan	\N	80436 Haley Landing Apt. 859	\N	Dothan	439	60729	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.358585	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
440	440	Stockton Location	Stockton	\N	23041 Penthouse	\N	Stockton	441	20222	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.368464	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
441	441	Youngstown Location	Youngstown	\N	83325 Apartment G	\N	Youngstown	463	04320	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.371172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
443	443	Yorba Linda Location	Yorba Linda	\N	66715 Ariane Fords Suite 447	\N	Yorba Linda	451	63509-6763	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.376498	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
444	444	Sitka Location	Sitka	\N	02867 Shaniya Fords	\N	Sitka	419	51190	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.379131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
446	446	Santa Monica Location	Santa Monica	\N	30761 Abbott Fork	\N	Santa Monica	434	60853	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.384428	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
447	447	Garden Grove Location	Garden Grove	\N	29073 Slip E	\N	Garden Grove	459	60613-3888	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.387071	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
449	449	Bellflower Location	Bellflower	\N	02996 Runolfsdottir Mews Apt. 942	\N	Bellflower	420	19510	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.392588	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
450	450	Moraga Location	Moraga	\N	80027 Schuster Harbor	\N	Moraga	427	26112-9724	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.39535	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
452	452	Manhattan Beach Location	Manhattan Beach	\N	56614 Space 19-I	\N	Manhattan Beach	418	92120	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.413686	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
453	453	Orange Location	Orange	\N	11722 White Prairie Suite 396	\N	Orange	442	77843	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.416465	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
455	455	Tucson Location	Tucson	\N	14685 Bartell Ramp	\N	Tucson	443	15641	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.421565	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
456	456	Dana Point Location	Dana Point	\N	80252 Suite 53-F	\N	Dana Point	452	05811-8301	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.424611	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
458	458	West Lafayette Location	West Lafayette	\N	44942 Homenick Centers	\N	West Lafayette	447	31587	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.429997	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
460	460	Bellflower Location	Bellflower	\N	04971 Samanta Forge #059	\N	Bellflower	429	71272-2528	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.435412	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
461	461	Akron Location	Akron	\N	22614 Trailer M	\N	Akron	452	35602	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.43807	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
463	463	Union City Location	Union City	\N	87660 Runolfsdottir Drives	\N	Union City	464	23611-8647	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.443992	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
465	465	Laguna Beach Location	Laguna Beach	\N	93769 Blanda Valleys Apt. 263	\N	Laguna Beach	446	98198	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.44962	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
467	467	Juneau Location	Juneau	\N	86766 Daryl Avenue #945	\N	Juneau	446	74133-6681	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.467876	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
468	468	Little Rock Location	Little Rock	\N	91833 Department W	\N	Little Rock	435	12634	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.473869	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
470	470	Crown Point Location	Crown Point	\N	61083 Green Drive	\N	Crown Point	448	46938-4937	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.479903	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
471	471	Tok Location	Tok	\N	43021 Earlene Squares	\N	Tok	421	58059-3946	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.485927	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
473	473	Tuscaloosa Location	Tuscaloosa	\N	90050 Jones Union	\N	Tuscaloosa	460	45700-9746	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.492012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
474	474	Seward Location	Seward	\N	50006 Medhurst Tunnel Apt. 396	\N	Seward	437	04751	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.494752	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
476	476	Rosemead Location	Rosemead	\N	76975 Lesley Canyon	\N	Rosemead	430	01010-6628	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.50079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
477	477	Redlands Location	Redlands	\N	90597 Cremin Inlet	\N	Redlands	421	06659	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.504151	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
479	479	Hammond Location	Hammond	\N	11740 Sporer Lights	\N	Hammond	446	77298-3848	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.510237	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
480	480	Burlingame Location	Burlingame	\N	43068 Homenick Trace #848	\N	Burlingame	422	84031-1710	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.512932	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
482	482	Moraga Location	Moraga	\N	35768 Brekke Streets	\N	Moraga	414	17699-6665	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.527552	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
483	483	San Dimas Location	San Dimas	\N	94512 Floor 9651	\N	San Dimas	\N	40026	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.534286	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
485	485	Pomona Location	Pomona	\N	77232 Catharine Crossroad Suite 089	\N	Pomona	418	35036	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.545705	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
487	487	Anaheim Location	Anaheim	\N	35353 Pfannerstill Underpass	\N	Anaheim	429	89305	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.550933	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
488	488	Fort Smith Location	Fort Smith	\N	93576 Ankunding Spur #769	\N	Fort Smith	425	36805	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.553511	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
490	490	Vincennes Location	Vincennes	\N	87102 Bergnaum Port	\N	Vincennes	414	54000-0874	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.558797	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
491	491	Tucson Location	Tucson	\N	58434 Connelly Extension Apt. 188	\N	Tucson	\N	82830	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.561437	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
493	493	Montebello Location	Montebello	\N	61633 Schuster Ville	\N	Montebello	456	98272-5563	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.5665	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
494	494	Culver City Location	Culver City	\N	94573 Pfannerstill Turnpike	\N	Culver City	453	55519	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.569281	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
496	496	Torrance Location	Torrance	\N	01627 O'Conner Well Apt. 874	\N	Torrance	452	88070-9675	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.574634	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
498	498	Rohnert Park Location	Rohnert Park	\N	56280 Shanny Junction	\N	Rohnert Park	429	82358-2529	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.579823	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
499	499	Burlingame Location	Burlingame	\N	62046 Buckridge Ways	\N	Burlingame	449	62342-5884	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.588101	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
501	501	Frankfort Location	Frankfort	\N	52568 Fritsch Prairie	\N	Frankfort	452	19561-1153	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.593826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
503	503	Cudahy Location	Cudahy	\N	26457 Tavares Mission Apt. 266	\N	Cudahy	448	70217	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.599459	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
504	504	Crown Point Location	Crown Point	\N	37584 Swift Ridge	\N	Crown Point	461	32300	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.602121	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
505	505	Flagstaff Location	Flagstaff	\N	71366 Buford Row	\N	Flagstaff	\N	29818	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.604914	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
507	507	Chino Location	Chino	\N	23932 White Flat	\N	Chino	414	55085-0821	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.609973	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
508	508	Murray Location	Murray	\N	13606 Basement	\N	Murray	414	89900	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.612539	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
510	510	South Pasadena Location	South Pasadena	\N	90427 Ardella Walk Apt. 639	\N	South Pasadena	448	60039	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.618016	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
511	511	Florence Location	Florence	\N	61236 Penthouse	\N	Florence	461	36665-0748	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.620907	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
513	513	Rolling Hills Location	Rolling Hills	\N	53685 Huels Avenue Suite 304	\N	Rolling Hills	433	67105-4842	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.633314	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
515	515	Tuskegee Location	Tuskegee	\N	77470 Dooley Valley	\N	Tuskegee	435	47185-0892	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.651923	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
516	516	Arcadia Location	Arcadia	\N	70261 Beverly Road	\N	Arcadia	433	25439	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.654814	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
518	518	Fountain Valley Location	Fountain Valley	\N	89827 Carleton Tunnel	\N	Fountain Valley	\N	53991-9744	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.659874	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
519	519	Chandler Location	Chandler	\N	69928 Amir Glen	\N	Chandler	441	29073	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.662371	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
521	521	Barrow Location	Barrow	\N	82519 Elyse Squares	\N	Barrow	417	58566	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.675886	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
522	522	San Rafael Location	San Rafael	\N	19708 Trevion River	\N	San Rafael	450	81884-9938	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.678538	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
525	525	Placentia Location	Placentia	\N	91019 McLaughlin Drive Suite 822	\N	Placentia	415	48459	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.690447	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
527	527	San Juan Capistrano Location	San Juan Capistrano	\N	96442 Adela Fort	\N	San Juan Capistrano	450	96998-7585	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.702482	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
528	528	Monterey Location	Monterey	\N	33620 Kunze Mountain	\N	Monterey	413	20237-5799	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.705844	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
530	530	Palm Springs Location	Palm Springs	\N	41398 Marilie Route	\N	Palm Springs	\N	38722-1947	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.71145	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
532	532	Claremont Location	Claremont	\N	94940 Schimmel Estates #338	\N	Claremont	459	26016	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.717446	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
534	534	Gardena Location	Gardena	\N	99754 Hilpert Court	\N	Gardena	422	80670-9733	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.723415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
535	535	Pasadena Location	Pasadena	\N	49314 Office	\N	Pasadena	437	97436-8829	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.726777	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
537	537	Valdez Location	Valdez	\N	67012 Swift Spring Suite 867	\N	Valdez	457	52806	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.732849	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
538	538	Cleveland Location	Cleveland	\N	02334 Kristian Isle Suite 657	\N	Cleveland	447	01143	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.735454	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
540	540	Covina Location	Covina	\N	97081 Gus Valley	\N	Covina	\N	01883	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.745015	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
541	541	Hamilton Location	Hamilton	\N	88947 Tina Extensions Apt. 205	\N	Hamilton	458	73886	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.747827	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
543	543	Kettering Location	Kettering	\N	78572 Roberto Square	\N	Kettering	425	88974-2636	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.75383	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
544	544	Alhambra Location	Alhambra	\N	22839 Lauren Port	\N	Alhambra	413	62857-9702	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.757038	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
546	546	Fayetteville Location	Fayetteville	\N	65426 Zoie Skyway Suite 692	\N	Fayetteville	431	74755-8060	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.763864	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
547	547	Sacramento Location	Sacramento	\N	01761 Melany Fields	\N	Sacramento	462	54945	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.78118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
549	549	Lodi Location	Lodi	\N	05340 Jamaal Divide	\N	Lodi	439	79573-0875	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.787279	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
550	550	Phenix City Location	Phenix City	\N	82755 Hangar G	\N	Phenix City	461	02226-8523	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.790012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
552	552	Juneau Location	Juneau	\N	87403 Upper	\N	Juneau	\N	35258	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.795974	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
553	553	Mission Viejo Location	Mission Viejo	\N	30152 Johann Street Apt. 545	\N	Mission Viejo	451	64193	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.799403	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
555	555	Demopolis Location	Demopolis	\N	14123 Thiel Rest Apt. 643	\N	Demopolis	459	00358	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.820321	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
557	557	Anaheim Location	Anaheim	\N	28253 Jessyca Rapids #131	\N	Anaheim	413	09609-1040	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.840186	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
558	558	Lynwood Location	Lynwood	\N	49849 Tyreek Landing	\N	Lynwood	425	07382	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.84291	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
560	560	Mobile Location	Mobile	\N	24900 Hangar 24-B	\N	Mobile	\N	54612-9435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.849811	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
561	561	North Little Rock Location	North Little Rock	\N	47110 Crist Valleys	\N	North Little Rock	431	80744-0621	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.853113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
563	563	Rolling Hills Location	Rolling Hills	\N	43804 Ethyl Freeway Suite 003	\N	Rolling Hills	\N	03264-8684	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.859292	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
564	564	Eufaula Location	Eufaula	\N	26203 Piper Common	\N	Eufaula	427	64758-5004	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.865276	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
566	566	Mobile Location	Mobile	\N	92378 Alexane Summit Suite 126	\N	Mobile	447	03232	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.873149	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
567	567	Oxnard Location	Oxnard	\N	00078 Mueller Forge Apt. 347	\N	Oxnard	462	94101	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.877358	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
569	569	Arcadia Location	Arcadia	\N	99841 Schaden Parkways Apt. 101	\N	Arcadia	463	97118-9596	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.888611	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
570	570	Azusa Location	Azusa	\N	47720 Rear	\N	Azusa	450	08495-4151	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.891457	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
572	572	Delta Junction Location	Delta Junction	\N	75038 Daisy Fork	\N	Delta Junction	412	32176	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.906744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
574	574	Lawndale Location	Lawndale	\N	10289 Basement	\N	Lawndale	453	35439-6948	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.915445	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
575	575	Rancho Cordova Location	Rancho Cordova	\N	76705 Ashlee Forks	\N	Rancho Cordova	448	19134-9822	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.918324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
577	577	Middletown Location	Middletown	\N	10033 Arturo Glen Apt. 829	\N	Middletown	445	25534-6680	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.923764	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
579	579	Beverly Hills Location	Beverly Hills	\N	00004 Langworth Trail	\N	Beverly Hills	443	79028	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.929151	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
580	580	Santa Clarita Location	Santa Clarita	\N	55107 Schulist Cove	\N	Santa Clarita	462	51571-4924	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.931871	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
582	582	Laguna Woods Location	Laguna Woods	\N	76237 Murphy Glen Suite 819	\N	Laguna Woods	453	22750	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.937261	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
584	584	Huntington Park Location	Huntington Park	\N	71388 Schuppe Manor	\N	Huntington Park	451	17948	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.942824	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
585	585	Garden Grove Location	Garden Grove	\N	83418 Morar Common Apt. 141	\N	Garden Grove	417	54370	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.945687	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
587	587	Fullerton Location	Fullerton	\N	30290 Norris Route	\N	Fullerton	436	90933-3063	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.961242	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
589	589	Sitka Location	Sitka	\N	51089 Marina Trail	\N	Sitka	465	90609	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.970234	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
590	590	La Puente Location	La Puente	\N	83120 Quentin Cove	\N	La Puente	449	69954	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.973052	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
591	591	Corona Location	Corona	\N	55362 Ronny Drives	\N	Corona	458	28320-0585	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.978953	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
593	593	San Dimas Location	San Dimas	\N	29928 Schoen Harbor Suite 248	\N	San Dimas	433	51365	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.985169	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
595	595	Barrow Location	Barrow	\N	43968 Ulises Spur Apt. 624	\N	Barrow	459	49999	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:08.991164	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
597	597	Demopolis Location	Demopolis	\N	63039 Lower	\N	Demopolis	428	46464	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.009185	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
598	598	Rancho Cordova Location	Rancho Cordova	\N	81839 McDermott Expressway	\N	Rancho Cordova	455	57334	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.01536	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
600	600	Bell Gardens Location	Bell Gardens	\N	61498 Camila Prairie	\N	Bell Gardens	416	61380-6497	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.027226	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
601	601	Vernon Location	Vernon	\N	74403 Thiel Trail Suite 902	\N	Vernon	465	99255-4055	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.029858	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
603	603	Beverly Hills Location	Beverly Hills	\N	35645 Anna Square Suite 137	\N	Beverly Hills	441	87497-5165	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.035947	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
605	605	Mobile Location	Mobile	\N	52612 Floor 63	\N	Mobile	423	48181	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.048412	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
606	606	Fairbanks Location	Fairbanks	\N	26407 Violet Village	\N	Fairbanks	460	36127	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.051274	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
608	608	North Little Rock Location	North Little Rock	\N	30927 Abshire Rest	\N	North Little Rock	459	17595-9475	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.056382	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
610	610	Bell Location	Bell	\N	56117 Floor 554	\N	Bell	461	13232-2603	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.061692	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2028	2028	Thousand Oaks Location	Thousand Oaks	\N	56221 Haag Knolls Apt. 029	\N	Thousand Oaks	418	83926-9686	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.087724	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
612	612	Mesa Location	Mesa	\N	91448 Leannon Vista	\N	Mesa	446	21930	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.067034	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
614	614	Ventura Location	Ventura	\N	68442 Penthouse	\N	Ventura	423	41788-0896	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.072232	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
615	615	Brea Location	Brea	\N	38631 Rosalinda Path	\N	Brea	455	07283-0038	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.074826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
617	617	Bell Gardens Location	Bell Gardens	\N	13061 Vinnie Cliffs Suite 262	\N	Bell Gardens	426	50036-0954	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.080133	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
619	619	South Gate Location	South Gate	\N	71343 Shanahan Track	\N	South Gate	439	47714	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.090131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
620	620	San Dimas Location	San Dimas	\N	14555 Side	\N	San Dimas	457	21235	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.092691	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
621	621	Orange Location	Orange	\N	38787 Yvette Terrace #243	\N	Orange	451	65777-1501	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.095564	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
623	623	Richmond Location	Richmond	\N	22648 Geoffrey Coves Suite 509	\N	Richmond	463	04109	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.100729	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
625	625	Prescott Location	Prescott	\N	79266 Leone Streets	\N	Prescott	420	70685	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.10651	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
626	626	Laguna Beach Location	Laguna Beach	\N	25749 Cole Vista Apt. 622	\N	Laguna Beach	461	08685	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.110943	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
628	628	Decatur Location	Decatur	\N	92428 Wolff Square	\N	Decatur	423	66657-4762	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.118739	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
629	629	Commerce Location	Commerce	\N	32323 Pansy Views	\N	Commerce	420	53725-3311	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.12131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
631	631	Richmond Location	Richmond	\N	03063 Luettgen Points	\N	Richmond	456	35192	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.126949	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
633	633	South Bend Location	South Bend	\N	20900 Bradtke Orchard Suite 788	\N	South Bend	435	59690-9530	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.153927	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
634	634	San Rafael Location	San Rafael	\N	24684 Reyes Station	\N	San Rafael	435	86623-4220	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.156756	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
636	636	Rancho Cordova Location	Rancho Cordova	\N	47311 Mertz Fork	\N	Rancho Cordova	423	36271	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.162026	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
638	638	Bloomington Location	Bloomington	\N	33564 Parker Lights	\N	Bloomington	435	49238	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.167347	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
639	639	Tok Location	Tok	\N	03847 Kub Hill	\N	Tok	418	49702-7914	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.16995	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
641	641	San Dimas Location	San Dimas	\N	62038 Basement	\N	San Dimas	447	23268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.175734	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
642	642	Alameda Location	Alameda	\N	43452 Vito Canyon Apt. 375	\N	Alameda	456	99756	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.178271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
643	643	Palmdale Location	Palmdale	\N	74398 Upper	\N	Palmdale	420	75119-1732	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.18085	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
645	645	Fairfield Location	Fairfield	\N	99987 Remington Cape Suite 917	\N	Fairfield	457	46648-0630	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.186052	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
647	647	Sierra Vista Location	Sierra Vista	\N	50115 Fahey Stream Suite 378	\N	Sierra Vista	464	76779	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.191108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
648	648	Muncie Location	Muncie	\N	52720 Floor 2	\N	Muncie	445	71304-6948	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.193602	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
650	650	Covina Location	Covina	\N	00519 Deron Fields Apt. 250	\N	Covina	429	42609	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.20741	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
651	651	Jonesboro Location	Jonesboro	\N	24672 Block Points #905	\N	Jonesboro	422	04120	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.217471	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
653	653	San Gabriel Location	San Gabriel	\N	20095 Vivianne Crescent	\N	San Gabriel	435	83104-2406	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.225538	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
654	654	Hoover Location	Hoover	\N	46991 Nichole Meadow	\N	Hoover	453	59785-4656	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.228107	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
656	656	San Bernardino Location	San Bernardino	\N	60606 Paris Spring	\N	San Bernardino	434	67433	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.233946	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
658	658	Temple City Location	Temple City	\N	86488 Edward Pike Suite 466	\N	Temple City	435	95762	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.240327	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
659	659	Culver City Location	Culver City	\N	33670 Larkin Loop	\N	Culver City	\N	75941	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.243704	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
661	661	Jasper Location	Jasper	\N	92006 Bud Ferry #365	\N	Jasper	414	34688-8262	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.249781	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
662	662	La Mirada Location	La Mirada	\N	82067 Trailer Z	\N	La Mirada	413	19174-2246	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.252364	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
664	664	Fayetteville Location	Fayetteville	\N	50475 Vidal Radial Apt. 214	\N	Fayetteville	\N	93680	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.25844	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
666	666	Garden Grove Location	Garden Grove	\N	66382 D'Amore Lodge Suite 774	\N	Garden Grove	449	92988-1988	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.274041	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
667	667	Seal Beach Location	Seal Beach	\N	73917 Mills Court Apt. 276	\N	Seal Beach	419	92391-0739	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.279964	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
669	669	Tucson Location	Tucson	\N	01990 Weber Cape Apt. 846	\N	Tucson	416	20963	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.29202	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
671	671	Evansville Location	Evansville	\N	14914 Holden Isle	\N	Evansville	452	91831-8062	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.304109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
672	672	Rolling Hills Location	Rolling Hills	\N	49033 Lobby	\N	Rolling Hills	449	98206-2912	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.307512	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
673	673	Hope Location	Hope	\N	26084 Department 64-B	\N	Hope	438	57826-6822	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.310323	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
675	675	Lake Forest Location	Lake Forest	\N	43757 Floor 94	\N	Lake Forest	415	87028-4623	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.316217	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
676	676	San Mateo Location	San Mateo	\N	62482 Slip Q	\N	San Mateo	\N	44602-5727	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.318754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
678	678	Diamond Bar Location	Diamond Bar	\N	65514 Daren Station	\N	Diamond Bar	459	97213	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.325012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
680	680	San Dimas Location	San Dimas	\N	59251 Shanna Shoals	\N	San Dimas	\N	22659	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.331024	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
682	682	Mentor Location	Mentor	\N	06325 Delmer Plains	\N	Mentor	416	86319	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.351971	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
684	684	Fort Wayne Location	Fort Wayne	\N	17994 Department K	\N	Fort Wayne	461	59303	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.361384	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
685	685	Garden Grove Location	Garden Grove	\N	81128 Harber Manor #078	\N	Garden Grove	447	92764-3966	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.370456	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
687	687	La Puente Location	La Puente	\N	36207 King Turnpike Apt. 138	\N	La Puente	417	23557	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.382171	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
688	688	El Segundo Location	El Segundo	\N	86308 Ola Causeway	\N	El Segundo	459	41905	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.384891	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
690	690	Lima Location	Lima	\N	64372 Ila Falls	\N	Lima	444	04280	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.400209	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
691	691	Thousand Oaks Location	Thousand Oaks	\N	65787 Roma Plains Apt. 629	\N	Thousand Oaks	423	89998	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.402916	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
693	693	Indio Location	Indio	\N	37068 Nicolas Islands Suite 439	\N	Indio	427	16872	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.412379	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
694	694	Lodi Location	Lodi	\N	24195 Toy Fall	\N	Lodi	443	41830	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.418367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
696	696	Temecula Location	Temecula	\N	54569 Price Summit	\N	Temecula	417	57695	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.424401	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
697	697	San Mateo Location	San Mateo	\N	95176 Apartment W	\N	San Mateo	426	65375-6843	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.430676	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2030	2030	La Mirada Location	La Mirada	\N	06882 Fay Ville	\N	La Mirada	423	87503-2602	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.094526	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
699	699	Kettering Location	Kettering	\N	06264 Hackett Coves Suite 266	\N	Kettering	464	75031	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.442638	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
701	701	Tuscaloosa Location	Tuscaloosa	\N	98635 McGlynn Flat Apt. 055	\N	Tuscaloosa	414	02806	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.454463	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
703	703	Tuscaloosa Location	Tuscaloosa	\N	14596 Zboncak Light #511	\N	Tuscaloosa	425	86812-6456	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.466257	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
704	704	El Segundo Location	El Segundo	\N	92638 Kelsie Union Suite 839	\N	El Segundo	422	50707-4469	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.472112	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
706	706	Huntington Beach Location	Huntington Beach	\N	96292 Crooks Walks Apt. 917	\N	Huntington Beach	433	52329-8280	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.480881	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
708	708	Fontana Location	Fontana	\N	57218 Lot 7-A	\N	Fontana	455	88122-1399	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.48695	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
709	709	Cerritos Location	Cerritos	\N	37131 Breanne Mount	\N	Cerritos	\N	32326-4591	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.490445	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
711	711	Laguna Hills Location	Laguna Hills	\N	97646 Alejandrin Mountains Apt. 253	\N	Laguna Hills	423	19154-5670	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.502784	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
713	713	Lakewood Location	Lakewood	\N	40549 Baumbach Squares	\N	Lakewood	463	03293	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.51136	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
714	714	Decatur Location	Decatur	\N	31286 Simonis Course Apt. 488	\N	Decatur	460	62305	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.514558	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
715	715	Terre Haute Location	Terre Haute	\N	37246 Floor 10	\N	Terre Haute	\N	02532-4484	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.520527	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
717	717	Lodi Location	Lodi	\N	97686 Giovani Islands #042	\N	Lodi	\N	92922-8681	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.526678	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
719	719	Phoenix Location	Phoenix	\N	89475 Swaniawski Plains	\N	Phoenix	416	85737	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.538584	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
720	720	Hollister Location	Hollister	\N	05579 Ena Alley	\N	Hollister	456	69435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.541379	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
721	721	Sierra Madre Location	Sierra Madre	\N	67134 Triston Fields	\N	Sierra Madre	429	37425	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.544795	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
723	723	Corona Location	Corona	\N	77312 Hyatt Ridges	\N	Corona	448	23327	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.556746	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
724	724	Alhambra Location	Alhambra	\N	84564 Andres Trafficway	\N	Alhambra	416	19760	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.559473	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
726	726	Fontana Location	Fontana	\N	63912 Cronin Junctions	\N	Fontana	458	85238	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.565454	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
727	727	Pico Rivera Location	Pico Rivera	\N	87827 Mertz Roads Suite 174	\N	Pico Rivera	432	85979-9731	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.575039	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
729	729	Forrest City Location	Forrest City	\N	70823 Turcotte Underpass Apt. 336	\N	Forrest City	459	28376	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.583904	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
731	731	North Little Rock Location	North Little Rock	\N	32620 Paucek Extensions	\N	North Little Rock	\N	81720-4061	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.588866	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
732	732	Pico Rivera Location	Pico Rivera	\N	97486 Basement	\N	Pico Rivera	446	16902	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.591108	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
734	734	Jeffersontown Location	Jeffersontown	\N	55093 Cole Burgs Suite 844	\N	Jeffersontown	461	06022-9670	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.596124	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
736	736	Indio Location	Indio	\N	85588 Julia Ridge #105	\N	Indio	\N	93335	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.602405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
737	737	Lexington Location	Lexington	\N	29158 Batz Radial	\N	Lexington	\N	71780	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.605123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
739	739	Sitka Location	Sitka	\N	23437 Dwight Mills Apt. 288	\N	Sitka	425	86405	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.611402	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
740	740	Bellflower Location	Bellflower	\N	71016 Ayla Terrace #438	\N	Bellflower	438	04585-6558	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.615502	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
741	741	Toledo Location	Toledo	\N	00631 Lot E	\N	Toledo	456	88126	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.618158	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
743	743	Whittier Location	Whittier	\N	68258 Pier E	\N	Whittier	453	61835	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.623301	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
745	745	Laguna Hills Location	Laguna Hills	\N	69669 Faye Turnpike	\N	Laguna Hills	442	78581	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.628581	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
746	746	Palos Verdes Estates Location	Palos Verdes Estates	\N	92834 Gino Village	\N	Palos Verdes Estates	465	46126	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.631123	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
748	748	Santa Ana Location	Santa Ana	\N	78150 Annette Centers	\N	Santa Ana	455	30457-6963	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.636278	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
749	749	San Clemente Location	San Clemente	\N	72928 Hilda Mission	\N	San Clemente	\N	29964-7939	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.638764	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
751	751	Tucson Location	Tucson	\N	47333 Department 25-C	\N	Tucson	440	68649-0278	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.643549	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
753	753	Stanton Location	Stanton	\N	75027 Department C	\N	Stanton	434	43120-8130	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.648698	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
754	754	Montgomery Location	Montgomery	\N	87458 Floor 0816	\N	Montgomery	462	40332-5201	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.65111	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
755	755	Gadsden Location	Gadsden	\N	80175 Erdman Street	\N	Gadsden	412	43142-6711	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.653668	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
757	757	La Puente Location	La Puente	\N	32800 Rosalind Burg	\N	La Puente	427	55910-9399	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.658749	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
758	758	San Clemente Location	San Clemente	\N	94050 Roob Forge	\N	San Clemente	420	16469-4769	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.661154	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
760	760	Santa Monica Location	Santa Monica	\N	74071 Otis Mills	\N	Santa Monica	\N	50102	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.671169	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
761	761	Valdez Location	Valdez	\N	64174 Wilderman Shoals	\N	Valdez	420	38793-6342	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.673484	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
763	763	Forrest City Location	Forrest City	\N	59885 Vivien Shoals Apt. 933	\N	Forrest City	425	75445	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.678511	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
765	765	Oxnard Location	Oxnard	\N	67725 Dario Branch	\N	Oxnard	\N	22696-9526	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.683508	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
766	766	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	47410 Ursula Squares	\N	Mentor-on-the-Lake	455	06567	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.685824	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
768	768	Evansville Location	Evansville	\N	32594 Hattie Avenue #843	\N	Evansville	416	70535-2469	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.691157	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
770	770	Calabasas Location	Calabasas	\N	06769 Schulist Park	\N	Calabasas	454	13753-7434	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.696177	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
771	771	Rolling Hills Estates Location	Rolling Hills Estates	\N	11444 McClure Parks #541	\N	Rolling Hills Estates	448	66708	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.698582	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
773	773	Agoura Hills Location	Agoura Hills	\N	80274 Kristian Ports	\N	Agoura Hills	\N	32169-9959	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.70354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
775	775	Monrovia Location	Monrovia	\N	21079 Durgan Street Suite 278	\N	Monrovia	412	15711	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.719577	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
776	776	Fontana Location	Fontana	\N	36698 Kessler Forest Apt. 547	\N	Fontana	444	14947-5171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.72228	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
778	778	Gulf Shores Location	Gulf Shores	\N	51453 Cordell Pines Apt. 819	\N	Gulf Shores	441	18511	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.731093	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
779	779	Elkhart Location	Elkhart	\N	33521 Bogan Plaza #499	\N	Elkhart	424	12209	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.73361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
781	781	Oakland Location	Oakland	\N	98345 Adonis Road #136	\N	Oakland	\N	63842-0625	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.739707	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
782	782	Demopolis Location	Demopolis	\N	89677 Corkery Port	\N	Demopolis	455	44210-8133	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.743259	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
784	784	Rancho Cordova Location	Rancho Cordova	\N	08993 Enrique Forges	\N	Rancho Cordova	416	37807-8071	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.749353	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
786	786	Louisville Location	Louisville	\N	54197 Hermann Ports	\N	Louisville	452	77565-6345	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.75543	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
788	788	Atwater Location	Atwater	\N	62651 Predovic River	\N	Atwater	449	36505	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.761472	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
790	790	Costa Mesa Location	Costa Mesa	\N	82246 Emilio Canyon Apt. 476	\N	Costa Mesa	433	17078	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.77348	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
791	791	Fontana Location	Fontana	\N	13772 Suzanne Meadows Suite 701	\N	Fontana	457	88524	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.779427	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
792	792	Oakland Location	Oakland	\N	53703 Upper	\N	Oakland	442	84521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.782392	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
794	794	Sitka Location	Sitka	\N	56414 Margaret Fork	\N	Sitka	430	63752-2986	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.787361	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
795	795	La Mirada Location	La Mirada	\N	27850 Elmira Streets	\N	La Mirada	442	27690-0395	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.789813	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
797	797	Sitka Location	Sitka	\N	82663 Champlin Cape	\N	Sitka	449	81932	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.79503	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
798	798	Mobile Location	Mobile	\N	81065 Herminio Burgs	\N	Mobile	461	73257-3090	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.797524	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
800	800	Irvine Location	Irvine	\N	45707 Effertz Run	\N	Irvine	450	18543-3291	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.802576	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
801	801	Walnut Location	Walnut	\N	64544 McLaughlin Junctions	\N	Walnut	451	19858	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.805098	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
803	803	Tuskegee Location	Tuskegee	\N	88791 Tate Shoals	\N	Tuskegee	454	32483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.810088	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
804	804	Tucson Location	Tucson	\N	16601 Daron Drive Apt. 566	\N	Tucson	\N	11193-9811	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.81274	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
806	806	Burbank Location	Burbank	\N	84073 Garrison Coves	\N	Burbank	448	95734	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.817608	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
807	807	Athens Location	Athens	\N	98363 Jackie Avenue #030	\N	Athens	446	01433-9807	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.820255	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
808	808	Avalon Location	Avalon	\N	37473 Lonny Passage	\N	Avalon	\N	69317	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.822744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
810	810	West Hollywood Location	West Hollywood	\N	30433 Susie Run	\N	West Hollywood	415	97654-3207	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.82758	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
812	812	Toledo Location	Toledo	\N	30956 Jose Row	\N	Toledo	412	51196	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.832519	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
813	813	Riverside Location	Riverside	\N	42360 Hillard Mews	\N	Riverside	416	86596	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.835022	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
815	815	Duarte Location	Duarte	\N	61234 Felicia Keys	\N	Duarte	446	76595-7030	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.839945	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
816	816	Santa Barbara Location	Santa Barbara	\N	22443 Braun Ranch Apt. 951	\N	Santa Barbara	441	49698-7218	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.842398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
818	818	Modesto Location	Modesto	\N	25883 Lubowitz Springs #331	\N	Modesto	463	82965	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.847202	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
820	820	Downey Location	Downey	\N	90622 Floor 727	\N	Downey	465	32183	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.855464	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
822	822	Blythe Location	Blythe	\N	93461 Bosco Spur Suite 700	\N	Blythe	440	63903-5069	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.860708	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
824	824	North Pole Location	North Pole	\N	00415 Howe Summit	\N	North Pole	415	17470	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.865852	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
825	825	San Luis Obispo Location	San Luis Obispo	\N	03428 Jasen Parkways #788	\N	San Luis Obispo	430	66765-7455	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.868436	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
827	827	Louisville Location	Louisville	\N	84345 Penthouse	\N	Louisville	426	85967	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.873569	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
828	828	Toledo Location	Toledo	\N	48572 Curt Ways	\N	Toledo	436	29909	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.875985	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
830	830	Lancaster Location	Lancaster	\N	68239 Quinton Court	\N	Lancaster	465	87019-6384	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.881016	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
831	831	Gardena Location	Gardena	\N	63581 Corrine Harbor	\N	Gardena	460	95313	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.883657	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
833	833	El Monte Location	El Monte	\N	93671 Fritsch Stravenue	\N	El Monte	450	61859	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.888743	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
834	834	Hidden Hills Location	Hidden Hills	\N	21301 Camren Ramp	\N	Hidden Hills	437	42979-2023	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.891165	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
836	836	Little Rock Location	Little Rock	\N	30604 Eleazar Run	\N	Little Rock	451	52813-4567	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.909487	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
838	838	Santa Ana Location	Santa Ana	\N	29365 Wolff Inlet #102	\N	Santa Ana	465	25681	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.916274	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
839	839	Rancho Cordova Location	Rancho Cordova	\N	14940 Armstrong Cliff #817	\N	Rancho Cordova	427	19372-0170	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.925746	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
841	841	Barrow Location	Barrow	\N	21122 Pier 5-E	\N	Barrow	425	36444-3479	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.931779	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
842	842	Fairfield Location	Fairfield	\N	45238 Schaefer Plaza	\N	Fairfield	412	26396-4813	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.934288	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
844	844	Bentonville Location	Bentonville	\N	68205 Ankunding Road #714	\N	Bentonville	433	90697-9787	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.940484	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
846	846	Rolling Hills Location	Rolling Hills	\N	89573 Josue Viaduct	\N	Rolling Hills	426	21383-0248	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.949889	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
847	847	Paducah Location	Paducah	\N	20070 Jalon Locks	\N	Paducah	443	77658-2483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.957219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
848	848	Fremont Location	Fremont	\N	58444 Marques Rest #597	\N	Fremont	\N	75968	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.959889	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
850	850	Monterey Location	Monterey	\N	08922 Will Overpass Apt. 136	\N	Monterey	453	00432-2029	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.967983	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
852	852	Buena Park Location	Buena Park	\N	05119 Basement	\N	Buena Park	412	87932	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.975511	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
853	853	Alameda Location	Alameda	\N	67265 Gerhold Overpass	\N	Alameda	432	23043-7509	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.978263	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
855	855	Long Beach Location	Long Beach	\N	71096 Kuhlman Route Apt. 623	\N	Long Beach	424	42504	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.98352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
856	856	Ontario Location	Ontario	\N	69931 Mayer Shoal	\N	Ontario	\N	63775-6506	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.986162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
858	858	South Pasadena Location	South Pasadena	\N	57603 Gilda Cape	\N	South Pasadena	416	09547-0367	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.990995	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
859	859	Oxnard Location	Oxnard	\N	28494 Wyman Villages	\N	Oxnard	432	04660	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.993502	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
861	861	Avalon Location	Avalon	\N	47847 Reilly Roads #641	\N	Avalon	\N	06233-1663	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:09.998555	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
862	862	Santa Barbara Location	Santa Barbara	\N	38746 Rosamond Loop Apt. 719	\N	Santa Barbara	457	14891	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.001738	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
864	864	Burbank Location	Burbank	\N	28482 Kris Vista Suite 796	\N	Burbank	444	45745-1084	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.006936	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
865	865	Cincinnati Location	Cincinnati	\N	60208 Lobby	\N	Cincinnati	438	21451-3436	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.009466	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
866	866	Indio Location	Indio	\N	53488 Emory Passage #204	\N	Indio	423	51771	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.012208	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
869	869	Redlands Location	Redlands	\N	63983 Breana Lights	\N	Redlands	415	40757-2559	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.025181	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
871	871	Bowling Green Location	Bowling Green	\N	63571 Jadon Fort	\N	Bowling Green	438	92517	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.0305	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
872	872	La Cañada Flintridge Location	La Cañada Flintridge	\N	74744 Markus Lodge #173	\N	La Cañada Flintridge	415	31319	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.033251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
874	874	West Covina Location	West Covina	\N	01506 Emard Views	\N	West Covina	447	27856-0506	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.03854	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
876	876	Lynwood Location	Lynwood	\N	32438 Slip 31-E	\N	Lynwood	443	11825	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.043906	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
877	877	Santa Monica Location	Santa Monica	\N	21030 Adams Via #614	\N	Santa Monica	452	10438	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.04658	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
879	879	Jonesboro Location	Jonesboro	\N	91170 Walker Mountains	\N	Jonesboro	439	79540	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.051799	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
880	880	Fresno Location	Fresno	\N	81290 Pier N	\N	Fresno	432	12874	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.054352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
882	882	Whittier Location	Whittier	\N	42295 Eryn Oval	\N	Whittier	425	04243	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.059396	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
883	883	Vincennes Location	Vincennes	\N	74401 Kirlin Way #632	\N	Vincennes	437	67681	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.071845	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
885	885	Duarte Location	Duarte	\N	85011 Spencer Centers Suite 668	\N	Duarte	434	71750-9124	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.082483	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
887	887	Hoover Location	Hoover	\N	47675 Luella Flats	\N	Hoover	422	15188	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.087775	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
888	888	West Memphis Location	West Memphis	\N	43430 Lubowitz Meadows #938	\N	West Memphis	\N	66754	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.090349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
889	889	Oxford Location	Oxford	\N	44822 Hills Ranch #179	\N	Oxford	462	90243-1534	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.092842	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
892	892	Kokomo Location	Kokomo	\N	26623 Kautzer Corner #096	\N	Kokomo	416	95665-6082	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.100409	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
893	893	Huntsville Location	Huntsville	\N	19378 Kunde Drive	\N	Huntsville	465	11195	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.103011	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
895	895	Gilbert Location	Gilbert	\N	32692 Abagail Summit Apt. 871	\N	Gilbert	418	27704-7785	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.108354	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
897	897	Blythe Location	Blythe	\N	64723 Runolfsdottir Canyon #908	\N	Blythe	460	80972-4942	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.113573	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
898	898	Laguna Beach Location	Laguna Beach	\N	69606 Floor 15	\N	Laguna Beach	450	28254	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.116396	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
900	900	Hollywood Location	Hollywood	\N	49302 Front	\N	Hollywood	454	99102-9689	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.12415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
901	901	Santa Barbara Location	Santa Barbara	\N	59664 Floor 85	\N	Santa Barbara	425	03890-8320	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.12678	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
903	903	Rancho Cordova Location	Rancho Cordova	\N	34304 Hansen Plaza #734	\N	Rancho Cordova	429	84276-7528	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.132859	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
905	905	Monterey Park Location	Monterey Park	\N	61748 Prosacco Lodge Apt. 180	\N	Monterey Park	447	30440-5178	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.142349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
907	907	Valencia Location	Valencia	\N	82139 Ryan Squares	\N	Valencia	\N	51804	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.14845	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
908	908	Agoura Hills Location	Agoura Hills	\N	88572 Cameron Road	\N	Agoura Hills	434	49407-7767	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.150893	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
910	910	Temple City Location	Temple City	\N	39757 Damien Freeway Apt. 826	\N	Temple City	463	06413	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.172502	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
911	911	Rancho Cordova Location	Rancho Cordova	\N	90886 Mossie Estates	\N	Rancho Cordova	458	65462-9684	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.175258	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
913	913	Corona Location	Corona	\N	04937 Kihn Cliffs Suite 284	\N	Corona	430	89132	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.182156	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
915	915	Frankfort Location	Frankfort	\N	02766 Cora Pike	\N	Frankfort	414	56519-8018	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.202074	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
916	916	Stockton Location	Stockton	\N	55916 Juana Junctions	\N	Stockton	424	04408	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.2051	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
917	917	Carson Location	Carson	\N	42387 Reilly Drive	\N	Carson	436	75022-6424	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.208802	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
919	919	Canton Location	Canton	\N	40039 Lesch Plain	\N	Canton	456	51999-3288	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.220161	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
920	920	Simi Valley Location	Simi Valley	\N	12222 Waelchi Mount	\N	Simi Valley	448	81124-6563	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.223166	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
922	922	Tok Location	Tok	\N	40233 Eileen Estate	\N	Tok	455	59803	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.232917	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
923	923	Rosemead Location	Rosemead	\N	20254 Greenholt Light	\N	Rosemead	420	70543-7863	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.238209	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
925	925	Rohnert Park Location	Rohnert Park	\N	05203 Dach Square	\N	Rohnert Park	424	63229-5612	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.250292	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
926	926	Gary Location	Gary	\N	66168 Arielle Well	\N	Gary	445	41136-3304	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.257012	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
928	928	Paducah Location	Paducah	\N	07327 Rowland Knolls Apt. 611	\N	Paducah	461	55674-7630	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.26528	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
930	930	Stockton Location	Stockton	\N	07489 Luther Roads	\N	Stockton	419	16519	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.280405	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
931	931	Huntington Park Location	Huntington Park	\N	62759 Beer Inlet	\N	Huntington Park	413	76635	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.287324	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
933	933	El Segundo Location	El Segundo	\N	73426 Demarco Union Apt. 258	\N	El Segundo	457	33226	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.29994	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
935	935	Nogales Location	Nogales	\N	58712 Gilberto Roads	\N	Nogales	430	67242-9789	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.311175	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
936	936	Middletown Location	Middletown	\N	93747 Douglas Expressway	\N	Middletown	427	08302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.313822	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
937	937	Garden Grove Location	Garden Grove	\N	98890 Huels Fort	\N	Garden Grove	454	55847-4854	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.322912	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
939	939	Texarkana Location	Texarkana	\N	42210 Christy Ridges #567	\N	Texarkana	441	89273-9406	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.328961	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
941	941	Middletown Location	Middletown	\N	35935 Dibbert Walks	\N	Middletown	449	70219	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.335023	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
942	942	Tok Location	Tok	\N	40380 Floor 5	\N	Tok	451	14214-5756	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.337743	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
944	944	Bowling Green Location	Bowling Green	\N	16062 Merle Loaf #866	\N	Bowling Green	413	32521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.354312	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
945	945	Barrow Location	Barrow	\N	15606 Bruen Summit	\N	Barrow	\N	56343	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.359107	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
946	946	Commerce Location	Commerce	\N	78118 Hettinger Loop	\N	Commerce	427	73641-8472	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.361753	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
948	948	San Luis Obispo Location	San Luis Obispo	\N	84772 Lobby	\N	San Luis Obispo	465	58935	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.368344	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
949	949	Hoover Location	Hoover	\N	14945 Gussie Vista	\N	Hoover	418	73864-6287	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.377343	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
951	951	Indio Location	Indio	\N	88689 Casper Green	\N	Indio	420	99641	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.38919	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
953	953	Moreno Valley Location	Moreno Valley	\N	83911 Clovis Crest	\N	Moreno Valley	453	88917	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.398823	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
954	954	Bellflower Location	Bellflower	\N	55604 Madie Wells Suite 685	\N	Bellflower	416	72350-0214	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.426589	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
956	956	Lake Forest Location	Lake Forest	\N	18558 Shanna Forks	\N	Lake Forest	412	67570	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.435644	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
958	958	Lexington Location	Lexington	\N	69254 Becker Mountain #852	\N	Lexington	451	48649	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.445689	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
959	959	Chino Location	Chino	\N	16170 Halvorson Rest	\N	Chino	430	75450	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.461117	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
961	961	Salinas Location	Salinas	\N	57881 Johathan Center	\N	Salinas	\N	60638	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.467739	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
963	963	Phoenix Location	Phoenix	\N	29371 Oberbrunner Groves Suite 030	\N	Phoenix	416	70719-4958	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.491219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
965	965	Bakersfield Location	Bakersfield	\N	84871 Gottlieb Summit #095	\N	Bakersfield	444	76245	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.503323	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
967	967	Richmond Location	Richmond	\N	92900 Macejkovic Junctions	\N	Richmond	446	95795	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.521376	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
968	968	Crown Point Location	Crown Point	\N	95163 Schimmel Flat Apt. 491	\N	Crown Point	433	62401	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.527825	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
970	970	Fort Wayne Location	Fort Wayne	\N	96924 Margret Island	\N	Fort Wayne	442	34812-5699	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.552546	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
972	972	North Little Rock Location	North Little Rock	\N	48387 Braun View #026	\N	North Little Rock	\N	59562	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.569918	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
973	973	Akron Location	Akron	\N	95382 Welch Place Apt. 863	\N	Akron	437	72349-7690	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.58236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
974	974	Torrance Location	Torrance	\N	67249 Suite 91-I	\N	Torrance	422	95409	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.588378	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
976	976	Los Angeles Location	Los Angeles	\N	84643 Terrill Field Apt. 522	\N	Los Angeles	445	59866-7498	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.600472	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
978	978	Demopolis Location	Demopolis	\N	99631 Wyman Mount #349	\N	Demopolis	450	87111-4789	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.616512	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
979	979	Murray Location	Murray	\N	13692 Lobby	\N	Murray	433	40837-5495	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.619087	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
981	981	Riverside Location	Riverside	\N	52104 Keebler Mountain	\N	Riverside	\N	23261	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.624384	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
982	982	Youngstown Location	Youngstown	\N	69754 Kim Pass	\N	Youngstown	\N	16323-5203	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.626833	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
984	984	Sutter Creek Location	Sutter Creek	\N	94200 Apartment 76-G	\N	Sutter Creek	452	12382	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.631993	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
986	986	Bellflower Location	Bellflower	\N	83074 Lue Bridge	\N	Bellflower	427	64277-9017	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.637206	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
987	987	Berkeley Location	Berkeley	\N	46646 Glover Gateway Apt. 183	\N	Berkeley	418	26187	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.639776	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
989	989	Monrovia Location	Monrovia	\N	68758 Elsa Pines	\N	Monrovia	\N	72704	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.645113	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
990	990	Redondo Beach Location	Redondo Beach	\N	25662 Scotty Course Apt. 325	\N	Redondo Beach	429	65530-4047	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.647749	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
992	992	Gardena Location	Gardena	\N	23767 Tate Crescent	\N	Gardena	444	17470	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.653345	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
994	994	Rolling Hills Estates Location	Rolling Hills Estates	\N	78879 Wisozk Trafficway Apt. 910	\N	Rolling Hills Estates	438	76585	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.658516	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
995	995	Tucson Location	Tucson	\N	98656 Isaiah Mill	\N	Tucson	423	74407-9416	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.661009	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
997	997	Oro Valley Location	Oro Valley	\N	79616 Lemuel Gardens	\N	Oro Valley	448	34226-5711	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.665882	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
998	998	Daly City Location	Daly City	\N	19035 Rear	\N	Daly City	424	82517	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.668363	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1000	1000	Blythe Location	Blythe	\N	85010 Cecile Hills	\N	Blythe	463	77345	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.673423	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1001	1001	Villa Park Location	Villa Park	\N	13396 Kessler Brook #444	\N	Villa Park	441	35405	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.676074	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1003	1003	North Pole Location	North Pole	\N	30066 Kihn Lodge Suite 712	\N	North Pole	437	51409-4784	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.681238	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1004	1004	Sonoma Location	Sonoma	\N	13532 Building Z	\N	Sonoma	\N	98353	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.683874	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1006	1006	Ashland Location	Ashland	\N	20847 Sasha Keys	\N	Ashland	425	61151-7726	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.688831	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1008	1008	South Bend Location	South Bend	\N	92126 Leannon Road	\N	South Bend	416	84082-5668	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.697571	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1009	1009	Signal Hill Location	Signal Hill	\N	75427 Birdie Tunnel	\N	Signal Hill	462	40435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.700294	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1011	1011	Temple City Location	Temple City	\N	34688 Nicola Junction Suite 483	\N	Temple City	460	79615-6218	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.705399	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1012	1012	La Mirada Location	La Mirada	\N	16193 Sawayn Mountains Apt. 490	\N	La Mirada	440	60293-9914	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.708017	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1014	1014	Nenana Location	Nenana	\N	27440 Fay Courts #864	\N	Nenana	437	99043	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.713215	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1016	1016	Bradbury Location	Bradbury	\N	25196 Space G	\N	Bradbury	456	71589-9175	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.718441	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1017	1017	Simi Valley Location	Simi Valley	\N	31448 Melyna Overpass #882	\N	Simi Valley	\N	68365-0290	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.72119	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1019	1019	Santa Barbara Location	Santa Barbara	\N	03760 Al Forest #475	\N	Santa Barbara	443	21611-2544	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.726249	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1021	1021	Santa Rosa Location	Santa Rosa	\N	29682 Boehm Village	\N	Santa Rosa	453	63273-8857	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.731999	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1022	1022	Palo Alto Location	Palo Alto	\N	76748 Jerde Drive	\N	Palo Alto	448	70943-6832	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.736088	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1024	1024	Visalia Location	Visalia	\N	22802 Trailer P	\N	Visalia	\N	00650	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.759498	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1025	1025	Pasadena Location	Pasadena	\N	31926 Swift Corner	\N	Pasadena	445	36073-2762	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.762526	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1026	1026	Vallejo Location	Vallejo	\N	57571 Brakus Forges	\N	Vallejo	451	64442	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.765133	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1028	1028	South Pasadena Location	South Pasadena	\N	18538 Floor 73	\N	South Pasadena	433	24401-3480	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.771185	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1030	1030	Sitka Location	Sitka	\N	57242 Parisian Club	\N	Sitka	454	98469	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.777146	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1031	1031	San Gabriel Location	San Gabriel	\N	18079 Terry Trafficway	\N	San Gabriel	458	42353	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.780809	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1033	1033	Chandler Location	Chandler	\N	40503 Department W	\N	Chandler	423	64205-8746	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.786836	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1034	1034	Vernon Location	Vernon	\N	35145 Barton Spring	\N	Vernon	\N	41919	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.792849	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1035	1035	Wynne Location	Wynne	\N	21643 Lang Parks	\N	Wynne	422	14846-4438	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.795314	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1037	1037	Demopolis Location	Demopolis	\N	25523 DuBuque Cape	\N	Demopolis	458	72583-5478	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.801387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1039	1039	Mission Viejo Location	Mission Viejo	\N	87575 Nolan Harbor #521	\N	Mission Viejo	445	59110-3309	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.807449	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1040	1040	West Memphis Location	West Memphis	\N	52275 Rodolfo Unions	\N	West Memphis	452	26208-7961	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.810962	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1042	1042	Bell Location	Bell	\N	55923 Catharine Greens	\N	Bell	454	41983-6189	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.816938	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1043	1043	Maywood Location	Maywood	\N	35669 Hayes Stravenue Apt. 332	\N	Maywood	456	05233-3081	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.819407	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1045	1045	Berkeley Location	Berkeley	\N	38825 Basement	\N	Berkeley	464	97506-7989	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.824462	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1046	1046	Thousand Oaks Location	Thousand Oaks	\N	05894 Heaney Corner	\N	Thousand Oaks	440	02601	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.826985	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1048	1048	Montebello Location	Montebello	\N	07771 Office	\N	Montebello	\N	61762-3994	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.832145	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1051	1051	San Diego Location	San Diego	\N	60655 Kuhn Corners	\N	San Diego	456	80833	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.846841	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1053	1053	Modesto Location	Modesto	\N	98151 Torrance Circle Suite 765	\N	Modesto	422	39495-2178	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.854067	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1055	1055	Monrovia Location	Monrovia	\N	98184 Hangar E	\N	Monrovia	\N	24008-7068	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.859537	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1056	1056	Temecula Location	Temecula	\N	95710 Sim Overpass	\N	Temecula	\N	00586-4704	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.862392	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1057	1057	Lakewood Location	Lakewood	\N	06599 Hamill Corners	\N	Lakewood	440	00477	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.864932	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1059	1059	City of Industry Location	City of Industry	\N	21994 Barton Viaduct	\N	City of Industry	444	39680	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.870003	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1061	1061	Sahuarita Location	Sahuarita	\N	27150 Matt Forges #190	\N	Sahuarita	422	12378	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.875159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1062	1062	Glendale Location	Glendale	\N	26338 Joesph Tunnel	\N	Glendale	434	73048-6000	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.877661	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1064	1064	Hidden Hills Location	Hidden Hills	\N	62087 Pfeffer Loop	\N	Hidden Hills	436	72475	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.882811	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1065	1065	Yuma Location	Yuma	\N	69622 Schmidt Trafficway	\N	Yuma	438	16884-2421	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.885408	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1067	1067	Fairfield Location	Fairfield	\N	46688 Libby Throughway	\N	Fairfield	438	09704	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.901951	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1069	1069	Huntington Beach Location	Huntington Beach	\N	65174 Elsa Unions #565	\N	Huntington Beach	429	41492-1663	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.91217	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1071	1071	Yuma Location	Yuma	\N	19897 Considine Run	\N	Yuma	456	64285	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.91951	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1072	1072	Mentor-on-the-Lake Location	Mentor-on-the-Lake	\N	89698 Renner Ferry Suite 325	\N	Mentor-on-the-Lake	433	38410	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.923165	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1074	1074	Canton Location	Canton	\N	75035 Francisco Locks	\N	Canton	412	10623-1991	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.930785	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1075	1075	Burbank Location	Burbank	\N	89045 Estell Crossing	\N	Burbank	460	66960	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.934241	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1077	1077	Pasadena Location	Pasadena	\N	15342 Esmeralda Path Apt. 318	\N	Pasadena	463	35591-1483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.939228	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1079	1079	Whittier Location	Whittier	\N	17927 Runolfsdottir Drive	\N	Whittier	436	42787	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.944392	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1080	1080	Parma Location	Parma	\N	58072 Stiedemann Port #746	\N	Parma	418	97985	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.946929	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1082	1082	Decatur Location	Decatur	\N	18212 Dietrich Club Suite 183	\N	Decatur	429	28953-3143	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.952079	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1083	1083	Seal Beach Location	Seal Beach	\N	35621 Fadel Meadows Suite 632	\N	Seal Beach	457	38802-5476	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.95491	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1085	1085	Huntington Beach Location	Huntington Beach	\N	32369 Beier Trail Apt. 832	\N	Huntington Beach	419	17103	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.967161	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1087	1087	Seal Beach Location	Seal Beach	\N	67240 Bashirian Ridges Suite 963	\N	Seal Beach	\N	58133-1961	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.974688	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1089	1089	Zanesville Location	Zanesville	\N	03028 Kunde Crossing	\N	Zanesville	416	37437	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.979946	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1090	1090	Orange Location	Orange	\N	53294 Sharon Curve #414	\N	Orange	451	44561-4283	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.982565	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1092	1092	Tuskegee Location	Tuskegee	\N	02752 Floor 89	\N	Tuskegee	414	30869-0765	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.988081	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1093	1093	Escondido Location	Escondido	\N	28360 Allie Terrace Suite 706	\N	Escondido	417	13356	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.991349	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1095	1095	Malibu Location	Malibu	\N	03973 Funk Locks	\N	Malibu	412	10106	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:10.99744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1097	1097	Lynwood Location	Lynwood	\N	34146 Kasandra Unions	\N	Lynwood	\N	21340-7658	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.003449	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1098	1098	Covington Location	Covington	\N	19776 Jany Drives Suite 300	\N	Covington	444	54770	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.009538	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1099	1099	Huntsville Location	Huntsville	\N	86270 Hilda Tunnel	\N	Huntsville	424	72559-2955	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.013929	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1101	1101	Escondido Location	Escondido	\N	39247 Lina Run	\N	Escondido	428	19711-2854	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.024889	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1103	1103	City of Industry Location	City of Industry	\N	09904 Lueilwitz Brooks #626	\N	City of Industry	446	23908-4920	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.030741	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1105	1105	Santa Clarita Location	Santa Clarita	\N	35831 Hangar M	\N	Santa Clarita	434	81311-6337	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.03644	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1106	1106	Hollywood Location	Hollywood	\N	39629 Hermann Skyway #180	\N	Hollywood	444	62987	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.04581	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1108	1108	Ketchikan Location	Ketchikan	\N	34398 Mia Islands #017	\N	Ketchikan	464	63879	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.05784	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1109	1109	Fayetteville Location	Fayetteville	\N	32950 Office	\N	Fayetteville	432	48214	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.062682	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1111	1111	Bowling Green Location	Bowling Green	\N	84912 Alfred Rest #553	\N	Bowling Green	451	73992-9622	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.070838	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1112	1112	Vincennes Location	Vincennes	\N	33521 Corwin Centers	\N	Vincennes	453	08635	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.076826	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1114	1114	La Puente Location	La Puente	\N	95491 Edwina Harbor Suite 300	\N	La Puente	437	72999	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.082449	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1116	1116	Culver City Location	Culver City	\N	62374 Kaleigh Falls Apt. 843	\N	Culver City	464	52813-8017	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.104878	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1118	1118	Lomita Location	Lomita	\N	51098 Strosin Mills #365	\N	Lomita	\N	09012-4586	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.112267	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1119	1119	Murrieta Location	Murrieta	\N	96702 Floor 35	\N	Murrieta	430	88823	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.114801	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1121	1121	Redlands Location	Redlands	\N	68827 Front	\N	Redlands	438	58821-1224	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.130856	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1122	1122	West Memphis Location	West Memphis	\N	35695 Floor 164	\N	West Memphis	417	97748	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.136809	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1123	1123	Torrance Location	Torrance	\N	31739 Kirlin Valley	\N	Torrance	447	15521	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.139452	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1125	1125	San Mateo Location	San Mateo	\N	14528 Claudia Squares Suite 062	\N	San Mateo	431	06278	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.154271	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1126	1126	Moraga Location	Moraga	\N	01854 Wanda Shoals	\N	Moraga	439	32548	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.159921	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1128	1128	Seal Beach Location	Seal Beach	\N	67963 Wunsch Mission	\N	Seal Beach	432	09663	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.171938	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1130	1130	Stockton Location	Stockton	\N	67290 Pier 7-H	\N	Stockton	417	62649	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.182814	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1131	1131	Cincinnati Location	Cincinnati	\N	08174 Floor 57	\N	Cincinnati	\N	57291-5403	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.186809	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1132	1132	San Diego Location	San Diego	\N	79246 Eloy Loaf	\N	San Diego	448	81650-6205	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.190835	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1134	1134	La Cañada Flintridge Location	La Cañada Flintridge	\N	54998 Pietro Prairie	\N	La Cañada Flintridge	418	60320-6588	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.202441	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1136	1136	Norwalk Location	Norwalk	\N	94398 Hickle Corner Suite 938	\N	Norwalk	\N	63441-0659	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.211007	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1137	1137	Baldwin Park Location	Baldwin Park	\N	29741 Ruth Loop	\N	Baldwin Park	443	35590	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.220122	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1140	1140	Monterey Location	Monterey	\N	36466 Tad Track	\N	Monterey	413	41241	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.238828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1141	1141	Lafayette Location	Lafayette	\N	60213 Dayton Ridges #852	\N	Lafayette	432	35911	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.244888	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1143	1143	Gary Location	Gary	\N	99910 Mozelle Fort	\N	Gary	413	72460-1178	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.262357	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1144	1144	Valparaiso Location	Valparaiso	\N	94838 Charlotte Mission	\N	Valparaiso	428	00480	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.273612	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1146	1146	Carson Location	Carson	\N	40057 Wyman Overpass Apt. 082	\N	Carson	453	42693-4840	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.280344	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1147	1147	Corona Location	Corona	\N	24681 Trey Ridges	\N	Corona	450	77766	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.282961	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1149	1149	Yorba Linda Location	Yorba Linda	\N	71453 Toy Manor	\N	Yorba Linda	413	65567	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.28889	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1151	1151	Compton Location	Compton	\N	11601 Hane Motorway	\N	Compton	\N	10659-9893	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.295104	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1152	1152	Stockton Location	Stockton	\N	36474 Jolie Gateway Suite 214	\N	Stockton	\N	10435	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.298375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1153	1153	Homer Location	Homer	\N	78000 Keshawn Mountains Apt. 724	\N	Homer	443	60566	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.300905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1155	1155	Auburn Location	Auburn	\N	22841 Name Terrace	\N	Auburn	427	38938	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.307067	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1156	1156	Seal Beach Location	Seal Beach	\N	96368 Evie Neck	\N	Seal Beach	446	55447	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.310504	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1158	1158	Seward Location	Seward	\N	87196 Hintz Fields Suite 986	\N	Seward	452	86916-9456	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.319176	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1159	1159	Irvine Location	Irvine	\N	53199 Space S	\N	Irvine	418	67992-7918	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.322622	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1161	1161	Auburn Location	Auburn	\N	80731 Hallie Hills	\N	Auburn	455	26726-3595	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.328581	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1162	1162	Lafayette Location	Lafayette	\N	80513 Morissette Route	\N	Lafayette	425	71417-2981	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.33293	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1165	1165	Santa Ana Location	Santa Ana	\N	27866 Schamberger Court	\N	Santa Ana	416	89131	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.338125	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1166	1166	Monterey Location	Monterey	\N	27259 Christelle Hill Suite 429	\N	Monterey	429	15426-8763	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.340697	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1168	1168	Hollywood Location	Hollywood	\N	63082 Heller Keys	\N	Hollywood	448	00245	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.345915	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1169	1169	Alhambra Location	Alhambra	\N	23494 Ebert Haven Suite 020	\N	Alhambra	440	15940	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.348494	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1171	1171	Fairbanks Location	Fairbanks	\N	42946 Department 09-E	\N	Fairbanks	457	10145-9486	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.353805	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1174	1174	Owensboro Location	Owensboro	\N	71424 Office	\N	Owensboro	430	44929	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.358927	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1175	1175	Costa Mesa Location	Costa Mesa	\N	79552 Abigail Streets Apt. 368	\N	Costa Mesa	424	30139-1648	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.361524	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1177	1177	Beverly Hills Location	Beverly Hills	\N	70910 Cruickshank Knolls	\N	Beverly Hills	414	73608	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.366676	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1178	1178	Oxford Location	Oxford	\N	10023 Department 24-C	\N	Oxford	424	74768	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.369506	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1180	1180	San Francisco Location	San Francisco	\N	51693 Von Springs	\N	San Francisco	\N	18078	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.375178	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1181	1181	Dothan Location	Dothan	\N	48782 Aufderhar Knolls	\N	Dothan	460	65034-2031	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.377692	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1183	1183	Bradbury Location	Bradbury	\N	63971 Basement	\N	Bradbury	461	38690	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.382834	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1184	1184	Whittier Location	Whittier	\N	39765 Bryana Meadows	\N	Whittier	465	25269	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.385423	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1186	1186	Sitka Location	Sitka	\N	45021 Crooks Fort	\N	Sitka	437	67476	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.390681	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1187	1187	Montgomery Location	Montgomery	\N	16543 Kane Lights	\N	Montgomery	451	31159-6526	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.393269	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1189	1189	Sierra Madre Location	Sierra Madre	\N	05076 Arnoldo Squares Suite 700	\N	Sierra Madre	418	10077	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.398464	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1191	1191	Hermosa Beach Location	Hermosa Beach	\N	95331 Barney Neck	\N	Hermosa Beach	415	84762-8483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.403487	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1193	1193	Simi Valley Location	Simi Valley	\N	33293 Bruen Trail	\N	Simi Valley	417	06153-5576	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.408777	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1194	1194	Akron Location	Akron	\N	41645 Dibbert Harbor Suite 756	\N	Akron	447	81882-4408	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.417439	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1196	1196	Columbus Location	Columbus	\N	04603 Marks Island	\N	Columbus	\N	31170-2763	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.424824	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1197	1197	Cypress Location	Cypress	\N	50449 Hipolito Plaza	\N	Cypress	447	12303	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.428821	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1198	1198	Zanesville Location	Zanesville	\N	31450 Hamill Rue #798	\N	Zanesville	447	07450-6745	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.432874	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1200	1200	Irwindale Location	Irwindale	\N	49550 Johathan Gardens Apt. 650	\N	Irwindale	455	71766	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.440843	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1202	1202	Burlingame Location	Burlingame	\N	29703 Stamm Plains Suite 604	\N	Burlingame	417	40994	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.447815	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1203	1203	Stockton Location	Stockton	\N	07602 Lot 82-B	\N	Stockton	448	88638	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.45181	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1205	1205	Birmingham Location	Birmingham	\N	65382 Ankunding Mill	\N	Birmingham	431	72040	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.459835	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1207	1207	Calabasas Location	Calabasas	\N	23024 Will Square	\N	Calabasas	424	21005	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.467814	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1208	1208	Forrest City Location	Forrest City	\N	62371 Willms Mount	\N	Forrest City	443	67360-4860	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.471838	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1209	1209	Selma Location	Selma	\N	18052 Abernathy Fields #596	\N	Selma	425	02951	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.475825	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1211	1211	Walnut Location	Walnut	\N	52483 Bernhard Knolls #382	\N	Walnut	426	43031-3547	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.491834	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1212	1212	Juneau Location	Juneau	\N	57277 Trailer 4-J	\N	Juneau	449	61883-5349	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.497815	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1214	1214	Escondido Location	Escondido	\N	60145 Doris Branch Suite 077	\N	Escondido	463	35924-9972	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.507857	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1216	1216	Calabasas Location	Calabasas	\N	72932 Willms Crossroad Suite 767	\N	Calabasas	422	50146	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.521828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1217	1217	Buena Park Location	Buena Park	\N	16589 Towne Ville	\N	Buena Park	446	55048-8884	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.525406	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1219	1219	Sierra Madre Location	Sierra Madre	\N	29781 Aileen Vista	\N	Sierra Madre	443	72693-4119	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.533605	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1220	1220	Cudahy Location	Cudahy	\N	92746 Ernser Crossing	\N	Cudahy	435	26910	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.536821	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1222	1222	Hermosa Beach Location	Hermosa Beach	\N	00888 Thurman Way	\N	Hermosa Beach	420	15304-5185	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.545153	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1224	1224	Culver City Location	Culver City	\N	70807 Basement	\N	Culver City	415	06835	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.555795	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1225	1225	Chandler Location	Chandler	\N	74771 Monique Walks #969	\N	Chandler	\N	68241-7751	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.55983	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1226	1226	Moreno Valley Location	Moreno Valley	\N	09560 Niko Pines	\N	Moreno Valley	419	03739-7951	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.563604	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1229	1229	Valdez Location	Valdez	\N	22562 Brooke Heights	\N	Valdez	448	37127-1332	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.577865	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1231	1231	Mesa Location	Mesa	\N	10619 Cole Lakes Suite 889	\N	Mesa	459	49048	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.585828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1232	1232	Downey Location	Downey	\N	31071 Weimann Ridges #167	\N	Downey	422	67652-9461	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.589828	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1234	1234	Pine Bluff Location	Pine Bluff	\N	07696 Jamarcus Lake Suite 026	\N	Pine Bluff	421	96207	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.597827	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1235	1235	Cerritos Location	Cerritos	\N	99177 Arnaldo Springs	\N	Cerritos	\N	54347	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.601821	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1237	1237	Beverly Hills Location	Beverly Hills	\N	58644 Zita Branch	\N	Beverly Hills	418	43568-1813	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.609838	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1239	1239	Oakland Location	Oakland	\N	72658 Side	\N	Oakland	441	36124	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.617216	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1240	1240	Santa Monica Location	Santa Monica	\N	02495 Sanford Path Apt. 467	\N	Santa Monica	452	21553-1268	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.620018	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1242	1242	Lima Location	Lima	\N	47663 Building 80	\N	Lima	454	27785-4607	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.633948	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1243	1243	Vallejo Location	Vallejo	\N	96823 Nitzsche Crossroad #666	\N	Vallejo	417	57789	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.636848	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1245	1245	Hermosa Beach Location	Hermosa Beach	\N	16333 Nicolas Way	\N	Hermosa Beach	423	61512-1356	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.642339	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1246	1246	Ashland Location	Ashland	\N	06524 Gracie Greens Suite 257	\N	Ashland	432	63327-0549	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.645044	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1248	1248	Homer Location	Homer	\N	67067 Lonny Pass	\N	Homer	\N	25490	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.65109	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1249	1249	Compton Location	Compton	\N	76231 Francesco Turnpike	\N	Compton	442	70882	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.653843	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1251	1251	Flagstaff Location	Flagstaff	\N	37551 Goldner Forge	\N	Flagstaff	444	61363	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.659183	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1252	1252	Newport Beach Location	Newport Beach	\N	03344 Floor 4	\N	Newport Beach	426	54444-6813	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.661787	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1254	1254	Vernon Location	Vernon	\N	09545 Bradtke Bridge	\N	Vernon	429	86667	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.667225	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1255	1255	Chandler Location	Chandler	\N	64165 Denesik Heights #280	\N	Chandler	443	09666	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.68448	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1257	1257	Two Rivers Location	Two Rivers	\N	47205 Adelle Springs Apt. 930	\N	Two Rivers	412	86315	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.695374	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1258	1258	Santa Ana Location	Santa Ana	\N	00255 Maxime Lodge	\N	Santa Ana	430	12320	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.700387	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1260	1260	Claremont Location	Claremont	\N	94655 Luettgen Causeway	\N	Claremont	452	86475-9346	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.705581	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1261	1261	Salinas Location	Salinas	\N	64011 Floor 2	\N	Salinas	449	07784	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.708197	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1263	1263	La Mirada Location	La Mirada	\N	38633 Alan Field	\N	La Mirada	421	26519-4307	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.713448	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1264	1264	Huntsville Location	Huntsville	\N	77054 Audra Plain	\N	Huntsville	\N	51605	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.716021	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1266	1266	Fairfield Location	Fairfield	\N	86942 Mireille Village	\N	Fairfield	437	31580-1129	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.72078	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1268	1268	Yuma Location	Yuma	\N	85005 Hyatt Run #061	\N	Yuma	426	72008-7339	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.725979	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1269	1269	El Monte Location	El Monte	\N	70385 Jamarcus Harbors #286	\N	El Monte	418	99094-0209	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.728573	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1270	1270	Elkhart Location	Elkhart	\N	44891 Jodie Spur	\N	Elkhart	440	46909	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.731168	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1272	1272	Tuskegee Location	Tuskegee	\N	37499 Lockman Burgs #581	\N	Tuskegee	453	71169	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.743809	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1274	1274	Columbus Location	Columbus	\N	99693 Declan Knoll	\N	Columbus	454	53980-6749	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.751197	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1275	1275	Kokomo Location	Kokomo	\N	14409 Carmela Manor Apt. 097	\N	Kokomo	422	79703-6065	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.755395	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1277	1277	Cincinnati Location	Cincinnati	\N	77970 Willms Throughway #900	\N	Cincinnati	442	10397	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.766413	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1278	1278	Temecula Location	Temecula	\N	89706 Aron Trail	\N	Temecula	421	86692	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.773508	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1280	1280	Covina Location	Covina	\N	50702 Orrin Plains	\N	Covina	464	08241-9733	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.784272	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1281	1281	Fremont Location	Fremont	\N	05303 Stamm Extensions	\N	Fremont	\N	80495-8547	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.786928	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1283	1283	Commerce Location	Commerce	\N	03668 Floor 2820	\N	Commerce	442	35957	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.791973	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1284	1284	Stanton Location	Stanton	\N	66014 Howell Estates #681	\N	Stanton	418	11149	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.79449	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1286	1286	Sutter Creek Location	Sutter Creek	\N	20124 Lobby	\N	Sutter Creek	465	99421-5664	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.809816	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1288	1288	Moreno Valley Location	Moreno Valley	\N	42556 Delphine Grove Suite 195	\N	Moreno Valley	432	21642	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.815867	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1289	1289	Norwalk Location	Norwalk	\N	00768 Wyman Haven	\N	Norwalk	452	63026-6014	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.822172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1291	1291	Yorba Linda Location	Yorba Linda	\N	80513 Demetris Expressway	\N	Yorba Linda	436	61627	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.829537	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1293	1293	Glendale Location	Glendale	\N	11575 Geo Road	\N	Glendale	460	25621-5204	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.835182	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1294	1294	Laguna Beach Location	Laguna Beach	\N	91164 Gaylord Well	\N	Laguna Beach	420	89295-4611	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.837871	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1296	1296	Orange Location	Orange	\N	90340 Hangar D	\N	Orange	421	11703-0996	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.843233	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1297	1297	Kokomo Location	Kokomo	\N	18016 Hackett Mews #774	\N	Kokomo	437	92077	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.846159	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1298	1298	Oxford Location	Oxford	\N	07821 Floor 2	\N	Oxford	434	16371-0706	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.848683	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1300	1300	Bessemer Location	Bessemer	\N	48441 Sandy Club	\N	Bessemer	426	29035-1341	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.855139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1302	1302	Villa Park Location	Villa Park	\N	19008 Dayana Drive	\N	Villa Park	429	40958-7762	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.887547	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1303	1303	South Gate Location	South Gate	\N	95258 Summer Rapid #376	\N	South Gate	451	19802	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.890688	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1305	1305	San Diego Location	San Diego	\N	06037 Rutherford Ridge	\N	San Diego	461	31059	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.900305	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1307	1307	Kent Location	Kent	\N	60885 Floor 352	\N	Kent	\N	84682-7080	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.915672	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1308	1308	Mesa Location	Mesa	\N	90057 Mckayla Streets #523	\N	Mesa	427	84224	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.918276	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1309	1309	Duarte Location	Duarte	\N	42860 Schinner Centers	\N	Duarte	420	91386	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.924025	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1310	1310	Montgomery Location	Montgomery	\N	36943 Katlynn Locks	\N	Montgomery	\N	95969	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.926739	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1312	1312	Little Rock Location	Little Rock	\N	12420 Lonnie Garden #446	\N	Little Rock	429	64789-2317	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.932834	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1313	1313	Tucson Location	Tucson	\N	35800 Vicky Turnpike #633	\N	Tucson	430	57083	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.936309	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2033	2033	Bentonville Location	Bentonville	\N	35189 Hangar O	\N	Bentonville	458	77566-4794	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:19.10926	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1315	1315	Selma Location	Selma	\N	56509 Smitham Land Apt. 475	\N	Selma	412	63833-2520	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.942398	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1317	1317	Delta Junction Location	Delta Junction	\N	85483 Melody Trail Apt. 252	\N	Delta Junction	435	34758	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.948479	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1319	1319	Laguna Beach Location	Laguna Beach	\N	86990 Cyril Run #848	\N	Laguna Beach	\N	50762-6106	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.954288	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1320	1320	Tucson Location	Tucson	\N	63736 Hegmann Road	\N	Tucson	\N	91186	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.956811	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1322	1322	Rohnert Park Location	Rohnert Park	\N	74374 Jolie Skyway	\N	Rohnert Park	\N	98691	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.962677	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1323	1323	Temple City Location	Temple City	\N	11685 Rogahn Forges	\N	Temple City	\N	05330	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.966032	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1325	1325	Signal Hill Location	Signal Hill	\N	63628 Lily Station	\N	Signal Hill	427	12364	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.972106	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1327	1327	Claremont Location	Claremont	\N	78697 Wolf Crest Apt. 115	\N	Claremont	438	25201	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.978174	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1328	1328	Marana Location	Marana	\N	25254 Dan Village Apt. 964	\N	Marana	458	09274	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.980859	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1329	1329	La Verne Location	La Verne	\N	55284 Celestine Landing #809	\N	La Verne	414	19950-2180	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.98427	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1331	1331	Pine Bluff Location	Pine Bluff	\N	32550 Carroll Track	\N	Pine Bluff	422	10501	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:11.997322	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1332	1332	Lima Location	Lima	\N	31181 Orpha Summit	\N	Lima	456	99260-0978	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.002454	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1334	1334	Lake Forest Location	Lake Forest	\N	72179 Boyle Groves	\N	Lake Forest	427	97407	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.008212	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1336	1336	Frankfort Location	Frankfort	\N	64091 Leuschke Fall #635	\N	Frankfort	425	56393-7547	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.014481	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1337	1337	Glendale Location	Glendale	\N	54426 Sunny Plaza	\N	Glendale	449	29656	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.01718	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1339	1339	Palo Alto Location	Palo Alto	\N	51597 Cydney Squares #966	\N	Palo Alto	\N	22202	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.023141	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1340	1340	Gilbert Location	Gilbert	\N	42954 Barton Pines	\N	Gilbert	\N	77086	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.026589	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1341	1341	Pomona Location	Pomona	\N	79189 Ryan Crest Suite 172	\N	Pomona	451	47070-1480	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.029089	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1343	1343	Jasper Location	Jasper	\N	35410 Rear	\N	Jasper	\N	71150	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.035375	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1345	1345	Seward Location	Seward	\N	71461 Dianna Brooks	\N	Seward	412	88984-2215	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.041443	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1347	1347	Modesto Location	Modesto	\N	66208 Dell Drive	\N	Modesto	412	73795	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.053755	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1348	1348	Fresno Location	Fresno	\N	82123 Satterfield Fields	\N	Fresno	413	49685	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.06303	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1350	1350	Covington Location	Covington	\N	02108 Crist Port #943	\N	Covington	458	11064	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.072976	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1351	1351	Athens Location	Athens	\N	25983 Giovanni Pines	\N	Athens	446	51422-4449	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.075602	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1353	1353	Temecula Location	Temecula	\N	53000 Hangar I	\N	Temecula	459	93056-9302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.081085	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1354	1354	Hope Location	Hope	\N	99402 Birdie Trail Apt. 774	\N	Hope	443	93249-0673	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.083683	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1356	1356	Rosemead Location	Rosemead	\N	30926 Lind View Apt. 302	\N	Rosemead	450	67257	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.088867	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1357	1357	Orange Location	Orange	\N	91054 Estell Mills	\N	Orange	435	77078	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.091412	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1359	1359	Artesia Location	Artesia	\N	74474 Kub Union	\N	Artesia	440	78059	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.096676	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1360	1360	Cleveland Location	Cleveland	\N	82489 Dariana Highway Apt. 446	\N	Cleveland	449	96112-4675	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.099384	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1362	1362	Sacramento Location	Sacramento	\N	61273 Feeney Terrace	\N	Sacramento	425	93924-6903	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.104795	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1363	1363	Eureka Location	Eureka	\N	70337 Effie Mountains Suite 210	\N	Eureka	456	40901-7802	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.107504	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1365	1365	Florence Location	Florence	\N	32319 Space 85	\N	Florence	\N	63482	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.11325	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1366	1366	Fremont Location	Fremont	\N	21254 Vanessa Via	\N	Fremont	\N	66183	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.116005	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1368	1368	Troy Location	Troy	\N	94066 Jaylan Shoals	\N	Troy	444	56470-0151	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.121139	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1369	1369	West Covina Location	West Covina	\N	91708 Quigley Flats	\N	West Covina	450	57557	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.12377	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1371	1371	Marana Location	Marana	\N	31485 Emilia Ways	\N	Marana	457	28243	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.129131	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1372	1372	Laguna Niguel Location	Laguna Niguel	\N	00647 Basement	\N	Laguna Niguel	445	72504-3364	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.131801	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1374	1374	Nenana Location	Nenana	\N	66041 Schmitt Throughway #595	\N	Nenana	463	38993-4818	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.137132	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1375	1375	Decatur Location	Decatur	\N	10997 Lemke Mews #933	\N	Decatur	441	00089-7613	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.13985	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1377	1377	Delta Junction Location	Delta Junction	\N	04896 Gibson Corners	\N	Delta Junction	437	52927	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.144998	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1378	1378	South Bend Location	South Bend	\N	94720 Floor 033	\N	South Bend	457	93432-2903	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.147678	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1380	1380	Concord Location	Concord	\N	55986 Mona Ways	\N	Concord	454	98717	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.153007	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1381	1381	Valencia Location	Valencia	\N	18866 Issac Lock Suite 924	\N	Valencia	\N	05455-2368	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.157437	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1383	1383	Tuscaloosa Location	Tuscaloosa	\N	35159 Macejkovic Square	\N	Tuscaloosa	453	99401-6185	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.162742	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1385	1385	Rialto Location	Rialto	\N	09096 Basement	\N	Rialto	\N	04647	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.168115	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1386	1386	Lawndale Location	Lawndale	\N	80196 Jaren Viaduct	\N	Lawndale	452	21154	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.170681	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1387	1387	Hollywood Location	Hollywood	\N	38123 Space 4-I	\N	Hollywood	464	08171	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.1732	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1389	1389	Lima Location	Lima	\N	94542 Kihn Plains Apt. 475	\N	Lima	\N	53397	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.1785	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1390	1390	Alameda Location	Alameda	\N	61309 Marcellus Hollow	\N	Alameda	415	94578-7139	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.180928	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1391	1391	Auburn Location	Auburn	\N	76454 Herman Crossing	\N	Auburn	433	06868	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.183704	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1393	1393	Dana Point Location	Dana Point	\N	87427 Eugenia Ranch	\N	Dana Point	\N	54208	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.189066	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1394	1394	Tempe Location	Tempe	\N	58487 Kellen Roads Apt. 144	\N	Tempe	434	47165	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.191516	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1396	1396	Fairbanks Location	Fairbanks	\N	08443 Gilbert Vista	\N	Fairbanks	\N	49949	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.207414	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1397	1397	Palo Alto Location	Palo Alto	\N	95221 Kaycee Forks Suite 528	\N	Palo Alto	\N	70350-7714	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.210076	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1399	1399	Lima Location	Lima	\N	87553 Easter Overpass	\N	Lima	454	74742-3511	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.226053	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1400	1400	Monterey Park Location	Monterey Park	\N	19196 Prosacco Field	\N	Monterey Park	\N	96092	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.23091	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1404	1404	Rancho Cordova Location	Rancho Cordova	\N	86116 Domenico Walk Suite 174	\N	Rancho Cordova	458	45839-3114	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.25589	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1406	1406	Richmond Location	Richmond	\N	45521 Reymundo Estate	\N	Richmond	437	74826	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.261455	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1408	1408	Apple Valley Location	Apple Valley	\N	17812 Hangar 7	\N	Apple Valley	418	89253	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.267265	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1409	1409	Signal Hill Location	Signal Hill	\N	07420 West Inlet	\N	Signal Hill	438	61279-5335	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.26992	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1411	1411	Lake Forest Location	Lake Forest	\N	80188 Alison Island Suite 198	\N	Lake Forest	444	89710-7310	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.27698	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1413	1413	Texarkana Location	Texarkana	\N	24992 Giovanna Springs	\N	Texarkana	455	93209-9253	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.282533	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1414	1414	La Habra Heights Location	La Habra Heights	\N	34291 Rolfson Trail	\N	La Habra Heights	\N	92348-8594	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.285162	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1415	1415	Auburn Location	Auburn	\N	46251 Breanne Lodge	\N	Auburn	\N	35049	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.28754	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1417	1417	Hope Location	Hope	\N	87230 Orn Well	\N	Hope	438	32909	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.292596	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1418	1418	Sierra Madre Location	Sierra Madre	\N	01060 Feil Cliffs Suite 092	\N	Sierra Madre	429	28921-7193	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.295235	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1420	1420	Palos Verdes Estates Location	Palos Verdes Estates	\N	93340 Elza Hollow	\N	Palos Verdes Estates	459	49279	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.300346	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1422	1422	Tustin Location	Tustin	\N	33782 Franecki Fall Suite 333	\N	Tustin	454	79105-9495	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.305676	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1424	1424	Pasadena Location	Pasadena	\N	22545 Isadore Hill #262	\N	Pasadena	415	19019-8561	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.310937	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1425	1425	Orange Location	Orange	\N	86640 Ben Common	\N	Orange	\N	62948	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.313489	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1426	1426	Huntington Park Location	Huntington Park	\N	90502 Amir Village Suite 819	\N	Huntington Park	412	76160-5351	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.315972	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1428	1428	South Pasadena Location	South Pasadena	\N	97559 Kristy Street	\N	South Pasadena	460	02032	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.324118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1430	1430	Lancaster Location	Lancaster	\N	04423 Jean Drive	\N	Lancaster	429	22394-2483	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.329348	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1431	1431	Temecula Location	Temecula	\N	69894 Kreiger Track Apt. 923	\N	Temecula	442	07491	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.332093	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1433	1433	Forrest City Location	Forrest City	\N	57520 Rolfson Flat	\N	Forrest City	455	65507-0401	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.337488	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1434	1434	Baldwin Park Location	Baldwin Park	\N	91667 Janae Ferry	\N	Baldwin Park	\N	57611	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.340095	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1436	1436	Mesa Location	Mesa	\N	27312 Miles Radial Apt. 325	\N	Mesa	424	30205	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.345219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1437	1437	Huntsville Location	Huntsville	\N	10119 Lennie Curve Apt. 835	\N	Huntsville	412	65938	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.347949	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1439	1439	Jasper Location	Jasper	\N	72775 Aisha Inlet	\N	Jasper	431	94631-0861	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.353367	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1441	1441	Muncie Location	Muncie	\N	00645 Camren Coves #915	\N	Muncie	463	78732-2436	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.358753	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1442	1442	South Pasadena Location	South Pasadena	\N	52083 Kutch Orchard	\N	South Pasadena	452	04274	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.361376	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1444	1444	Signal Hill Location	Signal Hill	\N	28619 Lobby	\N	Signal Hill	415	67666-5448	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.376537	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1445	1445	Paramount Location	Paramount	\N	59187 Anya Inlet	\N	Paramount	\N	80488	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.381505	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1447	1447	Diamond Bar Location	Diamond Bar	\N	18457 Upper	\N	Diamond Bar	413	56334-3990	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.390053	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1448	1448	Claremont Location	Claremont	\N	67450 Wiza Roads	\N	Claremont	442	63958	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.392666	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1450	1450	Rialto Location	Rialto	\N	62805 Balistreri Loaf Suite 289	\N	Rialto	459	00113-8575	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.397926	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1451	1451	Mentor Location	Mentor	\N	36834 Aida Haven Apt. 241	\N	Mentor	465	46645	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.400496	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1453	1453	El Monte Location	El Monte	\N	48461 Doyle Square Apt. 826	\N	El Monte	419	87288-6950	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.405835	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1455	1455	El Segundo Location	El Segundo	\N	67735 Elliot Inlet #405	\N	El Segundo	421	44949	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.411545	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1456	1456	Parma Location	Parma	\N	37543 Julian Bridge	\N	Parma	420	84102	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.414248	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1457	1457	Salinas Location	Salinas	\N	64141 Koss Locks	\N	Salinas	440	15577	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.416925	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1459	1459	Montgomery Location	Montgomery	\N	82000 Queenie Lane	\N	Montgomery	450	10147-4991	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.423451	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1461	1461	Laguna Niguel Location	Laguna Niguel	\N	26565 Ayla Cove Suite 537	\N	Laguna Niguel	451	34958	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.434408	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1462	1462	Muncie Location	Muncie	\N	01421 Kari Junctions #799	\N	Muncie	456	67491-4864	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.437289	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1464	1464	Whittier Location	Whittier	\N	21003 Padberg Fork	\N	Whittier	455	78057	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.442607	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1465	1465	Texarkana Location	Texarkana	\N	64294 Kaley Spring	\N	Texarkana	451	36105-7111	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.445225	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1467	1467	Fairbanks Location	Fairbanks	\N	50070 Carter Circles	\N	Fairbanks	\N	22901	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.450478	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1468	1468	Glendale Location	Glendale	\N	83785 Lot Y	\N	Glendale	417	81744	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.453691	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1470	1470	Mentor Location	Mentor	\N	60762 Bruen Harbor Suite 546	\N	Mentor	433	02690	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.465815	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1471	1471	Paramount Location	Paramount	\N	41495 Connelly Corners Apt. 238	\N	Paramount	438	79246-6600	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.46836	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1473	1473	Visalia Location	Visalia	\N	05465 Kautzer Plaza Apt. 128	\N	Visalia	464	06399-6300	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.474421	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1474	1474	Zanesville Location	Zanesville	\N	45260 Zulauf Divide #333	\N	Zanesville	439	43405	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.484595	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1476	1476	West Lafayette Location	West Lafayette	\N	64429 Jaclyn Tunnel	\N	West Lafayette	458	88806	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.490247	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1478	1478	Birmingham Location	Birmingham	\N	14776 Satterfield Track	\N	Birmingham	464	12774-7229	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.504546	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1479	1479	Ontario Location	Ontario	\N	00051 Casper Loaf Apt. 138	\N	Ontario	430	76525	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.508094	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1481	1481	Jonesboro Location	Jonesboro	\N	48902 Rolfson Lane	\N	Jonesboro	\N	52803	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.51415	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1482	1482	La Mirada Location	La Mirada	\N	73887 DuBuque Shores	\N	La Mirada	459	96981	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.516711	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1484	1484	Wynne Location	Wynne	\N	13183 Floor 565	\N	Wynne	432	86482-7173	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.530744	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1485	1485	Walnut Location	Walnut	\N	84928 McLaughlin Isle	\N	Walnut	430	99104	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.538251	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1486	1486	Texarkana Location	Texarkana	\N	59266 Greenholt Curve	\N	Texarkana	443	96734-0238	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.540905	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1488	1488	El Cerrito Location	El Cerrito	\N	68506 Viola Ranch	\N	El Cerrito	440	40719	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.553899	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1492	1492	Crown Point Location	Crown Point	\N	79773 Room F	\N	Crown Point	451	70331	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.575623	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1493	1493	Vincennes Location	Vincennes	\N	89843 Lexi Union Suite 074	\N	Vincennes	\N	63920-5643	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.580118	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1495	1495	San Fernando Location	San Fernando	\N	02203 Breitenberg Mews	\N	San Fernando	454	11034-6772	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.586151	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1496	1496	Maywood Location	Maywood	\N	10743 Floor 76	\N	Maywood	434	71050-8978	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.592172	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1498	1498	Cudahy Location	Cudahy	\N	22922 Savanah Mountain	\N	Cudahy	444	27796	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.598239	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1500	1500	Tucson Location	Tucson	\N	38552 Kali Passage Suite 180	\N	Tucson	462	73816-9761	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.610315	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1501	1501	Visalia Location	Visalia	\N	56950 Brendon Divide	\N	Visalia	418	48859-6978	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.61298	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1503	1503	Artesia Location	Artesia	\N	82053 Michael Square	\N	Artesia	417	97668-6835	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.625173	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1504	1504	Nogales Location	Nogales	\N	58343 Stroman Parks	\N	Nogales	424	32558	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.634446	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1506	1506	Rohnert Park Location	Rohnert Park	\N	20705 Luettgen Hollow Suite 106	\N	Rohnert Park	458	51302	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.641489	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1507	1507	Seal Beach Location	Seal Beach	\N	27687 Rear	\N	Seal Beach	415	72620-6256	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.644453	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1509	1509	Laguna Woods Location	Laguna Woods	\N	46165 Stop 89-H	\N	Laguna Woods	465	92513	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.664146	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1510	1510	Barrow Location	Barrow	\N	51090 Dell Run Apt. 156	\N	Barrow	\N	33956	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.672087	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1512	1512	Huntsville Location	Huntsville	\N	89448 Building A	\N	Huntsville	425	25911-4969	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.6789	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1513	1513	Columbus Location	Columbus	\N	92889 Veum Stream	\N	Columbus	422	20030-6368	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.682352	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1515	1515	Lodi Location	Lodi	\N	14578 Lot 85-A	\N	Lodi	421	91667	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.694422	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1516	1516	Placentia Location	Placentia	\N	33692 Building E	\N	Placentia	421	38522-2894	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.700455	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1518	1518	Nenana Location	Nenana	\N	90303 Alfonso Springs	\N	Nenana	449	13369	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.709124	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1519	1519	Ventura Location	Ventura	\N	86036 Kuhn Walk	\N	Ventura	446	20688-4957	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.719219	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1521	1521	Costa Mesa Location	Costa Mesa	\N	72637 Ashlynn Trace	\N	Costa Mesa	420	94733-3563	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.737391	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1522	1522	Richmond Location	Richmond	\N	96355 Camryn Road Suite 549	\N	Richmond	\N	31614-1208	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.743329	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1524	1524	Tucson Location	Tucson	\N	09155 Schuppe Valley Apt. 649	\N	Tucson	439	20679	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.751974	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1525	1525	Aliso Viejo Location	Aliso Viejo	\N	52856 Purdy Knolls	\N	Aliso Viejo	421	46727	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.755478	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1527	1527	Berkeley Location	Berkeley	\N	11043 Arne Garden Suite 348	\N	Berkeley	413	07370-8408	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.767484	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1528	1528	Merced Location	Merced	\N	03612 Greta Lights	\N	Merced	412	21935	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.773558	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1530	1530	Zanesville Location	Zanesville	\N	90640 Claud Court	\N	Zanesville	444	04264-7746	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.779612	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1531	1531	Hamilton Location	Hamilton	\N	66059 Gino Hollow Suite 682	\N	Hamilton	458	26575-1306	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.78239	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1533	1533	Union City Location	Union City	\N	99188 Lower	\N	Union City	429	56310-1787	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.791761	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1534	1534	Tok Location	Tok	\N	43590 Floor 896	\N	Tok	456	46294-7922	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.795099	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1536	1536	Moreno Valley Location	Moreno Valley	\N	50050 Jean Springs	\N	Moreno Valley	\N	25932-5798	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.803687	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1537	1537	Irvine Location	Irvine	\N	96592 Elinor Skyway	\N	Irvine	\N	96110	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.806236	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1539	1539	Oakland Location	Oakland	\N	13060 Kerluke Overpass Suite 173	\N	Oakland	427	82266	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.811382	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1540	1540	La Mirada Location	La Mirada	\N	77620 McClure Field	\N	La Mirada	\N	60180	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.814048	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1542	1542	Fountain Valley Location	Fountain Valley	\N	42726 Lower	\N	Fountain Valley	\N	59707-8191	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.81921	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1543	1543	Chico Location	Chico	\N	01191 Doyle Crest #698	\N	Chico	416	15478	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.821605	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1545	1545	Ventura Location	Ventura	\N	36522 Pfannerstill Avenue	\N	Ventura	438	10345	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.826836	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1546	1546	Fullerton Location	Fullerton	\N	92711 Mueller Club	\N	Fullerton	\N	33541-7235	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.829431	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1548	1548	North Pole Location	North Pole	\N	11171 Unit M	\N	North Pole	\N	89140	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.834433	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1549	1549	Lima Location	Lima	\N	72303 Jordi Tunnel	\N	Lima	465	06913-1871	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.836858	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1551	1551	Flagstaff Location	Flagstaff	\N	00768 Gaylord Meadows	\N	Flagstaff	428	54109	\N	\N	\N	\N	1	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	2014-06-25 15:08:12.84252	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
1552	1552	Redondo Beach Locat