#include "postgres.h"

#include <sys/time.h>

#include "fmgr.h"
#include "utils/pg_lzcompress.h"

PG_MODULE_MAGIC;

Datum		compresstest(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(compresstest);
Datum
compresstest(PG_FUNCTION_ARGS)
{
	bytea	   *data = PG_GETARG_BYTEA_PP(0);
	int32		iterations = PG_GETARG_INT32(1);
	int32		hashsz = PG_GETARG_INT32(2);
	int			i;
	char	   *rawdata = VARDATA_ANY(data);
	int			rawlen = VARSIZE_ANY_EXHDR(data); 
	PGLZ_Strategy strategy = *PGLZ_strategy_default;
	PGLZ_Header *buffer;
	struct timeval begin, end;
	int64		diff;
	bool		compressed = false;

#ifdef HASH_SIZE_ARGUMENT
	strategy.hashsz = hashsz;
#endif
	buffer = (PGLZ_Header *) palloc(PGLZ_MAX_OUTPUT(rawlen));

	gettimeofday(&begin, NULL);

	for (i = 0; i < iterations; i++)
	{
		compressed = pglz_compress(rawdata, rawlen, buffer, &strategy);
	}

	gettimeofday(&end, NULL);

	diff = (end.tv_sec - begin.tv_sec) * 1000000;
	diff += end.tv_usec - begin.tv_usec;

	if (!compressed)
		diff = -diff;

	PG_RETURN_INT64(diff);
}
