#!/bin/sh

PGDIR=`pwd`
PGBIN=${PGDIR}/bin

ACTDATA=${PGDIR}/actdata
SBYDATA=${PGDIR}/sbydata
ACTARCH=${PGDIR}/actarch
SBYARCH=${PGDIR}/sbyarch

TRIGGER=${PGDIR}/trigger

CONNINFO="dbname=replication host=localhost port=5432 user=postgres"

ACTPORT=5432
SBYPORT=5433


if [ ! -f ${PGBIN}/pg_config ]; then
    echo "Change the current directory to postgres installation dir"
    exit 1
fi

# clear the old data
rm -rf ${ACTDATA} ${SBYDATA} ${ACTARCH} ${SBYARCH} ${TRIGGER}
mkdir ${ACTARCH} ${SBYARCH}

# set up the primary
${PGBIN}/initdb -D ${ACTDATA} --locale=C --encoding=UTF8
echo "host all all 0.0.0.0/0 trust"            >> ${ACTDATA}/pg_hba.conf
echo "listen_addresses = '*'"                  >> ${ACTDATA}/postgresql.conf
echo "port = ${ACTPORT}"                       >> ${ACTDATA}/postgresql.conf
echo "archive_mode = on"                       >> ${ACTDATA}/postgresql.conf
echo "archive_command = 'cp %p ${ACTARCH}/%f'" >> ${ACTDATA}/postgresql.conf
echo "restore_command = 'cp ${ACTARCH}/%f %p'" >> ${ACTDATA}/postgresql.conf
echo "log_line_prefix = 'Primary %p '"         >> ${ACTDATA}/postgresql.conf

# get online-backup
${PGBIN}/pg_ctl -D ${ACTDATA} start
sleep 3
${PGBIN}/psql template1 -c "SELECT pg_start_backup('replication', true)"
rsync -a --exclude=pg_xlog --exclude=postmaster.pid ${ACTDATA}/ ${SBYDATA}
${PGBIN}/psql template1 -c "SELECT pg_stop_backup()"
mkdir -p ${SBYDATA}/pg_xlog/archive_status

# set up the standby
echo "port = ${SBYPORT}"                       >> ${SBYDATA}/postgresql.conf
echo "archive_command = 'cp %p ${SBYARCH}/%f'" >> ${SBYDATA}/postgresql.conf
echo "restore_command = 'cp ${SBYARCH}/%f %p'" >> ${SBYDATA}/postgresql.conf
echo "log_line_prefix = 'Standby %p '"         >> ${SBYDATA}/postgresql.conf
touch ${SBYDATA}/recovery.conf
echo "recovery_trigger_file = '${TRIGGER}'"    >> ${SBYDATA}/recovery.conf
echo "standby_mode          = 'true'      "    >> ${SBYDATA}/recovery.conf
echo "primary_conninfo      = '${CONNINFO}'"   >> ${SBYDATA}/recovery.conf
${PGBIN}/pg_ctl -D ${SBYDATA} start
