/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA
 
    Copyright (C) 2000 Mark L. Woodward
    If you want support or to professionally license this library, the author
    can be reached at info@mohawksoft.com
*/ 
	#include "postgres.h"
	#include "access/heapam.h"
	#include "catalog/catname.h"
	#include "catalog/indexing.h"
	#include "catalog/pg_proc.h"
	#include "executor/executor.h"
	#include "utils/fcache.h"
	#include "utils/sets.h"
	#include "utils/syscache.h"
#include <ctype.h>

#ifndef MIN
#define MIN(a,b) ((a<b)?(a):(b))
#endif

Datum decode(PG_FUNCTION_ARGS);
Datum concat(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(decode);
PG_FUNCTION_INFO_V1(concat);

static int pgscmp(text *pgs1, text *pgs2)
{
	int cb1 = VARSIZE(pgs1)-VARHDRSZ;
	int cb2 = VARSIZE(pgs2)-VARHDRSZ;
	int result = strncmp(VARDATA(pgs1),VARDATA(pgs2),MIN(cb1,cb2));
	return (result) ? result : cb1-cb2;
}
Datum decode(PG_FUNCTION_ARGS)
{
	int num = fcinfo->nargs;
	if(!fcinfo || (fcinfo->nargs < 3))
	{
		elog(WARNING, "Too few arguments passed to decode");
	}
	else
	{
		int i;
		text *ret = PG_GETARG_TEXT_P(0);

		for(i=1; i < num; i+=2)
		{
			text *sub;
			text *pat;
			if(i+1 < num)
			{
				pat = PG_GETARG_TEXT_P(i);
				sub = PG_GETARG_TEXT_P(i+1);

				if(!pgscmp(ret,pat))
				{
					ret = sub;
					break;
				}
			}
		}
		PG_RETURN_POINTER(ret);
	}
	PG_RETURN_NULL();
}


Datum concat(PG_FUNCTION_ARGS)
{
	char *ret=NULL;
	char *p;
	int i;
	int num = fcinfo->nargs;

	int cb = 0;

	// Calculate size needed!
	for(i=0; i < num; i++)
	{
    		text * var= PG_GETARG_TEXT_P(i);
		if(var && !fcinfo->argnull[i])
			cb += (VARSIZE(var)- VARHDRSZ);
	}

	// Allocate a new object
	ret = palloc(cb + VARHDRSZ);
        VARATT_SIZEP(ret) = cb + VARHDRSZ;

	p = VARDATA(ret);

	// Copy data into new object.
	for(i=0; i < num; i++)
	{
    		text * var= PG_GETARG_TEXT_P(i);
		if(var && !fcinfo->argnull[i])
		{
			int cbt = VARSIZE(var)-VARHDRSZ;
			char *pt = VARDATA(var);
			memcpy(p, pt, cbt);
			p+=cbt;
		}
	}
	PG_RETURN_POINTER(ret);
}

