/*
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
    MA 02111-1307, USA
 
    Copyright (C) 2000 Mark L. Woodward
    If you want support or to professionally license this library, the author
    can be reached at info@mohawksoft.com
*/ 
#include "postgres.h"

#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include "postgres.h"
#include "access/heapam.h"
#include "catalog/catname.h"
#include "catalog/indexing.h"
#include "catalog/pg_proc.h"
#include "executor/executor.h"
#include "utils/fcache.h"
#include "utils/sets.h"
#include "utils/syscache.h"
#include "access/tupmacs.h"
#include "access/xact.h"
#include "fmgr.h"
#include "miscadmin.h"
#include "utils/array.h"
#include "utils/builtins.h"
#include "utils/memutils.h"
#include "utils/lsyscache.h"

#define PGFUNCT(NAME)				\
	Datum NAME (PG_FUNCTION_ARGS);		\
	PG_FUNCTION_INFO_V1( NAME );		\
	Datum NAME (PG_FUNCTION_ARGS)
	
#define TEXT_PARM(X)				\
	if(!X) PG_RETURN_NULL();		\
	X##_len = (VARSIZE(X)-VARHDRSZ);	\
	p##X = VARDATA(X)

#define TVAR( NAME, NDX )	\
	int NAME##_len;	\
	char *p##NAME;	\
	text * NAME = PG_GETARG_TEXT_P ( NDX )

// Makes a postgres text * from a C string
static text *_strtopg(char *string)
{
	int slen = strlen(string);
	int cb = slen + VARHDRSZ;
	text * t = (text *)palloc(cb);
	if(t)
	{
		VARATT_SIZEP(t)=cb;
		strncpy(VARDATA(t),string, slen);
	}
	return t;
}
// Meat of strip function
static char *_strip(char *dest, char *p, int len)
{
	int i;
	char *r = dest;
	for(i=0; i < len; i++)
		if(isalnum(p[i]))
			*r++=tolower(p[i]);
	*r=0;
	return r;
}
// Meat of strip reverse
static char *_stripr(char *dest, char *p, int len)
{
	int i;
	char *r = dest;
	p+=(len-1);
	for(i=0; i < len; i++)
	{
		if(isalnum(*p))
			*r++=tolower(*p);
		p--;
	}
	*r=0;
	return r;
}
// Meat of match
// Match is similar to 'foobar' like 'foo%'
// where 'foo%' is the pattern, and foobar is the string
static bool _match(char *pat, char *str)
{
	int result=0;
        register char *pattern = pat;
        register char *string = str;
 
        while(*pattern && !result)
                result = (*pattern++ - *string++);
        return (result) ? false : true;
}

// Strip everything but letters and numbers from a field.
PGFUNCT( Strip )
{
	char *result;
	TVAR( field, 0 );
	TEXT_PARM(field);
 	result = (char *)alloca(field_len+1);
	_strip(result,pfield,field_len);
	PG_RETURN_TEXT_P (_strtopg(result) );
}
// Strip everything but letters and numbers from a field, add a '%' to the end
PGFUNCT( StripLike )
{
	char *result;
	char *r;
	TVAR(field, 0);
	TEXT_PARM(field);
 	result = (char *)alloca(field_len+3);
	r = _strip(result,pfield,field_len);
	*r++='%';
	*r=0;
	PG_RETURN_TEXT_P( _strtopg(result) );
}   
// Strip everything but letters and numbers from a field.
// and reverse the string
PGFUNCT(StripRev)
{
	char *result;
	TVAR( field, 0 );
	TEXT_PARM(field);
 	result = (char *)alloca(field_len+1);
	_stripr(result,pfield,field_len);
	PG_RETURN_TEXT_P (_strtopg(result) );
}
// Like StripRev and add a '%' to the end
PGFUNCT(StripRevLike)
{
	char *result;
	char *r;
	TVAR(field, 0);
	TEXT_PARM(field);
 	result = (char *)alloca(field_len+3);
	r = _stripr(result,pfield,field_len);
	*r++='%';
	*r=0;
	PG_RETURN_TEXT_P( _strtopg(result) );
}
// Strips and compares two strings
PGFUNCT(StripCmp)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(b1, pfield1, field1_len);
	if(!strcmp(b0,b1))
	{
		PG_RETURN_INT32(1);
	}
	else
	{
		PG_RETURN_INT32(0);
	}
}
// Strips field1, and compares to stripped fields 2,3
PGFUNCT(StripCmp2)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TVAR(field2,2);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	TEXT_PARM(field2);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+field2_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(_strip(b1, pfield1, field1_len), pfield2, field2_len);
	if(!strcmp(b0,b1))
	{
		PG_RETURN_INT32(1);
	}
	else
	{
		PG_RETURN_INT32(0);
	}
}
// Strips and tests if field2 starts with field1
PGFUNCT(StripMatch)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(b1, pfield1, field1_len);
	PG_RETURN_INT32(_match(b0,b1));
}
// Strips and tests if field2 starts with field1
PGFUNCT(StripMatch2)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TVAR(field2,2);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	TEXT_PARM(field2);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+field2_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(_strip(b1, pfield1, field1_len), pfield2, field2_len);
	PG_RETURN_INT32(_match(b0,b1));
}
// Strips and compares two strings
PGFUNCT(StripSearch)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(b1, pfield1, field1_len);
	if(strstr(b0,b1))
	{
		PG_RETURN_INT32(1);
	}
	else
	{
		PG_RETURN_INT32(0);
	}
}
// If string 1 is in string 2, or string 2 in string 1
// return true.
PGFUNCT(StripSearchEx)
{
	char *b0;
	char *b1;
	TVAR(field0,0);
	TVAR(field1,1);
	TEXT_PARM(field0);
	TEXT_PARM(field1);
	b0 = (char *)alloca(field0_len+1);
	b1 = (char *)alloca(field1_len+1);
	_strip(b0, pfield0, field0_len);
	_strip(b1, pfield1, field1_len);

	if(strstr(b0,b1) || strstr(b1,b0))
	{
		PG_RETURN_INT32(1);
	}
	else
	{
		PG_RETURN_INT32(0);
	}
}
