#!/usr/bin/perl -w
use DBI;

$ip=$ARGV[0] || '--help';
$dbname=$ARGV[1] || 'start';
$dbuser=$ARGV[2] || 'iclive';

#Default to Unknown Status
$status=3;

#192.168.3.9 template1 iclive 
$locks=0;
$exlocks=0;
$msg="";
if ($ip !~ /\d+/)
{
	print "Provide a IP or hostname of the box to check time on using postgresql SELECT NOW()\n";
	exit 3;
}
else
{
	#print "Server is $server\n";
	#Connect to Database
	$Con = "DBI:Pg:dbname=$dbname;host=$ip";
	$Dbh = DBI->connect($Con, $dbuser, '', {RaiseError =>1}) || die "Unable to access Database $dbname on host $ip as user $dbuser.\nError returned was: ". $DBI::errstr;

	$sql="SELECT mode,COUNT(mode) FROM pg_locks GROUP BY mode ORDER BY mode;";
	$sth = $Dbh->prepare($sql);
	$sth->execute();
	while (($mode,$count) = $sth->fetchrow()) {
		if ($mode =~ /exclusive/i) {
			$exlocks=$exlocks+$count;
		}
		$locks=$locks+$count;
		$msg="$msg $mode($count),";
	}
	if ($exlocks > 10)
	{
		$status=2;
	}
	elsif ($exlocks > 5)
	{
		$status=1;
	}
	else
	{
		$status=0;
	}
$msg="$locks Locks -- $msg";
# 0 OK
# 1 WARNING
# 2 CRITICAL
# 3 UNKNOWN

	print $msg;
	exit $status;
}
