#!/usr/bin/perl -w
use DBI;

$ip=$ARGV[0] || '--help';
$dbname=$ARGV[1] || 'start';
$dbuser=$ARGV[2] || 'iclive';

#192.168.3.9 template1 iclive 

if ($ip !~ /\d+/)
{
	print "Provide a IP or hostname of the box to check time on using postgresql SELECT NOW()\n";
	exit 3;
}
else
{
	#print "Server is $server\n";
	#Connect to Database
	$Con = "DBI:Pg:dbname=$dbname;host=$ip";
	$Dbh = DBI->connect($Con, $dbuser, '', {RaiseError =>1}) || die "Unable to access Database $dbname on host $ip as user $dbuser.\nError returned was: ". $DBI::errstr;

	$sql="SELECT NOW(),VERSION();";
	$sth = $Dbh->prepare($sql);
	$sth->execute();
	while (($time,$version) = $sth->fetchrow()) {
		#print "DBTIME: $time\n";
		#2005-03-02 08:08:52.174051-07
		($rymd,$rhms)=split /[\s]/, $time;
		($rhour,$rmin,$rsec)=split /[:]/, $rhms;
		($rsec,$_)=split /[.]/, $rsec;
		($rtime,$junk)=split /[.]/, $time;
		#print "rhour: $rhour, rmin: $rmin, rsec: $rsec\n";
#Setup time variables
		my($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time()); # The time now...

			$fullyear = $year + 1900; # The current year is exactly 'num yrs since 1900.'
			$year = substr ($year,2,3);
		$year = sprintf("%02d", $year);
		$mday  = sprintf("%02d", $mday);   # Make sure we have two digits.
			$mon   = sprintf("%02d", ++$mon); # Ditto here...
			$sec   = sprintf("%02d", $sec);   # Ditto here...
			$min   = sprintf("%02d", $min);   # Ditto here...
			$hour  = sprintf("%02d", $hour);  # Ditto here...
			$yday  = sprintf("%03d", $yday);  # 3 digits here...
			$ltime = "$fullyear-$mon-$mday $hour:$min:$sec";

		$lymd="$fullyear-$mon-$mday";
		if ($lymd ne $rymd)
		{
			$status=2;
			$msg="CRITIAL: Date is off! REMOTE: $rtime LOCAL: $ltime - $version";
		}
		elsif ($hour ne $rhour)
		{
			$status=2;
			$msg="WARNING: Hour is off! REMOTE: $rtime LOCAL: $ltime - $version";
		}
		elsif ($min ne $rmin)
		{
			$status=1;
			$msg="WARNING: Minute is off! REMOTE: $rtime LOCAL: $ltime - $version";
		}
		elsif ($sec ne $rsec)
		{
			$status=0;
			$msg="Time is close REMOTE: $rtime LOCAL: $ltime - $version";
		}
		else
		{
			$status=0;
			$msg="Time in sync REMOTE: $rtime LOCAL: $ltime - $version";
		}
	}
# 0 OK
# 1 WARNING
# 2 CRITICAL
# 3 UNKNOWN

	print $msg;
	exit $status;
}
