// ron.peterson@yellowbank.com
// 2001-01-03 12:00:06 PM

#include "global.h"
#include "md5.h"
#include "md5c.c"
#include "postgres.h"
#include <string.h>

#define MD_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final

/* pgmd5 driver code */

static void pgMD5FormatHex( unsigned char*, char* );

text*
pg_md5( pg_textin )
	text* pg_textin;
{
	char* bstring;
	char result[33];
	text* pg_result = (text*)palloc(VARHDRSZ + 33);
	unsigned int len = pg_textin->vl_len - VARHDRSZ;

	MD_CTX context;
	unsigned char digest[16];

	bstring = malloc( len + 1 );
	memcpy( bstring, pg_textin->vl_dat, len );
	bstring[len+1] = '\0';

	pg_result->vl_len = VARHDRSZ + 33;

	MDInit( &context );
	MDUpdate( &context, bstring, len );
	MDFinal( digest, &context );

	pgMD5FormatHex( digest, result );
	memmove( pg_result->vl_dat, result, 33 );

	free( bstring );

	return pg_result;
}

static void pgMD5FormatHex( digest, hexstring )
	unsigned char* digest;
	char* hexstring;
{
	unsigned int i;
	char c;

	for( i = 0; i < 16; i++ ) {
		c = ((digest[i] & 0xf0) >> 4) + '0';
		if( c > '9' ) c += 39;
		hexstring[i*2] = c;
		c = ( digest[i] & 0x0f ) + '0';
		if( c > '9' ) c += 39;
		hexstring[i*2+1] = c;
	}

	hexstring[32] = '\0';
}
