--
-- Get data for Transportable Optimizer Mode
--
-- simon@2ndquadrant.com

-- Output must be a set of files. We want this to run by an unprivileged user,

CREATE OR REPLACE TEMPORARY VIEW tom_get_stats AS
SELECT 
  n.nspname AS schemaname
, c.relname AS tablename
, a.attnum AS attnum
, stanullfrac AS s1
, stawidth AS s2
, stadistinct AS s3
, stakind1 AS s4
, stakind2 AS s5
, stakind3 AS s6
, stakind4 AS s7
, staop1 AS s8
, staop2 AS s9
, staop3 AS s10
, staop4 AS s11
, stanumbers1 AS s12
, stanumbers2 AS s13
, stanumbers3 AS s14
, stanumbers4 AS s15
, stavalues1::text AS s16
, stavalues2::text AS s17
, stavalues3::text AS s18
, stavalues4::text AS s19

FROM
 pg_statistic s
,pg_class c
,pg_attribute a
,pg_namespace n

WHERE has_table_privilege(c.oid, 'select'::text)
  AND n.nspname not in ('pg_catalog', 'information_schema', 'pg_toast')
  AND a.attname not in ('ctid','xmin','xmax','cmin','cmax','tableoid')
  AND c.relname not like 'tom_%'

  AND c.oid = s.starelid
  AND a.attnum = s.staattnum
  AND c.oid = a.attrelid
  AND n.oid = c.relnamespace

ORDER BY n.nspname
;
\copy (select * from tom_get_stats) TO 'tom_pg_statistic.data'

CREATE OR REPLACE TEMPORARY VIEW tom_get_pg_class AS
SELECT 
  n.nspname AS schemaname
, c.relname AS relname
, pg_relation_size(c.oid)/8192 AS pages
, case
	/* sequences */ 	
	when c.relkind = 'S' then 1
	else case
			/* zero size relation */
			when pg_relation_size(c.oid) = 0 or c.relpages = 0 then 0
			
			/* normal case */
			else pg_relation_size(c.oid)/8192 * (c.reltuples/c.relpages)
		  end
	end
FROM
 pg_class c
,pg_namespace n

WHERE has_table_privilege(c.oid, 'select'::text)
  AND n.nspname not in ('pg_catalog', 'information_schema', 'pg_toast')
  AND c.relname not like 'tom_%'
  AND c.relkind in ('r', 'i', 'S', 't')

  AND n.oid = c.relnamespace

ORDER BY n.nspname
;
\copy (select * from tom_get_pg_class) TO 'tom_pg_class.data'

--
-- End of get data for Transportable Optimizer Mode
--
