#!/bin/sh
# $Id$
#
# Load script for Transportable Optimizer Mode (TOM)
#
# Chris Browne 		select 'cbbrowne' || '@' || 'linuxfinances.info';
#
#source ~/dbs/pgsql83.sh env    # A cbbrowne-ism to set up access to my favorite DB cluster...

# These all provide overridable defaults
SOURCESCHEMA=${SOURCESCHEMA:-"public"}   # which schema is in use (e.g. - what schema to pg_dump)
TESTDB=${TESTDB:-"tomtestdb"}            # target database for TOM test
TOMSCHEMA=${TOMSCHEMA:-"tom"}            # schema to use for TOM tables

dropdb ${TESTDB}
createdb ${TESTDB}
psql -d ${TESTDB} -c "create schema ${TOMSCHEMA};"

psql -d ${TESTDB} -f ${SOURCESCHEMA}_dump.sql

psql -d ${TESTDB} -f create_tom_tables.sql --single-transaction -v TOM_SCHEMA=${TOMSCHEMA}
psql -d ${TESTDB} -f load_data_for_tom.sql --single-transaction -v TOM_SCHEMA=${TOMSCHEMA}
psql -d ${TESTDB} -f get_mapping_for_tom.sql -v TOM_SCHEMA=${TOMSCHEMA}
psql -d ${TESTDB} -c "load '\$libdir/tom_hooks';"

