#!/bin/sh
# $Id$
#
# Extract script for Transportable Optimizer Mode (TOM)
#
# Chris Browne 		select 'cbbrowne' || '@' || 'linuxfinances.info';
#
#source ~/dbs/pgsql83.sh env    # A cbbrowne-ism to set up access to my favorite DB cluster...

# These all provide overridable defaults
SOURCEDB=${SOURCEDB:-"postgres"}         # which database does the data come from
SOURCESCHEMA=${SOURCESCHEMA:-"public"}   # which schema is in use (e.g. - what schema to pg_dump)

psql -d ${SOURCEDB} -c "analyze;"
psql -d ${SOURCEDB} -f get_data_for_tom.sql
pg_dump -n ${SOURCESCHEMA} -s ${SOURCEDB} > ${SOURCESCHEMA}_dump.sql

