
#if defined(_WIN32) || defined(_WIN64)
#	define U64FMT "%I64u"
	typedef unsigned __int64 myuint64_t;
#else
#	define U64FMT "%llu"
	typedef unsigned long long myuint64_t;
#endif

#include "pg.h"
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#if 0
	CREATE TABLE test_param
	(
		b "char",
		s smallint,
		i int,
		l bigint,
		t text,
		f float4,
		d float8,
		t2 text	-- used to test NULL values
	);
#endif

int main(void)
{
	float f4;
	double f8 = 0;
	char *text;
	char ch = 0;
	short i2 = 0;
	int i4 = 0;
	myuint64_t i8;
	PGconn *conn;
	PGresult *res;
	PGparam *param;
	ExecStatusType status;
	char command[] = "INSERT INTO test_param VALUES "
		"($1, $2, $3, $4, $5, $6, $7, $8)";

	conn = PQconnectdb("hostaddr=127.0.0.1 user=postgres");
	if(PQstatus(conn) != CONNECTION_OK)
	{
		printf("connection failure\n");
		return 1;
	}

	/* clear test table */
	res = PQexec(conn, "DELETE FROM test_param");
	PQclear(res);

	/* creates a PGparam.	This can be used for multiple executions as
	 * long as PQparamReset() is called prior to putting param values.
	 */
	param = PQparamCreate();

	i8 = ULLONG_MAX;
	PQparamPutChar(param, UCHAR_MAX);
	PQparamPutInt2(param, USHRT_MAX);
	PQparamPutInt4(param, UINT_MAX);
	PQparamPutInt8(param, &i8);								 /* pqlib has no 64-bit type. */
	PQparamPutText(param, "This is some text");
	PQparamPutFloat4(param, 111.234f);
	PQparamPutFloat8(param, 11111111.234567);
	PQparamPutText(param, NULL);								 /* SQL NULL value */
	PQparamExec(conn, command, param, 1, &res);	/* exec query using param */

	/* check result */
	status = PQresultStatus(res);
	if(status != PGRES_COMMAND_OK && status != PGRES_TUPLES_OK)
		printf("%s", PQresultErrorMessage(res));
	PQclear(res);

	/* don't need this any more.	If it was needed, PGparamReset() would
	 * need to be called before using it again.
	 */
	PQparamClear(param);

	/* execute a query in binary format with no params.	NOTE: a PQparam
	 * without any values (a param count of 0) has the same effect as
	 * passing a NULL PGparam.	See PQparamReset(), which sets the
	 * internal param count to 0.
	 */
	PQparamExec(conn, "SELECT * FROM test_param", NULL, 0, &res);

	status = PQresultStatus(res);
	if(status != PGRES_COMMAND_OK && status != PGRES_TUPLES_OK)
	{
		printf("%s", PQresultErrorMessage(res));
		PQclear(res);
		return 1;
	}

	/* process results */
	PQgetchar(res, 0, 0, &ch);
	PQgetint2(res, 0, 1, &i2);
	PQgetint4(res, 0, 2, &i4);
	PQgetint8(res, 0, 3, &i8);
	text = PQgetvalue(res, 0, 4);
	PQgetfloat4(res, 0, 5, &f4);
	PQgetfloat8(res, 0, 6, &f8);

	printf("ch = %hhu\ni16 = %hu\ni32 = %u\ni64 = " U64FMT "\n"
		"text = '%s'\nfloat4 = %.3f\nfloat8 = %lf\n",
		ch, i2, i4, i8, text, f4, f8);

	if(PQgetisnull(res, 0, 7))
		printf("text #2 is NULL. (correct)\n");
	else
		printf("text #2 is not NULL! (wrong)\n");

	PQclear(res);
	PQfinish(conn);
	return 0;
}



