
#ifndef __PG_H__
#define __PG_H__

#include <libpq-fe.h>

#ifdef __cplusplus
extern "C" {
#endif

/* #########################################
 * PGparam API
 */

typedef struct pg_param PGparam;

PGparam *PQparamCreate(void);

char *PQparamErrorMessage(PGparam *param);

/* Resets a PGparam for use again. */
void PQparamReset(PGparam *param);

/* Frees a PGparam, used the term 'clear' to match PQclear(). */
void PQparamClear(PGparam *param);

int PQparamExec(
	PGconn *conn,
	const char *command,
	PGparam *param,
	int resultFormat,
	PGresult **resultp);

int PQparamExecPrepared(
	PGconn *conn,
	const char *stmtName,
	PGparam *param,
	int resultFormat,
	PGresult **resultp);

int PQparamSend(
	PGconn *conn,
	const char *command,
	PGparam *param,
	int resultFormat);

int PQparamSendPrepared(
	PGconn *conn,
	const char *stmtName,
	PGparam *param,
	int resultFormat);

int PQparamPutChar(PGparam *param, char ch);

int PQparamPutInt2(PGparam *param, short i2);

int PQparamPutInt4(PGparam *param, int i4);

int PQparamPutInt8(PGparam *param, void *i8p);

int PQparamPutFloat4(PGparam *param, float f4);

int PQparamPutFloat8(PGparam *param, double f8);

int PQparamPutText(PGparam *param, const char *text);

int PQparamPut(
	PGparam *param,
	const void *data,
	int datal,
	int format);






/* #########################################
 * PGresult Extension API
 */

int PQgetchar(
	const PGresult *res,
	int tup_num,
	int field_num,
	char *chp);

int PQgetint2(
	const PGresult *res,
	int tup_num,
	int field_num,
	short *i2p);

int PQgetint4(
	const PGresult *res,
	int tup_num,
	int field_num,
	int *i4p);

int PQgetint8(
	const PGresult *res,
	int tup_num,
	int field_num,
	void *i8p);

#define PQgetfloat4(res, tup_num, field_num, float4p) \
	PQgetint4(res, tup_num, field_num, (int *)((void*)(float4p)))

#define PQgetfloat8(res, tup_num, field_num, float8p) \
	PQgetint8(res, tup_num, field_num, (void *)(float8p))

#ifdef __cplusplus
}
#endif
#endif




