﻿Imports Devart.Data.PostgreSql

Public Class QueryClass

    Private Shared mPointAInfo As PgSqlCommand

    Public Property PointDate As DateTime

    Public Sub New(ByVal msgID As Int64, ByVal aConn As PgSqlConnection, ByVal pointDate As DateTime)
        aConn.Schema = GetDBSchemas(pointDate)
        Me.PointDate = pointDate
        GetPointTypeInfo(msgID, aConn)
    End Sub

    Public Sub GetPointTypeInfo(ByVal msgID As Int64, ByVal aConn As PgSqlConnection)
        Dim aDataReader As PgSqlDataReader = Nothing
        Try
            If mPointAInfo Is Nothing Then
                mPointAInfo = PreparePointAInfoQuery(aConn)
            End If
            mPointAInfo.Parameters(0).Value = msgID
            mPointAInfo.Parameters(1).Value = PointDate.Day
            aDataReader = mPointAInfo.ExecuteReader()
            If aDataReader.HasRows Then
                aDataReader.Read() 'One row should be enough.

                Dim value1 = aDataReader.Item(1)
                Dim value2 = aDataReader.Item(2)
                Dim value3 = aDataReader.Item(3)
            End If
            aDataReader.Close()
        Catch exConn As Exception
            Console.WriteLine("Vessel_A:GetShipStaticDetails" & exConn.Message)
            If aDataReader IsNot Nothing And Not aDataReader.IsClosed Then
                aDataReader.Close()
            End If
            Exit Sub
        End Try
    End Sub

    Private Shared Function PreparePointAInfoQuery(ByRef aConn As PgSqlConnection) As PgSqlCommand
        Dim pointAInfoQuery As String = "select " & _
                                              "msg_type, " & _
                                              "pos_accuracy, " & _
                                              "pos_raim, " & _
                                              "pos_lon, " & _
                                              "pos_lat, " & _
                                              "ship_speed, " & _
                                              "ship_course, " & _
                                              "ship_heading, " & _
                                              "ship_second, " & _
                                              "ship_radio, " & _
                                              "ship_status::smallint, " & _
                                              "ship_turn, " & _
                                              "ship_maneuver " & _
                                              "from " & _
                                              "ship_a_pos_messages " & _
                                              "where msg_id = :msgID " & _
                                              "and extract(day from ship_a_pos_messages.msg_date_rec) = :dayOfMonth"
        PreparePointAInfoQuery = New PgSqlCommand(pointAInfoQuery, aConn)
        PreparePointAInfoQuery.CommandType = CommandType.Text
        PreparePointAInfoQuery.Parameters.Add(":msgID", PgSqlType.BigInt)
        PreparePointAInfoQuery.Parameters.Add(":dayOfMonth", PgSqlType.Int)
        PreparePointAInfoQuery.Prepare()
        Return PreparePointAInfoQuery
    End Function
End Class
