<?php 

// XML RSS Generator done on the 16 Feb
// by MartyR and Gurugeek
// modified on the 20 Feb by gurugeek

require_once 'DB.php';
require_once 'XML/Serializer.php';

/// Please fill it in with your username, pw, db etc
$dsn = 'pgsql://username:password@localhost/dbname';
$dboptions = array(
'debug'       => 2, //
'portability' => DB_PORTABILITY_ALL );



$db =& DB::connect($dsn);
if (DB::isError($db)) {
	
	echo 'Standard Message: ' . $db->getMessage() . "\n";
	echo 'DBMS/User Message: ' . $db->getUserInfo() . "\n";
	echo 'DBMS/Debug Message: ' . $db->getDebugInfo() . "\n";
	exit;
}


$options = array(
"indent"         => "    ",
"linebreak"      => "\n",
"typeHints"      => false,
"addDecl"        => true,
"encoding"       => "UTF-8",
"rootName"       => "rdf:RDF",
"rootAttributes" => array("version" => "0.91", "xmlns:rdf"=>"http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
"defaultTagName" => "item"
);


$rdf    =   array(
"channel" => array(
"title" => "PostgreSQL News",
"link"  => "http://www.postgresql.org/",

)
);

//please double check the query....

$sql= " SELECT headline AS title,
       'http://www.postgresql.org/news/'||id||'.html' AS link, 
       summary AS body,  
       posted_by AS author,
       to_char(posted, 'dd-mm-YYYY') AS f_date
  FROM news
 WHERE ((active = TRUE)
   AND (approved = TRUE) )
 ORDER BY posted DESC
";


$q= $db->query($sql);
if (DB::isError($q)) {die($q->getMessage());
}


while($row =& $q->fetchRow(DB_FETCHMODE_OBJECT)) {
	
	$rdf []= array("title" => $row->title, "link" => $row->link, "description" => $row->body, "author" => $row->author , "date" =>submit_date);
}

$serializer = new XML_Serializer($options);

$result = $serializer->serialize($rdf);

if( $result === true ) {
	echo    ($serializer->getSerializedData());
	
}

$db->disconnect();
    ?>
