
/* named_pipe_trick.c : Windows implementation of the "named pipe trick"
 * to monitor postmaster while blocking, as originally implemented for
 * unix by Florian Pflug
 *
 * "Multi-byte character set" C build, for consistency with Postgres
 *
 * named_pipe_trick represents the postmaster. It creates named pipe instances as needed
 * that one or more auxiliary_backend processes may read from in a separate thread that
 * blocks, until we die. When that happens, their ReadFile() call
 * will return with an error.
 *
 * Built with Visual Studio 2008 Express Edition
 *
 * Peter Geoghegan - peter@2ndquadrant.com
 */ 

#include "windows.h"
#include <stdio.h>

#define WAIT_SECONDS 30
#define BUFSIZE 4096


int main(int argc, char** argv)
{
	const char* pipename = "\\\\.\\pipe\\demo_pipe";
	
	for(;;)
	{
		BOOL success = FALSE;
		HANDLE      pipe;
		printf("Creating named pipe instance...\n");
		pipe = CreateNamedPipe(pipename, PIPE_ACCESS_OUTBOUND | FILE_FLAG_WRITE_THROUGH,
		 PIPE_TYPE_MESSAGE | PIPE_READMODE_MESSAGE | PIPE_WAIT,
		 PIPE_UNLIMITED_INSTANCES, BUFSIZE * sizeof(char), BUFSIZE * sizeof(char), 0, NULL);
		if (pipe == INVALID_HANDLE_VALUE) 
		{
			printf("CreateNamedPipe failed, GLE=%d\n", GetLastError()); 
			Sleep(50000);
			return -1;
		}
		success = ConnectNamedPipe(pipe, NULL);
		if (!success)
		{
			printf("ConnectNamedPipe failed, GLE=%d\n", GetLastError()); 
			Sleep(5000); /* Give user a chance to see error message */
			return -1;
		}
	}

	return 0;
}

