
/* auxiliary_backend.c : Windows implementation of the "named pipe trick"
 * to monitor postmaster while blocking, as originally implemented for
 * unix by Florian Pflug
 *
 * "Multi-byte character set" C build, for consistency with Postgres
 *
 * Auxiliary backend represents a backend like the archiver, that listens on
 * a named pipe created by the postmaster, represented by named_pipe_trick
 *
 * Built with Visual Studio 2008 Express Edition
 *
 * Peter Geoghegan - peter@2ndquadrant.com
 */ 

#include "windows.h"
#include <stdio.h>

#define BUFSIZE 4096

int main(int argc, char** argv)
{
	char       buf[BUFSIZE];
	HANDLE      pipe;
	BOOL   success = FALSE; 
	DWORD  cbRead;
	const char* pipename = "\\\\.\\pipe\\demo_pipe";

	printf("Waiting on postmaster death...\n");
	// CreateFile to open existing named pipe
	pipe = CreateFile(
		pipename,
		GENERIC_READ,  // read and write access 
		FILE_SHARE_READ, // read sharing
		NULL,           // default security attributes
		OPEN_EXISTING,  // opens existing pipe 
		0,              // default attributes 
		NULL);          // no template file

	if (pipe == INVALID_HANDLE_VALUE) 
    {
		printf("CreateFile failed - was a \"postmaster\"/named_pipe_trick running? GLE=%d\n", GetLastError()); 
		Sleep(5000);  /* Give user a chance to see error message */
		return -1;
	}

	success = ReadFile( 
		pipe,    // pipe handle 
		buf,    // buffer to receive reply 
		BUFSIZE*sizeof(char),  // size of buffer 
		&cbRead,  // number of bytes read 
		NULL);    // not overlapped

	if (!success)
	{
		/* "postmaster" died */
		return -1;
	}
	

	return 0;
}
