%{
/*-------------------------------------------------------------------------
 *
 * specparse.y
 *	  bison grammar for the isolation test file format
 *
 * Portions Copyright (c) 1996-2011, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *-------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>

#include "isolationtester.h"


TestSpec		parseresult;			/* result of parsing is left here */

%}

%expect 0
%name-prefix="spec_yy"

%union
{
	char	   *str;
	Session		session;
	Step		step;
	struct
	{
		Session *sessions;
		int nsessions;
	}			 session_list;
	struct
	{
		Step *steps;
		int nsteps;
	}			 step_list;
}

%type <str>  opt_setup opt_teardown
%type <step_list> step_list
%type <session_list> session_list
%type <session> session
%type <step> step

%token <str> sqlblock string
%token SESSION SETUP STEP TEARDOWN TEST

%%

TestSpec:
			opt_setup
			opt_teardown
			session_list
			{
				parseresult.setupsql = $1;
				parseresult.teardownsql = $2;
				parseresult.sessions = $3.sessions;
				parseresult.nsessions = $3.nsessions;
			}
		;

opt_setup:
			/* EMPTY */			{ $$ = NULL; }
			| SETUP sqlblock	{ $$ = $2; }
		;

opt_teardown:
			/* EMPTY */			{ $$ = NULL; }
			| TEARDOWN sqlblock	{ $$ = $2; }
		;

session_list:
			session_list session
			{
				$$.sessions = realloc($1.sessions,
									  ($1.nsessions + 1) * sizeof(Session));
				$$.sessions[$1.nsessions] = $2;
				$$.nsessions = $1.nsessions + 1;
			}
			| session
			{
				$$.nsessions = 1;
				$$.sessions = malloc(sizeof(Session));
				$$.sessions[0] = $1;
			}
		;

session:
			SESSION string opt_setup step_list opt_teardown
			{
				$$.name = $2;
				$$.setupsql = $3;
				$$.steps = $4.steps;
				$$.nsteps = $4.nsteps;
				$$.teardownsql = $5;
			}
		;

step_list:
			step_list step
			{
				$$.steps = realloc($1.steps,
								   ($1.nsteps + 1) * sizeof(Step));
				$$.steps[$1.nsteps] = $2;
				$$.nsteps = $1.nsteps + 1;
			}
			| step
			{
				$$.nsteps = 1;
				$$.steps = malloc(sizeof(Step));
				$$.steps[0] = $1;
			}
		;


step:
			STEP string sqlblock
			{
				$$.name = $2;
				$$.sql = $3;
			}
		;
%%

#include "specscanner.c"
