--
-- Run the SQL commands in partition.sql(found in base directory 'pgsql_init') to setup trigger functions 
-- for partitioning. This file is generated by master makefile. 
-- psql -p xxxx < partition.sql
-- 

CREATE TABLE a(
    emp_id          int not null,
    designation     text not null,
    location        varchar(50) not null,
    jdate           date not null,
    ctc             float not null
);

INSERT INTO a VALUES (1567, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO a VALUES (1568, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO a VALUES (3501, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO a VALUES (3502, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO a VALUES (3503, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO a VALUES (1525, 'System Administrator', 'Chennai', '7 July, 2004', 35000);

CREATE TABLE emp (
    emp_id          int not null primary key,
    designation     text not null,
    location        varchar(50) not null,
    jdate           date not null,
    ctc             float not null

)
PARTITION BY RANGE (jdate, emp_id)
(
emp80 (START '01-01-1980',MINVALUE END '01-01-1990',500),
emp90 (START '01-01-1990',500 END '01-01-2000',1500+10),
emp00 (START '1 Jan 2000',1500+20 END 'Jan 1, 2010', MAXVALUE),
DEFAULT
);

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '12-11-1994', 70000);
INSERT INTO emp VALUES (1567, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO emp VALUES (1568, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO emp VALUES (3501, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO emp VALUES (3502, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO emp VALUES (3503, 'CEO', 'Pune', '17 June, 2006', 30000);
INSERT INTO emp VALUES (1515, 'System Administrator', 'Chennai', '7 July, 2004', 35000);

select * from emp;
select * from emp80;
select * from emp90;
select * from emp00;

ALTER TABLE emp DROP  partition emp90;
ALTER TABLE emp DROP  partition (START minvalue,minvalue END '01-01-1990',500);

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '12-11-1998', 70000);

select * from emp;
select * from emp80;
select * from emp90;
select * from emp00;

ALTER TABLE emp ADD range partition emp90 (START '01-01-1990',500 END '01-01-1995',1000);

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '12-11-1998', 70000);

select * from emp;
select * from emp90;
select * from emp00;

ALTER TABLE emp update partition emp90(START '01-01-1990',500 END '01-01-2000',1500+10);

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '12-11-1998', 70000);

select * from emp;
select * from emp90;
select * from emp00;

ALTER TABLE emp split partition emp00 at values ('1 Jan, 2005', 2500) into emp1 and emp2;

select * from emp;
select * from emp90;
select * from emp1;
select * from emp2;

ALTER TABLE emp merge partitions emp1 and emp2 into emp00;

select * from emp;
select * from emp90;
select * from emp00;

ALTER TABLE emp ADD  range partition emp40 (START '01-01-2010',20000 END '01 JAn, 2050',30000);
INSERT INTO emp VALUES (20000, 'SSE', 'Pune', '01-01-2045', 80000);

ALTER TABLE emp ADD  range partition emp80 (START '01-01-1980',1 END '01-01-1990',500);
ALTER TABLE emp ADD  range partition emp00 (START '1 Jan 2000',1500+20 END 'Jan 1, 2010', 4000-50);

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '12-11-1998', 70000);
INSERT INTO emp VALUES (1567, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO emp VALUES (1515, 'System Administrator', 'Chennai', '7 July, 1994', 35000);

select * from emp;
select * from emp80;
select * from emp90;
select * from emp00;

UPDATE emp SET emp_id = 12000 where emp_id = 1;
UPDATE emp SET jdate = '1995-10-9', emp_id = 750 where emp_id = 737;
UPDATE emp SET jdate = '2003-01-01', emp_id = 1550 where emp_id = 120;

select * from emp;
select * from emp80;
select * from emp90;
select * from emp00;

ALTER TABLE emp exchange emp00 with table a;

INSERT INTO emp VALUES (123, 'CFO', 'New York', '1985-12-21', 60000);
INSERT INTO emp VALUES (1232, 'CFO', 'New York', '1985-12-21', 60000);
INSERT INTO emp VALUES (1567, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO emp VALUES (1515, 'System Administrator', 'Chennai', '7 July, 1994', 35000);

ALTER TABLE emp ALTER COLUMN location TYPE varchar(100);
ALTER TABLE emp alter column location set default 'indiana';

SELECT * from pg_partitions;

select * from emp;
select * from emp80;
select * from emp90;
select * from emp00;
select * from a;

--
-- Run the SQL commands in partition.sql(found in base directory) to setup trigger functions 
-- for partitioning. This file is generated by master makefile. 
-- psql -p xxxx < partition.sql
--

-- pg_dump -Ft testdb -p 5454 > dump.tar
-- pg_restore -p 5454 -C -d testdb dump.tar

VACUUM VERBOSE emp;
ANALYZE VERBOSE emp;
TRUNCATE emp;

CREATE TABLE emp (
    emp_id          int not null primary key,
    designation     text not null,
    location        varchar(50) not null unique,
    jdate           date not null,
    ctc             float not null
)
PARTITION BY HASH (location, jdate, emp_id) PARTITIONS 3;

INSERT INTO emp VALUES (1, 'Project Manager', 'London', '01-01-1984', 80000);
INSERT INTO emp VALUES (737, 'Business Analyst', 'Honolulu', '11-11-1998', 70000);
INSERT INTO emp VALUES (1567, 'Programmer', 'Guangzhou', '7 Jan, 2001', 30000);
INSERT INTO emp VALUES (1515, 'System Administrator', 'Chennai', '7 July, 1994', 35000);
INSERT INTO emp VALUES (3949, 'Principal Architect', 'Pune', '25 Feb, 2010', 35000);

select * from emp;
select * from emp_0;
select * from emp_1;
select * from emp_2;

ALTER TABLE emp update partitions to 1;

select * from emp;
select * from emp_0;
select * from emp_1;
select * from emp_2;

ALTER TABLE emp update partitions to 3;

select * from emp;
select * from emp_0;
select * from emp_1;
select * from emp_2;

UPDATE emp SET emp_id = 120 where emp_id = 1;
UPDATE emp SET jdate = '1995-10-9', emp_id = 750 where emp_id = 737;
UPDATE emp SET jdate = 'Feb 23, 2009' where jdate = '2001-01-07';
UPDATE emp SET jdate = '1994-01-01' where emp_id = 120;
UPDATE emp SET jdate = '1994-01-01', emp_id = 550 where emp_id = 120;

select * from emp;
select * from emp_0;
select * from emp_1;
select * from emp_2;

INSERT INTO emp_0 VALUES (156, 'Accountant', 'Beijing', '2000-12-12', 40000);
INSERT INTO emp_0 VALUES (1520, 'Accountant', 'Beijing', '2009-12-12', 40000);

INSERT INTO emp_1 VALUES (652, 'CEO', 'Houston', '2000-01-02', 500000);
INSERT INTO emp_1 VALUES (601, 'CEO', 'Houston', '1996-01-02', 500000);

INSERT INTO emp_2 VALUES (1232, 'CFO', 'New York', '1985-12-21', 60000);
INSERT INTO emp_2 VALUES (123, 'CFO', 'New York', '1985-12-21', 60000);

ALTER TABLE emp ALTER COLUMN emp_id TYPE float;

DROP TABLE emp cascade;
