/*-------------------------------------------------------------------------
 *
 * walsender.h
 *	  Exports from postmaster/walsender.c.
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/include/postmaster/walsender.h,v 1.2 2008/01/01 19:45:58 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */
#ifndef _WALSENDER_H
#define _WALSENDER_H

#include "access/xlog.h"
#include "libpq/libpq.h"
#include "storage/proc.h"

/* global state */
extern bool	am_walsender;

/* user-settable parameters */
extern bool	XLogSyncReplication;
extern int	XLogReplicationTimeout;
extern int	WalSenderDelay;

/* main */
extern int	WalSenderMain(void);
extern void DeclareWalSender(Port *port, char *remote_ps_data);

/* communication with the other process */
extern Size WalSenderShmemSize(void);
extern void WalSenderShmemInit(void);
extern bool WalSenderRequestAdd(PGPROC *proc, bool wait_sending, XLogRecPtr requestLSN);
extern void WalSenderRequestRemove(PGPROC *proc);

/* routine for replication */
extern void InitReplication(XLogRecPtr record);

/* common routines */
extern pid_t	GetWalSenderPid(void);
extern bool		ReplicationIsActive(void);
extern void		WalSenderWakeup(void);
extern bool		CheckReplicationTimeout(int);
extern void		HandleWalSenderInterrupt(void);

#endif   /* _WALSENDER_H */
