-----------------------------------------------
-- Create two identical tables, one with a normal
-- index, and another with a clustered index
--
-- The sizes of the heap and indexes are be printed
-- at the end
-----------------------------------------------

\echo Create two largish tables. This may take a while..

-- Create and load table with integers from 1 to 30000000
DROP TABLE IF EXISTS narrowtable;
BEGIN;
CREATE TABLE narrowtable(key int, data text);

INSERT INTO narrowtable 
SELECT (a-1)*100+b, 'foobar' FROM generate_series(1, 400000) a,  generate_series(0,99) b;

ANALYZE narrowtable;
COMMIT;

-- Make a copy of the table
DROP TABLE IF EXISTS narrowtable2;
BEGIN;
SELECT * INTO narrowtable2 FROM narrowtable;
ANALYZE narrowtable2;
COMMIT;

-- Create a normal index on narrowtable and a clustered index on narrowtable2
\echo Build normal and clustered index
CREATE INDEX narrowtable_index ON narrowtable(key) WITH (groupthreshold=0);
CREATE INDEX narrowtable2_clustered_index ON narrowtable2(key) WITH (groupthreshold=2);

CHECKPOINT;


-- Print sizes
SELECT 
  (SELECT relpages FROM pg_class WHERE relname='narrowtable') AS heap_pages,
  (SELECT relpages FROM pg_class WHERE relname='narrowtable_index') AS normal_index_pages,
  (SELECT relpages FROM pg_class WHERE relname='narrowtable2_clustered_index') AS clustered_index_pages;

\echo Done! Now run git_demo_run.sql to test selects on the tables
