/* 
  Copyright (c) 2002 FramBak BakFram AB
  Author: Magnus Naeslund (mag@fbab.net)

  Use freely, but don't blame me if it blows up.
  
*/

class PGNotify {
    private long native_ref=0; //Don't ever touch, will cause crash if you do

    private native void  initNative();
    private native void  destroyNative();
    
    public native void   connect(String host,int port,String dbname,String user, String password);
    public native void   disconnect();
    public native void   listen(String identifier);
    public native void   unlisten(String identifier);

    public native String blockForNotify(int timeout); //Returns the listen identifier, <0 timeout is forever, 0 timeout returns emmediately (can return null), >0 is in milliseconds (returns null if timeout)

    static { System.loadLibrary("PGNotify"); }

    public PGNotify(){
	initNative();
    }

    public void finalize(){
	destroyNative();
    }

    public static void main(String[] args) {
	PGNotify p = new PGNotify();
	p.connect("server",5432,"database","user","passwd");
	p.listen("some_identifier");
	String id = p.blockForNotify(2000);
        System.out.println("block: "+(id!=null?id:"Timed out."));
	p.disconnect();
    }
}
