/*-------------------------------------------------------------------------
 *
 * pg_xlogfile.c
 *	  display xlog filename, given an xlog offset.
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "funcapi.h"
#include "catalog/pg_type.h"
#include "access/xlog_internal.h"
#include "utils/builtins.h"

Datum		pg_xlogfile_from_offset(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(pg_xlogfile_from_offset);
Datum
pg_xlogfile_from_offset(PG_FUNCTION_ARGS)
{
	text	   *offset = PG_GETARG_TEXT_P(0);
	char	   *offsetstr;
	uint32		xlogid;			
	uint32		xrecoff;		
	uint32		xlogseg;
	XLogRecPtr	offsetpoint;
	char		xlogfilename[MAXFNAMELEN];

	text	   *result;

	offsetstr = DatumGetCString(DirectFunctionCall1(textout,
												 PointerGetDatum(offset)));

	if (sscanf(offsetstr, "%X/%X", &xlogid, &xrecoff) != 2)
    	ereport(ERROR,
				(errcode(ERRCODE_DATA_EXCEPTION),
				 errmsg("could not parse xlog offset \"%s\"",
						offsetstr)));

    offsetpoint.xlogid = xlogid;
    offsetpoint.xrecoff = xrecoff;

	XLByteToSeg(offsetpoint, xlogid, xlogseg);
	XLogFileName(xlogfilename, ThisTimeLineID, xlogid, xlogseg);

	result = DatumGetTextP(DirectFunctionCall1(textin,
										 CStringGetDatum(xlogfilename)));

	PG_RETURN_TEXT_P(result);
}
