#!/usr/bin/perl -w
# Profile postgresql connections
use DBI;


$ip=$ARGV[0] || '--help';
$dbname=$ARGV[1] || 'template1';
$dbuser=$ARGV[2] || 'postgres';
$dbpass=$ARGV[3] || 'private';

my $idle_count=0;
my $longidle_count=0;
my $nonidle_count;
my $resting_count=0;
my $count=0;
my $total_count=0;

my ($datname,$query,$duration,$slow,$username);

	#Connect to Database
	my $Con = "DBI:Pg:dbname=$dbname;host=$ip";
	my $Dbh = DBI->connect($Con, $dbuser, $dbpass, {RaiseError =>1}) || die "Unable to access Database $dbname on host $ip as user $dbuser.\nError returned was: ". $DBI::errstr;

        $sql_max="SHOW max_connections;";
        $sth_max = $Dbh->prepare($sql_max);
        $sth_max->execute();
        while (($mconn) = $sth_max->fetchrow()) {
                $max_conn=$mconn;
        }


	my $sql="SELECT datname
	,current_query
	,timeofday()::TIMESTAMP-query_start
	, (CASE WHEN timeofday()::TIMESTAMP-query_start > INTERVAL '5 minutes' THEN TRUE ELSE FALSE END) AS slow
	,usename
	FROM pg_stat_activity
    ;";

	my $sth = $Dbh->prepare($sql);
	$sth->execute();
	while (($query,$duration,$slow) = $sth->fetchrow()) {
		#if slow is true (perl sees true as 1)
		if ($slow =~ /1/i)
		{
			if ($query =~/\<IDLE\>/i)
			{
				$longidle_count++;
			}
		}

		if ( ($query =~/\<IDLE\>/i) || (length($query) == 0) )
		{
			$idle_count++;
		}
		elsif ($query =~/[\t\s]/)
		{
			$resting_count++;
			#stop showing details of the resting queries
			#$detail=1;
		}

		$total_count++;
	}
	$Dbh->disconnect;

	$nonidle_count=$total_count-$idle_count;
	$used_pct=sprintf("%2.1f", $total_count/$max_conn*100);
	
	print "$total_count\n";
	print "$used_pct\n"; 
	print "$nonidle_count\n";
	print "$idle_count\n";
	print "$longidle_count\n";
	print "$resting_count\n"; 
