/*
 * checktoast.c
 *
 * Check the actual status of a possibly toasted datum
 *
 * Joe Conway <mail@joeconway.com>
 *
 * Copyright (c) 2001-2003, PostgreSQL Global Development Group
 * ALL RIGHTS RESERVED;
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without a written agreement
 * is hereby granted, provided that the above copyright notice and this
 * paragraph and the following two paragraphs appear in all copies.
 *
 * IN NO EVENT SHALL THE AUTHOR OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
 * LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 * DOCUMENTATION, EVEN IF THE AUTHOR OR DISTRIBUTORS HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHOR AND DISTRIBUTORS SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE AUTHOR AND DISTRIBUTORS HAS NO OBLIGATIONS TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 */
#include "postgres.h"

#include "fmgr.h"
#include "utils/builtins.h"

#define GET_TEXT(cstrp) DatumGetTextP(DirectFunctionCall1(textin, CStringGetDatum(cstrp)))

extern Datum checktoast(PG_FUNCTION_ARGS);
PG_FUNCTION_INFO_V1(checktoast);
Datum
checktoast(PG_FUNCTION_ARGS)
{
	Datum		datum = PG_GETARG_DATUM(0);
	varattrib  *attr = (varattrib *) datum;

	if (VARATT_IS_EXTERNAL(attr))
	{
		if (VARATT_IS_COMPRESSED(attr))
		{
			/* this is an external stored compressed value */
			PG_RETURN_TEXT_P(GET_TEXT("external,compressed"));
		}
		else
		{
			/* this is an external stored plain value */
			PG_RETURN_TEXT_P(GET_TEXT("external,uncompressed"));
		}
	}
	else if (VARATT_IS_COMPRESSED(attr))
	{
		/* this is a compressed value inside of the main tuple */
		PG_RETURN_TEXT_P(GET_TEXT("inline,compressed"));
	}
	else

		/* this is a plain value inside of the main tuple */
		PG_RETURN_TEXT_P(GET_TEXT("inline,uncompressed"));
}
