/*
 * contrib/randomize_xmin/randomize_xmin.c
 */
#include "postgres.h"

#include "access/heapam.h"
#include "access/htup_details.h"
#include "storage/bufmgr.h"

#ifdef PG_MODULE_MAGIC
PG_MODULE_MAGIC;
#endif

PG_FUNCTION_INFO_V1(randomize_xmin);

Datum
randomize_xmin(PG_FUNCTION_ARGS)
{
	Oid			heapOid = PG_GETARG_OID(0);
	int32		xminLower = PG_GETARG_INT32(1);
	int32		xminUpper = PG_GETARG_INT32(2);
	BlockNumber	nblocks, blocknum;
	Relation	rel;

	rel = relation_open(heapOid, AccessExclusiveLock);
	nblocks = RelationGetNumberOfBlocks(rel);

	for (blocknum = 0; blocknum < nblocks; blocknum++)
	{
		Buffer			buf;
		Page			page;
		OffsetNumber	offnum,
						maxoff;

		buf = ReadBuffer(rel, blocknum);
		LockBuffer(buf, BUFFER_LOCK_EXCLUSIVE);
		page = BufferGetPage(buf);

		maxoff = PageGetMaxOffsetNumber(page);

		for (offnum = FirstOffsetNumber;
			 offnum <= maxoff;
			 offnum = OffsetNumberNext(offnum))
		{
			ItemId				itemid;
			HeapTupleHeader		htup;
			HeapTupleData		tuple;

			itemid = PageGetItemId(page, offnum);

			if (!ItemIdIsNormal(itemid))
				continue;

			htup = (HeapTupleHeader) PageGetItem(page, itemid);

			htup->t_infomask &= ~HEAP_XMIN_COMMITTED;
#ifdef HeapTupleSetXmin
			HeapTupleHeaderSetXmin(page, htup, xminLower + random() % (xminUpper - xminLower + 1));
#else
			HeapTupleHeaderSetXmin(htup, xminLower + random() % (xminUpper - xminLower + 1));
#endif
		}
		MarkBufferDirty(buf);
		UnlockReleaseBuffer(buf);
	}
	relation_close(rel, AccessExclusiveLock);

	PG_RETURN_VOID();
}
