#!/usr/bin/perl
#------------------------------------------------------------------------------
# Project  : LINCAT E-BUSINESS software
# Name     : lincat-indexer.pl
# Language : 5.005_03 built for i386-linux
# OS       : linux RedHat 6.1 kernel 2.2.12-32
# Author   : Gilles Darold, gilles@darold.net
# Copyright: Copyright (c) 1998-2000 : Gilles Darold - All rights reserved -
# Function : Script use to create a text search index.
# Usage    : See documentation.
#------------------------------------------------------------------------------
# Version control :
# $Id$
#------------------------------------------------------------------------------
use strict;

# Packages used. 
use DBI ();
use DBD::Pg ();
use Benchmark;

my $DEBUG = 0;

#### EDIT THE FOLLOWING VARIABLES TO MATCH YOU CONFIGURATION ####

my $dbname = 'testdb';				# Database name
my $port = '5432';				# Port of the database
my $host = 'localhost';				# Hostname of the database
my @tables = qw/t_item/;			# Liste of table to base search
my @fields = qw/s_name_id s_description_id/;	# List of field to base seach
my $display = 's_name_id';			# The field to be displayed if a word match
my @types = qw//;				# Limit search on this list of type
my @customers = ();				# Limit search on this list of customer
my $language = 'fr';				# Search language
my $stopwords = '/usr/tmp/stop.fr.txt';		# Word to not look for
my $user = '';					# User allowed to connect to the database 
my $passwd = '';				# Password for this user

#### END OF EDIT ####

my $t0 = new Benchmark;

# Do not bufferize
$| = 1;

#---------- Load the stop words into memory
my @stopper = ();
if ( $stopwords ) {
	local(*STOPFILE) = undef;
	local($/) = '';
	unless ( open(STOPFILE, $stopwords) ) {
		print "ERROR Lincat-indexer : Can't open file $stopwords, $!\n";
		exit(0);
	}
	my $stop = <STOPFILE>;
	close(STOPFILE);
	$/ = "\n";
	@stopper = split(/\n/, $stop);
}

my $nb = 0;
my $found = 0;
#---------- Connect to the database
my $dbsrc = "dbi:Pg:dbname=$dbname;host=$host;port=$port";
my $dbh = DBI->connect($dbsrc, $user, $passwd, {AutoCommit => 0});
if (!$dbh) {
	print "ERROR Lincat-indexer : ", $DBI::errstr, ".\n";
	exit(0);
}

# Get all word to search
my $w = join(' ', @ARGV);
my @words = ();
# Remove unwanted words and doublon
foreach my $m ( split(/[\W\b]/, $w) ) {
	$m =~ s/s$//;
	$m =~ s/x$//;
	push(@words, $m) if ( (length($m) > 1) && !grep(/^$m$/, @stopper) &&  !grep(/^$m$/, @words) );
}
$nb += $#words+1;

# Find the first words registered
my @refs = ();
foreach ( @words ) {
	# Find the registered word with exactly the string
	push( @refs, &search_aword($dbh, lc($_)) );
}
my @links = ();
if ( $#refs >= 0 ) {
	# Get all object associated to theses words
	foreach ( @refs ) {
		print "Working with reference: $_\n" if ( $DEBUG );
		# Extract all object associated with this word
		push( @links, &search_links($dbh, $_, \@types, \@customers, \@tables, \@fields) );
	}
}

# Ok now display result following pertinance
# First those who contain all world
my %item = ();
# For each word reference
for my $r ( 0 .. $#links ) {
	if (exists $item{"$links[$r][1]"} ) {
		$item{"$links[$r][1]"} += 1;
	} else {
		$item{"$links[$r][1]"} = 1;
	}
}
foreach (sort { $item{$b} <=> $item{$a} } keys %item) {
	#print "$_ = $item{$_}\n";
	$found++;
	print &get_string($dbh, \@tables, $display, $_), "\n";
}

#----------- Approximative search
# Find the first words registered
@refs = ();
foreach ( @words ) {
	# Find the registered word with exactly the string
	push( @refs, &search_approx($dbh, lc($_)) );
}
@links = ();
if ( $#refs >= 0 ) {
	# Get all object associated to theses words
	foreach ( @refs ) {
		print "Working with reference: $_\n" if ( $DEBUG );
		# Extract all object associated with this word
		push( @links, &search_links($dbh, $_, \@types, \@customers, \@tables, \@fields) );
	}
}

# Ok now display result following pertinance
# First those who contain all world
%item = ();
# For each word reference
for my $r ( 0 .. $#links ) {
	if (exists $item{"$links[$r][1]"} ) {
		$item{"$links[$r][1]"} += 1;
	} else {
		$item{"$links[$r][1]"} = 1;
	}
}
foreach (sort { $item{$b} <=> $item{$a} } keys %item) {
	#print "$_ = $item{$_}\n";
	$found++;
	print &get_string($dbh, \@tables, $display, $_), "\n";
}


#---------- Disconnect from the database
$dbh->disconnect();

my $t1 = new Benchmark;
print "Search $nb words - $found object founds in : ", timestr(timediff($t1, $t0)), "\n";
print "Done...\n";

#-------------------------------------------------------------------------

sub search_aword {
	my ($conn, $word) = @_;

	#------------- Create the SQL search query
	my $cmd = "SELECT s_reference FROM t_dic_$language WHERE s_word='$word'";
	my $cur = $conn->prepare($cmd);
	$cur->execute();
	if ($DBI::err) {
		print "Error lincat-search : $cmd\n";
		$conn->rollback;
		$conn->disconnect();
		exit(0);
	} else {
		$conn->commit;
	}

	#-------------  Store all tuples returned
	my $data = $cur->fetchrow;

	$data;

}


sub search_approx {
	my ($conn, $word) = @_;

	#------------- Create the SQL search query
	my $cmd = "SELECT s_reference FROM t_dic_$language WHERE s_word!='$word' AND s_word LIKE '%$word%';";
	my $cur = $conn->prepare($cmd);
	$cur->execute();
	if ($DBI::err) {
		print "Error lincat-search : $cmd\n";
		$conn->rollback;
		$conn->disconnect();
		exit(0);
	} else {
		$conn->commit;
	}

	#-------------  Store all tuples returned
	my $data = $cur->fetchrow;

	$data;

}


sub search_wordlink {
	my ($conn, $word, $refobj, $type, $cust, $tbs, $fld) = @_;

	#------------- Create the SQL search query
	my $cmd = "SELECT * FROM t_link_dic_${language} WHERE t_dic_$language.s_word='$word' AND t_link_dic_$language.s_ref_dic=t_dic_$language.s_reference AND t_link_dic_$language.s_ref_obj='$refobj'";
	if ($#{$type} >= 0) {
		$cmd .= " AND (";
		foreach ( @$type ) {
			$cmd .= "t_link_dic_$language.s_type='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$cust} >= 0) {
		$cmd .= " AND (";
		foreach ( @$cust ) {
			$cmd .= "t_link_dic_$language.s_ref_user='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$tbs} >= 0) {
		$cmd .= " AND (";
		foreach ( @$tbs ) {
			$cmd .= "t_link_dic_$language.s_table='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$fld} >= 0) {
		$cmd .= " AND (";
		foreach ( @$fld ) {
			$cmd .= "t_link_dic_$language.s_field='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	my $cur = $conn->prepare($cmd);
	$cur->execute();
	if ($DBI::err) {
		print "Error lincat-search : $cmd\n";
		$conn->rollback;
		$conn->disconnect();
		exit(0);
	} else {
		$conn->commit;
	}

	#-------------  Store all tuples returned
	my @data = ();
	while (my $array_ref = $cur->fetch) {
		push(@data, [ @$array_ref ]);
	}

	$cur->finish;

	@data;

}


sub search_links {
	my ($conn, $refdic, $type, $cust, $tbs, $fld) = @_;

	#------------- Create the SQL search query
	my $cmd = "SELECT * FROM t_link_dic_$language WHERE s_ref_dic='$refdic'";
	if ($#{$type} >= 0) {
		$cmd .= " AND (";
		foreach ( @$type ) {
			$cmd .= "s_type='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$cust} >= 0) {
		$cmd .= " AND (";
		foreach ( @$cust ) {
			$cmd .= "s_ref_user='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$tbs} >= 0) {
		$cmd .= " AND (";
		foreach ( @$tbs ) {
			$cmd .= "s_table='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	if ($#{$fld} >= 0) {
		$cmd .= " AND (";
		foreach ( @$fld ) {
			$cmd .= "s_field='$_' OR ";
		}
		$cmd =~ s/ OR $//;
		$cmd .= ")";
	}
	my $cur = $conn->prepare($cmd);
	$cur->execute();
	if ($DBI::err) {
		print "Error lincat-search : $cmd\n";
		$conn->rollback;
		$conn->disconnect();
		exit(0);
	} else {
		$conn->commit;
	}

	#-------------  Store all tuples returned
	my @data = ();
	while (my $array_ref = $cur->fetch) {
		push(@data, [ @$array_ref ]);
	}

	$cur->finish;

	@data;

}


sub get_string {
	my ($conn, $table, $field, $ref) = @_;

	#------------- Create the SQL search query
	foreach my $tbl ( @$table ) {
		my $cmd = "SELECT s_string FROM t_translate WHERE $tbl.s_reference='$ref' AND $tbl.$field=t_translate.s_id AND t_translate.s_ref_language='$language';";
		my $cur = $conn->prepare($cmd);
		$cur->execute();
		if ($DBI::err) {
			print "Error lincat-search : $cmd\n";
			$conn->rollback;
			$conn->disconnect();
			exit(0);
		} else {
			$conn->commit;
		}

		#-------------  Store all tuples returned
		my $data = $cur->fetchrow;
		if ($data) {
			return $data;
		}
	}

}


