/*

  Implementation of bit1 bitmask class.

  Adriaan Joubert <adriaan@albourne.com>

*/

#include <stdio.h>	
#include <stdlib.h>
#include <string.h>
#include "postgres.h"

typedef unsigned char bit1;

bool bit1eq (bit1 *a, bit1 *b) {
  return *a==*b;
}

bool bit1ne (bit1 *a, bit1 *b) {
  return *a!=*b;
}

bool bit1lt (bit1 *a, bit1 *b) {
  return *a<*b;
}

bool bit1le (bit1 *a, bit1 *b) {
  return *a<=*b;
}

bool bit1gt (bit1 *a, bit1 *b) {
  return *a>*b;
}

bool bit1ge (bit1 *a, bit1 *b) {
  return *a>=*b;
}

int4 bit1cmp (bit1 *a, bit1 *b) {
  if (*a < *b) 
    return -1;
  else
    if (*a == *b)
      return 0;
    else
      return 1;
}

bit1 *bit1or (bit1 *a, bit1 *b) {
  bit1 *result = palloc(sizeof(bit1));
  if ((!PointerIsValid(a)) || (!PointerIsValid(a)))
    return NULL;
  *result = *a | *b;
  return result;
}

bit1 *bit1and (bit1 *a, bit1 *b) {
  bit1 *result = palloc(sizeof(bit1));
  if ((!PointerIsValid(a)) || (!PointerIsValid(a)))
    return NULL;
  *result = *a & *b;
  return result;
}

bit1 *bit1xor (bit1 *a, bit1 *b) {
  bit1 *result = palloc(sizeof(bit1));
  if ((!PointerIsValid(a)) || (!PointerIsValid(a)))
    return NULL;
  *result = *a ^ *b;
  return result;
}

bit1 *bit1not (bit1 *a) {
  bit1 *result = palloc(sizeof(bit1));
  if (!PointerIsValid(a))
    return NULL;
  *result = ~ (*a);
  return result;
}

bit1 *bit1left (bit1 *a, int4 s) {
  bit1 *result = palloc(sizeof(bit1));
  if (!PointerIsValid(a))
    return NULL;
  *result = *a << s;
  return result;
}

bit1 *bit1right (bit1 *a, int4 s) {
  bit1 *result = palloc(sizeof(bit1));
  if (!PointerIsValid(a))
    return NULL;
  *result = *a >> s;
  return result;
}

bit1 *bit1bit (bit1 *a) {
  bit1 *result = palloc(sizeof(bit1));
  if (!PointerIsValid(a))
    return NULL;
  *result = (*a)==0 ? 0 : 1;
  return result;
}

bit1 *
bit1_in(char *str)
{
  bit1 *result;
  bit1 x = 0;
  int val;
  int i;
  if (str[0] == 'B' || str[0] == 'b') {
    if (strlen(str)>9) {
      elog(ERROR,"Cannot parse %s as BIT1 as out of range",str);
      return NULL;
    }
    for (i=1; i<strlen(str); i++) {
      if (str[i]>='0' && str[i]<='1') {
        x <<= 1;
        x += str[i]=='1' ? 1 : 0;
      } else {
        elog(ERROR,"Cannot parse %s as a bit string",str);
        return NULL;
      }
    }
  } else if (str[0] == 'X' || str[0] == 'x') {
    if (strlen(str)>3) {
      elog(ERROR,"Cannot parse %s as BIT1 as out of range",str);
      return NULL;
    }
    for (i=1; i<strlen(str); i++) {
      x <<= 4;
      if (str[i]>='0' && str[i]<='9') {
        x += (bit1) (str[i] - '0');
      } else if (str[i]>='A' && str[i]<='F') {
        x += (bit1) (str[i] - 'A') + 10;
      } else if (str[i]>='a' && str[i]<='f') {
        x += (bit1) (str[i] - 'a') + 10;
      } else {
        elog(ERROR,"Cannot parse %s as a hex string",str);
        return NULL;
      }
    }
  } else if (sscanf(str,"%d",&val)==1) {
    if (val>255 || val<0) {
      elog(ERROR,"Cannot parse %d as BIT1 as out of range",val);
      return NULL;
    }
    x = val;
  } else {
    elog(ERROR,"Cannot parse %s as BIT1",str);
    return NULL;
  }
  result = (bit1 *)palloc(sizeof(bit1));
  *result = x;
  return (result);
}

char * bit1_out (bit1 *a) {
  char *out = 0;
  int i;
  if (!PointerIsValid(a))
    return NULL;
  out = (char *) palloc(10);
  out[0] = 'b';
  for (i=1; i<=8; i++)
    out[i] = ((*a)>>(8-i))%2 ? '1' : '0';
  out[9]='\0';
  return out;
}

/* Conversion function */
bit1 *bit1int4 (int4 a) {
  bit1 *result = palloc(sizeof(bit1));
  if (a > 0xFF || a<0)
    elog(ERROR, "int4 conversion to bit1 is out of range", NULL);
  *result = a;
  return result;
}

bool bit1bool (bit1 *a) {
  return (*a)>0;
}

int4 bit1int (bit1 *a) {
  return (int4) (*a);
}


/* hashing function nicked straight from postgres hash for chars */
#define PRIME1 37             /* Defined in include/utils/hsearch.h */
#define PRIME2 1048583        /* Defined in include/utils/hsearch.h */

uint32
bit1hash(bit1 *key)
{
    int             len;
    uint32          h;

    h = 0;
    /* Convert char to integer */
    h = h * PRIME1 ^ (*key - ' ');
    h %= PRIME2;

    return h;
}
