CREATE DATABASE fdw_test;
CREATE DATABASE fdw_test_remote;

\c fdw_test_remote

CREATE TABLE foo(id BIGINT PRIMARY KEY);
CREATE TABLE foo_1(LIKE foo INCLUDING ALL) INHERITS (foo);
CREATE TABLE foo_2(LIKE foo INCLUDING ALL) INHERITS (foo);
CREATE TABLE foo_3(LIKE foo INCLUDING ALL) INHERITS (foo);

INSERT INTO foo_1 SELECT id + 100000 FROM generate_series(1, 10) AS id;
INSERT INTO foo_2 SELECT id + 200000 FROM generate_series(1, 10) AS id;
INSERT INTO foo_3 SELECT id + 300000 FROM generate_series(1, 10) AS id;

\c fdw_test

CREATE EXTENSION IF NOT EXISTS postgres_fdw;

CREATE SERVER fdw_server_test FOREIGN DATA WRAPPER postgres_fdw OPTIONS (dbname 'fdw_test_remote');

CREATE USER MAPPING FOR current_user SERVER fdw_server_test;

CREATE FOREIGN TABLE foo(id BIGINT) SERVER fdw_server_test;

BEGIN;
\echo Should return IDs 200006 and 300005
SELECT * FROM foo WHERE id = ANY('{200006,300005}'::bigint[]);
\echo Should return IDs 200006 and 300005
WITH x AS (DELETE FROM foo WHERE id = ANY('{200006,300005}'::bigint[]) RETURNING *) SELECT * FROM x;
ROLLBACK;

BEGIN;
\echo Should return ID 200006
SELECT * FROM foo WHERE id = 200006;
\echo Should return ID 200006
WITH x AS (DELETE FROM foo WHERE id = 200006 RETURNING *) SELECT * FROM x;
ROLLBACK;

BEGIN;
\echo Should return ID 300005
SELECT * FROM foo WHERE id = 300005;
\echo Should return ID 300005
WITH x AS (DELETE FROM foo WHERE id = 300005 RETURNING *) SELECT * FROM x;
ROLLBACK;

\c postgres

DROP DATABASE fdw_test;
DROP DATABASE fdw_test_remote;
