--
-- PostgreSQL database dump
--

-- Started on 2009-01-10 11:37:08

SET client_encoding to 'LATIN1';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 1771 (class 1262 OID 20225)
-- Name: velasco; Type: DATABASE; Schema: -; Owner: sa
--



CREATE SCHEMA mscompat;


ALTER SCHEMA mscompat OWNER TO sa;

--
-- TOC entry 319 (class 2612 OID 16386)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: postgres
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO postgres;

SET search_path = mscompat, pg_catalog;

--
-- TOC entry 1499 (class 1259 OID 16586)
-- Dependencies: 1576 5
-- Name: sysdatabases; Type: VIEW; Schema: mscompat; Owner: postgres
--

update pg_cast set castcontext = 'a' where castsource = 'int'::regtype 
and casttarget = 'bool'::regtype ;


CREATE VIEW sysdatabases AS
    SELECT pg_database.datname AS name, 'None' AS filename FROM pg_database;


ALTER TABLE mscompat.sysdatabases OWNER TO postgres;

--
-- TOC entry 1498 (class 1259 OID 16582)
-- Dependencies: 1575 5
-- Name: sysindexes; Type: VIEW; Schema: mscompat; Owner: postgres
--

CREATE VIEW sysindexes AS
    SELECT pg_class.relname AS name FROM pg_class;


ALTER TABLE mscompat.sysindexes OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1497 (class 1259 OID 16579)
-- Dependencies: 5
-- Name: sysobjects; Type: TABLE; Schema: mscompat; Owner: postgres; Tablespace: 
--

CREATE TABLE sysobjects (
    id integer,
    xtype character(2),
    type character(2),
    name character(20)
);


ALTER TABLE mscompat.sysobjects OWNER TO postgres;

--
-- TOC entry 26 (class 1255 OID 16598)
-- Dependencies: 319 5
-- Name: boolcomp(boolean, integer); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION boolcomp(b1 boolean, i1 integer) RETURNS boolean
    AS $$ begin return b1 = cast(i1 as bool); end; $$
    LANGUAGE plpgsql;


ALTER FUNCTION mscompat.boolcomp(b1 boolean, i1 integer) OWNER TO postgres;

--
-- TOC entry 20 (class 1255 OID 16575)
-- Dependencies: 5 319
-- Name: bytea(integer); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION bytea(integer) RETURNS bytea
    AS $_$ 
begin return cast ($1 as bytea); end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION mscompat.bytea(integer) OWNER TO postgres;

--
-- TOC entry 27 (class 1255 OID 16601)
-- Dependencies: 5
-- Name: concat(character varying, character varying); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION concat(str1 character varying, str2 character varying) RETURNS character varying
    AS $_$ select $1 || $2; $_$
    LANGUAGE sql;


ALTER FUNCTION mscompat.concat(str1 character varying, str2 character varying) OWNER TO postgres;

--
-- TOC entry 34 (class 1255 OID 17731)
-- Dependencies: 5
-- Name: day(timestamp without time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION day(timestamp without time zone) RETURNS integer
    AS $_$ select extract('day' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.day(timestamp without time zone) OWNER TO postgres;

--
-- TOC entry 37 (class 1255 OID 17734)
-- Dependencies: 5
-- Name: day(timestamp with time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION day(timestamp with time zone) RETURNS integer
    AS $_$ select extract('day' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.day(timestamp with time zone) OWNER TO postgres;

--
-- TOC entry 40 (class 1255 OID 17737)
-- Dependencies: 5
-- Name: day(date); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION day(date) RETURNS integer
    AS $_$ select extract('day' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.day(date) OWNER TO postgres;

--
-- TOC entry 32 (class 1255 OID 16611)
-- Dependencies: 5
-- Name: getdate(); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION getdate() RETURNS timestamp without time zone
    AS $$
select current_timestamp::timestamp;  $$
    LANGUAGE sql;


ALTER FUNCTION mscompat.getdate() OWNER TO postgres;

--
-- TOC entry 22 (class 1255 OID 16592)
-- Dependencies: 5
-- Name: identity(integer, integer); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION identity(i1 integer, i2 integer) RETURNS integer
    AS $$
select nextval('syssequence')::integer;  $$
    LANGUAGE sql;


ALTER FUNCTION mscompat.identity(i1 integer, i2 integer) OWNER TO postgres;

--
-- TOC entry 33 (class 1255 OID 16612)
-- Dependencies: 5
-- Name: isnull(anyelement, anyelement); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION "isnull"(invalue anyelement, rvalue anyelement) RETURNS anyelement
    AS $_$ 
select coalesce ($1, $2); 
$_$
    LANGUAGE sql;


ALTER FUNCTION mscompat."isnull"(invalue anyelement, rvalue anyelement) OWNER TO postgres;

--
-- TOC entry 35 (class 1255 OID 17732)
-- Dependencies: 5
-- Name: month(timestamp without time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION month(timestamp without time zone) RETURNS integer
    AS $_$ select extract('month' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.month(timestamp without time zone) OWNER TO postgres;

--
-- TOC entry 38 (class 1255 OID 17735)
-- Dependencies: 5
-- Name: month(timestamp with time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION month(timestamp with time zone) RETURNS integer
    AS $_$ select extract('month' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.month(timestamp with time zone) OWNER TO postgres;

--
-- TOC entry 41 (class 1255 OID 17738)
-- Dependencies: 5
-- Name: month(date); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION month(date) RETURNS integer
    AS $_$ select extract('month' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.month(date) OWNER TO postgres;

--
-- TOC entry 21 (class 1255 OID 16590)
-- Dependencies: 5 319
-- Name: object_id(character varying); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION object_id(obj character varying) RETURNS integer
    AS $$ begin 
declare objname varchar(200); begin
objname := lower(obj); objname := trim(both ' ' from objname);
if exists (select * from pg_class where relname = objname) then return 1; end if; 
if exists (select * from pg_trigger where tgname = objname) then return 1; end if; 
if exists (select * from pg_proc where proname = objname) then return 1; end if; 
return null; end; end; $$
    LANGUAGE plpgsql;


ALTER FUNCTION mscompat.object_id(obj character varying) OWNER TO postgres;

--
-- TOC entry 23 (class 1255 OID 16593)
-- Dependencies: 5
-- Name: objectproperty(integer, character varying); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION objectproperty(id integer, obj character varying) RETURNS integer
    AS $$ select 1;  $$
    LANGUAGE sql;


ALTER FUNCTION mscompat.objectproperty(id integer, obj character varying) OWNER TO postgres;

--
-- TOC entry 24 (class 1255 OID 16594)
-- Dependencies: 5
-- Name: safediv(double precision, double precision); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION safediv(double precision, double precision) RETURNS double precision
    AS $_$ 
select case when $2 != 0 then $1/$2 else 0 end ;
$_$
    LANGUAGE sql;


ALTER FUNCTION mscompat.safediv(double precision, double precision) OWNER TO postgres;

--
-- TOC entry 25 (class 1255 OID 16596)
-- Dependencies: 5
-- Name: safediv(bigint, bigint); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION safediv(bigint, bigint) RETURNS bigint
    AS $_$ 
select case when $2 != 0 then $1/$2 else 0 end ;
$_$
    LANGUAGE sql;


ALTER FUNCTION mscompat.safediv(bigint, bigint) OWNER TO postgres;

--
-- TOC entry 28 (class 1255 OID 16603)
-- Dependencies: 319 5
-- Name: sp_rename(character varying, character varying); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION sp_rename(x character varying, y character varying) RETURNS void
    AS $$
begin execute ' alter table ' || x || ' rename to ' || y ; end; $$
    LANGUAGE plpgsql;


ALTER FUNCTION mscompat.sp_rename(x character varying, y character varying) OWNER TO postgres;

--
-- TOC entry 29 (class 1255 OID 16604)
-- Dependencies: 5 319
-- Name: sp_rename(character varying, character varying, character varying); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION sp_rename(x character varying, y character varying, z character varying) RETURNS void
    AS $_$
declare tab text ;
declare col text;
begin 
tab = substring(x from '^[^.]*');
col = substring(x from '[^.]*$');
execute ' alter table ' || tab || ' rename column  ' || col || ' to ' || y  ; 
end; $_$
    LANGUAGE plpgsql;


ALTER FUNCTION mscompat.sp_rename(x character varying, y character varying, z character varying) OWNER TO postgres;

--
-- TOC entry 36 (class 1255 OID 17733)
-- Dependencies: 5
-- Name: year(timestamp without time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION year(timestamp without time zone) RETURNS integer
    AS $_$ select extract('year' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.year(timestamp without time zone) OWNER TO postgres;

--
-- TOC entry 39 (class 1255 OID 17736)
-- Dependencies: 5
-- Name: year(timestamp with time zone); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION year(timestamp with time zone) RETURNS integer
    AS $_$ select extract('year' from $1)::integer; $_$
    LANGUAGE sql STABLE;


ALTER FUNCTION mscompat.year(timestamp with time zone) OWNER TO postgres;

--
-- TOC entry 42 (class 1255 OID 17739)
-- Dependencies: 5
-- Name: year(date); Type: FUNCTION; Schema: mscompat; Owner: postgres
--

CREATE FUNCTION year(date) RETURNS integer
    AS $_$ select extract('year' from $1)::integer; $_$
    LANGUAGE sql STABLE strict;


ALTER FUNCTION mscompat.year(date) OWNER TO postgres;

create or replace function str(anyelement, integer) returns text as $$
select cast($1 as text);
$$ language sql strict;

alter function mscompat.str(anyelement, integer) owner to postgres;

create or replace function space(integer) returns text as $$
select repeat(' ', $1);
$$ language sql strict;

alter function mscompat.space(integer) owner to postgres;

--
-- TOC entry 1026 (class 2617 OID 16602)
-- Dependencies: 5 27
-- Name: +; Type: OPERATOR; Schema: mscompat; Owner: postgres
--

CREATE OPERATOR + (
    PROCEDURE = concat,
    LEFTARG = character varying,
    RIGHTARG = character varying,
    COMMUTATOR = +
);


ALTER OPERATOR mscompat.+ (character varying, character varying) OWNER TO postgres;

--
-- TOC entry 1024 (class 2617 OID 16600)
-- Dependencies: 5 26
-- Name: =; Type: OPERATOR; Schema: mscompat; Owner: postgres
--

CREATE OPERATOR = (
    PROCEDURE = boolcomp,
    LEFTARG = boolean,
    RIGHTARG = integer,
    COMMUTATOR = =
);


ALTER OPERATOR mscompat.= (boolean, integer) OWNER TO postgres;

--
-- TOC entry 1022 (class 2617 OID 16595)
-- Dependencies: 24 5
-- Name: ?; Type: OPERATOR; Schema: mscompat; Owner: postgres
--

CREATE OPERATOR ? (
    PROCEDURE = safediv,
    LEFTARG = double precision,
    RIGHTARG = double precision,
    COMMUTATOR = ?
);


ALTER OPERATOR mscompat.? (double precision, double precision) OWNER TO postgres;

--
-- TOC entry 1023 (class 2617 OID 16597)
-- Dependencies: 5 25
-- Name: ?; Type: OPERATOR; Schema: mscompat; Owner: postgres
--

CREATE OPERATOR ? (
    PROCEDURE = safediv,
    LEFTARG = bigint,
    RIGHTARG = bigint,
    COMMUTATOR = ?
);


ALTER OPERATOR mscompat.? (bigint, bigint) OWNER TO postgres;

SET search_path = pg_catalog;

--
-- TOC entry 1618 (class 2605 OID 16576)
-- Dependencies: 20 20
-- Name: CAST (integer AS bytea); Type: CAST; Schema: pg_catalog; Owner: 
--

CREATE CAST (integer AS bytea) WITH FUNCTION mscompat.bytea(integer) AS IMPLICIT;


SET search_path = mscompat, pg_catalog;

--
-- TOC entry 1496 (class 1259 OID 16577)
-- Dependencies: 5
-- Name: syssequence; Type: SEQUENCE; Schema: mscompat; Owner: postgres
--

CREATE SEQUENCE syssequence
    START WITH 10
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE mscompat.syssequence OWNER TO postgres;

-- Completed on 2009-01-10 11:37:08

--
-- PostgreSQL database dump complete
--

