OPT_HOST="-h localhost"
USER=postgres

for x in $(psql $OPT_HOST -c "SELECT datname FROM pg_database WHERE datname ~ 'shard.*' " postgres -A -t)

do
	echo dropping $x
	dropdb $OPT_HOST $x
done;

createdb $OPT_HOST shard

psql $OPT_HOST -U $USER shard -c "
	CREATE EXTENSION postgres_fdw;
	CREATE TABLE customers(id int primary key, name varchar);
	INSERT INTO customers VALUES (0, 'me'), (1, 'you'),
	       (2, 'he'), (3, 'she');
	CREATE TABLE products(id int, price float4)
	       PARTITION BY RANGE (id);
	CREATE TABLE orders(customer_id int, product_id int)
	       PARTITION BY RANGE (product_id);"
createdb $OPT_HOST shard_0
psql $OPT_HOST -U $USER shard_0 -c "
		CREATE TABLE products_0 AS
		SELECT g.i AS id,
		       (trunc(100 * random()) / 10 + 1)::float4 AS price
	       	FROM generate_series(1, 1000) AS g(i);
		CREATE INDEX ON products_0(id);
		CREATE TABLE orders_0 AS
		SELECT trunc(2 * random())::int AS customer_id,
		       trunc(1000 * random())::int AS product_id
		FROM generate_series(1, 5000);
		ANALYZE;"
psql $OPT_HOST -U $USER shard -c "
		CREATE SERVER server_0 FOREIGN DATA WRAPPER postgres_fdw
			OPTIONS (host 'localhost', dbname 'shard_0', fetch_size '1000',
			use_remote_estimate 'true', fdw_tuple_cost '10');
		CREATE USER MAPPING FOR CURRENT_USER SERVER server_0 OPTIONS (user '$USER');
		IMPORT FOREIGN SCHEMA public FROM SERVER server_0 INTO public;
		ALTER TABLE products ATTACH PARTITION products_0 FOR VALUES FROM (1) TO (1001);
		ALTER TABLE orders ATTACH PARTITION orders_0 FOR VALUES FROM (1) TO (1001);"

createdb $OPT_HOST shard_1
psql $OPT_HOST -U $USER shard_1 -c "
		CREATE TABLE products_1 AS
		SELECT g.i AS id,
		       (trunc(100 * random()) / 10 + 1)::float4 AS price
		FROM generate_series(1001, 2000) AS g(i);
		CREATE INDEX ON products_1(id);
		CREATE TABLE orders_1 AS
		SELECT trunc(2 * random())::int + 2 AS customer_id,
		       trunc(1000 * random())::int + 1001 AS product_id
		FROM generate_series(1, 5000);
		ANALYZE;"
psql $OPT_HOST -U $USER shard -c "
		CREATE SERVER server_1 FOREIGN DATA WRAPPER postgres_fdw
			OPTIONS (host 'localhost', dbname 'shard_1', fetch_size '1000',
			use_remote_estimate 'true', fdw_tuple_cost '10');
		CREATE USER MAPPING FOR CURRENT_USER SERVER server_1 OPTIONS (user '$USER');
		IMPORT FOREIGN SCHEMA public FROM SERVER server_1 INTO public;
		ALTER TABLE products ATTACH PARTITION products_1 FOR VALUES FROM (1001) TO (2001);
		ALTER TABLE orders ATTACH PARTITION orders_1 FOR VALUES FROM (1001) TO (2001);"

