/* partial--1.0.sql */

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION partial" to load this file. \quit

CREATE FUNCTION partial_state_in (
	state		cstring
)
RETURNS state
AS 'MODULE_PATHNAME', 'partial_state_in'
LANGUAGE C
STABLE;

CREATE FUNCTION partial_state_out (
	state		state
)
RETURNS cstring
AS 'MODULE_PATHNAME', 'partial_state_out'
LANGUAGE C
STABLE;

-- Value of this type should never be stored on disk, so omit the related
-- attributes.
CREATE TYPE state (
       INPUT = partial_state_in,
       OUTPUT = partial_state_out,

       -- Hacks to ensure the same treatment that the core state gets.
       -- TODO Check the related PG code and improve these comments.
       INTERNALLENGTH = 4,
       PASSEDBYVALUE
);

CREATE FUNCTION partial_state_to_bytea (
	state		state
)
RETURNS bytea
AS 'MODULE_PATHNAME', 'partial_state_to_bytea'
LANGUAGE C
PARALLEL SAFE
STABLE;

CREATE CAST (state AS bytea) WITH FUNCTION partial_state_to_bytea(state);

CREATE FUNCTION numeric_accum_partial (
       state		state,
       arg		numeric
) RETURNS state
AS 'MODULE_PATHNAME', 'numeric_accum_partial'
PARALLEL SAFE
LANGUAGE C;

CREATE AGGREGATE avg(numeric) (
       SFUNC = numeric_accum_partial,
       STYPE = state,
       PARALLEL = safe
);

CREATE AGGREGATE sum(numeric) (
       SFUNC = numeric_accum_partial,
       STYPE = state,
       PARALLEL = safe
);

CREATE AGGREGATE count(numeric) (
       SFUNC = int8inc_any,
       STYPE = int8,
       INITCOND = '0',
       PARALLEL = safe
);

CREATE AGGREGATE avg(int4) (
       SFUNC = int4_avg_accum,
       INITCOND = '{0, 0}',
       STYPE = _int8,
       PARALLEL = safe
);

CREATE AGGREGATE sum(int4) (
       SFUNC = int4_sum,
       STYPE = int8,
       PARALLEL = safe
);

CREATE AGGREGATE avg(float4) (
       SFUNC = float4_accum,
       INITCOND = '{0, 0, 0}',
       STYPE = _float8,
       COMBINEFUNC = float8_combine,
       PARALLEL = safe
);

CREATE AGGREGATE sum(float4) (
       SFUNC = float4pl,
       STYPE = float4,
       COMBINEFUNC = float4pl,
       PARALLEL = safe
);

CREATE AGGREGATE count(float4) (
       SFUNC = int8inc_any,
       STYPE = int8,
       INITCOND = '0',
       COMBINEFUNC = int8pl,
       PARALLEL = safe
);

CREATE AGGREGATE count(*) (
       SFUNC = int8inc,
       STYPE = int8,
       INITCOND = '0',
       COMBINEFUNC = int8pl,
       PARALLEL = safe
);
