// odbctest1.cpp 
//

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#include <locale.h>

int odbc_test2()
{
	SQLRETURN rc, rc2;
	HENV henv;
	HDBC hdbc;
	SQLHSTMT hstmt;
	SQLTCHAR    szSqlState[10] = { 0 };
	SQLINTEGER  fNativeError;
	SQLTCHAR    szErrorMsg[1000] = { 0 };
	SQLSMALLINT cbErrorMsg;
	SQLLEN colsize;
	SQLINTEGER int4var;
	TCHAR buffer2[1000] = { 0 };
	TCHAR buffer3[1000] = { 0 };
	SQLTCHAR sqlstate[6] = ".....";

	_tprintf(_T("*** odbc_test2 ***\n"));

	rc = SQLAllocEnv(&henv);
	_tprintf(_T("SQLAllocEnv: %d\n"), rc);
	if (rc) return rc;

	rc = SQLAllocConnect(henv, &hdbc);
	_tprintf(_T("SQLAllocConnect: %d\n"), rc);
	if (rc) return rc;

	rc = SQLConnect(hdbc, (SQLTCHAR*)_T("pgsql_local_ansi_eucdb"), SQL_NTS, (SQLTCHAR*)_T("postgres"), SQL_NTS, (SQLTCHAR*)_T("pgsql"), SQL_NTS);
	_tprintf(_T("SQLConnect: %hd\n "), rc);
	switch (rc)
	{
	case SQL_SUCCESS:
		_tprintf(_T(" SQL_SUCCESS\n"));
		break;
	case SQL_SUCCESS_WITH_INFO:
		_tprintf(_T(" SQL_SUCCESS_WITH_INFO\n"));
		break;
	case SQL_ERROR:
		_tprintf(_T(" SQL_ERROR\n"));
		rc = SQLGetDiagRec(SQL_HANDLE_DBC, hdbc, 1, sqlstate, NULL, NULL, 0, NULL);
		_tprintf(_T("  SQLSTATE: %s\n "), sqlstate);
		break;
	case SQL_INVALID_HANDLE:
		_tprintf(_T(" SQL_INVALID_HANDLE\n"));
		break;
	case SQL_STILL_EXECUTING:
		_tprintf(_T(" SQL_STILL_EXECUTING\n"));
		break;
	}
	if (rc) return rc;

	rc = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &hstmt);
	_tprintf(_T("SQLAllocHandle(STMT): %hd\n "), rc);
	if (rc) return rc;

	rc = SQLExecDirect(hstmt, (SQLTCHAR*)_T("SELECT id, 'xxxx' AS v, {d '2017-08-15'} AS a FROM t1"), SQL_NTS);
	_tprintf(_T("SQLExecDirect: %hd\n "), rc);
	if (rc) return rc;

	do {
		rc = SQLFetch(hstmt);
		_tprintf(_T("\nSQLFetch: %hd\n "), rc);
		if (rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO)
		{
			SQLGetDiagRec(SQL_HANDLE_STMT, hstmt, 1, szSqlState, &fNativeError, szErrorMsg, sizeof(fNativeError), &cbErrorMsg);
			_tprintf(_T("  SQLGetDiagRec: %S : %d : %S\n"), szSqlState, cbErrorMsg, szErrorMsg);
		}
		if (rc == SQL_ERROR || rc == SQL_NO_DATA) return rc;

		rc2 = SQLGetData(hstmt, 1, SQL_C_LONG, &int4var, 4, &colsize);
		_tprintf(_T("SQLGetData1: %hd\n "), rc2);
		if (rc2 == SQL_ERROR) return rc2;

		rc2 = SQLGetData(hstmt, 2, SQL_C_TCHAR, buffer2, 1000, &colsize);
		_tprintf(_T("SQLGetData2: %hd\n "), rc2);
		if (rc2 == SQL_ERROR) return rc2;

		rc2 = SQLGetData(hstmt, 3, SQL_C_TCHAR, buffer3, 1000, &colsize);
		_tprintf(_T("SQLGetData3: %hd\n "), rc2);
		if (rc2 == SQL_ERROR) return rc2;

		_tprintf(_T(" id = %d, v = '%s', a = '%s' \n"), int4var, buffer2, buffer3);

	} while (rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO);

	_tprintf(_T("odbc_test1 Fin\n"));
	SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
	SQLDisconnect(hdbc);
	SQLFreeConnect(hdbc);
	return 0;
}

int _tmain(int argc, _TCHAR* argv[])
{
	TCHAR dummy;
	int r;

	_tsetlocale(LC_ALL, _T(""));
	_tprintf(_T("start\n"));

	r = (int)odbc_test2();
	_tprintf(_T("end rc=%d \n(pause)"), r);
	fflush(stdout);
	_tscanf_s(_T("%c"), &dummy, 1);
	return 0;
}
