#/bin/bash

for logged in "logged" "unlogged" ; do
  for i in 1 2 ; do
    for br in baseline2 baseline2_hashsnap2 baseline2_hashsnap2_lwlock; do
      (
	cd ~/Projects/postgrespro10
	make distclean > /dev/null 2>&1
	git checkout $br
	make distclean > /dev/null 2>&1
	./configure --prefix=/data/ysokolov/pghome_combo/ --enable-depend --enable-debug > /dev/null 2>&1
	make -j 32 install > /dev/null 2>&1 
	cd contrib
	make -j 32 install > /dev/null 2>&1
      )
	pg_ctl stop -w -t 900
	rm ~/pghome/data -rf
	initdb
	cp ~/pghome/postgresql.conf ~/pghome/data/
	pg_ctl start -w -t 900
	sleep 10
	createdb
	if [[ $logged == "logged" ]] ; then
	    pgbench_zipf -i -s 10
	else
	    pgbench_zipf -i -s 10 --unlogged-tables
	fi
	psql -c "create extension pageinspect"
	pg_ctl restart -w -t 900
	mkdir test_${br}_${logged}_${i}
	(
		cd test_${br}_${logged}_${i}
		for c in 10 20 40 70 110 160 230 310 400 500 650 800 ; do
			pgbench_zipf -s 10 -c $c -j 100 -M prepared -T 450 \
				-f ../ycsb_read_zipf.sql -f ../ycsb_update_zipf.sql -P 5 2>&1 \
				| tee pgbench_${c}.out
			psql -f ../btree_bloat.sql > btree_bloat_${c}.out
		done
	)
    done
  done
done
