hsh = {}
tsts = {}
Dir.glob('test_*/pgbench*.out') do |fl|
  if fl =~ /test_(.*)_\d\/pgbench_(\d+)/
    test, clients = $1, $2.to_i
    case test
    when /baseline2(_(un)?logged)/
      test = 'master'+$1
    when /baseline2_(.*_(un)?logged)/
      test = $1
    end
  else
    next
  end
  tps = File.readlines(fl).grep(/tps = (\d+)\..*including/).first[/\d+/].to_i
  tsts[test] = true
  hsh[clients] ||= {}
  hsh[clients][test] ||= []
  hsh[clients][test] << tps
end

hsh.each do |_, tests|
  tests.each do |test, tps|
    tests[test] = tps.inject(:+) / tps.size
  end
end

tsts.keys.partition{|s| s=~/unlogged/}.each do |names|
  next if names.empty?
  if names[0] =~ /_((un)?logged)$/
    puts $1.capitalize
  end
  short = names.map{|k| k[/^(.*)_(un)?logged$/, 1]}
  widths = short.map{|k| k.size}
  fmt = "%7s |" + widths.map{|w| " %#{w}s "}.join("|")
  puts format(fmt, "clients", *short)
  puts "--------+" + widths.map{|w| "-"*(w+2)}.join("+")

  fmt = "%7d |" + widths.map{|w| " %#{w}d "}.join("|")
  hsh.sort.each do |cl, tests|
    puts format(fmt, cl, *tests.values_at(*names))
  end
end
