hsh = {}
Dir.glob('test_*/pgbench*.out') do |fl|
  if fl =~ /test_baseline2_(?:(.*)_)?\d\/pgbench_tellers_(\d+)/
    test, clients = $1, $2.to_i
    test = 'master' if test == '' || test.nil?
  end
  tps = File.readlines(fl)[-1][/tps = (\d+)/,1].to_i
  hsh[clients] ||= {}
  hsh[clients][test] ||= []
  hsh[clients][test] << tps
end

hsh.each do |_, tests|
  tests.each do |test, tps|
    tests[test] = tps.inject(:+) / tps.size
  end
end

puts format("%7s | %8s | %8s | %s", *%w{clients master hashsnap hashsnap+lwlock})
puts "--------+----------+----------+--------------"

hsh.sort.each do |cl, tests|
  puts format("%7d | %8d | %8d | %8d", cl, *tests.values_at(*%w{master hashsnap hashsnap_lwlock}))
end
