#!/bin/bash

function pg_ctl_stop() {
	pg_ctl stop
	while [ -n "$(ps aux | grep '\<postgres\>' | grep -v grep)" ] ; do sleep 1; done
}

pg_ctl start
for jj in 1 2 3; do
for br in master master_ring16; do
	pgbench -i -s 400 -n
	pg_ctl_stop
	sleep 10
	(
		cd ~/Projects/postgres
		git checkout $br
		make -j 16 install
	)
	mkdir test_${br}_${jj}
	(
		cd test_${br}_${jj}
		ls -l ~/pghome/data/base/16384/1[6789]???* > ls_start.txt
		pg_ctl start -l server.log
		sleep 10
		pgbench -c 40 -j 40 -n -T $((3600*8)) -M prepared \
		       	-l --aggregate-interval=30 -P 30 -s 400 -f ../bloat.sql \
			2>&1 | tee pgbench.out
		ls -l ~/pghome/data/base/16384/1[6789]???* > ls_end.txt
	)
done
done
pg_ctl_stop
