// psqlodbc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "psqlodbc.h"

#include <vector>
#include <thread>
#include <assert.h> 

#include "publict1.h"
#include "publict2.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// The one and only application object

CWinApp theApp;

using namespace std;

void thread_stress_db();
LONG insert(CDatabase* pcdb, CString table_name, CString guid, CString& err);

int main()
{
    int nRetCode = 0;

    HMODULE hModule = ::GetModuleHandle(nullptr);

    if (hModule != nullptr)
    {
        // initialize MFC and print and error on failure
        if (!AfxWinInit(hModule, nullptr, ::GetCommandLine(), 0))
        {
            // TODO: change error code to suit your needs
            wprintf(L"Fatal Error: MFC initialization failed\n");
            nRetCode = 1;
        }
        else
        {
			std::vector<std::thread> threads;
			for (int i = 0; i < 50; i++)
				{
				threads.push_back(std::thread(thread_stress_db));
				}

			for (auto&& t : threads)
				{
				t.join();
				}
			}
    }
    else
    {
        // TODO: change error code to suit your needs
        wprintf(L"Fatal Error: GetModuleHandle failed\n");
        nRetCode = 1;
    }

    return nRetCode;
}

void thread_stress_db()
	{
	CString err;
	int i = 0;
	LONG rtn = 0;
	wchar_t wbuf[40] = { 0 };
	GUID guid;
	CString guidString;

	CDatabase db;

	try { db.OpenEx(_T("DSN=pgLocal;UID=mr_tester;PWD=testing"), CDatabase::useCursorLib); }
	catch (CDBException* e) { rtn = e->m_nRetCode; err = e->m_strError; e->Delete(); }

	assert(db.IsOpen());

	for (i = 0; i < 100; i++)
		{
		if (CoCreateGuid(&guid) == S_OK)
			{
			StringFromGUID2(guid, wbuf, 40);
			guidString = CString(wbuf);
			}
		else rtn = -1;
		assert(rtn == 0);

		rtn = insert(&db, _T("t1"), guidString, err);
		assert(rtn == 0);
		Sleep(10);

		rtn = insert(&db, _T("t2"), guidString, err);
		assert(rtn == 0);
		Sleep(10);
		}
	}

LONG insert(CDatabase* pcdb, CString table_name, CString guid, CString& err)
	{
	LONG rtn = 0;

	if (table_name == "t1")
		{
		Cpublict1 t(pcdb);
		try { t.Open(CRecordset::snapshot); }
		catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }

		if (rtn == 0)
			{
			try { t.AddNew(); }
			catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }
			}

		if (rtn == 0)
			{
			t.m_t1g = guid;
			try { t.Update(); }
			catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }
			}

		if (t.IsOpen()) t.Close();
		}
	else
		{
		Cpublict2 t(pcdb);
		try { t.Open(CRecordset::snapshot); }
		catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }

		if (rtn == 0)
			{
			try { t.AddNew(); }
			catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }
			}

		if (rtn == 0)
			{
			t.m_t2g = guid;
			try { t.Update(); }
			catch (CDBException* e) { rtn = -1; err = e->m_strError; e->Delete(); }
			}

		if (t.IsOpen()) t.Close();
		}

	return(rtn);
	}
