#!/bin/bash

# Initialise
pgbench -n -c 1 -t 1 -f cic_bug_init.sql -s 100 postgres
pgbench -n -c 20 -f cic_bug.sql -T 1200 -j 20 -s 100 postgres &

while ( true ); do
	psql -At -c "DROP INDEX pgb_a_aid1" postgres
	psql -At -c "CREATE INDEX CONCURRENTLY    pgb_a_aid1 ON cic_tab_accounts(aid1);" postgres
	
	psql -c "ANALYZE cic_tab_accounts" postgres

	# Query with ORDER BY should use IOS while the other query should just do a
	# SeqScan
	#
	psql -c "(select aid1 from cic_tab_accounts order by aid1 desc) except all (select aid1 from cic_tab_accounts)" postgres
	psql -c "(select aid1 from cic_tab_accounts ) except all (select aid1 from cic_tab_accounts order by aid1 desc)" postgres

	psql -c "VACUUM cic_tab_accounts" postgres
	psql -c "(select aid1 from cic_tab_accounts order by aid1 desc) except all (select aid1 from cic_tab_accounts)" postgres
	psql -c "(select aid1 from cic_tab_accounts ) except all (select aid1 from cic_tab_accounts order by aid1 desc)" postgres
	sleep 10

done

