
DROP TABLE IF EXISTS cic_tab_accounts;

CREATE TABLE cic_tab_accounts (
	aid bigint,
	abalance bigint,
	aid1 bigint
);

-- Update using aid1. aid1 should stay within the range (aid * 10 - 2 <= aid1 <= aid * 10 + 2) 
CREATE OR REPLACE FUNCTION cic_tab_update_using_aid1(chg integer, v_aid bigint, delta bigint)
RETURNS VOID AS $$
DECLARE
	range integer;
	aid_updated bigint;
BEGIN
	range := 2;
	UPDATE cic_tab_accounts p SET aid1 = aid1 +  chg,  abalance = abalance +
delta  WHERE aid1 >= v_aid * 10 - range - chg AND aid1 <= v_aid * 10 + range - chg
RETURNING p.aid INTO aid_updated;
END
$$ LANGUAGE plpgsql;


\set start 1
\set end (:start + (:scale * 10000))
INSERT INTO cic_tab_accounts SELECT
	generate_series(:start, :end ),
	0,
	generate_series(:start * 10, :end * 10, 10)
	;
	

CREATE UNIQUE INDEX pgb_a_aid ON cic_tab_accounts(aid);
CREATE INDEX pgb_a_aid1 ON cic_tab_accounts(aid1);

VACUUM ANALYZE;
