#include "postgres.h"
#include "fmgr.h"

#include "commands/event_trigger.h"
#include "executor/spi.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(trigger_test_ddl_command_end);

Datum
trigger_test_ddl_command_end(PG_FUNCTION_ARGS)
{
	const char *query;
	int			result;

	if (!CALLED_AS_EVENT_TRIGGER(fcinfo))
		elog(ERROR, "not fired by event trigger manager");

	query = "SELECT objid, UPPER(object_type), object_identity,\n"
			"  UPPER(command_tag)\n"
			"  FROM pg_catalog.pg_event_trigger_ddl_commands()";

	/* Attempt to connect */
	result = SPI_connect();
	if (result < 0)
		elog(ERROR, "pgaudit_ddl_command_end: SPI_connect returned %d",
			 result);

	/* Execute the query */
	result = SPI_execute(query, true, 0);
	if (result != SPI_OK_SELECT)
		elog(ERROR, "pgaudit_ddl_command_end: SPI_execute returned %d",
			 result);

	/* Complete the query */
	SPI_finish();

	PG_RETURN_NULL();
}