BEGIN;

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: postgres; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON DATABASE postgres IS 'default administrative connection database';


--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: obce; Type: TABLE; Schema: public; Owner: pavel; Tablespace: 
--

CREATE TABLE obce (
    id integer NOT NULL,
    okres_id character varying(6),
    nazev character varying(40),
    pocet_muzu integer,
    pocet_zen integer,
    vek_muzu numeric(3,1),
    vek_zen numeric(3,1)
);


ALTER TABLE public.obce OWNER TO pavel;

--
-- Name: obce_id_seq; Type: SEQUENCE; Schema: public; Owner: pavel
--

CREATE SEQUENCE obce_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.obce_id_seq OWNER TO pavel;

--
-- Name: obce_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: pavel
--

ALTER SEQUENCE obce_id_seq OWNED BY obce.id;


--
-- Name: okresy; Type: TABLE; Schema: public; Owner: pavel; Tablespace: 
--

CREATE TABLE okresy (
    id text NOT NULL,
    nazev text
);


ALTER TABLE public.okresy OWNER TO pavel;

--
-- Name: id; Type: DEFAULT; Schema: public; Owner: pavel
--

ALTER TABLE ONLY obce ALTER COLUMN id SET DEFAULT nextval('obce_id_seq'::regclass);


--
-- Data for Name: obce; Type: TABLE DATA; Schema: public; Owner: pavel
--

INSERT INTO obce VALUES (1, 'CZ0100', 'Praha', 608316, 640710, 39.8, 43.2);
INSERT INTO obce VALUES (2, 'CZ0201', 'Benešov', 7875, 8507, 39.2, 41.9);
INSERT INTO obce VALUES (3, 'CZ0201', 'Bernartice', 108, 115, 45.9, 43.3);
INSERT INTO obce VALUES (4, 'CZ0201', 'Bílkovice', 93, 89, 41.4, 46.8);
INSERT INTO obce VALUES (5, 'CZ0201', 'Blažejovice', 52, 48, 44.6, 50.8);
INSERT INTO obce VALUES (6, 'CZ0201', 'Borovnice', 39, 37, 45.6, 49.5);
INSERT INTO obce VALUES (7, 'CZ0201', 'Bukovany', 364, 372, 38.1, 38.8);
INSERT INTO obce VALUES (8, 'CZ0201', 'Bystřice', 2124, 2096, 38.5, 41.1);
INSERT INTO obce VALUES (9, 'CZ0201', 'Ctiboř', 55, 50, 38.6, 42.0);
INSERT INTO obce VALUES (10, 'CZ0201', 'Čakov', 65, 60, 36.4, 40.6);
INSERT INTO obce VALUES (11, 'CZ0201', 'Čechtice', 678, 763, 39.5, 41.2);
INSERT INTO obce VALUES (12, 'CZ0201', 'Čerčany', 1349, 1339, 38.9, 41.8);
INSERT INTO obce VALUES (13, 'CZ0201', 'Červený Újezd', 161, 142, 38.9, 42.4);
INSERT INTO obce VALUES (14, 'CZ0201', 'Český Šternberk', 83, 65, 41.9, 51.7);
INSERT INTO obce VALUES (15, 'CZ0201', 'Čtyřkoly', 246, 268, 37.2, 38.8);
INSERT INTO obce VALUES (16, 'CZ0201', 'Děkanovice', 33, 27, 39.3, 52.8);
INSERT INTO obce VALUES (17, 'CZ0201', 'Divišov', 749, 753, 38.0, 41.6);
INSERT INTO obce VALUES (18, 'CZ0201', 'Dolní Kralovice', 472, 463, 39.5, 42.5);
INSERT INTO obce VALUES (19, 'CZ0201', 'Drahňovice', 30, 34, 33.7, 46.0);
INSERT INTO obce VALUES (20, 'CZ0201', 'Dunice', 31, 31, 48.3, 50.4);
INSERT INTO obce VALUES (21, 'CZ0201', 'Heřmaničky', 342, 347, 40.7, 43.1);
INSERT INTO obce VALUES (22, 'CZ0201', 'Hradiště', 20, 15, 41.2, 56.5);
INSERT INTO obce VALUES (23, 'CZ0201', 'Hulice', 159, 142, 41.6, 42.2);
INSERT INTO obce VALUES (24, 'CZ0201', 'Hvězdonice', 154, 161, 42.1, 42.3);
INSERT INTO obce VALUES (25, 'CZ0201', 'Chářovice', 82, 94, 38.1, 39.8);
INSERT INTO obce VALUES (26, 'CZ0201', 'Chleby', 29, 30, 43.6, 45.5);
INSERT INTO obce VALUES (27, 'CZ0201', 'Chlístov', 142, 166, 36.8, 38.1);
INSERT INTO obce VALUES (28, 'CZ0201', 'Chlum', 77, 62, 44.3, 44.0);
INSERT INTO obce VALUES (29, 'CZ0201', 'Chmelná', 64, 54, 35.5, 40.7);
INSERT INTO obce VALUES (30, 'CZ0201', 'Chocerady', 541, 587, 39.9, 41.6);
INSERT INTO obce VALUES (31, 'CZ0201', 'Choratice', 39, 33, 36.3, 38.8);
INSERT INTO obce VALUES (32, 'CZ0201', 'Chotýšany', 234, 223, 37.7, 41.3);
INSERT INTO obce VALUES (33, 'CZ0201', 'Chrášťany', 87, 108, 41.5, 41.3);
INSERT INTO obce VALUES (34, 'CZ0201', 'Jankov', 404, 473, 40.1, 41.9);
INSERT INTO obce VALUES (35, 'CZ0201', 'Javorník', 64, 61, 43.8, 36.9);
INSERT INTO obce VALUES (36, 'CZ0201', 'Ješetice', 66, 64, 39.1, 42.5);
INSERT INTO obce VALUES (37, 'CZ0201', 'Kamberk', 86, 73, 46.9, 49.5);
INSERT INTO obce VALUES (38, 'CZ0201', 'Keblov', 91, 84, 43.1, 46.4);
INSERT INTO obce VALUES (39, 'CZ0201', 'Kladruby', 106, 120, 43.9, 40.5);
INSERT INTO obce VALUES (40, 'CZ0201', 'Kondrac', 224, 245, 38.3, 38.2);
INSERT INTO obce VALUES (41, 'CZ0201', 'Kozmice', 112, 134, 40.5, 41.1);
INSERT INTO obce VALUES (42, 'CZ0201', 'Krhanice', 461, 480, 39.3, 42.9);
INSERT INTO obce VALUES (43, 'CZ0201', 'Krňany', 191, 171, 41.3, 46.5);
INSERT INTO obce VALUES (44, 'CZ0201', 'Křečovice', 364, 363, 38.9, 41.6);
INSERT INTO obce VALUES (45, 'CZ0201', 'Křivsoudov', 214, 193, 41.0, 42.1);
INSERT INTO obce VALUES (46, 'CZ0201', 'Kuňovice', 42, 42, 41.3, 44.4);
INSERT INTO obce VALUES (47, 'CZ0201', 'Lešany', 321, 328, 38.8, 39.5);
INSERT INTO obce VALUES (48, 'CZ0201', 'Libež', 76, 92, 39.8, 37.8);
INSERT INTO obce VALUES (49, 'CZ0201', 'Litichovice', 19, 29, 43.1, 48.9);
INSERT INTO obce VALUES (50, 'CZ0201', 'Loket', 281, 268, 38.9, 44.2);
INSERT INTO obce VALUES (51, 'CZ0201', 'Louňovice pod Blaníkem', 318, 346, 42.1, 42.1);
INSERT INTO obce VALUES (52, 'CZ0201', 'Lštění', 186, 164, 41.3, 47.4);
INSERT INTO obce VALUES (53, 'CZ0201', 'Maršovice', 352, 360, 38.7, 41.4);
INSERT INTO obce VALUES (54, 'CZ0201', 'Mezno', 168, 168, 39.4, 43.9);
INSERT INTO obce VALUES (55, 'CZ0201', 'Miličín', 417, 439, 40.1, 44.2);
INSERT INTO obce VALUES (56, 'CZ0201', 'Miřetice', 72, 74, 38.9, 41.7);
INSERT INTO obce VALUES (57, 'CZ0201', 'Mnichovice', 102, 102, 38.6, 46.0);
INSERT INTO obce VALUES (58, 'CZ0201', 'Mrač', 353, 384, 40.3, 40.6);
INSERT INTO obce VALUES (59, 'CZ0201', 'Načeradec', 526, 502, 40.6, 45.3);
INSERT INTO obce VALUES (60, 'CZ0201', 'Nespeky', 301, 295, 37.4, 39.3);
INSERT INTO obce VALUES (61, 'CZ0201', 'Netvořice', 557, 554, 38.8, 40.5);
INSERT INTO obce VALUES (62, 'CZ0201', 'Neustupov', 283, 255, 39.8, 41.7);
INSERT INTO obce VALUES (63, 'CZ0201', 'Neveklov', 1259, 1218, 38.3, 40.7);
INSERT INTO obce VALUES (64, 'CZ0201', 'Olbramovice', 593, 573, 38.9, 40.8);
INSERT INTO obce VALUES (65, 'CZ0201', 'Ostrov', 40, 25, 38.8, 45.2);
INSERT INTO obce VALUES (66, 'CZ0201', 'Ostředek', 159, 172, 39.4, 39.1);
INSERT INTO obce VALUES (67, 'CZ0201', 'Pavlovice', 91, 96, 37.1, 39.9);
INSERT INTO obce VALUES (68, 'CZ0201', 'Petroupim', 132, 160, 38.9, 38.6);
INSERT INTO obce VALUES (69, 'CZ0201', 'Popovice', 141, 134, 44.0, 44.7);
INSERT INTO obce VALUES (70, 'CZ0201', 'Poříčí nad Sázavou', 570, 574, 38.6, 41.9);
INSERT INTO obce VALUES (71, 'CZ0201', 'Postupice', 602, 563, 40.9, 41.6);
INSERT INTO obce VALUES (72, 'CZ0201', 'Pravonín', 280, 268, 38.6, 42.5);
INSERT INTO obce VALUES (73, 'CZ0201', 'Přestavlky u Čerčan', 139, 145, 39.3, 40.0);
INSERT INTO obce VALUES (74, 'CZ0201', 'Psáře', 72, 60, 45.3, 46.9);
INSERT INTO obce VALUES (75, 'CZ0201', 'Pyšely', 773, 834, 36.9, 40.2);
INSERT INTO obce VALUES (76, 'CZ0201', 'Rabyně', 124, 135, 44.5, 40.7);
INSERT INTO obce VALUES (77, 'CZ0201', 'Radošovice', 153, 159, 40.7, 38.7);
INSERT INTO obce VALUES (78, 'CZ0201', 'Rataje', 91, 87, 37.6, 44.9);
INSERT INTO obce VALUES (79, 'CZ0201', 'Ratměřice', 132, 128, 39.3, 42.2);
INSERT INTO obce VALUES (80, 'CZ0201', 'Řehenice', 180, 172, 45.8, 42.8);
INSERT INTO obce VALUES (81, 'CZ0201', 'Řimovice', 111, 89, 37.5, 44.8);
INSERT INTO obce VALUES (82, 'CZ0201', 'Sázava', 1896, 1900, 39.1, 42.3);
INSERT INTO obce VALUES (83, 'CZ0201', 'Slověnice', 21, 16, 47.9, 45.6);
INSERT INTO obce VALUES (84, 'CZ0201', 'Smilkov', 130, 124, 41.6, 47.7);
INSERT INTO obce VALUES (85, 'CZ0201', 'Snět', 50, 46, 44.9, 52.5);
INSERT INTO obce VALUES (86, 'CZ0201', 'Soběhrdy', 193, 172, 38.5, 41.1);
INSERT INTO obce VALUES (87, 'CZ0201', 'Soutice', 111, 120, 44.9, 44.8);
INSERT INTO obce VALUES (88, 'CZ0201', 'Stranný', 64, 51, 35.6, 44.6);
INSERT INTO obce VALUES (89, 'CZ0201', 'Strojetice', 66, 62, 39.6, 46.1);
INSERT INTO obce VALUES (90, 'CZ0201', 'Struhařov', 373, 351, 38.8, 40.0);
INSERT INTO obce VALUES (91, 'CZ0201', 'Střezimíř', 158, 154, 40.2, 43.8);
INSERT INTO obce VALUES (92, 'CZ0201', 'Studený', 55, 38, 36.7, 50.8);
INSERT INTO obce VALUES (93, 'CZ0201', 'Šetějovice', 31, 34, 46.6, 47.0);
INSERT INTO obce VALUES (94, 'CZ0201', 'Tehov', 171, 173, 35.4, 39.3);
INSERT INTO obce VALUES (95, 'CZ0201', 'Teplýšovice', 211, 194, 37.3, 40.4);
INSERT INTO obce VALUES (96, 'CZ0201', 'Tichonice', 101, 97, 40.7, 48.4);
INSERT INTO obce VALUES (97, 'CZ0201', 'Tisem', 112, 103, 40.3, 40.6);
INSERT INTO obce VALUES (98, 'CZ0201', 'Tomice', 61, 80, 37.8, 38.2);
INSERT INTO obce VALUES (99, 'CZ0201', 'Trhový Štěpánov', 685, 677, 39.0, 43.0);
INSERT INTO obce VALUES (100, 'CZ0201', 'Třebešice', 36, 44, 38.6, 47.9);
INSERT INTO obce VALUES (101, 'CZ0201', 'Týnec nad Sázavou', 2733, 2730, 39.7, 42.8);
INSERT INTO obce VALUES (102, 'CZ0201', 'Václavice', 245, 244, 39.5, 41.3);
INSERT INTO obce VALUES (103, 'CZ0201', 'Veliš', 162, 155, 38.9, 38.0);
INSERT INTO obce VALUES (104, 'CZ0201', 'Vlašim', 5937, 6087, 39.8, 43.0);
INSERT INTO obce VALUES (105, 'CZ0201', 'Vodslivy', 47, 44, 39.1, 42.8);
INSERT INTO obce VALUES (106, 'CZ0201', 'Vojkov', 253, 277, 42.4, 46.0);
INSERT INTO obce VALUES (107, 'CZ0201', 'Votice', 2240, 2331, 39.6, 42.5);
INSERT INTO obce VALUES (108, 'CZ0201', 'Vracovice', 192, 177, 39.4, 40.8);
INSERT INTO obce VALUES (109, 'CZ0201', 'Vranov', 169, 175, 40.6, 43.3);
INSERT INTO obce VALUES (110, 'CZ0201', 'Vrchotovy Janovice', 458, 489, 37.3, 38.8);
INSERT INTO obce VALUES (111, 'CZ0201', 'Všechlapy', 37, 44, 46.5, 40.4);
INSERT INTO obce VALUES (112, 'CZ0201', 'Vysoký Újezd', 101, 98, 42.1, 43.6);
INSERT INTO obce VALUES (113, 'CZ0201', 'Xaverov', 33, 24, 36.8, 36.7);
INSERT INTO obce VALUES (114, 'CZ0201', 'Zdislavice', 271, 275, 39.0, 40.7);
INSERT INTO obce VALUES (115, 'CZ0201', 'Zvěstov', 191, 199, 44.3, 44.2);
INSERT INTO obce VALUES (116, 'CZ0202', 'Bavoryně', 105, 104, 36.0, 37.9);
INSERT INTO obce VALUES (117, 'CZ0202', 'Beroun', 9007, 9609, 38.3, 41.5);
INSERT INTO obce VALUES (118, 'CZ0202', 'Běštín', 151, 149, 41.9, 45.8);
INSERT INTO obce VALUES (119, 'CZ0202', 'Broumy', 430, 431, 38.5, 41.8);
INSERT INTO obce VALUES (120, 'CZ0202', 'Březová', 123, 150, 39.6, 39.7);
INSERT INTO obce VALUES (121, 'CZ0202', 'Bubovice', 114, 131, 35.8, 42.7);
INSERT INTO obce VALUES (122, 'CZ0202', 'Bykoš', 110, 110, 40.3, 43.4);
INSERT INTO obce VALUES (123, 'CZ0202', 'Bzová', 223, 216, 40.6, 44.5);
INSERT INTO obce VALUES (124, 'CZ0202', 'Cerhovice', 510, 515, 40.2, 41.5);
INSERT INTO obce VALUES (125, 'CZ0202', 'Drozdov', 341, 361, 39.6, 42.4);
INSERT INTO obce VALUES (126, 'CZ0202', 'Felbabka', 130, 125, 39.9, 45.5);
INSERT INTO obce VALUES (127, 'CZ0202', 'Hlásná Třebaň', 366, 402, 39.0, 38.2);
INSERT INTO obce VALUES (128, 'CZ0202', 'Hořovice', 3234, 3517, 39.9, 43.0);
INSERT INTO obce VALUES (129, 'CZ0202', 'Hostomice', 830, 789, 39.8, 42.4);
INSERT INTO obce VALUES (130, 'CZ0202', 'Hředle', 174, 176, 39.2, 42.8);
INSERT INTO obce VALUES (131, 'CZ0202', 'Hudlice', 612, 611, 40.5, 43.3);
INSERT INTO obce VALUES (132, 'CZ0202', 'Hvozdec', 110, 106, 42.9, 46.7);
INSERT INTO obce VALUES (133, 'CZ0202', 'Hýskov', 751, 776, 37.6, 40.4);
INSERT INTO obce VALUES (134, 'CZ0202', 'Chaloupky', 241, 222, 40.1, 41.4);
INSERT INTO obce VALUES (135, 'CZ0202', 'Chlustina', 117, 120, 41.9, 40.2);
INSERT INTO obce VALUES (136, 'CZ0202', 'Chodouň', 316, 285, 38.8, 40.8);
INSERT INTO obce VALUES (137, 'CZ0202', 'Chrustenice', 387, 404, 36.1, 39.8);
INSERT INTO obce VALUES (138, 'CZ0202', 'Chyňava', 840, 855, 39.7, 43.4);
INSERT INTO obce VALUES (139, 'CZ0202', 'Jivina', 103, 86, 40.0, 45.4);
INSERT INTO obce VALUES (140, 'CZ0202', 'Karlštejn', 359, 360, 41.7, 44.7);
INSERT INTO obce VALUES (141, 'CZ0202', 'Komárov', 1231, 1253, 40.2, 42.1);
INSERT INTO obce VALUES (142, 'CZ0202', 'Koněprusy', 110, 99, 35.9, 41.8);
INSERT INTO obce VALUES (143, 'CZ0202', 'Korno', 44, 45, 41.6, 40.9);
INSERT INTO obce VALUES (144, 'CZ0202', 'Kotopeky', 140, 129, 39.2, 43.7);
INSERT INTO obce VALUES (145, 'CZ0202', 'Králův Dvůr', 3429, 3387, 37.0, 39.3);
INSERT INTO obce VALUES (146, 'CZ0202', 'Kublov', 288, 312, 40.5, 41.4);
INSERT INTO obce VALUES (147, 'CZ0202', 'Lážovice', 46, 44, 38.9, 41.6);
INSERT INTO obce VALUES (148, 'CZ0202', 'Lhotka', 152, 155, 39.2, 41.6);
INSERT INTO obce VALUES (149, 'CZ0202', 'Libomyšl', 265, 238, 41.3, 44.0);
INSERT INTO obce VALUES (150, 'CZ0202', 'Liteň', 520, 537, 37.3, 38.2);
INSERT INTO obce VALUES (151, 'CZ0202', 'Loděnice', 841, 843, 37.5, 41.3);
INSERT INTO obce VALUES (152, 'CZ0202', 'Lochovice', 583, 565, 38.0, 40.4);
INSERT INTO obce VALUES (153, 'CZ0202', 'Lužce', 49, 55, 35.9, 40.6);
INSERT INTO obce VALUES (154, 'CZ0202', 'Malá Víska', 43, 41, 50.2, 44.9);
INSERT INTO obce VALUES (155, 'CZ0202', 'Málkov', 48, 46, 39.4, 40.8);
INSERT INTO obce VALUES (156, 'CZ0202', 'Měňany', 133, 141, 39.7, 41.3);
INSERT INTO obce VALUES (157, 'CZ0202', 'Mezouň', 255, 252, 40.4, 41.2);
INSERT INTO obce VALUES (158, 'CZ0202', 'Mořina', 376, 377, 37.0, 37.7);
INSERT INTO obce VALUES (159, 'CZ0202', 'Mořinka', 66, 65, 41.0, 41.0);
INSERT INTO obce VALUES (160, 'CZ0202', 'Nenačovice', 109, 135, 41.1, 38.9);
INSERT INTO obce VALUES (161, 'CZ0202', 'Nesvačily', 74, 67, 38.6, 39.2);
INSERT INTO obce VALUES (162, 'CZ0202', 'Neumětely', 295, 271, 35.8, 41.2);
INSERT INTO obce VALUES (163, 'CZ0202', 'Nižbor', 896, 883, 39.3, 42.0);
INSERT INTO obce VALUES (164, 'CZ0202', 'Nový Jáchymov', 300, 344, 40.4, 41.8);
INSERT INTO obce VALUES (165, 'CZ0202', 'Olešná', 217, 205, 40.6, 43.7);
INSERT INTO obce VALUES (166, 'CZ0202', 'Osek', 377, 400, 41.1, 42.7);
INSERT INTO obce VALUES (167, 'CZ0202', 'Osov', 170, 170, 38.6, 41.4);
INSERT INTO obce VALUES (168, 'CZ0202', 'Otmíče', 76, 81, 40.1, 40.4);
INSERT INTO obce VALUES (169, 'CZ0202', 'Otročiněves', 262, 255, 38.3, 42.0);
INSERT INTO obce VALUES (170, 'CZ0202', 'Podbrdy', 95, 92, 40.2, 46.4);
INSERT INTO obce VALUES (171, 'CZ0202', 'Podluhy', 302, 318, 40.8, 45.2);
INSERT INTO obce VALUES (172, 'CZ0202', 'Praskolesy', 453, 432, 38.4, 42.9);
INSERT INTO obce VALUES (173, 'CZ0202', 'Rpety', 246, 220, 36.6, 40.7);
INSERT INTO obce VALUES (174, 'CZ0202', 'Skřipel', 55, 52, 44.5, 43.4);
INSERT INTO obce VALUES (175, 'CZ0202', 'Skuhrov', 232, 196, 38.5, 41.3);
INSERT INTO obce VALUES (176, 'CZ0202', 'Srbsko', 225, 239, 42.0, 43.3);
INSERT INTO obce VALUES (177, 'CZ0202', 'Stašov', 217, 205, 38.2, 37.9);
INSERT INTO obce VALUES (178, 'CZ0202', 'Suchomasty', 256, 195, 41.3, 45.8);
INSERT INTO obce VALUES (179, 'CZ0202', 'Svatá', 184, 190, 41.3, 44.4);
INSERT INTO obce VALUES (180, 'CZ0202', 'Svatý Jan pod Skalou', 75, 74, 35.6, 39.4);
INSERT INTO obce VALUES (181, 'CZ0202', 'Svinaře', 229, 241, 38.3, 37.0);
INSERT INTO obce VALUES (182, 'CZ0202', 'Tetín', 426, 414, 38.9, 41.2);
INSERT INTO obce VALUES (183, 'CZ0202', 'Tlustice', 471, 445, 39.5, 41.0);
INSERT INTO obce VALUES (184, 'CZ0202', 'Tmaň', 497, 540, 38.3, 40.4);
INSERT INTO obce VALUES (185, 'CZ0202', 'Točník', 114, 105, 38.4, 37.4);
INSERT INTO obce VALUES (186, 'CZ0202', 'Trubín', 161, 154, 36.0, 37.6);
INSERT INTO obce VALUES (187, 'CZ0202', 'Trubská', 63, 75, 40.4, 45.0);
INSERT INTO obce VALUES (188, 'CZ0202', 'Újezd', 314, 318, 38.9, 41.5);
INSERT INTO obce VALUES (189, 'CZ0202', 'Velký Chlumec', 175, 197, 40.3, 42.3);
INSERT INTO obce VALUES (190, 'CZ0202', 'Vinařice', 42, 47, 44.0, 43.9);
INSERT INTO obce VALUES (191, 'CZ0202', 'Vižina', 122, 113, 38.8, 41.7);
INSERT INTO obce VALUES (192, 'CZ0202', 'Vráž', 481, 518, 40.3, 41.7);
INSERT INTO obce VALUES (193, 'CZ0202', 'Všeradice', 210, 199, 38.4, 40.3);
INSERT INTO obce VALUES (194, 'CZ0202', 'Vysoký Újezd', 295, 283, 37.1, 40.4);
INSERT INTO obce VALUES (195, 'CZ0202', 'Zadní Třebaň', 366, 348, 36.6, 43.5);
INSERT INTO obce VALUES (196, 'CZ0202', 'Zaječov', 679, 707, 41.4, 42.9);
INSERT INTO obce VALUES (197, 'CZ0202', 'Záluží', 235, 241, 38.8, 42.2);
INSERT INTO obce VALUES (198, 'CZ0202', 'Zdice', 1948, 2045, 39.3, 42.6);
INSERT INTO obce VALUES (199, 'CZ0202', 'Žebrák', 1052, 1061, 39.2, 41.0);
INSERT INTO obce VALUES (200, 'CZ0202', 'Železná', 120, 133, 36.1, 39.7);
INSERT INTO obce VALUES (201, 'CZ0203', 'Běleč', 170, 156, 39.0, 40.0);
INSERT INTO obce VALUES (202, 'CZ0203', 'Běloky', 76, 60, 39.0, 43.6);
INSERT INTO obce VALUES (203, 'CZ0203', 'Beřovice', 199, 188, 34.9, 39.5);
INSERT INTO obce VALUES (204, 'CZ0203', 'Bílichov', 97, 82, 38.9, 47.6);
INSERT INTO obce VALUES (205, 'CZ0203', 'Blevice', 128, 157, 41.3, 42.0);
INSERT INTO obce VALUES (206, 'CZ0203', 'Brandýsek', 896, 880, 38.4, 41.6);
INSERT INTO obce VALUES (207, 'CZ0203', 'Braškov', 500, 523, 39.5, 42.1);
INSERT INTO obce VALUES (208, 'CZ0203', 'Bratronice', 439, 426, 39.0, 42.7);
INSERT INTO obce VALUES (209, 'CZ0203', 'Buštěhrad', 1327, 1428, 38.0, 41.0);
INSERT INTO obce VALUES (210, 'CZ0203', 'Cvrčovice', 371, 328, 38.0, 41.8);
INSERT INTO obce VALUES (211, 'CZ0203', 'Černuc', 482, 505, 37.9, 41.1);
INSERT INTO obce VALUES (212, 'CZ0203', 'Doksy', 666, 695, 39.0, 42.1);
INSERT INTO obce VALUES (213, 'CZ0203', 'Dolany', 125, 120, 40.1, 42.6);
INSERT INTO obce VALUES (214, 'CZ0203', 'Drnek', 83, 85, 42.0, 47.5);
INSERT INTO obce VALUES (215, 'CZ0203', 'Družec', 513, 498, 40.2, 41.4);
INSERT INTO obce VALUES (216, 'CZ0203', 'Dřetovice', 237, 256, 36.3, 38.7);
INSERT INTO obce VALUES (217, 'CZ0203', 'Dřínov', 173, 150, 38.3, 40.4);
INSERT INTO obce VALUES (218, 'CZ0203', 'Hobšovice', 161, 171, 35.6, 39.6);
INSERT INTO obce VALUES (219, 'CZ0203', 'Horní Bezděkov', 260, 309, 41.8, 37.0);
INSERT INTO obce VALUES (220, 'CZ0203', 'Hořešovice', 130, 112, 37.7, 40.9);
INSERT INTO obce VALUES (221, 'CZ0203', 'Hořešovičky', 66, 61, 42.5, 50.7);
INSERT INTO obce VALUES (222, 'CZ0203', 'Hospozín', 272, 266, 35.2, 37.7);
INSERT INTO obce VALUES (223, 'CZ0203', 'Hostouň', 459, 471, 39.3, 42.2);
INSERT INTO obce VALUES (224, 'CZ0203', 'Hradečno', 240, 256, 40.8, 43.3);
INSERT INTO obce VALUES (225, 'CZ0203', 'Hrdlív', 226, 229, 39.1, 40.9);
INSERT INTO obce VALUES (226, 'CZ0203', 'Hřebeč', 840, 790, 36.6, 38.1);
INSERT INTO obce VALUES (227, 'CZ0203', 'Chržín', 122, 135, 36.6, 36.0);
INSERT INTO obce VALUES (228, 'CZ0203', 'Jarpice', 139, 138, 37.0, 37.2);
INSERT INTO obce VALUES (229, 'CZ0203', 'Jedomělice', 200, 173, 38.2, 41.3);
INSERT INTO obce VALUES (230, 'CZ0203', 'Jemníky', 125, 130, 35.8, 38.1);
INSERT INTO obce VALUES (231, 'CZ0203', 'Kačice', 642, 671, 39.1, 40.7);
INSERT INTO obce VALUES (232, 'CZ0203', 'Kamenné Žehrovice', 879, 889, 40.2, 41.9);
INSERT INTO obce VALUES (233, 'CZ0203', 'Kamenný Most', 209, 201, 39.4, 42.5);
INSERT INTO obce VALUES (234, 'CZ0203', 'Kladno', 33846, 36092, 39.2, 42.3);
INSERT INTO obce VALUES (235, 'CZ0203', 'Klobuky', 527, 536, 38.8, 39.7);
INSERT INTO obce VALUES (236, 'CZ0203', 'Kmetiněves', 130, 133, 35.6, 38.2);
INSERT INTO obce VALUES (237, 'CZ0203', 'Knovíz', 258, 267, 40.2, 41.1);
INSERT INTO obce VALUES (238, 'CZ0203', 'Koleč', 315, 310, 39.7, 41.3);
INSERT INTO obce VALUES (239, 'CZ0203', 'Královice', 80, 66, 39.4, 43.5);
INSERT INTO obce VALUES (240, 'CZ0203', 'Kutrovice', 53, 56, 39.4, 36.4);
INSERT INTO obce VALUES (241, 'CZ0203', 'Kvílice', 43, 44, 39.0, 45.7);
INSERT INTO obce VALUES (242, 'CZ0203', 'Kyšice', 324, 292, 38.7, 42.5);
INSERT INTO obce VALUES (243, 'CZ0203', 'Lány', 956, 972, 38.4, 39.9);
INSERT INTO obce VALUES (244, 'CZ0203', 'Ledce', 267, 216, 42.9, 45.6);
INSERT INTO obce VALUES (245, 'CZ0203', 'Lhota', 280, 301, 41.7, 44.7);
INSERT INTO obce VALUES (246, 'CZ0203', 'Libochovičky', 20, 23, 32.0, 41.7);
INSERT INTO obce VALUES (247, 'CZ0203', 'Libovice', 169, 154, 35.4, 36.3);
INSERT INTO obce VALUES (248, 'CZ0203', 'Libušín', 1515, 1467, 38.1, 40.0);
INSERT INTO obce VALUES (249, 'CZ0203', 'Lidice', 217, 256, 43.8, 44.1);
INSERT INTO obce VALUES (250, 'CZ0203', 'Líský', 37, 40, 45.3, 42.8);
INSERT INTO obce VALUES (251, 'CZ0203', 'Loucká', 64, 66, 40.0, 41.3);
INSERT INTO obce VALUES (252, 'CZ0203', 'Makotřasy', 177, 176, 37.1, 40.2);
INSERT INTO obce VALUES (253, 'CZ0203', 'Malé Kyšice', 172, 185, 41.0, 43.9);
INSERT INTO obce VALUES (254, 'CZ0203', 'Malé Přítočno', 139, 122, 40.7, 43.7);
INSERT INTO obce VALUES (255, 'CZ0203', 'Malíkovice', 175, 193, 41.8, 42.2);
INSERT INTO obce VALUES (256, 'CZ0203', 'Neprobylice', 81, 75, 33.8, 37.6);
INSERT INTO obce VALUES (257, 'CZ0203', 'Neuměřice', 189, 192, 39.4, 40.8);
INSERT INTO obce VALUES (258, 'CZ0203', 'Otvovice', 345, 338, 40.1, 44.6);
INSERT INTO obce VALUES (259, 'CZ0203', 'Páleč', 86, 92, 42.4, 39.7);
INSERT INTO obce VALUES (260, 'CZ0203', 'Pavlov', 52, 49, 39.8, 42.4);
INSERT INTO obce VALUES (261, 'CZ0203', 'Pchery', 976, 919, 39.2, 42.4);
INSERT INTO obce VALUES (262, 'CZ0203', 'Pletený Újezd', 209, 251, 40.7, 41.8);
INSERT INTO obce VALUES (263, 'CZ0203', 'Plchov', 92, 91, 39.9, 40.2);
INSERT INTO obce VALUES (264, 'CZ0203', 'Podlešín', 145, 142, 41.3, 39.5);
INSERT INTO obce VALUES (265, 'CZ0203', 'Poštovice', 101, 109, 41.3, 43.6);
INSERT INTO obce VALUES (266, 'CZ0203', 'Pozdeň', 235, 224, 36.6, 41.8);
INSERT INTO obce VALUES (267, 'CZ0203', 'Přelíc', 174, 177, 40.0, 42.4);
INSERT INTO obce VALUES (268, 'CZ0203', 'Řisuty', 146, 146, 38.5, 43.2);
INSERT INTO obce VALUES (269, 'CZ0203', 'Sazená', 149, 161, 37.9, 37.0);
INSERT INTO obce VALUES (270, 'CZ0203', 'Slaný', 7309, 7782, 39.4, 42.8);
INSERT INTO obce VALUES (271, 'CZ0203', 'Slatina', 222, 219, 37.8, 40.4);
INSERT INTO obce VALUES (272, 'CZ0203', 'Smečno', 888, 982, 39.1, 43.6);
INSERT INTO obce VALUES (273, 'CZ0203', 'Stehelčeves', 374, 338, 35.6, 38.5);
INSERT INTO obce VALUES (274, 'CZ0203', 'Stochov', 2868, 2979, 37.8, 40.9);
INSERT INTO obce VALUES (275, 'CZ0203', 'Stradonice', 52, 59, 35.8, 34.9);
INSERT INTO obce VALUES (276, 'CZ0203', 'Studeněves', 204, 236, 38.3, 36.4);
INSERT INTO obce VALUES (277, 'CZ0203', 'Svárov', 231, 239, 34.8, 34.8);
INSERT INTO obce VALUES (278, 'CZ0203', 'Svinařov', 355, 354, 38.7, 42.4);
INSERT INTO obce VALUES (279, 'CZ0203', 'Šlapanice', 94, 114, 39.5, 39.4);
INSERT INTO obce VALUES (280, 'CZ0203', 'Třebichovice', 282, 274, 38.1, 41.3);
INSERT INTO obce VALUES (281, 'CZ0203', 'Třebíz', 93, 94, 38.5, 40.1);
INSERT INTO obce VALUES (282, 'CZ0203', 'Třebusice', 270, 237, 38.0, 42.5);
INSERT INTO obce VALUES (283, 'CZ0203', 'Tuchlovice', 1145, 1161, 39.9, 42.7);
INSERT INTO obce VALUES (284, 'CZ0203', 'Tuřany', 253, 286, 37.6, 40.4);
INSERT INTO obce VALUES (285, 'CZ0203', 'Uhy', 183, 188, 35.0, 39.8);
INSERT INTO obce VALUES (286, 'CZ0203', 'Unhošť', 1851, 1986, 39.2, 42.9);
INSERT INTO obce VALUES (287, 'CZ0203', 'Velká Dobrá', 816, 782, 37.5, 40.0);
INSERT INTO obce VALUES (288, 'CZ0203', 'Velké Přítočno', 478, 452, 38.1, 40.3);
INSERT INTO obce VALUES (289, 'CZ0203', 'Velvary', 1442, 1527, 40.7, 43.1);
INSERT INTO obce VALUES (290, 'CZ0203', 'Vinařice', 944, 945, 39.3, 42.4);
INSERT INTO obce VALUES (291, 'CZ0203', 'Vraný', 359, 392, 37.8, 40.8);
INSERT INTO obce VALUES (292, 'CZ0203', 'Vrbičany', 110, 133, 36.3, 39.5);
INSERT INTO obce VALUES (293, 'CZ0203', 'Zájezd', 59, 52, 36.0, 40.3);
INSERT INTO obce VALUES (294, 'CZ0203', 'Zákolany', 264, 276, 38.2, 42.0);
INSERT INTO obce VALUES (295, 'CZ0203', 'Zichovec', 57, 48, 44.8, 46.5);
INSERT INTO obce VALUES (296, 'CZ0203', 'Zlonice', 1162, 1168, 36.7, 39.6);
INSERT INTO obce VALUES (297, 'CZ0203', 'Zvoleněves', 413, 399, 39.2, 42.3);
INSERT INTO obce VALUES (298, 'CZ0203', 'Želenice', 93, 84, 38.9, 41.3);
INSERT INTO obce VALUES (299, 'CZ0203', 'Žilina', 411, 398, 38.1, 41.5);
INSERT INTO obce VALUES (300, 'CZ0203', 'Žižice', 295, 286, 37.0, 39.0);
INSERT INTO obce VALUES (301, 'CZ0204', 'Barchovice', 103, 104, 41.7, 42.3);
INSERT INTO obce VALUES (302, 'CZ0204', 'Bečváry', 473, 523, 39.2, 45.9);
INSERT INTO obce VALUES (303, 'CZ0204', 'Bělušice', 135, 131, 38.3, 43.7);
INSERT INTO obce VALUES (304, 'CZ0204', 'Břežany I', 171, 144, 36.9, 41.5);
INSERT INTO obce VALUES (305, 'CZ0204', 'Břežany II', 314, 289, 37.4, 37.6);
INSERT INTO obce VALUES (306, 'CZ0204', 'Býchory', 400, 272, 37.8, 40.9);
INSERT INTO obce VALUES (307, 'CZ0204', 'Cerhenice', 798, 816, 38.6, 41.7);
INSERT INTO obce VALUES (308, 'CZ0204', 'Církvice', 88, 69, 41.3, 48.4);
INSERT INTO obce VALUES (309, 'CZ0204', 'Červené Pečky', 862, 883, 40.0, 41.4);
INSERT INTO obce VALUES (310, 'CZ0204', 'Český Brod', 3324, 3518, 39.2, 41.4);
INSERT INTO obce VALUES (311, 'CZ0204', 'Dobřichov', 332, 380, 38.7, 42.7);
INSERT INTO obce VALUES (312, 'CZ0204', 'Dolní Chvatliny', 223, 211, 36.7, 41.8);
INSERT INTO obce VALUES (313, 'CZ0204', 'Dománovice', 57, 62, 43.6, 42.5);
INSERT INTO obce VALUES (314, 'CZ0204', 'Doubravčice', 215, 224, 34.8, 37.0);
INSERT INTO obce VALUES (315, 'CZ0204', 'Drahobudice', 111, 109, 39.9, 45.5);
INSERT INTO obce VALUES (316, 'CZ0204', 'Grunta', 46, 49, 44.0, 43.9);
INSERT INTO obce VALUES (317, 'CZ0204', 'Horní Kruty', 251, 278, 38.6, 40.3);
INSERT INTO obce VALUES (318, 'CZ0204', 'Hradešín', 138, 156, 35.3, 34.4);
INSERT INTO obce VALUES (319, 'CZ0204', 'Choťovice', 100, 99, 40.3, 42.8);
INSERT INTO obce VALUES (320, 'CZ0204', 'Chotutice', 239, 254, 38.8, 42.2);
INSERT INTO obce VALUES (321, 'CZ0204', 'Chrášťany', 322, 332, 36.1, 37.0);
INSERT INTO obce VALUES (322, 'CZ0204', 'Jestřabí Lhota', 210, 208, 36.4, 39.3);
INSERT INTO obce VALUES (323, 'CZ0204', 'Kbel', 98, 96, 41.1, 44.9);
INSERT INTO obce VALUES (324, 'CZ0204', 'Klášterní Skalice', 65, 70, 37.3, 39.4);
INSERT INTO obce VALUES (325, 'CZ0204', 'Klučov', 449, 446, 39.7, 41.8);
INSERT INTO obce VALUES (326, 'CZ0204', 'Kolín', 15157, 15778, 39.4, 43.3);
INSERT INTO obce VALUES (327, 'CZ0204', 'Konárovice', 377, 383, 39.5, 41.9);
INSERT INTO obce VALUES (328, 'CZ0204', 'Kořenice', 299, 312, 40.5, 40.8);
INSERT INTO obce VALUES (329, 'CZ0204', 'Kouřim', 877, 951, 39.7, 42.9);
INSERT INTO obce VALUES (330, 'CZ0204', 'Krakovany', 397, 382, 39.9, 42.1);
INSERT INTO obce VALUES (331, 'CZ0204', 'Krupá', 166, 166, 38.5, 43.2);
INSERT INTO obce VALUES (332, 'CZ0204', 'Krychnov', 45, 57, 48.7, 47.0);
INSERT INTO obce VALUES (333, 'CZ0204', 'Křečhoř', 217, 207, 38.6, 43.7);
INSERT INTO obce VALUES (334, 'CZ0204', 'Kšely', 107, 114, 39.6, 40.3);
INSERT INTO obce VALUES (335, 'CZ0204', 'Libenice', 148, 147, 38.6, 38.1);
INSERT INTO obce VALUES (336, 'CZ0204', 'Libodřice', 146, 139, 41.5, 40.3);
INSERT INTO obce VALUES (337, 'CZ0204', 'Lipec', 98, 101, 43.1, 44.4);
INSERT INTO obce VALUES (338, 'CZ0204', 'Lošany', 155, 178, 39.7, 41.6);
INSERT INTO obce VALUES (339, 'CZ0204', 'Malotice', 134, 140, 39.9, 41.1);
INSERT INTO obce VALUES (340, 'CZ0204', 'Masojedy', 44, 46, 35.4, 39.7);
INSERT INTO obce VALUES (341, 'CZ0204', 'Mrzky', 74, 64, 38.9, 41.2);
INSERT INTO obce VALUES (342, 'CZ0204', 'Nebovidy', 327, 324, 36.6, 39.4);
INSERT INTO obce VALUES (343, 'CZ0204', 'Němčice', 157, 156, 38.9, 42.9);
INSERT INTO obce VALUES (344, 'CZ0204', 'Nová Ves I', 619, 639, 37.3, 39.6);
INSERT INTO obce VALUES (345, 'CZ0204', 'Ohaře', 163, 142, 41.2, 40.4);
INSERT INTO obce VALUES (346, 'CZ0204', 'Ovčáry', 447, 386, 37.8, 39.3);
INSERT INTO obce VALUES (347, 'CZ0204', 'Pašinka', 162, 169, 39.9, 41.1);
INSERT INTO obce VALUES (348, 'CZ0204', 'Pečky', 2244, 2257, 39.7, 43.4);
INSERT INTO obce VALUES (349, 'CZ0204', 'Plaňany', 875, 851, 36.6, 39.8);
INSERT INTO obce VALUES (350, 'CZ0209', 'Oleška', 440, 429, 37.9, 42.9);
INSERT INTO obce VALUES (351, 'CZ0204', 'Pňov-Předhradí', 261, 268, 43.9, 47.4);
INSERT INTO obce VALUES (352, 'CZ0204', 'Polepy', 314, 280, 40.9, 42.1);
INSERT INTO obce VALUES (353, 'CZ0204', 'Polní Chrčice', 76, 79, 41.3, 47.0);
INSERT INTO obce VALUES (354, 'CZ0204', 'Polní Voděrady', 70, 71, 38.7, 41.1);
INSERT INTO obce VALUES (355, 'CZ0204', 'Poříčany', 672, 662, 38.5, 41.6);
INSERT INTO obce VALUES (356, 'CZ0204', 'Přehvozdí', 107, 115, 36.3, 41.6);
INSERT INTO obce VALUES (357, 'CZ0204', 'Přistoupim', 201, 232, 38.9, 41.7);
INSERT INTO obce VALUES (358, 'CZ0204', 'Přišimasy', 337, 337, 35.4, 35.6);
INSERT INTO obce VALUES (359, 'CZ0204', 'Radim', 529, 572, 37.9, 40.3);
INSERT INTO obce VALUES (360, 'CZ0204', 'Radovesnice I', 165, 170, 42.6, 42.2);
INSERT INTO obce VALUES (361, 'CZ0204', 'Radovesnice II', 220, 210, 40.1, 43.0);
INSERT INTO obce VALUES (362, 'CZ0204', 'Ratboř', 259, 251, 41.8, 44.1);
INSERT INTO obce VALUES (363, 'CZ0204', 'Ratenice', 287, 260, 37.2, 39.1);
INSERT INTO obce VALUES (364, 'CZ0204', 'Rostoklaty', 236, 232, 38.1, 42.5);
INSERT INTO obce VALUES (365, 'CZ0204', 'Skvrňov', 78, 83, 46.0, 47.3);
INSERT INTO obce VALUES (366, 'CZ0204', 'Starý Kolín', 803, 776, 39.6, 42.6);
INSERT INTO obce VALUES (367, 'CZ0204', 'Svojšice', 313, 290, 43.2, 46.3);
INSERT INTO obce VALUES (368, 'CZ0204', 'Tatce', 282, 292, 39.9, 43.7);
INSERT INTO obce VALUES (369, 'CZ0204', 'Tismice', 202, 220, 36.2, 38.6);
INSERT INTO obce VALUES (370, 'CZ0204', 'Toušice', 118, 159, 39.7, 39.9);
INSERT INTO obce VALUES (371, 'CZ0204', 'Třebovle', 207, 241, 37.7, 39.9);
INSERT INTO obce VALUES (372, 'CZ0204', 'Tři Dvory', 434, 430, 41.4, 44.3);
INSERT INTO obce VALUES (373, 'CZ0204', 'Tuchoraz', 214, 203, 36.4, 38.5);
INSERT INTO obce VALUES (374, 'CZ0204', 'Tuklaty', 351, 371, 39.9, 40.9);
INSERT INTO obce VALUES (375, 'CZ0204', 'Týnec nad Labem', 1007, 1033, 39.3, 41.6);
INSERT INTO obce VALUES (376, 'CZ0204', 'Uhlířská Lhota', 182, 182, 40.7, 44.9);
INSERT INTO obce VALUES (377, 'CZ0204', 'Veletov', 106, 118, 40.8, 38.8);
INSERT INTO obce VALUES (378, 'CZ0204', 'Velim', 1069, 1061, 38.5, 41.7);
INSERT INTO obce VALUES (379, 'CZ0204', 'Velký Osek', 1067, 1111, 39.8, 43.3);
INSERT INTO obce VALUES (380, 'CZ0204', 'Veltruby', 678, 675, 39.5, 42.2);
INSERT INTO obce VALUES (381, 'CZ0204', 'Vitice', 518, 528, 39.8, 39.3);
INSERT INTO obce VALUES (382, 'CZ0204', 'Volárna', 235, 241, 39.9, 40.2);
INSERT INTO obce VALUES (383, 'CZ0204', 'Vrátkov', 122, 113, 41.6, 42.4);
INSERT INTO obce VALUES (384, 'CZ0204', 'Vrbčany', 172, 178, 38.7, 40.8);
INSERT INTO obce VALUES (385, 'CZ0204', 'Zalešany', 59, 52, 47.9, 51.6);
INSERT INTO obce VALUES (386, 'CZ0204', 'Zásmuky', 930, 904, 39.5, 42.0);
INSERT INTO obce VALUES (387, 'CZ0204', 'Žabonosy', 103, 119, 41.6, 44.9);
INSERT INTO obce VALUES (388, 'CZ0204', 'Ždánice', 166, 169, 40.7, 45.9);
INSERT INTO obce VALUES (389, 'CZ0204', 'Žehuň', 208, 217, 42.1, 43.7);
INSERT INTO obce VALUES (390, 'CZ0204', 'Žiželice', 777, 804, 38.8, 41.4);
INSERT INTO obce VALUES (391, 'CZ0205', 'Adamov', 51, 59, 48.3, 48.1);
INSERT INTO obce VALUES (392, 'CZ0205', 'Bernardov', 84, 91, 41.8, 41.0);
INSERT INTO obce VALUES (393, 'CZ0205', 'Bílé Podolí', 292, 312, 41.4, 42.7);
INSERT INTO obce VALUES (394, 'CZ0205', 'Bludov', 13, 14, 48.7, 46.3);
INSERT INTO obce VALUES (395, 'CZ0205', 'Bohdaneč', 220, 215, 40.8, 42.0);
INSERT INTO obce VALUES (396, 'CZ0205', 'Brambory', 55, 56, 42.2, 43.9);
INSERT INTO obce VALUES (397, 'CZ0205', 'Bratčice', 180, 200, 41.1, 47.1);
INSERT INTO obce VALUES (398, 'CZ0205', 'Církvice', 581, 625, 37.9, 40.9);
INSERT INTO obce VALUES (399, 'CZ0205', 'Čáslav', 4917, 5203, 39.6, 43.1);
INSERT INTO obce VALUES (400, 'CZ0205', 'Čejkovice', 16, 18, 45.1, 53.0);
INSERT INTO obce VALUES (401, 'CZ0205', 'Černíny', 189, 185, 43.7, 48.4);
INSERT INTO obce VALUES (402, 'CZ0205', 'Červené Janovice', 367, 355, 40.3, 41.9);
INSERT INTO obce VALUES (403, 'CZ0205', 'Čestín', 223, 215, 43.0, 47.4);
INSERT INTO obce VALUES (404, 'CZ0205', 'Dobrovítov', 61, 61, 44.3, 46.9);
INSERT INTO obce VALUES (405, 'CZ0205', 'Dolní Pohleď', 52, 43, 46.0, 49.2);
INSERT INTO obce VALUES (406, 'CZ0205', 'Drobovice', 204, 190, 40.1, 43.8);
INSERT INTO obce VALUES (407, 'CZ0205', 'Hlízov', 241, 243, 35.6, 39.7);
INSERT INTO obce VALUES (408, 'CZ0205', 'Horka I', 184, 202, 42.6, 43.3);
INSERT INTO obce VALUES (409, 'CZ0205', 'Horka II', 189, 193, 43.2, 44.5);
INSERT INTO obce VALUES (410, 'CZ0205', 'Horky', 183, 209, 40.5, 43.3);
INSERT INTO obce VALUES (411, 'CZ0205', 'Horušice', 102, 101, 45.9, 48.4);
INSERT INTO obce VALUES (412, 'CZ0205', 'Hostovlice', 133, 115, 39.7, 39.6);
INSERT INTO obce VALUES (413, 'CZ0205', 'Hraběšín', 62, 58, 42.6, 51.7);
INSERT INTO obce VALUES (414, 'CZ0205', 'Chabeřice', 116, 120, 41.8, 44.2);
INSERT INTO obce VALUES (415, 'CZ0205', 'Chlístovice', 369, 348, 40.7, 42.0);
INSERT INTO obce VALUES (416, 'CZ0205', 'Chotusice', 379, 336, 38.6, 43.5);
INSERT INTO obce VALUES (417, 'CZ0205', 'Kácov', 412, 414, 44.1, 44.4);
INSERT INTO obce VALUES (418, 'CZ0205', 'Kluky', 231, 226, 41.5, 47.0);
INSERT INTO obce VALUES (419, 'CZ0205', 'Kobylnice', 91, 105, 36.9, 39.5);
INSERT INTO obce VALUES (420, 'CZ0205', 'Košice', 22, 24, 39.9, 38.8);
INSERT INTO obce VALUES (421, 'CZ0205', 'Krchleby', 184, 219, 43.0, 41.7);
INSERT INTO obce VALUES (422, 'CZ0205', 'Křesetice', 330, 335, 38.0, 39.0);
INSERT INTO obce VALUES (423, 'CZ0205', 'Kutná Hora', 10607, 10818, 39.3, 42.4);
INSERT INTO obce VALUES (424, 'CZ0205', 'Ledečko', 86, 77, 37.9, 40.4);
INSERT INTO obce VALUES (425, 'CZ0205', 'Malešov', 456, 484, 40.3, 40.5);
INSERT INTO obce VALUES (426, 'CZ0205', 'Miskovice', 442, 410, 37.1, 40.7);
INSERT INTO obce VALUES (427, 'CZ0205', 'Močovice', 154, 183, 39.9, 40.3);
INSERT INTO obce VALUES (428, 'CZ0205', 'Nepoměřice', 107, 109, 40.7, 38.4);
INSERT INTO obce VALUES (429, 'CZ0205', 'Nové Dvory', 438, 422, 36.0, 39.7);
INSERT INTO obce VALUES (430, 'CZ0205', 'Okřesaneč', 87, 98, 40.8, 43.5);
INSERT INTO obce VALUES (431, 'CZ0205', 'Onomyšl', 141, 147, 40.3, 42.1);
INSERT INTO obce VALUES (432, 'CZ0205', 'Opatovice I', 61, 64, 37.7, 36.7);
INSERT INTO obce VALUES (433, 'CZ0205', 'Paběnice', 87, 81, 39.6, 45.2);
INSERT INTO obce VALUES (434, 'CZ0205', 'Pertoltice', 83, 67, 45.5, 48.5);
INSERT INTO obce VALUES (435, 'CZ0205', 'Petrovice I', 149, 153, 42.6, 43.1);
INSERT INTO obce VALUES (436, 'CZ0205', 'Petrovice II', 44, 54, 52.8, 55.1);
INSERT INTO obce VALUES (437, 'CZ0205', 'Podveky', 109, 108, 44.4, 44.2);
INSERT INTO obce VALUES (438, 'CZ0205', 'Potěhy', 278, 323, 40.9, 39.0);
INSERT INTO obce VALUES (439, 'CZ0205', 'Rašovice', 180, 193, 40.0, 40.0);
INSERT INTO obce VALUES (440, 'CZ0205', 'Rataje nad Sázavou', 296, 260, 45.3, 46.8);
INSERT INTO obce VALUES (441, 'CZ0205', 'Rohozec', 144, 123, 41.6, 44.8);
INSERT INTO obce VALUES (442, 'CZ0205', 'Řendějov', 121, 124, 38.7, 45.8);
INSERT INTO obce VALUES (443, 'CZ0205', 'Samopše', 61, 73, 48.1, 47.4);
INSERT INTO obce VALUES (444, 'CZ0205', 'Semtěš', 138, 126, 42.6, 45.9);
INSERT INTO obce VALUES (445, 'CZ0205', 'Schořov', 37, 30, 46.1, 46.4);
INSERT INTO obce VALUES (446, 'CZ0205', 'Slavošov', 81, 78, 42.6, 42.4);
INSERT INTO obce VALUES (447, 'CZ0205', 'Soběšín', 75, 72, 45.0, 50.8);
INSERT INTO obce VALUES (448, 'CZ0205', 'Souňov', 54, 67, 40.9, 40.4);
INSERT INTO obce VALUES (449, 'CZ0205', 'Staňkovice', 128, 131, 42.1, 48.6);
INSERT INTO obce VALUES (450, 'CZ0205', 'Starkoč', 49, 60, 40.7, 46.8);
INSERT INTO obce VALUES (451, 'CZ0205', 'Sudějov', 34, 34, 38.4, 47.9);
INSERT INTO obce VALUES (452, 'CZ0205', 'Suchdol', 552, 535, 39.6, 42.7);
INSERT INTO obce VALUES (453, 'CZ0205', 'Svatý Mikuláš', 368, 402, 41.7, 43.5);
INSERT INTO obce VALUES (454, 'CZ0205', 'Šebestěnice', 53, 64, 47.1, 42.6);
INSERT INTO obce VALUES (455, 'CZ0205', 'Štipoklasy', 68, 75, 39.6, 41.0);
INSERT INTO obce VALUES (456, 'CZ0205', 'Třebešice', 141, 114, 36.7, 36.6);
INSERT INTO obce VALUES (457, 'CZ0205', 'Třebětín', 60, 49, 47.2, 52.0);
INSERT INTO obce VALUES (458, 'CZ0205', 'Třebonín', 68, 68, 43.2, 41.4);
INSERT INTO obce VALUES (459, 'CZ0205', 'Tupadly', 304, 304, 38.5, 44.0);
INSERT INTO obce VALUES (460, 'CZ0205', 'Uhlířské Janovice', 1554, 1574, 38.3, 41.0);
INSERT INTO obce VALUES (461, 'CZ0205', 'Úmonín', 221, 242, 40.9, 43.5);
INSERT INTO obce VALUES (462, 'CZ0205', 'Úžice', 323, 303, 40.8, 43.5);
INSERT INTO obce VALUES (463, 'CZ0205', 'Vavřinec', 238, 231, 39.0, 42.0);
INSERT INTO obce VALUES (464, 'CZ0205', 'Vidice', 115, 108, 40.7, 46.7);
INSERT INTO obce VALUES (465, 'CZ0205', 'Vinaře', 127, 138, 40.5, 43.3);
INSERT INTO obce VALUES (466, 'CZ0205', 'Vlačice', 128, 138, 37.7, 39.2);
INSERT INTO obce VALUES (467, 'CZ0205', 'Vlastějovice', 240, 265, 41.7, 42.6);
INSERT INTO obce VALUES (468, 'CZ0205', 'Vlkaneč', 309, 286, 42.3, 43.7);
INSERT INTO obce VALUES (469, 'CZ0205', 'Vodranty', 35, 36, 46.8, 49.0);
INSERT INTO obce VALUES (470, 'CZ0205', 'Vrdy', 1538, 1519, 38.2, 40.9);
INSERT INTO obce VALUES (471, 'CZ0205', 'Záboří nad Labem', 418, 424, 39.3, 42.9);
INSERT INTO obce VALUES (472, 'CZ0205', 'Zbizuby', 217, 221, 40.1, 43.5);
INSERT INTO obce VALUES (473, 'CZ0205', 'Zbraslavice', 713, 695, 39.2, 43.3);
INSERT INTO obce VALUES (474, 'CZ0205', 'Zbýšov', 313, 307, 42.1, 44.3);
INSERT INTO obce VALUES (475, 'CZ0205', 'Zruč nad Sázavou', 2420, 2542, 40.8, 44.1);
INSERT INTO obce VALUES (476, 'CZ0205', 'Žáky', 177, 159, 37.8, 42.0);
INSERT INTO obce VALUES (477, 'CZ0205', 'Žehušice', 310, 307, 36.1, 41.3);
INSERT INTO obce VALUES (478, 'CZ0205', 'Žleby', 649, 655, 41.1, 43.6);
INSERT INTO obce VALUES (479, 'CZ0206', 'Býkev', 209, 195, 35.7, 37.7);
INSERT INTO obce VALUES (480, 'CZ0206', 'Byšice', 621, 662, 36.5, 39.3);
INSERT INTO obce VALUES (481, 'CZ0206', 'Cítov', 613, 586, 35.3, 37.5);
INSERT INTO obce VALUES (482, 'CZ0206', 'Čakovičky', 265, 250, 31.5, 34.5);
INSERT INTO obce VALUES (483, 'CZ0206', 'Čečelice', 304, 316, 39.6, 40.9);
INSERT INTO obce VALUES (484, 'CZ0206', 'Dobřeň', 89, 71, 37.7, 50.5);
INSERT INTO obce VALUES (485, 'CZ0206', 'Dolany', 399, 399, 38.5, 39.5);
INSERT INTO obce VALUES (486, 'CZ0206', 'Dolní Beřkovice', 660, 652, 37.1, 38.9);
INSERT INTO obce VALUES (487, 'CZ0206', 'Dolní Zimoř', 29, 32, 43.9, 47.8);
INSERT INTO obce VALUES (488, 'CZ0206', 'Dřínov', 204, 230, 36.7, 38.7);
INSERT INTO obce VALUES (489, 'CZ0206', 'Horní Počaply', 706, 754, 35.3, 40.8);
INSERT INTO obce VALUES (490, 'CZ0206', 'Hořín', 355, 372, 40.8, 41.9);
INSERT INTO obce VALUES (491, 'CZ0206', 'Hostín', 116, 122, 35.2, 39.6);
INSERT INTO obce VALUES (492, 'CZ0206', 'Hostín u Vojkovic', 160, 157, 42.6, 44.9);
INSERT INTO obce VALUES (493, 'CZ0206', 'Chlumín', 231, 226, 37.9, 39.2);
INSERT INTO obce VALUES (494, 'CZ0206', 'Chorušice', 249, 247, 38.0, 42.7);
INSERT INTO obce VALUES (495, 'CZ0206', 'Chvatěruby', 228, 234, 37.3, 40.1);
INSERT INTO obce VALUES (496, 'CZ0206', 'Jeviněves', 105, 87, 44.9, 48.6);
INSERT INTO obce VALUES (497, 'CZ0206', 'Kadlín', 68, 69, 40.1, 42.7);
INSERT INTO obce VALUES (498, 'CZ0206', 'Kanina', 27, 18, 43.1, 46.3);
INSERT INTO obce VALUES (499, 'CZ0206', 'Kly', 577, 553, 36.4, 38.9);
INSERT INTO obce VALUES (500, 'CZ0206', 'Kojetice', 358, 360, 38.3, 41.9);
INSERT INTO obce VALUES (501, 'CZ0206', 'Kokořín', 182, 195, 37.9, 39.2);
INSERT INTO obce VALUES (502, 'CZ0206', 'Kostelec nad Labem', 1680, 1733, 38.7, 41.8);
INSERT INTO obce VALUES (503, 'CZ0206', 'Kozomín', 158, 184, 38.4, 41.2);
INSERT INTO obce VALUES (504, 'CZ0206', 'Kralupy nad Vltavou', 8704, 8931, 39.6, 42.7);
INSERT INTO obce VALUES (505, 'CZ0206', 'Ledčice', 297, 289, 38.0, 40.2);
INSERT INTO obce VALUES (506, 'CZ0206', 'Lhotka', 121, 141, 43.9, 41.8);
INSERT INTO obce VALUES (507, 'CZ0206', 'Liběchov', 517, 497, 37.4, 42.0);
INSERT INTO obce VALUES (508, 'CZ0206', 'Libiš', 1021, 1000, 39.3, 42.8);
INSERT INTO obce VALUES (509, 'CZ0206', 'Liblice', 250, 228, 38.9, 39.6);
INSERT INTO obce VALUES (510, 'CZ0206', 'Lobeč', 87, 80, 29.8, 32.7);
INSERT INTO obce VALUES (511, 'CZ0206', 'Lužec nad Vltavou', 689, 671, 39.4, 41.2);
INSERT INTO obce VALUES (512, 'CZ0206', 'Malý Újezd', 481, 469, 36.4, 39.3);
INSERT INTO obce VALUES (513, 'CZ0206', 'Medonosy', 67, 62, 40.6, 39.2);
INSERT INTO obce VALUES (514, 'CZ0206', 'Mělnické Vtelno', 450, 462, 38.4, 41.7);
INSERT INTO obce VALUES (515, 'CZ0206', 'Mělník', 9292, 9881, 39.4, 43.1);
INSERT INTO obce VALUES (516, 'CZ0206', 'Mšeno', 682, 834, 39.6, 42.5);
INSERT INTO obce VALUES (517, 'CZ0206', 'Nebužely', 208, 217, 36.6, 37.0);
INSERT INTO obce VALUES (518, 'CZ0206', 'Nedomice', 161, 147, 38.0, 44.7);
INSERT INTO obce VALUES (519, 'CZ0206', 'Nelahozeves', 804, 752, 36.9, 40.9);
INSERT INTO obce VALUES (520, 'CZ0206', 'Neratovice', 8137, 8357, 38.3, 40.9);
INSERT INTO obce VALUES (521, 'CZ0206', 'Nosálov', 80, 84, 44.2, 47.2);
INSERT INTO obce VALUES (522, 'CZ0206', 'Nová Ves', 666, 541, 38.4, 42.2);
INSERT INTO obce VALUES (523, 'CZ0206', 'Obříství', 566, 579, 36.1, 39.6);
INSERT INTO obce VALUES (524, 'CZ0206', 'Olovnice', 248, 256, 37.6, 41.9);
INSERT INTO obce VALUES (525, 'CZ0206', 'Ovčáry', 211, 208, 38.5, 40.4);
INSERT INTO obce VALUES (526, 'CZ0206', 'Postřižín', 292, 308, 35.5, 35.6);
INSERT INTO obce VALUES (527, 'CZ0206', 'Řepín', 319, 314, 40.1, 38.0);
INSERT INTO obce VALUES (528, 'CZ0206', 'Spomyšl', 225, 216, 34.7, 38.4);
INSERT INTO obce VALUES (529, 'CZ0206', 'Stránka', 108, 104, 39.7, 45.7);
INSERT INTO obce VALUES (530, 'CZ0206', 'Střemy', 186, 198, 38.4, 41.4);
INSERT INTO obce VALUES (531, 'CZ0206', 'Tišice', 888, 916, 37.4, 40.7);
INSERT INTO obce VALUES (532, 'CZ0206', 'Tuhaň', 314, 327, 36.3, 37.7);
INSERT INTO obce VALUES (533, 'CZ0206', 'Tupadly', 69, 58, 35.6, 46.8);
INSERT INTO obce VALUES (534, 'CZ0206', 'Újezdec', 48, 59, 44.4, 45.3);
INSERT INTO obce VALUES (535, 'CZ0206', 'Úžice', 475, 410, 36.9, 39.3);
INSERT INTO obce VALUES (536, 'CZ0206', 'Velký Borek', 508, 471, 37.3, 41.9);
INSERT INTO obce VALUES (537, 'CZ0206', 'Veltrusy', 913, 949, 37.3, 40.5);
INSERT INTO obce VALUES (538, 'CZ0206', 'Vidim', 78, 85, 44.8, 50.1);
INSERT INTO obce VALUES (539, 'CZ0206', 'Vojkovice', 413, 398, 37.6, 40.6);
INSERT INTO obce VALUES (540, 'CZ0206', 'Vraňany', 434, 422, 39.2, 40.9);
INSERT INTO obce VALUES (541, 'CZ0206', 'Všestudy', 153, 157, 42.3, 44.9);
INSERT INTO obce VALUES (542, 'CZ0206', 'Všetaty', 1066, 1107, 38.4, 42.2);
INSERT INTO obce VALUES (543, 'CZ0206', 'Vysoká', 425, 409, 37.6, 40.6);
INSERT INTO obce VALUES (544, 'CZ0206', 'Zálezlice', 202, 180, 37.1, 40.7);
INSERT INTO obce VALUES (545, 'CZ0206', 'Zlončice', 219, 238, 31.6, 33.3);
INSERT INTO obce VALUES (546, 'CZ0206', 'Zlosyň', 219, 213, 37.4, 38.9);
INSERT INTO obce VALUES (547, 'CZ0206', 'Želízy', 247, 268, 37.4, 40.3);
INSERT INTO obce VALUES (548, 'CZ0207', 'Bakov nad Jizerou', 2485, 2461, 38.6, 42.0);
INSERT INTO obce VALUES (549, 'CZ0207', 'Bělá pod Bezdězem', 2489, 2517, 38.9, 41.5);
INSERT INTO obce VALUES (550, 'CZ0207', 'Benátky nad Jizerou', 3653, 3709, 37.8, 41.4);
INSERT INTO obce VALUES (551, 'CZ0207', 'Bezno', 430, 431, 36.7, 39.6);
INSERT INTO obce VALUES (552, 'CZ0207', 'Bílá Hlína', 51, 56, 40.7, 39.6);
INSERT INTO obce VALUES (553, 'CZ0207', 'Bítouchov', 177, 146, 39.7, 44.8);
INSERT INTO obce VALUES (554, 'CZ0207', 'Boreč', 143, 159, 34.9, 35.6);
INSERT INTO obce VALUES (555, 'CZ0207', 'Boseň', 226, 208, 35.6, 41.5);
INSERT INTO obce VALUES (556, 'CZ0207', 'Bradlec', 576, 531, 34.2, 33.4);
INSERT INTO obce VALUES (557, 'CZ0207', 'Branžež', 108, 107, 40.3, 44.1);
INSERT INTO obce VALUES (558, 'CZ0207', 'Brodce', 483, 507, 38.2, 41.2);
INSERT INTO obce VALUES (559, 'CZ0207', 'Březina', 195, 189, 38.7, 41.1);
INSERT INTO obce VALUES (560, 'CZ0207', 'Březno', 415, 421, 34.5, 36.5);
INSERT INTO obce VALUES (561, 'CZ0207', 'Březovice', 200, 170, 35.0, 37.8);
INSERT INTO obce VALUES (562, 'CZ0207', 'Bukovno', 349, 337, 37.0, 39.3);
INSERT INTO obce VALUES (563, 'CZ0207', 'Ctiměřice', 56, 63, 37.2, 40.7);
INSERT INTO obce VALUES (564, 'CZ0207', 'Čachovice', 424, 426, 39.1, 40.6);
INSERT INTO obce VALUES (565, 'CZ0207', 'Čistá', 365, 363, 38.4, 39.7);
INSERT INTO obce VALUES (566, 'CZ0207', 'Dalovice', 100, 98, 39.8, 41.2);
INSERT INTO obce VALUES (567, 'CZ0207', 'Dlouhá Lhota', 191, 197, 37.5, 38.5);
INSERT INTO obce VALUES (568, 'CZ0207', 'Dobrovice', 1588, 1607, 38.9, 42.0);
INSERT INTO obce VALUES (569, 'CZ0207', 'Dobšín', 114, 96, 41.0, 47.2);
INSERT INTO obce VALUES (570, 'CZ0207', 'Dolní Bousov', 1281, 1285, 38.3, 41.4);
INSERT INTO obce VALUES (571, 'CZ0207', 'Dolní Krupá', 110, 110, 38.1, 38.5);
INSERT INTO obce VALUES (572, 'CZ0207', 'Dolní Slivno', 155, 147, 38.7, 43.0);
INSERT INTO obce VALUES (573, 'CZ0207', 'Dolní Stakory', 127, 125, 37.0, 39.5);
INSERT INTO obce VALUES (574, 'CZ0207', 'Domousnice', 147, 129, 40.8, 44.1);
INSERT INTO obce VALUES (575, 'CZ0207', 'Doubravička', 66, 59, 40.3, 41.8);
INSERT INTO obce VALUES (576, 'CZ0207', 'Horky nad Jizerou', 255, 266, 38.7, 40.1);
INSERT INTO obce VALUES (577, 'CZ0207', 'Horní Bukovina', 124, 109, 37.0, 42.2);
INSERT INTO obce VALUES (578, 'CZ0207', 'Horní Slivno', 102, 107, 37.6, 38.5);
INSERT INTO obce VALUES (579, 'CZ0207', 'Hrdlořezy', 398, 351, 38.7, 38.5);
INSERT INTO obce VALUES (580, 'CZ0207', 'Hrušov', 103, 125, 38.5, 38.1);
INSERT INTO obce VALUES (581, 'CZ0207', 'Husí Lhota', 75, 79, 40.1, 39.0);
INSERT INTO obce VALUES (582, 'CZ0207', 'Charvatce', 106, 118, 41.5, 43.0);
INSERT INTO obce VALUES (583, 'CZ0207', 'Chocnějovice', 216, 192, 36.5, 43.2);
INSERT INTO obce VALUES (584, 'CZ0207', 'Chotětov', 420, 441, 37.0, 39.7);
INSERT INTO obce VALUES (585, 'CZ0207', 'Chudíř', 78, 91, 40.5, 42.5);
INSERT INTO obce VALUES (586, 'CZ0207', 'Jabkenice', 179, 172, 45.2, 47.4);
INSERT INTO obce VALUES (587, 'CZ0207', 'Jivina', 223, 212, 36.9, 39.3);
INSERT INTO obce VALUES (588, 'CZ0207', 'Jizerní Vtelno', 173, 182, 38.7, 43.1);
INSERT INTO obce VALUES (589, 'CZ0207', 'Josefův Důl', 243, 252, 34.8, 36.9);
INSERT INTO obce VALUES (590, 'CZ0207', 'Katusice', 470, 419, 39.3, 40.3);
INSERT INTO obce VALUES (591, 'CZ0207', 'Klášter Hradiště nad Jizerou', 457, 406, 35.9, 39.1);
INSERT INTO obce VALUES (592, 'CZ0207', 'Kluky', 29, 44, 38.7, 43.6);
INSERT INTO obce VALUES (593, 'CZ0207', 'Kněžmost', 872, 902, 38.0, 41.0);
INSERT INTO obce VALUES (594, 'CZ0207', 'Kobylnice', 63, 57, 33.3, 32.1);
INSERT INTO obce VALUES (595, 'CZ0207', 'Kochánky', 223, 186, 38.6, 43.4);
INSERT INTO obce VALUES (596, 'CZ0207', 'Kolomuty', 126, 132, 35.8, 37.0);
INSERT INTO obce VALUES (597, 'CZ0207', 'Koryta', 49, 44, 38.9, 39.0);
INSERT INTO obce VALUES (598, 'CZ0207', 'Kosmonosy', 2291, 2233, 38.3, 40.3);
INSERT INTO obce VALUES (599, 'CZ0207', 'Kosořice', 196, 209, 39.8, 40.3);
INSERT INTO obce VALUES (600, 'CZ0207', 'Košátky', 94, 76, 38.9, 41.6);
INSERT INTO obce VALUES (601, 'CZ0207', 'Kováň', 78, 79, 42.5, 39.2);
INSERT INTO obce VALUES (602, 'CZ0207', 'Kovanec', 69, 52, 38.3, 48.4);
INSERT INTO obce VALUES (603, 'CZ0207', 'Krásná Ves', 91, 110, 40.4, 37.7);
INSERT INTO obce VALUES (604, 'CZ0207', 'Krnsko', 289, 255, 36.5, 38.5);
INSERT INTO obce VALUES (605, 'CZ0207', 'Kropáčova Vrutice', 429, 441, 37.1, 40.3);
INSERT INTO obce VALUES (606, 'CZ0207', 'Ledce', 155, 156, 41.4, 42.9);
INSERT INTO obce VALUES (607, 'CZ0207', 'Lhotky', 74, 70, 34.8, 38.9);
INSERT INTO obce VALUES (608, 'CZ0207', 'Lipník', 148, 139, 39.1, 41.7);
INSERT INTO obce VALUES (609, 'CZ0207', 'Loukov', 88, 69, 39.6, 50.4);
INSERT INTO obce VALUES (610, 'CZ0207', 'Loukovec', 138, 139, 39.2, 39.9);
INSERT INTO obce VALUES (611, 'CZ0207', 'Luštěnice', 1020, 1059, 32.9, 36.2);
INSERT INTO obce VALUES (612, 'CZ0207', 'Mečeříž', 221, 211, 39.0, 41.5);
INSERT INTO obce VALUES (613, 'CZ0207', 'Mladá Boleslav', 22462, 22288, 38.9, 42.1);
INSERT INTO obce VALUES (614, 'CZ0207', 'Mnichovo Hradiště', 4248, 4259, 40.1, 44.2);
INSERT INTO obce VALUES (615, 'CZ0207', 'Mohelnice nad Jizerou', 34, 40, 40.1, 44.4);
INSERT INTO obce VALUES (616, 'CZ0207', 'Mukařov', 76, 102, 41.5, 44.0);
INSERT INTO obce VALUES (617, 'CZ0207', 'Němčice', 88, 96, 39.5, 38.2);
INSERT INTO obce VALUES (618, 'CZ0207', 'Nemyslovice', 70, 59, 37.5, 41.3);
INSERT INTO obce VALUES (619, 'CZ0207', 'Nepřevázka', 201, 211, 38.5, 38.8);
INSERT INTO obce VALUES (620, 'CZ0207', 'Neveklovice', 19, 27, 30.4, 41.2);
INSERT INTO obce VALUES (621, 'CZ0207', 'Niměřice', 169, 154, 39.6, 49.4);
INSERT INTO obce VALUES (622, 'CZ0207', 'Nová Telib', 110, 111, 35.9, 38.4);
INSERT INTO obce VALUES (623, 'CZ0207', 'Nová Ves u Bakova', 127, 122, 39.0, 42.1);
INSERT INTO obce VALUES (624, 'CZ0207', 'Obrubce', 97, 79, 41.6, 45.5);
INSERT INTO obce VALUES (625, 'CZ0207', 'Obruby', 107, 95, 40.2, 43.8);
INSERT INTO obce VALUES (626, 'CZ0207', 'Pěčice', 75, 78, 42.0, 40.8);
INSERT INTO obce VALUES (627, 'CZ0207', 'Pětikozly', 32, 37, 41.7, 46.4);
INSERT INTO obce VALUES (628, 'CZ0207', 'Petkovy', 126, 127, 38.5, 41.2);
INSERT INTO obce VALUES (629, 'CZ0207', 'Písková Lhota', 387, 376, 36.6, 40.1);
INSERT INTO obce VALUES (630, 'CZ0207', 'Plazy', 246, 225, 35.8, 38.1);
INSERT INTO obce VALUES (631, 'CZ0207', 'Plužná', 129, 108, 34.6, 37.8);
INSERT INTO obce VALUES (632, 'CZ0207', 'Prodašice', 46, 42, 38.0, 43.6);
INSERT INTO obce VALUES (633, 'CZ0207', 'Předměřice nad Jizerou', 343, 369, 39.8, 40.9);
INSERT INTO obce VALUES (634, 'CZ0207', 'Přepeře', 68, 65, 43.2, 41.5);
INSERT INTO obce VALUES (635, 'CZ0207', 'Ptýrov', 96, 103, 40.6, 37.6);
INSERT INTO obce VALUES (636, 'CZ0207', 'Rabakov', 28, 27, 43.9, 45.9);
INSERT INTO obce VALUES (637, 'CZ0207', 'Rohatsko', 107, 107, 38.1, 36.9);
INSERT INTO obce VALUES (638, 'CZ0207', 'Rokytá', 113, 114, 40.1, 38.2);
INSERT INTO obce VALUES (639, 'CZ0207', 'Rokytovec', 72, 62, 38.6, 41.6);
INSERT INTO obce VALUES (640, 'CZ0207', 'Řepov', 330, 369, 38.6, 38.0);
INSERT INTO obce VALUES (641, 'CZ0207', 'Řitonice', 44, 46, 38.0, 37.7);
INSERT INTO obce VALUES (642, 'CZ0207', 'Sedlec', 101, 111, 35.8, 37.9);
INSERT INTO obce VALUES (643, 'CZ0207', 'Semčice', 341, 329, 35.3, 37.6);
INSERT INTO obce VALUES (644, 'CZ0207', 'Sezemice', 51, 62, 43.2, 40.0);
INSERT INTO obce VALUES (645, 'CZ0207', 'Skalsko', 165, 208, 38.6, 37.6);
INSERT INTO obce VALUES (646, 'CZ0207', 'Skorkov', 239, 252, 40.2, 40.9);
INSERT INTO obce VALUES (647, 'CZ0207', 'Smilovice', 303, 324, 42.1, 44.5);
INSERT INTO obce VALUES (648, 'CZ0207', 'Sojovice', 246, 249, 39.1, 39.5);
INSERT INTO obce VALUES (649, 'CZ0207', 'Sovínky', 179, 159, 37.0, 39.5);
INSERT INTO obce VALUES (650, 'CZ0207', 'Strašnov', 125, 119, 41.1, 40.6);
INSERT INTO obce VALUES (651, 'CZ0207', 'Strážiště', 47, 53, 45.7, 43.0);
INSERT INTO obce VALUES (652, 'CZ0207', 'Strenice', 89, 90, 39.4, 38.6);
INSERT INTO obce VALUES (653, 'CZ0207', 'Sudoměř', 48, 37, 42.2, 41.9);
INSERT INTO obce VALUES (654, 'CZ0207', 'Sukorady', 183, 185, 39.1, 41.6);
INSERT INTO obce VALUES (655, 'CZ0207', 'Tuřice', 132, 139, 40.4, 40.2);
INSERT INTO obce VALUES (656, 'CZ0207', 'Ujkovice', 50, 50, 40.7, 47.5);
INSERT INTO obce VALUES (657, 'CZ0207', 'Velké Všelisy', 188, 194, 37.6, 41.6);
INSERT INTO obce VALUES (658, 'CZ0207', 'Veselice', 59, 58, 36.8, 39.7);
INSERT INTO obce VALUES (659, 'CZ0207', 'Vinařice', 130, 152, 39.5, 40.8);
INSERT INTO obce VALUES (660, 'CZ0207', 'Vinec', 119, 144, 38.8, 41.9);
INSERT INTO obce VALUES (661, 'CZ0207', 'Vlkava', 199, 225, 41.6, 40.5);
INSERT INTO obce VALUES (662, 'CZ0207', 'Vrátno', 63, 48, 40.8, 39.5);
INSERT INTO obce VALUES (663, 'CZ0207', 'Všejany', 306, 304, 40.9, 43.6);
INSERT INTO obce VALUES (664, 'CZ0207', 'Zdětín', 252, 254, 33.6, 38.8);
INSERT INTO obce VALUES (665, 'CZ0207', 'Žďár', 610, 639, 41.2, 42.2);
INSERT INTO obce VALUES (666, 'CZ0207', 'Žerčice', 195, 170, 37.1, 42.0);
INSERT INTO obce VALUES (667, 'CZ0207', 'Židněves', 145, 165, 34.5, 38.0);
INSERT INTO obce VALUES (668, 'CZ0208', 'Běrunice', 425, 455, 41.9, 43.8);
INSERT INTO obce VALUES (669, 'CZ0208', 'Bobnice', 413, 426, 37.9, 40.2);
INSERT INTO obce VALUES (670, 'CZ0208', 'Bříství', 181, 178, 39.4, 40.8);
INSERT INTO obce VALUES (671, 'CZ0208', 'Budiměřice', 310, 301, 40.3, 42.4);
INSERT INTO obce VALUES (672, 'CZ0208', 'Černíky', 41, 58, 42.6, 45.4);
INSERT INTO obce VALUES (673, 'CZ0208', 'Čilec', 106, 111, 42.5, 48.3);
INSERT INTO obce VALUES (674, 'CZ0208', 'Činěves', 252, 237, 39.8, 44.7);
INSERT INTO obce VALUES (675, 'CZ0208', 'Dlouhopolsko', 112, 102, 43.5, 52.9);
INSERT INTO obce VALUES (676, 'CZ0208', 'Dobšice', 106, 101, 40.1, 42.2);
INSERT INTO obce VALUES (677, 'CZ0208', 'Dvory', 257, 248, 38.2, 42.4);
INSERT INTO obce VALUES (678, 'CZ0208', 'Dymokury', 399, 442, 38.6, 40.6);
INSERT INTO obce VALUES (679, 'CZ0208', 'Hořany', 43, 61, 36.5, 40.5);
INSERT INTO obce VALUES (680, 'CZ0208', 'Hořátev', 350, 367, 40.7, 41.1);
INSERT INTO obce VALUES (681, 'CZ0208', 'Hradčany', 117, 122, 44.9, 45.1);
INSERT INTO obce VALUES (682, 'CZ0208', 'Hradištko', 260, 256, 39.8, 44.0);
INSERT INTO obce VALUES (683, 'CZ0208', 'Hrubý Jeseník', 266, 247, 38.8, 40.3);
INSERT INTO obce VALUES (684, 'CZ0208', 'Chleby', 204, 195, 38.6, 39.5);
INSERT INTO obce VALUES (685, 'CZ0208', 'Choťánky', 203, 209, 42.5, 43.2);
INSERT INTO obce VALUES (686, 'CZ0208', 'Chotěšice', 154, 173, 46.0, 47.2);
INSERT INTO obce VALUES (687, 'CZ0208', 'Chrást', 252, 269, 39.7, 41.3);
INSERT INTO obce VALUES (688, 'CZ0208', 'Chroustov', 89, 109, 41.7, 43.6);
INSERT INTO obce VALUES (689, 'CZ0208', 'Jíkev', 154, 156, 41.8, 44.9);
INSERT INTO obce VALUES (690, 'CZ0208', 'Jiřice', 86, 74, 39.5, 46.3);
INSERT INTO obce VALUES (691, 'CZ0208', 'Jizbice', 146, 153, 41.4, 44.7);
INSERT INTO obce VALUES (692, 'CZ0208', 'Kamenné Zboží', 284, 278, 36.8, 41.2);
INSERT INTO obce VALUES (693, 'CZ0208', 'Kněžice', 237, 263, 40.8, 44.6);
INSERT INTO obce VALUES (694, 'CZ0208', 'Kněžičky', 96, 88, 39.1, 44.6);
INSERT INTO obce VALUES (695, 'CZ0208', 'Kolaje', 40, 49, 50.9, 52.7);
INSERT INTO obce VALUES (696, 'CZ0208', 'Kostelní Lhota', 415, 385, 39.1, 44.3);
INSERT INTO obce VALUES (697, 'CZ0208', 'Kostomlátky', 145, 138, 41.0, 46.3);
INSERT INTO obce VALUES (698, 'CZ0209', 'Ondřejov', 635, 623, 40.2, 42.0);
INSERT INTO obce VALUES (699, 'CZ0208', 'Kostomlaty nad Labem', 847, 895, 38.5, 41.1);
INSERT INTO obce VALUES (700, 'CZ0208', 'Košík', 174, 183, 40.2, 42.3);
INSERT INTO obce VALUES (701, 'CZ0208', 'Kounice', 546, 593, 38.5, 41.1);
INSERT INTO obce VALUES (702, 'CZ0208', 'Kouty', 140, 139, 39.4, 40.6);
INSERT INTO obce VALUES (703, 'CZ0208', 'Kovanice', 388, 387, 38.3, 41.0);
INSERT INTO obce VALUES (704, 'CZ0208', 'Krchleby', 365, 394, 40.5, 41.3);
INSERT INTO obce VALUES (705, 'CZ0208', 'Křečkov', 157, 167, 39.9, 43.8);
INSERT INTO obce VALUES (706, 'CZ0208', 'Křinec', 640, 674, 40.3, 43.7);
INSERT INTO obce VALUES (707, 'CZ0208', 'Libice nad Cidlinou', 621, 672, 41.5, 45.0);
INSERT INTO obce VALUES (708, 'CZ0208', 'Loučeň', 627, 609, 40.6, 45.0);
INSERT INTO obce VALUES (709, 'CZ0208', 'Lysá nad Labem', 4117, 4415, 39.6, 42.5);
INSERT INTO obce VALUES (710, 'CZ0208', 'Mcely', 179, 203, 43.9, 43.0);
INSERT INTO obce VALUES (711, 'CZ0208', 'Městec Králové', 1437, 1501, 40.4, 42.7);
INSERT INTO obce VALUES (712, 'CZ0208', 'Milčice', 132, 150, 38.4, 39.8);
INSERT INTO obce VALUES (713, 'CZ0208', 'Milovice', 4493, 4652, 29.6, 30.5);
INSERT INTO obce VALUES (714, 'CZ0208', 'Netřebice', 100, 97, 40.8, 42.7);
INSERT INTO obce VALUES (715, 'CZ0208', 'Nový Dvůr', 37, 35, 37.0, 44.6);
INSERT INTO obce VALUES (716, 'CZ0208', 'Nymburk', 7006, 7562, 39.2, 42.3);
INSERT INTO obce VALUES (717, 'CZ0208', 'Odřepsy', 153, 148, 41.1, 43.8);
INSERT INTO obce VALUES (718, 'CZ0208', 'Okřínek', 74, 72, 43.5, 47.7);
INSERT INTO obce VALUES (719, 'CZ0208', 'Opočnice', 222, 212, 41.1, 45.3);
INSERT INTO obce VALUES (720, 'CZ0208', 'Opolany', 407, 456, 41.5, 42.2);
INSERT INTO obce VALUES (721, 'CZ0208', 'Oseček', 72, 70, 45.0, 45.8);
INSERT INTO obce VALUES (722, 'CZ0208', 'Oskořínek', 262, 280, 38.7, 40.2);
INSERT INTO obce VALUES (723, 'CZ0208', 'Ostrá', 243, 242, 40.3, 39.8);
INSERT INTO obce VALUES (724, 'CZ0208', 'Pátek', 292, 272, 39.1, 44.0);
INSERT INTO obce VALUES (725, 'CZ0208', 'Písková Lhota', 217, 220, 40.5, 42.3);
INSERT INTO obce VALUES (726, 'CZ0208', 'Písty', 184, 193, 43.1, 42.2);
INSERT INTO obce VALUES (727, 'CZ0208', 'Poděbrady', 6650, 7188, 40.1, 43.9);
INSERT INTO obce VALUES (728, 'CZ0208', 'Podmoky', 70, 80, 37.8, 44.9);
INSERT INTO obce VALUES (729, 'CZ0208', 'Přerov nad Labem', 562, 535, 37.5, 40.3);
INSERT INTO obce VALUES (730, 'CZ0208', 'Rožďalovice', 795, 831, 38.8, 44.5);
INSERT INTO obce VALUES (731, 'CZ0208', 'Sadská', 1557, 1643, 38.7, 41.3);
INSERT INTO obce VALUES (732, 'CZ0208', 'Sány', 236, 248, 41.2, 41.5);
INSERT INTO obce VALUES (733, 'CZ0208', 'Seletice', 96, 89, 44.0, 44.2);
INSERT INTO obce VALUES (734, 'CZ0208', 'Semice', 451, 411, 37.8, 41.6);
INSERT INTO obce VALUES (735, 'CZ0208', 'Senice', 87, 100, 41.2, 43.4);
INSERT INTO obce VALUES (736, 'CZ0208', 'Sloveč', 276, 267, 42.3, 43.1);
INSERT INTO obce VALUES (737, 'CZ0208', 'Sokoleč', 432, 406, 39.4, 44.0);
INSERT INTO obce VALUES (738, 'CZ0208', 'Stará Lysá', 276, 306, 40.2, 40.5);
INSERT INTO obce VALUES (739, 'CZ0208', 'Starý Vestec', 84, 83, 44.0, 35.9);
INSERT INTO obce VALUES (740, 'CZ0208', 'Straky', 282, 260, 38.9, 42.0);
INSERT INTO obce VALUES (741, 'CZ0208', 'Stratov', 246, 206, 37.4, 40.8);
INSERT INTO obce VALUES (742, 'CZ0208', 'Třebestovice', 340, 436, 39.1, 40.4);
INSERT INTO obce VALUES (743, 'CZ0208', 'Úmyslovice', 158, 156, 36.8, 39.6);
INSERT INTO obce VALUES (744, 'CZ0208', 'Velenice', 111, 105, 39.0, 44.7);
INSERT INTO obce VALUES (745, 'CZ0208', 'Velenka', 126, 148, 41.0, 41.2);
INSERT INTO obce VALUES (746, 'CZ0208', 'Vestec', 160, 160, 39.6, 41.5);
INSERT INTO obce VALUES (747, 'CZ0208', 'Vlkov pod Oškobrhem', 64, 52, 37.5, 49.2);
INSERT INTO obce VALUES (748, 'CZ0208', 'Vrbice', 82, 88, 45.8, 47.0);
INSERT INTO obce VALUES (749, 'CZ0208', 'Vrbová Lhota', 222, 199, 37.0, 39.1);
INSERT INTO obce VALUES (750, 'CZ0208', 'Všechlapy', 312, 348, 40.5, 39.4);
INSERT INTO obce VALUES (751, 'CZ0208', 'Vykáň', 175, 169, 36.9, 38.5);
INSERT INTO obce VALUES (752, 'CZ0208', 'Záhornice', 180, 163, 38.1, 43.0);
INSERT INTO obce VALUES (753, 'CZ0208', 'Zbožíčko', 104, 102, 40.8, 40.6);
INSERT INTO obce VALUES (754, 'CZ0208', 'Zvěřínek', 98, 130, 40.4, 38.2);
INSERT INTO obce VALUES (755, 'CZ0208', 'Žitovlice', 71, 76, 45.6, 52.0);
INSERT INTO obce VALUES (756, 'CZ0209', 'Babice', 323, 283, 34.3, 34.5);
INSERT INTO obce VALUES (757, 'CZ0209', 'Bašť', 643, 646, 33.1, 35.6);
INSERT INTO obce VALUES (758, 'CZ0209', 'Borek', 135, 114, 39.6, 42.0);
INSERT INTO obce VALUES (759, 'CZ0209', 'Bořanovice', 327, 339, 37.8, 43.9);
INSERT INTO obce VALUES (760, 'CZ0209', 'Brandýs nad Labem-Stará Boleslav', 8496, 8702, 38.8, 41.4);
INSERT INTO obce VALUES (761, 'CZ0209', 'Brázdim', 298, 327, 39.4, 40.0);
INSERT INTO obce VALUES (762, 'CZ0209', 'Březí', 189, 211, 40.1, 37.8);
INSERT INTO obce VALUES (763, 'CZ0209', 'Čelákovice', 5692, 5788, 38.3, 40.9);
INSERT INTO obce VALUES (764, 'CZ0209', 'Černé Voděrady', 140, 141, 39.9, 42.2);
INSERT INTO obce VALUES (765, 'CZ0209', 'Čestlice', 303, 287, 38.5, 40.5);
INSERT INTO obce VALUES (766, 'CZ0209', 'Dobročovice', 113, 101, 32.3, 36.1);
INSERT INTO obce VALUES (767, 'CZ0209', 'Dobřejovice', 453, 427, 36.7, 37.2);
INSERT INTO obce VALUES (768, 'CZ0209', 'Doubek', 112, 112, 37.4, 37.7);
INSERT INTO obce VALUES (769, 'CZ0209', 'Dřevčice', 338, 335, 35.8, 38.7);
INSERT INTO obce VALUES (770, 'CZ0209', 'Dřísy', 401, 395, 39.2, 41.4);
INSERT INTO obce VALUES (771, 'CZ0209', 'Herink', 89, 88, 28.9, 37.0);
INSERT INTO obce VALUES (772, 'CZ0209', 'Hlavenec', 166, 203, 35.3, 38.9);
INSERT INTO obce VALUES (773, 'CZ0209', 'Horoušany', 394, 402, 36.2, 37.1);
INSERT INTO obce VALUES (774, 'CZ0209', 'Hovorčovice', 965, 936, 37.1, 38.4);
INSERT INTO obce VALUES (775, 'CZ0209', 'Hrusice', 297, 301, 36.1, 37.8);
INSERT INTO obce VALUES (776, 'CZ0209', 'Husinec', 566, 619, 38.7, 39.3);
INSERT INTO obce VALUES (777, 'CZ0209', 'Jenštejn', 405, 411, 35.8, 38.0);
INSERT INTO obce VALUES (778, 'CZ0209', 'Jevany', 303, 284, 39.5, 44.6);
INSERT INTO obce VALUES (779, 'CZ0209', 'Jirny', 981, 1081, 36.4, 37.9);
INSERT INTO obce VALUES (780, 'CZ0209', 'Kaliště', 100, 92, 43.0, 40.4);
INSERT INTO obce VALUES (781, 'CZ0209', 'Kamenice', 1858, 1983, 36.4, 38.8);
INSERT INTO obce VALUES (782, 'CZ0209', 'Káraný', 302, 317, 40.0, 43.7);
INSERT INTO obce VALUES (783, 'CZ0209', 'Klecany', 1245, 1244, 36.9, 39.4);
INSERT INTO obce VALUES (784, 'CZ0209', 'Klíčany', 192, 178, 35.5, 38.5);
INSERT INTO obce VALUES (785, 'CZ0209', 'Klokočná', 92, 101, 38.2, 38.6);
INSERT INTO obce VALUES (786, 'CZ0209', 'Konětopy', 159, 134, 38.1, 43.2);
INSERT INTO obce VALUES (787, 'CZ0209', 'Konojedy', 123, 127, 33.5, 33.2);
INSERT INTO obce VALUES (788, 'CZ0209', 'Kostelec nad Černými Lesy', 1647, 1835, 38.7, 40.6);
INSERT INTO obce VALUES (789, 'CZ0209', 'Kostelec u Křížků', 267, 293, 38.7, 40.8);
INSERT INTO obce VALUES (790, 'CZ0209', 'Kostelní Hlavno', 241, 255, 37.2, 39.0);
INSERT INTO obce VALUES (791, 'CZ0209', 'Kozojedy', 308, 321, 38.2, 43.0);
INSERT INTO obce VALUES (792, 'CZ0209', 'Křenek', 107, 116, 43.7, 43.9);
INSERT INTO obce VALUES (793, 'CZ0209', 'Křenice', 223, 238, 36.8, 36.0);
INSERT INTO obce VALUES (794, 'CZ0209', 'Křížkový Újezdec', 92, 99, 39.5, 38.0);
INSERT INTO obce VALUES (795, 'CZ0209', 'Kunice', 522, 505, 36.0, 38.6);
INSERT INTO obce VALUES (796, 'CZ0209', 'Květnice', 487, 539, 30.6, 31.4);
INSERT INTO obce VALUES (797, 'CZ0209', 'Lázně Toušeň', 614, 577, 38.0, 42.4);
INSERT INTO obce VALUES (798, 'CZ0209', 'Lhota', 205, 204, 38.5, 42.1);
INSERT INTO obce VALUES (799, 'CZ0209', 'Líbeznice', 926, 970, 36.3, 38.9);
INSERT INTO obce VALUES (800, 'CZ0209', 'Louňovice', 393, 409, 37.8, 38.1);
INSERT INTO obce VALUES (801, 'CZ0209', 'Máslovice', 142, 136, 41.9, 41.9);
INSERT INTO obce VALUES (802, 'CZ0209', 'Měšice', 738, 757, 34.4, 39.0);
INSERT INTO obce VALUES (803, 'CZ0209', 'Mirošovice', 544, 516, 37.5, 40.1);
INSERT INTO obce VALUES (804, 'CZ0209', 'Mnichovice', 1530, 1535, 37.4, 39.4);
INSERT INTO obce VALUES (805, 'CZ0209', 'Modletice', 312, 270, 34.7, 33.6);
INSERT INTO obce VALUES (806, 'CZ0209', 'Mochov', 622, 639, 37.6, 38.5);
INSERT INTO obce VALUES (807, 'CZ0209', 'Mratín', 537, 561, 33.8, 35.2);
INSERT INTO obce VALUES (808, 'CZ0209', 'Mukařov', 943, 979, 35.6, 39.3);
INSERT INTO obce VALUES (809, 'CZ0209', 'Nehvizdy', 922, 919, 33.7, 33.8);
INSERT INTO obce VALUES (810, 'CZ0209', 'Nová Ves', 212, 211, 33.5, 33.3);
INSERT INTO obce VALUES (811, 'CZ0209', 'Nový Vestec', 191, 182, 40.7, 44.3);
INSERT INTO obce VALUES (812, 'CZ0209', 'Nučice', 187, 165, 39.2, 42.7);
INSERT INTO obce VALUES (813, 'CZ0209', 'Nupaky', 354, 348, 31.9, 33.3);
INSERT INTO obce VALUES (814, 'CZ0209', 'Odolena Voda', 2708, 2787, 37.5, 39.0);
INSERT INTO obce VALUES (815, 'CZ0209', 'Oplany', 39, 42, 42.9, 47.6);
INSERT INTO obce VALUES (816, 'CZ0209', 'Panenské Břežany', 283, 288, 39.1, 44.8);
INSERT INTO obce VALUES (817, 'CZ0209', 'Pětihosty', 95, 87, 30.6, 36.6);
INSERT INTO obce VALUES (818, 'CZ0209', 'Petříkov', 235, 217, 39.0, 39.9);
INSERT INTO obce VALUES (819, 'CZ0209', 'Podolanka', 251, 263, 40.9, 43.0);
INSERT INTO obce VALUES (820, 'CZ0209', 'Polerady', 108, 122, 36.4, 35.8);
INSERT INTO obce VALUES (821, 'CZ0209', 'Popovičky', 146, 150, 31.9, 37.2);
INSERT INTO obce VALUES (822, 'CZ0209', 'Prusice', 36, 34, 42.2, 49.9);
INSERT INTO obce VALUES (823, 'CZ0209', 'Předboj', 265, 292, 35.9, 37.0);
INSERT INTO obce VALUES (824, 'CZ0209', 'Přezletice', 465, 439, 40.1, 43.2);
INSERT INTO obce VALUES (825, 'CZ0209', 'Radějovice', 138, 153, 37.2, 36.0);
INSERT INTO obce VALUES (826, 'CZ0209', 'Radonice', 331, 340, 38.8, 40.1);
INSERT INTO obce VALUES (827, 'CZ0209', 'Říčany', 6603, 6847, 37.6, 40.6);
INSERT INTO obce VALUES (828, 'CZ0209', 'Sedlec', 114, 108, 35.3, 37.5);
INSERT INTO obce VALUES (829, 'CZ0209', 'Senohraby', 536, 512, 40.0, 43.8);
INSERT INTO obce VALUES (830, 'CZ0209', 'Sibřina', 309, 333, 38.3, 37.1);
INSERT INTO obce VALUES (831, 'CZ0209', 'Sluhy', 337, 337, 39.5, 42.5);
INSERT INTO obce VALUES (832, 'CZ0209', 'Sluštice', 161, 169, 39.7, 39.8);
INSERT INTO obce VALUES (833, 'CZ0209', 'Strančice', 932, 980, 37.4, 39.4);
INSERT INTO obce VALUES (834, 'CZ0209', 'Struhařov', 326, 341, 36.9, 40.0);
INSERT INTO obce VALUES (835, 'CZ0209', 'Stříbrná Skalice', 567, 556, 38.3, 40.9);
INSERT INTO obce VALUES (836, 'CZ0209', 'Sudovo Hlavno', 226, 230, 38.6, 41.0);
INSERT INTO obce VALUES (837, 'CZ0209', 'Sulice', 644, 701, 36.5, 36.8);
INSERT INTO obce VALUES (838, 'CZ0209', 'Svémyslice', 116, 93, 33.7, 37.0);
INSERT INTO obce VALUES (839, 'CZ0209', 'Světice', 492, 508, 36.5, 38.9);
INSERT INTO obce VALUES (840, 'CZ0209', 'Svojetice', 314, 340, 37.7, 39.7);
INSERT INTO obce VALUES (841, 'CZ0209', 'Šestajovice', 1319, 1389, 34.8, 35.5);
INSERT INTO obce VALUES (842, 'CZ0209', 'Škvorec', 607, 614, 37.7, 40.1);
INSERT INTO obce VALUES (843, 'CZ0209', 'Štíhlice', 71, 65, 39.8, 38.8);
INSERT INTO obce VALUES (844, 'CZ0209', 'Tehov', 323, 311, 35.4, 36.6);
INSERT INTO obce VALUES (845, 'CZ0209', 'Tehovec', 181, 210, 38.5, 38.3);
INSERT INTO obce VALUES (846, 'CZ0209', 'Úvaly', 2811, 3053, 38.2, 40.3);
INSERT INTO obce VALUES (847, 'CZ0209', 'Veleň', 444, 461, 40.2, 42.2);
INSERT INTO obce VALUES (848, 'CZ0209', 'Veliká Ves', 128, 143, 41.0, 35.8);
INSERT INTO obce VALUES (849, 'CZ0209', 'Velké Popovice', 1177, 1280, 36.3, 37.6);
INSERT INTO obce VALUES (850, 'CZ0209', 'Větrušice', 231, 240, 36.6, 40.3);
INSERT INTO obce VALUES (851, 'CZ0209', 'Vlkančice', 73, 56, 44.1, 45.0);
INSERT INTO obce VALUES (852, 'CZ0209', 'Vodochody', 274, 267, 38.7, 41.4);
INSERT INTO obce VALUES (853, 'CZ0209', 'Všestary', 328, 322, 39.3, 36.5);
INSERT INTO obce VALUES (854, 'CZ0209', 'Vyšehořovice', 275, 281, 37.4, 40.4);
INSERT INTO obce VALUES (855, 'CZ0209', 'Výžerky', 63, 57, 36.8, 43.4);
INSERT INTO obce VALUES (856, 'CZ0209', 'Vyžlovka', 282, 306, 43.6, 43.2);
INSERT INTO obce VALUES (857, 'CZ0209', 'Zápy', 430, 391, 38.4, 39.9);
INSERT INTO obce VALUES (858, 'CZ0209', 'Záryby', 421, 401, 37.4, 39.7);
INSERT INTO obce VALUES (859, 'CZ0209', 'Zdiby', 1227, 1221, 34.6, 36.1);
INSERT INTO obce VALUES (860, 'CZ0209', 'Zeleneč', 1362, 1393, 33.4, 35.2);
INSERT INTO obce VALUES (861, 'CZ0209', 'Zlatá', 51, 57, 37.0, 37.1);
INSERT INTO obce VALUES (862, 'CZ0209', 'Zlonín', 144, 126, 39.2, 43.3);
INSERT INTO obce VALUES (863, 'CZ0209', 'Zvánovice', 204, 219, 36.9, 40.2);
INSERT INTO obce VALUES (864, 'CZ020A', 'Bojanovice', 216, 200, 42.2, 41.9);
INSERT INTO obce VALUES (865, 'CZ020A', 'Bratřínov', 69, 82, 40.2, 38.6);
INSERT INTO obce VALUES (866, 'CZ020A', 'Březová-Oleško', 388, 380, 39.5, 42.5);
INSERT INTO obce VALUES (867, 'CZ020A', 'Buš', 166, 142, 37.3, 38.4);
INSERT INTO obce VALUES (868, 'CZ020A', 'Černolice', 146, 130, 36.2, 38.2);
INSERT INTO obce VALUES (869, 'CZ020A', 'Černošice', 3006, 3173, 37.4, 39.7);
INSERT INTO obce VALUES (870, 'CZ020A', 'Červený Újezd', 508, 512, 37.2, 37.3);
INSERT INTO obce VALUES (871, 'CZ020A', 'Číčovice', 141, 123, 41.0, 42.3);
INSERT INTO obce VALUES (872, 'CZ020A', 'Čisovice', 463, 458, 40.2, 42.1);
INSERT INTO obce VALUES (873, 'CZ020A', 'Davle', 641, 700, 40.2, 43.0);
INSERT INTO obce VALUES (874, 'CZ020A', 'Dobrovíz', 243, 235, 40.3, 44.2);
INSERT INTO obce VALUES (875, 'CZ020A', 'Dobříč', 141, 143, 39.7, 39.6);
INSERT INTO obce VALUES (876, 'CZ020B', 'Narysov', 126, 116, 37.7, 40.2);
INSERT INTO obce VALUES (877, 'CZ020A', 'Dobřichovice', 1599, 1699, 37.8, 39.5);
INSERT INTO obce VALUES (878, 'CZ020A', 'Dolní Břežany', 1484, 1472, 33.4, 35.5);
INSERT INTO obce VALUES (879, 'CZ020A', 'Drahelčice', 229, 228, 38.6, 41.5);
INSERT INTO obce VALUES (880, 'CZ020A', 'Holubice', 652, 715, 34.2, 34.6);
INSERT INTO obce VALUES (881, 'CZ020A', 'Horoměřice', 1524, 1567, 35.6, 37.8);
INSERT INTO obce VALUES (882, 'CZ020A', 'Hostivice', 3544, 3731, 36.3, 39.0);
INSERT INTO obce VALUES (883, 'CZ020A', 'Hradištko', 820, 853, 38.8, 41.0);
INSERT INTO obce VALUES (884, 'CZ020A', 'Hvozdnice', 204, 203, 43.4, 42.6);
INSERT INTO obce VALUES (885, 'CZ020A', 'Choteč', 167, 177, 36.0, 37.2);
INSERT INTO obce VALUES (886, 'CZ020A', 'Chrášťany', 374, 411, 36.5, 38.7);
INSERT INTO obce VALUES (887, 'CZ020A', 'Chýně', 775, 795, 33.2, 34.4);
INSERT INTO obce VALUES (888, 'CZ020A', 'Chýnice', 146, 162, 38.7, 41.3);
INSERT INTO obce VALUES (889, 'CZ020A', 'Jeneč', 573, 628, 39.0, 41.3);
INSERT INTO obce VALUES (890, 'CZ020A', 'Jesenice', 3083, 3201, 33.0, 34.0);
INSERT INTO obce VALUES (891, 'CZ020A', 'Jílové u Prahy', 2032, 2093, 37.6, 39.4);
INSERT INTO obce VALUES (892, 'CZ020A', 'Jíloviště', 319, 316, 40.3, 42.1);
INSERT INTO obce VALUES (893, 'CZ020A', 'Jinočany', 614, 651, 34.9, 36.2);
INSERT INTO obce VALUES (894, 'CZ020A', 'Kamenný Přívoz', 644, 621, 39.7, 42.4);
INSERT INTO obce VALUES (895, 'CZ020A', 'Karlík', 229, 199, 36.3, 38.6);
INSERT INTO obce VALUES (896, 'CZ020A', 'Klínec', 246, 259, 38.7, 41.5);
INSERT INTO obce VALUES (897, 'CZ020A', 'Kněževes', 264, 261, 38.7, 43.1);
INSERT INTO obce VALUES (898, 'CZ020A', 'Kosoř', 422, 440, 35.1, 39.5);
INSERT INTO obce VALUES (899, 'CZ020A', 'Kytín', 195, 199, 40.4, 48.1);
INSERT INTO obce VALUES (900, 'CZ020A', 'Lety', 580, 615, 36.6, 41.1);
INSERT INTO obce VALUES (901, 'CZ020A', 'Libčice nad Vltavou', 1635, 1650, 38.6, 40.7);
INSERT INTO obce VALUES (902, 'CZ020A', 'Libeř', 542, 561, 36.8, 37.1);
INSERT INTO obce VALUES (903, 'CZ020A', 'Lichoceves', 163, 130, 37.2, 38.4);
INSERT INTO obce VALUES (904, 'CZ020A', 'Líšnice', 248, 241, 40.4, 41.9);
INSERT INTO obce VALUES (905, 'CZ020A', 'Měchenice', 351, 368, 40.2, 44.3);
INSERT INTO obce VALUES (906, 'CZ020A', 'Mníšek pod Brdy', 2155, 2287, 39.1, 42.3);
INSERT INTO obce VALUES (907, 'CZ020A', 'Nučice', 766, 754, 35.0, 38.1);
INSERT INTO obce VALUES (908, 'CZ020A', 'Ohrobec', 509, 497, 37.0, 37.4);
INSERT INTO obce VALUES (909, 'CZ020A', 'Okoř', 41, 31, 40.5, 42.3);
INSERT INTO obce VALUES (910, 'CZ020A', 'Okrouhlo', 334, 302, 38.9, 42.9);
INSERT INTO obce VALUES (911, 'CZ020A', 'Ořech', 409, 463, 36.0, 38.9);
INSERT INTO obce VALUES (912, 'CZ020A', 'Petrov', 273, 226, 37.9, 42.5);
INSERT INTO obce VALUES (913, 'CZ020A', 'Pohoří', 130, 129, 39.3, 39.6);
INSERT INTO obce VALUES (914, 'CZ020A', 'Průhonice', 1237, 1320, 38.2, 39.2);
INSERT INTO obce VALUES (915, 'CZ020A', 'Psáry', 1590, 1678, 35.7, 36.1);
INSERT INTO obce VALUES (916, 'CZ020A', 'Ptice', 284, 304, 39.2, 39.2);
INSERT INTO obce VALUES (917, 'CZ020A', 'Roblín', 99, 110, 41.5, 39.4);
INSERT INTO obce VALUES (918, 'CZ020A', 'Roztoky', 3679, 3859, 37.6, 40.4);
INSERT INTO obce VALUES (919, 'CZ020A', 'Rudná', 2228, 2266, 36.5, 39.6);
INSERT INTO obce VALUES (920, 'CZ020A', 'Řevnice', 1514, 1568, 41.5, 44.1);
INSERT INTO obce VALUES (921, 'CZ020A', 'Řitka', 455, 467, 34.5, 36.3);
INSERT INTO obce VALUES (922, 'CZ020A', 'Slapy', 379, 376, 40.4, 45.1);
INSERT INTO obce VALUES (923, 'CZ020A', 'Statenice', 563, 555, 37.3, 38.6);
INSERT INTO obce VALUES (924, 'CZ020A', 'Středokluky', 478, 499, 39.3, 41.9);
INSERT INTO obce VALUES (925, 'CZ020A', 'Svrkyně', 141, 149, 38.3, 39.3);
INSERT INTO obce VALUES (926, 'CZ020A', 'Štěchovice', 801, 844, 39.5, 40.7);
INSERT INTO obce VALUES (927, 'CZ020A', 'Tachlovice', 355, 372, 36.3, 37.1);
INSERT INTO obce VALUES (928, 'CZ020A', 'Trnová', 114, 94, 36.4, 40.4);
INSERT INTO obce VALUES (929, 'CZ020A', 'Třebotov', 630, 610, 38.6, 39.3);
INSERT INTO obce VALUES (930, 'CZ020A', 'Tuchoměřice', 617, 655, 36.6, 38.3);
INSERT INTO obce VALUES (931, 'CZ020A', 'Tursko', 320, 349, 37.6, 39.4);
INSERT INTO obce VALUES (932, 'CZ020A', 'Úholičky', 371, 337, 38.7, 38.9);
INSERT INTO obce VALUES (933, 'CZ020A', 'Úhonice', 461, 513, 39.8, 41.4);
INSERT INTO obce VALUES (934, 'CZ020A', 'Únětice', 322, 312, 38.3, 40.0);
INSERT INTO obce VALUES (935, 'CZ020A', 'Velké Přílepy', 1283, 1361, 32.9, 33.0);
INSERT INTO obce VALUES (936, 'CZ020A', 'Vestec', 1078, 1058, 33.2, 33.7);
INSERT INTO obce VALUES (937, 'CZ020A', 'Vonoklasy', 247, 242, 37.0, 37.0);
INSERT INTO obce VALUES (938, 'CZ020A', 'Vrané nad Vltavou', 1101, 1171, 38.9, 39.8);
INSERT INTO obce VALUES (939, 'CZ020A', 'Všenory', 777, 768, 39.5, 43.9);
INSERT INTO obce VALUES (940, 'CZ020A', 'Zahořany', 124, 129, 37.3, 40.3);
INSERT INTO obce VALUES (941, 'CZ020A', 'Zbuzany', 558, 469, 41.1, 39.0);
INSERT INTO obce VALUES (942, 'CZ020A', 'Zlatníky-Hodkovice', 559, 559, 37.5, 40.3);
INSERT INTO obce VALUES (943, 'CZ020A', 'Zvole', 779, 776, 34.8, 36.6);
INSERT INTO obce VALUES (944, 'CZ020B', 'Bezděkov pod Třemšínem', 79, 71, 39.9, 43.3);
INSERT INTO obce VALUES (945, 'CZ020B', 'Bohostice', 85, 99, 37.1, 46.2);
INSERT INTO obce VALUES (946, 'CZ020B', 'Bohutín', 819, 846, 38.9, 40.1);
INSERT INTO obce VALUES (947, 'CZ020B', 'Borotice', 153, 139, 41.9, 41.4);
INSERT INTO obce VALUES (948, 'CZ020B', 'Bratkovice', 142, 146, 40.3, 42.1);
INSERT INTO obce VALUES (949, 'CZ020B', 'Brdy', 22, 13, 40.7, 44.2);
INSERT INTO obce VALUES (950, 'CZ020B', 'Březnice', 1781, 1828, 38.9, 42.4);
INSERT INTO obce VALUES (951, 'CZ020B', 'Buková u Příbramě', 97, 109, 40.5, 37.7);
INSERT INTO obce VALUES (952, 'CZ020B', 'Bukovany', 39, 43, 41.3, 44.4);
INSERT INTO obce VALUES (953, 'CZ020B', 'Cetyně', 85, 69, 40.6, 46.5);
INSERT INTO obce VALUES (954, 'CZ020B', 'Čenkov', 163, 170, 38.9, 43.0);
INSERT INTO obce VALUES (955, 'CZ020B', 'Čím', 128, 169, 35.0, 39.2);
INSERT INTO obce VALUES (956, 'CZ020B', 'Daleké Dušníky', 200, 204, 39.8, 41.8);
INSERT INTO obce VALUES (957, 'CZ020B', 'Dlouhá Lhota', 162, 159, 39.9, 40.9);
INSERT INTO obce VALUES (958, 'CZ020B', 'Dobříš', 4148, 4316, 38.6, 41.7);
INSERT INTO obce VALUES (959, 'CZ020B', 'Dolní Hbity', 420, 421, 40.4, 42.9);
INSERT INTO obce VALUES (960, 'CZ020B', 'Drahenice', 82, 79, 43.5, 45.0);
INSERT INTO obce VALUES (961, 'CZ020B', 'Drahlín', 267, 284, 39.7, 42.4);
INSERT INTO obce VALUES (962, 'CZ020B', 'Drásov', 193, 204, 40.3, 39.4);
INSERT INTO obce VALUES (963, 'CZ020B', 'Drevníky', 162, 156, 42.2, 43.6);
INSERT INTO obce VALUES (964, 'CZ020B', 'Drhovy', 122, 113, 38.0, 42.3);
INSERT INTO obce VALUES (965, 'CZ020B', 'Dubenec', 151, 134, 40.0, 42.6);
INSERT INTO obce VALUES (966, 'CZ020B', 'Dublovice', 537, 503, 38.0, 41.1);
INSERT INTO obce VALUES (967, 'CZ020B', 'Dubno', 138, 125, 37.4, 40.1);
INSERT INTO obce VALUES (968, 'CZ020B', 'Háje', 162, 162, 38.6, 39.5);
INSERT INTO obce VALUES (969, 'CZ020B', 'Hluboš', 287, 278, 37.8, 42.9);
INSERT INTO obce VALUES (970, 'CZ020B', 'Hlubyně', 68, 67, 42.8, 44.1);
INSERT INTO obce VALUES (971, 'CZ020B', 'Horčápsko', 53, 40, 40.7, 50.8);
INSERT INTO obce VALUES (972, 'CZ020B', 'Hřiměždice', 210, 181, 39.9, 45.8);
INSERT INTO obce VALUES (973, 'CZ020B', 'Hudčice', 121, 122, 42.4, 47.1);
INSERT INTO obce VALUES (974, 'CZ020B', 'Hvožďany', 420, 416, 40.4, 41.9);
INSERT INTO obce VALUES (975, 'CZ020B', 'Chotilsko', 221, 193, 39.2, 42.1);
INSERT INTO obce VALUES (976, 'CZ020B', 'Chrást', 98, 113, 41.7, 40.5);
INSERT INTO obce VALUES (977, 'CZ020B', 'Chraštice', 131, 106, 39.0, 42.9);
INSERT INTO obce VALUES (978, 'CZ020B', 'Jablonná', 184, 155, 38.4, 39.5);
INSERT INTO obce VALUES (979, 'CZ020B', 'Jesenice', 269, 244, 39.0, 41.3);
INSERT INTO obce VALUES (980, 'CZ020B', 'Jince', 1127, 1106, 36.8, 38.2);
INSERT INTO obce VALUES (981, 'CZ020B', 'Kamýk nad Vltavou', 429, 451, 39.5, 40.5);
INSERT INTO obce VALUES (982, 'CZ020B', 'Klučenice', 235, 245, 40.5, 40.3);
INSERT INTO obce VALUES (983, 'CZ020B', 'Kňovice', 172, 154, 37.6, 44.4);
INSERT INTO obce VALUES (984, 'CZ020B', 'Korkyně', 56, 63, 42.1, 37.5);
INSERT INTO obce VALUES (985, 'CZ020B', 'Kosova Hora', 620, 601, 38.1, 41.2);
INSERT INTO obce VALUES (986, 'CZ020B', 'Kotenčice', 99, 95, 39.1, 42.4);
INSERT INTO obce VALUES (987, 'CZ020B', 'Koupě', 69, 74, 43.1, 45.0);
INSERT INTO obce VALUES (988, 'CZ020B', 'Kozárovice', 169, 188, 43.2, 45.5);
INSERT INTO obce VALUES (989, 'CZ020B', 'Krásná Hora nad Vltavou', 547, 541, 38.4, 39.7);
INSERT INTO obce VALUES (990, 'CZ020B', 'Křepenice', 82, 77, 42.5, 47.5);
INSERT INTO obce VALUES (991, 'CZ020B', 'Křešín', 60, 49, 42.3, 45.1);
INSERT INTO obce VALUES (992, 'CZ020B', 'Láz', 293, 294, 39.9, 40.5);
INSERT INTO obce VALUES (993, 'CZ020B', 'Lazsko', 94, 76, 38.4, 42.9);
INSERT INTO obce VALUES (994, 'CZ020B', 'Lešetice', 48, 56, 43.1, 48.0);
INSERT INTO obce VALUES (995, 'CZ020B', 'Lhota u Příbramě', 214, 234, 41.2, 42.2);
INSERT INTO obce VALUES (996, 'CZ020B', 'Malá Hraštice', 432, 436, 37.0, 40.3);
INSERT INTO obce VALUES (997, 'CZ020B', 'Milešov', 166, 160, 40.6, 42.3);
INSERT INTO obce VALUES (998, 'CZ020B', 'Milín', 1028, 1120, 39.5, 40.8);
INSERT INTO obce VALUES (999, 'CZ020B', 'Modřovice', 34, 38, 35.6, 41.0);
INSERT INTO obce VALUES (1000, 'CZ020B', 'Mokrovraty', 311, 329, 39.2, 42.0);
INSERT INTO obce VALUES (1001, 'CZ020B', 'Nalžovice', 258, 292, 38.7, 39.0);
INSERT INTO obce VALUES (1002, 'CZ020B', 'Nečín', 368, 369, 41.2, 42.7);
INSERT INTO obce VALUES (1003, 'CZ020B', 'Nedrahovice', 221, 246, 38.9, 40.5);
INSERT INTO obce VALUES (1004, 'CZ020B', 'Nechvalice', 297, 305, 39.1, 40.0);
INSERT INTO obce VALUES (1005, 'CZ020B', 'Nepomuk', 89, 99, 40.5, 41.8);
INSERT INTO obce VALUES (1006, 'CZ020B', 'Nestrašovice', 37, 33, 42.1, 42.5);
INSERT INTO obce VALUES (1007, 'CZ020B', 'Nová Ves pod Pleší', 454, 466, 35.6, 38.0);
INSERT INTO obce VALUES (1008, 'CZ020B', 'Nové Dvory', 97, 111, 38.9, 42.0);
INSERT INTO obce VALUES (1009, 'CZ020B', 'Nový Knín', 916, 935, 39.5, 41.5);
INSERT INTO obce VALUES (1010, 'CZ020B', 'Občov', 53, 62, 41.9, 39.0);
INSERT INTO obce VALUES (1011, 'CZ020B', 'Obecnice', 618, 611, 39.6, 41.5);
INSERT INTO obce VALUES (1012, 'CZ020B', 'Obory', 128, 118, 39.1, 44.8);
INSERT INTO obce VALUES (1013, 'CZ020B', 'Obořiště', 305, 300, 38.4, 42.1);
INSERT INTO obce VALUES (1014, 'CZ020B', 'Ohrazenice', 133, 132, 40.8, 41.7);
INSERT INTO obce VALUES (1015, 'CZ020B', 'Osečany', 130, 126, 38.1, 44.0);
INSERT INTO obce VALUES (1016, 'CZ020B', 'Ostrov', 51, 51, 40.0, 38.9);
INSERT INTO obce VALUES (1017, 'CZ020B', 'Ouběnice', 97, 105, 38.5, 41.9);
INSERT INTO obce VALUES (1018, 'CZ020B', 'Pečice', 197, 173, 38.3, 44.1);
INSERT INTO obce VALUES (1019, 'CZ020B', 'Petrovice', 653, 687, 38.9, 41.6);
INSERT INTO obce VALUES (1020, 'CZ020B', 'Pičín', 260, 290, 38.9, 40.0);
INSERT INTO obce VALUES (1021, 'CZ020B', 'Počaply', 49, 56, 38.3, 37.9);
INSERT INTO obce VALUES (1022, 'CZ020B', 'Počepice', 262, 259, 37.2, 40.4);
INSERT INTO obce VALUES (1023, 'CZ020B', 'Podlesí', 502, 516, 39.3, 41.2);
INSERT INTO obce VALUES (1024, 'CZ020B', 'Prosenická Lhota', 220, 242, 38.4, 40.6);
INSERT INTO obce VALUES (1025, 'CZ020B', 'Příbram', 16522, 17695, 39.5, 42.9);
INSERT INTO obce VALUES (1026, 'CZ020B', 'Příčovy', 140, 143, 37.4, 41.2);
INSERT INTO obce VALUES (1027, 'CZ020B', 'Radětice', 70, 76, 42.3, 40.3);
INSERT INTO obce VALUES (1028, 'CZ020B', 'Radíč', 96, 105, 40.4, 43.6);
INSERT INTO obce VALUES (1029, 'CZ020B', 'Rosovice', 416, 379, 38.5, 43.2);
INSERT INTO obce VALUES (1030, 'CZ020B', 'Rožmitál pod Třemšínem', 2116, 2243, 39.9, 45.2);
INSERT INTO obce VALUES (1031, 'CZ020B', 'Rybníky', 158, 153, 38.4, 38.8);
INSERT INTO obce VALUES (1032, 'CZ020B', 'Sádek', 99, 114, 42.1, 46.3);
INSERT INTO obce VALUES (1033, 'CZ020B', 'Sedlčany', 3655, 3988, 39.6, 43.6);
INSERT INTO obce VALUES (1034, 'CZ020B', 'Sedlec-Prčice', 1439, 1432, 40.0, 43.2);
INSERT INTO obce VALUES (1035, 'CZ020B', 'Sedlice', 109, 109, 39.5, 44.1);
INSERT INTO obce VALUES (1036, 'CZ020B', 'Smolotely', 112, 108, 41.2, 42.3);
INSERT INTO obce VALUES (1037, 'CZ020B', 'Solenice', 172, 228, 40.6, 40.6);
INSERT INTO obce VALUES (1038, 'CZ020B', 'Stará Huť', 606, 619, 38.8, 41.1);
INSERT INTO obce VALUES (1039, 'CZ020B', 'Starosedlský Hrádek', 68, 67, 39.6, 38.2);
INSERT INTO obce VALUES (1040, 'CZ020B', 'Suchodol', 155, 163, 36.3, 37.7);
INSERT INTO obce VALUES (1041, 'CZ020B', 'Svaté Pole', 178, 182, 37.9, 39.3);
INSERT INTO obce VALUES (1042, 'CZ020B', 'Svatý Jan', 344, 318, 39.6, 40.6);
INSERT INTO obce VALUES (1043, 'CZ020B', 'Svojšice', 45, 48, 43.1, 36.4);
INSERT INTO obce VALUES (1044, 'CZ020B', 'Štětkovice', 154, 144, 37.2, 38.6);
INSERT INTO obce VALUES (1045, 'CZ020B', 'Těchařovice', 20, 22, 42.9, 42.0);
INSERT INTO obce VALUES (1046, 'CZ020B', 'Tochovice', 366, 310, 37.6, 39.9);
INSERT INTO obce VALUES (1047, 'CZ020B', 'Trhové Dušníky', 217, 191, 40.0, 38.4);
INSERT INTO obce VALUES (1048, 'CZ020B', 'Třebsko', 106, 98, 39.0, 42.9);
INSERT INTO obce VALUES (1049, 'CZ020B', 'Tušovice', 45, 50, 39.9, 40.0);
INSERT INTO obce VALUES (1050, 'CZ020B', 'Velká Lečice', 75, 71, 43.9, 47.4);
INSERT INTO obce VALUES (1051, 'CZ020B', 'Věšín', 341, 320, 39.8, 42.3);
INSERT INTO obce VALUES (1052, 'CZ020B', 'Višňová', 316, 319, 37.7, 39.4);
INSERT INTO obce VALUES (1053, 'CZ020B', 'Volenice', 210, 194, 37.1, 41.7);
INSERT INTO obce VALUES (1054, 'CZ020B', 'Voznice', 248, 263, 43.4, 43.8);
INSERT INTO obce VALUES (1055, 'CZ020B', 'Vrančice', 73, 73, 38.5, 40.1);
INSERT INTO obce VALUES (1056, 'CZ020B', 'Vranovice', 131, 152, 34.7, 40.3);
INSERT INTO obce VALUES (1057, 'CZ020B', 'Vševily', 57, 64, 40.8, 44.1);
INSERT INTO obce VALUES (1058, 'CZ020B', 'Vysoká u Příbramě', 156, 174, 40.6, 43.0);
INSERT INTO obce VALUES (1059, 'CZ020B', 'Vysoký Chlumec', 430, 392, 38.4, 42.4);
INSERT INTO obce VALUES (1060, 'CZ020B', 'Zalužany', 179, 174, 43.7, 48.5);
INSERT INTO obce VALUES (1061, 'CZ020B', 'Zbenice', 57, 75, 42.9, 43.7);
INSERT INTO obce VALUES (1062, 'CZ020B', 'Zduchovice', 150, 133, 38.9, 42.0);
INSERT INTO obce VALUES (1063, 'CZ020B', 'Županovice', 35, 45, 39.5, 45.5);
INSERT INTO obce VALUES (1064, 'CZ020C', 'Bdín', 25, 33, 46.3, 45.6);
INSERT INTO obce VALUES (1065, 'CZ020C', 'Branov', 89, 96, 46.9, 44.1);
INSERT INTO obce VALUES (1066, 'CZ020C', 'Břežany', 85, 59, 38.6, 43.0);
INSERT INTO obce VALUES (1067, 'CZ020C', 'Čistá', 456, 437, 40.4, 43.0);
INSERT INTO obce VALUES (1068, 'CZ020C', 'Děkov', 105, 94, 40.2, 38.2);
INSERT INTO obce VALUES (1069, 'CZ020C', 'Drahouš', 45, 38, 44.3, 42.2);
INSERT INTO obce VALUES (1070, 'CZ020C', 'Hořesedly', 210, 229, 39.9, 39.8);
INSERT INTO obce VALUES (1071, 'CZ020C', 'Hořovičky', 287, 260, 36.4, 39.9);
INSERT INTO obce VALUES (1072, 'CZ020C', 'Hracholusky', 29, 40, 45.4, 44.7);
INSERT INTO obce VALUES (1073, 'CZ020C', 'Hřebečníky', 203, 161, 40.5, 44.2);
INSERT INTO obce VALUES (1074, 'CZ020C', 'Hředle', 292, 291, 39.4, 44.4);
INSERT INTO obce VALUES (1075, 'CZ020C', 'Hvozd', 95, 86, 41.0, 37.9);
INSERT INTO obce VALUES (1076, 'CZ020C', 'Chrášťany', 315, 309, 37.7, 40.0);
INSERT INTO obce VALUES (1077, 'CZ020C', 'Janov', 62, 56, 41.3, 52.3);
INSERT INTO obce VALUES (1078, 'CZ020C', 'Jesenice', 840, 891, 38.3, 43.5);
INSERT INTO obce VALUES (1079, 'CZ020C', 'Kalivody', 50, 45, 43.5, 48.3);
INSERT INTO obce VALUES (1080, 'CZ020C', 'Karlova Ves', 63, 58, 44.6, 44.1);
INSERT INTO obce VALUES (1081, 'CZ020C', 'Kněževes', 543, 530, 39.3, 38.9);
INSERT INTO obce VALUES (1082, 'CZ020C', 'Kolešov', 70, 55, 32.1, 39.4);
INSERT INTO obce VALUES (1083, 'CZ020C', 'Kolešovice', 443, 419, 41.4, 45.3);
INSERT INTO obce VALUES (1084, 'CZ020C', 'Kounov', 256, 265, 36.5, 38.2);
INSERT INTO obce VALUES (1085, 'CZ020C', 'Kozojedy', 43, 42, 42.6, 49.9);
INSERT INTO obce VALUES (1086, 'CZ020C', 'Krakov', 67, 55, 35.7, 41.4);
INSERT INTO obce VALUES (1087, 'CZ020C', 'Krakovec', 46, 46, 37.2, 44.0);
INSERT INTO obce VALUES (1088, 'CZ020C', 'Kroučová', 118, 136, 39.2, 41.9);
INSERT INTO obce VALUES (1089, 'CZ020C', 'Krty', 46, 50, 44.8, 46.4);
INSERT INTO obce VALUES (1090, 'CZ020C', 'Krupá', 223, 230, 41.1, 42.9);
INSERT INTO obce VALUES (1091, 'CZ020C', 'Krušovice', 329, 288, 37.6, 42.5);
INSERT INTO obce VALUES (1092, 'CZ020C', 'Křivoklát', 308, 367, 40.1, 41.5);
INSERT INTO obce VALUES (1093, 'CZ020C', 'Lašovice', 53, 57, 47.4, 49.1);
INSERT INTO obce VALUES (1094, 'CZ020C', 'Lišany', 335, 344, 39.7, 40.3);
INSERT INTO obce VALUES (1095, 'CZ020C', 'Lubná', 507, 472, 37.2, 37.7);
INSERT INTO obce VALUES (1096, 'CZ020C', 'Lužná', 894, 908, 39.9, 43.2);
INSERT INTO obce VALUES (1097, 'CZ020C', 'Malinová', 45, 46, 34.2, 38.4);
INSERT INTO obce VALUES (1098, 'CZ020C', 'Městečko', 214, 208, 42.1, 44.3);
INSERT INTO obce VALUES (1099, 'CZ020C', 'Milostín', 122, 132, 39.4, 42.1);
INSERT INTO obce VALUES (1100, 'CZ020C', 'Milý', 75, 81, 38.5, 40.5);
INSERT INTO obce VALUES (1101, 'CZ020C', 'Mšec', 449, 448, 39.1, 43.0);
INSERT INTO obce VALUES (1102, 'CZ020C', 'Mšecké Žehrovice', 225, 238, 39.0, 43.9);
INSERT INTO obce VALUES (1103, 'CZ020C', 'Mutějovice', 407, 413, 39.5, 40.0);
INSERT INTO obce VALUES (1104, 'CZ020C', 'Nesuchyně', 220, 213, 36.0, 37.9);
INSERT INTO obce VALUES (1105, 'CZ020C', 'Nezabudice', 36, 40, 49.8, 52.2);
INSERT INTO obce VALUES (1106, 'CZ020C', 'Nové Strašecí', 2531, 2667, 38.4, 41.8);
INSERT INTO obce VALUES (1107, 'CZ020C', 'Nový Dům', 72, 76, 40.1, 39.1);
INSERT INTO obce VALUES (1108, 'CZ020C', 'Olešná', 296, 279, 38.6, 42.0);
INSERT INTO obce VALUES (1109, 'CZ020C', 'Oráčov', 199, 181, 39.3, 41.6);
INSERT INTO obce VALUES (1110, 'CZ020C', 'Panoší Újezd', 145, 149, 37.7, 41.2);
INSERT INTO obce VALUES (1111, 'CZ020C', 'Pavlíkov', 569, 534, 39.1, 43.0);
INSERT INTO obce VALUES (1112, 'CZ020C', 'Petrovice', 115, 119, 40.9, 41.3);
INSERT INTO obce VALUES (1113, 'CZ020C', 'Pochvalov', 120, 144, 41.4, 45.0);
INSERT INTO obce VALUES (1114, 'CZ020C', 'Přerubenice', 34, 38, 42.4, 40.1);
INSERT INTO obce VALUES (1115, 'CZ020C', 'Příčina', 93, 89, 43.4, 43.6);
INSERT INTO obce VALUES (1116, 'CZ020C', 'Přílepy', 104, 107, 38.9, 40.9);
INSERT INTO obce VALUES (1117, 'CZ020C', 'Pšovlky', 161, 154, 40.2, 41.3);
INSERT INTO obce VALUES (1118, 'CZ020C', 'Pustověty', 82, 87, 40.9, 41.8);
INSERT INTO obce VALUES (1119, 'CZ020C', 'Račice', 83, 73, 43.2, 45.7);
INSERT INTO obce VALUES (1120, 'CZ020C', 'Rakovník', 8048, 8455, 39.6, 42.5);
INSERT INTO obce VALUES (1121, 'CZ020C', 'Roztoky', 601, 508, 39.3, 41.8);
INSERT INTO obce VALUES (1122, 'CZ020C', 'Ruda', 347, 349, 40.6, 40.6);
INSERT INTO obce VALUES (1123, 'CZ020C', 'Rynholec', 431, 423, 37.6, 41.0);
INSERT INTO obce VALUES (1124, 'CZ020C', 'Řeřichy', 64, 55, 38.6, 39.0);
INSERT INTO obce VALUES (1125, 'CZ020C', 'Řevničov', 704, 686, 38.9, 43.7);
INSERT INTO obce VALUES (1126, 'CZ020C', 'Senec', 118, 120, 36.7, 42.9);
INSERT INTO obce VALUES (1127, 'CZ020C', 'Senomaty', 509, 529, 39.2, 39.6);
INSERT INTO obce VALUES (1128, 'CZ020C', 'Skryje', 50, 87, 36.3, 42.4);
INSERT INTO obce VALUES (1129, 'CZ020C', 'Slabce', 364, 368, 39.7, 40.7);
INSERT INTO obce VALUES (1130, 'CZ020C', 'Smilovice', 31, 29, 35.8, 45.1);
INSERT INTO obce VALUES (1131, 'CZ020C', 'Srbeč', 154, 154, 40.1, 43.9);
INSERT INTO obce VALUES (1132, 'CZ020C', 'Svojetín', 187, 174, 39.6, 39.7);
INSERT INTO obce VALUES (1133, 'CZ020C', 'Sýkořice', 241, 236, 42.2, 43.5);
INSERT INTO obce VALUES (1134, 'CZ020C', 'Šanov', 239, 254, 36.4, 42.9);
INSERT INTO obce VALUES (1135, 'CZ020C', 'Šípy', 81, 72, 41.5, 50.0);
INSERT INTO obce VALUES (1136, 'CZ020C', 'Švihov', 37, 24, 36.9, 37.3);
INSERT INTO obce VALUES (1137, 'CZ020C', 'Třeboc', 62, 64, 40.0, 45.3);
INSERT INTO obce VALUES (1138, 'CZ020C', 'Třtice', 251, 236, 39.7, 42.8);
INSERT INTO obce VALUES (1139, 'CZ020C', 'Václavy', 31, 32, 46.2, 44.2);
INSERT INTO obce VALUES (1140, 'CZ020C', 'Velká Buková', 132, 125, 42.4, 42.8);
INSERT INTO obce VALUES (1141, 'CZ020C', 'Velká Chmelištná', 27, 23, 51.2, 56.2);
INSERT INTO obce VALUES (1142, 'CZ020C', 'Všesulov', 80, 73, 34.9, 35.4);
INSERT INTO obce VALUES (1143, 'CZ020C', 'Všetaty', 163, 156, 38.3, 43.9);
INSERT INTO obce VALUES (1144, 'CZ020C', 'Zavidov', 171, 154, 39.0, 39.5);
INSERT INTO obce VALUES (1145, 'CZ020C', 'Zbečno', 229, 237, 40.4, 45.8);
INSERT INTO obce VALUES (1146, 'CZ020C', 'Žďár', 45, 47, 35.4, 37.2);
INSERT INTO obce VALUES (1147, 'CZ0311', 'Adamov', 285, 283, 38.7, 41.2);
INSERT INTO obce VALUES (1148, 'CZ0311', 'Bečice', 59, 46, 43.2, 48.2);
INSERT INTO obce VALUES (1149, 'CZ0311', 'Borek', 654, 662, 39.7, 41.4);
INSERT INTO obce VALUES (1150, 'CZ0311', 'Borovany', 1920, 2040, 38.4, 40.2);
INSERT INTO obce VALUES (1151, 'CZ0311', 'Borovnice', 53, 52, 38.1, 47.5);
INSERT INTO obce VALUES (1152, 'CZ0311', 'Boršov nad Vltavou', 785, 824, 36.3, 36.7);
INSERT INTO obce VALUES (1153, 'CZ0311', 'Bošilec', 108, 99, 42.3, 44.7);
INSERT INTO obce VALUES (1154, 'CZ0311', 'Branišov', 114, 114, 35.2, 36.9);
INSERT INTO obce VALUES (1155, 'CZ0311', 'Břehov', 57, 63, 39.9, 37.4);
INSERT INTO obce VALUES (1156, 'CZ0311', 'Čakov', 132, 127, 38.7, 40.7);
INSERT INTO obce VALUES (1157, 'CZ0311', 'Čejkovice', 164, 161, 35.7, 36.7);
INSERT INTO obce VALUES (1158, 'CZ0311', 'Čenkov u Bechyně', 19, 28, 45.7, 42.3);
INSERT INTO obce VALUES (1159, 'CZ0311', 'České Budějovice', 45643, 49222, 40.0, 42.8);
INSERT INTO obce VALUES (1160, 'CZ0311', 'Čížkrajice', 121, 128, 38.8, 49.7);
INSERT INTO obce VALUES (1161, 'CZ0311', 'Dasný', 150, 156, 36.4, 35.8);
INSERT INTO obce VALUES (1162, 'CZ0311', 'Dívčice', 281, 285, 38.6, 42.5);
INSERT INTO obce VALUES (1163, 'CZ0311', 'Dobrá Voda u Českých Budějovic', 1184, 1285, 41.5, 45.4);
INSERT INTO obce VALUES (1164, 'CZ0311', 'Dobšice', 57, 57, 39.1, 37.3);
INSERT INTO obce VALUES (1165, 'CZ0311', 'Dolní Bukovsko', 791, 768, 39.0, 41.7);
INSERT INTO obce VALUES (1166, 'CZ0311', 'Doubravice', 161, 134, 36.6, 38.3);
INSERT INTO obce VALUES (1167, 'CZ0311', 'Doudleby', 209, 188, 39.4, 43.7);
INSERT INTO obce VALUES (1168, 'CZ0311', 'Drahotěšice', 144, 124, 37.5, 39.5);
INSERT INTO obce VALUES (1169, 'CZ0311', 'Dražíč', 105, 112, 46.9, 51.8);
INSERT INTO obce VALUES (1170, 'CZ0311', 'Dříteň', 784, 748, 36.4, 38.2);
INSERT INTO obce VALUES (1171, 'CZ0311', 'Dubičné', 180, 157, 39.0, 41.6);
INSERT INTO obce VALUES (1172, 'CZ0311', 'Dubné', 696, 664, 37.0, 38.7);
INSERT INTO obce VALUES (1173, 'CZ0311', 'Dynín', 162, 154, 37.6, 46.7);
INSERT INTO obce VALUES (1174, 'CZ0311', 'Habří', 49, 43, 40.5, 41.9);
INSERT INTO obce VALUES (1175, 'CZ0311', 'Hartmanice', 83, 83, 38.1, 41.4);
INSERT INTO obce VALUES (1176, 'CZ0311', 'Heřmaň', 91, 91, 38.0, 41.6);
INSERT INTO obce VALUES (1177, 'CZ0311', 'Hlavatce', 73, 75, 38.9, 39.4);
INSERT INTO obce VALUES (1178, 'CZ0311', 'Hlincová Hora', 188, 167, 36.0, 39.9);
INSERT INTO obce VALUES (1179, 'CZ0311', 'Hluboká nad Vltavou', 2412, 2501, 38.8, 41.2);
INSERT INTO obce VALUES (1180, 'CZ0311', 'Homole', 614, 620, 36.6, 37.8);
INSERT INTO obce VALUES (1181, 'CZ0311', 'Horní Kněžeklady', 47, 60, 49.4, 48.8);
INSERT INTO obce VALUES (1182, 'CZ0311', 'Horní Stropnice', 786, 754, 39.1, 40.6);
INSERT INTO obce VALUES (1183, 'CZ0311', 'Hosín', 412, 382, 37.0, 41.0);
INSERT INTO obce VALUES (1184, 'CZ0311', 'Hosty', 82, 78, 48.9, 47.8);
INSERT INTO obce VALUES (1185, 'CZ0311', 'Hradce', 33, 33, 40.7, 41.4);
INSERT INTO obce VALUES (1186, 'CZ0311', 'Hranice', 111, 98, 39.3, 44.9);
INSERT INTO obce VALUES (1187, 'CZ0311', 'Hrdějovice', 792, 790, 38.9, 39.4);
INSERT INTO obce VALUES (1188, 'CZ0311', 'Hůry', 249, 245, 37.6, 38.0);
INSERT INTO obce VALUES (1189, 'CZ0311', 'Hvozdec', 48, 51, 35.8, 36.1);
INSERT INTO obce VALUES (1190, 'CZ0311', 'Chotýčany', 96, 113, 36.6, 40.8);
INSERT INTO obce VALUES (1191, 'CZ0311', 'Chrášťany', 360, 365, 41.7, 43.5);
INSERT INTO obce VALUES (1192, 'CZ0311', 'Jankov', 196, 185, 39.8, 40.6);
INSERT INTO obce VALUES (1193, 'CZ0311', 'Jílovice', 477, 475, 42.0, 43.3);
INSERT INTO obce VALUES (1194, 'CZ0311', 'Jivno', 129, 124, 40.2, 39.3);
INSERT INTO obce VALUES (1195, 'CZ0311', 'Kamenná', 151, 142, 37.9, 38.1);
INSERT INTO obce VALUES (1196, 'CZ0311', 'Kamenný Újezd', 1101, 1116, 38.1, 40.9);
INSERT INTO obce VALUES (1197, 'CZ0311', 'Komařice', 142, 137, 43.1, 45.6);
INSERT INTO obce VALUES (1198, 'CZ0311', 'Kvítkovice', 47, 56, 38.3, 39.4);
INSERT INTO obce VALUES (1199, 'CZ0311', 'Ledenice', 1167, 1151, 38.2, 41.5);
INSERT INTO obce VALUES (1200, 'CZ0311', 'Libín', 183, 169, 38.8, 42.4);
INSERT INTO obce VALUES (1201, 'CZ0311', 'Libníč', 229, 206, 42.0, 45.2);
INSERT INTO obce VALUES (1202, 'CZ0311', 'Lipí', 277, 300, 38.9, 38.9);
INSERT INTO obce VALUES (1203, 'CZ0311', 'Lišov', 2068, 2096, 39.3, 41.6);
INSERT INTO obce VALUES (1204, 'CZ0311', 'Litvínovice', 1052, 1086, 35.8, 36.9);
INSERT INTO obce VALUES (1205, 'CZ0311', 'Ločenice', 321, 298, 39.6, 42.2);
INSERT INTO obce VALUES (1206, 'CZ0311', 'Mazelov', 113, 92, 39.6, 44.3);
INSERT INTO obce VALUES (1207, 'CZ0311', 'Mladošovice', 163, 127, 39.0, 44.5);
INSERT INTO obce VALUES (1208, 'CZ0311', 'Modrá Hůrka', 40, 36, 41.7, 42.4);
INSERT INTO obce VALUES (1209, 'CZ0311', 'Mokrý Lom', 47, 55, 42.9, 41.2);
INSERT INTO obce VALUES (1210, 'CZ0311', 'Mydlovary', 165, 142, 37.3, 38.9);
INSERT INTO obce VALUES (1211, 'CZ0311', 'Nákří', 105, 114, 41.9, 40.0);
INSERT INTO obce VALUES (1212, 'CZ0311', 'Nedabyle', 162, 155, 38.1, 40.2);
INSERT INTO obce VALUES (1213, 'CZ0311', 'Neplachov', 181, 169, 40.4, 43.2);
INSERT INTO obce VALUES (1214, 'CZ0311', 'Nová Ves', 339, 355, 37.6, 39.6);
INSERT INTO obce VALUES (1215, 'CZ0311', 'Nové Hrady', 1279, 1288, 38.3, 41.6);
INSERT INTO obce VALUES (1216, 'CZ0311', 'Olešnice', 395, 386, 39.8, 41.9);
INSERT INTO obce VALUES (1217, 'CZ0311', 'Olešník', 391, 372, 38.0, 40.6);
INSERT INTO obce VALUES (1218, 'CZ0311', 'Ostrolovský Újezd', 74, 73, 38.7, 44.5);
INSERT INTO obce VALUES (1219, 'CZ0311', 'Petříkov', 142, 131, 41.0, 42.7);
INSERT INTO obce VALUES (1220, 'CZ0311', 'Pištín', 281, 263, 39.5, 41.6);
INSERT INTO obce VALUES (1221, 'CZ0311', 'Planá', 146, 138, 35.1, 36.2);
INSERT INTO obce VALUES (1222, 'CZ0311', 'Plav', 203, 175, 39.5, 41.7);
INSERT INTO obce VALUES (1223, 'CZ0311', 'Radošovice', 89, 84, 40.4, 43.0);
INSERT INTO obce VALUES (1224, 'CZ0311', 'Roudné', 458, 460, 36.3, 36.3);
INSERT INTO obce VALUES (1225, 'CZ0311', 'Rudolfov', 1228, 1202, 40.3, 43.2);
INSERT INTO obce VALUES (1226, 'CZ0311', 'Římov', 423, 377, 38.0, 41.4);
INSERT INTO obce VALUES (1227, 'CZ0311', 'Sedlec', 248, 253, 39.2, 39.3);
INSERT INTO obce VALUES (1228, 'CZ0311', 'Slavče', 305, 263, 37.4, 40.8);
INSERT INTO obce VALUES (1229, 'CZ0311', 'Srubec', 894, 867, 37.3, 37.4);
INSERT INTO obce VALUES (1230, 'CZ0311', 'Staré Hodějovice', 535, 540, 39.1, 39.1);
INSERT INTO obce VALUES (1231, 'CZ0311', 'Strážkovice', 190, 203, 38.2, 40.9);
INSERT INTO obce VALUES (1232, 'CZ0311', 'Strýčice', 30, 23, 38.9, 46.7);
INSERT INTO obce VALUES (1233, 'CZ0311', 'Střížov', 90, 104, 39.8, 41.0);
INSERT INTO obce VALUES (1234, 'CZ0311', 'Svatý Jan nad Malší', 269, 260, 38.8, 40.2);
INSERT INTO obce VALUES (1235, 'CZ0311', 'Ševětín', 662, 711, 38.1, 39.7);
INSERT INTO obce VALUES (1236, 'CZ0311', 'Štěpánovice', 359, 353, 37.4, 40.7);
INSERT INTO obce VALUES (1237, 'CZ0311', 'Temelín', 451, 388, 37.6, 42.5);
INSERT INTO obce VALUES (1238, 'CZ0311', 'Trhové Sviny', 2481, 2467, 38.8, 40.8);
INSERT INTO obce VALUES (1239, 'CZ0311', 'Týn nad Vltavou', 4090, 4334, 36.7, 38.5);
INSERT INTO obce VALUES (1240, 'CZ0311', 'Úsilné', 190, 199, 41.9, 40.5);
INSERT INTO obce VALUES (1241, 'CZ0311', 'Včelná', 780, 814, 40.0, 41.7);
INSERT INTO obce VALUES (1242, 'CZ0311', 'Vidov', 255, 244, 32.6, 33.5);
INSERT INTO obce VALUES (1243, 'CZ0311', 'Vitín', 183, 175, 37.0, 39.3);
INSERT INTO obce VALUES (1244, 'CZ0311', 'Vlkov', 9, 9, 55.3, 53.7);
INSERT INTO obce VALUES (1245, 'CZ0311', 'Vrábče', 281, 312, 40.9, 38.9);
INSERT INTO obce VALUES (1246, 'CZ0311', 'Vráto', 143, 135, 39.2, 38.2);
INSERT INTO obce VALUES (1247, 'CZ0311', 'Všemyslice', 507, 471, 38.4, 40.7);
INSERT INTO obce VALUES (1248, 'CZ0311', 'Záboří', 159, 162, 41.6, 39.4);
INSERT INTO obce VALUES (1249, 'CZ0311', 'Zahájí', 210, 230, 38.0, 38.4);
INSERT INTO obce VALUES (1250, 'CZ0311', 'Závraty', 22, 21, 46.6, 29.7);
INSERT INTO obce VALUES (1251, 'CZ0311', 'Zliv', 1812, 1906, 39.2, 42.6);
INSERT INTO obce VALUES (1252, 'CZ0311', 'Zvíkov', 136, 136, 38.1, 37.3);
INSERT INTO obce VALUES (1253, 'CZ0311', 'Žabovřesky', 219, 202, 36.6, 37.9);
INSERT INTO obce VALUES (1254, 'CZ0311', 'Žár', 164, 155, 37.6, 41.1);
INSERT INTO obce VALUES (1255, 'CZ0311', 'Žimutice', 298, 299, 39.4, 42.6);
INSERT INTO obce VALUES (1256, 'CZ0312', 'Benešov nad Černou', 641, 668, 38.4, 39.8);
INSERT INTO obce VALUES (1257, 'CZ0312', 'Besednice', 414, 458, 37.3, 40.9);
INSERT INTO obce VALUES (1258, 'CZ0312', 'Bohdalovice', 160, 158, 38.0, 35.7);
INSERT INTO obce VALUES (1259, 'CZ0312', 'Boletice', 138, 136, 34.2, 32.4);
INSERT INTO obce VALUES (1260, 'CZ0312', 'Brloh', 554, 483, 38.4, 41.4);
INSERT INTO obce VALUES (1261, 'CZ0312', 'Bujanov', 288, 273, 35.6, 38.2);
INSERT INTO obce VALUES (1262, 'CZ0312', 'Černá v Pošumaví', 426, 391, 38.4, 40.6);
INSERT INTO obce VALUES (1263, 'CZ0312', 'Český Krumlov', 6628, 6884, 39.4, 41.5);
INSERT INTO obce VALUES (1264, 'CZ0312', 'Dolní Dvořiště', 638, 632, 35.3, 37.4);
INSERT INTO obce VALUES (1265, 'CZ0312', 'Dolní Třebonín', 596, 611, 35.5, 36.9);
INSERT INTO obce VALUES (1266, 'CZ0312', 'Frymburk', 677, 663, 38.5, 40.4);
INSERT INTO obce VALUES (1267, 'CZ0312', 'Holubov', 503, 531, 39.9, 39.6);
INSERT INTO obce VALUES (1268, 'CZ0312', 'Horní Dvořiště', 275, 247, 36.6, 39.4);
INSERT INTO obce VALUES (1269, 'CZ0312', 'Horní Planá', 1124, 1105, 40.0, 44.2);
INSERT INTO obce VALUES (1270, 'CZ0312', 'Hořice na Šumavě', 408, 393, 36.8, 37.0);
INSERT INTO obce VALUES (1271, 'CZ0312', 'Chlumec', 39, 40, 37.1, 31.3);
INSERT INTO obce VALUES (1272, 'CZ0312', 'Chvalšiny', 609, 595, 36.7, 40.0);
INSERT INTO obce VALUES (1273, 'CZ0312', 'Kájov', 783, 807, 36.2, 37.4);
INSERT INTO obce VALUES (1274, 'CZ0312', 'Kaplice', 3751, 3594, 37.7, 40.1);
INSERT INTO obce VALUES (1275, 'CZ0312', 'Křemže', 1356, 1344, 38.1, 40.6);
INSERT INTO obce VALUES (1276, 'CZ0312', 'Lipno nad Vltavou', 306, 303, 38.4, 39.2);
INSERT INTO obce VALUES (1277, 'CZ0312', 'Loučovice', 942, 882, 37.9, 41.5);
INSERT INTO obce VALUES (1278, 'CZ0312', 'Malonty', 638, 652, 34.3, 34.9);
INSERT INTO obce VALUES (1279, 'CZ0312', 'Malšín', 65, 61, 42.4, 40.9);
INSERT INTO obce VALUES (1280, 'CZ0312', 'Mirkovice', 221, 215, 39.8, 38.5);
INSERT INTO obce VALUES (1281, 'CZ0312', 'Mojné', 114, 118, 38.7, 37.3);
INSERT INTO obce VALUES (1282, 'CZ0312', 'Netřebice', 245, 226, 38.2, 42.7);
INSERT INTO obce VALUES (1283, 'CZ0312', 'Nová Ves', 198, 218, 38.6, 39.1);
INSERT INTO obce VALUES (1284, 'CZ0312', 'Omlenice', 259, 241, 37.0, 39.7);
INSERT INTO obce VALUES (1285, 'CZ0312', 'Pohorská Ves', 167, 128, 32.7, 33.4);
INSERT INTO obce VALUES (1286, 'CZ0312', 'Přední Výtoň', 119, 103, 42.6, 46.8);
INSERT INTO obce VALUES (1287, 'CZ0312', 'Přídolí', 353, 326, 35.7, 34.6);
INSERT INTO obce VALUES (1288, 'CZ0312', 'Přísečná', 102, 99, 38.9, 43.7);
INSERT INTO obce VALUES (1289, 'CZ0312', 'Rožmberk nad Vltavou', 192, 180, 38.1, 38.5);
INSERT INTO obce VALUES (1290, 'CZ0312', 'Rožmitál na Šumavě', 239, 204, 36.1, 39.0);
INSERT INTO obce VALUES (1291, 'CZ0312', 'Soběnov', 173, 177, 38.7, 40.6);
INSERT INTO obce VALUES (1292, 'CZ0312', 'Srnín', 140, 160, 36.9, 39.4);
INSERT INTO obce VALUES (1293, 'CZ0312', 'Střítež', 211, 214, 39.0, 40.0);
INSERT INTO obce VALUES (1294, 'CZ0312', 'Světlík', 133, 123, 34.6, 37.2);
INSERT INTO obce VALUES (1295, 'CZ0312', 'Velešín', 1985, 2036, 38.4, 40.1);
INSERT INTO obce VALUES (1296, 'CZ0312', 'Větřní', 2123, 2057, 36.0, 38.2);
INSERT INTO obce VALUES (1297, 'CZ0312', 'Věžovatá Pláně', 61, 64, 41.2, 40.0);
INSERT INTO obce VALUES (1298, 'CZ0312', 'Vyšší Brod', 1318, 1306, 38.1, 39.2);
INSERT INTO obce VALUES (1299, 'CZ0312', 'Zlatá Koruna', 361, 370, 40.2, 41.8);
INSERT INTO obce VALUES (1300, 'CZ0312', 'Zubčice', 220, 199, 34.7, 39.2);
INSERT INTO obce VALUES (1301, 'CZ0312', 'Zvíkov', 35, 32, 38.7, 37.2);
INSERT INTO obce VALUES (1302, 'CZ0313', 'Báňovice', 54, 50, 36.6, 43.5);
INSERT INTO obce VALUES (1303, 'CZ0313', 'Bednárec', 49, 52, 41.0, 47.6);
INSERT INTO obce VALUES (1304, 'CZ0313', 'Bednáreček', 95, 104, 39.0, 43.6);
INSERT INTO obce VALUES (1305, 'CZ0313', 'Blažejov', 217, 154, 39.3, 37.8);
INSERT INTO obce VALUES (1306, 'CZ0313', 'Bořetín', 51, 44, 33.4, 39.9);
INSERT INTO obce VALUES (1307, 'CZ0313', 'Březina', 59, 60, 53.7, 52.0);
INSERT INTO obce VALUES (1308, 'CZ0313', 'Budeč', 118, 111, 36.0, 41.8);
INSERT INTO obce VALUES (1309, 'CZ0313', 'Budíškovice', 411, 388, 40.1, 44.4);
INSERT INTO obce VALUES (1310, 'CZ0313', 'Cep', 103, 88, 39.8, 40.0);
INSERT INTO obce VALUES (1311, 'CZ0313', 'Cizkrajov', 285, 267, 38.5, 41.6);
INSERT INTO obce VALUES (1312, 'CZ0313', 'Červený Hrádek', 112, 97, 37.5, 40.3);
INSERT INTO obce VALUES (1313, 'CZ0313', 'České Velenice', 1787, 1761, 37.7, 40.5);
INSERT INTO obce VALUES (1314, 'CZ0313', 'Český Rudolec', 480, 475, 40.1, 42.7);
INSERT INTO obce VALUES (1315, 'CZ0313', 'Číměř', 397, 313, 38.6, 40.3);
INSERT INTO obce VALUES (1316, 'CZ0313', 'Člunek', 251, 237, 37.7, 40.2);
INSERT INTO obce VALUES (1317, 'CZ0313', 'Dačice', 3828, 3958, 39.5, 42.4);
INSERT INTO obce VALUES (1318, 'CZ0313', 'Dešná', 328, 302, 38.6, 42.1);
INSERT INTO obce VALUES (1319, 'CZ0313', 'Deštná', 368, 380, 37.4, 40.3);
INSERT INTO obce VALUES (1320, 'CZ0313', 'Dívčí Kopy', 35, 30, 40.4, 43.7);
INSERT INTO obce VALUES (1321, 'CZ0313', 'Dobrohošť', 25, 24, 38.0, 42.0);
INSERT INTO obce VALUES (1322, 'CZ0313', 'Dolní Pěna', 113, 124, 34.4, 34.4);
INSERT INTO obce VALUES (1323, 'CZ0313', 'Dolní Žďár', 67, 72, 37.3, 39.9);
INSERT INTO obce VALUES (1324, 'CZ0313', 'Domanín', 174, 181, 34.9, 37.4);
INSERT INTO obce VALUES (1325, 'CZ0313', 'Doňov', 41, 39, 42.4, 45.5);
INSERT INTO obce VALUES (1326, 'CZ0313', 'Drunče', 22, 26, 46.3, 52.3);
INSERT INTO obce VALUES (1327, 'CZ0313', 'Dunajovice', 114, 105, 37.7, 42.5);
INSERT INTO obce VALUES (1328, 'CZ0313', 'Dvory nad Lužnicí', 164, 181, 40.9, 41.8);
INSERT INTO obce VALUES (1329, 'CZ0313', 'Frahelž', 74, 84, 43.6, 42.9);
INSERT INTO obce VALUES (1330, 'CZ0313', 'Hadravova Rosička', 24, 27, 48.2, 47.8);
INSERT INTO obce VALUES (1331, 'CZ0313', 'Halámky', 81, 80, 41.9, 51.1);
INSERT INTO obce VALUES (1332, 'CZ0313', 'Hamr', 182, 172, 40.3, 42.0);
INSERT INTO obce VALUES (1333, 'CZ0313', 'Hatín', 106, 103, 39.5, 44.9);
INSERT INTO obce VALUES (1334, 'CZ0313', 'Heřmaneč', 47, 46, 37.3, 37.7);
INSERT INTO obce VALUES (1335, 'CZ0313', 'Horní Meziříčko', 62, 54, 41.1, 42.9);
INSERT INTO obce VALUES (1336, 'CZ0313', 'Horní Němčice', 46, 48, 39.3, 41.2);
INSERT INTO obce VALUES (1337, 'CZ0313', 'Horní Pěna', 307, 291, 37.0, 38.8);
INSERT INTO obce VALUES (1338, 'CZ0313', 'Horní Radouň', 128, 115, 39.6, 48.4);
INSERT INTO obce VALUES (1339, 'CZ0313', 'Horní Skrýchov', 73, 51, 32.8, 37.3);
INSERT INTO obce VALUES (1340, 'CZ0313', 'Horní Slatina', 78, 79, 37.9, 37.3);
INSERT INTO obce VALUES (1341, 'CZ0313', 'Hospříz', 205, 199, 37.4, 36.2);
INSERT INTO obce VALUES (1342, 'CZ0313', 'Hrachoviště', 39, 39, 38.2, 46.6);
INSERT INTO obce VALUES (1343, 'CZ0313', 'Hříšice', 155, 171, 35.5, 38.0);
INSERT INTO obce VALUES (1344, 'CZ0313', 'Chlum u Třeboně', 1082, 1061, 41.7, 44.4);
INSERT INTO obce VALUES (1345, 'CZ0313', 'Jarošov nad Nežárkou', 555, 551, 38.6, 40.6);
INSERT INTO obce VALUES (1346, 'CZ0313', 'Jilem', 59, 51, 45.1, 46.4);
INSERT INTO obce VALUES (1347, 'CZ0313', 'Jindřichův Hradec', 10827, 11633, 39.1, 41.7);
INSERT INTO obce VALUES (1348, 'CZ0313', 'Kačlehy', 45, 35, 39.8, 50.8);
INSERT INTO obce VALUES (1349, 'CZ0313', 'Kamenný Malíkov', 27, 35, 46.4, 53.5);
INSERT INTO obce VALUES (1350, 'CZ0313', 'Kardašova Řečice', 1129, 1148, 38.5, 41.8);
INSERT INTO obce VALUES (1351, 'CZ0313', 'Klec', 85, 88, 46.1, 42.1);
INSERT INTO obce VALUES (1352, 'CZ0313', 'Kostelní Radouň', 140, 150, 40.9, 41.6);
INSERT INTO obce VALUES (1353, 'CZ0313', 'Kostelní Vydří', 86, 78, 40.2, 43.0);
INSERT INTO obce VALUES (1354, 'CZ0313', 'Kunžak', 784, 740, 39.3, 42.2);
INSERT INTO obce VALUES (1355, 'CZ0313', 'Lásenice', 298, 268, 37.1, 40.2);
INSERT INTO obce VALUES (1356, 'CZ0313', 'Lodhéřov', 321, 302, 38.0, 40.6);
INSERT INTO obce VALUES (1357, 'CZ0313', 'Lomnice nad Lužnicí', 845, 915, 39.5, 41.8);
INSERT INTO obce VALUES (1358, 'CZ0313', 'Lužnice', 205, 224, 38.0, 41.9);
INSERT INTO obce VALUES (1359, 'CZ0313', 'Majdalena', 240, 249, 39.3, 45.2);
INSERT INTO obce VALUES (1360, 'CZ0313', 'Nová Bystřice', 1703, 1696, 38.9, 41.2);
INSERT INTO obce VALUES (1361, 'CZ0313', 'Nová Olešná', 52, 57, 40.8, 46.1);
INSERT INTO obce VALUES (1362, 'CZ0313', 'Nová Včelnice', 1169, 1207, 40.6, 43.4);
INSERT INTO obce VALUES (1363, 'CZ0313', 'Nová Ves nad Lužnicí', 197, 175, 37.6, 40.4);
INSERT INTO obce VALUES (1364, 'CZ0313', 'Novosedly nad Nežárkou', 316, 321, 39.7, 42.7);
INSERT INTO obce VALUES (1365, 'CZ0313', 'Okrouhlá Radouň', 92, 95, 38.2, 45.8);
INSERT INTO obce VALUES (1366, 'CZ0313', 'Peč', 219, 185, 37.3, 39.6);
INSERT INTO obce VALUES (1367, 'CZ0313', 'Písečné', 282, 286, 38.2, 40.0);
INSERT INTO obce VALUES (1368, 'CZ0313', 'Pístina', 60, 119, 43.8, 45.2);
INSERT INTO obce VALUES (1369, 'CZ0313', 'Plavsko', 219, 232, 39.8, 42.7);
INSERT INTO obce VALUES (1370, 'CZ0313', 'Pleše', 89, 95, 43.4, 41.7);
INSERT INTO obce VALUES (1371, 'CZ0313', 'Pluhův Žďár', 321, 290, 40.4, 45.5);
INSERT INTO obce VALUES (1372, 'CZ0313', 'Polště', 55, 50, 38.5, 42.3);
INSERT INTO obce VALUES (1373, 'CZ0313', 'Ponědraž', 55, 49, 45.2, 47.6);
INSERT INTO obce VALUES (1374, 'CZ0313', 'Ponědrážka', 34, 40, 50.2, 43.2);
INSERT INTO obce VALUES (1375, 'CZ0313', 'Popelín', 266, 237, 39.3, 44.7);
INSERT INTO obce VALUES (1376, 'CZ0313', 'Příbraz', 135, 116, 41.3, 46.7);
INSERT INTO obce VALUES (1377, 'CZ0313', 'Rapšach', 290, 272, 36.9, 39.3);
INSERT INTO obce VALUES (1378, 'CZ0313', 'Ratiboř', 88, 94, 43.0, 46.3);
INSERT INTO obce VALUES (1379, 'CZ0313', 'Rodvínov', 249, 223, 38.6, 38.9);
INSERT INTO obce VALUES (1380, 'CZ0313', 'Roseč', 99, 111, 37.9, 37.7);
INSERT INTO obce VALUES (1381, 'CZ0313', 'Rosička', 33, 28, 47.2, 47.5);
INSERT INTO obce VALUES (1382, 'CZ0313', 'Slavonice', 1317, 1308, 38.6, 41.1);
INSERT INTO obce VALUES (1383, 'CZ0313', 'Smržov', 45, 55, 41.4, 45.2);
INSERT INTO obce VALUES (1384, 'CZ0313', 'Staňkov', 119, 108, 41.0, 47.5);
INSERT INTO obce VALUES (1385, 'CZ0313', 'Staré Hobzí', 272, 270, 39.8, 41.5);
INSERT INTO obce VALUES (1386, 'CZ0313', 'Staré Město pod Landštejnem', 260, 245, 39.0, 42.4);
INSERT INTO obce VALUES (1387, 'CZ0313', 'Stráž nad Nežárkou', 416, 442, 40.0, 41.7);
INSERT INTO obce VALUES (1388, 'CZ0313', 'Strmilov', 709, 736, 39.0, 42.9);
INSERT INTO obce VALUES (1389, 'CZ0313', 'Stříbřec', 231, 226, 44.0, 47.3);
INSERT INTO obce VALUES (1390, 'CZ0313', 'Střížovice', 294, 282, 38.5, 41.9);
INSERT INTO obce VALUES (1391, 'CZ0313', 'Studená', 1172, 1229, 40.3, 43.2);
INSERT INTO obce VALUES (1392, 'CZ0313', 'Suchdol nad Lužnicí', 1780, 1879, 40.4, 42.8);
INSERT INTO obce VALUES (1393, 'CZ0313', 'Světce', 77, 76, 43.2, 44.9);
INSERT INTO obce VALUES (1394, 'CZ0313', 'Třebětice', 153, 147, 37.1, 41.0);
INSERT INTO obce VALUES (1395, 'CZ0313', 'Třeboň', 4210, 4499, 40.1, 43.2);
INSERT INTO obce VALUES (1396, 'CZ0313', 'Újezdec', 37, 33, 39.0, 47.5);
INSERT INTO obce VALUES (1397, 'CZ0313', 'Velký Ratmírov', 110, 107, 38.6, 39.4);
INSERT INTO obce VALUES (1398, 'CZ0313', 'Vícemil', 45, 39, 39.3, 46.2);
INSERT INTO obce VALUES (1399, 'CZ0313', 'Višňová', 44, 33, 43.7, 41.6);
INSERT INTO obce VALUES (1400, 'CZ0313', 'Vlčetínec', 26, 28, 46.0, 46.7);
INSERT INTO obce VALUES (1401, 'CZ0313', 'Volfířov', 367, 340, 35.8, 41.2);
INSERT INTO obce VALUES (1402, 'CZ0313', 'Vydří', 68, 61, 41.3, 47.1);
INSERT INTO obce VALUES (1403, 'CZ0313', 'Záblatí', 37, 37, 40.8, 46.0);
INSERT INTO obce VALUES (1404, 'CZ0313', 'Záhoří', 63, 59, 39.7, 38.2);
INSERT INTO obce VALUES (1405, 'CZ0313', 'Zahrádky', 106, 125, 45.1, 43.8);
INSERT INTO obce VALUES (1406, 'CZ0313', 'Žďár', 46, 43, 44.6, 42.1);
INSERT INTO obce VALUES (1407, 'CZ0313', 'Županovice', 24, 36, 30.0, 35.5);
INSERT INTO obce VALUES (1408, 'CZ0314', 'Albrechtice nad Vltavou', 428, 412, 43.2, 45.5);
INSERT INTO obce VALUES (1409, 'CZ0314', 'Bernartice', 625, 648, 41.2, 44.0);
INSERT INTO obce VALUES (1410, 'CZ0314', 'Borovany', 104, 105, 40.5, 46.2);
INSERT INTO obce VALUES (1411, 'CZ0314', 'Boudy', 93, 81, 38.7, 47.9);
INSERT INTO obce VALUES (1412, 'CZ0314', 'Božetice', 185, 190, 39.1, 40.6);
INSERT INTO obce VALUES (1413, 'CZ0314', 'Branice', 146, 158, 41.7, 41.6);
INSERT INTO obce VALUES (1414, 'CZ0314', 'Cerhonice', 69, 73, 47.6, 48.0);
INSERT INTO obce VALUES (1415, 'CZ0314', 'Čimelice', 502, 493, 40.0, 43.7);
INSERT INTO obce VALUES (1416, 'CZ0314', 'Čížová', 498, 520, 38.3, 40.1);
INSERT INTO obce VALUES (1417, 'CZ0314', 'Dobev', 373, 368, 37.8, 40.4);
INSERT INTO obce VALUES (1418, 'CZ0314', 'Dolní Novosedly', 106, 109, 39.7, 43.8);
INSERT INTO obce VALUES (1419, 'CZ0314', 'Drhovle', 262, 238, 46.5, 50.4);
INSERT INTO obce VALUES (1420, 'CZ0314', 'Heřmaň', 125, 115, 37.6, 45.1);
INSERT INTO obce VALUES (1421, 'CZ0314', 'Horosedly', 61, 54, 38.7, 41.2);
INSERT INTO obce VALUES (1422, 'CZ0314', 'Hrazany', 152, 133, 41.2, 39.3);
INSERT INTO obce VALUES (1423, 'CZ0314', 'Hrejkovice', 246, 236, 41.1, 44.4);
INSERT INTO obce VALUES (1424, 'CZ0314', 'Chyšky', 551, 544, 38.3, 39.9);
INSERT INTO obce VALUES (1425, 'CZ0314', 'Jetětice', 138, 148, 40.0, 44.7);
INSERT INTO obce VALUES (1426, 'CZ0314', 'Jickovice', 46, 44, 42.1, 48.3);
INSERT INTO obce VALUES (1427, 'CZ0314', 'Kestřany', 344, 308, 37.7, 41.9);
INSERT INTO obce VALUES (1428, 'CZ0314', 'Kluky', 283, 270, 37.0, 42.5);
INSERT INTO obce VALUES (1429, 'CZ0314', 'Kostelec nad Vltavou', 186, 202, 41.0, 47.1);
INSERT INTO obce VALUES (1430, 'CZ0314', 'Kovářov', 722, 735, 42.0, 43.6);
INSERT INTO obce VALUES (1431, 'CZ0314', 'Kožlí', 24, 23, 42.0, 42.6);
INSERT INTO obce VALUES (1432, 'CZ0314', 'Králova Lhota', 97, 104, 39.7, 44.4);
INSERT INTO obce VALUES (1433, 'CZ0314', 'Křenovice', 74, 81, 42.3, 45.0);
INSERT INTO obce VALUES (1434, 'CZ0314', 'Křižanov', 52, 45, 42.3, 53.5);
INSERT INTO obce VALUES (1435, 'CZ0314', 'Kučeř', 86, 85, 41.3, 46.1);
INSERT INTO obce VALUES (1436, 'CZ0314', 'Květov', 59, 52, 42.3, 44.2);
INSERT INTO obce VALUES (1437, 'CZ0314', 'Lety', 139, 125, 43.1, 40.3);
INSERT INTO obce VALUES (1438, 'CZ0314', 'Milevsko', 4395, 4666, 41.6, 44.0);
INSERT INTO obce VALUES (1439, 'CZ0314', 'Minice', 18, 18, 50.3, 54.8);
INSERT INTO obce VALUES (1440, 'CZ0314', 'Mirotice', 599, 592, 38.7, 42.9);
INSERT INTO obce VALUES (1441, 'CZ0314', 'Mirovice', 772, 825, 39.8, 43.2);
INSERT INTO obce VALUES (1442, 'CZ0314', 'Mišovice', 98, 110, 42.3, 48.1);
INSERT INTO obce VALUES (1443, 'CZ0314', 'Myslín', 45, 43, 39.5, 36.0);
INSERT INTO obce VALUES (1444, 'CZ0314', 'Nerestce', 57, 50, 41.0, 45.5);
INSERT INTO obce VALUES (1445, 'CZ0314', 'Nevězice', 83, 68, 40.1, 51.9);
INSERT INTO obce VALUES (1446, 'CZ0314', 'Okrouhlá', 29, 41, 39.6, 41.4);
INSERT INTO obce VALUES (1447, 'CZ0314', 'Olešná', 60, 44, 41.8, 45.5);
INSERT INTO obce VALUES (1448, 'CZ0314', 'Orlík nad Vltavou', 161, 165, 41.4, 44.2);
INSERT INTO obce VALUES (1449, 'CZ0314', 'Osek', 69, 55, 33.2, 43.7);
INSERT INTO obce VALUES (1450, 'CZ0314', 'Oslov', 165, 187, 40.9, 42.7);
INSERT INTO obce VALUES (1451, 'CZ0314', 'Ostrovec', 238, 203, 39.8, 42.4);
INSERT INTO obce VALUES (1452, 'CZ0314', 'Paseky', 78, 64, 42.2, 46.4);
INSERT INTO obce VALUES (1453, 'CZ0314', 'Písek', 14389, 15560, 39.5, 42.6);
INSERT INTO obce VALUES (1454, 'CZ0314', 'Podolí I', 185, 168, 40.9, 42.7);
INSERT INTO obce VALUES (1455, 'CZ0314', 'Probulov', 26, 21, 52.3, 66.0);
INSERT INTO obce VALUES (1456, 'CZ0314', 'Protivín', 2500, 2483, 39.2, 42.3);
INSERT INTO obce VALUES (1457, 'CZ0314', 'Přeborov', 66, 63, 39.6, 46.9);
INSERT INTO obce VALUES (1458, 'CZ0314', 'Předotice', 225, 247, 39.8, 43.0);
INSERT INTO obce VALUES (1459, 'CZ0314', 'Přeštěnice', 146, 142, 39.0, 40.8);
INSERT INTO obce VALUES (1460, 'CZ0314', 'Putim', 248, 254, 39.5, 41.9);
INSERT INTO obce VALUES (1461, 'CZ0314', 'Rakovice', 107, 113, 42.1, 42.2);
INSERT INTO obce VALUES (1462, 'CZ0314', 'Ražice', 205, 206, 43.1, 45.3);
INSERT INTO obce VALUES (1463, 'CZ0314', 'Sepekov', 671, 683, 41.5, 44.9);
INSERT INTO obce VALUES (1464, 'CZ0314', 'Skály', 136, 134, 45.1, 45.0);
INSERT INTO obce VALUES (1465, 'CZ0314', 'Slabčice', 160, 140, 40.9, 46.9);
INSERT INTO obce VALUES (1466, 'CZ0314', 'Smetanova Lhota', 145, 130, 43.5, 46.0);
INSERT INTO obce VALUES (1467, 'CZ0314', 'Stehlovice', 55, 49, 43.9, 49.3);
INSERT INTO obce VALUES (1468, 'CZ0314', 'Tálín', 85, 74, 40.9, 42.2);
INSERT INTO obce VALUES (1469, 'CZ0314', 'Temešvár', 52, 62, 43.1, 37.9);
INSERT INTO obce VALUES (1470, 'CZ0314', 'Varvažov', 103, 86, 48.1, 49.2);
INSERT INTO obce VALUES (1471, 'CZ0314', 'Veselíčko', 103, 88, 40.3, 45.0);
INSERT INTO obce VALUES (1472, 'CZ0314', 'Vlastec', 98, 101, 34.6, 43.2);
INSERT INTO obce VALUES (1473, 'CZ0314', 'Vlksice', 66, 73, 42.6, 44.5);
INSERT INTO obce VALUES (1474, 'CZ0314', 'Vojníkov', 39, 26, 53.8, 58.5);
INSERT INTO obce VALUES (1475, 'CZ0314', 'Vráž', 137, 146, 39.8, 41.7);
INSERT INTO obce VALUES (1476, 'CZ0314', 'Vrcovice', 76, 76, 36.6, 36.9);
INSERT INTO obce VALUES (1477, 'CZ0314', 'Záhoří', 395, 393, 40.2, 42.8);
INSERT INTO obce VALUES (1478, 'CZ0314', 'Zbelítov', 159, 171, 41.1, 43.5);
INSERT INTO obce VALUES (1479, 'CZ0314', 'Zběšičky', 69, 72, 36.2, 45.1);
INSERT INTO obce VALUES (1480, 'CZ0314', 'Zhoř', 149, 127, 39.1, 46.9);
INSERT INTO obce VALUES (1481, 'CZ0314', 'Zvíkovské Podhradí', 100, 98, 37.6, 40.6);
INSERT INTO obce VALUES (1482, 'CZ0314', 'Žďár', 128, 108, 43.3, 44.1);
INSERT INTO obce VALUES (1483, 'CZ0315', 'Babice', 42, 52, 39.3, 35.9);
INSERT INTO obce VALUES (1484, 'CZ0315', 'Bohumilice', 160, 146, 37.1, 43.4);
INSERT INTO obce VALUES (1485, 'CZ0315', 'Bohunice', 25, 18, 49.9, 55.9);
INSERT INTO obce VALUES (1486, 'CZ0315', 'Borová Lada', 136, 132, 40.2, 39.1);
INSERT INTO obce VALUES (1487, 'CZ0315', 'Bošice', 151, 139, 41.6, 44.6);
INSERT INTO obce VALUES (1488, 'CZ0315', 'Budkov', 45, 46, 46.8, 43.7);
INSERT INTO obce VALUES (1489, 'CZ0315', 'Buk', 142, 138, 37.1, 41.6);
INSERT INTO obce VALUES (1490, 'CZ0315', 'Bušanovice', 126, 112, 38.8, 43.9);
INSERT INTO obce VALUES (1491, 'CZ0315', 'Čkyně', 746, 835, 39.2, 41.5);
INSERT INTO obce VALUES (1492, 'CZ0315', 'Drslavice', 49, 35, 42.5, 46.6);
INSERT INTO obce VALUES (1493, 'CZ0315', 'Dub', 209, 217, 35.2, 35.6);
INSERT INTO obce VALUES (1494, 'CZ0315', 'Dvory', 32, 38, 41.8, 40.7);
INSERT INTO obce VALUES (1495, 'CZ0315', 'Horní Vltavice', 201, 203, 41.5, 40.2);
INSERT INTO obce VALUES (1496, 'CZ0315', 'Hracholusky', 259, 229, 37.6, 40.6);
INSERT INTO obce VALUES (1497, 'CZ0315', 'Husinec', 679, 718, 37.0, 40.9);
INSERT INTO obce VALUES (1498, 'CZ0315', 'Chlumany', 174, 162, 37.3, 39.6);
INSERT INTO obce VALUES (1499, 'CZ0315', 'Chroboly', 255, 229, 39.2, 39.0);
INSERT INTO obce VALUES (1500, 'CZ0315', 'Chvalovice', 87, 79, 39.3, 40.9);
INSERT INTO obce VALUES (1501, 'CZ0315', 'Kratušín', 25, 28, 46.5, 47.3);
INSERT INTO obce VALUES (1502, 'CZ0315', 'Křišťanov', 55, 38, 41.9, 47.8);
INSERT INTO obce VALUES (1503, 'CZ0315', 'Ktiš', 248, 246, 37.2, 37.5);
INSERT INTO obce VALUES (1504, 'CZ0315', 'Kubova Huť', 56, 52, 37.2, 38.1);
INSERT INTO obce VALUES (1505, 'CZ0315', 'Kvilda', 82, 99, 40.7, 39.6);
INSERT INTO obce VALUES (1506, 'CZ0315', 'Lažiště', 159, 160, 35.0, 37.0);
INSERT INTO obce VALUES (1507, 'CZ0315', 'Lčovice', 66, 68, 40.6, 47.1);
INSERT INTO obce VALUES (1508, 'CZ0315', 'Lenora', 402, 394, 38.4, 40.3);
INSERT INTO obce VALUES (1509, 'CZ0315', 'Lhenice', 916, 914, 39.9, 40.7);
INSERT INTO obce VALUES (1510, 'CZ0315', 'Lipovice', 84, 107, 40.9, 39.3);
INSERT INTO obce VALUES (1511, 'CZ0315', 'Lužice', 21, 16, 45.5, 48.6);
INSERT INTO obce VALUES (1512, 'CZ0315', 'Mahouš', 82, 67, 38.1, 39.2);
INSERT INTO obce VALUES (1513, 'CZ0315', 'Malovice', 333, 291, 38.8, 42.7);
INSERT INTO obce VALUES (1514, 'CZ0315', 'Mičovice', 169, 162, 40.6, 44.3);
INSERT INTO obce VALUES (1515, 'CZ0315', 'Nebahovy', 240, 213, 40.9, 42.3);
INSERT INTO obce VALUES (1516, 'CZ0315', 'Němčice', 95, 91, 37.4, 37.8);
INSERT INTO obce VALUES (1517, 'CZ0315', 'Netolice', 1329, 1372, 38.4, 41.3);
INSERT INTO obce VALUES (1518, 'CZ0315', 'Nicov', 39, 36, 36.9, 41.3);
INSERT INTO obce VALUES (1519, 'CZ0315', 'Nová Pec', 274, 254, 39.0, 43.2);
INSERT INTO obce VALUES (1520, 'CZ0315', 'Nové Hutě', 41, 37, 44.6, 43.4);
INSERT INTO obce VALUES (1521, 'CZ0315', 'Olšovice', 28, 17, 44.4, 54.2);
INSERT INTO obce VALUES (1522, 'CZ0315', 'Pěčnov', 67, 56, 32.5, 31.3);
INSERT INTO obce VALUES (1523, 'CZ0315', 'Prachatice', 5616, 5971, 38.5, 40.9);
INSERT INTO obce VALUES (1524, 'CZ0315', 'Radhostice', 91, 83, 38.8, 43.3);
INSERT INTO obce VALUES (1525, 'CZ0315', 'Stachy', 579, 625, 42.0, 44.5);
INSERT INTO obce VALUES (1526, 'CZ0315', 'Stožec', 112, 98, 40.0, 35.2);
INSERT INTO obce VALUES (1527, 'CZ0315', 'Strážný', 237, 206, 32.7, 32.8);
INSERT INTO obce VALUES (1528, 'CZ0315', 'Strunkovice nad Blanicí', 599, 603, 38.3, 41.7);
INSERT INTO obce VALUES (1529, 'CZ0315', 'Svatá Maří', 295, 267, 40.4, 40.6);
INSERT INTO obce VALUES (1530, 'CZ0315', 'Šumavské Hoštice', 201, 184, 36.8, 42.0);
INSERT INTO obce VALUES (1531, 'CZ0315', 'Těšovice', 136, 140, 40.1, 41.4);
INSERT INTO obce VALUES (1532, 'CZ0315', 'Tvrzice', 58, 53, 37.3, 38.9);
INSERT INTO obce VALUES (1533, 'CZ0315', 'Újezdec', 36, 30, 39.4, 50.2);
INSERT INTO obce VALUES (1534, 'CZ0315', 'Vacov', 696, 682, 40.9, 44.6);
INSERT INTO obce VALUES (1535, 'CZ0315', 'Vimperk', 3801, 4001, 38.7, 40.6);
INSERT INTO obce VALUES (1536, 'CZ0315', 'Vitějovice', 253, 235, 37.6, 42.8);
INSERT INTO obce VALUES (1537, 'CZ0315', 'Vlachovo Březí', 849, 877, 37.2, 39.7);
INSERT INTO obce VALUES (1538, 'CZ0315', 'Volary', 2055, 1959, 37.4, 39.1);
INSERT INTO obce VALUES (1539, 'CZ0315', 'Vrbice', 34, 33, 45.2, 44.7);
INSERT INTO obce VALUES (1540, 'CZ0315', 'Záblatí', 191, 167, 39.4, 41.9);
INSERT INTO obce VALUES (1541, 'CZ0315', 'Zábrdí', 24, 26, 44.5, 47.1);
INSERT INTO obce VALUES (1542, 'CZ0315', 'Zálezly', 153, 149, 43.2, 44.1);
INSERT INTO obce VALUES (1543, 'CZ0315', 'Zbytiny', 169, 147, 38.4, 42.3);
INSERT INTO obce VALUES (1544, 'CZ0315', 'Zdíkov', 894, 862, 40.1, 44.6);
INSERT INTO obce VALUES (1545, 'CZ0315', 'Žárovná', 54, 63, 39.0, 39.8);
INSERT INTO obce VALUES (1546, 'CZ0315', 'Želnava', 75, 54, 39.1, 45.3);
INSERT INTO obce VALUES (1547, 'CZ0315', 'Žernovice', 134, 119, 38.4, 37.3);
INSERT INTO obce VALUES (1548, 'CZ0316', 'Bavorov', 741, 738, 40.0, 42.9);
INSERT INTO obce VALUES (1549, 'CZ0316', 'Bělčice', 508, 507, 40.4, 45.0);
INSERT INTO obce VALUES (1550, 'CZ0316', 'Bezdědovice', 171, 154, 40.5, 44.3);
INSERT INTO obce VALUES (1551, 'CZ0316', 'Bílsko', 105, 104, 38.5, 41.9);
INSERT INTO obce VALUES (1552, 'CZ0316', 'Blatná', 3345, 3442, 39.9, 43.0);
INSERT INTO obce VALUES (1553, 'CZ0316', 'Bratronice', 30, 25, 42.7, 46.3);
INSERT INTO obce VALUES (1554, 'CZ0316', 'Březí', 38, 34, 39.3, 47.1);
INSERT INTO obce VALUES (1555, 'CZ0316', 'Budyně', 26, 23, 41.0, 39.0);
INSERT INTO obce VALUES (1556, 'CZ0316', 'Buzice', 73, 62, 39.1, 45.2);
INSERT INTO obce VALUES (1557, 'CZ0316', 'Cehnice', 239, 230, 39.7, 43.2);
INSERT INTO obce VALUES (1558, 'CZ0316', 'Čečelovice', 79, 88, 46.1, 44.6);
INSERT INTO obce VALUES (1559, 'CZ0316', 'Čejetice', 484, 440, 35.8, 40.7);
INSERT INTO obce VALUES (1560, 'CZ0316', 'Čepřovice', 95, 95, 38.1, 42.8);
INSERT INTO obce VALUES (1561, 'CZ0316', 'Čestice', 474, 453, 41.1, 42.1);
INSERT INTO obce VALUES (1562, 'CZ0316', 'Číčenice', 233, 220, 38.1, 39.9);
INSERT INTO obce VALUES (1563, 'CZ0316', 'Doubravice', 138, 113, 38.9, 43.6);
INSERT INTO obce VALUES (1564, 'CZ0316', 'Drahonice', 187, 162, 40.1, 45.3);
INSERT INTO obce VALUES (1565, 'CZ0316', 'Drachkov', 85, 77, 34.1, 41.0);
INSERT INTO obce VALUES (1566, 'CZ0316', 'Drážov', 130, 117, 38.3, 47.5);
INSERT INTO obce VALUES (1567, 'CZ0316', 'Droužetice', 61, 48, 39.9, 42.0);
INSERT INTO obce VALUES (1568, 'CZ0316', 'Dřešín', 135, 160, 39.5, 39.2);
INSERT INTO obce VALUES (1569, 'CZ0316', 'Hajany', 50, 60, 35.1, 34.0);
INSERT INTO obce VALUES (1570, 'CZ0316', 'Hájek', 19, 16, 35.2, 49.1);
INSERT INTO obce VALUES (1571, 'CZ0316', 'Hlupín', 51, 41, 41.4, 45.8);
INSERT INTO obce VALUES (1572, 'CZ0316', 'Horní Poříčí', 153, 155, 40.7, 42.6);
INSERT INTO obce VALUES (1573, 'CZ0316', 'Hornosín', 42, 35, 39.8, 42.4);
INSERT INTO obce VALUES (1574, 'CZ0316', 'Hoslovice', 102, 89, 43.6, 42.5);
INSERT INTO obce VALUES (1575, 'CZ0316', 'Hoštice', 83, 80, 40.2, 44.5);
INSERT INTO obce VALUES (1576, 'CZ0316', 'Chelčice', 193, 224, 33.5, 39.5);
INSERT INTO obce VALUES (1577, 'CZ0316', 'Chlum', 101, 87, 38.5, 41.2);
INSERT INTO obce VALUES (1578, 'CZ0316', 'Chobot', 31, 28, 44.6, 44.5);
INSERT INTO obce VALUES (1579, 'CZ0316', 'Chrášťovice', 124, 120, 39.1, 44.3);
INSERT INTO obce VALUES (1580, 'CZ0316', 'Jinín', 90, 75, 37.6, 45.4);
INSERT INTO obce VALUES (1581, 'CZ0316', 'Kadov', 188, 187, 39.7, 43.5);
INSERT INTO obce VALUES (1582, 'CZ0316', 'Kalenice', 38, 49, 44.7, 45.5);
INSERT INTO obce VALUES (1583, 'CZ0316', 'Katovice', 665, 678, 39.4, 42.6);
INSERT INTO obce VALUES (1584, 'CZ0316', 'Kladruby', 74, 75, 41.6, 41.9);
INSERT INTO obce VALUES (1585, 'CZ0316', 'Kocelovice', 80, 88, 49.6, 48.6);
INSERT INTO obce VALUES (1586, 'CZ0316', 'Krajníčko', 47, 49, 39.8, 40.8);
INSERT INTO obce VALUES (1587, 'CZ0316', 'Kraselov', 112, 115, 44.2, 42.9);
INSERT INTO obce VALUES (1588, 'CZ0316', 'Krašlovice', 75, 89, 41.6, 40.9);
INSERT INTO obce VALUES (1589, 'CZ0316', 'Krejnice', 35, 33, 37.1, 41.4);
INSERT INTO obce VALUES (1590, 'CZ0316', 'Krty-Hradec', 67, 52, 43.9, 46.8);
INSERT INTO obce VALUES (1591, 'CZ0316', 'Kuřimany', 13, 11, 47.2, 52.6);
INSERT INTO obce VALUES (1592, 'CZ0316', 'Kváskovice', 57, 56, 35.3, 36.3);
INSERT INTO obce VALUES (1593, 'CZ0316', 'Lažánky', 34, 51, 41.9, 36.9);
INSERT INTO obce VALUES (1594, 'CZ0316', 'Lažany', 74, 39, 33.0, 38.5);
INSERT INTO obce VALUES (1595, 'CZ0316', 'Libějovice', 223, 250, 38.8, 41.9);
INSERT INTO obce VALUES (1596, 'CZ0316', 'Libětice', 42, 34, 35.2, 44.0);
INSERT INTO obce VALUES (1597, 'CZ0316', 'Litochovice', 153, 144, 34.8, 40.1);
INSERT INTO obce VALUES (1598, 'CZ0316', 'Lnáře', 387, 352, 39.7, 44.0);
INSERT INTO obce VALUES (1599, 'CZ0316', 'Lom', 62, 66, 45.0, 44.4);
INSERT INTO obce VALUES (1600, 'CZ0316', 'Mačkov', 104, 190, 35.4, 39.5);
INSERT INTO obce VALUES (1601, 'CZ0316', 'Malenice', 305, 343, 40.3, 40.6);
INSERT INTO obce VALUES (1602, 'CZ0316', 'Mečichov', 113, 123, 40.0, 41.5);
INSERT INTO obce VALUES (1603, 'CZ0316', 'Měkynec', 19, 17, 37.8, 44.3);
INSERT INTO obce VALUES (1604, 'CZ0316', 'Milejovice', 30, 35, 38.4, 45.6);
INSERT INTO obce VALUES (1605, 'CZ0316', 'Miloňovice', 159, 141, 38.3, 39.2);
INSERT INTO obce VALUES (1606, 'CZ0316', 'Mnichov', 122, 133, 39.9, 41.3);
INSERT INTO obce VALUES (1607, 'CZ0316', 'Mutěnice', 109, 96, 37.9, 44.0);
INSERT INTO obce VALUES (1608, 'CZ0316', 'Myštice', 130, 158, 45.0, 45.5);
INSERT INTO obce VALUES (1609, 'CZ0316', 'Nebřehovice', 67, 72, 38.7, 41.6);
INSERT INTO obce VALUES (1610, 'CZ0316', 'Němčice', 52, 53, 40.5, 41.7);
INSERT INTO obce VALUES (1611, 'CZ0316', 'Němětice', 53, 70, 44.0, 40.5);
INSERT INTO obce VALUES (1612, 'CZ0316', 'Nihošovice', 160, 150, 39.0, 39.4);
INSERT INTO obce VALUES (1613, 'CZ0316', 'Nišovice', 107, 120, 38.8, 38.4);
INSERT INTO obce VALUES (1614, 'CZ0316', 'Nová Ves', 36, 31, 44.6, 57.6);
INSERT INTO obce VALUES (1615, 'CZ0316', 'Novosedly', 165, 189, 40.5, 42.0);
INSERT INTO obce VALUES (1616, 'CZ0316', 'Osek', 391, 281, 42.6, 42.0);
INSERT INTO obce VALUES (1617, 'CZ0316', 'Paračov', 47, 41, 37.1, 42.9);
INSERT INTO obce VALUES (1618, 'CZ0316', 'Pivkovice', 45, 36, 46.5, 52.2);
INSERT INTO obce VALUES (1619, 'CZ0316', 'Pohorovice', 47, 35, 37.5, 40.8);
INSERT INTO obce VALUES (1620, 'CZ0316', 'Pracejovice', 164, 154, 37.4, 40.7);
INSERT INTO obce VALUES (1621, 'CZ0316', 'Předmíř', 170, 164, 38.5, 42.7);
INSERT INTO obce VALUES (1622, 'CZ0316', 'Přední Zborovice', 32, 33, 51.2, 52.8);
INSERT INTO obce VALUES (1623, 'CZ0316', 'Předslavice', 134, 121, 37.1, 45.3);
INSERT INTO obce VALUES (1624, 'CZ0316', 'Přechovice', 50, 55, 39.9, 44.7);
INSERT INTO obce VALUES (1625, 'CZ0316', 'Přešťovice', 219, 204, 41.8, 44.0);
INSERT INTO obce VALUES (1626, 'CZ0316', 'Radějovice', 18, 18, 37.0, 50.8);
INSERT INTO obce VALUES (1627, 'CZ0316', 'Radomyšl', 584, 615, 37.6, 40.1);
INSERT INTO obce VALUES (1628, 'CZ0316', 'Radošovice', 343, 320, 40.1, 39.1);
INSERT INTO obce VALUES (1629, 'CZ0316', 'Rovná', 113, 136, 42.3, 42.3);
INSERT INTO obce VALUES (1630, 'CZ0316', 'Řepice', 264, 210, 35.2, 37.0);
INSERT INTO obce VALUES (1631, 'CZ0316', 'Sedlice', 658, 661, 39.9, 42.1);
INSERT INTO obce VALUES (1632, 'CZ0316', 'Skály', 34, 35, 37.6, 45.6);
INSERT INTO obce VALUES (1633, 'CZ0316', 'Skočice', 111, 114, 39.5, 41.6);
INSERT INTO obce VALUES (1634, 'CZ0316', 'Slaník', 73, 80, 33.7, 39.7);
INSERT INTO obce VALUES (1635, 'CZ0316', 'Sousedovice', 126, 134, 35.2, 39.8);
INSERT INTO obce VALUES (1636, 'CZ0316', 'Stožice', 150, 157, 37.9, 38.6);
INSERT INTO obce VALUES (1637, 'CZ0316', 'Strakonice', 11209, 11872, 39.7, 42.5);
INSERT INTO obce VALUES (1638, 'CZ0316', 'Strašice', 96, 85, 40.9, 48.1);
INSERT INTO obce VALUES (1639, 'CZ0316', 'Strunkovice nad Volyňkou', 56, 57, 39.8, 49.7);
INSERT INTO obce VALUES (1640, 'CZ0316', 'Střelské Hoštice', 469, 445, 38.1, 39.9);
INSERT INTO obce VALUES (1641, 'CZ0316', 'Škvořetice', 181, 160, 41.0, 43.6);
INSERT INTO obce VALUES (1642, 'CZ0316', 'Štěchovice', 111, 112, 38.7, 39.5);
INSERT INTO obce VALUES (1643, 'CZ0316', 'Štěkeň', 398, 438, 40.5, 44.1);
INSERT INTO obce VALUES (1644, 'CZ0316', 'Tchořovice', 114, 129, 40.2, 41.5);
INSERT INTO obce VALUES (1645, 'CZ0316', 'Truskovice', 92, 89, 37.3, 36.0);
INSERT INTO obce VALUES (1646, 'CZ0316', 'Třebohostice', 148, 154, 39.3, 41.4);
INSERT INTO obce VALUES (1647, 'CZ0316', 'Třešovice', 38, 44, 45.4, 40.1);
INSERT INTO obce VALUES (1648, 'CZ0316', 'Úlehle', 59, 49, 47.0, 50.5);
INSERT INTO obce VALUES (1649, 'CZ0316', 'Únice', 28, 26, 38.3, 51.8);
INSERT INTO obce VALUES (1650, 'CZ0316', 'Uzenice', 64, 70, 40.5, 43.9);
INSERT INTO obce VALUES (1651, 'CZ0316', 'Uzeničky', 64, 58, 44.4, 50.0);
INSERT INTO obce VALUES (1652, 'CZ0316', 'Vacovice', 33, 29, 50.9, 57.8);
INSERT INTO obce VALUES (1653, 'CZ0316', 'Velká Turná', 82, 80, 37.6, 44.2);
INSERT INTO obce VALUES (1654, 'CZ0316', 'Vodňany', 3446, 3640, 38.2, 41.3);
INSERT INTO obce VALUES (1655, 'CZ0316', 'Volenice', 262, 276, 39.4, 41.7);
INSERT INTO obce VALUES (1656, 'CZ0316', 'Volyně', 1528, 1581, 40.2, 43.8);
INSERT INTO obce VALUES (1657, 'CZ0316', 'Záboří', 165, 149, 36.3, 40.4);
INSERT INTO obce VALUES (1658, 'CZ0316', 'Zahorčice', 33, 29, 39.7, 50.6);
INSERT INTO obce VALUES (1659, 'CZ0316', 'Zvotoky', 35, 32, 43.8, 45.8);
INSERT INTO obce VALUES (1660, 'CZ0317', 'Balkova Lhota', 52, 62, 37.1, 40.8);
INSERT INTO obce VALUES (1661, 'CZ0317', 'Bečice', 41, 28, 44.9, 51.3);
INSERT INTO obce VALUES (1662, 'CZ0317', 'Bechyně', 2713, 2772, 39.7, 43.5);
INSERT INTO obce VALUES (1663, 'CZ0317', 'Běleč', 95, 85, 42.8, 39.7);
INSERT INTO obce VALUES (1664, 'CZ0317', 'Borkovice', 115, 117, 40.6, 44.3);
INSERT INTO obce VALUES (1665, 'CZ0317', 'Borotín', 295, 296, 39.8, 38.5);
INSERT INTO obce VALUES (1666, 'CZ0317', 'Bradáčov', 25, 31, 51.1, 59.8);
INSERT INTO obce VALUES (1667, 'CZ0317', 'Březnice', 91, 92, 38.9, 42.7);
INSERT INTO obce VALUES (1668, 'CZ0317', 'Budislav', 186, 185, 41.1, 47.0);
INSERT INTO obce VALUES (1669, 'CZ0317', 'Černýšovice', 37, 36, 53.5, 52.4);
INSERT INTO obce VALUES (1670, 'CZ0317', 'Dírná', 227, 226, 42.4, 43.3);
INSERT INTO obce VALUES (1671, 'CZ0317', 'Dlouhá Lhota', 92, 75, 41.5, 45.4);
INSERT INTO obce VALUES (1672, 'CZ0317', 'Dobronice u Bechyně', 56, 55, 46.2, 54.2);
INSERT INTO obce VALUES (1673, 'CZ0317', 'Dolní Hořice', 429, 396, 40.9, 45.4);
INSERT INTO obce VALUES (1674, 'CZ0317', 'Dolní Hrachovice', 77, 64, 38.5, 46.2);
INSERT INTO obce VALUES (1675, 'CZ0317', 'Drahov', 81, 76, 42.5, 46.9);
INSERT INTO obce VALUES (1676, 'CZ0317', 'Dráchov', 143, 127, 44.5, 46.3);
INSERT INTO obce VALUES (1677, 'CZ0317', 'Dražice', 381, 393, 37.5, 39.2);
INSERT INTO obce VALUES (1678, 'CZ0317', 'Dražičky', 61, 68, 34.8, 34.8);
INSERT INTO obce VALUES (1679, 'CZ0317', 'Drhovice', 100, 91, 42.5, 42.9);
INSERT INTO obce VALUES (1680, 'CZ0317', 'Haškovcova Lhota', 37, 33, 44.1, 45.7);
INSERT INTO obce VALUES (1681, 'CZ0317', 'Hlasivo', 84, 91, 42.7, 42.8);
INSERT INTO obce VALUES (1682, 'CZ0317', 'Hlavatce', 173, 194, 42.8, 43.3);
INSERT INTO obce VALUES (1683, 'CZ0317', 'Hodětín', 51, 48, 45.9, 50.0);
INSERT INTO obce VALUES (1684, 'CZ0317', 'Hodonice', 72, 85, 41.0, 37.7);
INSERT INTO obce VALUES (1685, 'CZ0317', 'Chotěmice', 55, 56, 44.7, 46.6);
INSERT INTO obce VALUES (1686, 'CZ0317', 'Chotoviny', 858, 863, 39.4, 41.2);
INSERT INTO obce VALUES (1687, 'CZ0317', 'Choustník', 254, 252, 40.6, 42.1);
INSERT INTO obce VALUES (1688, 'CZ0317', 'Chrbonín', 72, 69, 43.4, 38.9);
INSERT INTO obce VALUES (1689, 'CZ0317', 'Chýnov', 1094, 1205, 39.1, 41.2);
INSERT INTO obce VALUES (1690, 'CZ0317', 'Jedlany', 30, 33, 41.5, 47.9);
INSERT INTO obce VALUES (1691, 'CZ0317', 'Jistebnice', 1012, 1034, 39.5, 43.4);
INSERT INTO obce VALUES (1692, 'CZ0317', 'Katov', 31, 37, 47.4, 44.4);
INSERT INTO obce VALUES (1693, 'CZ0317', 'Klenovice', 297, 315, 38.3, 36.4);
INSERT INTO obce VALUES (1694, 'CZ0317', 'Komárov', 69, 54, 41.1, 46.2);
INSERT INTO obce VALUES (1695, 'CZ0317', 'Košice', 368, 355, 41.2, 42.7);
INSERT INTO obce VALUES (1696, 'CZ0317', 'Košín', 29, 33, 36.6, 36.8);
INSERT INTO obce VALUES (1697, 'CZ0317', 'Krátošice', 63, 49, 41.3, 45.9);
INSERT INTO obce VALUES (1698, 'CZ0317', 'Krtov', 72, 74, 37.5, 37.7);
INSERT INTO obce VALUES (1699, 'CZ0317', 'Libějice', 60, 43, 41.6, 46.5);
INSERT INTO obce VALUES (1700, 'CZ0317', 'Lom', 71, 74, 41.0, 45.3);
INSERT INTO obce VALUES (1701, 'CZ0317', 'Malšice', 919, 918, 41.2, 43.5);
INSERT INTO obce VALUES (1702, 'CZ0317', 'Mažice', 58, 57, 51.4, 50.3);
INSERT INTO obce VALUES (1703, 'CZ0317', 'Meziříčí', 86, 88, 39.1, 41.1);
INSERT INTO obce VALUES (1704, 'CZ0317', 'Mezná', 60, 55, 38.8, 42.8);
INSERT INTO obce VALUES (1705, 'CZ0317', 'Mladá Vožice', 1335, 1392, 39.2, 41.4);
INSERT INTO obce VALUES (1706, 'CZ0317', 'Mlýny', 75, 62, 39.6, 42.4);
INSERT INTO obce VALUES (1707, 'CZ0317', 'Myslkovice', 178, 203, 41.7, 41.7);
INSERT INTO obce VALUES (1708, 'CZ0317', 'Nadějkov', 380, 364, 38.4, 43.1);
INSERT INTO obce VALUES (1709, 'CZ0317', 'Nasavrky', 34, 35, 42.4, 39.1);
INSERT INTO obce VALUES (1710, 'CZ0317', 'Nemyšl', 146, 148, 35.8, 39.2);
INSERT INTO obce VALUES (1711, 'CZ0317', 'Nová Ves u Chýnova', 137, 144, 37.1, 39.7);
INSERT INTO obce VALUES (1712, 'CZ0317', 'Nová Ves u Mladé Vožice', 91, 86, 40.9, 43.8);
INSERT INTO obce VALUES (1713, 'CZ0317', 'Oldřichov', 115, 111, 38.1, 41.9);
INSERT INTO obce VALUES (1714, 'CZ0317', 'Opařany', 700, 694, 38.2, 42.5);
INSERT INTO obce VALUES (1715, 'CZ0317', 'Planá nad Lužnicí', 1770, 1896, 38.3, 40.1);
INSERT INTO obce VALUES (1716, 'CZ0317', 'Pohnánec', 30, 28, 42.6, 48.1);
INSERT INTO obce VALUES (1717, 'CZ0317', 'Pohnání', 42, 37, 35.2, 45.0);
INSERT INTO obce VALUES (1718, 'CZ0317', 'Pojbuky', 57, 58, 42.3, 46.3);
INSERT INTO obce VALUES (1719, 'CZ0317', 'Přehořov', 178, 168, 38.4, 36.8);
INSERT INTO obce VALUES (1720, 'CZ0317', 'Psárov', 73, 62, 42.6, 50.5);
INSERT INTO obce VALUES (1721, 'CZ0317', 'Radenín', 261, 242, 38.7, 43.3);
INSERT INTO obce VALUES (1722, 'CZ0317', 'Radětice', 118, 101, 39.5, 46.6);
INSERT INTO obce VALUES (1723, 'CZ0317', 'Radimovice u Tábora', 34, 35, 40.5, 46.0);
INSERT INTO obce VALUES (1724, 'CZ0317', 'Radimovice u Želče', 186, 189, 38.0, 38.6);
INSERT INTO obce VALUES (1725, 'CZ0317', 'Radkov', 90, 78, 41.6, 47.1);
INSERT INTO obce VALUES (1726, 'CZ0317', 'Rataje', 107, 102, 41.2, 46.1);
INSERT INTO obce VALUES (1727, 'CZ0317', 'Ratibořské Hory', 373, 377, 38.3, 41.5);
INSERT INTO obce VALUES (1728, 'CZ0317', 'Rodná', 48, 40, 44.0, 47.8);
INSERT INTO obce VALUES (1729, 'CZ0317', 'Roudná', 276, 243, 40.8, 44.2);
INSERT INTO obce VALUES (1730, 'CZ0317', 'Řemíčov', 39, 35, 45.7, 52.7);
INSERT INTO obce VALUES (1731, 'CZ0317', 'Řepeč', 123, 127, 39.1, 40.0);
INSERT INTO obce VALUES (1732, 'CZ0317', 'Řípec', 140, 159, 38.4, 41.9);
INSERT INTO obce VALUES (1733, 'CZ0317', 'Sedlečko u Soběslavě', 57, 57, 37.6, 43.2);
INSERT INTO obce VALUES (1734, 'CZ0317', 'Sezimovo Ústí', 3557, 3773, 43.0, 46.2);
INSERT INTO obce VALUES (1735, 'CZ0317', 'Skalice', 230, 241, 41.6, 42.7);
INSERT INTO obce VALUES (1736, 'CZ0317', 'Skopytce', 74, 72, 48.7, 45.2);
INSERT INTO obce VALUES (1737, 'CZ0317', 'Skrýchov u Malšic', 74, 56, 35.2, 45.1);
INSERT INTO obce VALUES (1738, 'CZ0317', 'Slapsko', 74, 84, 42.3, 40.9);
INSERT INTO obce VALUES (1739, 'CZ0317', 'Slapy', 240, 245, 39.4, 40.0);
INSERT INTO obce VALUES (1740, 'CZ0317', 'Smilovy Hory', 181, 191, 46.8, 49.1);
INSERT INTO obce VALUES (1741, 'CZ0317', 'Soběslav', 3525, 3760, 40.4, 43.6);
INSERT INTO obce VALUES (1742, 'CZ0317', 'Stádlec', 305, 287, 40.3, 44.0);
INSERT INTO obce VALUES (1743, 'CZ0317', 'Sudoměřice u Bechyně', 336, 329, 41.2, 40.8);
INSERT INTO obce VALUES (1744, 'CZ0317', 'Sudoměřice u Tábora', 151, 146, 39.7, 42.7);
INSERT INTO obce VALUES (1745, 'CZ0317', 'Sviny', 173, 164, 38.4, 39.8);
INSERT INTO obce VALUES (1746, 'CZ0317', 'Svrabov', 31, 27, 41.5, 46.9);
INSERT INTO obce VALUES (1747, 'CZ0317', 'Šebířov', 188, 168, 44.7, 43.9);
INSERT INTO obce VALUES (1748, 'CZ0317', 'Tábor', 17164, 18320, 39.7, 42.5);
INSERT INTO obce VALUES (1749, 'CZ0317', 'Třebějice', 40, 32, 50.2, 56.0);
INSERT INTO obce VALUES (1750, 'CZ0317', 'Tučapy', 389, 388, 40.9, 44.0);
INSERT INTO obce VALUES (1751, 'CZ0317', 'Turovec', 110, 120, 38.5, 41.3);
INSERT INTO obce VALUES (1752, 'CZ0317', 'Ústrašice', 149, 155, 37.5, 40.8);
INSERT INTO obce VALUES (1753, 'CZ0317', 'Val', 114, 117, 43.7, 40.7);
INSERT INTO obce VALUES (1754, 'CZ0317', 'Vesce', 150, 127, 37.3, 39.8);
INSERT INTO obce VALUES (1755, 'CZ0317', 'Veselí nad Lužnicí', 3241, 3337, 39.4, 42.7);
INSERT INTO obce VALUES (1756, 'CZ0317', 'Vilice', 90, 82, 39.5, 46.9);
INSERT INTO obce VALUES (1757, 'CZ0317', 'Vlastiboř', 144, 171, 41.9, 42.6);
INSERT INTO obce VALUES (1758, 'CZ0317', 'Vlčeves', 42, 34, 46.4, 49.4);
INSERT INTO obce VALUES (1759, 'CZ0317', 'Vlkov', 81, 70, 43.0, 52.5);
INSERT INTO obce VALUES (1760, 'CZ0317', 'Vodice', 95, 90, 50.8, 55.3);
INSERT INTO obce VALUES (1761, 'CZ0317', 'Zadní Střítež', 12, 21, 50.8, 55.8);
INSERT INTO obce VALUES (1762, 'CZ0317', 'Záhoří', 31, 26, 50.8, 52.1);
INSERT INTO obce VALUES (1763, 'CZ0317', 'Zálší', 139, 131, 41.6, 42.2);
INSERT INTO obce VALUES (1764, 'CZ0317', 'Zhoř u Mladé Vožice', 44, 51, 40.1, 38.2);
INSERT INTO obce VALUES (1765, 'CZ0317', 'Zhoř u Tábora', 77, 82, 41.0, 41.0);
INSERT INTO obce VALUES (1766, 'CZ0317', 'Zlukov', 132, 127, 40.5, 41.3);
INSERT INTO obce VALUES (1767, 'CZ0317', 'Zvěrotice', 187, 185, 39.4, 41.0);
INSERT INTO obce VALUES (1768, 'CZ0317', 'Želeč', 475, 448, 35.8, 37.5);
INSERT INTO obce VALUES (1769, 'CZ0317', 'Žíšov', 97, 88, 39.2, 42.0);
INSERT INTO obce VALUES (1770, 'CZ0321', 'Babylon', 152, 144, 38.9, 41.1);
INSERT INTO obce VALUES (1771, 'CZ0321', 'Bělá nad Radbuzou', 968, 906, 37.3, 39.5);
INSERT INTO obce VALUES (1772, 'CZ0321', 'Blížejov', 726, 686, 35.4, 38.8);
INSERT INTO obce VALUES (1773, 'CZ0321', 'Brnířov', 197, 183, 37.8, 40.9);
INSERT INTO obce VALUES (1774, 'CZ0321', 'Bukovec', 36, 51, 48.7, 44.5);
INSERT INTO obce VALUES (1775, 'CZ0321', 'Čečovice', 40, 38, 33.1, 36.8);
INSERT INTO obce VALUES (1776, 'CZ0321', 'Čermná', 107, 119, 42.5, 45.9);
INSERT INTO obce VALUES (1777, 'CZ0321', 'Černovice', 83, 110, 50.0, 59.4);
INSERT INTO obce VALUES (1778, 'CZ0321', 'Česká Kubice', 433, 365, 37.2, 37.2);
INSERT INTO obce VALUES (1779, 'CZ0321', 'Díly', 187, 195, 41.5, 42.7);
INSERT INTO obce VALUES (1780, 'CZ0321', 'Domažlice', 5262, 5695, 39.8, 43.1);
INSERT INTO obce VALUES (1781, 'CZ0321', 'Drahotín', 80, 71, 39.3, 39.4);
INSERT INTO obce VALUES (1782, 'CZ0321', 'Draženov', 223, 220, 36.0, 38.9);
INSERT INTO obce VALUES (1783, 'CZ0321', 'Hlohová', 129, 122, 41.6, 42.8);
INSERT INTO obce VALUES (1784, 'CZ0321', 'Hlohovčice', 101, 94, 39.4, 46.2);
INSERT INTO obce VALUES (1785, 'CZ0321', 'Holýšov', 2416, 2530, 37.2, 39.6);
INSERT INTO obce VALUES (1786, 'CZ0321', 'Hora Svatého Václava', 30, 28, 49.3, 43.9);
INSERT INTO obce VALUES (1787, 'CZ0321', 'Horní Kamenice', 105, 118, 41.7, 45.9);
INSERT INTO obce VALUES (1788, 'CZ0321', 'Horšovský Týn', 2429, 2516, 39.8, 40.9);
INSERT INTO obce VALUES (1789, 'CZ0321', 'Hostouň', 731, 642, 38.8, 38.9);
INSERT INTO obce VALUES (1790, 'CZ0321', 'Hradiště', 87, 79, 40.7, 44.3);
INSERT INTO obce VALUES (1791, 'CZ0321', 'Hvožďany', 13, 18, 41.0, 37.6);
INSERT INTO obce VALUES (1792, 'CZ0321', 'Chocomyšl', 54, 60, 39.9, 46.2);
INSERT INTO obce VALUES (1793, 'CZ0321', 'Chodov', 400, 380, 40.1, 41.7);
INSERT INTO obce VALUES (1794, 'CZ0321', 'Chodská Lhota', 217, 215, 35.6, 39.3);
INSERT INTO obce VALUES (1795, 'CZ0321', 'Chrastavice', 176, 179, 37.3, 38.6);
INSERT INTO obce VALUES (1796, 'CZ0321', 'Kanice', 85, 83, 43.0, 45.3);
INSERT INTO obce VALUES (1797, 'CZ0321', 'Kaničky', 15, 15, 36.0, 42.2);
INSERT INTO obce VALUES (1798, 'CZ0321', 'Kdyně', 2510, 2723, 39.0, 41.6);
INSERT INTO obce VALUES (1799, 'CZ0321', 'Klenčí pod Čerchovem', 640, 663, 38.3, 40.7);
INSERT INTO obce VALUES (1800, 'CZ0321', 'Koloveč', 491, 496, 40.1, 41.7);
INSERT INTO obce VALUES (1801, 'CZ0321', 'Kout na Šumavě', 565, 594, 39.0, 40.1);
INSERT INTO obce VALUES (1802, 'CZ0321', 'Křenovy', 71, 68, 38.3, 48.4);
INSERT INTO obce VALUES (1803, 'CZ0321', 'Kvíčovice', 176, 166, 39.5, 41.6);
INSERT INTO obce VALUES (1804, 'CZ0321', 'Libkov', 55, 54, 40.9, 38.7);
INSERT INTO obce VALUES (1805, 'CZ0321', 'Loučim', 54, 57, 48.4, 47.8);
INSERT INTO obce VALUES (1806, 'CZ0321', 'Luženičky', 161, 149, 36.7, 38.8);
INSERT INTO obce VALUES (1807, 'CZ0321', 'Meclov', 588, 542, 37.7, 38.1);
INSERT INTO obce VALUES (1808, 'CZ0321', 'Mezholezy (dříve okres Domažlice)', 42, 51, 32.8, 40.6);
INSERT INTO obce VALUES (1809, 'CZ0321', 'Mezholezy (dříve okres Horšovský Týn)', 75, 65, 44.2, 42.9);
INSERT INTO obce VALUES (1810, 'CZ0321', 'Milavče', 288, 287, 40.0, 42.8);
INSERT INTO obce VALUES (1811, 'CZ0321', 'Mířkov', 161, 139, 36.6, 41.8);
INSERT INTO obce VALUES (1812, 'CZ0321', 'Mnichov', 119, 113, 39.5, 39.9);
INSERT INTO obce VALUES (1813, 'CZ0321', 'Močerady', 35, 31, 41.3, 53.0);
INSERT INTO obce VALUES (1814, 'CZ0321', 'Mrákov', 587, 585, 40.0, 41.3);
INSERT INTO obce VALUES (1815, 'CZ0321', 'Mutěnín', 133, 136, 41.8, 43.7);
INSERT INTO obce VALUES (1816, 'CZ0321', 'Nemanice', 148, 136, 37.8, 37.7);
INSERT INTO obce VALUES (1817, 'CZ0321', 'Němčice', 70, 59, 41.1, 44.5);
INSERT INTO obce VALUES (1818, 'CZ0321', 'Neuměř', 67, 67, 44.6, 43.7);
INSERT INTO obce VALUES (1819, 'CZ0321', 'Nevolice', 82, 86, 36.9, 39.9);
INSERT INTO obce VALUES (1820, 'CZ0321', 'Nová Ves', 69, 71, 41.8, 42.9);
INSERT INTO obce VALUES (1821, 'CZ0321', 'Nový Kramolín', 128, 115, 37.6, 37.4);
INSERT INTO obce VALUES (1822, 'CZ0321', 'Osvračín', 291, 270, 38.5, 40.5);
INSERT INTO obce VALUES (1823, 'CZ0321', 'Otov', 49, 44, 39.6, 44.0);
INSERT INTO obce VALUES (1824, 'CZ0321', 'Pařezov', 70, 63, 38.7, 39.4);
INSERT INTO obce VALUES (1825, 'CZ0321', 'Pasečnice', 98, 96, 41.0, 45.6);
INSERT INTO obce VALUES (1826, 'CZ0321', 'Pec', 123, 123, 40.9, 43.5);
INSERT INTO obce VALUES (1827, 'CZ0321', 'Pelechy', 32, 33, 38.7, 46.3);
INSERT INTO obce VALUES (1828, 'CZ0321', 'Poběžovice', 809, 861, 38.4, 40.5);
INSERT INTO obce VALUES (1829, 'CZ0321', 'Pocinovice', 282, 277, 38.6, 42.4);
INSERT INTO obce VALUES (1830, 'CZ0321', 'Poděvousy', 125, 106, 37.9, 45.4);
INSERT INTO obce VALUES (1831, 'CZ0321', 'Postřekov', 574, 562, 40.2, 44.0);
INSERT INTO obce VALUES (1832, 'CZ0321', 'Puclice', 165, 175, 38.8, 42.1);
INSERT INTO obce VALUES (1833, 'CZ0321', 'Rybník', 95, 93, 37.5, 35.6);
INSERT INTO obce VALUES (1834, 'CZ0321', 'Semněvice', 87, 85, 37.7, 35.3);
INSERT INTO obce VALUES (1835, 'CZ0321', 'Spáňov', 98, 92, 38.6, 43.0);
INSERT INTO obce VALUES (1836, 'CZ0321', 'Srbice', 196, 189, 43.1, 44.7);
INSERT INTO obce VALUES (1837, 'CZ0321', 'Srby', 207, 206, 40.6, 41.9);
INSERT INTO obce VALUES (1838, 'CZ0321', 'Staňkov', 1617, 1661, 38.9, 42.1);
INSERT INTO obce VALUES (1839, 'CZ0321', 'Stráž', 132, 106, 37.4, 40.1);
INSERT INTO obce VALUES (1840, 'CZ0321', 'Štichov', 37, 33, 46.5, 47.7);
INSERT INTO obce VALUES (1841, 'CZ0321', 'Tlumačov', 209, 209, 39.2, 42.7);
INSERT INTO obce VALUES (1842, 'CZ0321', 'Trhanov', 278, 281, 41.4, 41.2);
INSERT INTO obce VALUES (1843, 'CZ0321', 'Úboč', 47, 52, 35.8, 48.4);
INSERT INTO obce VALUES (1844, 'CZ0321', 'Újezd', 190, 189, 38.1, 41.2);
INSERT INTO obce VALUES (1845, 'CZ0321', 'Únějovice', 59, 44, 40.9, 46.2);
INSERT INTO obce VALUES (1846, 'CZ0321', 'Úsilov', 71, 66, 40.1, 39.1);
INSERT INTO obce VALUES (1847, 'CZ0321', 'Velký Malahov', 128, 113, 36.6, 40.7);
INSERT INTO obce VALUES (1848, 'CZ0321', 'Vidice', 87, 94, 40.5, 43.6);
INSERT INTO obce VALUES (1849, 'CZ0321', 'Vlkanov', 64, 61, 37.3, 41.0);
INSERT INTO obce VALUES (1850, 'CZ0321', 'Všekary', 58, 48, 36.3, 42.0);
INSERT INTO obce VALUES (1851, 'CZ0321', 'Všepadly', 28, 24, 43.3, 52.2);
INSERT INTO obce VALUES (1852, 'CZ0321', 'Všeruby', 438, 421, 38.7, 39.1);
INSERT INTO obce VALUES (1853, 'CZ0321', 'Zahořany', 459, 459, 40.5, 42.1);
INSERT INTO obce VALUES (1854, 'CZ0321', 'Ždánov', 76, 69, 39.4, 40.4);
INSERT INTO obce VALUES (1855, 'CZ0322', 'Běhařov', 99, 84, 39.1, 38.4);
INSERT INTO obce VALUES (1856, 'CZ0322', 'Běšiny', 441, 407, 39.3, 40.8);
INSERT INTO obce VALUES (1857, 'CZ0322', 'Bezděkov', 464, 467, 38.8, 40.8);
INSERT INTO obce VALUES (1858, 'CZ0322', 'Biřkov', 63, 72, 42.3, 38.7);
INSERT INTO obce VALUES (1859, 'CZ0322', 'Bolešiny', 351, 364, 36.2, 39.1);
INSERT INTO obce VALUES (1860, 'CZ0322', 'Břežany', 82, 82, 38.7, 44.9);
INSERT INTO obce VALUES (1861, 'CZ0322', 'Budětice', 159, 148, 42.8, 47.0);
INSERT INTO obce VALUES (1862, 'CZ0322', 'Bukovník', 39, 44, 44.9, 38.1);
INSERT INTO obce VALUES (1863, 'CZ0322', 'Čachrov', 245, 254, 41.1, 43.0);
INSERT INTO obce VALUES (1864, 'CZ0322', 'Černíkov', 155, 174, 42.6, 41.6);
INSERT INTO obce VALUES (1865, 'CZ0322', 'Červené Poříčí', 117, 117, 38.4, 44.8);
INSERT INTO obce VALUES (1866, 'CZ0322', 'Číhaň', 99, 101, 39.2, 40.9);
INSERT INTO obce VALUES (1867, 'CZ0322', 'Čímice', 75, 75, 44.5, 50.5);
INSERT INTO obce VALUES (1868, 'CZ0322', 'Dešenice', 341, 338, 40.3, 42.8);
INSERT INTO obce VALUES (1869, 'CZ0322', 'Dlažov', 213, 222, 38.6, 40.3);
INSERT INTO obce VALUES (1870, 'CZ0322', 'Dlouhá Ves', 469, 376, 40.5, 42.2);
INSERT INTO obce VALUES (1871, 'CZ0322', 'Dobršín', 49, 57, 40.8, 43.1);
INSERT INTO obce VALUES (1872, 'CZ0322', 'Dolany', 407, 416, 40.2, 38.9);
INSERT INTO obce VALUES (1873, 'CZ0322', 'Domoraz', 28, 24, 46.0, 61.1);
INSERT INTO obce VALUES (1874, 'CZ0322', 'Dražovice', 79, 84, 37.7, 41.6);
INSERT INTO obce VALUES (1875, 'CZ0322', 'Frymburk', 58, 57, 38.5, 40.7);
INSERT INTO obce VALUES (1876, 'CZ0322', 'Hamry', 63, 44, 42.2, 47.8);
INSERT INTO obce VALUES (1877, 'CZ0322', 'Hartmanice', 555, 516, 40.3, 44.3);
INSERT INTO obce VALUES (1878, 'CZ0322', 'Hejná', 96, 72, 41.2, 48.0);
INSERT INTO obce VALUES (1879, 'CZ0322', 'Hlavňovice', 243, 247, 43.1, 44.1);
INSERT INTO obce VALUES (1880, 'CZ0322', 'Hnačov', 47, 47, 45.3, 41.5);
INSERT INTO obce VALUES (1881, 'CZ0322', 'Horažďovice', 2712, 2938, 40.1, 42.8);
INSERT INTO obce VALUES (1882, 'CZ0322', 'Horská Kvilda', 42, 46, 35.0, 37.7);
INSERT INTO obce VALUES (1883, 'CZ0322', 'Hrádek', 688, 688, 38.7, 41.8);
INSERT INTO obce VALUES (1884, 'CZ0322', 'Hradešice', 218, 213, 39.2, 44.9);
INSERT INTO obce VALUES (1885, 'CZ0322', 'Chanovice', 389, 369, 39.2, 42.4);
INSERT INTO obce VALUES (1886, 'CZ0322', 'Chlistov', 55, 51, 44.5, 44.3);
INSERT INTO obce VALUES (1887, 'CZ0322', 'Chudenice', 379, 390, 39.6, 43.0);
INSERT INTO obce VALUES (1888, 'CZ0322', 'Chudenín', 349, 307, 37.9, 37.0);
INSERT INTO obce VALUES (1889, 'CZ0322', 'Janovice nad Úhlavou', 1147, 1109, 36.9, 38.5);
INSERT INTO obce VALUES (1890, 'CZ0322', 'Javor', 38, 42, 38.7, 50.1);
INSERT INTO obce VALUES (1891, 'CZ0322', 'Ježovy', 105, 115, 41.0, 42.5);
INSERT INTO obce VALUES (1892, 'CZ0322', 'Kašperské Hory', 780, 783, 39.7, 43.6);
INSERT INTO obce VALUES (1893, 'CZ0322', 'Kejnice', 50, 63, 44.0, 43.4);
INSERT INTO obce VALUES (1894, 'CZ0322', 'Klatovy', 10937, 11852, 40.2, 43.3);
INSERT INTO obce VALUES (1895, 'CZ0322', 'Klenová', 69, 55, 36.8, 43.9);
INSERT INTO obce VALUES (1896, 'CZ0322', 'Kolinec', 798, 731, 40.3, 41.9);
INSERT INTO obce VALUES (1897, 'CZ0322', 'Kovčín', 38, 43, 46.1, 47.9);
INSERT INTO obce VALUES (1898, 'CZ0322', 'Křenice', 99, 97, 39.6, 43.2);
INSERT INTO obce VALUES (1899, 'CZ0322', 'Kvášňovice', 54, 72, 47.3, 48.6);
INSERT INTO obce VALUES (1900, 'CZ0322', 'Lomec', 49, 55, 40.9, 36.3);
INSERT INTO obce VALUES (1901, 'CZ0322', 'Malý Bor', 305, 265, 38.8, 44.5);
INSERT INTO obce VALUES (1902, 'CZ0322', 'Maňovice', 19, 21, 43.6, 42.7);
INSERT INTO obce VALUES (1903, 'CZ0322', 'Měčín', 581, 550, 40.1, 42.6);
INSERT INTO obce VALUES (1904, 'CZ0322', 'Mezihoří', 36, 36, 44.7, 40.4);
INSERT INTO obce VALUES (1905, 'CZ0322', 'Mlýnské Struhadlo', 27, 22, 46.5, 54.9);
INSERT INTO obce VALUES (1906, 'CZ0322', 'Modrava', 32, 23, 36.7, 44.7);
INSERT INTO obce VALUES (1907, 'CZ0322', 'Mochtín', 499, 481, 38.0, 42.9);
INSERT INTO obce VALUES (1908, 'CZ0322', 'Mokrosuky', 64, 60, 43.4, 51.0);
INSERT INTO obce VALUES (1909, 'CZ0322', 'Myslív', 228, 220, 40.9, 46.4);
INSERT INTO obce VALUES (1910, 'CZ0322', 'Myslovice', 56, 59, 43.7, 46.0);
INSERT INTO obce VALUES (1911, 'CZ0322', 'Nalžovské Hory', 611, 593, 40.6, 45.2);
INSERT INTO obce VALUES (1912, 'CZ0322', 'Nehodiv', 39, 39, 38.1, 47.9);
INSERT INTO obce VALUES (1913, 'CZ0322', 'Nezamyslice', 113, 106, 41.5, 43.9);
INSERT INTO obce VALUES (1914, 'CZ0322', 'Nezdice na Šumavě', 171, 172, 46.1, 51.1);
INSERT INTO obce VALUES (1915, 'CZ0322', 'Nýrsko', 2560, 2580, 38.1, 40.0);
INSERT INTO obce VALUES (1916, 'CZ0322', 'Obytce', 97, 99, 37.1, 41.1);
INSERT INTO obce VALUES (1917, 'CZ0322', 'Olšany', 113, 99, 40.6, 45.3);
INSERT INTO obce VALUES (1918, 'CZ0322', 'Ostřetice', 27, 33, 38.7, 47.5);
INSERT INTO obce VALUES (1919, 'CZ0322', 'Pačejov', 404, 393, 41.4, 42.7);
INSERT INTO obce VALUES (1920, 'CZ0322', 'Petrovice u Sušice', 298, 284, 41.1, 41.1);
INSERT INTO obce VALUES (1921, 'CZ0322', 'Plánice', 833, 871, 39.8, 43.2);
INSERT INTO obce VALUES (1922, 'CZ0322', 'Podmokly', 78, 97, 39.1, 42.5);
INSERT INTO obce VALUES (1923, 'CZ0322', 'Poleň', 146, 148, 41.1, 41.6);
INSERT INTO obce VALUES (1924, 'CZ0322', 'Prášily', 81, 75, 38.0, 37.3);
INSERT INTO obce VALUES (1925, 'CZ0322', 'Předslav', 345, 394, 38.8, 40.2);
INSERT INTO obce VALUES (1926, 'CZ0322', 'Rabí', 232, 247, 42.4, 45.7);
INSERT INTO obce VALUES (1927, 'CZ0322', 'Rejštejn', 126, 115, 41.3, 45.6);
INSERT INTO obce VALUES (1928, 'CZ0322', 'Slatina', 59, 55, 42.6, 51.8);
INSERT INTO obce VALUES (1929, 'CZ0322', 'Soběšice', 188, 203, 42.9, 46.7);
INSERT INTO obce VALUES (1930, 'CZ0322', 'Srní', 132, 138, 44.5, 41.0);
INSERT INTO obce VALUES (1931, 'CZ0322', 'Strašín', 180, 172, 42.0, 44.5);
INSERT INTO obce VALUES (1932, 'CZ0322', 'Strážov', 697, 665, 41.3, 41.9);
INSERT INTO obce VALUES (1933, 'CZ0322', 'Sušice', 5488, 5960, 39.8, 43.4);
INSERT INTO obce VALUES (1934, 'CZ0322', 'Svéradice', 181, 178, 40.9, 43.8);
INSERT INTO obce VALUES (1935, 'CZ0322', 'Švihov', 842, 820, 40.0, 43.3);
INSERT INTO obce VALUES (1936, 'CZ0322', 'Tužice', 37, 37, 38.4, 48.9);
INSERT INTO obce VALUES (1937, 'CZ0322', 'Týnec', 174, 168, 38.8, 39.8);
INSERT INTO obce VALUES (1938, 'CZ0322', 'Újezd u Plánice', 62, 48, 44.5, 47.1);
INSERT INTO obce VALUES (1939, 'CZ0322', 'Velhartice', 453, 432, 42.3, 43.6);
INSERT INTO obce VALUES (1940, 'CZ0322', 'Velké Hydčice', 111, 120, 39.7, 42.9);
INSERT INTO obce VALUES (1941, 'CZ0322', 'Velký Bor', 281, 306, 39.0, 41.1);
INSERT INTO obce VALUES (1942, 'CZ0322', 'Vrhaveč', 463, 454, 39.2, 41.7);
INSERT INTO obce VALUES (1943, 'CZ0322', 'Vřeskovice', 159, 146, 39.8, 45.3);
INSERT INTO obce VALUES (1944, 'CZ0322', 'Zavlekov', 244, 208, 40.3, 40.3);
INSERT INTO obce VALUES (1945, 'CZ0322', 'Zborovy', 63, 60, 43.0, 48.2);
INSERT INTO obce VALUES (1946, 'CZ0322', 'Železná Ruda', 1201, 1078, 37.4, 37.6);
INSERT INTO obce VALUES (1947, 'CZ0322', 'Žihobce', 309, 332, 41.7, 44.9);
INSERT INTO obce VALUES (1948, 'CZ0322', 'Žichovice', 331, 342, 41.5, 44.4);
INSERT INTO obce VALUES (1949, 'CZ0323', 'Dýšina', 805, 801, 38.7, 41.1);
INSERT INTO obce VALUES (1950, 'CZ0323', 'Chrást', 895, 925, 40.6, 43.5);
INSERT INTO obce VALUES (1951, 'CZ0323', 'Chválenice', 287, 289, 38.5, 40.2);
INSERT INTO obce VALUES (1952, 'CZ0323', 'Kyšice', 360, 397, 40.0, 40.3);
INSERT INTO obce VALUES (1953, 'CZ0323', 'Letkov', 233, 229, 37.7, 40.1);
INSERT INTO obce VALUES (1954, 'CZ0323', 'Lhůta', 77, 85, 40.6, 43.1);
INSERT INTO obce VALUES (1955, 'CZ0323', 'Losiná', 473, 482, 40.7, 40.8);
INSERT INTO obce VALUES (1956, 'CZ0323', 'Mokrouše', 86, 88, 39.4, 39.9);
INSERT INTO obce VALUES (1957, 'CZ0323', 'Nezbavětice', 94, 78, 43.1, 49.4);
INSERT INTO obce VALUES (1958, 'CZ0323', 'Nezvěstice', 682, 708, 41.7, 42.7);
INSERT INTO obce VALUES (1959, 'CZ0323', 'Plzeň', 82729, 87206, 40.4, 43.5);
INSERT INTO obce VALUES (1960, 'CZ0323', 'Starý Plzenec', 2171, 2298, 40.5, 42.4);
INSERT INTO obce VALUES (1961, 'CZ0323', 'Šťáhlavy', 1123, 1125, 40.5, 44.8);
INSERT INTO obce VALUES (1962, 'CZ0323', 'Štěnovický Borek', 220, 219, 39.5, 39.3);
INSERT INTO obce VALUES (1963, 'CZ0323', 'Tymákov', 340, 350, 41.6, 43.5);
INSERT INTO obce VALUES (1964, 'CZ0324', 'Blovice', 1941, 2147, 39.0, 41.8);
INSERT INTO obce VALUES (1965, 'CZ0324', 'Bolkov', 29, 29, 49.4, 51.5);
INSERT INTO obce VALUES (1966, 'CZ0324', 'Borovno', 43, 48, 42.6, 45.8);
INSERT INTO obce VALUES (1967, 'CZ0324', 'Borovy', 110, 114, 39.6, 43.1);
INSERT INTO obce VALUES (1968, 'CZ0324', 'Buková', 115, 100, 40.6, 44.6);
INSERT INTO obce VALUES (1969, 'CZ0324', 'Čižice', 246, 268, 41.7, 42.5);
INSERT INTO obce VALUES (1970, 'CZ0324', 'Čížkov', 321, 308, 41.6, 44.2);
INSERT INTO obce VALUES (1971, 'CZ0324', 'Čmelíny', 67, 45, 38.7, 48.1);
INSERT INTO obce VALUES (1972, 'CZ0324', 'Dnešice', 438, 394, 38.8, 41.0);
INSERT INTO obce VALUES (1973, 'CZ0324', 'Dobřany', 3057, 3080, 37.3, 39.8);
INSERT INTO obce VALUES (1974, 'CZ0324', 'Dolce', 140, 131, 39.7, 43.4);
INSERT INTO obce VALUES (1975, 'CZ0324', 'Dolní Lukavice', 435, 434, 38.5, 41.7);
INSERT INTO obce VALUES (1976, 'CZ0324', 'Drahkov', 62, 66, 42.2, 49.9);
INSERT INTO obce VALUES (1977, 'CZ0324', 'Honezovice', 112, 115, 41.4, 40.0);
INSERT INTO obce VALUES (1978, 'CZ0324', 'Horní Lukavice', 193, 201, 41.7, 41.3);
INSERT INTO obce VALUES (1979, 'CZ0324', 'Horšice', 224, 208, 37.6, 39.9);
INSERT INTO obce VALUES (1980, 'CZ0324', 'Hradec', 265, 250, 37.8, 40.7);
INSERT INTO obce VALUES (1981, 'CZ0324', 'Hradiště', 154, 112, 38.0, 43.4);
INSERT INTO obce VALUES (1982, 'CZ0324', 'Chlum', 105, 106, 39.3, 42.4);
INSERT INTO obce VALUES (1983, 'CZ0324', 'Chlumčany', 1193, 1229, 38.2, 40.6);
INSERT INTO obce VALUES (1984, 'CZ0324', 'Chlumy', 125, 58, 45.7, 48.7);
INSERT INTO obce VALUES (1985, 'CZ0324', 'Chocenice', 294, 273, 40.7, 40.0);
INSERT INTO obce VALUES (1986, 'CZ0324', 'Chotěšov', 1369, 1393, 40.3, 42.6);
INSERT INTO obce VALUES (1987, 'CZ0324', 'Jarov', 125, 110, 42.3, 49.3);
INSERT INTO obce VALUES (1988, 'CZ0324', 'Kasejovice', 671, 640, 41.1, 44.7);
INSERT INTO obce VALUES (1989, 'CZ0324', 'Kbel', 147, 146, 43.5, 47.5);
INSERT INTO obce VALUES (1990, 'CZ0324', 'Klášter', 93, 77, 42.5, 43.9);
INSERT INTO obce VALUES (1991, 'CZ0324', 'Kotovice', 144, 146, 40.0, 39.0);
INSERT INTO obce VALUES (1992, 'CZ0324', 'Kozlovice', 44, 43, 38.6, 43.1);
INSERT INTO obce VALUES (1993, 'CZ0324', 'Kramolín', 54, 61, 43.4, 41.6);
INSERT INTO obce VALUES (1994, 'CZ0324', 'Letiny', 306, 310, 39.4, 40.9);
INSERT INTO obce VALUES (1995, 'CZ0324', 'Lisov', 48, 61, 41.6, 43.8);
INSERT INTO obce VALUES (1996, 'CZ0324', 'Líšina', 87, 72, 42.3, 47.3);
INSERT INTO obce VALUES (1997, 'CZ0324', 'Louňová', 30, 25, 46.7, 55.7);
INSERT INTO obce VALUES (1998, 'CZ0324', 'Lužany', 325, 325, 40.9, 42.8);
INSERT INTO obce VALUES (1999, 'CZ0324', 'Měcholupy', 104, 104, 40.2, 41.5);
INSERT INTO obce VALUES (2000, 'CZ0324', 'Merklín', 600, 573, 38.4, 39.7);
INSERT INTO obce VALUES (2001, 'CZ0324', 'Mileč', 198, 177, 41.5, 47.9);
INSERT INTO obce VALUES (2002, 'CZ0324', 'Milínov', 91, 98, 42.6, 43.5);
INSERT INTO obce VALUES (2003, 'CZ0324', 'Míšov', 45, 60, 42.0, 46.7);
INSERT INTO obce VALUES (2004, 'CZ0324', 'Mladý Smolivec', 360, 360, 41.9, 43.2);
INSERT INTO obce VALUES (2005, 'CZ0324', 'Mohelnice', 35, 33, 40.5, 49.2);
INSERT INTO obce VALUES (2006, 'CZ0324', 'Nebílovy', 164, 168, 40.6, 44.5);
INSERT INTO obce VALUES (2007, 'CZ0324', 'Nekvasovy', 95, 92, 43.4, 44.2);
INSERT INTO obce VALUES (2008, 'CZ0324', 'Nepomuk', 1930, 1864, 37.8, 40.5);
INSERT INTO obce VALUES (2009, 'CZ0324', 'Netunice', 94, 95, 39.5, 40.9);
INSERT INTO obce VALUES (2010, 'CZ0324', 'Neurazy', 485, 404, 42.2, 45.4);
INSERT INTO obce VALUES (2011, 'CZ0324', 'Nezdice', 85, 116, 43.7, 40.2);
INSERT INTO obce VALUES (2012, 'CZ0324', 'Nezdřev', 66, 52, 44.4, 44.6);
INSERT INTO obce VALUES (2013, 'CZ0324', 'Nová Ves', 121, 130, 34.4, 37.8);
INSERT INTO obce VALUES (2014, 'CZ0324', 'Nové Mitrovice', 168, 147, 40.8, 42.6);
INSERT INTO obce VALUES (2015, 'CZ0324', 'Oplot', 179, 165, 38.1, 42.3);
INSERT INTO obce VALUES (2016, 'CZ0324', 'Oselce', 174, 178, 42.3, 48.5);
INSERT INTO obce VALUES (2017, 'CZ0324', 'Otěšice', 78, 74, 42.9, 47.6);
INSERT INTO obce VALUES (2018, 'CZ0324', 'Polánka', 23, 23, 42.5, 49.6);
INSERT INTO obce VALUES (2019, 'CZ0324', 'Prádlo', 164, 112, 43.5, 47.2);
INSERT INTO obce VALUES (2020, 'CZ0324', 'Předenice', 96, 107, 41.6, 40.8);
INSERT INTO obce VALUES (2021, 'CZ0324', 'Přestavlky', 118, 97, 42.1, 46.4);
INSERT INTO obce VALUES (2022, 'CZ0324', 'Přeštice', 3539, 3509, 39.2, 41.6);
INSERT INTO obce VALUES (2023, 'CZ0324', 'Příchovice', 522, 519, 38.0, 41.2);
INSERT INTO obce VALUES (2024, 'CZ0324', 'Ptenín', 104, 117, 43.9, 43.3);
INSERT INTO obce VALUES (2025, 'CZ0324', 'Radkovice', 52, 42, 40.8, 49.9);
INSERT INTO obce VALUES (2026, 'CZ0324', 'Roupov', 128, 122, 43.4, 46.6);
INSERT INTO obce VALUES (2027, 'CZ0324', 'Řenče', 469, 446, 40.9, 40.5);
INSERT INTO obce VALUES (2028, 'CZ0324', 'Seč', 134, 147, 41.2, 39.9);
INSERT INTO obce VALUES (2029, 'CZ0324', 'Sedliště', 58, 49, 45.8, 50.8);
INSERT INTO obce VALUES (2030, 'CZ0324', 'Skašov', 118, 121, 41.0, 45.6);
INSERT INTO obce VALUES (2031, 'CZ0324', 'Soběkury', 314, 304, 39.8, 42.3);
INSERT INTO obce VALUES (2032, 'CZ0324', 'Spálené Poříčí', 1366, 1349, 39.4, 41.7);
INSERT INTO obce VALUES (2033, 'CZ0324', 'Srby', 87, 87, 45.9, 48.5);
INSERT INTO obce VALUES (2034, 'CZ0324', 'Stod', 1894, 1757, 40.8, 44.1);
INSERT INTO obce VALUES (2035, 'CZ0324', 'Střelice', 69, 78, 36.5, 35.3);
INSERT INTO obce VALUES (2036, 'CZ0324', 'Střížovice', 179, 175, 41.2, 41.3);
INSERT INTO obce VALUES (2037, 'CZ0324', 'Štěnovice', 865, 885, 37.7, 39.8);
INSERT INTO obce VALUES (2038, 'CZ0324', 'Tojice', 43, 42, 38.5, 48.5);
INSERT INTO obce VALUES (2039, 'CZ0324', 'Třebčice', 59, 39, 36.4, 42.4);
INSERT INTO obce VALUES (2040, 'CZ0324', 'Týniště', 27, 25, 45.6, 42.9);
INSERT INTO obce VALUES (2041, 'CZ0324', 'Únětice', 66, 66, 35.2, 47.1);
INSERT INTO obce VALUES (2042, 'CZ0324', 'Útušice', 314, 308, 40.7, 39.6);
INSERT INTO obce VALUES (2043, 'CZ0324', 'Ves Touškov', 174, 169, 39.3, 41.5);
INSERT INTO obce VALUES (2044, 'CZ0324', 'Vlčí', 34, 39, 42.6, 43.1);
INSERT INTO obce VALUES (2045, 'CZ0324', 'Vlčtejn', 53, 39, 38.7, 51.0);
INSERT INTO obce VALUES (2046, 'CZ0324', 'Vrčeň', 166, 166, 37.0, 41.2);
INSERT INTO obce VALUES (2047, 'CZ0324', 'Vstiš', 240, 204, 38.6, 39.9);
INSERT INTO obce VALUES (2048, 'CZ0324', 'Zdemyslice', 274, 251, 41.4, 41.1);
INSERT INTO obce VALUES (2049, 'CZ0324', 'Zemětice', 132, 124, 45.3, 49.2);
INSERT INTO obce VALUES (2050, 'CZ0324', 'Žákava', 212, 184, 37.5, 40.6);
INSERT INTO obce VALUES (2051, 'CZ0324', 'Ždírec', 236, 225, 39.8, 44.4);
INSERT INTO obce VALUES (2052, 'CZ0324', 'Žinkovy', 432, 474, 43.8, 47.8);
INSERT INTO obce VALUES (2053, 'CZ0324', 'Životice', 24, 29, 50.8, 61.8);
INSERT INTO obce VALUES (2054, 'CZ0325', 'Bdeněves', 299, 287, 36.1, 41.2);
INSERT INTO obce VALUES (2055, 'CZ0325', 'Bezvěrov', 351, 325, 39.1, 39.6);
INSERT INTO obce VALUES (2056, 'CZ0325', 'Bílov', 44, 38, 43.6, 46.1);
INSERT INTO obce VALUES (2057, 'CZ0325', 'Blatnice', 392, 362, 38.5, 41.3);
INSERT INTO obce VALUES (2058, 'CZ0325', 'Blažim', 32, 30, 34.0, 40.9);
INSERT INTO obce VALUES (2059, 'CZ0325', 'Bohy', 45, 45, 42.6, 48.7);
INSERT INTO obce VALUES (2060, 'CZ0325', 'Brodeslavy', 37, 35, 43.5, 49.6);
INSERT INTO obce VALUES (2061, 'CZ0325', 'Bučí', 77, 78, 37.7, 40.8);
INSERT INTO obce VALUES (2062, 'CZ0325', 'Čeminy', 130, 124, 42.2, 42.3);
INSERT INTO obce VALUES (2063, 'CZ0325', 'Černíkovice', 34, 44, 38.9, 42.9);
INSERT INTO obce VALUES (2064, 'CZ0325', 'Čerňovice', 60, 68, 43.1, 40.0);
INSERT INTO obce VALUES (2065, 'CZ0325', 'Česká Bříza', 248, 271, 40.8, 42.1);
INSERT INTO obce VALUES (2066, 'CZ0325', 'Dobříč', 196, 195, 42.1, 44.9);
INSERT INTO obce VALUES (2067, 'CZ0325', 'Dolany', 137, 131, 38.9, 45.9);
INSERT INTO obce VALUES (2068, 'CZ0325', 'Dolní Bělá', 214, 223, 40.1, 43.2);
INSERT INTO obce VALUES (2069, 'CZ0325', 'Dolní Hradiště', 22, 22, 46.2, 48.3);
INSERT INTO obce VALUES (2070, 'CZ0325', 'Dražeň', 73, 79, 39.7, 37.4);
INSERT INTO obce VALUES (2071, 'CZ0325', 'Druztová', 341, 356, 38.4, 41.9);
INSERT INTO obce VALUES (2072, 'CZ0325', 'Heřmanova Huť', 891, 912, 40.0, 40.6);
INSERT INTO obce VALUES (2073, 'CZ0325', 'Hlince', 38, 29, 35.1, 45.1);
INSERT INTO obce VALUES (2074, 'CZ0325', 'Hněvnice', 48, 52, 39.3, 40.3);
INSERT INTO obce VALUES (2075, 'CZ0325', 'Holovousy', 27, 31, 46.1, 46.5);
INSERT INTO obce VALUES (2076, 'CZ0325', 'Horní Bělá', 297, 285, 39.5, 44.9);
INSERT INTO obce VALUES (2077, 'CZ0325', 'Horní Bříza', 2195, 2298, 38.1, 42.3);
INSERT INTO obce VALUES (2078, 'CZ0325', 'Hromnice', 561, 551, 40.6, 42.9);
INSERT INTO obce VALUES (2079, 'CZ0325', 'Hvozd', 119, 123, 38.8, 41.8);
INSERT INTO obce VALUES (2080, 'CZ0325', 'Chotíkov', 503, 494, 37.4, 40.2);
INSERT INTO obce VALUES (2081, 'CZ0325', 'Chříč', 103, 85, 38.4, 42.5);
INSERT INTO obce VALUES (2082, 'CZ0325', 'Jarov', 62, 67, 43.0, 44.6);
INSERT INTO obce VALUES (2083, 'CZ0325', 'Kaceřov', 62, 54, 39.9, 35.9);
INSERT INTO obce VALUES (2084, 'CZ0325', 'Kaznějov', 1532, 1643, 38.5, 40.3);
INSERT INTO obce VALUES (2085, 'CZ0325', 'Kbelany', 38, 48, 39.0, 40.0);
INSERT INTO obce VALUES (2086, 'CZ0325', 'Kočín', 66, 55, 40.5, 39.1);
INSERT INTO obce VALUES (2087, 'CZ0325', 'Kopidlo', 66, 55, 41.8, 50.0);
INSERT INTO obce VALUES (2088, 'CZ0325', 'Koryta', 70, 65, 38.4, 38.3);
INSERT INTO obce VALUES (2089, 'CZ0325', 'Kozojedy', 313, 319, 41.3, 44.0);
INSERT INTO obce VALUES (2090, 'CZ0325', 'Kozolupy', 496, 464, 39.7, 43.3);
INSERT INTO obce VALUES (2091, 'CZ0325', 'Kožlany', 720, 690, 39.0, 42.8);
INSERT INTO obce VALUES (2092, 'CZ0325', 'Kralovice', 1743, 1785, 38.4, 40.9);
INSERT INTO obce VALUES (2093, 'CZ0325', 'Krašovice', 185, 183, 43.1, 46.8);
INSERT INTO obce VALUES (2094, 'CZ0325', 'Krsy', 111, 106, 41.3, 41.9);
INSERT INTO obce VALUES (2095, 'CZ0325', 'Křelovice', 116, 115, 38.8, 40.8);
INSERT INTO obce VALUES (2096, 'CZ0325', 'Kunějovice', 63, 66, 36.5, 38.0);
INSERT INTO obce VALUES (2097, 'CZ0325', 'Ledce', 365, 369, 40.0, 41.1);
INSERT INTO obce VALUES (2098, 'CZ0325', 'Líně', 1192, 1227, 39.4, 40.6);
INSERT INTO obce VALUES (2099, 'CZ0325', 'Líšťany', 327, 360, 38.1, 37.7);
INSERT INTO obce VALUES (2100, 'CZ0325', 'Líté', 100, 99, 41.3, 46.2);
INSERT INTO obce VALUES (2101, 'CZ0325', 'Lochousice', 64, 56, 36.6, 40.4);
INSERT INTO obce VALUES (2102, 'CZ0325', 'Loza', 143, 126, 39.8, 42.3);
INSERT INTO obce VALUES (2103, 'CZ0325', 'Manětín', 574, 602, 41.1, 42.7);
INSERT INTO obce VALUES (2104, 'CZ0325', 'Město Touškov', 1003, 1045, 37.1, 39.5);
INSERT INTO obce VALUES (2105, 'CZ0325', 'Mladotice', 286, 270, 39.1, 42.8);
INSERT INTO obce VALUES (2106, 'CZ0325', 'Mrtník', 142, 169, 41.2, 39.0);
INSERT INTO obce VALUES (2107, 'CZ0325', 'Myslinka', 87, 72, 36.3, 37.8);
INSERT INTO obce VALUES (2108, 'CZ0325', 'Nadryby', 54, 53, 34.9, 38.3);
INSERT INTO obce VALUES (2109, 'CZ0325', 'Nečtiny', 324, 314, 41.8, 44.3);
INSERT INTO obce VALUES (2110, 'CZ0325', 'Nekmíř', 223, 219, 41.0, 42.1);
INSERT INTO obce VALUES (2111, 'CZ0325', 'Nevřeň', 128, 107, 36.7, 36.5);
INSERT INTO obce VALUES (2112, 'CZ0325', 'Nýřany', 3509, 3552, 38.7, 40.2);
INSERT INTO obce VALUES (2113, 'CZ0325', 'Obora', 242, 219, 41.3, 44.6);
INSERT INTO obce VALUES (2114, 'CZ0325', 'Ostrov u Bezdružic', 90, 103, 37.9, 44.0);
INSERT INTO obce VALUES (2115, 'CZ0325', 'Pastuchovice', 36, 39, 50.3, 46.8);
INSERT INTO obce VALUES (2116, 'CZ0325', 'Pernarec', 369, 393, 37.2, 38.0);
INSERT INTO obce VALUES (2117, 'CZ0325', 'Pláně', 141, 122, 41.2, 44.6);
INSERT INTO obce VALUES (2118, 'CZ0325', 'Plasy', 1342, 1319, 40.3, 42.8);
INSERT INTO obce VALUES (2119, 'CZ0325', 'Plešnice', 123, 130, 35.0, 37.7);
INSERT INTO obce VALUES (2120, 'CZ0325', 'Pňovany', 191, 195, 40.3, 45.1);
INSERT INTO obce VALUES (2121, 'CZ0325', 'Potvorov', 70, 72, 43.3, 40.5);
INSERT INTO obce VALUES (2122, 'CZ0325', 'Přehýšov', 269, 338, 39.4, 41.1);
INSERT INTO obce VALUES (2123, 'CZ0325', 'Příšov', 140, 150, 38.6, 38.7);
INSERT INTO obce VALUES (2124, 'CZ0325', 'Rochlov', 117, 130, 40.4, 36.8);
INSERT INTO obce VALUES (2125, 'CZ0325', 'Rybnice', 233, 256, 39.2, 38.7);
INSERT INTO obce VALUES (2126, 'CZ0325', 'Sedlec', 39, 36, 41.4, 41.3);
INSERT INTO obce VALUES (2127, 'CZ0325', 'Slatina', 41, 32, 46.8, 48.3);
INSERT INTO obce VALUES (2128, 'CZ0325', 'Studená', 22, 20, 44.8, 55.8);
INSERT INTO obce VALUES (2129, 'CZ0325', 'Štichovice', 64, 62, 39.7, 41.8);
INSERT INTO obce VALUES (2130, 'CZ0325', 'Tatiná', 114, 118, 40.0, 41.4);
INSERT INTO obce VALUES (2131, 'CZ0325', 'Tis u Blatna', 54, 42, 42.9, 40.3);
INSERT INTO obce VALUES (2132, 'CZ0325', 'Tlučná', 1439, 1488, 37.1, 39.4);
INSERT INTO obce VALUES (2133, 'CZ0325', 'Trnová', 406, 412, 40.8, 43.0);
INSERT INTO obce VALUES (2134, 'CZ0325', 'Třemošná', 2422, 2432, 40.1, 42.5);
INSERT INTO obce VALUES (2135, 'CZ0325', 'Úherce', 130, 135, 37.7, 38.0);
INSERT INTO obce VALUES (2136, 'CZ0325', 'Újezd nade Mží', 43, 39, 42.0, 44.1);
INSERT INTO obce VALUES (2137, 'CZ0325', 'Úlice', 193, 217, 42.2, 40.6);
INSERT INTO obce VALUES (2138, 'CZ0325', 'Úněšov', 296, 284, 39.4, 41.5);
INSERT INTO obce VALUES (2139, 'CZ0325', 'Úterý', 227, 239, 37.9, 37.6);
INSERT INTO obce VALUES (2140, 'CZ0325', 'Vejprnice', 1675, 1762, 36.5, 37.3);
INSERT INTO obce VALUES (2141, 'CZ0325', 'Velečín', 34, 37, 49.0, 51.2);
INSERT INTO obce VALUES (2142, 'CZ0325', 'Vochov', 305, 344, 39.1, 41.1);
INSERT INTO obce VALUES (2143, 'CZ0325', 'Všehrdy', 28, 28, 34.1, 38.2);
INSERT INTO obce VALUES (2144, 'CZ0325', 'Všeruby', 578, 574, 34.8, 37.2);
INSERT INTO obce VALUES (2145, 'CZ0325', 'Výrov', 243, 207, 38.2, 43.1);
INSERT INTO obce VALUES (2146, 'CZ0325', 'Vysoká Libyně', 124, 122, 37.2, 40.6);
INSERT INTO obce VALUES (2147, 'CZ0325', 'Zahrádka', 75, 60, 42.9, 42.8);
INSERT INTO obce VALUES (2148, 'CZ0325', 'Zbůch', 1099, 1072, 37.8, 40.2);
INSERT INTO obce VALUES (2149, 'CZ0325', 'Zruč-Senec', 1449, 1499, 39.6, 40.9);
INSERT INTO obce VALUES (2150, 'CZ0325', 'Žihle', 752, 721, 37.6, 41.9);
INSERT INTO obce VALUES (2151, 'CZ0325', 'Žilov', 210, 215, 38.2, 40.6);
INSERT INTO obce VALUES (2152, 'CZ0326', 'Bezděkov', 55, 59, 40.7, 42.0);
INSERT INTO obce VALUES (2153, 'CZ0326', 'Břasy', 1085, 1099, 41.6, 44.2);
INSERT INTO obce VALUES (2154, 'CZ0326', 'Březina', 164, 157, 43.0, 44.3);
INSERT INTO obce VALUES (2155, 'CZ0326', 'Bujesily', 28, 32, 44.1, 50.1);
INSERT INTO obce VALUES (2156, 'CZ0326', 'Bušovice', 277, 244, 40.6, 44.5);
INSERT INTO obce VALUES (2157, 'CZ0326', 'Cekov', 67, 52, 41.8, 39.4);
INSERT INTO obce VALUES (2158, 'CZ0326', 'Čilá', 8, 14, 46.6, 65.9);
INSERT INTO obce VALUES (2159, 'CZ0326', 'Dobřív', 594, 595, 40.3, 43.2);
INSERT INTO obce VALUES (2160, 'CZ0326', 'Drahoňův Újezd', 77, 64, 43.2, 45.3);
INSERT INTO obce VALUES (2161, 'CZ0326', 'Ejpovice', 310, 300, 37.3, 40.1);
INSERT INTO obce VALUES (2162, 'CZ0326', 'Hlohovice', 153, 182, 43.0, 44.3);
INSERT INTO obce VALUES (2163, 'CZ0326', 'Holoubkov', 696, 752, 40.2, 41.5);
INSERT INTO obce VALUES (2164, 'CZ0326', 'Hrádek', 1544, 1459, 39.9, 42.6);
INSERT INTO obce VALUES (2165, 'CZ0326', 'Hradiště', 15, 10, 53.5, 51.2);
INSERT INTO obce VALUES (2166, 'CZ0326', 'Hůrky', 114, 114, 43.5, 42.3);
INSERT INTO obce VALUES (2167, 'CZ0326', 'Cheznovice', 388, 363, 39.8, 42.9);
INSERT INTO obce VALUES (2168, 'CZ0326', 'Chlum', 27, 25, 45.7, 50.7);
INSERT INTO obce VALUES (2169, 'CZ0326', 'Chomle', 38, 32, 48.3, 49.8);
INSERT INTO obce VALUES (2170, 'CZ0326', 'Kakejcov', 41, 42, 43.2, 39.2);
INSERT INTO obce VALUES (2171, 'CZ0326', 'Kamenec', 27, 27, 38.4, 38.0);
INSERT INTO obce VALUES (2172, 'CZ0326', 'Kamenný Újezd', 324, 344, 41.8, 43.0);
INSERT INTO obce VALUES (2173, 'CZ0326', 'Kařez', 320, 319, 39.6, 42.9);
INSERT INTO obce VALUES (2174, 'CZ0326', 'Kařízek', 22, 28, 41.1, 39.4);
INSERT INTO obce VALUES (2175, 'CZ0326', 'Klabava', 219, 232, 44.6, 45.8);
INSERT INTO obce VALUES (2176, 'CZ0326', 'Kladruby', 80, 71, 45.0, 42.3);
INSERT INTO obce VALUES (2177, 'CZ0326', 'Kornatice', 75, 73, 41.8, 39.2);
INSERT INTO obce VALUES (2178, 'CZ0326', 'Lhota pod Radčem', 153, 161, 37.5, 36.6);
INSERT INTO obce VALUES (2179, 'CZ0326', 'Lhotka u Radnic', 38, 34, 39.9, 44.5);
INSERT INTO obce VALUES (2180, 'CZ0326', 'Liblín', 141, 143, 49.8, 59.6);
INSERT INTO obce VALUES (2181, 'CZ0326', 'Líšná', 83, 79, 41.2, 45.3);
INSERT INTO obce VALUES (2182, 'CZ0326', 'Litohlavy', 258, 249, 41.4, 43.2);
INSERT INTO obce VALUES (2183, 'CZ0326', 'Medový Újezd', 102, 125, 43.8, 47.3);
INSERT INTO obce VALUES (2184, 'CZ0326', 'Mešno', 48, 45, 39.4, 39.9);
INSERT INTO obce VALUES (2185, 'CZ0326', 'Mirošov', 1096, 1122, 41.3, 47.1);
INSERT INTO obce VALUES (2186, 'CZ0326', 'Mlečice', 142, 146, 41.6, 45.0);
INSERT INTO obce VALUES (2187, 'CZ0326', 'Mýto', 752, 731, 41.3, 42.9);
INSERT INTO obce VALUES (2188, 'CZ0326', 'Němčovice', 61, 61, 36.1, 34.4);
INSERT INTO obce VALUES (2189, 'CZ0326', 'Nevid', 82, 87, 41.5, 38.8);
INSERT INTO obce VALUES (2190, 'CZ0326', 'Osek', 686, 639, 37.7, 40.3);
INSERT INTO obce VALUES (2191, 'CZ0326', 'Ostrovec-Lhotka', 46, 56, 44.1, 43.8);
INSERT INTO obce VALUES (2192, 'CZ0326', 'Plískov', 63, 56, 42.7, 52.8);
INSERT INTO obce VALUES (2193, 'CZ0326', 'Podmokly', 144, 133, 40.1, 43.0);
INSERT INTO obce VALUES (2194, 'CZ0326', 'Příkosice', 186, 192, 40.6, 40.6);
INSERT INTO obce VALUES (2195, 'CZ0326', 'Přívětice', 104, 87, 41.2, 46.9);
INSERT INTO obce VALUES (2196, 'CZ0326', 'Radnice', 888, 867, 39.8, 43.1);
INSERT INTO obce VALUES (2197, 'CZ0326', 'Raková', 96, 106, 39.9, 38.7);
INSERT INTO obce VALUES (2198, 'CZ0326', 'Rokycany', 6946, 7140, 39.7, 42.8);
INSERT INTO obce VALUES (2199, 'CZ0326', 'Sebečice', 35, 30, 52.0, 50.4);
INSERT INTO obce VALUES (2200, 'CZ0326', 'Sirá', 59, 61, 35.5, 42.0);
INSERT INTO obce VALUES (2201, 'CZ0326', 'Skomelno', 95, 87, 42.8, 44.9);
INSERT INTO obce VALUES (2202, 'CZ0326', 'Skořice', 130, 113, 39.4, 43.4);
INSERT INTO obce VALUES (2203, 'CZ0326', 'Smědčice', 107, 128, 35.2, 36.2);
INSERT INTO obce VALUES (2204, 'CZ0326', 'Strašice', 1242, 1194, 37.6, 40.9);
INSERT INTO obce VALUES (2205, 'CZ0326', 'Svojkovice', 194, 195, 40.4, 41.9);
INSERT INTO obce VALUES (2206, 'CZ0326', 'Štítov', 41, 27, 36.5, 37.9);
INSERT INTO obce VALUES (2207, 'CZ0326', 'Těně', 113, 119, 43.2, 42.7);
INSERT INTO obce VALUES (2208, 'CZ0326', 'Terešov', 51, 66, 43.9, 45.0);
INSERT INTO obce VALUES (2209, 'CZ0326', 'Těškov', 135, 163, 44.1, 43.2);
INSERT INTO obce VALUES (2210, 'CZ0326', 'Trokavec', 40, 47, 44.9, 45.1);
INSERT INTO obce VALUES (2211, 'CZ0326', 'Týček', 95, 104, 40.8, 46.0);
INSERT INTO obce VALUES (2212, 'CZ0326', 'Újezd u Svatého Kříže', 128, 112, 43.2, 44.2);
INSERT INTO obce VALUES (2213, 'CZ0326', 'Vejvanov', 107, 126, 40.0, 41.7);
INSERT INTO obce VALUES (2214, 'CZ0326', 'Veselá', 130, 124, 35.5, 39.9);
INSERT INTO obce VALUES (2215, 'CZ0326', 'Vísky', 18, 25, 31.8, 38.2);
INSERT INTO obce VALUES (2216, 'CZ0326', 'Volduchy', 517, 553, 40.3, 42.9);
INSERT INTO obce VALUES (2217, 'CZ0326', 'Všenice', 120, 129, 41.6, 39.5);
INSERT INTO obce VALUES (2218, 'CZ0326', 'Zbiroh', 1260, 1346, 38.7, 40.0);
INSERT INTO obce VALUES (2219, 'CZ0326', 'Zvíkovec', 64, 117, 42.6, 37.3);
INSERT INTO obce VALUES (2220, 'CZ0327', 'Benešovice', 79, 92, 41.0, 42.9);
INSERT INTO obce VALUES (2221, 'CZ0327', 'Bezdružice', 499, 481, 37.0, 40.5);
INSERT INTO obce VALUES (2222, 'CZ0327', 'Bor', 2201, 2177, 36.7, 38.8);
INSERT INTO obce VALUES (2223, 'CZ0327', 'Brod nad Tichou', 122, 116, 36.6, 39.1);
INSERT INTO obce VALUES (2224, 'CZ0327', 'Broumov', 60, 50, 39.1, 40.1);
INSERT INTO obce VALUES (2225, 'CZ0327', 'Cebiv', 148, 126, 35.4, 39.4);
INSERT INTO obce VALUES (2226, 'CZ0327', 'Ctiboř', 166, 173, 37.7, 39.6);
INSERT INTO obce VALUES (2227, 'CZ0327', 'Částkov', 176, 172, 38.7, 39.9);
INSERT INTO obce VALUES (2228, 'CZ0327', 'Černošín', 608, 604, 39.0, 40.6);
INSERT INTO obce VALUES (2229, 'CZ0327', 'Dlouhý Újezd', 182, 171, 35.1, 37.7);
INSERT INTO obce VALUES (2230, 'CZ0327', 'Erpužice', 182, 174, 36.3, 38.7);
INSERT INTO obce VALUES (2231, 'CZ0327', 'Halže', 500, 478, 36.6, 36.4);
INSERT INTO obce VALUES (2232, 'CZ0327', 'Horní Kozolupy', 129, 123, 40.1, 45.7);
INSERT INTO obce VALUES (2233, 'CZ0327', 'Hošťka', 255, 206, 35.1, 37.6);
INSERT INTO obce VALUES (2234, 'CZ0327', 'Chodová Planá', 939, 901, 38.1, 38.6);
INSERT INTO obce VALUES (2235, 'CZ0327', 'Chodský Újezd', 393, 384, 38.8, 38.7);
INSERT INTO obce VALUES (2236, 'CZ0327', 'Kladruby', 773, 707, 36.5, 40.3);
INSERT INTO obce VALUES (2237, 'CZ0327', 'Kočov', 90, 103, 36.8, 37.8);
INSERT INTO obce VALUES (2238, 'CZ0327', 'Kokašice', 126, 133, 36.7, 38.9);
INSERT INTO obce VALUES (2239, 'CZ0327', 'Konstantinovy Lázně', 447, 488, 42.4, 44.7);
INSERT INTO obce VALUES (2240, 'CZ0327', 'Kostelec', 287, 255, 36.7, 37.9);
INSERT INTO obce VALUES (2241, 'CZ0327', 'Kšice', 103, 91, 39.5, 41.0);
INSERT INTO obce VALUES (2242, 'CZ0327', 'Lesná', 270, 225, 37.3, 39.0);
INSERT INTO obce VALUES (2243, 'CZ0327', 'Lestkov', 211, 175, 36.6, 42.5);
INSERT INTO obce VALUES (2244, 'CZ0327', 'Lom u Tachova', 206, 212, 35.4, 35.4);
INSERT INTO obce VALUES (2245, 'CZ0327', 'Milíře', 123, 100, 34.1, 32.7);
INSERT INTO obce VALUES (2246, 'CZ0327', 'Obora', 64, 43, 45.1, 41.2);
INSERT INTO obce VALUES (2247, 'CZ0327', 'Olbramov', 45, 28, 38.9, 43.1);
INSERT INTO obce VALUES (2248, 'CZ0327', 'Ošelín', 54, 54, 42.3, 35.7);
INSERT INTO obce VALUES (2249, 'CZ0327', 'Planá', 2745, 2843, 38.2, 40.9);
INSERT INTO obce VALUES (2250, 'CZ0327', 'Prostiboř', 78, 69, 42.3, 43.7);
INSERT INTO obce VALUES (2251, 'CZ0327', 'Přimda', 817, 712, 36.0, 37.4);
INSERT INTO obce VALUES (2252, 'CZ0327', 'Rozvadov', 430, 378, 35.5, 37.2);
INSERT INTO obce VALUES (2253, 'CZ0327', 'Skapce', 54, 53, 37.1, 40.2);
INSERT INTO obce VALUES (2254, 'CZ0327', 'Staré Sedliště', 594, 551, 35.2, 36.6);
INSERT INTO obce VALUES (2255, 'CZ0327', 'Staré Sedlo', 128, 117, 40.7, 40.7);
INSERT INTO obce VALUES (2256, 'CZ0327', 'Stráž', 572, 529, 36.9, 40.6);
INSERT INTO obce VALUES (2257, 'CZ0327', 'Stříbro', 3988, 4012, 38.5, 41.0);
INSERT INTO obce VALUES (2258, 'CZ0327', 'Studánka', 237, 220, 36.5, 38.2);
INSERT INTO obce VALUES (2259, 'CZ0327', 'Sulislav', 101, 87, 39.4, 40.5);
INSERT INTO obce VALUES (2260, 'CZ0327', 'Svojšín', 201, 227, 39.2, 36.8);
INSERT INTO obce VALUES (2261, 'CZ0327', 'Sytno', 173, 145, 36.1, 37.8);
INSERT INTO obce VALUES (2262, 'CZ0327', 'Tachov', 6053, 6423, 38.8, 41.4);
INSERT INTO obce VALUES (2263, 'CZ0327', 'Tisová', 257, 218, 37.6, 39.3);
INSERT INTO obce VALUES (2264, 'CZ0327', 'Trpísty', 144, 109, 39.9, 45.1);
INSERT INTO obce VALUES (2265, 'CZ0327', 'Třemešné', 197, 170, 38.3, 42.4);
INSERT INTO obce VALUES (2266, 'CZ0327', 'Únehle', 60, 58, 30.3, 40.4);
INSERT INTO obce VALUES (2267, 'CZ0327', 'Vranov', 75, 64, 40.3, 44.9);
INSERT INTO obce VALUES (2268, 'CZ0327', 'Zadní Chodov', 151, 133, 38.3, 40.4);
INSERT INTO obce VALUES (2269, 'CZ0327', 'Záchlumí', 205, 222, 35.2, 35.3);
INSERT INTO obce VALUES (2270, 'CZ0327', 'Zhoř', 74, 71, 35.2, 37.3);
INSERT INTO obce VALUES (2271, 'CZ0411', 'Aš', 6555, 6857, 37.1, 40.2);
INSERT INTO obce VALUES (2272, 'CZ0411', 'Dolní Žandov', 616, 595, 37.5, 39.8);
INSERT INTO obce VALUES (2273, 'CZ0411', 'Drmoul', 413, 459, 38.4, 39.7);
INSERT INTO obce VALUES (2274, 'CZ0411', 'Františkovy Lázně', 2645, 2961, 39.3, 42.6);
INSERT INTO obce VALUES (2275, 'CZ0411', 'Hazlov', 838, 816, 38.5, 40.1);
INSERT INTO obce VALUES (2276, 'CZ0411', 'Hranice', 1060, 1140, 39.7, 41.8);
INSERT INTO obce VALUES (2277, 'CZ0411', 'Cheb', 17094, 17532, 37.6, 40.5);
INSERT INTO obce VALUES (2278, 'CZ0411', 'Krásná', 261, 243, 37.7, 38.4);
INSERT INTO obce VALUES (2279, 'CZ0411', 'Křižovatka', 145, 142, 37.6, 39.9);
INSERT INTO obce VALUES (2280, 'CZ0411', 'Lázně Kynžvart', 763, 793, 38.4, 43.8);
INSERT INTO obce VALUES (2281, 'CZ0411', 'Libá', 360, 355, 37.9, 40.7);
INSERT INTO obce VALUES (2282, 'CZ0411', 'Lipová', 347, 347, 39.0, 39.1);
INSERT INTO obce VALUES (2283, 'CZ0411', 'Luby', 1217, 1219, 39.2, 41.5);
INSERT INTO obce VALUES (2284, 'CZ0411', 'Mariánské Lázně', 6407, 7270, 41.1, 45.0);
INSERT INTO obce VALUES (2285, 'CZ0411', 'Milhostov', 179, 168, 37.0, 34.9);
INSERT INTO obce VALUES (2286, 'CZ0411', 'Milíkov', 122, 116, 39.3, 42.1);
INSERT INTO obce VALUES (2287, 'CZ0411', 'Mnichov', 171, 227, 39.6, 41.2);
INSERT INTO obce VALUES (2288, 'CZ0411', 'Nebanice', 167, 174, 37.5, 36.9);
INSERT INTO obce VALUES (2289, 'CZ0411', 'Nový Kostel', 290, 281, 38.5, 39.5);
INSERT INTO obce VALUES (2290, 'CZ0411', 'Odrava', 110, 113, 39.4, 37.8);
INSERT INTO obce VALUES (2291, 'CZ0411', 'Okrouhlá', 128, 121, 37.3, 39.6);
INSERT INTO obce VALUES (2292, 'CZ0411', 'Ovesné Kladruby', 52, 60, 37.9, 37.7);
INSERT INTO obce VALUES (2293, 'CZ0411', 'Plesná', 1045, 1052, 37.5, 39.8);
INSERT INTO obce VALUES (2294, 'CZ0411', 'Podhradí', 88, 91, 38.1, 40.5);
INSERT INTO obce VALUES (2295, 'CZ0411', 'Pomezí nad Ohří', 73, 67, 37.0, 35.1);
INSERT INTO obce VALUES (2296, 'CZ0411', 'Poustka', 71, 85, 37.3, 33.9);
INSERT INTO obce VALUES (2297, 'CZ0411', 'Prameny', 79, 67, 35.8, 38.2);
INSERT INTO obce VALUES (2298, 'CZ0411', 'Skalná', 962, 980, 38.0, 40.2);
INSERT INTO obce VALUES (2299, 'CZ0411', 'Stará Voda', 263, 226, 36.7, 36.6);
INSERT INTO obce VALUES (2300, 'CZ0411', 'Teplá', 1554, 1533, 37.0, 39.9);
INSERT INTO obce VALUES (2301, 'CZ0411', 'Trstěnice', 182, 169, 38.3, 40.2);
INSERT INTO obce VALUES (2302, 'CZ0411', 'Třebeň', 219, 198, 36.6, 37.6);
INSERT INTO obce VALUES (2303, 'CZ0411', 'Tři Sekery', 449, 420, 38.4, 39.9);
INSERT INTO obce VALUES (2304, 'CZ0411', 'Tuřany', 54, 60, 41.7, 40.8);
INSERT INTO obce VALUES (2305, 'CZ0411', 'Valy', 194, 202, 40.1, 41.9);
INSERT INTO obce VALUES (3605, 'CZ0532', 'Sopřeč', 139, 135, 39.4, 43.0);
INSERT INTO obce VALUES (2306, 'CZ0411', 'Velká Hleďsebe', 1102, 1100, 39.7, 41.3);
INSERT INTO obce VALUES (2307, 'CZ0411', 'Velký Luh', 88, 62, 40.3, 41.6);
INSERT INTO obce VALUES (2308, 'CZ0411', 'Vlkovice', 57, 64, 41.5, 43.2);
INSERT INTO obce VALUES (2309, 'CZ0411', 'Vojtanov', 117, 89, 40.7, 41.7);
INSERT INTO obce VALUES (2310, 'CZ0411', 'Zádub-Závišín', 172, 138, 40.4, 44.6);
INSERT INTO obce VALUES (2311, 'CZ0412', 'Abertamy', 697, 642, 35.9, 36.5);
INSERT INTO obce VALUES (2312, 'CZ0412', 'Andělská Hora', 126, 123, 43.4, 39.9);
INSERT INTO obce VALUES (2313, 'CZ0412', 'Bečov nad Teplou', 523, 480, 39.4, 44.1);
INSERT INTO obce VALUES (2314, 'CZ0412', 'Bochov', 1028, 1032, 37.6, 38.0);
INSERT INTO obce VALUES (2315, 'CZ0412', 'Boží Dar', 95, 93, 37.2, 38.0);
INSERT INTO obce VALUES (2316, 'CZ0412', 'Božičany', 314, 302, 38.8, 37.2);
INSERT INTO obce VALUES (2317, 'CZ0412', 'Březová', 270, 286, 42.0, 42.2);
INSERT INTO obce VALUES (2318, 'CZ0412', 'Černava', 153, 141, 42.9, 38.8);
INSERT INTO obce VALUES (2319, 'CZ0412', 'Čichalov', 71, 84, 37.8, 45.6);
INSERT INTO obce VALUES (2320, 'CZ0412', 'Dalovice', 937, 956, 40.5, 41.9);
INSERT INTO obce VALUES (2321, 'CZ0412', 'Děpoltovice', 173, 162, 42.2, 41.4);
INSERT INTO obce VALUES (2322, 'CZ0412', 'Hájek', 263, 220, 36.8, 39.9);
INSERT INTO obce VALUES (2323, 'CZ0412', 'Horní Blatná', 387, 286, 31.7, 33.4);
INSERT INTO obce VALUES (2324, 'CZ0412', 'Hory', 122, 102, 34.6, 42.0);
INSERT INTO obce VALUES (2325, 'CZ0412', 'Hradiště', 336, 270, 33.6, 39.3);
INSERT INTO obce VALUES (2326, 'CZ0412', 'Hroznětín', 977, 954, 36.9, 38.7);
INSERT INTO obce VALUES (2327, 'CZ0412', 'Chodov', 92, 67, 28.7, 24.1);
INSERT INTO obce VALUES (2328, 'CZ0412', 'Chyše', 316, 292, 40.2, 41.8);
INSERT INTO obce VALUES (2329, 'CZ0412', 'Jáchymov', 1563, 1631, 34.8, 39.2);
INSERT INTO obce VALUES (2330, 'CZ0412', 'Jenišov', 379, 378, 34.8, 36.5);
INSERT INTO obce VALUES (2331, 'CZ0412', 'Karlovy Vary', 24581, 26739, 41.1, 44.5);
INSERT INTO obce VALUES (2332, 'CZ0412', 'Kolová', 367, 325, 38.4, 39.3);
INSERT INTO obce VALUES (2333, 'CZ0412', 'Krásné Údolí', 233, 198, 37.4, 42.1);
INSERT INTO obce VALUES (2334, 'CZ0412', 'Krásný Les', 132, 130, 37.9, 38.4);
INSERT INTO obce VALUES (2335, 'CZ0412', 'Kyselka', 410, 394, 38.2, 38.8);
INSERT INTO obce VALUES (2336, 'CZ0412', 'Merklín', 556, 554, 37.1, 38.4);
INSERT INTO obce VALUES (2337, 'CZ0412', 'Mírová', 145, 138, 38.9, 38.8);
INSERT INTO obce VALUES (2338, 'CZ0412', 'Nejdek', 4131, 4287, 38.4, 41.6);
INSERT INTO obce VALUES (2339, 'CZ0412', 'Nová Role', 2024, 2135, 40.4, 42.6);
INSERT INTO obce VALUES (2340, 'CZ0412', 'Nové Hamry', 171, 156, 40.5, 42.9);
INSERT INTO obce VALUES (2341, 'CZ0412', 'Ostrov', 8377, 8853, 39.3, 42.1);
INSERT INTO obce VALUES (2342, 'CZ0412', 'Otovice', 294, 311, 41.5, 41.4);
INSERT INTO obce VALUES (2343, 'CZ0412', 'Otročín', 273, 252, 36.7, 41.5);
INSERT INTO obce VALUES (2344, 'CZ0412', 'Pernink', 331, 391, 31.9, 38.9);
INSERT INTO obce VALUES (2345, 'CZ0412', 'Pila', 228, 227, 38.8, 42.6);
INSERT INTO obce VALUES (2346, 'CZ0412', 'Potůčky', 209, 219, 34.5, 38.2);
INSERT INTO obce VALUES (2347, 'CZ0412', 'Pšov', 302, 288, 40.9, 43.8);
INSERT INTO obce VALUES (2348, 'CZ0412', 'Sadov', 567, 614, 39.1, 38.2);
INSERT INTO obce VALUES (2349, 'CZ0412', 'Smolné Pece', 63, 66, 39.6, 44.7);
INSERT INTO obce VALUES (2350, 'CZ0412', 'Stanovice', 294, 252, 37.2, 40.4);
INSERT INTO obce VALUES (2351, 'CZ0412', 'Stráž nad Ohří', 316, 300, 39.1, 40.4);
INSERT INTO obce VALUES (2352, 'CZ0412', 'Stružná', 285, 234, 38.5, 40.9);
INSERT INTO obce VALUES (2353, 'CZ0412', 'Šemnice', 288, 295, 36.7, 38.9);
INSERT INTO obce VALUES (2354, 'CZ0412', 'Štědrá', 288, 263, 40.3, 41.3);
INSERT INTO obce VALUES (2355, 'CZ0412', 'Teplička', 50, 47, 41.5, 40.6);
INSERT INTO obce VALUES (2356, 'CZ0412', 'Toužim', 1940, 1923, 38.0, 40.4);
INSERT INTO obce VALUES (2357, 'CZ0412', 'Útvina', 288, 306, 38.0, 38.0);
INSERT INTO obce VALUES (2358, 'CZ0412', 'Valeč', 197, 184, 40.3, 43.0);
INSERT INTO obce VALUES (2359, 'CZ0412', 'Velichov', 272, 267, 38.0, 39.9);
INSERT INTO obce VALUES (2360, 'CZ0412', 'Verušičky', 172, 190, 35.7, 37.6);
INSERT INTO obce VALUES (2361, 'CZ0412', 'Vojkovice', 340, 301, 38.6, 40.5);
INSERT INTO obce VALUES (2362, 'CZ0412', 'Vrbice', 93, 87, 35.5, 41.7);
INSERT INTO obce VALUES (2363, 'CZ0412', 'Vysoká Pec', 135, 197, 37.4, 43.1);
INSERT INTO obce VALUES (2364, 'CZ0412', 'Žlutice', 1294, 1340, 38.2, 40.4);
INSERT INTO obce VALUES (2365, 'CZ0413', 'Březová', 1375, 1366, 39.4, 44.0);
INSERT INTO obce VALUES (2366, 'CZ0413', 'Bublava', 160, 163, 42.2, 44.2);
INSERT INTO obce VALUES (2367, 'CZ0413', 'Bukovany', 846, 860, 36.6, 38.9);
INSERT INTO obce VALUES (2368, 'CZ0413', 'Citice', 428, 456, 37.3, 39.4);
INSERT INTO obce VALUES (2369, 'CZ0413', 'Dasnice', 195, 179, 35.4, 38.0);
INSERT INTO obce VALUES (2370, 'CZ0413', 'Dolní Nivy', 158, 164, 37.0, 38.7);
INSERT INTO obce VALUES (2371, 'CZ0413', 'Dolní Rychnov', 752, 730, 34.8, 36.6);
INSERT INTO obce VALUES (2372, 'CZ0413', 'Habartov', 2607, 2631, 38.3, 40.5);
INSERT INTO obce VALUES (2373, 'CZ0413', 'Horní Slavkov', 2832, 2822, 37.6, 40.4);
INSERT INTO obce VALUES (2374, 'CZ0413', 'Chlum Svaté Maří', 146, 151, 40.3, 42.2);
INSERT INTO obce VALUES (2375, 'CZ0413', 'Chodov', 6945, 7199, 37.8, 40.3);
INSERT INTO obce VALUES (2376, 'CZ0413', 'Jindřichovice', 279, 234, 40.4, 42.5);
INSERT INTO obce VALUES (2377, 'CZ0413', 'Josefov', 178, 154, 39.3, 43.0);
INSERT INTO obce VALUES (2378, 'CZ0413', 'Kaceřov', 230, 208, 37.9, 41.1);
INSERT INTO obce VALUES (2379, 'CZ0413', 'Krajková', 433, 457, 39.0, 39.3);
INSERT INTO obce VALUES (2380, 'CZ0413', 'Královské Poříčí', 427, 435, 35.9, 37.9);
INSERT INTO obce VALUES (2381, 'CZ0413', 'Kraslice', 3479, 3595, 39.6, 42.1);
INSERT INTO obce VALUES (2382, 'CZ0413', 'Krásno', 369, 357, 37.8, 40.0);
INSERT INTO obce VALUES (2383, 'CZ0413', 'Kynšperk nad Ohří', 2415, 2621, 39.0, 41.5);
INSERT INTO obce VALUES (2384, 'CZ0413', 'Libavské Údolí', 274, 313, 39.3, 40.4);
INSERT INTO obce VALUES (2385, 'CZ0413', 'Loket', 1577, 1614, 35.5, 37.9);
INSERT INTO obce VALUES (2386, 'CZ0413', 'Lomnice', 597, 595, 35.9, 39.5);
INSERT INTO obce VALUES (2387, 'CZ0413', 'Nová Ves', 148, 142, 35.5, 31.9);
INSERT INTO obce VALUES (2388, 'CZ0413', 'Nové Sedlo', 1392, 1321, 37.4, 39.2);
INSERT INTO obce VALUES (2389, 'CZ0413', 'Oloví', 959, 966, 36.7, 39.9);
INSERT INTO obce VALUES (2390, 'CZ0413', 'Přebuz', 38, 36, 48.9, 51.3);
INSERT INTO obce VALUES (2391, 'CZ0413', 'Rotava', 1690, 1778, 36.1, 38.1);
INSERT INTO obce VALUES (2392, 'CZ0413', 'Rovná', 283, 289, 32.0, 36.6);
INSERT INTO obce VALUES (2393, 'CZ0413', 'Sokolov', 11872, 12510, 38.4, 41.5);
INSERT INTO obce VALUES (2394, 'CZ0413', 'Staré Sedlo', 444, 392, 39.0, 41.5);
INSERT INTO obce VALUES (2395, 'CZ0413', 'Stříbrná', 229, 200, 42.4, 43.9);
INSERT INTO obce VALUES (2396, 'CZ0413', 'Svatava', 758, 844, 37.8, 41.7);
INSERT INTO obce VALUES (2397, 'CZ0413', 'Šabina', 152, 161, 39.8, 41.6);
INSERT INTO obce VALUES (2398, 'CZ0413', 'Šindelová', 140, 129, 44.6, 43.9);
INSERT INTO obce VALUES (2399, 'CZ0413', 'Tatrovice', 92, 78, 40.5, 37.7);
INSERT INTO obce VALUES (2400, 'CZ0413', 'Těšovice', 73, 82, 43.3, 42.2);
INSERT INTO obce VALUES (2401, 'CZ0413', 'Vintířov', 603, 581, 34.8, 34.7);
INSERT INTO obce VALUES (2402, 'CZ0413', 'Vřesová', 304, 211, 36.4, 31.0);
INSERT INTO obce VALUES (2403, 'CZ0421', 'Arnoltice', 170, 158, 38.2, 39.5);
INSERT INTO obce VALUES (2404, 'CZ0421', 'Benešov nad Ploučnicí', 2024, 1967, 38.0, 41.4);
INSERT INTO obce VALUES (2405, 'CZ0421', 'Bynovec', 146, 136, 38.0, 36.6);
INSERT INTO obce VALUES (2406, 'CZ0421', 'Česká Kamenice', 2775, 2758, 38.3, 41.8);
INSERT INTO obce VALUES (2407, 'CZ0421', 'Děčín', 25605, 26655, 38.9, 41.8);
INSERT INTO obce VALUES (2408, 'CZ0421', 'Dobkovice', 376, 319, 38.6, 38.6);
INSERT INTO obce VALUES (2409, 'CZ0421', 'Dobrná', 243, 217, 38.0, 38.6);
INSERT INTO obce VALUES (2410, 'CZ0421', 'Dolní Habartice', 292, 280, 38.0, 43.0);
INSERT INTO obce VALUES (2411, 'CZ0421', 'Dolní Podluží', 604, 598, 39.4, 39.8);
INSERT INTO obce VALUES (2412, 'CZ0421', 'Dolní Poustevna', 1038, 988, 35.2, 37.5);
INSERT INTO obce VALUES (2413, 'CZ0421', 'Doubice', 55, 50, 43.0, 44.5);
INSERT INTO obce VALUES (2414, 'CZ0421', 'Františkov nad Ploučnicí', 179, 189, 41.8, 45.2);
INSERT INTO obce VALUES (2415, 'CZ0421', 'Heřmanov', 265, 243, 37.4, 39.7);
INSERT INTO obce VALUES (2416, 'CZ0421', 'Horní Habartice', 205, 204, 40.5, 44.5);
INSERT INTO obce VALUES (2417, 'CZ0421', 'Horní Podluží', 398, 380, 37.3, 38.8);
INSERT INTO obce VALUES (2418, 'CZ0421', 'Hřensko', 203, 121, 36.6, 36.3);
INSERT INTO obce VALUES (2419, 'CZ0421', 'Huntířov', 410, 372, 37.7, 38.6);
INSERT INTO obce VALUES (2420, 'CZ0421', 'Chřibská', 743, 747, 36.8, 38.1);
INSERT INTO obce VALUES (2421, 'CZ0421', 'Janov', 149, 162, 44.4, 48.6);
INSERT INTO obce VALUES (2422, 'CZ0421', 'Janská', 114, 97, 35.8, 39.5);
INSERT INTO obce VALUES (2423, 'CZ0421', 'Jetřichovice', 226, 192, 42.8, 43.8);
INSERT INTO obce VALUES (2424, 'CZ0421', 'Jílové', 2622, 2632, 37.9, 41.0);
INSERT INTO obce VALUES (2425, 'CZ0421', 'Jiřetín pod Jedlovou', 299, 299, 38.3, 42.8);
INSERT INTO obce VALUES (2426, 'CZ0421', 'Jiříkov', 2044, 2003, 37.4, 40.8);
INSERT INTO obce VALUES (2427, 'CZ0421', 'Kámen', 104, 93, 37.7, 44.9);
INSERT INTO obce VALUES (2428, 'CZ0421', 'Krásná Lípa', 1854, 1895, 37.6, 41.7);
INSERT INTO obce VALUES (2429, 'CZ0421', 'Kunratice', 136, 133, 36.1, 36.1);
INSERT INTO obce VALUES (2430, 'CZ0421', 'Kytlice', 269, 208, 44.4, 45.1);
INSERT INTO obce VALUES (2431, 'CZ0421', 'Labská Stráň', 110, 93, 40.7, 44.0);
INSERT INTO obce VALUES (2432, 'CZ0421', 'Lipová', 320, 313, 37.0, 42.0);
INSERT INTO obce VALUES (2433, 'CZ0421', 'Lobendava', 185, 166, 40.7, 40.3);
INSERT INTO obce VALUES (2434, 'CZ0421', 'Ludvíkovice', 432, 437, 37.2, 39.1);
INSERT INTO obce VALUES (2435, 'CZ0421', 'Malá Veleň', 229, 226, 38.3, 40.8);
INSERT INTO obce VALUES (2436, 'CZ0421', 'Malšovice', 424, 410, 37.0, 37.8);
INSERT INTO obce VALUES (2437, 'CZ0421', 'Markvartice', 332, 317, 38.3, 40.3);
INSERT INTO obce VALUES (2438, 'CZ0421', 'Merboltice', 86, 74, 36.4, 41.1);
INSERT INTO obce VALUES (2439, 'CZ0421', 'Mikulášovice', 1129, 1157, 39.7, 42.5);
INSERT INTO obce VALUES (2440, 'CZ0421', 'Rumburk', 5613, 5807, 37.8, 40.5);
INSERT INTO obce VALUES (2441, 'CZ0421', 'Růžová', 211, 198, 40.0, 41.8);
INSERT INTO obce VALUES (2442, 'CZ0421', 'Rybniště', 359, 370, 38.6, 39.6);
INSERT INTO obce VALUES (2443, 'CZ0421', 'Srbská Kamenice', 104, 101, 44.6, 46.9);
INSERT INTO obce VALUES (2444, 'CZ0421', 'Staré Křečany', 662, 637, 38.5, 40.1);
INSERT INTO obce VALUES (2445, 'CZ0421', 'Starý Šachov', 107, 110, 38.6, 38.0);
INSERT INTO obce VALUES (2446, 'CZ0421', 'Šluknov', 2792, 2884, 37.8, 40.6);
INSERT INTO obce VALUES (2447, 'CZ0421', 'Těchlovice', 297, 265, 36.9, 39.1);
INSERT INTO obce VALUES (2448, 'CZ0421', 'Valkeřice', 212, 205, 39.8, 39.7);
INSERT INTO obce VALUES (2449, 'CZ0421', 'Varnsdorf', 7674, 8180, 38.1, 41.6);
INSERT INTO obce VALUES (2450, 'CZ0421', 'Velká Bukovina', 231, 210, 40.2, 42.5);
INSERT INTO obce VALUES (2451, 'CZ0421', 'Velký Šenov', 1027, 1024, 38.5, 41.9);
INSERT INTO obce VALUES (2452, 'CZ0421', 'Verneřice', 590, 541, 36.3, 40.3);
INSERT INTO obce VALUES (2453, 'CZ0421', 'Veselé', 157, 146, 38.1, 43.7);
INSERT INTO obce VALUES (2454, 'CZ0421', 'Vilémov', 470, 472, 39.2, 44.5);
INSERT INTO obce VALUES (2455, 'CZ0422', 'Bílence', 124, 124, 37.3, 38.6);
INSERT INTO obce VALUES (2456, 'CZ0422', 'Blatno', 197, 188, 42.0, 41.6);
INSERT INTO obce VALUES (2457, 'CZ0422', 'Boleboř', 128, 104, 39.1, 39.6);
INSERT INTO obce VALUES (2458, 'CZ0422', 'Březno', 643, 630, 37.2, 39.2);
INSERT INTO obce VALUES (2459, 'CZ0422', 'Černovice', 261, 262, 40.4, 40.2);
INSERT INTO obce VALUES (2460, 'CZ0422', 'Domašín', 62, 49, 41.3, 33.8);
INSERT INTO obce VALUES (2461, 'CZ0422', 'Droužkovice', 355, 362, 38.3, 39.1);
INSERT INTO obce VALUES (2462, 'CZ0422', 'Hora Svatého Šebestiána', 138, 123, 37.5, 38.9);
INSERT INTO obce VALUES (2463, 'CZ0422', 'Hrušovany', 244, 250, 33.4, 33.6);
INSERT INTO obce VALUES (2464, 'CZ0422', 'Chbany', 294, 318, 37.6, 37.1);
INSERT INTO obce VALUES (2465, 'CZ0422', 'Chomutov', 24323, 25472, 38.7, 41.7);
INSERT INTO obce VALUES (2466, 'CZ0422', 'Jirkov', 10230, 10693, 35.3, 38.0);
INSERT INTO obce VALUES (2467, 'CZ0422', 'Kadaň', 8750, 9214, 37.7, 41.0);
INSERT INTO obce VALUES (2468, 'CZ0422', 'Kalek', 118, 95, 41.8, 45.0);
INSERT INTO obce VALUES (2469, 'CZ0422', 'Klášterec nad Ohří', 7675, 7887, 37.0, 39.8);
INSERT INTO obce VALUES (2470, 'CZ0422', 'Kovářská', 643, 578, 38.9, 41.6);
INSERT INTO obce VALUES (2471, 'CZ0422', 'Kryštofovy Hamry', 34, 37, 55.0, 52.0);
INSERT INTO obce VALUES (2472, 'CZ0422', 'Křimov', 191, 144, 34.9, 32.2);
INSERT INTO obce VALUES (2473, 'CZ0422', 'Libědice', 123, 116, 40.1, 39.6);
INSERT INTO obce VALUES (2474, 'CZ0422', 'Loučná pod Klínovcem', 53, 37, 49.4, 47.3);
INSERT INTO obce VALUES (2475, 'CZ0422', 'Málkov', 334, 325, 38.5, 38.4);
INSERT INTO obce VALUES (2476, 'CZ0422', 'Mašťov', 308, 324, 39.5, 43.3);
INSERT INTO obce VALUES (2477, 'CZ0422', 'Měděnec', 85, 66, 44.1, 43.7);
INSERT INTO obce VALUES (2478, 'CZ0422', 'Místo', 189, 164, 40.1, 42.9);
INSERT INTO obce VALUES (2479, 'CZ0422', 'Nezabylice', 95, 107, 38.5, 37.4);
INSERT INTO obce VALUES (2480, 'CZ0422', 'Okounov', 173, 156, 40.3, 38.3);
INSERT INTO obce VALUES (2481, 'CZ0422', 'Otvice', 303, 309, 39.9, 39.3);
INSERT INTO obce VALUES (2482, 'CZ0422', 'Perštejn', 563, 532, 39.3, 41.6);
INSERT INTO obce VALUES (2483, 'CZ0422', 'Pesvice', 54, 46, 41.4, 41.6);
INSERT INTO obce VALUES (2484, 'CZ0422', 'Pětipsy', 111, 97, 36.7, 39.0);
INSERT INTO obce VALUES (2485, 'CZ0422', 'Račetice', 190, 172, 35.3, 37.8);
INSERT INTO obce VALUES (2486, 'CZ0422', 'Radonice', 619, 587, 37.1, 38.8);
INSERT INTO obce VALUES (2487, 'CZ0422', 'Rokle', 166, 125, 37.8, 35.7);
INSERT INTO obce VALUES (2488, 'CZ0422', 'Spořice', 592, 624, 36.5, 37.7);
INSERT INTO obce VALUES (2489, 'CZ0422', 'Strupčice', 361, 355, 38.1, 38.3);
INSERT INTO obce VALUES (2490, 'CZ0422', 'Údlice', 570, 534, 40.2, 41.6);
INSERT INTO obce VALUES (2491, 'CZ0422', 'Vejprty', 1697, 1602, 38.5, 40.9);
INSERT INTO obce VALUES (2492, 'CZ0422', 'Veliká Ves', 150, 147, 40.8, 38.9);
INSERT INTO obce VALUES (2493, 'CZ0422', 'Vilémov', 289, 309, 39.6, 40.7);
INSERT INTO obce VALUES (2494, 'CZ0422', 'Vrskmaň', 123, 122, 39.7, 42.7);
INSERT INTO obce VALUES (2495, 'CZ0422', 'Všehrdy', 64, 41, 38.9, 43.3);
INSERT INTO obce VALUES (2496, 'CZ0422', 'Všestudy', 77, 97, 35.6, 35.0);
INSERT INTO obce VALUES (2497, 'CZ0422', 'Výsluní', 156, 110, 39.4, 39.9);
INSERT INTO obce VALUES (2498, 'CZ0422', 'Vysoká Pec', 493, 456, 40.2, 41.1);
INSERT INTO obce VALUES (2499, 'CZ0423', 'Bechlín', 615, 624, 38.4, 40.9);
INSERT INTO obce VALUES (2500, 'CZ0423', 'Bohušovice nad Ohří', 1211, 1329, 38.4, 39.9);
INSERT INTO obce VALUES (2501, 'CZ0423', 'Brňany', 206, 227, 40.3, 38.6);
INSERT INTO obce VALUES (2502, 'CZ0423', 'Brozany nad Ohří', 560, 623, 38.9, 40.0);
INSERT INTO obce VALUES (2503, 'CZ0423', 'Brzánky', 41, 43, 40.5, 43.8);
INSERT INTO obce VALUES (2504, 'CZ0423', 'Bříza', 202, 203, 35.6, 37.5);
INSERT INTO obce VALUES (2505, 'CZ0423', 'Budyně nad Ohří', 1049, 1081, 39.0, 42.1);
INSERT INTO obce VALUES (2506, 'CZ0423', 'Býčkovice', 187, 145, 38.0, 40.4);
INSERT INTO obce VALUES (2507, 'CZ0423', 'Ctiněves', 151, 156, 39.6, 43.0);
INSERT INTO obce VALUES (2508, 'CZ0423', 'Černěves', 103, 109, 35.8, 40.2);
INSERT INTO obce VALUES (2509, 'CZ0423', 'Černiv', 78, 72, 35.8, 42.5);
INSERT INTO obce VALUES (2510, 'CZ0423', 'Černouček', 149, 127, 38.2, 41.2);
INSERT INTO obce VALUES (2511, 'CZ0423', 'Čížkovice', 697, 699, 36.3, 39.4);
INSERT INTO obce VALUES (2512, 'CZ0423', 'Děčany', 183, 176, 41.1, 43.0);
INSERT INTO obce VALUES (2513, 'CZ0423', 'Dlažkovice', 55, 54, 42.9, 45.3);
INSERT INTO obce VALUES (2514, 'CZ0423', 'Dobříň', 293, 286, 38.6, 40.4);
INSERT INTO obce VALUES (2515, 'CZ0423', 'Doksany', 184, 209, 42.2, 41.7);
INSERT INTO obce VALUES (2516, 'CZ0423', 'Dolánky nad Ohří', 142, 119, 41.4, 43.2);
INSERT INTO obce VALUES (2517, 'CZ0423', 'Drahobuz', 122, 132, 37.7, 41.5);
INSERT INTO obce VALUES (2518, 'CZ0423', 'Dušníky', 194, 171, 33.5, 38.3);
INSERT INTO obce VALUES (2519, 'CZ0423', 'Evaň', 157, 140, 40.1, 47.0);
INSERT INTO obce VALUES (2520, 'CZ0423', 'Hlinná', 120, 115, 40.6, 39.2);
INSERT INTO obce VALUES (2521, 'CZ0423', 'Horní Beřkovice', 424, 479, 41.2, 42.4);
INSERT INTO obce VALUES (2522, 'CZ0423', 'Horní Řepčice', 49, 63, 42.1, 41.5);
INSERT INTO obce VALUES (2523, 'CZ0423', 'Hoštka', 838, 847, 36.5, 37.5);
INSERT INTO obce VALUES (2524, 'CZ0423', 'Hrobce', 304, 291, 36.5, 41.7);
INSERT INTO obce VALUES (2525, 'CZ0423', 'Chodouny', 310, 328, 40.2, 42.2);
INSERT INTO obce VALUES (2526, 'CZ0423', 'Chodovlice', 80, 77, 39.5, 42.4);
INSERT INTO obce VALUES (2527, 'CZ0423', 'Chotěšov', 275, 213, 44.0, 42.7);
INSERT INTO obce VALUES (2528, 'CZ0423', 'Chotiměř', 146, 147, 36.2, 41.1);
INSERT INTO obce VALUES (2529, 'CZ0423', 'Chotiněves', 104, 101, 41.1, 43.5);
INSERT INTO obce VALUES (2530, 'CZ0423', 'Chudoslavice', 70, 63, 39.1, 39.7);
INSERT INTO obce VALUES (2531, 'CZ0423', 'Jenčice', 181, 179, 42.1, 42.4);
INSERT INTO obce VALUES (2532, 'CZ0423', 'Kamýk', 74, 69, 38.5, 39.3);
INSERT INTO obce VALUES (2533, 'CZ0423', 'Keblice', 187, 183, 40.7, 39.7);
INSERT INTO obce VALUES (2534, 'CZ0423', 'Klapý', 267, 255, 40.1, 44.1);
INSERT INTO obce VALUES (2535, 'CZ0423', 'Kleneč', 214, 232, 42.2, 43.1);
INSERT INTO obce VALUES (2536, 'CZ0423', 'Kostomlaty pod Řípem', 237, 217, 40.1, 42.2);
INSERT INTO obce VALUES (2537, 'CZ0423', 'Krabčice', 427, 462, 41.1, 44.3);
INSERT INTO obce VALUES (2538, 'CZ0423', 'Křesín', 170, 164, 37.7, 44.0);
INSERT INTO obce VALUES (2539, 'CZ0423', 'Křešice', 736, 704, 40.9, 42.3);
INSERT INTO obce VALUES (2540, 'CZ0423', 'Kyškovice', 143, 139, 39.8, 40.4);
INSERT INTO obce VALUES (2541, 'CZ0423', 'Levín', 70, 58, 43.2, 47.8);
INSERT INTO obce VALUES (2542, 'CZ0423', 'Lhotka nad Labem', 107, 138, 38.0, 41.9);
INSERT INTO obce VALUES (2543, 'CZ0423', 'Liběšice', 863, 699, 37.3, 41.1);
INSERT INTO obce VALUES (2544, 'CZ0423', 'Libkovice pod Řípem', 250, 277, 38.0, 40.3);
INSERT INTO obce VALUES (2545, 'CZ0423', 'Libochovany', 298, 282, 39.7, 42.1);
INSERT INTO obce VALUES (2546, 'CZ0423', 'Libochovice', 1725, 1862, 40.5, 43.9);
INSERT INTO obce VALUES (2547, 'CZ0423', 'Libotenice', 206, 219, 39.3, 41.5);
INSERT INTO obce VALUES (2548, 'CZ0423', 'Litoměřice', 11326, 12303, 38.7, 41.8);
INSERT INTO obce VALUES (2549, 'CZ0423', 'Lkáň', 83, 72, 38.2, 43.0);
INSERT INTO obce VALUES (2550, 'CZ0423', 'Lovečkovice', 253, 249, 40.6, 40.5);
INSERT INTO obce VALUES (2551, 'CZ0423', 'Lovosice', 4302, 4533, 39.5, 43.3);
INSERT INTO obce VALUES (2552, 'CZ0423', 'Lukavec', 195, 155, 37.2, 38.9);
INSERT INTO obce VALUES (2553, 'CZ0423', 'Malé Žernoseky', 322, 366, 38.9, 42.6);
INSERT INTO obce VALUES (2554, 'CZ0423', 'Malíč', 89, 69, 38.2, 39.1);
INSERT INTO obce VALUES (2555, 'CZ0423', 'Martiněves', 372, 366, 40.1, 42.7);
INSERT INTO obce VALUES (2556, 'CZ0423', 'Michalovice', 67, 77, 41.2, 42.6);
INSERT INTO obce VALUES (2557, 'CZ0423', 'Miřejovice', 106, 77, 38.7, 41.6);
INSERT INTO obce VALUES (2558, 'CZ0423', 'Mlékojedy', 95, 89, 35.3, 41.5);
INSERT INTO obce VALUES (2559, 'CZ0423', 'Mnetěš', 262, 260, 37.7, 41.2);
INSERT INTO obce VALUES (2560, 'CZ0423', 'Mšené-lázně', 877, 869, 38.3, 42.1);
INSERT INTO obce VALUES (2561, 'CZ0423', 'Nové Dvory', 204, 201, 39.2, 42.1);
INSERT INTO obce VALUES (2562, 'CZ0423', 'Oleško', 45, 42, 39.8, 47.1);
INSERT INTO obce VALUES (2563, 'CZ0423', 'Píšťany', 110, 96, 40.9, 43.5);
INSERT INTO obce VALUES (2564, 'CZ0423', 'Ploskovice', 217, 204, 39.8, 41.6);
INSERT INTO obce VALUES (2565, 'CZ0423', 'Podsedice', 320, 335, 40.8, 43.5);
INSERT INTO obce VALUES (2566, 'CZ0423', 'Polepy', 709, 662, 38.7, 39.7);
INSERT INTO obce VALUES (2567, 'CZ0423', 'Prackovice nad Labem', 314, 299, 39.5, 41.1);
INSERT INTO obce VALUES (2568, 'CZ0423', 'Přestavlky', 132, 137, 35.8, 37.6);
INSERT INTO obce VALUES (2569, 'CZ0423', 'Račice', 163, 159, 40.5, 41.4);
INSERT INTO obce VALUES (2570, 'CZ0423', 'Račiněves', 271, 257, 39.0, 41.8);
INSERT INTO obce VALUES (2571, 'CZ0423', 'Radovesice', 232, 218, 37.3, 43.8);
INSERT INTO obce VALUES (2572, 'CZ0423', 'Rochov', 56, 50, 42.2, 42.7);
INSERT INTO obce VALUES (2573, 'CZ0423', 'Roudnice nad Labem', 6468, 6761, 39.6, 43.4);
INSERT INTO obce VALUES (2574, 'CZ0423', 'Sedlec', 91, 99, 38.7, 40.0);
INSERT INTO obce VALUES (2575, 'CZ0423', 'Siřejovice', 140, 139, 41.5, 42.3);
INSERT INTO obce VALUES (2576, 'CZ0423', 'Slatina', 138, 126, 39.3, 41.2);
INSERT INTO obce VALUES (2577, 'CZ0423', 'Snědovice', 391, 340, 39.3, 42.0);
INSERT INTO obce VALUES (2578, 'CZ0423', 'Staňkovice', 15, 11, 48.6, 44.6);
INSERT INTO obce VALUES (2579, 'CZ0423', 'Straškov-Vodochody', 498, 544, 39.0, 39.8);
INSERT INTO obce VALUES (2580, 'CZ0423', 'Sulejovice', 389, 325, 39.4, 44.2);
INSERT INTO obce VALUES (2581, 'CZ0423', 'Štětí', 4596, 4629, 38.5, 40.7);
INSERT INTO obce VALUES (2582, 'CZ0423', 'Terezín', 1500, 1537, 39.5, 42.8);
INSERT INTO obce VALUES (2583, 'CZ0423', 'Travčice', 291, 286, 40.7, 41.9);
INSERT INTO obce VALUES (2584, 'CZ0423', 'Trnovany', 156, 165, 40.5, 40.3);
INSERT INTO obce VALUES (2585, 'CZ0423', 'Třebenice', 936, 882, 39.9, 43.4);
INSERT INTO obce VALUES (2586, 'CZ0423', 'Třebívlice', 418, 413, 41.1, 43.2);
INSERT INTO obce VALUES (2587, 'CZ0423', 'Třebušín', 276, 277, 40.3, 42.2);
INSERT INTO obce VALUES (2588, 'CZ0423', 'Úpohlavy', 118, 132, 36.9, 37.4);
INSERT INTO obce VALUES (2589, 'CZ0423', 'Úštěk', 1556, 1482, 38.6, 41.0);
INSERT INTO obce VALUES (2590, 'CZ0423', 'Vědomice', 442, 443, 38.8, 40.1);
INSERT INTO obce VALUES (2591, 'CZ0423', 'Velemín', 758, 737, 40.3, 41.8);
INSERT INTO obce VALUES (2592, 'CZ0423', 'Velké Žernoseky', 248, 226, 38.5, 42.5);
INSERT INTO obce VALUES (2593, 'CZ0423', 'Vchynice', 167, 152, 38.2, 40.7);
INSERT INTO obce VALUES (2594, 'CZ0423', 'Vlastislav', 65, 86, 40.4, 41.8);
INSERT INTO obce VALUES (2595, 'CZ0423', 'Vražkov', 214, 203, 38.1, 43.1);
INSERT INTO obce VALUES (2596, 'CZ0423', 'Vrbice', 253, 265, 35.3, 39.0);
INSERT INTO obce VALUES (2597, 'CZ0423', 'Vrbičany', 164, 173, 37.8, 39.2);
INSERT INTO obce VALUES (2598, 'CZ0423', 'Vrutice', 154, 143, 38.1, 41.5);
INSERT INTO obce VALUES (2599, 'CZ0423', 'Záluží', 66, 73, 38.3, 38.2);
INSERT INTO obce VALUES (2600, 'CZ0423', 'Žabovřesky nad Ohří', 114, 118, 38.9, 39.4);
INSERT INTO obce VALUES (2601, 'CZ0423', 'Žalhostice', 260, 268, 39.0, 43.9);
INSERT INTO obce VALUES (2602, 'CZ0423', 'Židovice', 184, 169, 39.3, 41.6);
INSERT INTO obce VALUES (2603, 'CZ0423', 'Žitenice', 796, 665, 37.6, 41.1);
INSERT INTO obce VALUES (2604, 'CZ0424', 'Bitozeves', 188, 204, 37.1, 37.0);
INSERT INTO obce VALUES (2605, 'CZ0424', 'Blatno', 246, 269, 40.2, 40.8);
INSERT INTO obce VALUES (2606, 'CZ0424', 'Blažim', 121, 138, 34.6, 33.2);
INSERT INTO obce VALUES (2607, 'CZ0424', 'Blšany', 509, 477, 39.0, 41.0);
INSERT INTO obce VALUES (2608, 'CZ0424', 'Blšany u Loun', 119, 125, 41.3, 40.5);
INSERT INTO obce VALUES (2609, 'CZ0424', 'Brodec', 38, 33, 46.8, 48.3);
INSERT INTO obce VALUES (2610, 'CZ0424', 'Břvany', 157, 162, 38.9, 39.5);
INSERT INTO obce VALUES (2611, 'CZ0424', 'Cítoliby', 501, 524, 37.1, 39.0);
INSERT INTO obce VALUES (2612, 'CZ0424', 'Čeradice', 149, 152, 36.6, 37.3);
INSERT INTO obce VALUES (2613, 'CZ0424', 'Černčice', 760, 734, 38.4, 40.4);
INSERT INTO obce VALUES (2614, 'CZ0424', 'Deštnice', 94, 93, 39.2, 41.7);
INSERT INTO obce VALUES (2615, 'CZ0424', 'Dobroměřice', 706, 679, 38.7, 39.4);
INSERT INTO obce VALUES (2616, 'CZ0424', 'Domoušice', 351, 326, 39.3, 44.1);
INSERT INTO obce VALUES (2617, 'CZ0424', 'Holedeč', 278, 264, 41.4, 44.3);
INSERT INTO obce VALUES (2618, 'CZ0424', 'Hříškov', 204, 207, 41.1, 42.5);
INSERT INTO obce VALUES (2619, 'CZ0424', 'Hřivice', 315, 305, 41.1, 42.6);
INSERT INTO obce VALUES (2620, 'CZ0424', 'Chlumčany', 245, 257, 40.4, 43.5);
INSERT INTO obce VALUES (2621, 'CZ0424', 'Chožov', 310, 288, 36.6, 42.5);
INSERT INTO obce VALUES (2622, 'CZ0424', 'Chraberce', 74, 72, 39.5, 45.0);
INSERT INTO obce VALUES (2623, 'CZ0424', 'Jimlín', 411, 402, 40.2, 42.3);
INSERT INTO obce VALUES (2624, 'CZ0424', 'Koštice', 316, 293, 42.0, 42.9);
INSERT INTO obce VALUES (2625, 'CZ0424', 'Kozly', 66, 59, 38.6, 40.5);
INSERT INTO obce VALUES (2626, 'CZ0424', 'Krásný Dvůr', 381, 373, 40.6, 42.7);
INSERT INTO obce VALUES (2627, 'CZ0424', 'Kryry', 1222, 1239, 38.4, 41.3);
INSERT INTO obce VALUES (2628, 'CZ0424', 'Lenešice', 700, 753, 38.3, 40.1);
INSERT INTO obce VALUES (2629, 'CZ0424', 'Libčeves', 492, 434, 37.6, 40.7);
INSERT INTO obce VALUES (2630, 'CZ0424', 'Liběšice', 375, 363, 38.3, 40.5);
INSERT INTO obce VALUES (2631, 'CZ0424', 'Libočany', 277, 263, 39.9, 38.9);
INSERT INTO obce VALUES (2632, 'CZ0424', 'Libořice', 177, 160, 39.6, 43.2);
INSERT INTO obce VALUES (2633, 'CZ0424', 'Lipno', 253, 282, 38.9, 38.5);
INSERT INTO obce VALUES (2634, 'CZ0424', 'Lišany', 85, 79, 37.8, 37.9);
INSERT INTO obce VALUES (2635, 'CZ0424', 'Líšťany', 223, 225, 41.2, 43.6);
INSERT INTO obce VALUES (2636, 'CZ0424', 'Louny', 9051, 9745, 38.3, 41.6);
INSERT INTO obce VALUES (2637, 'CZ0424', 'Lubenec', 768, 739, 40.7, 43.5);
INSERT INTO obce VALUES (2638, 'CZ0424', 'Měcholupy', 561, 477, 38.2, 41.7);
INSERT INTO obce VALUES (2639, 'CZ0424', 'Nepomyšl', 215, 191, 40.5, 42.5);
INSERT INTO obce VALUES (2640, 'CZ0424', 'Nová Ves', 45, 54, 45.6, 47.4);
INSERT INTO obce VALUES (2641, 'CZ0424', 'Nové Sedlo', 285, 277, 38.4, 38.9);
INSERT INTO obce VALUES (2642, 'CZ0424', 'Obora', 156, 199, 37.7, 39.2);
INSERT INTO obce VALUES (2643, 'CZ0424', 'Očihov', 189, 167, 38.3, 42.0);
INSERT INTO obce VALUES (2644, 'CZ0424', 'Opočno', 66, 57, 43.0, 46.2);
INSERT INTO obce VALUES (2645, 'CZ0424', 'Panenský Týnec', 208, 198, 39.6, 41.1);
INSERT INTO obce VALUES (2646, 'CZ0424', 'Peruc', 1078, 1087, 40.5, 43.6);
INSERT INTO obce VALUES (2647, 'CZ0424', 'Petrohrad', 339, 308, 41.0, 42.6);
INSERT INTO obce VALUES (2648, 'CZ0424', 'Pnětluky', 159, 172, 39.4, 42.3);
INSERT INTO obce VALUES (2649, 'CZ0424', 'Počedělice', 146, 147, 40.2, 41.6);
INSERT INTO obce VALUES (2650, 'CZ0424', 'Podbořanský Rohozec', 57, 69, 37.7, 40.2);
INSERT INTO obce VALUES (2651, 'CZ0424', 'Podbořany', 3124, 3273, 37.0, 40.6);
INSERT INTO obce VALUES (2652, 'CZ0424', 'Postoloprty', 2565, 2554, 35.7, 38.0);
INSERT INTO obce VALUES (2653, 'CZ0424', 'Raná', 123, 128, 39.4, 39.3);
INSERT INTO obce VALUES (2654, 'CZ0424', 'Ročov', 270, 278, 41.2, 42.3);
INSERT INTO obce VALUES (2655, 'CZ0424', 'Slavětín', 255, 222, 37.9, 39.9);
INSERT INTO obce VALUES (2656, 'CZ0424', 'Smolnice', 185, 216, 42.2, 43.8);
INSERT INTO obce VALUES (2657, 'CZ0424', 'Staňkovice', 449, 443, 36.2, 40.6);
INSERT INTO obce VALUES (2658, 'CZ0424', 'Toužetín', 154, 151, 37.6, 42.5);
INSERT INTO obce VALUES (2659, 'CZ0424', 'Tuchořice', 364, 341, 42.1, 40.2);
INSERT INTO obce VALUES (2660, 'CZ0424', 'Úherce', 35, 37, 39.8, 49.9);
INSERT INTO obce VALUES (2661, 'CZ0424', 'Velemyšleves', 164, 164, 37.4, 37.5);
INSERT INTO obce VALUES (2662, 'CZ0424', 'Veltěže', 196, 198, 38.2, 39.8);
INSERT INTO obce VALUES (2663, 'CZ0424', 'Vinařice', 129, 111, 42.3, 47.2);
INSERT INTO obce VALUES (2664, 'CZ0424', 'Vrbno nad Lesy', 85, 78, 38.8, 44.2);
INSERT INTO obce VALUES (2665, 'CZ0424', 'Vroutek', 1039, 963, 39.0, 42.5);
INSERT INTO obce VALUES (2666, 'CZ0424', 'Vršovice', 129, 135, 43.7, 45.2);
INSERT INTO obce VALUES (2667, 'CZ0424', 'Výškov', 249, 254, 35.2, 37.2);
INSERT INTO obce VALUES (2668, 'CZ0424', 'Zálužice', 38, 41, 39.9, 46.2);
INSERT INTO obce VALUES (2669, 'CZ0424', 'Zbrašín', 154, 148, 40.4, 45.0);
INSERT INTO obce VALUES (2670, 'CZ0424', 'Žatec', 9448, 9876, 38.1, 41.3);
INSERT INTO obce VALUES (2671, 'CZ0424', 'Želkovice', 39, 48, 38.9, 40.1);
INSERT INTO obce VALUES (2672, 'CZ0424', 'Žerotín', 84, 96, 41.0, 43.7);
INSERT INTO obce VALUES (2673, 'CZ0424', 'Žiželice', 234, 209, 38.5, 38.6);
INSERT INTO obce VALUES (2674, 'CZ0425', 'Bečov', 969, 934, 33.3, 36.5);
INSERT INTO obce VALUES (2675, 'CZ0425', 'Bělušice', 93, 107, 40.2, 42.5);
INSERT INTO obce VALUES (2676, 'CZ0425', 'Braňany', 612, 584, 36.9, 39.3);
INSERT INTO obce VALUES (2677, 'CZ0425', 'Brandov', 125, 118, 40.4, 40.8);
INSERT INTO obce VALUES (2678, 'CZ0425', 'Český Jiřetín', 38, 34, 47.4, 34.1);
INSERT INTO obce VALUES (2679, 'CZ0425', 'Havraň', 264, 259, 36.9, 39.9);
INSERT INTO obce VALUES (2680, 'CZ0425', 'Hora Svaté Kateřiny', 222, 211, 38.7, 36.7);
INSERT INTO obce VALUES (2681, 'CZ0425', 'Horní Jiřetín', 1066, 1020, 38.7, 41.5);
INSERT INTO obce VALUES (2682, 'CZ0425', 'Klíny', 56, 49, 44.7, 39.1);
INSERT INTO obce VALUES (2683, 'CZ0425', 'Korozluky', 79, 93, 37.1, 35.9);
INSERT INTO obce VALUES (2684, 'CZ0425', 'Lišnice', 102, 98, 40.3, 43.5);
INSERT INTO obce VALUES (2685, 'CZ0425', 'Litvínov', 13805, 13728, 39.2, 42.2);
INSERT INTO obce VALUES (2686, 'CZ0425', 'Lom', 1955, 1896, 37.5, 39.9);
INSERT INTO obce VALUES (2687, 'CZ0425', 'Louka u Litvínova', 384, 363, 35.7, 37.4);
INSERT INTO obce VALUES (2688, 'CZ0425', 'Lužice', 232, 218, 39.1, 42.6);
INSERT INTO obce VALUES (2689, 'CZ0425', 'Malé Březno', 121, 102, 34.0, 36.8);
INSERT INTO obce VALUES (2690, 'CZ0425', 'Mariánské Radčice', 233, 202, 34.5, 37.6);
INSERT INTO obce VALUES (2691, 'CZ0425', 'Meziboří', 2365, 2486, 41.0, 44.3);
INSERT INTO obce VALUES (2692, 'CZ0425', 'Most', 32893, 34625, 37.7, 41.2);
INSERT INTO obce VALUES (2693, 'CZ0425', 'Nová Ves v Horách', 218, 239, 41.2, 43.4);
INSERT INTO obce VALUES (2694, 'CZ0425', 'Obrnice', 1348, 1303, 31.4, 32.4);
INSERT INTO obce VALUES (2695, 'CZ0425', 'Patokryje', 191, 213, 41.0, 38.7);
INSERT INTO obce VALUES (2696, 'CZ0425', 'Polerady', 123, 112, 39.1, 40.6);
INSERT INTO obce VALUES (2697, 'CZ0425', 'Skršín', 118, 104, 40.3, 43.5);
INSERT INTO obce VALUES (2698, 'CZ0425', 'Volevčice', 43, 52, 39.6, 44.4);
INSERT INTO obce VALUES (2699, 'CZ0425', 'Želenice', 254, 215, 38.7, 41.1);
INSERT INTO obce VALUES (2700, 'CZ0426', 'Bílina', 7792, 8111, 37.1, 39.9);
INSERT INTO obce VALUES (2701, 'CZ0426', 'Bořislav', 178, 181, 42.0, 41.9);
INSERT INTO obce VALUES (2702, 'CZ0426', 'Bystřany', 907, 962, 40.4, 44.0);
INSERT INTO obce VALUES (2703, 'CZ0426', 'Bžany', 419, 394, 39.5, 43.0);
INSERT INTO obce VALUES (2704, 'CZ0426', 'Dubí', 4037, 4024, 38.8, 41.7);
INSERT INTO obce VALUES (2705, 'CZ0426', 'Duchcov', 4437, 4511, 37.5, 41.0);
INSERT INTO obce VALUES (2706, 'CZ0426', 'Háj u Duchcova', 539, 506, 37.0, 38.9);
INSERT INTO obce VALUES (2707, 'CZ0426', 'Hostomice', 636, 635, 35.9, 39.5);
INSERT INTO obce VALUES (2708, 'CZ0426', 'Hrob', 1059, 1014, 38.2, 41.8);
INSERT INTO obce VALUES (2709, 'CZ0426', 'Hrobčice', 485, 494, 38.8, 39.3);
INSERT INTO obce VALUES (2710, 'CZ0426', 'Jeníkov', 470, 474, 38.1, 40.2);
INSERT INTO obce VALUES (2711, 'CZ0426', 'Kladruby', 179, 153, 39.4, 37.8);
INSERT INTO obce VALUES (2712, 'CZ0426', 'Kostomlaty pod Milešovkou', 465, 432, 39.4, 41.9);
INSERT INTO obce VALUES (2713, 'CZ0426', 'Košťany', 1402, 1466, 38.0, 40.7);
INSERT INTO obce VALUES (2714, 'CZ0426', 'Krupka', 6879, 7102, 36.7, 39.1);
INSERT INTO obce VALUES (2715, 'CZ0426', 'Lahošť', 289, 293, 38.6, 41.5);
INSERT INTO obce VALUES (2716, 'CZ0426', 'Ledvice', 283, 281, 36.9, 37.2);
INSERT INTO obce VALUES (2717, 'CZ0426', 'Lukov', 73, 68, 44.1, 43.0);
INSERT INTO obce VALUES (2718, 'CZ0426', 'Měrunice', 158, 149, 40.0, 41.8);
INSERT INTO obce VALUES (2719, 'CZ0426', 'Mikulov', 94, 88, 38.3, 41.3);
INSERT INTO obce VALUES (2720, 'CZ0426', 'Modlany', 473, 445, 37.9, 38.7);
INSERT INTO obce VALUES (2721, 'CZ0426', 'Moldava', 161, 111, 34.2, 30.6);
INSERT INTO obce VALUES (2722, 'CZ0426', 'Novosedlice', 1152, 1142, 37.6, 40.2);
INSERT INTO obce VALUES (2723, 'CZ0426', 'Ohníč', 381, 402, 40.6, 39.5);
INSERT INTO obce VALUES (2724, 'CZ0426', 'Osek', 2503, 2532, 39.0, 41.4);
INSERT INTO obce VALUES (2725, 'CZ0426', 'Proboštov', 1296, 1303, 38.3, 41.4);
INSERT INTO obce VALUES (2726, 'CZ0426', 'Rtyně nad Bílinou', 389, 402, 38.5, 39.4);
INSERT INTO obce VALUES (2727, 'CZ0426', 'Srbice', 148, 145, 40.8, 40.9);
INSERT INTO obce VALUES (2728, 'CZ0426', 'Světec', 491, 490, 37.6, 40.5);
INSERT INTO obce VALUES (2729, 'CZ0426', 'Teplice', 24673, 26535, 39.0, 42.6);
INSERT INTO obce VALUES (2730, 'CZ0426', 'Újezdeček', 453, 479, 35.8, 38.2);
INSERT INTO obce VALUES (2731, 'CZ0426', 'Zabrušany', 546, 562, 39.6, 41.7);
INSERT INTO obce VALUES (2732, 'CZ0426', 'Žalany', 251, 247, 38.0, 39.6);
INSERT INTO obce VALUES (2733, 'CZ0426', 'Žim', 76, 78, 38.8, 39.1);
INSERT INTO obce VALUES (2734, 'CZ0427', 'Dolní Zálezly', 291, 282, 40.6, 40.6);
INSERT INTO obce VALUES (2735, 'CZ0427', 'Habrovany', 110, 114, 36.5, 36.8);
INSERT INTO obce VALUES (2736, 'CZ0427', 'Homole u Panny', 194, 181, 42.2, 40.9);
INSERT INTO obce VALUES (2737, 'CZ0427', 'Chabařovice', 1277, 1290, 37.7, 39.6);
INSERT INTO obce VALUES (2738, 'CZ0427', 'Chlumec', 2224, 2210, 38.2, 39.8);
INSERT INTO obce VALUES (2739, 'CZ0427', 'Chuderov', 512, 502, 35.9, 36.4);
INSERT INTO obce VALUES (2740, 'CZ0427', 'Libouchec', 963, 892, 38.9, 40.1);
INSERT INTO obce VALUES (2741, 'CZ0427', 'Malé Březno', 272, 285, 40.2, 41.2);
INSERT INTO obce VALUES (2742, 'CZ0427', 'Malečov', 404, 345, 38.0, 40.0);
INSERT INTO obce VALUES (2743, 'CZ0427', 'Petrovice', 480, 425, 34.9, 36.2);
INSERT INTO obce VALUES (2744, 'CZ0427', 'Povrly', 1099, 1127, 38.8, 42.1);
INSERT INTO obce VALUES (2745, 'CZ0427', 'Přestanov', 188, 185, 36.1, 40.2);
INSERT INTO obce VALUES (2746, 'CZ0427', 'Ryjice', 99, 85, 38.6, 41.2);
INSERT INTO obce VALUES (2747, 'CZ0427', 'Řehlovice', 660, 647, 37.8, 41.6);
INSERT INTO obce VALUES (2748, 'CZ0427', 'Stebno', 229, 206, 37.6, 41.0);
INSERT INTO obce VALUES (2749, 'CZ0427', 'Tašov', 86, 91, 37.4, 36.8);
INSERT INTO obce VALUES (2750, 'CZ0427', 'Telnice', 414, 351, 39.8, 40.9);
INSERT INTO obce VALUES (2751, 'CZ0427', 'Tisá', 434, 438, 37.2, 41.3);
INSERT INTO obce VALUES (2752, 'CZ0427', 'Trmice', 1624, 1577, 35.5, 36.2);
INSERT INTO obce VALUES (2753, 'CZ0427', 'Ústí nad Labem', 46525, 48952, 38.2, 41.6);
INSERT INTO obce VALUES (2754, 'CZ0427', 'Velké Březno', 1084, 1121, 37.8, 42.3);
INSERT INTO obce VALUES (2755, 'CZ0427', 'Velké Chvojno', 387, 374, 36.4, 38.9);
INSERT INTO obce VALUES (2756, 'CZ0427', 'Zubrnice', 115, 107, 41.7, 38.7);
INSERT INTO obce VALUES (2757, 'CZ0511', 'Bezděz', 151, 150, 41.2, 44.0);
INSERT INTO obce VALUES (2758, 'CZ0511', 'Blatce', 44, 46, 44.4, 37.5);
INSERT INTO obce VALUES (2759, 'CZ0511', 'Blíževedly', 342, 310, 36.3, 37.2);
INSERT INTO obce VALUES (2760, 'CZ0511', 'Bohatice', 81, 86, 40.4, 39.6);
INSERT INTO obce VALUES (2761, 'CZ0511', 'Brniště', 697, 685, 37.9, 39.5);
INSERT INTO obce VALUES (2762, 'CZ0511', 'Cvikov', 2271, 2227, 38.3, 41.5);
INSERT INTO obce VALUES (2763, 'CZ0511', 'Česká Lípa', 18508, 19596, 36.9, 39.5);
INSERT INTO obce VALUES (2764, 'CZ0511', 'Doksy', 2527, 2604, 39.8, 42.9);
INSERT INTO obce VALUES (2765, 'CZ0511', 'Dubá', 897, 894, 38.2, 40.4);
INSERT INTO obce VALUES (2766, 'CZ0511', 'Dubnice', 315, 327, 37.5, 37.1);
INSERT INTO obce VALUES (2767, 'CZ0511', 'Hamr na Jezeře', 198, 173, 35.6, 38.8);
INSERT INTO obce VALUES (2768, 'CZ0511', 'Holany', 265, 245, 37.2, 38.7);
INSERT INTO obce VALUES (2769, 'CZ0511', 'Horní Libchava', 319, 307, 34.9, 34.6);
INSERT INTO obce VALUES (2770, 'CZ0511', 'Horní Police', 335, 351, 37.4, 39.6);
INSERT INTO obce VALUES (2771, 'CZ0511', 'Chlum', 139, 139, 36.0, 39.1);
INSERT INTO obce VALUES (2772, 'CZ0511', 'Chotovice', 73, 81, 39.5, 40.4);
INSERT INTO obce VALUES (2773, 'CZ0511', 'Jestřebí', 388, 427, 36.7, 40.2);
INSERT INTO obce VALUES (2774, 'CZ0511', 'Kamenický Šenov', 1982, 2013, 39.8, 40.9);
INSERT INTO obce VALUES (2775, 'CZ0511', 'Kozly', 66, 71, 40.3, 39.5);
INSERT INTO obce VALUES (2776, 'CZ0511', 'Kravaře', 422, 435, 37.5, 39.0);
INSERT INTO obce VALUES (2777, 'CZ0511', 'Krompach', 78, 63, 41.0, 43.5);
INSERT INTO obce VALUES (2778, 'CZ0511', 'Kunratice u Cvikova', 295, 281, 38.6, 40.1);
INSERT INTO obce VALUES (2779, 'CZ0511', 'Kvítkov', 109, 92, 35.6, 40.3);
INSERT INTO obce VALUES (2780, 'CZ0511', 'Luka', 55, 59, 36.4, 41.9);
INSERT INTO obce VALUES (2781, 'CZ0511', 'Mařenice', 167, 210, 41.2, 45.3);
INSERT INTO obce VALUES (2782, 'CZ0511', 'Mimoň', 3297, 3491, 38.1, 40.7);
INSERT INTO obce VALUES (2783, 'CZ0511', 'Noviny pod Ralskem', 119, 131, 43.1, 43.0);
INSERT INTO obce VALUES (2784, 'CZ0511', 'Nový Bor', 5929, 6331, 39.0, 42.3);
INSERT INTO obce VALUES (2785, 'CZ0511', 'Nový Oldřichov', 366, 368, 36.8, 41.4);
INSERT INTO obce VALUES (2786, 'CZ0511', 'Okna', 154, 141, 37.7, 41.3);
INSERT INTO obce VALUES (2787, 'CZ0511', 'Okrouhlá', 277, 274, 39.8, 41.5);
INSERT INTO obce VALUES (2788, 'CZ0511', 'Pertoltice pod Ralskem', 217, 174, 35.6, 38.8);
INSERT INTO obce VALUES (2789, 'CZ0511', 'Polevsko', 188, 180, 38.6, 41.0);
INSERT INTO obce VALUES (2790, 'CZ0511', 'Provodín', 361, 318, 39.3, 43.2);
INSERT INTO obce VALUES (2791, 'CZ0511', 'Prysk', 218, 236, 40.4, 40.9);
INSERT INTO obce VALUES (2792, 'CZ0511', 'Radvanec', 78, 70, 39.0, 40.4);
INSERT INTO obce VALUES (2793, 'CZ0511', 'Ralsko', 1089, 1016, 33.8, 33.8);
INSERT INTO obce VALUES (2794, 'CZ0511', 'Skalice u České Lípy', 724, 686, 36.4, 39.4);
INSERT INTO obce VALUES (2795, 'CZ0511', 'Skalka u Doks', 79, 72, 39.0, 35.9);
INSERT INTO obce VALUES (2796, 'CZ0511', 'Sloup v Čechách', 356, 369, 40.6, 43.8);
INSERT INTO obce VALUES (2797, 'CZ0511', 'Slunečná', 58, 52, 41.1, 37.2);
INSERT INTO obce VALUES (2798, 'CZ0511', 'Sosnová', 341, 352, 41.0, 41.2);
INSERT INTO obce VALUES (2799, 'CZ0511', 'Stráž pod Ralskem', 2062, 2137, 34.8, 36.7);
INSERT INTO obce VALUES (2800, 'CZ0511', 'Stružnice', 493, 469, 37.3, 39.5);
INSERT INTO obce VALUES (2801, 'CZ0511', 'Stvolínky', 174, 161, 36.4, 34.5);
INSERT INTO obce VALUES (2802, 'CZ0511', 'Svojkov', 89, 74, 38.4, 40.4);
INSERT INTO obce VALUES (2803, 'CZ0511', 'Svor', 334, 345, 36.9, 39.5);
INSERT INTO obce VALUES (2804, 'CZ0511', 'Tachov', 91, 72, 33.8, 31.5);
INSERT INTO obce VALUES (2805, 'CZ0511', 'Tuhaň', 151, 114, 38.1, 43.1);
INSERT INTO obce VALUES (2806, 'CZ0511', 'Velenice', 78, 66, 45.9, 47.1);
INSERT INTO obce VALUES (2807, 'CZ0511', 'Velký Valtinov', 76, 91, 43.4, 43.1);
INSERT INTO obce VALUES (2808, 'CZ0511', 'Volfartice', 300, 335, 38.2, 38.4);
INSERT INTO obce VALUES (2809, 'CZ0511', 'Vrchovany', 57, 53, 38.3, 40.9);
INSERT INTO obce VALUES (2810, 'CZ0511', 'Zahrádky', 335, 347, 37.3, 37.7);
INSERT INTO obce VALUES (2811, 'CZ0511', 'Zákupy', 1404, 1439, 37.1, 40.1);
INSERT INTO obce VALUES (2812, 'CZ0511', 'Žandov', 986, 972, 38.4, 41.1);
INSERT INTO obce VALUES (2813, 'CZ0511', 'Ždírec', 65, 66, 35.2, 35.6);
INSERT INTO obce VALUES (2814, 'CZ0512', 'Albrechtice v Jizerských horách', 176, 158, 39.0, 43.6);
INSERT INTO obce VALUES (2815, 'CZ0512', 'Bedřichov', 165, 158, 36.1, 35.2);
INSERT INTO obce VALUES (2816, 'CZ0512', 'Dalešice', 74, 80, 37.0, 37.6);
INSERT INTO obce VALUES (2817, 'CZ0512', 'Desná', 1664, 1755, 39.6, 42.3);
INSERT INTO obce VALUES (2818, 'CZ0512', 'Držkov', 267, 287, 40.4, 44.0);
INSERT INTO obce VALUES (2819, 'CZ0512', 'Frýdštejn', 415, 434, 40.3, 43.6);
INSERT INTO obce VALUES (2820, 'CZ0512', 'Jablonec nad Nisou', 21799, 23529, 38.9, 42.2);
INSERT INTO obce VALUES (2821, 'CZ0512', 'Janov nad Nisou', 650, 628, 39.0, 42.0);
INSERT INTO obce VALUES (2822, 'CZ0512', 'Jenišovice', 485, 482, 37.2, 38.7);
INSERT INTO obce VALUES (2823, 'CZ0512', 'Jílové u Držkova', 109, 101, 40.6, 44.5);
INSERT INTO obce VALUES (2824, 'CZ0512', 'Jiřetín pod Bukovou', 286, 304, 41.9, 45.6);
INSERT INTO obce VALUES (2825, 'CZ0512', 'Josefův Důl', 511, 451, 41.7, 45.6);
INSERT INTO obce VALUES (2826, 'CZ0512', 'Koberovy', 507, 518, 38.9, 42.4);
INSERT INTO obce VALUES (2827, 'CZ0512', 'Kořenov', 487, 482, 41.3, 43.8);
INSERT INTO obce VALUES (2828, 'CZ0512', 'Líšný', 127, 131, 45.8, 46.3);
INSERT INTO obce VALUES (2829, 'CZ0512', 'Loužnice', 110, 103, 37.8, 42.7);
INSERT INTO obce VALUES (2830, 'CZ0512', 'Lučany nad Nisou', 912, 874, 38.7, 40.7);
INSERT INTO obce VALUES (2831, 'CZ0512', 'Malá Skála', 563, 568, 39.7, 43.0);
INSERT INTO obce VALUES (2832, 'CZ0512', 'Maršovice', 261, 242, 38.7, 40.2);
INSERT INTO obce VALUES (2833, 'CZ0512', 'Nová Ves nad Nisou', 349, 316, 39.2, 39.6);
INSERT INTO obce VALUES (2834, 'CZ0512', 'Pěnčín', 935, 968, 38.5, 41.1);
INSERT INTO obce VALUES (2835, 'CZ0512', 'Plavy', 542, 510, 37.6, 41.5);
INSERT INTO obce VALUES (2836, 'CZ0512', 'Pulečný', 171, 175, 38.4, 38.5);
INSERT INTO obce VALUES (2837, 'CZ0512', 'Radčice', 87, 82, 46.3, 47.7);
INSERT INTO obce VALUES (2838, 'CZ0512', 'Rádlo', 368, 332, 37.4, 39.4);
INSERT INTO obce VALUES (2839, 'CZ0512', 'Rychnov u Jablonce nad Nisou', 1299, 1313, 35.3, 37.6);
INSERT INTO obce VALUES (2840, 'CZ0512', 'Skuhrov', 252, 277, 39.6, 41.4);
INSERT INTO obce VALUES (2841, 'CZ0512', 'Smržovka', 1817, 1869, 38.5, 41.2);
INSERT INTO obce VALUES (2842, 'CZ0512', 'Tanvald', 3399, 3555, 39.3, 42.1);
INSERT INTO obce VALUES (2843, 'CZ0512', 'Velké Hamry', 1353, 1526, 38.4, 42.7);
INSERT INTO obce VALUES (2844, 'CZ0512', 'Vlastiboř', 66, 63, 47.2, 51.0);
INSERT INTO obce VALUES (2845, 'CZ0512', 'Zásada', 431, 444, 40.7, 43.2);
INSERT INTO obce VALUES (2846, 'CZ0512', 'Zlatá Olešnice', 265, 259, 39.6, 42.6);
INSERT INTO obce VALUES (2847, 'CZ0512', 'Železný Brod', 3125, 3389, 40.0, 43.1);
INSERT INTO obce VALUES (2848, 'CZ0513', 'Bílá', 418, 419, 37.7, 40.4);
INSERT INTO obce VALUES (2849, 'CZ0513', 'Bílý Kostel nad Nisou', 464, 430, 37.6, 41.2);
INSERT INTO obce VALUES (2850, 'CZ0513', 'Bílý Potok', 338, 345, 40.6, 41.5);
INSERT INTO obce VALUES (2851, 'CZ0513', 'Bulovka', 471, 416, 35.9, 38.3);
INSERT INTO obce VALUES (2852, 'CZ0513', 'Cetenov', 57, 54, 43.3, 44.6);
INSERT INTO obce VALUES (2853, 'CZ0513', 'Černousy', 185, 159, 36.4, 44.1);
INSERT INTO obce VALUES (2854, 'CZ0513', 'Český Dub', 1415, 1428, 40.0, 44.8);
INSERT INTO obce VALUES (2855, 'CZ0513', 'Čtveřín', 239, 214, 38.1, 40.9);
INSERT INTO obce VALUES (2856, 'CZ0513', 'Dětřichov', 345, 356, 36.6, 38.7);
INSERT INTO obce VALUES (2857, 'CZ0513', 'Dlouhý Most', 391, 384, 37.1, 37.9);
INSERT INTO obce VALUES (2858, 'CZ0513', 'Dolní Řasnice', 273, 252, 37.6, 38.1);
INSERT INTO obce VALUES (2859, 'CZ0513', 'Frýdlant', 3712, 3925, 37.9, 40.8);
INSERT INTO obce VALUES (2860, 'CZ0513', 'Habartice', 281, 236, 34.9, 39.0);
INSERT INTO obce VALUES (2861, 'CZ0513', 'Hejnice', 1352, 1447, 38.3, 40.6);
INSERT INTO obce VALUES (2862, 'CZ0513', 'Heřmanice', 118, 114, 37.5, 41.5);
INSERT INTO obce VALUES (2863, 'CZ0513', 'Hlavice', 96, 117, 47.0, 49.9);
INSERT INTO obce VALUES (2864, 'CZ0513', 'Hodkovice nad Mohelkou', 1387, 1458, 38.3, 41.0);
INSERT INTO obce VALUES (2865, 'CZ0513', 'Horní Řasnice', 141, 118, 33.7, 41.3);
INSERT INTO obce VALUES (2866, 'CZ0513', 'Hrádek nad Nisou', 3860, 3782, 37.4, 41.5);
INSERT INTO obce VALUES (2867, 'CZ0513', 'Chotyně', 452, 452, 36.9, 39.7);
INSERT INTO obce VALUES (2868, 'CZ0513', 'Chrastava', 3031, 3092, 37.2, 40.3);
INSERT INTO obce VALUES (2869, 'CZ0513', 'Jablonné v Podještědí', 1891, 1917, 38.2, 40.5);
INSERT INTO obce VALUES (2870, 'CZ0513', 'Janovice v Podještědí', 42, 38, 39.2, 44.5);
INSERT INTO obce VALUES (2871, 'CZ0513', 'Janův Důl', 63, 73, 37.5, 39.7);
INSERT INTO obce VALUES (2872, 'CZ0513', 'Jeřmanice', 233, 216, 37.7, 37.9);
INSERT INTO obce VALUES (2873, 'CZ0513', 'Jindřichovice pod Smrkem', 323, 356, 41.0, 42.7);
INSERT INTO obce VALUES (2874, 'CZ0513', 'Kobyly', 177, 153, 41.2, 45.3);
INSERT INTO obce VALUES (2875, 'CZ0513', 'Krásný Les', 227, 228, 41.0, 39.1);
INSERT INTO obce VALUES (2876, 'CZ0513', 'Kryštofovo Údolí', 158, 133, 40.5, 42.6);
INSERT INTO obce VALUES (2877, 'CZ0513', 'Křižany', 384, 392, 39.2, 40.4);
INSERT INTO obce VALUES (2878, 'CZ0513', 'Kunratice', 199, 192, 39.7, 40.0);
INSERT INTO obce VALUES (2879, 'CZ0513', 'Lázně Libverda', 225, 248, 37.6, 40.4);
INSERT INTO obce VALUES (2880, 'CZ0513', 'Lažany', 100, 122, 39.6, 36.5);
INSERT INTO obce VALUES (2881, 'CZ0513', 'Liberec', 49035, 52590, 39.0, 42.2);
INSERT INTO obce VALUES (2882, 'CZ0513', 'Mníšek', 642, 682, 37.6, 39.7);
INSERT INTO obce VALUES (2883, 'CZ0513', 'Nová Ves', 400, 408, 40.6, 39.2);
INSERT INTO obce VALUES (2884, 'CZ0513', 'Nové Město pod Smrkem', 1935, 1962, 37.7, 38.6);
INSERT INTO obce VALUES (2885, 'CZ0513', 'Oldřichov v Hájích', 323, 311, 40.5, 40.4);
INSERT INTO obce VALUES (2886, 'CZ0513', 'Osečná', 521, 572, 38.7, 39.2);
INSERT INTO obce VALUES (2887, 'CZ0513', 'Paceřice', 142, 150, 41.8, 44.0);
INSERT INTO obce VALUES (2888, 'CZ0513', 'Pěnčín', 318, 343, 38.4, 39.6);
INSERT INTO obce VALUES (2889, 'CZ0513', 'Pertoltice', 138, 144, 38.7, 38.4);
INSERT INTO obce VALUES (2890, 'CZ0513', 'Proseč pod Ještědem', 155, 137, 42.7, 44.4);
INSERT INTO obce VALUES (2891, 'CZ0513', 'Příšovice', 650, 666, 38.1, 39.9);
INSERT INTO obce VALUES (2892, 'CZ0513', 'Radimovice', 134, 139, 40.4, 43.3);
INSERT INTO obce VALUES (2893, 'CZ0513', 'Raspenava', 1417, 1433, 38.5, 39.8);
INSERT INTO obce VALUES (2894, 'CZ0513', 'Rynoltice', 379, 387, 40.9, 41.9);
INSERT INTO obce VALUES (2895, 'CZ0513', 'Soběslavice', 77, 74, 37.4, 38.8);
INSERT INTO obce VALUES (2896, 'CZ0513', 'Stráž nad Nisou', 1073, 1026, 37.7, 40.1);
INSERT INTO obce VALUES (2897, 'CZ0513', 'Světlá pod Ještědem', 472, 459, 40.4, 42.4);
INSERT INTO obce VALUES (2898, 'CZ0513', 'Svijanský Újezd', 196, 193, 38.0, 39.9);
INSERT INTO obce VALUES (2899, 'CZ0513', 'Svijany', 145, 147, 43.3, 43.3);
INSERT INTO obce VALUES (2900, 'CZ0513', 'Sychrov', 110, 90, 31.5, 38.5);
INSERT INTO obce VALUES (2901, 'CZ0513', 'Šimonovice', 353, 360, 35.5, 38.0);
INSERT INTO obce VALUES (2902, 'CZ0513', 'Višňová', 702, 682, 38.9, 40.8);
INSERT INTO obce VALUES (2903, 'CZ0513', 'Vlastibořice', 106, 140, 44.5, 43.4);
INSERT INTO obce VALUES (2904, 'CZ0513', 'Všelibice', 268, 264, 41.2, 45.3);
INSERT INTO obce VALUES (2905, 'CZ0513', 'Zdislava', 160, 146, 37.7, 39.7);
INSERT INTO obce VALUES (2906, 'CZ0513', 'Žďárek', 65, 60, 41.1, 37.9);
INSERT INTO obce VALUES (2907, 'CZ0514', 'Bělá', 128, 129, 39.6, 43.4);
INSERT INTO obce VALUES (2908, 'CZ0514', 'Benecko', 564, 539, 40.9, 42.0);
INSERT INTO obce VALUES (2909, 'CZ0514', 'Benešov u Semil', 445, 426, 36.6, 40.8);
INSERT INTO obce VALUES (2910, 'CZ0514', 'Bozkov', 290, 282, 39.9, 42.3);
INSERT INTO obce VALUES (2911, 'CZ0514', 'Bradlecká Lhota', 109, 119, 41.9, 43.7);
INSERT INTO obce VALUES (2912, 'CZ0514', 'Bukovina u Čisté', 99, 95, 37.0, 40.2);
INSERT INTO obce VALUES (2913, 'CZ0514', 'Bystrá nad Jizerou', 52, 60, 39.7, 45.1);
INSERT INTO obce VALUES (2914, 'CZ0514', 'Čistá u Horek', 261, 273, 40.4, 43.6);
INSERT INTO obce VALUES (2915, 'CZ0514', 'Háje nad Jizerou', 336, 331, 37.9, 41.2);
INSERT INTO obce VALUES (2916, 'CZ0514', 'Harrachov', 764, 795, 40.8, 42.7);
INSERT INTO obce VALUES (2917, 'CZ0514', 'Holenice', 45, 43, 40.2, 44.5);
INSERT INTO obce VALUES (2918, 'CZ0514', 'Horka u Staré Paky', 130, 126, 38.6, 46.2);
INSERT INTO obce VALUES (2919, 'CZ0514', 'Horní Branná', 920, 923, 38.1, 40.6);
INSERT INTO obce VALUES (2920, 'CZ0514', 'Hrubá Skála', 278, 293, 41.7, 42.2);
INSERT INTO obce VALUES (2921, 'CZ0514', 'Chuchelna', 456, 492, 39.3, 41.0);
INSERT INTO obce VALUES (2922, 'CZ0514', 'Jablonec nad Jizerou', 902, 942, 39.5, 43.5);
INSERT INTO obce VALUES (2923, 'CZ0514', 'Jesenný', 250, 232, 40.9, 45.1);
INSERT INTO obce VALUES (2924, 'CZ0514', 'Jestřabí v Krkonoších', 132, 106, 40.8, 46.1);
INSERT INTO obce VALUES (2925, 'CZ0514', 'Jilemnice', 2770, 2911, 38.2, 41.9);
INSERT INTO obce VALUES (2926, 'CZ0514', 'Kacanovy', 92, 87, 40.3, 44.2);
INSERT INTO obce VALUES (2927, 'CZ0514', 'Karlovice', 381, 357, 40.7, 44.0);
INSERT INTO obce VALUES (2928, 'CZ0514', 'Klokočí', 94, 84, 36.8, 44.0);
INSERT INTO obce VALUES (2929, 'CZ0514', 'Košťálov', 830, 846, 38.5, 42.8);
INSERT INTO obce VALUES (2930, 'CZ0514', 'Kruh', 244, 256, 40.6, 41.3);
INSERT INTO obce VALUES (2931, 'CZ0514', 'Ktová', 93, 92, 42.5, 46.7);
INSERT INTO obce VALUES (2932, 'CZ0514', 'Levínská Olešnice', 195, 163, 38.7, 41.4);
INSERT INTO obce VALUES (2933, 'CZ0514', 'Libštát', 495, 507, 38.7, 42.7);
INSERT INTO obce VALUES (2934, 'CZ0514', 'Lomnice nad Popelkou', 2873, 2982, 39.3, 42.8);
INSERT INTO obce VALUES (2935, 'CZ0514', 'Loučky', 80, 81, 43.1, 43.7);
INSERT INTO obce VALUES (2936, 'CZ0514', 'Martinice v Krkonoších', 297, 287, 38.3, 41.8);
INSERT INTO obce VALUES (2937, 'CZ0514', 'Mírová pod Kozákovem', 750, 836, 39.2, 40.6);
INSERT INTO obce VALUES (2938, 'CZ0514', 'Modřišice', 195, 195, 39.7, 41.3);
INSERT INTO obce VALUES (2939, 'CZ0514', 'Mříčná', 262, 240, 36.7, 41.0);
INSERT INTO obce VALUES (2940, 'CZ0514', 'Nová Ves nad Popelkou', 325, 328, 39.6, 41.1);
INSERT INTO obce VALUES (2941, 'CZ0514', 'Ohrazenice', 558, 567, 38.9, 40.0);
INSERT INTO obce VALUES (2942, 'CZ0514', 'Olešnice', 84, 93, 43.4, 43.8);
INSERT INTO obce VALUES (2943, 'CZ0514', 'Paseky nad Jizerou', 123, 123, 44.7, 42.7);
INSERT INTO obce VALUES (2944, 'CZ0514', 'Peřimov', 113, 111, 38.4, 40.9);
INSERT INTO obce VALUES (2945, 'CZ0514', 'Poniklá', 582, 612, 40.6, 44.6);
INSERT INTO obce VALUES (2946, 'CZ0514', 'Přepeře', 435, 447, 39.9, 40.9);
INSERT INTO obce VALUES (2947, 'CZ0514', 'Příkrý', 125, 120, 42.9, 44.3);
INSERT INTO obce VALUES (2948, 'CZ0514', 'Radostná pod Kozákovem', 195, 163, 40.8, 46.6);
INSERT INTO obce VALUES (2949, 'CZ0514', 'Rakousy', 38, 34, 40.1, 47.0);
INSERT INTO obce VALUES (2950, 'CZ0514', 'Rokytnice nad Jizerou', 1534, 1478, 40.3, 45.2);
INSERT INTO obce VALUES (2951, 'CZ0514', 'Roprachtice', 132, 146, 41.0, 42.5);
INSERT INTO obce VALUES (2952, 'CZ0514', 'Rovensko pod Troskami', 606, 625, 40.5, 41.4);
INSERT INTO obce VALUES (2953, 'CZ0514', 'Roztoky u Jilemnice', 451, 479, 38.2, 40.5);
INSERT INTO obce VALUES (2954, 'CZ0514', 'Roztoky u Semil', 61, 63, 47.5, 50.6);
INSERT INTO obce VALUES (2955, 'CZ0514', 'Semily', 4292, 4538, 39.5, 43.1);
INSERT INTO obce VALUES (2956, 'CZ0514', 'Slaná', 342, 347, 36.6, 41.6);
INSERT INTO obce VALUES (2957, 'CZ0514', 'Stružinec', 345, 354, 41.0, 42.6);
INSERT INTO obce VALUES (2958, 'CZ0514', 'Studenec', 904, 914, 38.1, 41.6);
INSERT INTO obce VALUES (2959, 'CZ0514', 'Svojek', 82, 81, 37.7, 43.9);
INSERT INTO obce VALUES (2960, 'CZ0514', 'Syřenov', 110, 102, 35.9, 43.9);
INSERT INTO obce VALUES (2961, 'CZ0514', 'Tatobity', 272, 268, 42.1, 42.0);
INSERT INTO obce VALUES (2962, 'CZ0514', 'Troskovice', 60, 47, 48.9, 53.5);
INSERT INTO obce VALUES (2963, 'CZ0514', 'Turnov', 6883, 7562, 40.3, 43.9);
INSERT INTO obce VALUES (2964, 'CZ0514', 'Veselá', 107, 109, 41.1, 41.0);
INSERT INTO obce VALUES (2965, 'CZ0514', 'Víchová nad Jizerou', 438, 476, 37.7, 39.1);
INSERT INTO obce VALUES (2966, 'CZ0514', 'Vítkovice', 199, 205, 39.5, 37.6);
INSERT INTO obce VALUES (2967, 'CZ0514', 'Všeň', 268, 275, 39.7, 44.3);
INSERT INTO obce VALUES (2968, 'CZ0514', 'Vyskeř', 194, 178, 41.9, 44.9);
INSERT INTO obce VALUES (2969, 'CZ0514', 'Vysoké nad Jizerou', 679, 625, 40.0, 43.5);
INSERT INTO obce VALUES (2970, 'CZ0514', 'Záhoří', 255, 255, 39.7, 41.1);
INSERT INTO obce VALUES (2971, 'CZ0514', 'Žernov', 135, 104, 37.4, 43.8);
INSERT INTO obce VALUES (2972, 'CZ0521', 'Babice', 100, 93, 42.5, 46.5);
INSERT INTO obce VALUES (2973, 'CZ0521', 'Barchov', 123, 130, 38.6, 43.2);
INSERT INTO obce VALUES (2974, 'CZ0521', 'Běleč nad Orlicí', 136, 134, 40.5, 40.3);
INSERT INTO obce VALUES (2975, 'CZ0521', 'Benátky', 58, 41, 37.0, 39.2);
INSERT INTO obce VALUES (2976, 'CZ0521', 'Blešno', 176, 166, 39.1, 41.1);
INSERT INTO obce VALUES (2977, 'CZ0521', 'Boharyně', 260, 284, 38.0, 42.1);
INSERT INTO obce VALUES (2978, 'CZ0521', 'Černilov', 1210, 1233, 36.8, 37.0);
INSERT INTO obce VALUES (2979, 'CZ0521', 'Černožice', 593, 595, 38.9, 43.3);
INSERT INTO obce VALUES (2980, 'CZ0521', 'Čistěves', 77, 78, 35.7, 35.8);
INSERT INTO obce VALUES (2981, 'CZ0521', 'Divec', 102, 101, 34.1, 37.9);
INSERT INTO obce VALUES (2982, 'CZ0521', 'Dobřenice', 296, 313, 41.2, 43.2);
INSERT INTO obce VALUES (2983, 'CZ0521', 'Dohalice', 210, 230, 35.8, 37.6);
INSERT INTO obce VALUES (2984, 'CZ0521', 'Dolní Přím', 299, 304, 38.3, 42.8);
INSERT INTO obce VALUES (2985, 'CZ0521', 'Habřina', 131, 135, 38.3, 40.1);
INSERT INTO obce VALUES (2986, 'CZ0521', 'Hlušice', 381, 371, 37.5, 42.2);
INSERT INTO obce VALUES (2987, 'CZ0521', 'Hněvčeves', 79, 76, 40.0, 42.6);
INSERT INTO obce VALUES (2988, 'CZ0521', 'Holohlavy', 467, 455, 37.2, 38.7);
INSERT INTO obce VALUES (2989, 'CZ0521', 'Hořiněves', 345, 358, 40.8, 41.7);
INSERT INTO obce VALUES (2990, 'CZ0521', 'Hradec Králové', 45220, 49273, 41.0, 44.3);
INSERT INTO obce VALUES (2991, 'CZ0521', 'Hrádek', 97, 92, 40.3, 42.9);
INSERT INTO obce VALUES (2992, 'CZ0521', 'Humburky', 156, 188, 39.1, 45.9);
INSERT INTO obce VALUES (2993, 'CZ0521', 'Hvozdnice', 103, 101, 35.5, 40.3);
INSERT INTO obce VALUES (2994, 'CZ0521', 'Chlumec nad Cidlinou', 2662, 2739, 39.7, 42.6);
INSERT INTO obce VALUES (2995, 'CZ0521', 'Chudeřice', 113, 98, 38.5, 37.2);
INSERT INTO obce VALUES (2996, 'CZ0521', 'Jeníkovice', 228, 206, 38.4, 41.5);
INSERT INTO obce VALUES (2997, 'CZ0521', 'Jílovice', 170, 154, 36.1, 37.2);
INSERT INTO obce VALUES (2998, 'CZ0521', 'Káranice', 94, 104, 39.0, 41.3);
INSERT INTO obce VALUES (2999, 'CZ0521', 'Klamoš', 194, 202, 42.5, 44.1);
INSERT INTO obce VALUES (3000, 'CZ0521', 'Kobylice', 126, 117, 34.6, 34.2);
INSERT INTO obce VALUES (3001, 'CZ0521', 'Kosice', 150, 171, 37.9, 40.0);
INSERT INTO obce VALUES (3002, 'CZ0521', 'Kosičky', 181, 180, 38.8, 41.8);
INSERT INTO obce VALUES (3003, 'CZ0521', 'Králíky', 185, 191, 38.7, 37.5);
INSERT INTO obce VALUES (3004, 'CZ0521', 'Kratonohy', 286, 303, 38.7, 40.9);
INSERT INTO obce VALUES (3005, 'CZ0521', 'Kunčice', 139, 160, 40.9, 42.2);
INSERT INTO obce VALUES (3006, 'CZ0521', 'Ledce', 162, 176, 36.8, 42.8);
INSERT INTO obce VALUES (3007, 'CZ0521', 'Lejšovka', 98, 94, 39.3, 40.2);
INSERT INTO obce VALUES (3008, 'CZ0521', 'Lhota pod Libčany', 451, 439, 37.3, 40.3);
INSERT INTO obce VALUES (3009, 'CZ0521', 'Libčany', 473, 462, 38.7, 39.3);
INSERT INTO obce VALUES (3010, 'CZ0521', 'Libníkovice', 66, 82, 42.7, 39.3);
INSERT INTO obce VALUES (3011, 'CZ0521', 'Librantice', 236, 240, 36.7, 39.2);
INSERT INTO obce VALUES (3012, 'CZ0521', 'Libřice', 151, 134, 39.5, 41.7);
INSERT INTO obce VALUES (3013, 'CZ0521', 'Lišice', 91, 76, 47.4, 54.4);
INSERT INTO obce VALUES (3014, 'CZ0521', 'Lodín', 164, 184, 38.9, 39.4);
INSERT INTO obce VALUES (3015, 'CZ0521', 'Lochenice', 266, 284, 37.7, 39.6);
INSERT INTO obce VALUES (3016, 'CZ0521', 'Lovčice', 324, 356, 39.6, 40.9);
INSERT INTO obce VALUES (3017, 'CZ0521', 'Lužany', 58, 73, 42.0, 42.0);
INSERT INTO obce VALUES (3018, 'CZ0521', 'Lužec nad Cidlinou', 244, 253, 40.8, 45.4);
INSERT INTO obce VALUES (3019, 'CZ0521', 'Máslojedy', 106, 111, 36.7, 37.8);
INSERT INTO obce VALUES (3020, 'CZ0521', 'Měník', 300, 309, 39.4, 41.4);
INSERT INTO obce VALUES (3021, 'CZ0521', 'Mlékosrby', 118, 124, 36.4, 44.8);
INSERT INTO obce VALUES (3022, 'CZ0521', 'Mokrovousy', 164, 143, 35.8, 43.4);
INSERT INTO obce VALUES (3023, 'CZ0521', 'Myštěves', 88, 95, 41.7, 44.8);
INSERT INTO obce VALUES (3024, 'CZ0521', 'Mžany', 188, 217, 41.0, 39.3);
INSERT INTO obce VALUES (3025, 'CZ0521', 'Neděliště', 181, 181, 40.0, 42.2);
INSERT INTO obce VALUES (3026, 'CZ0521', 'Nechanice', 1162, 1150, 38.7, 41.3);
INSERT INTO obce VALUES (3027, 'CZ0521', 'Nepolisy', 471, 468, 38.0, 41.2);
INSERT INTO obce VALUES (3028, 'CZ0521', 'Nové Město', 204, 183, 38.4, 42.7);
INSERT INTO obce VALUES (3029, 'CZ0521', 'Nový Bydžov', 3508, 3669, 39.1, 42.3);
INSERT INTO obce VALUES (3030, 'CZ0521', 'Obědovice', 125, 127, 38.6, 45.7);
INSERT INTO obce VALUES (3031, 'CZ0521', 'Ohnišťany', 155, 147, 39.4, 45.9);
INSERT INTO obce VALUES (3032, 'CZ0521', 'Olešnice', 145, 162, 37.7, 41.7);
INSERT INTO obce VALUES (3033, 'CZ0521', 'Osice', 230, 240, 39.5, 40.7);
INSERT INTO obce VALUES (3034, 'CZ0521', 'Osičky', 63, 70, 41.5, 42.7);
INSERT INTO obce VALUES (3035, 'CZ0521', 'Petrovice', 117, 124, 39.2, 38.7);
INSERT INTO obce VALUES (3036, 'CZ0521', 'Písek', 107, 118, 41.5, 45.6);
INSERT INTO obce VALUES (3037, 'CZ0521', 'Prasek', 314, 279, 37.0, 41.7);
INSERT INTO obce VALUES (3038, 'CZ0521', 'Praskačka', 490, 495, 39.2, 40.5);
INSERT INTO obce VALUES (3039, 'CZ0521', 'Předměřice nad Labem', 884, 954, 38.0, 39.1);
INSERT INTO obce VALUES (3040, 'CZ0521', 'Převýšov', 163, 174, 41.5, 43.3);
INSERT INTO obce VALUES (3041, 'CZ0521', 'Pšánky', 21, 25, 49.1, 43.0);
INSERT INTO obce VALUES (3042, 'CZ0521', 'Puchlovice', 56, 71, 47.6, 43.6);
INSERT INTO obce VALUES (3043, 'CZ0521', 'Račice nad Trotinou', 84, 81, 38.3, 39.8);
INSERT INTO obce VALUES (3044, 'CZ0521', 'Radíkovice', 87, 97, 37.6, 38.6);
INSERT INTO obce VALUES (3045, 'CZ0521', 'Radostov', 67, 62, 38.4, 41.7);
INSERT INTO obce VALUES (3046, 'CZ0521', 'Roudnice', 298, 310, 36.3, 39.0);
INSERT INTO obce VALUES (3047, 'CZ0521', 'Sadová', 163, 172, 41.5, 44.2);
INSERT INTO obce VALUES (3048, 'CZ0521', 'Sendražice', 215, 177, 36.0, 39.5);
INSERT INTO obce VALUES (3049, 'CZ0521', 'Skalice', 288, 281, 38.3, 41.5);
INSERT INTO obce VALUES (3050, 'CZ0521', 'Skřivany', 490, 561, 37.3, 40.3);
INSERT INTO obce VALUES (3051, 'CZ0521', 'Sloupno', 251, 248, 40.0, 42.3);
INSERT INTO obce VALUES (3052, 'CZ0521', 'Smidary', 827, 737, 41.8, 44.5);
INSERT INTO obce VALUES (3053, 'CZ0521', 'Smiřice', 1455, 1595, 37.9, 41.3);
INSERT INTO obce VALUES (3054, 'CZ0521', 'Smržov', 228, 231, 38.1, 41.1);
INSERT INTO obce VALUES (3055, 'CZ0521', 'Sovětice', 106, 111, 37.8, 39.4);
INSERT INTO obce VALUES (3056, 'CZ0521', 'Stará Voda', 59, 54, 40.1, 41.4);
INSERT INTO obce VALUES (3057, 'CZ0521', 'Starý Bydžov', 206, 200, 42.2, 44.7);
INSERT INTO obce VALUES (3058, 'CZ0521', 'Stěžery', 893, 896, 37.3, 39.0);
INSERT INTO obce VALUES (3059, 'CZ0521', 'Stračov', 155, 147, 42.1, 44.9);
INSERT INTO obce VALUES (3060, 'CZ0521', 'Střezetice', 178, 193, 38.0, 39.3);
INSERT INTO obce VALUES (3061, 'CZ0521', 'Světí', 147, 146, 39.0, 43.2);
INSERT INTO obce VALUES (3062, 'CZ0521', 'Syrovátka', 220, 180, 39.2, 41.8);
INSERT INTO obce VALUES (3063, 'CZ0521', 'Šaplava', 64, 57, 41.5, 43.4);
INSERT INTO obce VALUES (3064, 'CZ0521', 'Těchlovice', 182, 164, 40.9, 44.9);
INSERT INTO obce VALUES (3065, 'CZ0521', 'Třebechovice pod Orebem', 2873, 2975, 38.6, 41.0);
INSERT INTO obce VALUES (3066, 'CZ0521', 'Třesovice', 118, 117, 40.7, 44.7);
INSERT INTO obce VALUES (3067, 'CZ0521', 'Urbanice', 174, 173, 38.5, 40.3);
INSERT INTO obce VALUES (3068, 'CZ0521', 'Vinary', 215, 243, 41.6, 44.4);
INSERT INTO obce VALUES (3069, 'CZ0521', 'Vrchovnice', 30, 33, 45.7, 51.7);
INSERT INTO obce VALUES (3070, 'CZ0521', 'Všestary', 804, 822, 37.0, 40.3);
INSERT INTO obce VALUES (3071, 'CZ0521', 'Výrava', 199, 162, 38.9, 44.4);
INSERT INTO obce VALUES (3072, 'CZ0521', 'Vysoká nad Labem', 601, 587, 35.6, 37.1);
INSERT INTO obce VALUES (3073, 'CZ0521', 'Vysoký Újezd', 38, 24, 37.2, 42.8);
INSERT INTO obce VALUES (3074, 'CZ0521', 'Zachrašťany', 81, 93, 46.3, 44.3);
INSERT INTO obce VALUES (3075, 'CZ0521', 'Zdechovice', 69, 61, 42.6, 48.7);
INSERT INTO obce VALUES (3076, 'CZ0522', 'Bačalky', 81, 79, 44.7, 48.7);
INSERT INTO obce VALUES (3077, 'CZ0522', 'Bašnice', 93, 94, 41.5, 44.6);
INSERT INTO obce VALUES (3078, 'CZ0522', 'Běchary', 115, 109, 37.3, 43.2);
INSERT INTO obce VALUES (3079, 'CZ0522', 'Bílsko u Hořic', 59, 63, 40.8, 43.7);
INSERT INTO obce VALUES (3080, 'CZ0522', 'Boháňka', 113, 106, 42.0, 42.9);
INSERT INTO obce VALUES (3081, 'CZ0522', 'Borek', 46, 53, 37.5, 40.0);
INSERT INTO obce VALUES (3082, 'CZ0522', 'Brada-Rybníček', 72, 60, 36.4, 36.3);
INSERT INTO obce VALUES (3083, 'CZ0522', 'Březina', 34, 36, 35.6, 42.3);
INSERT INTO obce VALUES (3084, 'CZ0522', 'Bříšťany', 115, 116, 39.2, 45.7);
INSERT INTO obce VALUES (3085, 'CZ0522', 'Budčeves', 81, 93, 41.4, 43.6);
INSERT INTO obce VALUES (3086, 'CZ0522', 'Bukvice', 68, 69, 38.6, 46.9);
INSERT INTO obce VALUES (3087, 'CZ0522', 'Butoves', 111, 114, 37.0, 35.2);
INSERT INTO obce VALUES (3088, 'CZ0522', 'Bystřice', 150, 174, 37.5, 38.1);
INSERT INTO obce VALUES (3089, 'CZ0522', 'Cerekvice nad Bystřicí', 403, 422, 37.4, 38.8);
INSERT INTO obce VALUES (3090, 'CZ0522', 'Červená Třemešná', 80, 79, 37.4, 41.6);
INSERT INTO obce VALUES (3091, 'CZ0522', 'Češov', 79, 100, 47.0, 46.4);
INSERT INTO obce VALUES (3092, 'CZ0522', 'Dětenice', 339, 355, 39.0, 40.8);
INSERT INTO obce VALUES (3093, 'CZ0522', 'Dílce', 22, 24, 37.8, 43.1);
INSERT INTO obce VALUES (3094, 'CZ0522', 'Dobrá Voda u Hořic', 281, 301, 38.2, 40.5);
INSERT INTO obce VALUES (3095, 'CZ0522', 'Dolní Lochov', 24, 26, 48.7, 45.8);
INSERT INTO obce VALUES (3096, 'CZ0522', 'Dřevěnice', 96, 114, 40.7, 39.5);
INSERT INTO obce VALUES (3097, 'CZ0522', 'Holín', 306, 287, 37.7, 42.6);
INSERT INTO obce VALUES (3098, 'CZ0522', 'Holovousy', 235, 281, 41.9, 41.5);
INSERT INTO obce VALUES (3099, 'CZ0522', 'Hořice', 4478, 4575, 39.8, 43.9);
INSERT INTO obce VALUES (3100, 'CZ0522', 'Cholenice', 96, 103, 36.6, 40.8);
INSERT INTO obce VALUES (3101, 'CZ0522', 'Chomutice', 309, 321, 37.2, 40.4);
INSERT INTO obce VALUES (3102, 'CZ0522', 'Choteč', 110, 94, 40.6, 43.6);
INSERT INTO obce VALUES (3103, 'CZ0522', 'Chyjice', 81, 69, 37.5, 47.0);
INSERT INTO obce VALUES (3104, 'CZ0522', 'Jeřice', 190, 208, 39.3, 39.5);
INSERT INTO obce VALUES (3105, 'CZ0522', 'Jičín', 8221, 8425, 39.4, 43.0);
INSERT INTO obce VALUES (3106, 'CZ0522', 'Jičíněves', 298, 264, 39.5, 45.6);
INSERT INTO obce VALUES (3107, 'CZ0522', 'Jinolice', 82, 84, 39.5, 40.2);
INSERT INTO obce VALUES (3108, 'CZ0522', 'Kacákova Lhota', 76, 86, 38.2, 41.7);
INSERT INTO obce VALUES (3109, 'CZ0522', 'Kbelnice', 100, 85, 36.6, 39.2);
INSERT INTO obce VALUES (3110, 'CZ0522', 'Kněžnice', 143, 119, 38.7, 45.8);
INSERT INTO obce VALUES (3111, 'CZ0522', 'Konecchlumí', 184, 191, 37.3, 41.4);
INSERT INTO obce VALUES (3112, 'CZ0522', 'Kopidlno', 1100, 1140, 38.5, 41.2);
INSERT INTO obce VALUES (3113, 'CZ0522', 'Kostelec', 21, 20, 47.3, 46.6);
INSERT INTO obce VALUES (3114, 'CZ0522', 'Kovač', 63, 64, 41.4, 40.8);
INSERT INTO obce VALUES (3115, 'CZ0522', 'Kozojedy', 102, 94, 39.3, 42.3);
INSERT INTO obce VALUES (3116, 'CZ0522', 'Kyje', 29, 26, 43.9, 47.6);
INSERT INTO obce VALUES (3117, 'CZ0522', 'Lázně Bělohrad', 1889, 1838, 39.7, 43.4);
INSERT INTO obce VALUES (3118, 'CZ0522', 'Libáň', 799, 870, 39.6, 42.8);
INSERT INTO obce VALUES (3119, 'CZ0522', 'Libošovice', 227, 227, 41.2, 43.8);
INSERT INTO obce VALUES (3120, 'CZ0522', 'Libuň', 419, 402, 38.5, 43.0);
INSERT INTO obce VALUES (3121, 'CZ0522', 'Lískovice', 88, 111, 42.1, 47.4);
INSERT INTO obce VALUES (3122, 'CZ0522', 'Lukavec u Hořic', 136, 153, 42.4, 41.9);
INSERT INTO obce VALUES (3123, 'CZ0522', 'Lužany', 291, 290, 39.0, 42.2);
INSERT INTO obce VALUES (3124, 'CZ0522', 'Markvartice', 237, 223, 42.6, 43.1);
INSERT INTO obce VALUES (3125, 'CZ0522', 'Miletín', 445, 465, 39.4, 42.4);
INSERT INTO obce VALUES (3126, 'CZ0522', 'Milovice u Hořic', 149, 160, 33.1, 35.3);
INSERT INTO obce VALUES (3127, 'CZ0522', 'Mladějov', 224, 243, 43.3, 46.2);
INSERT INTO obce VALUES (3128, 'CZ0522', 'Mlázovice', 274, 324, 43.2, 47.3);
INSERT INTO obce VALUES (3129, 'CZ0522', 'Nemyčeves', 133, 171, 39.0, 37.5);
INSERT INTO obce VALUES (3130, 'CZ0522', 'Nevratice', 73, 76, 38.4, 42.7);
INSERT INTO obce VALUES (3131, 'CZ0522', 'Nová Paka', 4607, 4765, 39.7, 42.8);
INSERT INTO obce VALUES (3132, 'CZ0522', 'Ohařice', 30, 35, 47.2, 44.0);
INSERT INTO obce VALUES (3133, 'CZ0522', 'Ohaveč', 35, 44, 33.0, 39.5);
INSERT INTO obce VALUES (3134, 'CZ0522', 'Osek', 98, 90, 36.1, 42.0);
INSERT INTO obce VALUES (3135, 'CZ0522', 'Ostroměř', 719, 688, 39.3, 43.8);
INSERT INTO obce VALUES (3136, 'CZ0522', 'Ostružno', 50, 36, 40.0, 45.7);
INSERT INTO obce VALUES (3137, 'CZ0522', 'Pecka', 651, 651, 39.9, 42.5);
INSERT INTO obce VALUES (3138, 'CZ0522', 'Petrovičky', 21, 23, 40.9, 37.7);
INSERT INTO obce VALUES (3139, 'CZ0522', 'Podhorní Újezd a Vojice', 315, 308, 39.6, 41.9);
INSERT INTO obce VALUES (3140, 'CZ0522', 'Podhradí', 207, 225, 42.1, 44.1);
INSERT INTO obce VALUES (3141, 'CZ0522', 'Podůlší', 123, 129, 37.0, 37.1);
INSERT INTO obce VALUES (3142, 'CZ0522', 'Radim', 152, 182, 42.5, 42.5);
INSERT INTO obce VALUES (3143, 'CZ0522', 'Rašín', 37, 32, 38.7, 49.8);
INSERT INTO obce VALUES (3144, 'CZ0522', 'Rohoznice', 153, 177, 40.4, 36.7);
INSERT INTO obce VALUES (3145, 'CZ0522', 'Rokytňany', 40, 32, 36.6, 45.9);
INSERT INTO obce VALUES (3146, 'CZ0522', 'Samšina', 138, 127, 37.8, 43.9);
INSERT INTO obce VALUES (3147, 'CZ0522', 'Sběř', 126, 123, 42.4, 46.5);
INSERT INTO obce VALUES (3148, 'CZ0522', 'Sedliště', 51, 57, 38.7, 45.7);
INSERT INTO obce VALUES (3149, 'CZ0522', 'Sekeřice', 57, 54, 46.4, 48.9);
INSERT INTO obce VALUES (3150, 'CZ0522', 'Slatiny', 273, 307, 40.5, 49.3);
INSERT INTO obce VALUES (3151, 'CZ0522', 'Slavhostice', 68, 71, 41.8, 46.3);
INSERT INTO obce VALUES (3152, 'CZ0522', 'Sobčice', 158, 146, 37.0, 41.0);
INSERT INTO obce VALUES (3153, 'CZ0522', 'Soběraz', 48, 49, 41.8, 37.6);
INSERT INTO obce VALUES (3154, 'CZ0522', 'Sobotka', 1235, 1252, 40.0, 43.4);
INSERT INTO obce VALUES (3155, 'CZ0522', 'Stará Paka', 1003, 1023, 40.1, 43.1);
INSERT INTO obce VALUES (3156, 'CZ0522', 'Staré Hrady', 91, 93, 40.9, 38.5);
INSERT INTO obce VALUES (3157, 'CZ0522', 'Staré Místo', 171, 152, 37.3, 38.3);
INSERT INTO obce VALUES (3158, 'CZ0522', 'Staré Smrkovice', 132, 142, 35.2, 37.2);
INSERT INTO obce VALUES (3159, 'CZ0522', 'Střevač', 131, 152, 35.4, 41.7);
INSERT INTO obce VALUES (3160, 'CZ0522', 'Sukorady', 110, 100, 43.5, 45.8);
INSERT INTO obce VALUES (3161, 'CZ0522', 'Svatojanský Újezd', 51, 52, 38.0, 46.3);
INSERT INTO obce VALUES (3162, 'CZ0522', 'Šárovcova Lhota', 90, 99, 42.7, 45.0);
INSERT INTO obce VALUES (3163, 'CZ0522', 'Tetín', 73, 67, 40.1, 44.2);
INSERT INTO obce VALUES (3164, 'CZ0522', 'Třebnouševes', 140, 137, 38.1, 40.9);
INSERT INTO obce VALUES (3165, 'CZ0522', 'Třtěnice', 163, 169, 39.9, 44.1);
INSERT INTO obce VALUES (3166, 'CZ0522', 'Tuř', 65, 66, 36.6, 40.9);
INSERT INTO obce VALUES (3167, 'CZ0522', 'Úbislavice', 196, 184, 40.5, 42.1);
INSERT INTO obce VALUES (3168, 'CZ0522', 'Údrnice', 148, 163, 40.6, 39.5);
INSERT INTO obce VALUES (3169, 'CZ0522', 'Úhlejov', 71, 71, 37.4, 38.1);
INSERT INTO obce VALUES (3170, 'CZ0522', 'Újezd pod Troskami', 162, 165, 40.3, 45.3);
INSERT INTO obce VALUES (3171, 'CZ0522', 'Úlibice', 122, 125, 38.1, 41.3);
INSERT INTO obce VALUES (3172, 'CZ0522', 'Valdice', 725, 688, 38.7, 41.1);
INSERT INTO obce VALUES (3173, 'CZ0522', 'Veliš', 74, 88, 36.9, 41.2);
INSERT INTO obce VALUES (3174, 'CZ0522', 'Vidochov', 192, 164, 40.3, 44.5);
INSERT INTO obce VALUES (3175, 'CZ0522', 'Vitiněves', 156, 161, 39.2, 38.6);
INSERT INTO obce VALUES (3176, 'CZ0522', 'Volanice', 117, 130, 37.9, 37.5);
INSERT INTO obce VALUES (3177, 'CZ0522', 'Vrbice', 46, 43, 51.1, 52.6);
INSERT INTO obce VALUES (3178, 'CZ0522', 'Vršce', 121, 119, 33.9, 39.1);
INSERT INTO obce VALUES (3179, 'CZ0522', 'Vřesník', 53, 48, 33.2, 37.5);
INSERT INTO obce VALUES (3180, 'CZ0522', 'Vysoké Veselí', 464, 459, 37.7, 40.3);
INSERT INTO obce VALUES (3181, 'CZ0522', 'Zámostí-Blata', 61, 58, 38.3, 44.9);
INSERT INTO obce VALUES (3182, 'CZ0522', 'Zelenecká Lhota', 79, 71, 40.0, 41.9);
INSERT INTO obce VALUES (3183, 'CZ0522', 'Železnice', 655, 581, 38.0, 42.3);
INSERT INTO obce VALUES (3184, 'CZ0522', 'Žeretice', 139, 133, 42.8, 41.7);
INSERT INTO obce VALUES (3185, 'CZ0522', 'Židovice', 69, 65, 44.4, 42.9);
INSERT INTO obce VALUES (3186, 'CZ0522', 'Žlunice', 119, 120, 41.2, 44.8);
INSERT INTO obce VALUES (3187, 'CZ0523', 'Adršpach', 267, 261, 39.3, 42.0);
INSERT INTO obce VALUES (3188, 'CZ0523', 'Bezděkov nad Metují', 243, 232, 38.9, 42.7);
INSERT INTO obce VALUES (3189, 'CZ0523', 'Bohuslavice', 501, 510, 39.2, 40.5);
INSERT INTO obce VALUES (3190, 'CZ0523', 'Borová', 87, 101, 39.9, 45.7);
INSERT INTO obce VALUES (3191, 'CZ0523', 'Božanov', 190, 171, 36.0, 38.2);
INSERT INTO obce VALUES (3192, 'CZ0523', 'Broumov', 3838, 4139, 38.4, 41.0);
INSERT INTO obce VALUES (3193, 'CZ0523', 'Brzice', 104, 104, 41.1, 45.2);
INSERT INTO obce VALUES (3194, 'CZ0523', 'Bukovice', 202, 180, 39.9, 42.8);
INSERT INTO obce VALUES (3195, 'CZ0523', 'Černčice', 225, 245, 38.8, 40.5);
INSERT INTO obce VALUES (3196, 'CZ0523', 'Červená Hora', 98, 103, 38.2, 40.7);
INSERT INTO obce VALUES (3197, 'CZ0523', 'Červený Kostelec', 4164, 4370, 39.8, 43.3);
INSERT INTO obce VALUES (3198, 'CZ0523', 'Česká Čermná', 231, 243, 40.3, 38.4);
INSERT INTO obce VALUES (3199, 'CZ0523', 'Česká Metuje', 154, 144, 39.6, 39.7);
INSERT INTO obce VALUES (3200, 'CZ0523', 'Česká Skalice', 2521, 2798, 40.1, 42.8);
INSERT INTO obce VALUES (3201, 'CZ0523', 'Dolany', 315, 312, 40.5, 43.3);
INSERT INTO obce VALUES (3202, 'CZ0523', 'Dolní Radechová', 367, 392, 39.6, 42.9);
INSERT INTO obce VALUES (3203, 'CZ0523', 'Hejtmánkovice', 312, 350, 39.6, 41.8);
INSERT INTO obce VALUES (3204, 'CZ0523', 'Heřmanice', 192, 192, 36.0, 38.7);
INSERT INTO obce VALUES (3205, 'CZ0523', 'Heřmánkovice', 253, 236, 39.8, 40.4);
INSERT INTO obce VALUES (3206, 'CZ0523', 'Horní Radechová', 239, 233, 37.1, 39.8);
INSERT INTO obce VALUES (3207, 'CZ0523', 'Hořenice', 91, 86, 40.4, 43.7);
INSERT INTO obce VALUES (3208, 'CZ0523', 'Hořičky', 262, 255, 39.3, 41.1);
INSERT INTO obce VALUES (3209, 'CZ0523', 'Hronov', 3032, 3188, 41.0, 44.2);
INSERT INTO obce VALUES (3210, 'CZ0523', 'Hynčice', 95, 95, 37.7, 44.6);
INSERT INTO obce VALUES (3211, 'CZ0523', 'Chvalkovice', 356, 319, 38.8, 43.9);
INSERT INTO obce VALUES (3212, 'CZ0523', 'Jaroměř', 6221, 6549, 38.2, 41.4);
INSERT INTO obce VALUES (3213, 'CZ0523', 'Jasenná', 357, 375, 38.7, 40.9);
INSERT INTO obce VALUES (3214, 'CZ0523', 'Jestřebí', 85, 82, 41.7, 45.7);
INSERT INTO obce VALUES (3215, 'CZ0523', 'Jetřichov', 238, 190, 37.2, 43.1);
INSERT INTO obce VALUES (3216, 'CZ0523', 'Kramolna', 548, 520, 37.8, 40.0);
INSERT INTO obce VALUES (3217, 'CZ0523', 'Křinice', 202, 187, 37.0, 41.7);
INSERT INTO obce VALUES (3218, 'CZ0523', 'Lhota pod Hořičkami', 124, 129, 36.7, 41.4);
INSERT INTO obce VALUES (3219, 'CZ0523', 'Libchyně', 34, 38, 41.2, 39.5);
INSERT INTO obce VALUES (3220, 'CZ0523', 'Litoboř', 54, 46, 43.8, 42.3);
INSERT INTO obce VALUES (3221, 'CZ0523', 'Machov', 582, 575, 41.1, 43.1);
INSERT INTO obce VALUES (3222, 'CZ0523', 'Martínkovice', 271, 253, 40.5, 42.4);
INSERT INTO obce VALUES (3223, 'CZ0523', 'Mezilečí', 72, 85, 43.5, 39.2);
INSERT INTO obce VALUES (3224, 'CZ0523', 'Mezilesí', 110, 102, 39.8, 45.8);
INSERT INTO obce VALUES (3225, 'CZ0523', 'Meziměstí', 1357, 1343, 39.7, 44.0);
INSERT INTO obce VALUES (3226, 'CZ0523', 'Nahořany', 251, 265, 39.4, 41.7);
INSERT INTO obce VALUES (3227, 'CZ0523', 'Náchod', 9941, 10819, 39.3, 43.3);
INSERT INTO obce VALUES (3228, 'CZ0523', 'Nové Město nad Metují', 4760, 5118, 40.8, 43.3);
INSERT INTO obce VALUES (3229, 'CZ0523', 'Nový Hrádek', 370, 390, 39.2, 37.8);
INSERT INTO obce VALUES (3230, 'CZ0523', 'Nový Ples', 159, 156, 38.4, 40.9);
INSERT INTO obce VALUES (3231, 'CZ0523', 'Otovice', 187, 194, 40.7, 41.1);
INSERT INTO obce VALUES (3232, 'CZ0523', 'Police nad Metují', 2099, 2188, 40.1, 43.7);
INSERT INTO obce VALUES (3233, 'CZ0523', 'Provodov-Šonov', 588, 569, 36.9, 40.0);
INSERT INTO obce VALUES (3234, 'CZ0523', 'Přibyslav', 87, 95, 39.2, 38.7);
INSERT INTO obce VALUES (3235, 'CZ0523', 'Rasošky', 309, 301, 38.8, 39.8);
INSERT INTO obce VALUES (3236, 'CZ0523', 'Rožnov', 195, 197, 38.3, 43.7);
INSERT INTO obce VALUES (3237, 'CZ0523', 'Rychnovek', 296, 294, 39.4, 40.2);
INSERT INTO obce VALUES (3238, 'CZ0523', 'Říkov', 82, 109, 39.8, 40.1);
INSERT INTO obce VALUES (3239, 'CZ0523', 'Sendraž', 50, 41, 43.0, 49.5);
INSERT INTO obce VALUES (3240, 'CZ0523', 'Slatina nad Úpou', 146, 146, 42.7, 41.9);
INSERT INTO obce VALUES (3241, 'CZ0523', 'Slavětín nad Metují', 119, 115, 40.2, 42.2);
INSERT INTO obce VALUES (3242, 'CZ0523', 'Slavoňov', 144, 149, 39.4, 38.0);
INSERT INTO obce VALUES (3243, 'CZ0523', 'Stárkov', 343, 307, 42.2, 46.7);
INSERT INTO obce VALUES (3244, 'CZ0523', 'Studnice', 549, 531, 37.9, 40.0);
INSERT INTO obce VALUES (3245, 'CZ0523', 'Suchý Důl', 237, 192, 36.1, 42.9);
INSERT INTO obce VALUES (3246, 'CZ0523', 'Šestajovice', 96, 82, 38.4, 45.8);
INSERT INTO obce VALUES (3247, 'CZ0523', 'Šonov', 143, 175, 36.2, 36.2);
INSERT INTO obce VALUES (3248, 'CZ0523', 'Teplice nad Metují', 882, 881, 40.9, 43.6);
INSERT INTO obce VALUES (3249, 'CZ0523', 'Velichovky', 377, 377, 39.3, 40.8);
INSERT INTO obce VALUES (3250, 'CZ0523', 'Velká Jesenice', 378, 374, 39.0, 40.7);
INSERT INTO obce VALUES (3251, 'CZ0523', 'Velké Petrovice', 177, 183, 39.6, 42.2);
INSERT INTO obce VALUES (3252, 'CZ0523', 'Velké Poříčí', 1194, 1256, 39.2, 41.3);
INSERT INTO obce VALUES (3253, 'CZ0523', 'Velký Třebešov', 163, 169, 37.9, 41.1);
INSERT INTO obce VALUES (3254, 'CZ0523', 'Vernéřovice', 189, 177, 37.9, 40.2);
INSERT INTO obce VALUES (3255, 'CZ0523', 'Vestec', 65, 82, 37.4, 41.5);
INSERT INTO obce VALUES (3256, 'CZ0523', 'Vlkov', 201, 191, 37.4, 40.5);
INSERT INTO obce VALUES (3257, 'CZ0523', 'Vršovka', 49, 59, 42.9, 39.5);
INSERT INTO obce VALUES (3258, 'CZ0523', 'Vysoká Srbská', 125, 127, 39.9, 42.8);
INSERT INTO obce VALUES (3259, 'CZ0523', 'Vysokov', 240, 211, 38.9, 42.2);
INSERT INTO obce VALUES (3260, 'CZ0523', 'Zábrodí', 224, 221, 39.9, 41.4);
INSERT INTO obce VALUES (3261, 'CZ0523', 'Zaloňov', 228, 210, 37.1, 39.8);
INSERT INTO obce VALUES (3262, 'CZ0523', 'Žďár nad Metují', 309, 319, 36.6, 39.6);
INSERT INTO obce VALUES (3263, 'CZ0523', 'Žďárky', 274, 285, 40.0, 41.0);
INSERT INTO obce VALUES (3264, 'CZ0523', 'Žernov', 126, 108, 37.9, 40.7);
INSERT INTO obce VALUES (3265, 'CZ0524', 'Albrechtice nad Orlicí', 489, 542, 41.8, 46.1);
INSERT INTO obce VALUES (3266, 'CZ0524', 'Bačetín', 216, 195, 36.6, 43.9);
INSERT INTO obce VALUES (3267, 'CZ0524', 'Bartošovice v Orlických horách', 112, 90, 37.4, 38.7);
INSERT INTO obce VALUES (3268, 'CZ0524', 'Bílý Újezd', 325, 288, 38.8, 43.3);
INSERT INTO obce VALUES (3269, 'CZ0524', 'Bohdašín', 113, 129, 41.5, 48.8);
INSERT INTO obce VALUES (3270, 'CZ0524', 'Bolehošť', 286, 263, 41.3, 44.1);
INSERT INTO obce VALUES (3271, 'CZ0524', 'Borohrádek', 1046, 1075, 40.4, 44.1);
INSERT INTO obce VALUES (3272, 'CZ0524', 'Borovnice', 198, 183, 37.7, 43.7);
INSERT INTO obce VALUES (3273, 'CZ0524', 'Bystré', 147, 124, 38.4, 41.4);
INSERT INTO obce VALUES (3274, 'CZ0524', 'Byzhradec', 96, 95, 38.7, 46.8);
INSERT INTO obce VALUES (3275, 'CZ0524', 'Častolovice', 850, 817, 38.9, 40.7);
INSERT INTO obce VALUES (3276, 'CZ0524', 'Čermná nad Orlicí', 530, 510, 39.7, 42.4);
INSERT INTO obce VALUES (3277, 'CZ0524', 'Černíkovice', 344, 338, 40.1, 42.6);
INSERT INTO obce VALUES (3278, 'CZ0524', 'České Meziříčí', 860, 927, 36.1, 38.8);
INSERT INTO obce VALUES (3279, 'CZ0524', 'Čestice', 282, 283, 37.5, 38.9);
INSERT INTO obce VALUES (3280, 'CZ0524', 'Deštné v Orlických horách', 297, 300, 40.2, 41.9);
INSERT INTO obce VALUES (3281, 'CZ0524', 'Dobré', 408, 395, 38.6, 41.6);
INSERT INTO obce VALUES (3282, 'CZ0524', 'Dobruška', 3358, 3558, 39.6, 42.0);
INSERT INTO obce VALUES (3283, 'CZ0524', 'Dobřany', 64, 64, 37.8, 38.9);
INSERT INTO obce VALUES (3284, 'CZ0524', 'Doudleby nad Orlicí', 939, 959, 39.4, 41.6);
INSERT INTO obce VALUES (3285, 'CZ0524', 'Hřibiny-Ledská', 189, 183, 39.1, 40.8);
INSERT INTO obce VALUES (3286, 'CZ0524', 'Chleny', 110, 126, 38.7, 40.4);
INSERT INTO obce VALUES (3287, 'CZ0524', 'Chlístov', 44, 39, 42.1, 44.6);
INSERT INTO obce VALUES (3288, 'CZ0524', 'Jahodov', 45, 46, 37.5, 38.2);
INSERT INTO obce VALUES (3289, 'CZ0524', 'Janov', 60, 57, 36.0, 45.0);
INSERT INTO obce VALUES (3290, 'CZ0524', 'Javornice', 483, 442, 37.9, 40.9);
INSERT INTO obce VALUES (3291, 'CZ0524', 'Kostelec nad Orlicí', 3014, 3223, 39.9, 42.6);
INSERT INTO obce VALUES (3292, 'CZ0524', 'Kostelecké Horky', 67, 72, 43.1, 41.8);
INSERT INTO obce VALUES (3293, 'CZ0524', 'Kounov', 129, 109, 38.6, 41.6);
INSERT INTO obce VALUES (3294, 'CZ0524', 'Králova Lhota', 108, 103, 40.2, 35.9);
INSERT INTO obce VALUES (3295, 'CZ0524', 'Krchleby', 51, 39, 38.1, 38.5);
INSERT INTO obce VALUES (3296, 'CZ0524', 'Kvasiny', 724, 657, 38.5, 41.5);
INSERT INTO obce VALUES (3297, 'CZ0524', 'Lhoty u Potštejna', 147, 144, 38.0, 41.5);
INSERT INTO obce VALUES (3298, 'CZ0524', 'Libel', 59, 59, 37.2, 39.0);
INSERT INTO obce VALUES (3299, 'CZ0524', 'Liberk', 361, 337, 36.9, 38.6);
INSERT INTO obce VALUES (3300, 'CZ0524', 'Lično', 331, 299, 38.5, 41.7);
INSERT INTO obce VALUES (3301, 'CZ0524', 'Lípa nad Orlicí', 264, 249, 39.6, 39.8);
INSERT INTO obce VALUES (3302, 'CZ0524', 'Lukavice', 317, 279, 37.8, 41.5);
INSERT INTO obce VALUES (3303, 'CZ0524', 'Lupenice', 134, 124, 40.3, 40.1);
INSERT INTO obce VALUES (3304, 'CZ0524', 'Mokré', 78, 69, 39.9, 42.5);
INSERT INTO obce VALUES (3305, 'CZ0524', 'Nová Ves', 64, 72, 46.0, 42.9);
INSERT INTO obce VALUES (3306, 'CZ0524', 'Očelice', 131, 121, 37.2, 40.7);
INSERT INTO obce VALUES (3307, 'CZ0524', 'Ohnišov', 237, 247, 41.5, 42.8);
INSERT INTO obce VALUES (3308, 'CZ0524', 'Olešnice', 221, 224, 38.7, 38.6);
INSERT INTO obce VALUES (3309, 'CZ0524', 'Olešnice v Orlických horách', 234, 240, 37.1, 43.4);
INSERT INTO obce VALUES (3310, 'CZ0524', 'Opočno', 1510, 1618, 39.8, 43.7);
INSERT INTO obce VALUES (3311, 'CZ0524', 'Orlické Záhoří', 109, 87, 36.7, 40.5);
INSERT INTO obce VALUES (3312, 'CZ0524', 'Osečnice', 146, 146, 38.8, 38.9);
INSERT INTO obce VALUES (3313, 'CZ0524', 'Pěčín', 258, 263, 39.1, 38.9);
INSERT INTO obce VALUES (3314, 'CZ0524', 'Podbřezí', 262, 259, 37.2, 39.8);
INSERT INTO obce VALUES (3315, 'CZ0524', 'Pohoří', 326, 337, 35.7, 39.0);
INSERT INTO obce VALUES (3316, 'CZ0524', 'Polom', 60, 59, 41.4, 39.1);
INSERT INTO obce VALUES (3317, 'CZ0524', 'Potštejn', 439, 451, 41.7, 44.6);
INSERT INTO obce VALUES (3318, 'CZ0524', 'Proruby', 23, 26, 54.2, 46.9);
INSERT INTO obce VALUES (3319, 'CZ0524', 'Přepychy', 274, 318, 38.4, 44.6);
INSERT INTO obce VALUES (3320, 'CZ0524', 'Rohenice', 132, 133, 40.1, 38.9);
INSERT INTO obce VALUES (3321, 'CZ0524', 'Rokytnice v Orlických horách', 1144, 1172, 37.5, 40.2);
INSERT INTO obce VALUES (3322, 'CZ0524', 'Rybná nad Zdobnicí', 213, 212, 39.5, 41.6);
INSERT INTO obce VALUES (3323, 'CZ0524', 'Rychnov nad Kněžnou', 5397, 6069, 38.3, 41.1);
INSERT INTO obce VALUES (3324, 'CZ0524', 'Říčky v Orlických horách', 51, 40, 38.5, 46.3);
INSERT INTO obce VALUES (3325, 'CZ0524', 'Sedloňov', 127, 105, 36.6, 44.8);
INSERT INTO obce VALUES (3326, 'CZ0524', 'Semechnice', 191, 192, 36.8, 42.7);
INSERT INTO obce VALUES (3327, 'CZ0524', 'Skuhrov nad Bělou', 535, 547, 38.8, 41.3);
INSERT INTO obce VALUES (3328, 'CZ0524', 'Slatina nad Zdobnicí', 407, 428, 39.6, 41.6);
INSERT INTO obce VALUES (3329, 'CZ0524', 'Sněžné', 59, 65, 45.0, 48.1);
INSERT INTO obce VALUES (3330, 'CZ0524', 'Solnice', 1202, 1085, 38.4, 41.9);
INSERT INTO obce VALUES (3331, 'CZ0524', 'Svídnice', 96, 88, 39.2, 43.1);
INSERT INTO obce VALUES (3332, 'CZ0524', 'Synkov-Slemeno', 186, 193, 38.5, 41.2);
INSERT INTO obce VALUES (3333, 'CZ0524', 'Trnov', 351, 350, 39.1, 41.9);
INSERT INTO obce VALUES (3334, 'CZ0524', 'Třebešov', 137, 120, 37.7, 37.3);
INSERT INTO obce VALUES (3335, 'CZ0524', 'Tutleky', 179, 184, 37.7, 41.6);
INSERT INTO obce VALUES (3336, 'CZ0524', 'Týniště nad Orlicí', 3096, 3268, 40.2, 42.9);
INSERT INTO obce VALUES (3337, 'CZ0524', 'Val', 136, 146, 41.1, 43.2);
INSERT INTO obce VALUES (3338, 'CZ0524', 'Vamberk', 2344, 2354, 39.3, 43.0);
INSERT INTO obce VALUES (3339, 'CZ0524', 'Voděrady', 331, 343, 38.4, 41.5);
INSERT INTO obce VALUES (3340, 'CZ0524', 'Vrbice', 58, 68, 41.6, 45.3);
INSERT INTO obce VALUES (3341, 'CZ0524', 'Záměl', 332, 316, 39.7, 43.2);
INSERT INTO obce VALUES (3342, 'CZ0524', 'Zdelov', 116, 109, 36.2, 40.4);
INSERT INTO obce VALUES (3343, 'CZ0524', 'Zdobnice', 87, 72, 38.7, 42.2);
INSERT INTO obce VALUES (3344, 'CZ0524', 'Žďár nad Orlicí', 215, 229, 37.9, 40.7);
INSERT INTO obce VALUES (3345, 'CZ0525', 'Batňovice', 386, 362, 39.4, 43.5);
INSERT INTO obce VALUES (3346, 'CZ0525', 'Bernartice', 459, 429, 39.2, 40.7);
INSERT INTO obce VALUES (3347, 'CZ0525', 'Bílá Třemešná', 675, 664, 39.1, 42.2);
INSERT INTO obce VALUES (3348, 'CZ0525', 'Bílé Poličany', 74, 69, 44.0, 44.4);
INSERT INTO obce VALUES (3349, 'CZ0525', 'Borovnice', 213, 204, 39.5, 44.3);
INSERT INTO obce VALUES (3350, 'CZ0525', 'Borovnička', 99, 96, 36.7, 46.8);
INSERT INTO obce VALUES (3351, 'CZ0525', 'Čermná', 209, 178, 37.9, 42.0);
INSERT INTO obce VALUES (3352, 'CZ0525', 'Černý Důl', 390, 367, 38.9, 44.0);
INSERT INTO obce VALUES (3353, 'CZ0525', 'Dolní Branná', 503, 467, 39.1, 39.7);
INSERT INTO obce VALUES (3354, 'CZ0525', 'Dolní Brusnice', 191, 181, 37.9, 38.8);
INSERT INTO obce VALUES (3355, 'CZ0525', 'Dolní Dvůr', 130, 116, 39.4, 37.4);
INSERT INTO obce VALUES (3356, 'CZ0525', 'Dolní Kalná', 334, 329, 38.4, 40.8);
INSERT INTO obce VALUES (3357, 'CZ0525', 'Dolní Lánov', 369, 358, 38.5, 39.5);
INSERT INTO obce VALUES (3358, 'CZ0525', 'Dolní Olešnice', 197, 172, 37.5, 39.4);
INSERT INTO obce VALUES (3359, 'CZ0525', 'Doubravice', 191, 191, 43.1, 44.3);
INSERT INTO obce VALUES (3360, 'CZ0525', 'Dubenec', 356, 356, 37.3, 40.0);
INSERT INTO obce VALUES (3361, 'CZ0525', 'Dvůr Králové nad Labem', 7810, 8335, 40.0, 43.6);
INSERT INTO obce VALUES (3362, 'CZ0525', 'Hajnice', 491, 469, 37.6, 37.9);
INSERT INTO obce VALUES (3363, 'CZ0525', 'Havlovice', 462, 456, 40.0, 40.3);
INSERT INTO obce VALUES (3364, 'CZ0525', 'Horní Brusnice', 232, 215, 41.3, 42.7);
INSERT INTO obce VALUES (3365, 'CZ0525', 'Horní Kalná', 163, 177, 39.4, 43.0);
INSERT INTO obce VALUES (3366, 'CZ0525', 'Horní Maršov', 572, 538, 40.3, 40.6);
INSERT INTO obce VALUES (3367, 'CZ0525', 'Horní Olešnice', 150, 138, 38.9, 43.5);
INSERT INTO obce VALUES (3368, 'CZ0525', 'Hostinné', 2293, 2430, 38.9, 41.4);
INSERT INTO obce VALUES (3369, 'CZ0525', 'Hřibojedy', 101, 104, 39.9, 41.0);
INSERT INTO obce VALUES (3370, 'CZ0525', 'Chotěvice', 497, 540, 38.7, 40.7);
INSERT INTO obce VALUES (3371, 'CZ0525', 'Choustníkovo Hradiště', 278, 301, 40.2, 42.3);
INSERT INTO obce VALUES (3372, 'CZ0525', 'Chvaleč', 301, 300, 38.3, 41.1);
INSERT INTO obce VALUES (3373, 'CZ0525', 'Janské Lázně', 406, 411, 38.3, 43.1);
INSERT INTO obce VALUES (3374, 'CZ0525', 'Jívka', 298, 292, 41.2, 43.3);
INSERT INTO obce VALUES (3375, 'CZ0525', 'Klášterská Lhota', 100, 103, 41.2, 44.4);
INSERT INTO obce VALUES (3376, 'CZ0525', 'Kocbeře', 266, 261, 38.5, 40.2);
INSERT INTO obce VALUES (3377, 'CZ0525', 'Kohoutov', 149, 133, 39.2, 40.8);
INSERT INTO obce VALUES (3378, 'CZ0525', 'Královec', 99, 83, 35.4, 43.2);
INSERT INTO obce VALUES (3379, 'CZ0525', 'Kuks', 128, 130, 37.4, 38.8);
INSERT INTO obce VALUES (3380, 'CZ0525', 'Kunčice nad Labem', 314, 263, 39.6, 41.6);
INSERT INTO obce VALUES (3381, 'CZ0525', 'Lampertice', 232, 237, 40.0, 42.7);
INSERT INTO obce VALUES (3382, 'CZ0525', 'Lánov', 841, 827, 36.9, 39.7);
INSERT INTO obce VALUES (3383, 'CZ0525', 'Lanžov', 89, 105, 43.8, 41.9);
INSERT INTO obce VALUES (3384, 'CZ0525', 'Libňatov', 178, 183, 41.4, 44.2);
INSERT INTO obce VALUES (3385, 'CZ0525', 'Libotov', 90, 96, 37.7, 41.5);
INSERT INTO obce VALUES (3386, 'CZ0525', 'Litíč', 62, 76, 36.7, 33.9);
INSERT INTO obce VALUES (3387, 'CZ0525', 'Malá Úpa', 80, 66, 35.1, 36.8);
INSERT INTO obce VALUES (3388, 'CZ0525', 'Malé Svatoňovice', 761, 782, 40.1, 43.9);
INSERT INTO obce VALUES (3389, 'CZ0525', 'Maršov u Úpice', 79, 84, 38.9, 44.4);
INSERT INTO obce VALUES (3390, 'CZ0525', 'Mladé Buky', 1131, 1102, 36.8, 41.0);
INSERT INTO obce VALUES (3391, 'CZ0525', 'Mostek', 688, 685, 41.2, 44.5);
INSERT INTO obce VALUES (3392, 'CZ0525', 'Nemojov', 304, 320, 39.2, 40.8);
INSERT INTO obce VALUES (3393, 'CZ0525', 'Pec pod Sněžkou', 322, 300, 40.6, 42.0);
INSERT INTO obce VALUES (3394, 'CZ0525', 'Pilníkov', 628, 572, 36.9, 42.9);
INSERT INTO obce VALUES (3395, 'CZ0525', 'Prosečné', 275, 267, 38.4, 40.4);
INSERT INTO obce VALUES (3396, 'CZ0525', 'Radvanice', 505, 553, 36.5, 39.2);
INSERT INTO obce VALUES (3397, 'CZ0525', 'Rtyně v Podkrkonoší', 1523, 1513, 39.9, 44.0);
INSERT INTO obce VALUES (3398, 'CZ0525', 'Rudník', 1139, 1085, 37.8, 41.6);
INSERT INTO obce VALUES (3399, 'CZ0525', 'Stanovice', 36, 33, 43.8, 44.8);
INSERT INTO obce VALUES (3400, 'CZ0525', 'Staré Buky', 244, 214, 36.9, 42.7);
INSERT INTO obce VALUES (3401, 'CZ0525', 'Strážné', 79, 81, 37.9, 37.7);
INSERT INTO obce VALUES (3402, 'CZ0525', 'Suchovršice', 173, 187, 39.3, 43.0);
INSERT INTO obce VALUES (3403, 'CZ0525', 'Svoboda nad Úpou', 1063, 1074, 40.8, 44.4);
INSERT INTO obce VALUES (3404, 'CZ0525', 'Špindlerův Mlýn', 573, 625, 39.3, 42.9);
INSERT INTO obce VALUES (3405, 'CZ0525', 'Trotina', 41, 29, 42.7, 43.3);
INSERT INTO obce VALUES (3406, 'CZ0525', 'Trutnov', 15012, 15993, 38.8, 42.4);
INSERT INTO obce VALUES (3407, 'CZ0525', 'Třebihošť', 210, 201, 40.6, 42.3);
INSERT INTO obce VALUES (3408, 'CZ0525', 'Úpice', 2859, 3098, 39.4, 42.2);
INSERT INTO obce VALUES (3409, 'CZ0525', 'Velké Svatoňovice', 641, 562, 40.7, 43.4);
INSERT INTO obce VALUES (3410, 'CZ0525', 'Velký Vřešťov', 107, 103, 36.5, 43.3);
INSERT INTO obce VALUES (3411, 'CZ0525', 'Vilantice', 97, 101, 39.6, 43.6);
INSERT INTO obce VALUES (3412, 'CZ0525', 'Vítězná', 640, 637, 37.7, 41.0);
INSERT INTO obce VALUES (3413, 'CZ0525', 'Vlčice', 242, 225, 36.9, 41.7);
INSERT INTO obce VALUES (3414, 'CZ0525', 'Vlčkovice v Podkrkonoší', 219, 209, 37.2, 41.3);
INSERT INTO obce VALUES (3415, 'CZ0525', 'Vrchlabí', 6127, 6583, 39.5, 42.9);
INSERT INTO obce VALUES (3416, 'CZ0525', 'Zábřezí-Řečice', 71, 78, 42.1, 39.0);
INSERT INTO obce VALUES (3417, 'CZ0525', 'Zdobín', 48, 57, 37.6, 44.7);
INSERT INTO obce VALUES (3418, 'CZ0525', 'Zlatá Olešnice', 92, 92, 36.2, 39.8);
INSERT INTO obce VALUES (3419, 'CZ0525', 'Žacléř', 1702, 1851, 39.9, 42.2);
INSERT INTO obce VALUES (3420, 'CZ0531', 'Běstvina', 267, 254, 40.2, 43.7);
INSERT INTO obce VALUES (3421, 'CZ0531', 'Biskupice', 16, 31, 33.1, 37.6);
INSERT INTO obce VALUES (3422, 'CZ0531', 'Bítovany', 205, 209, 39.8, 43.1);
INSERT INTO obce VALUES (3423, 'CZ0531', 'Bojanov', 323, 323, 42.1, 47.2);
INSERT INTO obce VALUES (3424, 'CZ0531', 'Bor u Skutče', 88, 82, 39.0, 44.5);
INSERT INTO obce VALUES (3425, 'CZ0531', 'Bořice', 95, 78, 41.5, 44.3);
INSERT INTO obce VALUES (3426, 'CZ0531', 'Bousov', 109, 108, 40.0, 43.1);
INSERT INTO obce VALUES (3427, 'CZ0531', 'Bylany', 222, 178, 34.3, 38.9);
INSERT INTO obce VALUES (3428, 'CZ0531', 'Ctětín', 132, 132, 42.6, 49.1);
INSERT INTO obce VALUES (3429, 'CZ0531', 'Čankovice', 164, 152, 38.8, 39.9);
INSERT INTO obce VALUES (3430, 'CZ0531', 'České Lhotice', 50, 50, 46.2, 43.2);
INSERT INTO obce VALUES (3431, 'CZ0531', 'Dědová', 83, 73, 40.2, 44.9);
INSERT INTO obce VALUES (3432, 'CZ0531', 'Dolní Bezděkov', 96, 106, 39.1, 40.0);
INSERT INTO obce VALUES (3433, 'CZ0531', 'Dřenice', 153, 182, 39.0, 41.0);
INSERT INTO obce VALUES (3434, 'CZ0531', 'Dvakačovice', 103, 82, 39.6, 42.0);
INSERT INTO obce VALUES (3435, 'CZ0531', 'Hamry', 123, 132, 42.3, 43.3);
INSERT INTO obce VALUES (3436, 'CZ0531', 'Heřmanův Městec', 2378, 2614, 40.1, 43.1);
INSERT INTO obce VALUES (3437, 'CZ0531', 'Hlinsko', 4990, 5215, 39.2, 43.3);
INSERT INTO obce VALUES (3438, 'CZ0531', 'Hluboká', 114, 105, 40.1, 45.0);
INSERT INTO obce VALUES (3439, 'CZ0531', 'Hodonín', 46, 47, 39.5, 36.5);
INSERT INTO obce VALUES (3440, 'CZ0531', 'Holetín', 403, 364, 38.4, 43.0);
INSERT INTO obce VALUES (3441, 'CZ0531', 'Honbice', 103, 85, 40.1, 42.3);
INSERT INTO obce VALUES (3442, 'CZ0531', 'Horka', 191, 209, 41.1, 44.8);
INSERT INTO obce VALUES (3443, 'CZ0531', 'Horní Bradlo', 240, 229, 42.1, 45.6);
INSERT INTO obce VALUES (3444, 'CZ0531', 'Hošťalovice', 71, 63, 44.2, 46.5);
INSERT INTO obce VALUES (3445, 'CZ0531', 'Hrochův Týnec', 973, 957, 38.9, 40.6);
INSERT INTO obce VALUES (3446, 'CZ0531', 'Hroubovice', 175, 188, 41.1, 41.6);
INSERT INTO obce VALUES (3447, 'CZ0531', 'Chrast', 1558, 1644, 38.7, 42.9);
INSERT INTO obce VALUES (3448, 'CZ0531', 'Chroustovice', 617, 651, 38.9, 41.0);
INSERT INTO obce VALUES (3449, 'CZ0531', 'Chrudim', 11307, 12016, 38.8, 42.1);
INSERT INTO obce VALUES (3450, 'CZ0531', 'Jeníkov', 236, 263, 34.7, 37.1);
INSERT INTO obce VALUES (3451, 'CZ0531', 'Jenišovice', 217, 201, 41.0, 42.0);
INSERT INTO obce VALUES (3452, 'CZ0531', 'Kameničky', 407, 397, 37.4, 39.4);
INSERT INTO obce VALUES (3453, 'CZ0531', 'Kladno', 113, 121, 36.7, 42.8);
INSERT INTO obce VALUES (3454, 'CZ0531', 'Klešice', 191, 187, 34.8, 37.7);
INSERT INTO obce VALUES (3455, 'CZ0531', 'Kněžice', 80, 77, 40.3, 45.3);
INSERT INTO obce VALUES (3456, 'CZ0531', 'Kočí', 298, 305, 39.8, 39.2);
INSERT INTO obce VALUES (3457, 'CZ0531', 'Kostelec u Heřmanova Městce', 158, 157, 36.2, 39.1);
INSERT INTO obce VALUES (3458, 'CZ0531', 'Krásné', 75, 76, 40.5, 46.0);
INSERT INTO obce VALUES (3459, 'CZ0531', 'Krouna', 700, 688, 38.7, 41.7);
INSERT INTO obce VALUES (3460, 'CZ0531', 'Křižanovice', 51, 63, 38.2, 43.6);
INSERT INTO obce VALUES (3461, 'CZ0531', 'Lány', 114, 127, 37.4, 39.8);
INSERT INTO obce VALUES (3462, 'CZ0531', 'Leštinka', 70, 71, 41.9, 43.6);
INSERT INTO obce VALUES (3463, 'CZ0531', 'Libkov', 38, 40, 46.8, 44.9);
INSERT INTO obce VALUES (3464, 'CZ0531', 'Liboměřice', 80, 66, 39.0, 45.8);
INSERT INTO obce VALUES (3465, 'CZ0531', 'Licibořice', 105, 123, 37.8, 39.0);
INSERT INTO obce VALUES (3466, 'CZ0531', 'Lipovec', 102, 127, 44.5, 44.4);
INSERT INTO obce VALUES (3467, 'CZ0531', 'Lozice', 87, 72, 37.7, 40.6);
INSERT INTO obce VALUES (3468, 'CZ0531', 'Lukavice', 480, 447, 39.2, 39.2);
INSERT INTO obce VALUES (3469, 'CZ0531', 'Luže', 1286, 1317, 39.3, 42.2);
INSERT INTO obce VALUES (3470, 'CZ0531', 'Míčov-Sušice', 150, 120, 43.1, 48.0);
INSERT INTO obce VALUES (3471, 'CZ0531', 'Miřetice', 622, 611, 39.0, 41.8);
INSERT INTO obce VALUES (3472, 'CZ0531', 'Mladoňovice', 171, 154, 39.6, 43.7);
INSERT INTO obce VALUES (3473, 'CZ0531', 'Morašice', 308, 307, 39.5, 42.9);
INSERT INTO obce VALUES (3474, 'CZ0531', 'Mrákotín', 181, 183, 36.3, 40.7);
INSERT INTO obce VALUES (3475, 'CZ0531', 'Nabočany', 54, 71, 37.7, 36.1);
INSERT INTO obce VALUES (3476, 'CZ0531', 'Načešice', 277, 280, 39.0, 41.1);
INSERT INTO obce VALUES (3477, 'CZ0531', 'Nasavrky', 819, 832, 39.1, 41.7);
INSERT INTO obce VALUES (3478, 'CZ0531', 'Orel', 367, 348, 38.9, 43.2);
INSERT INTO obce VALUES (3479, 'CZ0531', 'Ostrov', 90, 89, 34.8, 39.4);
INSERT INTO obce VALUES (3480, 'CZ0531', 'Otradov', 146, 127, 39.5, 47.2);
INSERT INTO obce VALUES (3481, 'CZ0531', 'Perálec', 127, 118, 37.8, 43.2);
INSERT INTO obce VALUES (3482, 'CZ0531', 'Podhořany u Ronova', 130, 137, 45.0, 47.5);
INSERT INTO obce VALUES (3483, 'CZ0531', 'Pokřikov', 128, 132, 39.0, 40.8);
INSERT INTO obce VALUES (3484, 'CZ0531', 'Prachovice', 743, 717, 36.7, 39.6);
INSERT INTO obce VALUES (3485, 'CZ0531', 'Proseč', 1069, 1098, 38.6, 41.3);
INSERT INTO obce VALUES (3486, 'CZ0531', 'Prosetín', 392, 408, 37.5, 41.2);
INSERT INTO obce VALUES (3487, 'CZ0531', 'Předhradí', 218, 214, 42.3, 42.5);
INSERT INTO obce VALUES (3488, 'CZ0531', 'Přestavlky', 116, 93, 36.4, 42.4);
INSERT INTO obce VALUES (3489, 'CZ0531', 'Rabštejnská Lhota', 340, 365, 36.8, 37.4);
INSERT INTO obce VALUES (3490, 'CZ0531', 'Raná', 200, 176, 40.0, 41.2);
INSERT INTO obce VALUES (3491, 'CZ0531', 'Ronov nad Doubravou', 855, 889, 39.7, 41.6);
INSERT INTO obce VALUES (3492, 'CZ0531', 'Rosice', 677, 704, 37.0, 40.6);
INSERT INTO obce VALUES (3493, 'CZ0531', 'Rozhovice', 132, 131, 40.3, 40.7);
INSERT INTO obce VALUES (3494, 'CZ0531', 'Řestoky', 242, 232, 38.4, 42.1);
INSERT INTO obce VALUES (3495, 'CZ0531', 'Seč', 844, 814, 39.7, 45.9);
INSERT INTO obce VALUES (3496, 'CZ0531', 'Skuteč', 2595, 2705, 38.5, 42.2);
INSERT INTO obce VALUES (3497, 'CZ0531', 'Slatiňany', 2014, 2094, 40.1, 41.9);
INSERT INTO obce VALUES (3498, 'CZ0531', 'Smrček', 58, 52, 41.5, 42.4);
INSERT INTO obce VALUES (3499, 'CZ0531', 'Sobětuchy', 416, 347, 36.1, 37.4);
INSERT INTO obce VALUES (3500, 'CZ0531', 'Stolany', 191, 188, 38.5, 39.1);
INSERT INTO obce VALUES (3501, 'CZ0531', 'Střemošice', 86, 101, 44.1, 46.5);
INSERT INTO obce VALUES (3502, 'CZ0531', 'Studnice', 231, 229, 39.8, 43.6);
INSERT INTO obce VALUES (3503, 'CZ0531', 'Svídnice', 220, 202, 40.0, 43.0);
INSERT INTO obce VALUES (3504, 'CZ0531', 'Svratouch', 428, 466, 39.5, 42.3);
INSERT INTO obce VALUES (3505, 'CZ0531', 'Tisovec', 150, 155, 39.4, 43.3);
INSERT INTO obce VALUES (3506, 'CZ0531', 'Trhová Kamenice', 448, 441, 38.6, 41.5);
INSERT INTO obce VALUES (3507, 'CZ0531', 'Trojovice', 87, 99, 39.2, 42.0);
INSERT INTO obce VALUES (3508, 'CZ0531', 'Třemošnice', 1618, 1542, 38.4, 42.8);
INSERT INTO obce VALUES (3509, 'CZ0531', 'Třibřichy', 140, 147, 40.5, 42.2);
INSERT INTO obce VALUES (3510, 'CZ0531', 'Tuněchody', 282, 308, 38.8, 41.3);
INSERT INTO obce VALUES (3511, 'CZ0531', 'Úherčice', 64, 56, 44.4, 47.5);
INSERT INTO obce VALUES (3512, 'CZ0531', 'Úhřetice', 227, 256, 40.7, 42.0);
INSERT INTO obce VALUES (3513, 'CZ0531', 'Vápenný Podol', 105, 111, 41.7, 41.0);
INSERT INTO obce VALUES (3514, 'CZ0531', 'Včelákov', 285, 273, 39.8, 43.6);
INSERT INTO obce VALUES (3515, 'CZ0531', 'Vejvanovice', 164, 139, 37.3, 42.1);
INSERT INTO obce VALUES (3516, 'CZ0531', 'Vítanov', 213, 226, 39.7, 43.0);
INSERT INTO obce VALUES (3517, 'CZ0531', 'Vojtěchov', 204, 206, 37.6, 43.5);
INSERT INTO obce VALUES (3518, 'CZ0531', 'Vortová', 123, 142, 41.5, 42.1);
INSERT INTO obce VALUES (3519, 'CZ0531', 'Vrbatův Kostelec', 173, 148, 43.2, 45.5);
INSERT INTO obce VALUES (3520, 'CZ0531', 'Všeradov', 82, 76, 43.4, 47.6);
INSERT INTO obce VALUES (3521, 'CZ0531', 'Vysočina', 326, 351, 39.7, 41.2);
INSERT INTO obce VALUES (3522, 'CZ0531', 'Vyžice', 76, 95, 44.0, 45.7);
INSERT INTO obce VALUES (3523, 'CZ0531', 'Zaječice', 526, 504, 39.1, 42.5);
INSERT INTO obce VALUES (3524, 'CZ0531', 'Zájezdec', 61, 65, 37.4, 41.3);
INSERT INTO obce VALUES (3525, 'CZ0531', 'Zderaz', 142, 140, 38.1, 41.3);
INSERT INTO obce VALUES (3526, 'CZ0531', 'Žlebské Chvalovice', 40, 41, 50.8, 58.8);
INSERT INTO obce VALUES (3527, 'CZ0531', 'Žumberk', 121, 123, 41.7, 42.4);
INSERT INTO obce VALUES (3528, 'CZ0532', 'Barchov', 99, 86, 37.6, 41.0);
INSERT INTO obce VALUES (3529, 'CZ0532', 'Bezděkov', 138, 123, 38.5, 42.8);
INSERT INTO obce VALUES (3530, 'CZ0532', 'Borek', 124, 118, 35.9, 42.5);
INSERT INTO obce VALUES (3531, 'CZ0532', 'Brloh', 102, 124, 42.9, 45.8);
INSERT INTO obce VALUES (3532, 'CZ0532', 'Břehy', 488, 468, 41.1, 44.3);
INSERT INTO obce VALUES (3533, 'CZ0532', 'Bukovina nad Labem', 107, 110, 37.6, 39.6);
INSERT INTO obce VALUES (3534, 'CZ0532', 'Bukovina u Přelouče', 32, 39, 37.3, 41.2);
INSERT INTO obce VALUES (3535, 'CZ0532', 'Bukovka', 199, 209, 38.9, 41.4);
INSERT INTO obce VALUES (3536, 'CZ0532', 'Býšť', 725, 700, 35.2, 37.3);
INSERT INTO obce VALUES (3537, 'CZ0532', 'Časy', 123, 103, 34.4, 38.5);
INSERT INTO obce VALUES (3538, 'CZ0532', 'Čeperka', 483, 515, 40.5, 40.7);
INSERT INTO obce VALUES (3539, 'CZ0532', 'Čepí', 205, 198, 35.8, 41.1);
INSERT INTO obce VALUES (3540, 'CZ0532', 'Černá u Bohdanče', 134, 151, 39.2, 41.2);
INSERT INTO obce VALUES (3541, 'CZ0532', 'Dašice', 1377, 1244, 37.1, 38.5);
INSERT INTO obce VALUES (3542, 'CZ0532', 'Dolany', 190, 177, 38.5, 43.3);
INSERT INTO obce VALUES (3543, 'CZ0532', 'Dolní Roveň', 988, 999, 37.8, 41.6);
INSERT INTO obce VALUES (3544, 'CZ0532', 'Dolní Ředice', 409, 439, 37.8, 39.6);
INSERT INTO obce VALUES (3545, 'CZ0532', 'Dříteč', 191, 191, 36.4, 36.4);
INSERT INTO obce VALUES (3546, 'CZ0532', 'Dubany', 109, 104, 39.8, 39.6);
INSERT INTO obce VALUES (3547, 'CZ0532', 'Hlavečník', 139, 137, 40.3, 42.1);
INSERT INTO obce VALUES (3548, 'CZ0532', 'Holice', 3170, 3328, 39.1, 42.3);
INSERT INTO obce VALUES (3549, 'CZ0532', 'Holotín', 24, 16, 35.4, 50.3);
INSERT INTO obce VALUES (3550, 'CZ0532', 'Horní Jelení', 962, 1001, 36.8, 41.8);
INSERT INTO obce VALUES (3551, 'CZ0532', 'Horní Ředice', 512, 519, 37.2, 38.0);
INSERT INTO obce VALUES (3552, 'CZ0532', 'Hrobice', 98, 108, 43.8, 40.3);
INSERT INTO obce VALUES (3553, 'CZ0532', 'Choltice', 467, 547, 40.4, 41.7);
INSERT INTO obce VALUES (3554, 'CZ0532', 'Choteč', 159, 160, 36.3, 39.3);
INSERT INTO obce VALUES (3555, 'CZ0532', 'Chrtníky', 40, 43, 37.0, 45.5);
INSERT INTO obce VALUES (3556, 'CZ0532', 'Chvaletice', 1578, 1662, 38.2, 41.7);
INSERT INTO obce VALUES (3557, 'CZ0532', 'Chvojenec', 385, 342, 36.9, 39.6);
INSERT INTO obce VALUES (3558, 'CZ0532', 'Chýšť', 103, 103, 39.1, 41.0);
INSERT INTO obce VALUES (3559, 'CZ0532', 'Jankovice', 141, 153, 42.3, 45.4);
INSERT INTO obce VALUES (3560, 'CZ0532', 'Jaroslav', 113, 122, 37.5, 37.9);
INSERT INTO obce VALUES (3561, 'CZ0532', 'Jedousov', 68, 74, 35.6, 45.5);
INSERT INTO obce VALUES (3562, 'CZ0532', 'Jeníkovice', 124, 113, 37.6, 42.3);
INSERT INTO obce VALUES (3563, 'CZ0532', 'Jezbořice', 168, 182, 40.0, 39.8);
INSERT INTO obce VALUES (3564, 'CZ0532', 'Kasalice', 102, 104, 37.5, 41.8);
INSERT INTO obce VALUES (3565, 'CZ0532', 'Kladruby nad Labem', 299, 339, 40.6, 43.3);
INSERT INTO obce VALUES (3566, 'CZ0532', 'Kojice', 218, 210, 40.9, 45.9);
INSERT INTO obce VALUES (3567, 'CZ0532', 'Kostěnice', 260, 246, 38.0, 42.0);
INSERT INTO obce VALUES (3568, 'CZ0532', 'Křičeň', 120, 110, 41.9, 44.6);
INSERT INTO obce VALUES (3569, 'CZ0532', 'Kunětice', 140, 145, 39.6, 40.9);
INSERT INTO obce VALUES (3570, 'CZ0532', 'Labské Chrčice', 87, 84, 33.3, 35.9);
INSERT INTO obce VALUES (3571, 'CZ0532', 'Lány u Dašic', 76, 72, 38.3, 40.5);
INSERT INTO obce VALUES (3572, 'CZ0532', 'Lázně Bohdaneč', 1691, 1701, 37.2, 40.3);
INSERT INTO obce VALUES (3573, 'CZ0532', 'Libišany', 217, 224, 38.7, 41.9);
INSERT INTO obce VALUES (3574, 'CZ0532', 'Lipoltice', 182, 214, 40.8, 41.0);
INSERT INTO obce VALUES (3575, 'CZ0532', 'Litošice', 73, 58, 39.0, 40.3);
INSERT INTO obce VALUES (3576, 'CZ0532', 'Malé Výkleky', 57, 63, 45.7, 46.4);
INSERT INTO obce VALUES (3577, 'CZ0532', 'Mikulovice', 559, 516, 37.7, 39.4);
INSERT INTO obce VALUES (3578, 'CZ0532', 'Mokošín', 66, 83, 43.2, 44.5);
INSERT INTO obce VALUES (3579, 'CZ0532', 'Morašice', 51, 47, 42.4, 52.3);
INSERT INTO obce VALUES (3580, 'CZ0532', 'Moravany', 874, 925, 42.1, 44.5);
INSERT INTO obce VALUES (3581, 'CZ0532', 'Němčice', 262, 238, 29.7, 33.1);
INSERT INTO obce VALUES (3582, 'CZ0532', 'Neratov', 66, 60, 43.7, 38.1);
INSERT INTO obce VALUES (3583, 'CZ0532', 'Opatovice nad Labem', 1348, 1248, 36.3, 39.4);
INSERT INTO obce VALUES (3584, 'CZ0532', 'Ostřešany', 484, 498, 40.0, 40.8);
INSERT INTO obce VALUES (3585, 'CZ0532', 'Ostřetín', 472, 485, 38.8, 43.4);
INSERT INTO obce VALUES (3586, 'CZ0532', 'Pardubice', 43753, 46324, 40.4, 43.9);
INSERT INTO obce VALUES (3587, 'CZ0532', 'Plch', 49, 47, 35.5, 44.3);
INSERT INTO obce VALUES (3588, 'CZ0532', 'Poběžovice u Holic', 107, 110, 36.9, 40.8);
INSERT INTO obce VALUES (3589, 'CZ0532', 'Poběžovice u Přelouče', 45, 42, 39.4, 43.0);
INSERT INTO obce VALUES (3590, 'CZ0532', 'Podůlšany', 64, 77, 43.0, 42.8);
INSERT INTO obce VALUES (3591, 'CZ0532', 'Pravy', 46, 46, 39.3, 37.3);
INSERT INTO obce VALUES (3592, 'CZ0532', 'Přelouč', 4338, 4413, 40.4, 43.1);
INSERT INTO obce VALUES (3593, 'CZ0532', 'Přelovice', 98, 100, 41.6, 42.4);
INSERT INTO obce VALUES (3594, 'CZ0532', 'Přepychy', 43, 36, 41.4, 50.0);
INSERT INTO obce VALUES (3595, 'CZ0532', 'Ráby', 338, 264, 41.1, 43.3);
INSERT INTO obce VALUES (3596, 'CZ0532', 'Rohovládova Bělá', 252, 270, 38.6, 40.3);
INSERT INTO obce VALUES (3597, 'CZ0532', 'Rohoznice', 131, 122, 45.3, 47.5);
INSERT INTO obce VALUES (3598, 'CZ0532', 'Rokytno', 439, 402, 36.5, 40.1);
INSERT INTO obce VALUES (3599, 'CZ0532', 'Rybitví', 675, 748, 39.5, 43.2);
INSERT INTO obce VALUES (3600, 'CZ0532', 'Řečany nad Labem', 670, 665, 41.9, 44.3);
INSERT INTO obce VALUES (3601, 'CZ0532', 'Selmice', 317, 66, 39.6, 47.8);
INSERT INTO obce VALUES (3602, 'CZ0532', 'Semín', 265, 263, 41.2, 44.1);
INSERT INTO obce VALUES (3603, 'CZ0532', 'Sezemice', 1781, 1780, 37.8, 40.4);
INSERT INTO obce VALUES (3604, 'CZ0532', 'Slepotice', 227, 220, 36.7, 42.2);
INSERT INTO obce VALUES (3606, 'CZ0532', 'Sovolusky', 64, 63, 39.5, 40.5);
INSERT INTO obce VALUES (3607, 'CZ0532', 'Spojil', 230, 219, 37.0, 36.4);
INSERT INTO obce VALUES (3608, 'CZ0532', 'Srch', 655, 665, 36.4, 37.8);
INSERT INTO obce VALUES (3609, 'CZ0532', 'Srnojedy', 327, 316, 34.0, 35.1);
INSERT INTO obce VALUES (3610, 'CZ0532', 'Staré Hradiště', 718, 728, 38.0, 40.8);
INSERT INTO obce VALUES (3611, 'CZ0532', 'Staré Jesenčany', 151, 157, 38.8, 38.7);
INSERT INTO obce VALUES (3612, 'CZ0532', 'Staré Ždánice', 354, 315, 38.7, 43.5);
INSERT INTO obce VALUES (3613, 'CZ0532', 'Starý Mateřov', 260, 245, 35.0, 37.8);
INSERT INTO obce VALUES (3614, 'CZ0532', 'Stéblová', 109, 107, 36.8, 41.8);
INSERT INTO obce VALUES (3615, 'CZ0532', 'Stojice', 110, 105, 41.2, 46.8);
INSERT INTO obce VALUES (3616, 'CZ0532', 'Strašov', 165, 149, 37.5, 42.5);
INSERT INTO obce VALUES (3617, 'CZ0532', 'Svinčany', 221, 191, 37.4, 40.5);
INSERT INTO obce VALUES (3618, 'CZ0532', 'Svojšice', 123, 120, 36.2, 40.0);
INSERT INTO obce VALUES (3619, 'CZ0532', 'Tetov', 94, 78, 43.7, 49.2);
INSERT INTO obce VALUES (3620, 'CZ0532', 'Trnávka', 104, 110, 42.5, 43.9);
INSERT INTO obce VALUES (3621, 'CZ0532', 'Trusnov', 116, 111, 43.4, 43.0);
INSERT INTO obce VALUES (3622, 'CZ0532', 'Třebosice', 89, 88, 36.6, 39.3);
INSERT INTO obce VALUES (3623, 'CZ0532', 'Turkovice', 115, 132, 44.0, 46.7);
INSERT INTO obce VALUES (3624, 'CZ0532', 'Uhersko', 145, 148, 38.8, 41.4);
INSERT INTO obce VALUES (3625, 'CZ0532', 'Úhřetická Lhota', 123, 124, 39.4, 39.2);
INSERT INTO obce VALUES (3626, 'CZ0532', 'Újezd u Přelouče', 80, 115, 40.8, 43.2);
INSERT INTO obce VALUES (3627, 'CZ0532', 'Újezd u Sezemic', 67, 55, 39.1, 47.9);
INSERT INTO obce VALUES (3628, 'CZ0532', 'Urbanice', 39, 29, 45.3, 47.9);
INSERT INTO obce VALUES (3629, 'CZ0532', 'Valy', 233, 237, 41.1, 41.3);
INSERT INTO obce VALUES (3630, 'CZ0532', 'Vápno', 79, 71, 36.6, 39.9);
INSERT INTO obce VALUES (3631, 'CZ0532', 'Veliny', 185, 199, 39.9, 41.2);
INSERT INTO obce VALUES (3632, 'CZ0532', 'Veselí', 171, 176, 41.8, 42.4);
INSERT INTO obce VALUES (3633, 'CZ0532', 'Vlčí Habřina', 137, 152, 44.5, 43.3);
INSERT INTO obce VALUES (3634, 'CZ0532', 'Voleč', 153, 167, 41.4, 44.2);
INSERT INTO obce VALUES (3635, 'CZ0532', 'Vysoké Chvojno', 177, 176, 43.3, 45.6);
INSERT INTO obce VALUES (3636, 'CZ0532', 'Vyšehněvice', 104, 104, 40.6, 47.1);
INSERT INTO obce VALUES (3637, 'CZ0532', 'Zdechovice', 330, 297, 38.6, 41.2);
INSERT INTO obce VALUES (3638, 'CZ0532', 'Žáravice', 75, 67, 42.0, 45.2);
INSERT INTO obce VALUES (3639, 'CZ0532', 'Živanice', 446, 453, 39.3, 41.4);
INSERT INTO obce VALUES (3640, 'CZ0533', 'Banín', 149, 164, 38.6, 42.6);
INSERT INTO obce VALUES (3641, 'CZ0533', 'Bělá nad Svitavou', 263, 258, 39.8, 42.1);
INSERT INTO obce VALUES (3642, 'CZ0533', 'Bělá u Jevíčka', 174, 184, 42.9, 46.3);
INSERT INTO obce VALUES (3643, 'CZ0533', 'Benátky', 166, 196, 36.1, 36.8);
INSERT INTO obce VALUES (3644, 'CZ0533', 'Bezděčí u Trnávky', 110, 119, 40.0, 42.8);
INSERT INTO obce VALUES (3645, 'CZ0533', 'Biskupice', 227, 214, 39.0, 40.7);
INSERT INTO obce VALUES (3646, 'CZ0533', 'Bohuňov', 94, 82, 46.0, 47.8);
INSERT INTO obce VALUES (3647, 'CZ0533', 'Bohuňovice', 52, 61, 38.3, 43.3);
INSERT INTO obce VALUES (3648, 'CZ0533', 'Borová', 477, 503, 37.9, 38.7);
INSERT INTO obce VALUES (3649, 'CZ0533', 'Borušov', 81, 85, 39.5, 42.9);
INSERT INTO obce VALUES (3650, 'CZ0533', 'Brněnec', 663, 713, 41.3, 44.8);
INSERT INTO obce VALUES (3651, 'CZ0533', 'Březina', 173, 181, 43.2, 44.6);
INSERT INTO obce VALUES (3652, 'CZ0533', 'Březinky', 72, 75, 41.2, 45.0);
INSERT INTO obce VALUES (3653, 'CZ0533', 'Březiny', 79, 77, 36.5, 41.3);
INSERT INTO obce VALUES (3654, 'CZ0533', 'Březová nad Svitavou', 851, 875, 34.5, 38.0);
INSERT INTO obce VALUES (3655, 'CZ0533', 'Budislav', 236, 207, 40.5, 41.2);
INSERT INTO obce VALUES (3656, 'CZ0533', 'Bystré', 835, 792, 37.9, 40.2);
INSERT INTO obce VALUES (3657, 'CZ0533', 'Cerekvice nad Loučnou', 427, 431, 38.3, 39.2);
INSERT INTO obce VALUES (3658, 'CZ0533', 'Čistá', 459, 470, 35.9, 36.8);
INSERT INTO obce VALUES (3659, 'CZ0533', 'Desná', 157, 159, 41.1, 41.1);
INSERT INTO obce VALUES (3660, 'CZ0533', 'Dětřichov', 154, 165, 34.8, 36.8);
INSERT INTO obce VALUES (3661, 'CZ0533', 'Dětřichov u Moravské Třebové', 97, 105, 41.3, 42.4);
INSERT INTO obce VALUES (3662, 'CZ0533', 'Dlouhá Loučka', 276, 252, 36.2, 39.8);
INSERT INTO obce VALUES (3663, 'CZ0533', 'Dolní Újezd', 972, 994, 37.7, 41.3);
INSERT INTO obce VALUES (3664, 'CZ0533', 'Gruna', 75, 83, 39.0, 44.9);
INSERT INTO obce VALUES (3665, 'CZ0533', 'Hartinkov', 27, 21, 45.6, 61.2);
INSERT INTO obce VALUES (3666, 'CZ0533', 'Hartmanice', 151, 140, 37.6, 40.0);
INSERT INTO obce VALUES (3667, 'CZ0533', 'Horky', 51, 60, 37.1, 43.2);
INSERT INTO obce VALUES (3668, 'CZ0533', 'Horní Újezd', 231, 213, 38.0, 41.6);
INSERT INTO obce VALUES (3669, 'CZ0533', 'Hradec nad Svitavou', 844, 814, 37.5, 41.9);
INSERT INTO obce VALUES (3670, 'CZ0533', 'Chmelík', 102, 91, 41.3, 40.9);
INSERT INTO obce VALUES (3671, 'CZ0533', 'Chornice', 445, 433, 37.9, 39.4);
INSERT INTO obce VALUES (3672, 'CZ0533', 'Chotěnov', 67, 60, 37.7, 43.7);
INSERT INTO obce VALUES (3673, 'CZ0533', 'Chotovice', 69, 66, 34.8, 36.8);
INSERT INTO obce VALUES (3674, 'CZ0533', 'Chrastavec', 121, 118, 44.2, 49.9);
INSERT INTO obce VALUES (3675, 'CZ0533', 'Janov', 453, 488, 35.4, 39.1);
INSERT INTO obce VALUES (3676, 'CZ0533', 'Janůvky', 16, 16, 54.4, 50.6);
INSERT INTO obce VALUES (3677, 'CZ0533', 'Jaroměřice', 595, 612, 40.0, 43.5);
INSERT INTO obce VALUES (3678, 'CZ0533', 'Jarošov', 96, 94, 35.0, 43.1);
INSERT INTO obce VALUES (3679, 'CZ0533', 'Javorník', 188, 188, 38.9, 37.7);
INSERT INTO obce VALUES (3680, 'CZ0533', 'Jedlová', 515, 516, 39.7, 41.2);
INSERT INTO obce VALUES (3681, 'CZ0533', 'Jevíčko', 1398, 1493, 37.2, 40.3);
INSERT INTO obce VALUES (3682, 'CZ0533', 'Kamenec u Poličky', 276, 269, 35.9, 39.0);
INSERT INTO obce VALUES (3683, 'CZ0533', 'Kamenná Horka', 146, 142, 40.8, 40.4);
INSERT INTO obce VALUES (3684, 'CZ0533', 'Karle', 196, 192, 40.0, 40.6);
INSERT INTO obce VALUES (3685, 'CZ0533', 'Koclířov', 360, 336, 39.1, 39.9);
INSERT INTO obce VALUES (3686, 'CZ0533', 'Korouhev', 396, 398, 38.6, 42.1);
INSERT INTO obce VALUES (3687, 'CZ0533', 'Koruna', 68, 63, 42.4, 42.5);
INSERT INTO obce VALUES (3688, 'CZ0533', 'Křenov', 219, 199, 37.7, 40.8);
INSERT INTO obce VALUES (3689, 'CZ0533', 'Kukle', 32, 31, 38.9, 40.2);
INSERT INTO obce VALUES (3690, 'CZ0533', 'Kunčina', 697, 626, 36.9, 39.4);
INSERT INTO obce VALUES (3691, 'CZ0533', 'Květná', 206, 187, 32.9, 36.1);
INSERT INTO obce VALUES (3692, 'CZ0533', 'Lavičné', 69, 54, 42.3, 50.0);
INSERT INTO obce VALUES (3693, 'CZ0533', 'Linhartice', 319, 316, 37.8, 40.4);
INSERT INTO obce VALUES (3694, 'CZ0533', 'Litomyšl', 4980, 5295, 39.9, 42.5);
INSERT INTO obce VALUES (3695, 'CZ0533', 'Lubná', 520, 489, 37.2, 40.5);
INSERT INTO obce VALUES (3696, 'CZ0533', 'Makov', 166, 178, 37.8, 37.9);
INSERT INTO obce VALUES (3697, 'CZ0533', 'Malíkov', 64, 50, 36.4, 36.6);
INSERT INTO obce VALUES (3698, 'CZ0533', 'Městečko Trnávka', 757, 731, 39.9, 42.8);
INSERT INTO obce VALUES (3699, 'CZ0533', 'Mikuleč', 108, 108, 39.5, 40.1);
INSERT INTO obce VALUES (3700, 'CZ0533', 'Mladějov na Moravě', 241, 234, 38.5, 39.7);
INSERT INTO obce VALUES (3701, 'CZ0533', 'Morašice', 359, 350, 38.4, 39.7);
INSERT INTO obce VALUES (3702, 'CZ0533', 'Moravská Třebová', 5271, 5639, 39.4, 42.9);
INSERT INTO obce VALUES (3703, 'CZ0533', 'Nedvězí', 107, 105, 41.4, 45.6);
INSERT INTO obce VALUES (3704, 'CZ0533', 'Němčice', 490, 459, 36.9, 38.9);
INSERT INTO obce VALUES (3705, 'CZ0533', 'Nová Sídla', 105, 128, 40.4, 41.0);
INSERT INTO obce VALUES (3706, 'CZ0533', 'Nová Ves u Jarošova', 32, 26, 37.4, 46.2);
INSERT INTO obce VALUES (3707, 'CZ0533', 'Oldřiš', 345, 316, 36.8, 41.5);
INSERT INTO obce VALUES (3708, 'CZ0533', 'Opatov', 609, 568, 38.2, 39.3);
INSERT INTO obce VALUES (3709, 'CZ0533', 'Opatovec', 332, 314, 38.4, 39.2);
INSERT INTO obce VALUES (3710, 'CZ0533', 'Osík', 486, 505, 37.8, 40.0);
INSERT INTO obce VALUES (3711, 'CZ0533', 'Pohledy', 181, 157, 39.1, 41.4);
INSERT INTO obce VALUES (3712, 'CZ0533', 'Polička', 4307, 4570, 39.0, 42.8);
INSERT INTO obce VALUES (3713, 'CZ0533', 'Pomezí', 575, 575, 37.4, 40.3);
INSERT INTO obce VALUES (5892, 'CZ0724', 'Komárov', 162, 174, 41.0, 46.4);
INSERT INTO obce VALUES (3714, 'CZ0533', 'Poříčí u Litomyšle', 254, 201, 36.5, 40.8);
INSERT INTO obce VALUES (3715, 'CZ0533', 'Příluka', 85, 82, 38.8, 38.4);
INSERT INTO obce VALUES (3716, 'CZ0533', 'Pustá Kamenice', 174, 164, 39.3, 40.6);
INSERT INTO obce VALUES (3717, 'CZ0533', 'Pustá Rybná', 83, 86, 43.4, 49.4);
INSERT INTO obce VALUES (3718, 'CZ0533', 'Radiměř', 551, 553, 39.4, 40.7);
INSERT INTO obce VALUES (3719, 'CZ0533', 'Radkov', 63, 59, 40.7, 42.9);
INSERT INTO obce VALUES (3720, 'CZ0533', 'Rohozná', 318, 347, 41.4, 48.2);
INSERT INTO obce VALUES (3721, 'CZ0533', 'Rozhraní', 181, 154, 40.5, 43.7);
INSERT INTO obce VALUES (3722, 'CZ0533', 'Rozstání', 123, 133, 41.4, 39.1);
INSERT INTO obce VALUES (3723, 'CZ0533', 'Rudná', 94, 94, 35.5, 39.8);
INSERT INTO obce VALUES (3724, 'CZ0533', 'Rychnov na Moravě', 295, 287, 38.7, 43.3);
INSERT INTO obce VALUES (3725, 'CZ0533', 'Řídký', 35, 37, 42.4, 44.4);
INSERT INTO obce VALUES (3726, 'CZ0533', 'Sádek', 236, 239, 38.5, 42.7);
INSERT INTO obce VALUES (3727, 'CZ0533', 'Sebranice', 487, 471, 36.4, 37.2);
INSERT INTO obce VALUES (3728, 'CZ0533', 'Sedliště', 121, 118, 37.5, 35.0);
INSERT INTO obce VALUES (3729, 'CZ0533', 'Sklené', 116, 116, 39.3, 40.0);
INSERT INTO obce VALUES (3730, 'CZ0533', 'Slatina', 71, 64, 35.9, 40.0);
INSERT INTO obce VALUES (3731, 'CZ0533', 'Sloupnice', 820, 901, 40.3, 43.4);
INSERT INTO obce VALUES (3732, 'CZ0533', 'Staré Město', 520, 497, 37.1, 38.9);
INSERT INTO obce VALUES (3733, 'CZ0533', 'Stašov', 126, 122, 38.7, 38.2);
INSERT INTO obce VALUES (3734, 'CZ0533', 'Strakov', 99, 114, 38.1, 41.0);
INSERT INTO obce VALUES (3735, 'CZ0533', 'Suchá Lhota', 47, 44, 34.9, 39.3);
INSERT INTO obce VALUES (3736, 'CZ0533', 'Svitavy', 8148, 8919, 38.8, 42.0);
INSERT INTO obce VALUES (3737, 'CZ0533', 'Svojanov', 164, 198, 43.7, 44.9);
INSERT INTO obce VALUES (3738, 'CZ0533', 'Široký Důl', 196, 190, 36.4, 39.8);
INSERT INTO obce VALUES (3739, 'CZ0533', 'Študlov', 75, 65, 42.3, 44.5);
INSERT INTO obce VALUES (3740, 'CZ0533', 'Telecí', 219, 179, 39.5, 43.7);
INSERT INTO obce VALUES (3741, 'CZ0533', 'Trpín', 212, 223, 39.7, 41.6);
INSERT INTO obce VALUES (3742, 'CZ0533', 'Trstěnice', 259, 255, 37.3, 43.1);
INSERT INTO obce VALUES (3743, 'CZ0533', 'Tržek', 83, 79, 40.7, 45.5);
INSERT INTO obce VALUES (3744, 'CZ0533', 'Třebařov', 481, 466, 37.0, 41.4);
INSERT INTO obce VALUES (3745, 'CZ0533', 'Újezdec', 45, 51, 32.8, 37.5);
INSERT INTO obce VALUES (3746, 'CZ0533', 'Útěchov', 124, 112, 33.5, 38.4);
INSERT INTO obce VALUES (3747, 'CZ0533', 'Vendolí', 487, 471, 37.1, 38.7);
INSERT INTO obce VALUES (3748, 'CZ0533', 'Vidlatá Seč', 146, 139, 37.5, 40.4);
INSERT INTO obce VALUES (3749, 'CZ0533', 'Víska u Jevíčka', 80, 76, 39.6, 42.0);
INSERT INTO obce VALUES (3750, 'CZ0533', 'Vítějeves', 195, 200, 38.9, 44.7);
INSERT INTO obce VALUES (3751, 'CZ0533', 'Vlčkov', 55, 52, 41.8, 38.4);
INSERT INTO obce VALUES (3752, 'CZ0533', 'Vranová Lhota', 215, 228, 38.1, 39.4);
INSERT INTO obce VALUES (3753, 'CZ0533', 'Vrážné', 43, 32, 37.4, 44.4);
INSERT INTO obce VALUES (3754, 'CZ0533', 'Vysoká', 16, 20, 41.2, 41.7);
INSERT INTO obce VALUES (3755, 'CZ0533', 'Želivsko', 20, 23, 44.7, 45.9);
INSERT INTO obce VALUES (3756, 'CZ0534', 'Albrechtice', 227, 238, 37.6, 43.8);
INSERT INTO obce VALUES (3757, 'CZ0534', 'Anenská Studánka', 76, 128, 35.6, 45.1);
INSERT INTO obce VALUES (3758, 'CZ0534', 'Běstovice', 212, 219, 37.2, 39.9);
INSERT INTO obce VALUES (3759, 'CZ0534', 'Bošín', 38, 42, 37.4, 35.0);
INSERT INTO obce VALUES (3760, 'CZ0534', 'Brandýs nad Orlicí', 674, 713, 39.7, 44.7);
INSERT INTO obce VALUES (3761, 'CZ0534', 'Bučina', 95, 104, 42.1, 42.7);
INSERT INTO obce VALUES (3762, 'CZ0534', 'Bystřec', 546, 565, 37.4, 39.7);
INSERT INTO obce VALUES (3763, 'CZ0534', 'Cotkytle', 219, 211, 39.1, 41.9);
INSERT INTO obce VALUES (3764, 'CZ0534', 'Čenkovice', 97, 82, 36.6, 39.9);
INSERT INTO obce VALUES (3765, 'CZ0534', 'Červená Voda', 1507, 1600, 38.4, 41.1);
INSERT INTO obce VALUES (3766, 'CZ0534', 'Česká Rybná', 202, 200, 38.6, 41.7);
INSERT INTO obce VALUES (3767, 'CZ0534', 'Česká Třebová', 7910, 8268, 39.4, 43.0);
INSERT INTO obce VALUES (3768, 'CZ0534', 'České Heřmanice', 269, 275, 37.2, 40.5);
INSERT INTO obce VALUES (3769, 'CZ0534', 'České Libchavy', 304, 289, 34.8, 36.1);
INSERT INTO obce VALUES (3770, 'CZ0534', 'České Petrovice', 75, 74, 44.6, 38.6);
INSERT INTO obce VALUES (3771, 'CZ0534', 'Damníkov', 352, 355, 36.6, 37.7);
INSERT INTO obce VALUES (3772, 'CZ0534', 'Dlouhá Třebová', 636, 616, 37.8, 40.3);
INSERT INTO obce VALUES (3773, 'CZ0534', 'Dlouhoňovice', 367, 381, 36.6, 39.2);
INSERT INTO obce VALUES (3774, 'CZ0534', 'Dobříkov', 246, 235, 38.3, 39.3);
INSERT INTO obce VALUES (3775, 'CZ0534', 'Dolní Čermná', 657, 683, 36.8, 40.3);
INSERT INTO obce VALUES (3776, 'CZ0534', 'Dolní Dobrouč', 1293, 1264, 37.2, 40.4);
INSERT INTO obce VALUES (3777, 'CZ0534', 'Dolní Morava', 162, 148, 36.0, 38.0);
INSERT INTO obce VALUES (3778, 'CZ0534', 'Džbánov', 154, 170, 38.6, 39.7);
INSERT INTO obce VALUES (3779, 'CZ0534', 'Hejnice', 110, 105, 39.3, 39.8);
INSERT INTO obce VALUES (3780, 'CZ0534', 'Helvíkovice', 226, 220, 39.1, 41.3);
INSERT INTO obce VALUES (3781, 'CZ0534', 'Hnátnice', 423, 445, 40.1, 39.5);
INSERT INTO obce VALUES (3782, 'CZ0534', 'Horní Čermná', 513, 503, 38.7, 41.6);
INSERT INTO obce VALUES (3783, 'CZ0534', 'Horní Heřmanice', 250, 263, 41.3, 43.9);
INSERT INTO obce VALUES (3784, 'CZ0534', 'Horní Třešňovec', 314, 284, 36.3, 39.7);
INSERT INTO obce VALUES (3785, 'CZ0534', 'Hrádek', 54, 47, 35.7, 43.9);
INSERT INTO obce VALUES (3786, 'CZ0534', 'Hrušová', 158, 167, 42.0, 41.3);
INSERT INTO obce VALUES (3787, 'CZ0534', 'Choceň', 4441, 4584, 39.4, 43.2);
INSERT INTO obce VALUES (3788, 'CZ0534', 'Jablonné nad Orlicí', 1562, 1710, 38.2, 40.4);
INSERT INTO obce VALUES (3789, 'CZ0534', 'Jamné nad Orlicí', 352, 336, 39.0, 39.2);
INSERT INTO obce VALUES (3790, 'CZ0534', 'Javorník', 130, 123, 37.5, 44.1);
INSERT INTO obce VALUES (3791, 'CZ0534', 'Jehnědí', 152, 161, 40.1, 39.0);
INSERT INTO obce VALUES (3792, 'CZ0534', 'Kameničná', 150, 190, 38.8, 39.7);
INSERT INTO obce VALUES (3793, 'CZ0534', 'Klášterec nad Orlicí', 474, 446, 37.0, 39.9);
INSERT INTO obce VALUES (3794, 'CZ0534', 'Koldín', 158, 180, 39.0, 40.3);
INSERT INTO obce VALUES (3795, 'CZ0534', 'Kosořín', 80, 70, 37.1, 38.6);
INSERT INTO obce VALUES (3796, 'CZ0534', 'Králíky', 2255, 2321, 39.1, 41.5);
INSERT INTO obce VALUES (3797, 'CZ0534', 'Krasíkov', 156, 173, 36.8, 39.0);
INSERT INTO obce VALUES (3798, 'CZ0534', 'Kunvald', 504, 509, 40.3, 40.1);
INSERT INTO obce VALUES (3799, 'CZ0534', 'Lanškroun', 4829, 5367, 39.4, 42.1);
INSERT INTO obce VALUES (3800, 'CZ0534', 'Leština', 148, 157, 41.4, 41.4);
INSERT INTO obce VALUES (3801, 'CZ0534', 'Letohrad', 3058, 3279, 38.1, 41.2);
INSERT INTO obce VALUES (3802, 'CZ0534', 'Libecina', 86, 80, 41.7, 45.0);
INSERT INTO obce VALUES (3803, 'CZ0534', 'Libchavy', 851, 857, 36.9, 39.1);
INSERT INTO obce VALUES (3804, 'CZ0534', 'Lichkov', 272, 272, 36.0, 38.2);
INSERT INTO obce VALUES (3805, 'CZ0534', 'Líšnice', 403, 381, 37.1, 40.1);
INSERT INTO obce VALUES (3806, 'CZ0534', 'Lubník', 166, 149, 35.7, 36.7);
INSERT INTO obce VALUES (3807, 'CZ0534', 'Lukavice', 578, 561, 37.3, 38.2);
INSERT INTO obce VALUES (3808, 'CZ0534', 'Luková', 354, 334, 38.7, 40.4);
INSERT INTO obce VALUES (3809, 'CZ0534', 'Mistrovice', 314, 298, 36.4, 41.3);
INSERT INTO obce VALUES (3810, 'CZ0534', 'Mladkov', 278, 265, 38.7, 40.8);
INSERT INTO obce VALUES (3811, 'CZ0534', 'Mostek', 123, 133, 36.0, 37.5);
INSERT INTO obce VALUES (3812, 'CZ0534', 'Nasavrky', 71, 65, 40.9, 45.4);
INSERT INTO obce VALUES (3813, 'CZ0534', 'Nekoř', 449, 446, 37.0, 40.8);
INSERT INTO obce VALUES (3814, 'CZ0534', 'Nové Hrady', 158, 128, 39.4, 44.2);
INSERT INTO obce VALUES (3815, 'CZ0534', 'Orlické Podhůří', 321, 318, 35.8, 38.8);
INSERT INTO obce VALUES (3816, 'CZ0534', 'Orličky', 140, 144, 37.9, 39.2);
INSERT INTO obce VALUES (3817, 'CZ0534', 'Ostrov', 322, 292, 34.5, 34.6);
INSERT INTO obce VALUES (3818, 'CZ0534', 'Oucmanice', 113, 109, 38.3, 39.0);
INSERT INTO obce VALUES (3819, 'CZ0534', 'Pastviny', 169, 173, 40.5, 42.8);
INSERT INTO obce VALUES (3820, 'CZ0534', 'Petrovice', 125, 124, 37.4, 40.3);
INSERT INTO obce VALUES (3821, 'CZ0534', 'Písečná', 266, 240, 35.2, 37.9);
INSERT INTO obce VALUES (3822, 'CZ0534', 'Plchovice', 45, 36, 40.1, 48.6);
INSERT INTO obce VALUES (3823, 'CZ0534', 'Podlesí', 136, 128, 37.8, 40.7);
INSERT INTO obce VALUES (3824, 'CZ0534', 'Přívrat', 170, 164, 39.2, 37.6);
INSERT INTO obce VALUES (3825, 'CZ0534', 'Pustina', 36, 36, 40.7, 46.7);
INSERT INTO obce VALUES (3826, 'CZ0534', 'Radhošť', 84, 87, 46.5, 45.0);
INSERT INTO obce VALUES (3827, 'CZ0534', 'Rudoltice', 817, 782, 33.7, 36.0);
INSERT INTO obce VALUES (3828, 'CZ0534', 'Rybník', 386, 411, 40.5, 40.2);
INSERT INTO obce VALUES (3829, 'CZ0534', 'Řepníky', 210, 207, 38.7, 40.0);
INSERT INTO obce VALUES (3830, 'CZ0534', 'Řetová', 349, 344, 39.8, 40.4);
INSERT INTO obce VALUES (3831, 'CZ0534', 'Řetůvka', 137, 123, 42.6, 44.1);
INSERT INTO obce VALUES (3832, 'CZ0534', 'Sázava', 286, 284, 37.1, 37.8);
INSERT INTO obce VALUES (3833, 'CZ0534', 'Seč', 83, 71, 37.5, 42.9);
INSERT INTO obce VALUES (3834, 'CZ0534', 'Semanín', 317, 302, 35.6, 37.9);
INSERT INTO obce VALUES (3835, 'CZ0534', 'Skořenice', 234, 199, 36.1, 41.2);
INSERT INTO obce VALUES (3836, 'CZ0534', 'Slatina', 185, 211, 39.2, 37.5);
INSERT INTO obce VALUES (3837, 'CZ0534', 'Sobkovice', 114, 118, 38.5, 39.5);
INSERT INTO obce VALUES (3838, 'CZ0534', 'Sopotnice', 495, 479, 38.8, 40.9);
INSERT INTO obce VALUES (3839, 'CZ0534', 'Sruby', 275, 270, 40.1, 45.1);
INSERT INTO obce VALUES (3840, 'CZ0534', 'Stradouň', 99, 94, 36.8, 45.5);
INSERT INTO obce VALUES (3841, 'CZ0534', 'Strážná', 55, 54, 37.0, 44.1);
INSERT INTO obce VALUES (3842, 'CZ0534', 'Studené', 73, 77, 38.2, 42.6);
INSERT INTO obce VALUES (3843, 'CZ0534', 'Sudislav nad Orlicí', 59, 59, 36.6, 40.5);
INSERT INTO obce VALUES (3844, 'CZ0534', 'Sudslava', 88, 101, 37.8, 37.0);
INSERT INTO obce VALUES (3845, 'CZ0534', 'Svatý Jiří', 150, 157, 39.0, 41.5);
INSERT INTO obce VALUES (3846, 'CZ0534', 'Šedivec', 106, 102, 36.6, 39.3);
INSERT INTO obce VALUES (3847, 'CZ0534', 'Tatenice', 414, 426, 37.1, 38.6);
INSERT INTO obce VALUES (3848, 'CZ0534', 'Těchonín', 321, 296, 40.9, 42.2);
INSERT INTO obce VALUES (3849, 'CZ0534', 'Tisová', 268, 277, 39.6, 41.8);
INSERT INTO obce VALUES (3850, 'CZ0534', 'Trpík', 35, 39, 45.1, 40.8);
INSERT INTO obce VALUES (3851, 'CZ0534', 'Třebovice', 416, 368, 37.5, 40.9);
INSERT INTO obce VALUES (3852, 'CZ0534', 'Týnišťko', 78, 76, 36.8, 41.0);
INSERT INTO obce VALUES (3853, 'CZ0534', 'Újezd u Chocně', 148, 164, 36.9, 43.1);
INSERT INTO obce VALUES (3854, 'CZ0534', 'Ústí nad Orlicí', 7093, 7472, 40.1, 42.8);
INSERT INTO obce VALUES (3855, 'CZ0534', 'Velká Skrovnice', 137, 139, 38.5, 42.7);
INSERT INTO obce VALUES (3856, 'CZ0534', 'Verměřovice', 367, 363, 35.8, 39.2);
INSERT INTO obce VALUES (3857, 'CZ0534', 'Vinary', 48, 63, 40.4, 45.4);
INSERT INTO obce VALUES (3858, 'CZ0534', 'Voděrady', 163, 164, 40.7, 41.5);
INSERT INTO obce VALUES (3859, 'CZ0534', 'Vraclav', 375, 367, 38.8, 40.9);
INSERT INTO obce VALUES (3860, 'CZ0534', 'Vračovice-Orlov', 113, 90, 36.3, 40.9);
INSERT INTO obce VALUES (3861, 'CZ0534', 'Výprachtice', 491, 497, 36.9, 38.7);
INSERT INTO obce VALUES (3862, 'CZ0534', 'Vysoké Mýto', 6100, 6478, 38.1, 40.9);
INSERT INTO obce VALUES (3863, 'CZ0534', 'Zádolí', 46, 37, 47.6, 46.5);
INSERT INTO obce VALUES (3864, 'CZ0534', 'Záchlumí', 415, 373, 39.4, 41.7);
INSERT INTO obce VALUES (3865, 'CZ0534', 'Zálší', 127, 106, 38.8, 42.3);
INSERT INTO obce VALUES (3866, 'CZ0534', 'Zámrsk', 376, 347, 40.2, 41.9);
INSERT INTO obce VALUES (3867, 'CZ0534', 'Zářecká Lhota', 88, 98, 39.0, 39.0);
INSERT INTO obce VALUES (3868, 'CZ0534', 'Žamberk', 2966, 3059, 37.9, 41.9);
INSERT INTO obce VALUES (3869, 'CZ0534', 'Žampach', 180, 115, 39.8, 36.7);
INSERT INTO obce VALUES (3870, 'CZ0534', 'Žichlínek', 467, 427, 36.4, 38.8);
INSERT INTO obce VALUES (3871, 'CZ0631', 'Bačkov', 66, 66, 41.4, 43.7);
INSERT INTO obce VALUES (3872, 'CZ0631', 'Bartoušov', 96, 76, 41.3, 42.8);
INSERT INTO obce VALUES (3873, 'CZ0631', 'Bělá', 112, 94, 42.3, 44.4);
INSERT INTO obce VALUES (3874, 'CZ0631', 'Bezděkov', 129, 128, 42.0, 45.0);
INSERT INTO obce VALUES (3875, 'CZ0631', 'Bojiště', 129, 113, 40.2, 43.6);
INSERT INTO obce VALUES (3876, 'CZ0631', 'Boňkov', 29, 28, 42.1, 44.9);
INSERT INTO obce VALUES (3877, 'CZ0631', 'Borek', 65, 62, 44.7, 47.1);
INSERT INTO obce VALUES (3878, 'CZ0631', 'Břevnice', 58, 45, 44.0, 40.4);
INSERT INTO obce VALUES (3879, 'CZ0631', 'Čachotín', 94, 86, 39.3, 42.1);
INSERT INTO obce VALUES (3880, 'CZ0631', 'Čečkovice', 34, 45, 41.2, 41.8);
INSERT INTO obce VALUES (3881, 'CZ0631', 'Česká Bělá', 504, 513, 36.8, 40.2);
INSERT INTO obce VALUES (3882, 'CZ0631', 'Číhošť', 180, 155, 41.3, 43.4);
INSERT INTO obce VALUES (3883, 'CZ0631', 'Dlouhá Ves', 189, 205, 38.3, 37.8);
INSERT INTO obce VALUES (3884, 'CZ0631', 'Dolní Krupá', 194, 194, 36.4, 38.3);
INSERT INTO obce VALUES (3885, 'CZ0631', 'Dolní Město', 470, 443, 40.6, 43.5);
INSERT INTO obce VALUES (3886, 'CZ0631', 'Dolní Sokolovec', 40, 51, 40.7, 41.1);
INSERT INTO obce VALUES (3887, 'CZ0631', 'Druhanov', 78, 77, 35.2, 38.3);
INSERT INTO obce VALUES (3888, 'CZ0631', 'Golčův Jeníkov', 1315, 1359, 39.6, 41.4);
INSERT INTO obce VALUES (3889, 'CZ0631', 'Habry', 682, 631, 40.5, 42.9);
INSERT INTO obce VALUES (3890, 'CZ0631', 'Havlíčkova Borová', 462, 457, 37.6, 40.8);
INSERT INTO obce VALUES (3891, 'CZ0631', 'Havlíčkův Brod', 11835, 12578, 39.0, 42.4);
INSERT INTO obce VALUES (3892, 'CZ0631', 'Herálec', 552, 560, 40.3, 42.2);
INSERT INTO obce VALUES (3893, 'CZ0631', 'Heřmanice', 37, 29, 51.2, 49.1);
INSERT INTO obce VALUES (3894, 'CZ0631', 'Hněvkovice', 270, 279, 38.3, 44.9);
INSERT INTO obce VALUES (3895, 'CZ0631', 'Horní Krupá', 250, 245, 37.6, 38.3);
INSERT INTO obce VALUES (3896, 'CZ0631', 'Horní Paseka', 38, 31, 44.0, 56.9);
INSERT INTO obce VALUES (3897, 'CZ0631', 'Hradec', 104, 98, 44.4, 44.2);
INSERT INTO obce VALUES (3898, 'CZ0631', 'Hurtova Lhota', 112, 101, 38.2, 39.4);
INSERT INTO obce VALUES (3899, 'CZ0631', 'Chotěboř', 4870, 4949, 38.9, 41.6);
INSERT INTO obce VALUES (3900, 'CZ0631', 'Chrtníč', 60, 66, 41.4, 46.0);
INSERT INTO obce VALUES (3901, 'CZ0631', 'Chřenovice', 75, 69, 41.1, 46.7);
INSERT INTO obce VALUES (3902, 'CZ0631', 'Jedlá', 34, 39, 44.2, 40.0);
INSERT INTO obce VALUES (3903, 'CZ0631', 'Jeřišno', 157, 151, 40.4, 43.0);
INSERT INTO obce VALUES (3904, 'CZ0631', 'Jilem', 65, 55, 38.3, 43.2);
INSERT INTO obce VALUES (3905, 'CZ0631', 'Jitkov', 107, 101, 38.2, 41.0);
INSERT INTO obce VALUES (3906, 'CZ0631', 'Kámen', 186, 183, 38.2, 44.1);
INSERT INTO obce VALUES (3907, 'CZ0631', 'Kamenná Lhota', 129, 129, 34.6, 39.0);
INSERT INTO obce VALUES (3908, 'CZ0631', 'Klokočov', 52, 61, 40.8, 46.9);
INSERT INTO obce VALUES (3909, 'CZ0631', 'Knyk', 196, 183, 37.5, 38.5);
INSERT INTO obce VALUES (3910, 'CZ0631', 'Kochánov', 59, 87, 37.2, 34.8);
INSERT INTO obce VALUES (3911, 'CZ0631', 'Kojetín', 79, 81, 42.8, 45.5);
INSERT INTO obce VALUES (3912, 'CZ0631', 'Kouty', 96, 92, 40.4, 45.4);
INSERT INTO obce VALUES (3913, 'CZ0631', 'Kozlov', 69, 67, 41.7, 49.4);
INSERT INTO obce VALUES (3914, 'CZ0631', 'Kožlí', 371, 364, 39.8, 45.0);
INSERT INTO obce VALUES (3915, 'CZ0631', 'Kraborovice', 50, 49, 44.7, 55.1);
INSERT INTO obce VALUES (3916, 'CZ0631', 'Krásná Hora', 267, 270, 41.3, 43.2);
INSERT INTO obce VALUES (3917, 'CZ0631', 'Krátká Ves', 79, 67, 38.4, 46.5);
INSERT INTO obce VALUES (3918, 'CZ0631', 'Krucemburk', 856, 815, 39.5, 41.5);
INSERT INTO obce VALUES (3919, 'CZ0631', 'Kunemil', 51, 61, 40.6, 46.5);
INSERT INTO obce VALUES (3920, 'CZ0631', 'Květinov', 128, 102, 39.3, 49.1);
INSERT INTO obce VALUES (3921, 'CZ0631', 'Kyjov', 71, 65, 38.6, 42.4);
INSERT INTO obce VALUES (3922, 'CZ0631', 'Kynice', 45, 49, 41.5, 43.9);
INSERT INTO obce VALUES (3923, 'CZ0631', 'Lány', 30, 34, 47.8, 50.6);
INSERT INTO obce VALUES (3924, 'CZ0631', 'Ledeč nad Sázavou', 2816, 2899, 41.8, 44.3);
INSERT INTO obce VALUES (3925, 'CZ0631', 'Leškovice', 34, 42, 47.5, 44.8);
INSERT INTO obce VALUES (3926, 'CZ0631', 'Leština u Světlé', 304, 296, 40.2, 42.5);
INSERT INTO obce VALUES (3927, 'CZ0631', 'Libice nad Doubravou', 414, 446, 41.9, 41.0);
INSERT INTO obce VALUES (3928, 'CZ0631', 'Lípa', 531, 546, 38.8, 39.8);
INSERT INTO obce VALUES (3929, 'CZ0631', 'Lipnice nad Sázavou', 331, 323, 39.5, 41.9);
INSERT INTO obce VALUES (3930, 'CZ0631', 'Lučice', 323, 302, 38.6, 43.5);
INSERT INTO obce VALUES (3931, 'CZ0631', 'Malčín', 97, 92, 42.3, 44.4);
INSERT INTO obce VALUES (3932, 'CZ0631', 'Maleč', 340, 360, 40.7, 40.7);
INSERT INTO obce VALUES (3933, 'CZ0631', 'Michalovice', 61, 64, 40.6, 38.3);
INSERT INTO obce VALUES (3934, 'CZ0631', 'Modlíkov', 89, 80, 37.5, 39.9);
INSERT INTO obce VALUES (3935, 'CZ0631', 'Nejepín', 29, 29, 53.1, 56.6);
INSERT INTO obce VALUES (3936, 'CZ0631', 'Nová Ves u Chotěboře', 288, 295, 40.0, 40.8);
INSERT INTO obce VALUES (3937, 'CZ0631', 'Nová Ves u Leštiny', 52, 57, 43.2, 42.1);
INSERT INTO obce VALUES (3938, 'CZ0631', 'Nová Ves u Světlé', 238, 239, 40.0, 41.0);
INSERT INTO obce VALUES (3939, 'CZ0631', 'Okrouhlice', 611, 651, 40.1, 40.5);
INSERT INTO obce VALUES (3940, 'CZ0631', 'Okrouhlička', 98, 109, 44.5, 43.0);
INSERT INTO obce VALUES (3941, 'CZ0631', 'Olešenka', 98, 93, 36.1, 39.2);
INSERT INTO obce VALUES (3942, 'CZ0631', 'Olešná', 166, 161, 36.8, 37.4);
INSERT INTO obce VALUES (3943, 'CZ0631', 'Ostrov', 71, 68, 36.6, 42.8);
INSERT INTO obce VALUES (3944, 'CZ0631', 'Oudoleň', 191, 159, 36.5, 41.6);
INSERT INTO obce VALUES (3945, 'CZ0631', 'Ovesná Lhota', 99, 91, 39.6, 44.7);
INSERT INTO obce VALUES (3946, 'CZ0631', 'Pavlov', 63, 56, 44.6, 36.5);
INSERT INTO obce VALUES (3947, 'CZ0631', 'Podmoklany', 72, 54, 38.8, 49.2);
INSERT INTO obce VALUES (3948, 'CZ0631', 'Podmoky', 45, 49, 44.9, 54.9);
INSERT INTO obce VALUES (3949, 'CZ0631', 'Pohled', 365, 398, 41.0, 43.9);
INSERT INTO obce VALUES (3950, 'CZ0631', 'Pohleď', 36, 43, 50.6, 49.2);
INSERT INTO obce VALUES (3951, 'CZ0631', 'Prosíčka', 58, 59, 37.0, 40.7);
INSERT INTO obce VALUES (3952, 'CZ0631', 'Přibyslav', 1957, 2000, 37.9, 41.5);
INSERT INTO obce VALUES (3953, 'CZ0631', 'Příseka', 185, 197, 37.8, 41.8);
INSERT INTO obce VALUES (3954, 'CZ0631', 'Radostín', 84, 70, 36.8, 42.6);
INSERT INTO obce VALUES (3955, 'CZ0631', 'Rozsochatec', 273, 245, 37.5, 39.1);
INSERT INTO obce VALUES (3956, 'CZ0631', 'Rušinov', 81, 88, 40.7, 44.8);
INSERT INTO obce VALUES (3957, 'CZ0631', 'Rybníček', 29, 25, 54.1, 61.0);
INSERT INTO obce VALUES (3958, 'CZ0631', 'Sázavka', 157, 151, 39.3, 43.6);
INSERT INTO obce VALUES (3959, 'CZ0631', 'Sedletín', 141, 143, 39.8, 42.8);
INSERT INTO obce VALUES (3960, 'CZ0631', 'Skorkov', 36, 39, 42.3, 45.2);
INSERT INTO obce VALUES (3961, 'CZ0631', 'Skryje', 89, 92, 40.0, 44.1);
INSERT INTO obce VALUES (3962, 'CZ0631', 'Skuhrov', 123, 126, 39.1, 42.0);
INSERT INTO obce VALUES (3963, 'CZ0631', 'Slavětín', 54, 48, 35.5, 46.2);
INSERT INTO obce VALUES (3964, 'CZ0631', 'Slavíkov', 174, 164, 42.4, 48.1);
INSERT INTO obce VALUES (3965, 'CZ0631', 'Slavníč', 23, 27, 36.4, 32.1);
INSERT INTO obce VALUES (3966, 'CZ0631', 'Sloupno', 25, 19, 47.3, 52.8);
INSERT INTO obce VALUES (3967, 'CZ0631', 'Služátky', 81, 81, 43.6, 41.0);
INSERT INTO obce VALUES (3968, 'CZ0631', 'Sobíňov', 360, 331, 38.9, 40.7);
INSERT INTO obce VALUES (3969, 'CZ0631', 'Stříbrné Hory', 121, 117, 39.1, 41.0);
INSERT INTO obce VALUES (3970, 'CZ0631', 'Světlá nad Sázavou', 3451, 3437, 39.2, 41.9);
INSERT INTO obce VALUES (3971, 'CZ0631', 'Šlapanov', 399, 388, 39.2, 42.2);
INSERT INTO obce VALUES (3972, 'CZ0631', 'Štoky', 845, 873, 36.7, 39.0);
INSERT INTO obce VALUES (3973, 'CZ0631', 'Tis', 174, 190, 40.5, 43.6);
INSERT INTO obce VALUES (3974, 'CZ0631', 'Trpišovice', 78, 80, 40.2, 46.1);
INSERT INTO obce VALUES (3975, 'CZ0631', 'Uhelná Příbram', 249, 272, 40.2, 47.4);
INSERT INTO obce VALUES (3976, 'CZ0631', 'Úhořilka', 20, 24, 40.5, 45.3);
INSERT INTO obce VALUES (3977, 'CZ0631', 'Úsobí', 353, 335, 40.0, 44.1);
INSERT INTO obce VALUES (3978, 'CZ0631', 'Vepříkov', 161, 188, 43.1, 41.6);
INSERT INTO obce VALUES (3979, 'CZ0631', 'Veselý Žďár', 264, 274, 39.5, 39.6);
INSERT INTO obce VALUES (3980, 'CZ0631', 'Věž', 421, 404, 41.5, 43.6);
INSERT INTO obce VALUES (3981, 'CZ0631', 'Věžnice', 213, 197, 40.8, 42.8);
INSERT INTO obce VALUES (3982, 'CZ0631', 'Vilémov', 494, 483, 43.4, 45.4);
INSERT INTO obce VALUES (3983, 'CZ0631', 'Vilémovice', 113, 104, 40.6, 42.9);
INSERT INTO obce VALUES (3984, 'CZ0631', 'Víska', 89, 89, 39.7, 43.5);
INSERT INTO obce VALUES (3985, 'CZ0631', 'Vlkanov', 27, 23, 36.5, 42.8);
INSERT INTO obce VALUES (3986, 'CZ0631', 'Vysoká', 86, 87, 36.7, 36.4);
INSERT INTO obce VALUES (3987, 'CZ0631', 'Zvěstovice', 27, 39, 49.6, 41.4);
INSERT INTO obce VALUES (3988, 'CZ0631', 'Ždírec', 56, 54, 38.3, 31.3);
INSERT INTO obce VALUES (3989, 'CZ0631', 'Ždírec nad Doubravou', 1636, 1599, 38.4, 40.7);
INSERT INTO obce VALUES (3990, 'CZ0631', 'Žižkovo Pole', 170, 186, 40.2, 41.2);
INSERT INTO obce VALUES (3991, 'CZ0632', 'Arnolec', 98, 87, 40.0, 38.0);
INSERT INTO obce VALUES (3992, 'CZ0632', 'Batelov', 1167, 1175, 38.7, 42.0);
INSERT INTO obce VALUES (3993, 'CZ0632', 'Bílý Kámen', 115, 102, 34.6, 38.3);
INSERT INTO obce VALUES (3994, 'CZ0632', 'Bítovčice', 221, 216, 40.4, 40.5);
INSERT INTO obce VALUES (3995, 'CZ0632', 'Bohuslavice', 67, 73, 37.2, 38.1);
INSERT INTO obce VALUES (3996, 'CZ0632', 'Borovná', 43, 42, 38.7, 51.2);
INSERT INTO obce VALUES (3997, 'CZ0632', 'Boršov', 65, 74, 37.5, 39.4);
INSERT INTO obce VALUES (3998, 'CZ0632', 'Brtnice', 1911, 1847, 38.0, 41.6);
INSERT INTO obce VALUES (3999, 'CZ0632', 'Brtnička', 53, 55, 42.8, 48.6);
INSERT INTO obce VALUES (4000, 'CZ0632', 'Brzkov', 124, 129, 36.8, 38.3);
INSERT INTO obce VALUES (4001, 'CZ0632', 'Cejle', 220, 215, 40.0, 42.3);
INSERT INTO obce VALUES (4002, 'CZ0632', 'Cerekvička-Rosice', 68, 59, 44.5, 42.3);
INSERT INTO obce VALUES (4003, 'CZ0632', 'Černíč', 74, 61, 41.8, 49.3);
INSERT INTO obce VALUES (4004, 'CZ0632', 'Čížov', 106, 89, 38.1, 43.1);
INSERT INTO obce VALUES (4005, 'CZ0632', 'Dlouhá Brtnice', 199, 193, 37.1, 40.9);
INSERT INTO obce VALUES (4006, 'CZ0632', 'Dobronín', 951, 969, 36.3, 38.1);
INSERT INTO obce VALUES (4007, 'CZ0632', 'Dobroutov', 137, 124, 36.9, 34.2);
INSERT INTO obce VALUES (4008, 'CZ0632', 'Dolní Cerekev', 641, 637, 37.8, 38.7);
INSERT INTO obce VALUES (4009, 'CZ0632', 'Dolní Vilímeč', 52, 49, 37.3, 39.0);
INSERT INTO obce VALUES (4010, 'CZ0632', 'Doupě', 53, 52, 36.4, 44.1);
INSERT INTO obce VALUES (4011, 'CZ0632', 'Dudín', 95, 78, 37.9, 40.6);
INSERT INTO obce VALUES (4012, 'CZ0632', 'Dušejov', 221, 195, 36.4, 38.6);
INSERT INTO obce VALUES (4013, 'CZ0632', 'Dvorce', 80, 87, 45.5, 45.6);
INSERT INTO obce VALUES (4014, 'CZ0632', 'Dyjice', 73, 62, 39.1, 40.6);
INSERT INTO obce VALUES (4015, 'CZ0632', 'Hladov', 79, 63, 41.3, 43.8);
INSERT INTO obce VALUES (4016, 'CZ0632', 'Hodice', 368, 370, 39.0, 41.5);
INSERT INTO obce VALUES (4017, 'CZ0632', 'Hojkov', 76, 86, 41.5, 46.7);
INSERT INTO obce VALUES (4018, 'CZ0632', 'Horní Dubenky', 323, 332, 39.3, 42.3);
INSERT INTO obce VALUES (4019, 'CZ0632', 'Horní Myslová', 41, 40, 35.5, 43.0);
INSERT INTO obce VALUES (4020, 'CZ0632', 'Hostětice', 68, 65, 39.2, 41.1);
INSERT INTO obce VALUES (4021, 'CZ0632', 'Hrutov', 44, 41, 42.8, 42.6);
INSERT INTO obce VALUES (4022, 'CZ0632', 'Hubenov', 59, 69, 42.5, 41.7);
INSERT INTO obce VALUES (4023, 'CZ0632', 'Hybrálec', 204, 197, 39.1, 42.2);
INSERT INTO obce VALUES (4024, 'CZ0632', 'Jamné', 259, 250, 37.7, 42.9);
INSERT INTO obce VALUES (4025, 'CZ0632', 'Jersín', 99, 95, 36.6, 40.3);
INSERT INTO obce VALUES (4026, 'CZ0632', 'Jezdovice', 142, 135, 39.1, 41.6);
INSERT INTO obce VALUES (4027, 'CZ0632', 'Ježená', 69, 59, 35.7, 42.8);
INSERT INTO obce VALUES (4028, 'CZ0632', 'Jihlava', 25037, 26185, 39.4, 42.7);
INSERT INTO obce VALUES (4029, 'CZ0632', 'Jihlávka', 110, 113, 42.9, 48.9);
INSERT INTO obce VALUES (4030, 'CZ0632', 'Jindřichovice', 47, 39, 40.9, 38.9);
INSERT INTO obce VALUES (4031, 'CZ0632', 'Kalhov', 58, 58, 42.7, 44.6);
INSERT INTO obce VALUES (4032, 'CZ0632', 'Kaliště', 71, 81, 44.6, 43.2);
INSERT INTO obce VALUES (4033, 'CZ0632', 'Kamenice', 924, 902, 38.4, 41.6);
INSERT INTO obce VALUES (4034, 'CZ0632', 'Kamenná', 84, 92, 38.9, 41.2);
INSERT INTO obce VALUES (4035, 'CZ0632', 'Klatovec', 35, 28, 41.7, 52.0);
INSERT INTO obce VALUES (4036, 'CZ0632', 'Kněžice', 751, 689, 38.3, 40.5);
INSERT INTO obce VALUES (4037, 'CZ0632', 'Knínice', 83, 96, 43.9, 45.9);
INSERT INTO obce VALUES (4038, 'CZ0632', 'Kostelec', 467, 435, 36.1, 39.2);
INSERT INTO obce VALUES (4039, 'CZ0632', 'Kostelní Myslová', 33, 30, 37.0, 42.0);
INSERT INTO obce VALUES (4040, 'CZ0632', 'Kozlov', 241, 213, 39.8, 42.7);
INSERT INTO obce VALUES (4041, 'CZ0632', 'Krahulčí', 352, 335, 35.8, 38.7);
INSERT INTO obce VALUES (4042, 'CZ0632', 'Krasonice', 104, 98, 42.8, 50.3);
INSERT INTO obce VALUES (4043, 'CZ0632', 'Lhotka', 44, 41, 44.3, 41.4);
INSERT INTO obce VALUES (4044, 'CZ0632', 'Luka nad Jihlavou', 1340, 1344, 38.2, 41.9);
INSERT INTO obce VALUES (4045, 'CZ0632', 'Malý Beranov', 291, 280, 38.3, 42.8);
INSERT INTO obce VALUES (4046, 'CZ0632', 'Markvartice', 102, 105, 38.1, 42.7);
INSERT INTO obce VALUES (4047, 'CZ0632', 'Měšín', 99, 100, 38.7, 36.4);
INSERT INTO obce VALUES (4048, 'CZ0632', 'Milíčov', 67, 57, 43.4, 47.0);
INSERT INTO obce VALUES (4049, 'CZ0632', 'Mirošov', 98, 82, 38.8, 45.5);
INSERT INTO obce VALUES (4050, 'CZ0632', 'Mrákotín', 471, 441, 37.7, 41.8);
INSERT INTO obce VALUES (4051, 'CZ0632', 'Mysletice', 64, 55, 37.1, 41.8);
INSERT INTO obce VALUES (4052, 'CZ0632', 'Mysliboř', 105, 112, 37.3, 39.7);
INSERT INTO obce VALUES (4053, 'CZ0632', 'Nadějov', 103, 100, 38.2, 44.1);
INSERT INTO obce VALUES (4054, 'CZ0632', 'Nevcehle', 122, 104, 40.1, 44.6);
INSERT INTO obce VALUES (4055, 'CZ0632', 'Nová Říše', 445, 426, 39.0, 41.3);
INSERT INTO obce VALUES (4056, 'CZ0632', 'Olšany', 33, 32, 38.0, 39.8);
INSERT INTO obce VALUES (4057, 'CZ0632', 'Olší', 28, 26, 34.3, 40.7);
INSERT INTO obce VALUES (4058, 'CZ0632', 'Opatov', 96, 93, 41.3, 41.6);
INSERT INTO obce VALUES (4059, 'CZ0632', 'Ořechov', 41, 33, 34.3, 46.2);
INSERT INTO obce VALUES (4060, 'CZ0632', 'Otín', 37, 40, 47.4, 40.9);
INSERT INTO obce VALUES (4061, 'CZ0632', 'Panenská Rozsíčka', 74, 80, 34.5, 34.3);
INSERT INTO obce VALUES (4062, 'CZ0632', 'Panské Dubenky', 56, 65, 42.4, 42.5);
INSERT INTO obce VALUES (4063, 'CZ0632', 'Pavlov', 212, 201, 40.3, 43.5);
INSERT INTO obce VALUES (4064, 'CZ0632', 'Plandry', 96, 98, 35.5, 38.1);
INSERT INTO obce VALUES (4065, 'CZ0632', 'Polná', 2589, 2657, 37.8, 40.4);
INSERT INTO obce VALUES (4066, 'CZ0632', 'Puklice', 405, 372, 36.8, 42.8);
INSERT INTO obce VALUES (4067, 'CZ0632', 'Radkov', 116, 116, 40.2, 41.2);
INSERT INTO obce VALUES (4068, 'CZ0632', 'Rančířov', 178, 166, 34.0, 34.5);
INSERT INTO obce VALUES (4069, 'CZ0632', 'Rantířov', 236, 233, 36.3, 36.9);
INSERT INTO obce VALUES (4070, 'CZ0632', 'Rohozná', 188, 202, 40.7, 40.6);
INSERT INTO obce VALUES (4071, 'CZ0632', 'Rozseč', 98, 85, 38.1, 39.1);
INSERT INTO obce VALUES (4072, 'CZ0632', 'Růžená', 173, 150, 35.4, 41.8);
INSERT INTO obce VALUES (4073, 'CZ0632', 'Rybné', 53, 53, 44.6, 41.1);
INSERT INTO obce VALUES (4074, 'CZ0632', 'Řásná', 99, 98, 40.8, 44.8);
INSERT INTO obce VALUES (4075, 'CZ0632', 'Řídelov', 39, 45, 40.6, 42.7);
INSERT INTO obce VALUES (4076, 'CZ0632', 'Sedlatice', 34, 29, 41.0, 46.9);
INSERT INTO obce VALUES (4077, 'CZ0632', 'Sedlejov', 134, 128, 40.8, 42.0);
INSERT INTO obce VALUES (4078, 'CZ0632', 'Smrčná', 166, 163, 38.5, 42.5);
INSERT INTO obce VALUES (4079, 'CZ0632', 'Stáj', 89, 89, 38.6, 43.0);
INSERT INTO obce VALUES (4080, 'CZ0632', 'Stará Říše', 361, 318, 37.7, 41.7);
INSERT INTO obce VALUES (4081, 'CZ0632', 'Stonařov', 521, 527, 37.1, 40.2);
INSERT INTO obce VALUES (4082, 'CZ0632', 'Strachoňovice', 47, 40, 40.1, 39.9);
INSERT INTO obce VALUES (4083, 'CZ0632', 'Střítež', 188, 167, 37.7, 41.6);
INSERT INTO obce VALUES (4084, 'CZ0632', 'Suchá', 126, 138, 39.1, 39.8);
INSERT INTO obce VALUES (4085, 'CZ0632', 'Svojkovice', 25, 33, 43.1, 45.8);
INSERT INTO obce VALUES (4086, 'CZ0632', 'Šimanov', 92, 91, 43.0, 45.1);
INSERT INTO obce VALUES (4087, 'CZ0632', 'Švábov', 32, 40, 48.5, 50.5);
INSERT INTO obce VALUES (4088, 'CZ0632', 'Telč', 2777, 2955, 39.8, 43.1);
INSERT INTO obce VALUES (4089, 'CZ0632', 'Třešť', 2938, 2983, 38.7, 42.4);
INSERT INTO obce VALUES (4090, 'CZ0632', 'Třeštice', 63, 62, 38.8, 36.8);
INSERT INTO obce VALUES (4091, 'CZ0632', 'Urbanov', 65, 72, 35.9, 38.3);
INSERT INTO obce VALUES (4092, 'CZ0632', 'Ústí', 104, 118, 41.2, 44.1);
INSERT INTO obce VALUES (4093, 'CZ0632', 'Vanov', 51, 39, 41.9, 43.2);
INSERT INTO obce VALUES (4094, 'CZ0632', 'Vanůvek', 12, 17, 44.3, 44.1);
INSERT INTO obce VALUES (4095, 'CZ0632', 'Vápovice', 17, 29, 52.7, 52.4);
INSERT INTO obce VALUES (4096, 'CZ0632', 'Velký Beranov', 666, 640, 36.1, 38.5);
INSERT INTO obce VALUES (4097, 'CZ0632', 'Větrný Jeníkov', 305, 298, 38.3, 40.9);
INSERT INTO obce VALUES (4098, 'CZ0632', 'Věžnice', 73, 72, 38.7, 42.3);
INSERT INTO obce VALUES (4099, 'CZ0632', 'Věžnička', 65, 61, 37.6, 41.4);
INSERT INTO obce VALUES (4100, 'CZ0632', 'Vílanec', 165, 149, 37.1, 36.7);
INSERT INTO obce VALUES (4101, 'CZ0632', 'Volevčice', 18, 24, 54.2, 41.0);
INSERT INTO obce VALUES (4102, 'CZ0632', 'Vyskytná nad Jihlavou', 396, 388, 38.3, 41.0);
INSERT INTO obce VALUES (4103, 'CZ0632', 'Vysoké Studnice', 176, 202, 38.1, 37.3);
INSERT INTO obce VALUES (4104, 'CZ0632', 'Vystrčenovice', 47, 55, 45.9, 39.4);
INSERT INTO obce VALUES (4105, 'CZ0632', 'Záborná', 115, 105, 36.4, 40.8);
INSERT INTO obce VALUES (4106, 'CZ0632', 'Zadní Vydří', 25, 32, 40.7, 41.9);
INSERT INTO obce VALUES (4107, 'CZ0632', 'Zbilidy', 101, 89, 37.4, 42.4);
INSERT INTO obce VALUES (4108, 'CZ0632', 'Zbinohy', 34, 34, 34.8, 38.6);
INSERT INTO obce VALUES (4109, 'CZ0632', 'Zdeňkov', 39, 32, 41.4, 49.2);
INSERT INTO obce VALUES (4110, 'CZ0632', 'Zhoř', 206, 227, 36.8, 36.6);
INSERT INTO obce VALUES (4111, 'CZ0632', 'Zvolenovice', 34, 40, 42.9, 42.3);
INSERT INTO obce VALUES (4112, 'CZ0632', 'Žatec', 63, 56, 35.2, 39.8);
INSERT INTO obce VALUES (4113, 'CZ0632', 'Ždírec', 166, 205, 40.6, 44.0);
INSERT INTO obce VALUES (4114, 'CZ0633', 'Arneštovice', 39, 51, 47.9, 41.9);
INSERT INTO obce VALUES (4115, 'CZ0633', 'Bácovice', 33, 35, 39.4, 34.6);
INSERT INTO obce VALUES (4116, 'CZ0633', 'Bělá', 24, 24, 39.6, 45.8);
INSERT INTO obce VALUES (4117, 'CZ0633', 'Bohdalín', 104, 104, 41.5, 44.2);
INSERT INTO obce VALUES (4118, 'CZ0633', 'Bořetice', 36, 36, 44.6, 45.3);
INSERT INTO obce VALUES (4119, 'CZ0633', 'Bořetín', 50, 54, 37.7, 45.2);
INSERT INTO obce VALUES (4120, 'CZ0633', 'Božejov', 355, 326, 39.0, 41.4);
INSERT INTO obce VALUES (4121, 'CZ0633', 'Bratřice', 78, 87, 45.1, 49.6);
INSERT INTO obce VALUES (4122, 'CZ0633', 'Budíkov', 149, 130, 39.7, 42.9);
INSERT INTO obce VALUES (4123, 'CZ0633', 'Buřenice', 105, 100, 45.2, 49.9);
INSERT INTO obce VALUES (4124, 'CZ0633', 'Bystrá', 39, 53, 40.8, 41.5);
INSERT INTO obce VALUES (4125, 'CZ0633', 'Cetoraz', 138, 147, 41.7, 43.4);
INSERT INTO obce VALUES (4126, 'CZ0633', 'Čáslavsko', 51, 53, 56.9, 60.5);
INSERT INTO obce VALUES (4127, 'CZ0633', 'Častrov', 282, 274, 41.8, 43.9);
INSERT INTO obce VALUES (4128, 'CZ0633', 'Čejov', 227, 218, 39.6, 41.5);
INSERT INTO obce VALUES (4129, 'CZ0633', 'Čelistná', 55, 52, 38.6, 42.8);
INSERT INTO obce VALUES (4130, 'CZ0633', 'Černov', 51, 60, 40.6, 45.7);
INSERT INTO obce VALUES (4131, 'CZ0633', 'Černovice', 911, 919, 39.8, 43.4);
INSERT INTO obce VALUES (4132, 'CZ0633', 'Červená Řečice', 481, 496, 42.3, 44.5);
INSERT INTO obce VALUES (4133, 'CZ0633', 'Čížkov', 63, 59, 40.9, 39.5);
INSERT INTO obce VALUES (4134, 'CZ0633', 'Dehtáře', 60, 53, 37.2, 41.0);
INSERT INTO obce VALUES (4135, 'CZ0633', 'Dobrá Voda', 103, 85, 38.9, 42.7);
INSERT INTO obce VALUES (4136, 'CZ0633', 'Dobrá Voda u Pacova', 51, 47, 41.9, 41.6);
INSERT INTO obce VALUES (4137, 'CZ0633', 'Dubovice', 39, 32, 37.4, 43.0);
INSERT INTO obce VALUES (4138, 'CZ0633', 'Důl', 33, 28, 42.3, 43.6);
INSERT INTO obce VALUES (4139, 'CZ0633', 'Eš', 28, 33, 45.1, 39.9);
INSERT INTO obce VALUES (4140, 'CZ0633', 'Hojanovice', 47, 47, 43.3, 48.9);
INSERT INTO obce VALUES (4141, 'CZ0633', 'Hojovice', 34, 31, 55.3, 61.3);
INSERT INTO obce VALUES (4142, 'CZ0633', 'Horní Cerekev', 958, 988, 39.1, 41.3);
INSERT INTO obce VALUES (4143, 'CZ0633', 'Horní Rápotice', 69, 78, 38.7, 40.7);
INSERT INTO obce VALUES (4144, 'CZ0633', 'Horní Ves', 159, 151, 41.0, 44.5);
INSERT INTO obce VALUES (4145, 'CZ0633', 'Hořepník', 304, 317, 38.8, 41.7);
INSERT INTO obce VALUES (4146, 'CZ0633', 'Hořice', 89, 93, 45.0, 45.7);
INSERT INTO obce VALUES (4147, 'CZ0633', 'Humpolec', 5453, 5649, 40.1, 43.3);
INSERT INTO obce VALUES (4148, 'CZ0633', 'Chýstovice', 13, 15, 54.4, 56.6);
INSERT INTO obce VALUES (4149, 'CZ0633', 'Chyšná', 45, 52, 37.3, 42.7);
INSERT INTO obce VALUES (4150, 'CZ0633', 'Jankov', 23, 15, 37.7, 52.2);
INSERT INTO obce VALUES (4151, 'CZ0633', 'Ježov', 35, 31, 39.4, 42.0);
INSERT INTO obce VALUES (4152, 'CZ0633', 'Jiřice', 404, 412, 36.9, 41.3);
INSERT INTO obce VALUES (4153, 'CZ0633', 'Kaliště', 172, 168, 37.5, 44.6);
INSERT INTO obce VALUES (4154, 'CZ0633', 'Kámen', 130, 135, 41.6, 42.6);
INSERT INTO obce VALUES (4155, 'CZ0633', 'Kamenice nad Lipou', 2015, 2024, 39.2, 43.0);
INSERT INTO obce VALUES (4156, 'CZ0633', 'Kejžlice', 162, 164, 41.2, 40.6);
INSERT INTO obce VALUES (4157, 'CZ0633', 'Koberovice', 69, 73, 44.4, 44.6);
INSERT INTO obce VALUES (4158, 'CZ0633', 'Kojčice', 165, 147, 36.3, 38.1);
INSERT INTO obce VALUES (4159, 'CZ0633', 'Komorovice', 93, 85, 39.0, 38.0);
INSERT INTO obce VALUES (4160, 'CZ0633', 'Košetice', 377, 365, 37.9, 39.2);
INSERT INTO obce VALUES (4161, 'CZ0633', 'Krasíkovice', 61, 52, 37.1, 36.2);
INSERT INTO obce VALUES (4162, 'CZ0633', 'Křeč', 120, 111, 41.8, 45.8);
INSERT INTO obce VALUES (4163, 'CZ0633', 'Křelovice', 166, 173, 43.7, 44.5);
INSERT INTO obce VALUES (4164, 'CZ0633', 'Křešín', 73, 75, 47.5, 49.0);
INSERT INTO obce VALUES (4165, 'CZ0633', 'Leskovice', 49, 45, 40.2, 55.5);
INSERT INTO obce VALUES (4166, 'CZ0633', 'Lesná', 30, 38, 41.1, 42.1);
INSERT INTO obce VALUES (4167, 'CZ0633', 'Lhota-Vlasenice', 45, 45, 45.7, 49.0);
INSERT INTO obce VALUES (4168, 'CZ0633', 'Libkova Voda', 128, 110, 38.3, 39.6);
INSERT INTO obce VALUES (4169, 'CZ0633', 'Lidmaň', 186, 91, 39.0, 44.5);
INSERT INTO obce VALUES (4170, 'CZ0633', 'Litohošť', 36, 27, 41.0, 44.9);
INSERT INTO obce VALUES (4171, 'CZ0633', 'Lukavec', 544, 549, 39.8, 40.8);
INSERT INTO obce VALUES (4172, 'CZ0633', 'Martinice u Onšova', 22, 26, 41.2, 39.7);
INSERT INTO obce VALUES (4173, 'CZ0633', 'Mezilesí', 70, 59, 45.0, 53.0);
INSERT INTO obce VALUES (4174, 'CZ0633', 'Mezná', 64, 52, 43.6, 42.9);
INSERT INTO obce VALUES (4175, 'CZ0633', 'Mladé Bříště', 116, 112, 42.0, 42.5);
INSERT INTO obce VALUES (4176, 'CZ0633', 'Mnich', 187, 190, 42.4, 44.2);
INSERT INTO obce VALUES (4177, 'CZ0633', 'Moraveč', 105, 107, 39.1, 42.7);
INSERT INTO obce VALUES (4178, 'CZ0633', 'Mysletín', 48, 67, 40.7, 38.8);
INSERT INTO obce VALUES (4179, 'CZ0633', 'Nová Buková', 41, 52, 43.0, 41.4);
INSERT INTO obce VALUES (4180, 'CZ0633', 'Nová Cerekev', 531, 539, 41.9, 45.8);
INSERT INTO obce VALUES (4181, 'CZ0633', 'Nový Rychnov', 493, 482, 38.7, 41.9);
INSERT INTO obce VALUES (4182, 'CZ0633', 'Obrataň', 411, 441, 38.9, 43.0);
INSERT INTO obce VALUES (4183, 'CZ0633', 'Olešná', 288, 264, 35.7, 41.1);
INSERT INTO obce VALUES (4184, 'CZ0633', 'Ondřejov', 79, 63, 40.6, 43.8);
INSERT INTO obce VALUES (4185, 'CZ0633', 'Onšov', 105, 129, 42.2, 49.9);
INSERT INTO obce VALUES (4186, 'CZ0633', 'Pacov', 2505, 2519, 40.0, 43.9);
INSERT INTO obce VALUES (4187, 'CZ0633', 'Pavlov', 64, 62, 40.2, 41.9);
INSERT INTO obce VALUES (4188, 'CZ0633', 'Pelhřimov', 8139, 8568, 39.3, 41.7);
INSERT INTO obce VALUES (4189, 'CZ0633', 'Píšť', 36, 36, 45.9, 43.8);
INSERT INTO obce VALUES (4190, 'CZ0633', 'Počátky', 1300, 1357, 40.2, 43.2);
INSERT INTO obce VALUES (4191, 'CZ0633', 'Polesí', 39, 39, 39.3, 52.6);
INSERT INTO obce VALUES (4192, 'CZ0633', 'Pošná', 121, 115, 42.6, 50.9);
INSERT INTO obce VALUES (4193, 'CZ0633', 'Proseč', 32, 32, 42.1, 39.4);
INSERT INTO obce VALUES (4194, 'CZ0633', 'Proseč pod Křemešníkem', 47, 39, 44.9, 48.0);
INSERT INTO obce VALUES (4195, 'CZ0633', 'Putimov', 138, 125, 36.1, 40.8);
INSERT INTO obce VALUES (4196, 'CZ0633', 'Rodinov', 112, 95, 35.6, 43.2);
INSERT INTO obce VALUES (4197, 'CZ0633', 'Rovná', 26, 38, 37.0, 42.5);
INSERT INTO obce VALUES (4198, 'CZ0633', 'Rynárec', 311, 288, 36.6, 38.5);
INSERT INTO obce VALUES (4199, 'CZ0633', 'Řečice', 72, 69, 44.8, 44.7);
INSERT INTO obce VALUES (4200, 'CZ0633', 'Salačova Lhota', 69, 54, 40.9, 48.1);
INSERT INTO obce VALUES (4201, 'CZ0633', 'Samšín', 85, 82, 40.5, 45.7);
INSERT INTO obce VALUES (4202, 'CZ0633', 'Sedlice', 74, 67, 45.2, 50.5);
INSERT INTO obce VALUES (4203, 'CZ0633', 'Senožaty', 343, 354, 41.4, 41.2);
INSERT INTO obce VALUES (4204, 'CZ0633', 'Staré Bříště', 22, 18, 49.0, 49.4);
INSERT INTO obce VALUES (4205, 'CZ0633', 'Stojčín', 67, 55, 39.3, 44.6);
INSERT INTO obce VALUES (4206, 'CZ0633', 'Střítež', 54, 49, 44.9, 48.1);
INSERT INTO obce VALUES (4207, 'CZ0633', 'Střítež pod Křemešníkem', 26, 20, 43.9, 55.0);
INSERT INTO obce VALUES (4208, 'CZ0633', 'Svépravice', 61, 59, 39.5, 45.9);
INSERT INTO obce VALUES (4209, 'CZ0633', 'Syrov', 30, 24, 44.0, 47.4);
INSERT INTO obce VALUES (4210, 'CZ0633', 'Těchobuz', 76, 36, 47.0, 47.4);
INSERT INTO obce VALUES (4211, 'CZ0633', 'Těmice', 208, 207, 43.4, 46.1);
INSERT INTO obce VALUES (4212, 'CZ0633', 'Ústrašín', 110, 110, 39.7, 43.2);
INSERT INTO obce VALUES (4213, 'CZ0633', 'Útěchovice', 38, 28, 34.3, 47.6);
INSERT INTO obce VALUES (4214, 'CZ0633', 'Útěchovice pod Stražištěm', 57, 61, 45.9, 46.2);
INSERT INTO obce VALUES (4215, 'CZ0633', 'Útěchovičky', 41, 35, 38.1, 46.5);
INSERT INTO obce VALUES (4216, 'CZ0633', 'Včelnička', 99, 85, 41.6, 48.7);
INSERT INTO obce VALUES (4217, 'CZ0633', 'Velká Chyška', 153, 132, 41.0, 44.5);
INSERT INTO obce VALUES (4218, 'CZ0633', 'Velký Rybník', 84, 83, 39.3, 41.9);
INSERT INTO obce VALUES (4219, 'CZ0633', 'Veselá', 96, 120, 45.5, 42.8);
INSERT INTO obce VALUES (4220, 'CZ0633', 'Věžná', 61, 67, 39.5, 44.5);
INSERT INTO obce VALUES (4221, 'CZ0633', 'Vojslavice', 44, 46, 39.6, 48.9);
INSERT INTO obce VALUES (4222, 'CZ0633', 'Vokov', 49, 46, 34.4, 40.3);
INSERT INTO obce VALUES (4223, 'CZ0633', 'Vyklantice', 87, 86, 46.2, 50.9);
INSERT INTO obce VALUES (4224, 'CZ0633', 'Vyskytná', 339, 369, 39.5, 38.5);
INSERT INTO obce VALUES (4225, 'CZ0633', 'Vysoká Lhota', 10, 12, 58.0, 65.5);
INSERT INTO obce VALUES (4226, 'CZ0633', 'Vystrkov', 116, 121, 39.3, 39.8);
INSERT INTO obce VALUES (4227, 'CZ0633', 'Zachotín', 120, 118, 40.3, 43.2);
INSERT INTO obce VALUES (4228, 'CZ0633', 'Zajíčkov', 114, 113, 39.5, 40.0);
INSERT INTO obce VALUES (4229, 'CZ0633', 'Zhořec', 71, 56, 41.8, 52.3);
INSERT INTO obce VALUES (4230, 'CZ0633', 'Zlátenka', 22, 32, 43.7, 33.8);
INSERT INTO obce VALUES (4231, 'CZ0633', 'Želiv', 532, 554, 40.8, 43.9);
INSERT INTO obce VALUES (4232, 'CZ0633', 'Žirov', 36, 36, 44.8, 41.0);
INSERT INTO obce VALUES (4233, 'CZ0633', 'Žirovnice', 1486, 1584, 40.9, 43.3);
INSERT INTO obce VALUES (4234, 'CZ0634', 'Babice', 101, 96, 41.2, 45.4);
INSERT INTO obce VALUES (4235, 'CZ0634', 'Bačice', 85, 101, 43.6, 45.9);
INSERT INTO obce VALUES (4236, 'CZ0634', 'Bačkovice', 62, 57, 44.5, 45.1);
INSERT INTO obce VALUES (4237, 'CZ0634', 'Benetice', 99, 96, 36.8, 41.1);
INSERT INTO obce VALUES (4238, 'CZ0634', 'Biskupice-Pulkov', 142, 134, 42.1, 45.6);
INSERT INTO obce VALUES (4239, 'CZ0634', 'Blatnice', 196, 163, 40.1, 41.7);
INSERT INTO obce VALUES (4240, 'CZ0634', 'Bohušice', 61, 56, 41.0, 43.5);
INSERT INTO obce VALUES (4241, 'CZ0634', 'Bochovice', 79, 63, 42.2, 49.2);
INSERT INTO obce VALUES (4242, 'CZ0634', 'Bransouze', 129, 120, 42.3, 42.4);
INSERT INTO obce VALUES (4243, 'CZ0634', 'Březník', 313, 312, 40.7, 45.5);
INSERT INTO obce VALUES (4244, 'CZ0634', 'Budišov', 593, 610, 37.6, 41.1);
INSERT INTO obce VALUES (4245, 'CZ0634', 'Budkov', 185, 175, 37.1, 42.2);
INSERT INTO obce VALUES (4246, 'CZ0634', 'Cidlina', 50, 48, 43.2, 48.2);
INSERT INTO obce VALUES (4247, 'CZ0634', 'Čáslavice', 255, 280, 43.8, 43.9);
INSERT INTO obce VALUES (4248, 'CZ0634', 'Častohostice', 96, 94, 40.3, 44.9);
INSERT INTO obce VALUES (4249, 'CZ0634', 'Čechočovice', 134, 149, 42.7, 41.7);
INSERT INTO obce VALUES (4250, 'CZ0634', 'Čechtín', 151, 147, 39.4, 41.8);
INSERT INTO obce VALUES (4251, 'CZ0634', 'Červená Lhota', 95, 86, 39.7, 44.6);
INSERT INTO obce VALUES (4252, 'CZ0634', 'Číhalín', 92, 97, 42.5, 41.0);
INSERT INTO obce VALUES (4253, 'CZ0634', 'Číchov', 135, 119, 41.1, 46.2);
INSERT INTO obce VALUES (4254, 'CZ0634', 'Čikov', 98, 102, 42.0, 45.4);
INSERT INTO obce VALUES (4255, 'CZ0634', 'Číměř', 111, 104, 40.1, 40.6);
INSERT INTO obce VALUES (4256, 'CZ0634', 'Dalešice', 285, 300, 39.0, 41.2);
INSERT INTO obce VALUES (4257, 'CZ0634', 'Dědice', 64, 66, 37.1, 39.9);
INSERT INTO obce VALUES (4258, 'CZ0634', 'Dešov', 197, 215, 40.7, 41.8);
INSERT INTO obce VALUES (4259, 'CZ0634', 'Dolní Lažany', 78, 74, 38.7, 35.8);
INSERT INTO obce VALUES (4260, 'CZ0634', 'Dolní Vilémovice', 196, 202, 39.4, 40.9);
INSERT INTO obce VALUES (4261, 'CZ0634', 'Domamil', 145, 143, 39.7, 41.7);
INSERT INTO obce VALUES (4262, 'CZ0634', 'Dukovany', 394, 393, 36.7, 39.5);
INSERT INTO obce VALUES (4263, 'CZ0634', 'Hartvíkovice', 277, 263, 38.0, 41.9);
INSERT INTO obce VALUES (4264, 'CZ0634', 'Heraltice', 187, 175, 41.2, 42.6);
INSERT INTO obce VALUES (4265, 'CZ0634', 'Hluboké', 101, 115, 43.6, 46.6);
INSERT INTO obce VALUES (4266, 'CZ0634', 'Hodov', 148, 144, 40.5, 43.5);
INSERT INTO obce VALUES (4267, 'CZ0634', 'Horní Heřmanice', 64, 74, 40.1, 40.5);
INSERT INTO obce VALUES (4268, 'CZ0634', 'Horní Smrčné', 23, 28, 44.1, 45.9);
INSERT INTO obce VALUES (4269, 'CZ0634', 'Horní Újezd', 135, 123, 41.7, 43.9);
INSERT INTO obce VALUES (4270, 'CZ0634', 'Horní Vilémovice', 34, 37, 38.6, 39.3);
INSERT INTO obce VALUES (4271, 'CZ0634', 'Hornice', 36, 40, 46.4, 46.3);
INSERT INTO obce VALUES (4272, 'CZ0634', 'Hrotovice', 907, 886, 38.0, 41.0);
INSERT INTO obce VALUES (4273, 'CZ0634', 'Hroznatín', 60, 49, 34.9, 42.2);
INSERT INTO obce VALUES (4274, 'CZ0634', 'Hvězdoňovice', 38, 43, 36.4, 37.9);
INSERT INTO obce VALUES (4275, 'CZ0634', 'Chlístov', 115, 126, 40.4, 41.4);
INSERT INTO obce VALUES (4276, 'CZ0634', 'Chlum', 71, 84, 40.9, 44.8);
INSERT INTO obce VALUES (4277, 'CZ0634', 'Chotěbudice', 44, 59, 46.3, 45.1);
INSERT INTO obce VALUES (4278, 'CZ0634', 'Jakubov u Moravských Budějovic', 327, 298, 37.3, 41.5);
INSERT INTO obce VALUES (4279, 'CZ0634', 'Jaroměřice nad Rokytnou', 2098, 2179, 37.8, 40.0);
INSERT INTO obce VALUES (4280, 'CZ0634', 'Jasenice', 105, 100, 40.4, 44.1);
INSERT INTO obce VALUES (4281, 'CZ0634', 'Jemnice', 2151, 2274, 38.4, 40.5);
INSERT INTO obce VALUES (4282, 'CZ0634', 'Jinošov', 157, 127, 42.8, 40.2);
INSERT INTO obce VALUES (4283, 'CZ0634', 'Jiratice', 35, 45, 39.1, 41.5);
INSERT INTO obce VALUES (4284, 'CZ0634', 'Kamenná', 101, 113, 42.0, 44.6);
INSERT INTO obce VALUES (4285, 'CZ0634', 'Kdousov', 57, 50, 36.9, 46.0);
INSERT INTO obce VALUES (4286, 'CZ0634', 'Kladeruby nad Oslavou', 102, 100, 40.4, 39.9);
INSERT INTO obce VALUES (4287, 'CZ0634', 'Klučov', 79, 80, 38.5, 39.7);
INSERT INTO obce VALUES (4288, 'CZ0634', 'Kojatice', 147, 159, 44.6, 51.3);
INSERT INTO obce VALUES (4289, 'CZ0634', 'Kojatín', 35, 40, 41.2, 42.1);
INSERT INTO obce VALUES (4290, 'CZ0634', 'Kojetice', 232, 218, 39.8, 42.4);
INSERT INTO obce VALUES (4291, 'CZ0634', 'Komárovice', 49, 59, 42.9, 42.2);
INSERT INTO obce VALUES (4292, 'CZ0634', 'Koněšín', 231, 227, 38.6, 43.3);
INSERT INTO obce VALUES (4293, 'CZ0634', 'Kostníky', 98, 97, 37.8, 45.1);
INSERT INTO obce VALUES (4294, 'CZ0634', 'Kouty', 191, 185, 38.8, 40.5);
INSERT INTO obce VALUES (4295, 'CZ0634', 'Kozlany', 71, 61, 37.9, 41.2);
INSERT INTO obce VALUES (4296, 'CZ0634', 'Kožichovice', 190, 188, 40.0, 41.0);
INSERT INTO obce VALUES (4297, 'CZ0634', 'Krahulov', 114, 120, 43.3, 41.4);
INSERT INTO obce VALUES (4298, 'CZ0634', 'Kralice nad Oslavou', 448, 445, 39.1, 42.2);
INSERT INTO obce VALUES (4299, 'CZ0634', 'Kramolín', 58, 51, 42.2, 48.0);
INSERT INTO obce VALUES (4300, 'CZ0634', 'Krhov', 89, 108, 42.3, 45.6);
INSERT INTO obce VALUES (4301, 'CZ0634', 'Krokočín', 104, 103, 39.5, 43.1);
INSERT INTO obce VALUES (4302, 'CZ0634', 'Kuroslepy', 90, 88, 41.2, 46.5);
INSERT INTO obce VALUES (4303, 'CZ0634', 'Láz', 141, 136, 39.3, 42.1);
INSERT INTO obce VALUES (4304, 'CZ0634', 'Lesná', 53, 45, 38.4, 45.4);
INSERT INTO obce VALUES (4305, 'CZ0634', 'Lesní Jakubov', 42, 47, 38.4, 47.1);
INSERT INTO obce VALUES (4306, 'CZ0634', 'Lesonice', 247, 225, 37.7, 44.2);
INSERT INTO obce VALUES (4307, 'CZ0634', 'Lesůňky', 46, 44, 43.1, 47.8);
INSERT INTO obce VALUES (4308, 'CZ0634', 'Lhánice', 79, 75, 44.1, 45.3);
INSERT INTO obce VALUES (4309, 'CZ0634', 'Lhotice', 84, 78, 36.6, 41.7);
INSERT INTO obce VALUES (4310, 'CZ0634', 'Lipník', 180, 182, 36.2, 40.5);
INSERT INTO obce VALUES (4311, 'CZ0634', 'Litohoř', 278, 299, 36.4, 39.5);
INSERT INTO obce VALUES (4312, 'CZ0634', 'Litovany', 66, 78, 43.8, 45.8);
INSERT INTO obce VALUES (4313, 'CZ0634', 'Lomy', 67, 66, 44.1, 45.5);
INSERT INTO obce VALUES (4314, 'CZ0634', 'Loukovice', 60, 52, 41.0, 47.2);
INSERT INTO obce VALUES (4315, 'CZ0634', 'Lovčovice', 27, 29, 37.1, 40.6);
INSERT INTO obce VALUES (4316, 'CZ0634', 'Lukov', 192, 180, 36.3, 38.0);
INSERT INTO obce VALUES (4317, 'CZ0634', 'Markvartice', 124, 120, 35.6, 44.1);
INSERT INTO obce VALUES (4318, 'CZ0634', 'Martínkov', 148, 128, 37.6, 43.5);
INSERT INTO obce VALUES (4319, 'CZ0634', 'Mastník', 127, 119, 38.5, 42.7);
INSERT INTO obce VALUES (4320, 'CZ0634', 'Menhartice', 69, 78, 35.5, 37.6);
INSERT INTO obce VALUES (4321, 'CZ0634', 'Meziříčko', 45, 54, 38.5, 42.1);
INSERT INTO obce VALUES (4322, 'CZ0634', 'Mikulovice', 102, 118, 39.8, 36.9);
INSERT INTO obce VALUES (4323, 'CZ0634', 'Mladoňovice', 197, 200, 37.8, 39.6);
INSERT INTO obce VALUES (4324, 'CZ0634', 'Mohelno', 674, 717, 40.6, 44.7);
INSERT INTO obce VALUES (4325, 'CZ0634', 'Moravské Budějovice', 3843, 3973, 39.2, 43.2);
INSERT INTO obce VALUES (4326, 'CZ0634', 'Myslibořice', 328, 389, 37.6, 46.3);
INSERT INTO obce VALUES (4327, 'CZ0634', 'Naloučany', 81, 81, 40.9, 37.5);
INSERT INTO obce VALUES (4328, 'CZ0634', 'Náměšť nad Oslavou', 2467, 2599, 39.0, 41.9);
INSERT INTO obce VALUES (4329, 'CZ0634', 'Nárameč', 190, 164, 41.2, 46.6);
INSERT INTO obce VALUES (4330, 'CZ0634', 'Nimpšov', 35, 30, 48.2, 49.5);
INSERT INTO obce VALUES (4331, 'CZ0634', 'Nová Ves', 115, 92, 37.1, 44.0);
INSERT INTO obce VALUES (4332, 'CZ0634', 'Nové Syrovice', 525, 448, 41.2, 42.8);
INSERT INTO obce VALUES (4333, 'CZ0634', 'Nový Telečkov', 53, 49, 35.8, 39.2);
INSERT INTO obce VALUES (4334, 'CZ0634', 'Ocmanice', 169, 162, 40.8, 42.4);
INSERT INTO obce VALUES (4335, 'CZ0634', 'Odunec', 41, 48, 46.6, 48.9);
INSERT INTO obce VALUES (4336, 'CZ0634', 'Okarec', 63, 68, 41.4, 44.0);
INSERT INTO obce VALUES (4337, 'CZ0634', 'Okřešice', 96, 77, 35.4, 41.0);
INSERT INTO obce VALUES (4338, 'CZ0634', 'Okříšky', 1026, 1031, 40.3, 42.3);
INSERT INTO obce VALUES (4339, 'CZ0634', 'Opatov', 387, 377, 40.7, 40.7);
INSERT INTO obce VALUES (4340, 'CZ0634', 'Oponešice', 102, 90, 38.5, 42.7);
INSERT INTO obce VALUES (4341, 'CZ0634', 'Ostašov', 65, 61, 38.5, 41.7);
INSERT INTO obce VALUES (4342, 'CZ0634', 'Pálovice', 88, 74, 41.2, 41.3);
INSERT INTO obce VALUES (4343, 'CZ0634', 'Petrovice', 212, 210, 37.6, 40.1);
INSERT INTO obce VALUES (4344, 'CZ0634', 'Petrůvky', 42, 39, 40.3, 41.5);
INSERT INTO obce VALUES (4345, 'CZ0634', 'Pokojovice', 49, 36, 38.9, 49.0);
INSERT INTO obce VALUES (4346, 'CZ0634', 'Police', 198, 182, 39.7, 42.7);
INSERT INTO obce VALUES (4347, 'CZ0634', 'Popůvky', 45, 43, 38.8, 51.9);
INSERT INTO obce VALUES (4348, 'CZ0634', 'Pozďatín', 93, 86, 40.4, 44.6);
INSERT INTO obce VALUES (4349, 'CZ0634', 'Přeckov', 36, 43, 41.7, 35.9);
INSERT INTO obce VALUES (4350, 'CZ0634', 'Předín', 344, 360, 38.4, 42.3);
INSERT INTO obce VALUES (4351, 'CZ0634', 'Přešovice', 72, 68, 48.3, 45.7);
INSERT INTO obce VALUES (4352, 'CZ0634', 'Přibyslavice', 386, 395, 40.6, 41.0);
INSERT INTO obce VALUES (4353, 'CZ0634', 'Příštpo', 143, 136, 40.7, 45.2);
INSERT INTO obce VALUES (4354, 'CZ0634', 'Pucov', 49, 54, 43.6, 49.3);
INSERT INTO obce VALUES (4355, 'CZ0634', 'Pyšel', 217, 234, 38.0, 40.4);
INSERT INTO obce VALUES (4356, 'CZ0634', 'Rácovice', 52, 56, 40.0, 43.9);
INSERT INTO obce VALUES (4357, 'CZ0634', 'Račice', 39, 33, 35.7, 42.7);
INSERT INTO obce VALUES (4358, 'CZ0634', 'Radkovice u Budče', 80, 84, 37.0, 36.9);
INSERT INTO obce VALUES (4359, 'CZ0634', 'Radkovice u Hrotovic', 163, 175, 39.0, 38.2);
INSERT INTO obce VALUES (4360, 'CZ0634', 'Radonín', 34, 36, 49.3, 42.6);
INSERT INTO obce VALUES (4361, 'CZ0634', 'Radošov', 90, 80, 43.5, 41.6);
INSERT INTO obce VALUES (4362, 'CZ0634', 'Radotice', 69, 64, 43.3, 47.2);
INSERT INTO obce VALUES (4363, 'CZ0634', 'Rapotice', 251, 242, 39.9, 42.0);
INSERT INTO obce VALUES (4364, 'CZ0634', 'Rohy', 65, 60, 44.5, 48.6);
INSERT INTO obce VALUES (4365, 'CZ0634', 'Rokytnice nad Rokytnou', 438, 447, 39.6, 40.4);
INSERT INTO obce VALUES (4366, 'CZ0634', 'Rouchovany', 564, 582, 37.7, 41.7);
INSERT INTO obce VALUES (4367, 'CZ0634', 'Rudíkov', 343, 320, 36.3, 40.0);
INSERT INTO obce VALUES (4368, 'CZ0634', 'Římov', 207, 205, 40.2, 43.9);
INSERT INTO obce VALUES (4369, 'CZ0634', 'Sedlec', 119, 118, 41.8, 44.8);
INSERT INTO obce VALUES (4370, 'CZ0634', 'Slavětice', 122, 125, 41.5, 42.1);
INSERT INTO obce VALUES (4371, 'CZ0634', 'Slavičky', 118, 110, 40.5, 41.2);
INSERT INTO obce VALUES (4372, 'CZ0634', 'Slavíkovice', 120, 93, 39.9, 45.6);
INSERT INTO obce VALUES (4373, 'CZ0634', 'Smrk', 133, 114, 38.9, 46.5);
INSERT INTO obce VALUES (4374, 'CZ0634', 'Stařeč', 825, 852, 38.5, 39.1);
INSERT INTO obce VALUES (4375, 'CZ0634', 'Stropešín', 60, 53, 40.3, 46.0);
INSERT INTO obce VALUES (4376, 'CZ0634', 'Střítež', 223, 272, 39.7, 38.5);
INSERT INTO obce VALUES (4377, 'CZ0634', 'Studenec', 268, 278, 38.3, 42.2);
INSERT INTO obce VALUES (4378, 'CZ0634', 'Studnice', 71, 80, 40.9, 38.9);
INSERT INTO obce VALUES (4379, 'CZ0634', 'Sudice', 171, 161, 43.5, 45.9);
INSERT INTO obce VALUES (4380, 'CZ0634', 'Svatoslav', 126, 118, 41.9, 44.5);
INSERT INTO obce VALUES (4381, 'CZ0634', 'Šebkovice', 238, 237, 37.6, 42.0);
INSERT INTO obce VALUES (4382, 'CZ0634', 'Štěměchy', 159, 144, 40.3, 42.9);
INSERT INTO obce VALUES (4383, 'CZ0634', 'Štěpkov', 60, 53, 38.1, 44.1);
INSERT INTO obce VALUES (4384, 'CZ0634', 'Trnava', 292, 302, 40.7, 41.1);
INSERT INTO obce VALUES (4385, 'CZ0634', 'Třebelovice', 235, 215, 37.6, 39.5);
INSERT INTO obce VALUES (4386, 'CZ0634', 'Třebenice', 230, 211, 39.6, 42.0);
INSERT INTO obce VALUES (4387, 'CZ0634', 'Třebíč', 18516, 19640, 38.3, 41.1);
INSERT INTO obce VALUES (4388, 'CZ0634', 'Třesov', 44, 39, 42.3, 41.6);
INSERT INTO obce VALUES (4389, 'CZ0634', 'Valdíkov', 44, 59, 37.0, 39.5);
INSERT INTO obce VALUES (4390, 'CZ0634', 'Valeč', 322, 375, 35.2, 37.6);
INSERT INTO obce VALUES (4391, 'CZ0634', 'Vícenice', 102, 91, 36.8, 39.7);
INSERT INTO obce VALUES (4392, 'CZ0634', 'Vícenice u Náměště nad Oslavou', 200, 188, 38.5, 39.7);
INSERT INTO obce VALUES (4393, 'CZ0634', 'Vladislav', 614, 564, 40.9, 44.1);
INSERT INTO obce VALUES (4394, 'CZ0634', 'Vlčatín', 70, 74, 40.2, 37.9);
INSERT INTO obce VALUES (4395, 'CZ0634', 'Výčapy', 455, 414, 36.6, 37.9);
INSERT INTO obce VALUES (4396, 'CZ0634', 'Zahrádka', 68, 61, 38.5, 42.1);
INSERT INTO obce VALUES (4397, 'CZ0634', 'Zárubice', 66, 55, 42.3, 50.9);
INSERT INTO obce VALUES (4398, 'CZ0634', 'Zašovice', 58, 56, 43.7, 45.7);
INSERT INTO obce VALUES (4399, 'CZ0634', 'Zvěrkovice', 113, 115, 40.6, 38.0);
INSERT INTO obce VALUES (4400, 'CZ0634', 'Želetava', 764, 800, 37.6, 39.5);
INSERT INTO obce VALUES (4401, 'CZ0635', 'Baliny', 63, 65, 40.3, 42.7);
INSERT INTO obce VALUES (4402, 'CZ0635', 'Blažkov', 153, 140, 37.8, 41.0);
INSERT INTO obce VALUES (4403, 'CZ0635', 'Blízkov', 166, 162, 40.1, 38.5);
INSERT INTO obce VALUES (4404, 'CZ0635', 'Bobrová', 450, 474, 38.2, 40.8);
INSERT INTO obce VALUES (4405, 'CZ0635', 'Bobrůvka', 123, 110, 39.9, 43.5);
INSERT INTO obce VALUES (4406, 'CZ0635', 'Bohdalec', 154, 140, 39.6, 41.6);
INSERT INTO obce VALUES (4407, 'CZ0635', 'Bohdalov', 594, 541, 37.1, 39.9);
INSERT INTO obce VALUES (4408, 'CZ0635', 'Bohuňov', 125, 110, 35.7, 38.7);
INSERT INTO obce VALUES (4409, 'CZ0635', 'Borovnice', 84, 96, 41.0, 45.4);
INSERT INTO obce VALUES (4410, 'CZ0635', 'Bory', 401, 393, 37.7, 39.3);
INSERT INTO obce VALUES (4411, 'CZ0635', 'Březejc', 75, 68, 34.1, 38.5);
INSERT INTO obce VALUES (4412, 'CZ0635', 'Březí', 77, 96, 43.5, 44.5);
INSERT INTO obce VALUES (4413, 'CZ0635', 'Březí nad Oslavou', 118, 113, 38.1, 39.3);
INSERT INTO obce VALUES (4414, 'CZ0635', 'Březské', 113, 112, 37.9, 40.4);
INSERT INTO obce VALUES (4415, 'CZ0635', 'Budeč', 90, 96, 40.7, 36.2);
INSERT INTO obce VALUES (4416, 'CZ0635', 'Bukov', 88, 92, 39.3, 41.8);
INSERT INTO obce VALUES (4417, 'CZ0635', 'Bystřice nad Pernštejnem', 4340, 4359, 38.7, 41.8);
INSERT INTO obce VALUES (4418, 'CZ0635', 'Býšovec', 74, 63, 42.4, 47.3);
INSERT INTO obce VALUES (4419, 'CZ0635', 'Cikháj', 54, 58, 44.1, 43.3);
INSERT INTO obce VALUES (4420, 'CZ0635', 'Černá', 170, 158, 36.7, 41.6);
INSERT INTO obce VALUES (4421, 'CZ0635', 'Dalečín', 344, 319, 41.3, 43.2);
INSERT INTO obce VALUES (4422, 'CZ0635', 'Daňkovice', 78, 70, 39.2, 43.2);
INSERT INTO obce VALUES (4423, 'CZ0635', 'Dlouhé', 133, 134, 35.9, 38.1);
INSERT INTO obce VALUES (4424, 'CZ0635', 'Dobrá Voda', 162, 174, 40.5, 38.8);
INSERT INTO obce VALUES (4425, 'CZ0635', 'Dolní Heřmanice', 255, 262, 35.7, 39.7);
INSERT INTO obce VALUES (4426, 'CZ0635', 'Dolní Libochová', 72, 77, 41.1, 40.1);
INSERT INTO obce VALUES (4427, 'CZ0635', 'Dolní Rožínka', 330, 338, 41.6, 44.7);
INSERT INTO obce VALUES (4428, 'CZ0635', 'Fryšava pod Žákovou horou', 172, 171, 40.2, 42.5);
INSERT INTO obce VALUES (4429, 'CZ0635', 'Hamry nad Sázavou', 679, 751, 38.4, 39.3);
INSERT INTO obce VALUES (4430, 'CZ0635', 'Herálec', 654, 638, 38.7, 41.9);
INSERT INTO obce VALUES (4431, 'CZ0635', 'Heřmanov', 111, 109, 37.9, 42.4);
INSERT INTO obce VALUES (4432, 'CZ0635', 'Hodíškov', 71, 77, 39.2, 38.0);
INSERT INTO obce VALUES (4433, 'CZ0635', 'Horní Libochová', 102, 99, 37.4, 42.0);
INSERT INTO obce VALUES (4434, 'CZ0635', 'Horní Radslavice', 40, 49, 45.5, 44.8);
INSERT INTO obce VALUES (4435, 'CZ0635', 'Horní Rožínka', 44, 43, 32.3, 46.7);
INSERT INTO obce VALUES (4436, 'CZ0635', 'Chlumek', 93, 84, 43.3, 46.4);
INSERT INTO obce VALUES (4437, 'CZ0635', 'Chlumětín', 107, 91, 40.5, 49.1);
INSERT INTO obce VALUES (4438, 'CZ0635', 'Chlum-Korouhvice', 21, 23, 32.4, 42.0);
INSERT INTO obce VALUES (4439, 'CZ0635', 'Jabloňov', 168, 168, 35.6, 37.1);
INSERT INTO obce VALUES (4440, 'CZ0635', 'Jámy', 290, 272, 37.2, 39.2);
INSERT INTO obce VALUES (4441, 'CZ0635', 'Javorek', 49, 55, 37.5, 37.0);
INSERT INTO obce VALUES (4442, 'CZ0635', 'Jimramov', 603, 606, 40.8, 44.8);
INSERT INTO obce VALUES (4443, 'CZ0635', 'Jívoví', 145, 156, 38.9, 41.6);
INSERT INTO obce VALUES (4444, 'CZ0635', 'Kadolec', 86, 76, 36.7, 42.0);
INSERT INTO obce VALUES (4445, 'CZ0635', 'Kadov', 67, 59, 41.7, 43.5);
INSERT INTO obce VALUES (4446, 'CZ0635', 'Karlov', 44, 27, 39.9, 35.9);
INSERT INTO obce VALUES (4447, 'CZ0635', 'Kněževes', 80, 79, 40.1, 46.0);
INSERT INTO obce VALUES (4448, 'CZ0635', 'Koroužné', 126, 120, 40.7, 48.5);
INSERT INTO obce VALUES (4449, 'CZ0635', 'Kotlasy', 50, 67, 40.8, 41.1);
INSERT INTO obce VALUES (4450, 'CZ0635', 'Kozlov', 106, 97, 42.5, 46.4);
INSERT INTO obce VALUES (4451, 'CZ0635', 'Krásné', 52, 53, 37.9, 39.9);
INSERT INTO obce VALUES (4452, 'CZ0635', 'Krásněves', 118, 141, 39.8, 40.6);
INSERT INTO obce VALUES (4453, 'CZ0635', 'Křídla', 168, 152, 36.1, 37.7);
INSERT INTO obce VALUES (4454, 'CZ0635', 'Křižánky', 190, 194, 43.6, 43.3);
INSERT INTO obce VALUES (4455, 'CZ0635', 'Křižanov', 927, 942, 36.5, 39.2);
INSERT INTO obce VALUES (4456, 'CZ0635', 'Křoví', 256, 275, 37.8, 41.9);
INSERT INTO obce VALUES (4457, 'CZ0635', 'Kuklík', 84, 89, 40.0, 42.1);
INSERT INTO obce VALUES (4458, 'CZ0635', 'Kundratice', 92, 92, 38.8, 40.9);
INSERT INTO obce VALUES (4459, 'CZ0635', 'Kyjov', 23, 26, 44.9, 47.3);
INSERT INTO obce VALUES (4460, 'CZ0635', 'Lavičky', 257, 231, 33.5, 37.6);
INSERT INTO obce VALUES (4461, 'CZ0635', 'Lhotka', 86, 78, 37.1, 41.6);
INSERT INTO obce VALUES (4462, 'CZ0635', 'Lísek', 187, 183, 39.5, 38.8);
INSERT INTO obce VALUES (4463, 'CZ0635', 'Líšná', 27, 27, 50.7, 54.8);
INSERT INTO obce VALUES (4464, 'CZ0635', 'Malá Losenice', 138, 129, 39.9, 42.7);
INSERT INTO obce VALUES (4465, 'CZ0635', 'Martinice', 216, 224, 35.0, 37.3);
INSERT INTO obce VALUES (4466, 'CZ0635', 'Matějov', 107, 113, 38.6, 39.3);
INSERT INTO obce VALUES (4467, 'CZ0635', 'Měřín', 985, 977, 37.5, 40.2);
INSERT INTO obce VALUES (4468, 'CZ0635', 'Meziříčko', 84, 97, 36.6, 38.7);
INSERT INTO obce VALUES (4469, 'CZ0635', 'Milasín', 26, 25, 37.9, 45.1);
INSERT INTO obce VALUES (4470, 'CZ0635', 'Milešín', 39, 45, 39.0, 47.4);
INSERT INTO obce VALUES (4471, 'CZ0635', 'Mirošov', 69, 67, 37.3, 39.9);
INSERT INTO obce VALUES (4472, 'CZ0635', 'Moravec', 273, 296, 39.5, 46.0);
INSERT INTO obce VALUES (4473, 'CZ0635', 'Moravecké Pavlovice', 24, 25, 42.2, 53.7);
INSERT INTO obce VALUES (4474, 'CZ0635', 'Netín', 153, 168, 37.4, 40.5);
INSERT INTO obce VALUES (4475, 'CZ0635', 'Nížkov', 466, 478, 35.6, 38.3);
INSERT INTO obce VALUES (4476, 'CZ0635', 'Nová Ves', 77, 89, 37.2, 42.0);
INSERT INTO obce VALUES (4477, 'CZ0635', 'Nová Ves u Nového Města na Moravě', 313, 318, 35.1, 34.6);
INSERT INTO obce VALUES (4478, 'CZ0635', 'Nové Dvory', 142, 171, 37.8, 40.2);
INSERT INTO obce VALUES (4479, 'CZ0635', 'Nové Město na Moravě', 5238, 5219, 38.5, 41.3);
INSERT INTO obce VALUES (4480, 'CZ0635', 'Nové Sady', 103, 87, 36.0, 39.1);
INSERT INTO obce VALUES (4481, 'CZ0635', 'Nové Veselí', 629, 632, 37.9, 41.2);
INSERT INTO obce VALUES (4482, 'CZ0635', 'Nový Jimramov', 27, 37, 45.9, 45.1);
INSERT INTO obce VALUES (4483, 'CZ0635', 'Nyklovice', 83, 87, 38.8, 41.5);
INSERT INTO obce VALUES (4484, 'CZ0635', 'Obyčtov', 191, 202, 38.6, 40.1);
INSERT INTO obce VALUES (4485, 'CZ0635', 'Ořechov', 166, 159, 40.2, 40.5);
INSERT INTO obce VALUES (4486, 'CZ0635', 'Oslavice', 330, 318, 36.2, 39.0);
INSERT INTO obce VALUES (4487, 'CZ0635', 'Oslavička', 43, 54, 42.2, 43.2);
INSERT INTO obce VALUES (4488, 'CZ0635', 'Osová Bítýška', 409, 455, 39.0, 38.6);
INSERT INTO obce VALUES (4489, 'CZ0635', 'Osové', 36, 24, 44.6, 41.7);
INSERT INTO obce VALUES (4490, 'CZ0635', 'Ostrov nad Oslavou', 475, 476, 38.3, 39.2);
INSERT INTO obce VALUES (4491, 'CZ0635', 'Otín', 172, 187, 35.3, 38.8);
INSERT INTO obce VALUES (4492, 'CZ0635', 'Pavlínov', 128, 131, 39.5, 37.1);
INSERT INTO obce VALUES (4493, 'CZ0635', 'Pavlov', 175, 159, 36.2, 41.3);
INSERT INTO obce VALUES (4494, 'CZ0635', 'Petráveč', 85, 87, 39.7, 39.9);
INSERT INTO obce VALUES (4495, 'CZ0635', 'Pikárec', 161, 148, 36.5, 42.1);
INSERT INTO obce VALUES (4496, 'CZ0635', 'Písečné', 108, 92, 38.9, 40.6);
INSERT INTO obce VALUES (4497, 'CZ0635', 'Počítky', 100, 112, 35.7, 36.3);
INSERT INTO obce VALUES (4498, 'CZ0635', 'Poděšín', 122, 120, 37.9, 38.5);
INSERT INTO obce VALUES (4499, 'CZ0635', 'Podolí', 44, 46, 40.4, 40.1);
INSERT INTO obce VALUES (4500, 'CZ0635', 'Pokojov', 88, 72, 36.9, 45.3);
INSERT INTO obce VALUES (4501, 'CZ0635', 'Polnička', 368, 375, 38.7, 39.9);
INSERT INTO obce VALUES (4502, 'CZ0635', 'Prosetín', 211, 192, 37.4, 41.5);
INSERT INTO obce VALUES (4503, 'CZ0635', 'Račice', 22, 23, 40.6, 35.3);
INSERT INTO obce VALUES (4504, 'CZ0635', 'Račín', 55, 46, 34.8, 46.1);
INSERT INTO obce VALUES (4505, 'CZ0635', 'Radenice', 64, 84, 43.7, 40.2);
INSERT INTO obce VALUES (4506, 'CZ0635', 'Radešín', 50, 59, 38.2, 42.4);
INSERT INTO obce VALUES (4507, 'CZ0635', 'Radešínská Svratka', 319, 284, 37.6, 40.2);
INSERT INTO obce VALUES (4508, 'CZ0635', 'Radkov', 89, 80, 40.7, 46.8);
INSERT INTO obce VALUES (4509, 'CZ0635', 'Radňoves', 54, 49, 42.6, 42.5);
INSERT INTO obce VALUES (4510, 'CZ0635', 'Radňovice', 159, 173, 39.7, 39.3);
INSERT INTO obce VALUES (4511, 'CZ0635', 'Radostín', 67, 75, 48.3, 46.4);
INSERT INTO obce VALUES (4512, 'CZ0635', 'Radostín nad Oslavou', 473, 443, 34.8, 37.2);
INSERT INTO obce VALUES (4513, 'CZ0635', 'Rodkov', 45, 52, 40.4, 40.6);
INSERT INTO obce VALUES (4514, 'CZ0635', 'Rosička', 26, 21, 47.3, 44.4);
INSERT INTO obce VALUES (4515, 'CZ0635', 'Rousměrov', 65, 54, 38.2, 45.6);
INSERT INTO obce VALUES (4516, 'CZ0635', 'Rovečné', 321, 313, 41.2, 46.0);
INSERT INTO obce VALUES (4517, 'CZ0635', 'Rozseč', 51, 58, 36.5, 36.9);
INSERT INTO obce VALUES (4518, 'CZ0635', 'Rozsochy', 357, 347, 39.6, 40.8);
INSERT INTO obce VALUES (4519, 'CZ0635', 'Rožná', 402, 368, 37.8, 40.4);
INSERT INTO obce VALUES (4520, 'CZ0635', 'Ruda', 175, 166, 39.3, 41.6);
INSERT INTO obce VALUES (4521, 'CZ0635', 'Rudolec', 101, 111, 38.6, 40.1);
INSERT INTO obce VALUES (4522, 'CZ0635', 'Řečice', 241, 245, 38.5, 39.3);
INSERT INTO obce VALUES (4523, 'CZ0635', 'Sázava', 302, 304, 38.6, 39.3);
INSERT INTO obce VALUES (4524, 'CZ0635', 'Sazomín', 109, 108, 38.7, 40.8);
INSERT INTO obce VALUES (4525, 'CZ0635', 'Sejřek', 73, 86, 40.6, 38.7);
INSERT INTO obce VALUES (4526, 'CZ0635', 'Sirákov', 134, 118, 36.5, 40.3);
INSERT INTO obce VALUES (4527, 'CZ0635', 'Sklené', 54, 52, 39.9, 34.2);
INSERT INTO obce VALUES (4528, 'CZ0635', 'Sklené nad Oslavou', 116, 121, 37.0, 41.6);
INSERT INTO obce VALUES (4529, 'CZ0635', 'Skorotice', 65, 73, 44.7, 46.4);
INSERT INTO obce VALUES (4530, 'CZ0635', 'Skřinářov', 71, 68, 43.8, 47.6);
INSERT INTO obce VALUES (4531, 'CZ0635', 'Sněžné', 375, 361, 39.3, 42.7);
INSERT INTO obce VALUES (4532, 'CZ0635', 'Spělkov', 22, 25, 43.3, 50.7);
INSERT INTO obce VALUES (4533, 'CZ0635', 'Strachujov', 74, 71, 34.7, 47.5);
INSERT INTO obce VALUES (4534, 'CZ0635', 'Stránecká Zhoř', 301, 316, 36.7, 38.5);
INSERT INTO obce VALUES (4535, 'CZ0635', 'Strážek', 418, 481, 41.3, 46.6);
INSERT INTO obce VALUES (4536, 'CZ0635', 'Střítež', 47, 47, 40.4, 43.0);
INSERT INTO obce VALUES (4537, 'CZ0635', 'Sulkovec', 87, 99, 40.8, 47.3);
INSERT INTO obce VALUES (4538, 'CZ0635', 'Světnov', 225, 226, 39.0, 41.3);
INSERT INTO obce VALUES (4539, 'CZ0635', 'Sviny', 50, 55, 38.3, 41.4);
INSERT INTO obce VALUES (4540, 'CZ0635', 'Svratka', 736, 733, 40.6, 46.5);
INSERT INTO obce VALUES (4541, 'CZ0635', 'Škrdlovice', 281, 331, 40.3, 45.2);
INSERT INTO obce VALUES (4542, 'CZ0635', 'Štěpánov nad Svratkou', 367, 358, 39.9, 43.6);
INSERT INTO obce VALUES (4543, 'CZ0635', 'Tasov', 303, 311, 39.4, 40.7);
INSERT INTO obce VALUES (4544, 'CZ0635', 'Tři Studně', 55, 44, 41.4, 40.0);
INSERT INTO obce VALUES (4545, 'CZ0635', 'Ubušínek', 47, 41, 41.0, 44.1);
INSERT INTO obce VALUES (4546, 'CZ0635', 'Uhřínov', 151, 124, 37.1, 40.1);
INSERT INTO obce VALUES (4547, 'CZ0635', 'Ujčov', 237, 257, 38.9, 40.2);
INSERT INTO obce VALUES (4548, 'CZ0635', 'Újezd', 116, 102, 41.9, 42.4);
INSERT INTO obce VALUES (4549, 'CZ0635', 'Unčín', 102, 102, 37.7, 39.0);
INSERT INTO obce VALUES (4550, 'CZ0635', 'Vatín', 164, 167, 39.4, 37.8);
INSERT INTO obce VALUES (4551, 'CZ0635', 'Věcov', 363, 322, 37.9, 39.8);
INSERT INTO obce VALUES (4552, 'CZ0635', 'Věchnov', 170, 162, 38.7, 38.7);
INSERT INTO obce VALUES (4553, 'CZ0635', 'Velká Bíteš', 2500, 2501, 37.2, 40.5);
INSERT INTO obce VALUES (4554, 'CZ0635', 'Velká Losenice', 572, 573, 35.2, 36.5);
INSERT INTO obce VALUES (4555, 'CZ0635', 'Velké Janovice', 67, 59, 40.0, 38.9);
INSERT INTO obce VALUES (4556, 'CZ0635', 'Velké Meziříčí', 5799, 6024, 37.7, 41.2);
INSERT INTO obce VALUES (4557, 'CZ0635', 'Velké Tresné', 55, 62, 45.6, 49.5);
INSERT INTO obce VALUES (4558, 'CZ0635', 'Vepřová', 221, 199, 35.4, 40.2);
INSERT INTO obce VALUES (4559, 'CZ0635', 'Věstín', 88, 72, 40.1, 47.5);
INSERT INTO obce VALUES (4560, 'CZ0635', 'Věžná', 108, 101, 40.2, 44.9);
INSERT INTO obce VALUES (4561, 'CZ0635', 'Vídeň', 215, 191, 37.1, 39.6);
INSERT INTO obce VALUES (4562, 'CZ0635', 'Vidonín', 83, 85, 36.9, 38.7);
INSERT INTO obce VALUES (4563, 'CZ0635', 'Vír', 359, 373, 40.8, 42.3);
INSERT INTO obce VALUES (4564, 'CZ0635', 'Vlachovice', 53, 57, 40.3, 40.0);
INSERT INTO obce VALUES (4565, 'CZ0635', 'Vlkov', 134, 135, 39.4, 43.1);
INSERT INTO obce VALUES (4566, 'CZ0635', 'Vojnův Městec', 386, 369, 39.8, 42.4);
INSERT INTO obce VALUES (4567, 'CZ0635', 'Vysoké', 61, 62, 36.2, 41.8);
INSERT INTO obce VALUES (4568, 'CZ0635', 'Záblatí', 92, 86, 39.5, 39.6);
INSERT INTO obce VALUES (4569, 'CZ0635', 'Zadní Zhořec', 70, 76, 36.8, 37.3);
INSERT INTO obce VALUES (4570, 'CZ0635', 'Znětínek', 106, 100, 34.0, 38.3);
INSERT INTO obce VALUES (4571, 'CZ0635', 'Zubří', 205, 214, 36.0, 37.1);
INSERT INTO obce VALUES (4572, 'CZ0635', 'Zvole', 320, 309, 37.6, 38.7);
INSERT INTO obce VALUES (4573, 'CZ0635', 'Ždánice', 82, 101, 38.5, 40.3);
INSERT INTO obce VALUES (4574, 'CZ0635', 'Žďár nad Sázavou', 11509, 11750, 39.4, 42.0);
INSERT INTO obce VALUES (4575, 'CZ0641', 'Adamov', 2320, 2371, 39.7, 42.5);
INSERT INTO obce VALUES (4576, 'CZ0641', 'Bedřichov', 126, 124, 36.5, 41.1);
INSERT INTO obce VALUES (4577, 'CZ0641', 'Benešov', 327, 336, 38.1, 41.8);
INSERT INTO obce VALUES (4578, 'CZ0641', 'Blansko', 10163, 10894, 40.0, 42.9);
INSERT INTO obce VALUES (4579, 'CZ0641', 'Borotín', 205, 214, 39.2, 42.8);
INSERT INTO obce VALUES (4580, 'CZ0641', 'Bořitov', 638, 646, 38.8, 42.5);
INSERT INTO obce VALUES (4581, 'CZ0641', 'Boskovice', 5257, 5660, 39.7, 43.5);
INSERT INTO obce VALUES (4582, 'CZ0641', 'Brťov-Jeneč', 163, 186, 40.3, 44.6);
INSERT INTO obce VALUES (4583, 'CZ0641', 'Bukovina', 164, 175, 36.6, 39.3);
INSERT INTO obce VALUES (4584, 'CZ0641', 'Bukovinka', 211, 217, 38.5, 42.2);
INSERT INTO obce VALUES (4585, 'CZ0641', 'Býkovice', 101, 94, 39.1, 42.5);
INSERT INTO obce VALUES (4586, 'CZ0641', 'Cetkovice', 366, 378, 37.8, 39.7);
INSERT INTO obce VALUES (4587, 'CZ0641', 'Crhov', 94, 77, 39.7, 38.7);
INSERT INTO obce VALUES (4588, 'CZ0641', 'Černá Hora', 907, 1037, 39.2, 43.7);
INSERT INTO obce VALUES (4589, 'CZ0641', 'Černovice', 185, 171, 36.7, 38.2);
INSERT INTO obce VALUES (4590, 'CZ0641', 'Deštná', 116, 116, 40.5, 41.4);
INSERT INTO obce VALUES (4591, 'CZ0641', 'Dlouhá Lhota', 59, 54, 37.7, 43.2);
INSERT INTO obce VALUES (4592, 'CZ0641', 'Doubravice nad Svitavou', 655, 632, 39.0, 42.0);
INSERT INTO obce VALUES (4593, 'CZ0641', 'Drnovice', 591, 610, 37.3, 38.4);
INSERT INTO obce VALUES (4594, 'CZ0641', 'Habrůvka', 179, 189, 41.9, 44.8);
INSERT INTO obce VALUES (4595, 'CZ0641', 'Hodonín', 60, 65, 43.6, 45.6);
INSERT INTO obce VALUES (4596, 'CZ0641', 'Holštejn', 79, 72, 39.1, 46.2);
INSERT INTO obce VALUES (4597, 'CZ0641', 'Horní Poříčí', 128, 127, 39.5, 42.8);
INSERT INTO obce VALUES (4598, 'CZ0641', 'Horní Smržov', 66, 68, 35.4, 37.5);
INSERT INTO obce VALUES (4599, 'CZ0641', 'Chrudichromy', 115, 89, 37.8, 39.0);
INSERT INTO obce VALUES (4600, 'CZ0641', 'Jabloňany', 203, 192, 36.5, 40.8);
INSERT INTO obce VALUES (4601, 'CZ0641', 'Jedovnice', 1327, 1375, 38.9, 41.3);
INSERT INTO obce VALUES (4602, 'CZ0641', 'Kněževes', 89, 90, 38.1, 47.0);
INSERT INTO obce VALUES (4603, 'CZ0641', 'Knínice u Boskovic', 409, 415, 38.1, 40.5);
INSERT INTO obce VALUES (4604, 'CZ0641', 'Kořenec', 179, 177, 37.5, 42.3);
INSERT INTO obce VALUES (4605, 'CZ0641', 'Kotvrdovice', 407, 435, 40.3, 42.4);
INSERT INTO obce VALUES (4606, 'CZ0641', 'Kozárov', 55, 64, 41.7, 39.3);
INSERT INTO obce VALUES (4607, 'CZ0641', 'Krasová', 137, 141, 40.7, 41.7);
INSERT INTO obce VALUES (4608, 'CZ0641', 'Krhov', 67, 69, 41.1, 46.2);
INSERT INTO obce VALUES (4609, 'CZ0641', 'Křetín', 245, 257, 40.4, 41.9);
INSERT INTO obce VALUES (4610, 'CZ0641', 'Křtěnov', 115, 119, 38.7, 38.3);
INSERT INTO obce VALUES (4611, 'CZ0641', 'Křtiny', 380, 405, 40.7, 43.5);
INSERT INTO obce VALUES (4612, 'CZ0641', 'Kulířov', 104, 88, 45.8, 53.8);
INSERT INTO obce VALUES (4613, 'CZ0641', 'Kunčina Ves', 26, 27, 39.6, 45.1);
INSERT INTO obce VALUES (4614, 'CZ0641', 'Kunice', 66, 62, 36.0, 40.6);
INSERT INTO obce VALUES (4615, 'CZ0641', 'Kuničky', 140, 141, 39.3, 41.1);
INSERT INTO obce VALUES (4616, 'CZ0641', 'Kunštát', 1343, 1360, 36.8, 39.7);
INSERT INTO obce VALUES (4617, 'CZ0641', 'Lazinov', 73, 80, 40.9, 42.1);
INSERT INTO obce VALUES (4618, 'CZ0641', 'Lažany', 176, 200, 40.4, 42.4);
INSERT INTO obce VALUES (4619, 'CZ0641', 'Letovice', 3393, 3547, 39.4, 43.0);
INSERT INTO obce VALUES (4620, 'CZ0641', 'Lhota Rapotina', 207, 192, 40.0, 42.8);
INSERT INTO obce VALUES (4621, 'CZ0641', 'Lhota u Lysic', 71, 56, 41.9, 45.3);
INSERT INTO obce VALUES (4622, 'CZ0641', 'Lhota u Olešnice', 20, 18, 42.2, 48.9);
INSERT INTO obce VALUES (4623, 'CZ0641', 'Lipovec', 544, 538, 37.6, 41.8);
INSERT INTO obce VALUES (4624, 'CZ0641', 'Lipůvka', 572, 644, 40.0, 41.2);
INSERT INTO obce VALUES (4625, 'CZ0641', 'Louka', 28, 35, 44.9, 53.7);
INSERT INTO obce VALUES (4626, 'CZ0641', 'Lubě', 50, 54, 41.3, 44.0);
INSERT INTO obce VALUES (4627, 'CZ0641', 'Ludíkov', 151, 141, 35.3, 40.9);
INSERT INTO obce VALUES (4628, 'CZ0641', 'Lysice', 977, 971, 39.2, 39.9);
INSERT INTO obce VALUES (4629, 'CZ0641', 'Makov', 21, 27, 55.1, 48.5);
INSERT INTO obce VALUES (4630, 'CZ0641', 'Malá Lhota', 64, 72, 44.3, 42.8);
INSERT INTO obce VALUES (4631, 'CZ0641', 'Malá Roudka', 100, 92, 42.7, 45.8);
INSERT INTO obce VALUES (4632, 'CZ0641', 'Míchov', 71, 74, 34.5, 42.6);
INSERT INTO obce VALUES (4633, 'CZ0641', 'Milonice', 92, 97, 38.6, 43.1);
INSERT INTO obce VALUES (4634, 'CZ0641', 'Němčice', 213, 213, 38.8, 42.9);
INSERT INTO obce VALUES (4635, 'CZ0641', 'Nýrov', 96, 103, 38.6, 43.8);
INSERT INTO obce VALUES (4636, 'CZ0641', 'Obora', 153, 160, 36.7, 40.4);
INSERT INTO obce VALUES (4637, 'CZ0641', 'Okrouhlá', 280, 266, 37.0, 40.9);
INSERT INTO obce VALUES (4638, 'CZ0641', 'Olešnice', 861, 871, 38.6, 41.5);
INSERT INTO obce VALUES (4639, 'CZ0641', 'Olomučany', 483, 449, 41.0, 44.4);
INSERT INTO obce VALUES (4640, 'CZ0641', 'Ostrov u Macochy', 567, 536, 39.0, 44.7);
INSERT INTO obce VALUES (4641, 'CZ0641', 'Pamětice', 122, 105, 35.0, 40.2);
INSERT INTO obce VALUES (4642, 'CZ0641', 'Petrov', 80, 72, 38.2, 41.1);
INSERT INTO obce VALUES (4643, 'CZ0641', 'Petrovice', 279, 300, 38.5, 39.5);
INSERT INTO obce VALUES (4644, 'CZ0641', 'Prostřední Poříčí', 148, 119, 37.1, 44.8);
INSERT INTO obce VALUES (4645, 'CZ0641', 'Rájec-Jestřebí', 1868, 1889, 39.1, 41.9);
INSERT INTO obce VALUES (4646, 'CZ0641', 'Ráječko', 627, 609, 39.3, 41.3);
INSERT INTO obce VALUES (4647, 'CZ0641', 'Roubanina', 56, 81, 39.8, 39.3);
INSERT INTO obce VALUES (4648, 'CZ0641', 'Rozseč nad Kunštátem', 261, 253, 38.0, 38.0);
INSERT INTO obce VALUES (4649, 'CZ0641', 'Rozsíčka', 85, 71, 39.8, 40.2);
INSERT INTO obce VALUES (4650, 'CZ0641', 'Rudice', 454, 457, 39.3, 42.1);
INSERT INTO obce VALUES (4651, 'CZ0641', 'Sebranice', 305, 303, 38.6, 40.0);
INSERT INTO obce VALUES (4652, 'CZ0641', 'Senetářov', 252, 276, 39.1, 41.2);
INSERT INTO obce VALUES (4653, 'CZ0641', 'Skalice nad Svitavou', 302, 320, 37.1, 40.5);
INSERT INTO obce VALUES (4654, 'CZ0641', 'Skrchov', 49, 54, 34.5, 38.0);
INSERT INTO obce VALUES (4655, 'CZ0641', 'Sloup', 477, 473, 39.1, 40.9);
INSERT INTO obce VALUES (4656, 'CZ0641', 'Spešov', 283, 290, 39.4, 41.0);
INSERT INTO obce VALUES (4657, 'CZ0641', 'Stvolová', 68, 70, 44.3, 45.2);
INSERT INTO obce VALUES (4658, 'CZ0641', 'Sudice', 219, 238, 37.1, 40.1);
INSERT INTO obce VALUES (4659, 'CZ0641', 'Suchý', 220, 223, 35.7, 40.0);
INSERT INTO obce VALUES (4660, 'CZ0641', 'Sulíkov', 134, 128, 39.4, 38.6);
INSERT INTO obce VALUES (4661, 'CZ0641', 'Světlá', 114, 109, 37.5, 41.3);
INSERT INTO obce VALUES (4662, 'CZ0641', 'Svinošice', 147, 136, 35.9, 42.3);
INSERT INTO obce VALUES (4663, 'CZ0641', 'Svitávka', 862, 868, 38.0, 42.0);
INSERT INTO obce VALUES (4664, 'CZ0641', 'Šebetov', 374, 542, 38.6, 45.1);
INSERT INTO obce VALUES (4665, 'CZ0641', 'Šebrov-Kateřina', 350, 399, 37.8, 39.6);
INSERT INTO obce VALUES (4666, 'CZ0641', 'Šošůvka', 365, 357, 39.0, 42.3);
INSERT INTO obce VALUES (4667, 'CZ0641', 'Štěchov', 82, 81, 36.7, 40.5);
INSERT INTO obce VALUES (4668, 'CZ0641', 'Tasovice', 36, 42, 36.1, 37.5);
INSERT INTO obce VALUES (4669, 'CZ0641', 'Uhřice', 140, 151, 39.4, 42.6);
INSERT INTO obce VALUES (4670, 'CZ0641', 'Újezd u Boskovic', 227, 219, 37.6, 43.1);
INSERT INTO obce VALUES (4671, 'CZ0641', 'Újezd u Černé Hory', 118, 128, 38.4, 41.0);
INSERT INTO obce VALUES (4672, 'CZ0641', 'Úsobrno', 207, 229, 42.8, 45.1);
INSERT INTO obce VALUES (4673, 'CZ0641', 'Ústup', 20, 22, 40.6, 42.1);
INSERT INTO obce VALUES (4674, 'CZ0641', 'Valchov', 240, 241, 38.3, 38.5);
INSERT INTO obce VALUES (4675, 'CZ0641', 'Vanovice', 269, 274, 39.1, 41.4);
INSERT INTO obce VALUES (4676, 'CZ0641', 'Vavřinec', 428, 432, 39.6, 42.3);
INSERT INTO obce VALUES (4677, 'CZ0641', 'Vážany', 102, 105, 35.5, 43.4);
INSERT INTO obce VALUES (4678, 'CZ0641', 'Velenov', 96, 109, 35.9, 41.3);
INSERT INTO obce VALUES (4679, 'CZ0641', 'Velké Opatovice', 2089, 1982, 38.9, 41.1);
INSERT INTO obce VALUES (4680, 'CZ0641', 'Vilémovice', 144, 153, 44.2, 45.1);
INSERT INTO obce VALUES (4681, 'CZ0641', 'Vísky', 112, 122, 39.3, 40.3);
INSERT INTO obce VALUES (4682, 'CZ0641', 'Voděrady', 258, 266, 38.7, 41.5);
INSERT INTO obce VALUES (4683, 'CZ0641', 'Vranová', 174, 160, 41.1, 40.6);
INSERT INTO obce VALUES (4684, 'CZ0641', 'Vysočany', 413, 403, 40.0, 42.4);
INSERT INTO obce VALUES (4685, 'CZ0641', 'Závist', 67, 66, 40.7, 40.2);
INSERT INTO obce VALUES (4686, 'CZ0641', 'Zbraslavec', 94, 94, 43.4, 44.7);
INSERT INTO obce VALUES (4687, 'CZ0641', 'Žďár', 202, 179, 40.1, 40.9);
INSERT INTO obce VALUES (4688, 'CZ0641', 'Žďárná', 373, 390, 37.5, 39.1);
INSERT INTO obce VALUES (4689, 'CZ0641', 'Žernovník', 112, 107, 41.8, 39.3);
INSERT INTO obce VALUES (4690, 'CZ0641', 'Žerůtky', 25, 28, 48.5, 46.7);
INSERT INTO obce VALUES (4691, 'CZ0642', 'Brno', 178429, 192970, 40.1, 43.8);
INSERT INTO obce VALUES (4692, 'CZ0643', 'Babice nad Svitavou', 493, 498, 39.6, 41.6);
INSERT INTO obce VALUES (4693, 'CZ0643', 'Babice u Rosic', 305, 333, 37.5, 39.3);
INSERT INTO obce VALUES (4694, 'CZ0643', 'Běleč', 95, 98, 41.0, 43.3);
INSERT INTO obce VALUES (4695, 'CZ0643', 'Bílovice nad Svitavou', 1643, 1655, 35.0, 38.5);
INSERT INTO obce VALUES (4696, 'CZ0643', 'Biskoupky', 87, 92, 43.9, 41.2);
INSERT INTO obce VALUES (4697, 'CZ0643', 'Blažovice', 565, 548, 38.2, 41.7);
INSERT INTO obce VALUES (4698, 'CZ0643', 'Blučina', 1033, 1065, 39.1, 41.9);
INSERT INTO obce VALUES (4699, 'CZ0643', 'Borač', 172, 151, 40.0, 43.9);
INSERT INTO obce VALUES (4700, 'CZ0643', 'Borovník', 43, 51, 38.0, 37.4);
INSERT INTO obce VALUES (4701, 'CZ0643', 'Braníškov', 86, 107, 41.7, 42.9);
INSERT INTO obce VALUES (4702, 'CZ0643', 'Branišovice', 274, 262, 38.3, 41.1);
INSERT INTO obce VALUES (4703, 'CZ0643', 'Bratčice', 412, 367, 39.1, 42.0);
INSERT INTO obce VALUES (4704, 'CZ0643', 'Brumov', 125, 121, 38.5, 40.3);
INSERT INTO obce VALUES (4705, 'CZ0643', 'Březina (dříve okres Blansko)', 359, 366, 41.5, 40.5);
INSERT INTO obce VALUES (4706, 'CZ0643', 'Březina (dříve okres Tišnov)', 134, 130, 39.0, 45.4);
INSERT INTO obce VALUES (4707, 'CZ0643', 'Bukovice', 31, 27, 48.4, 48.4);
INSERT INTO obce VALUES (4708, 'CZ0643', 'Cvrčovice', 310, 296, 37.9, 40.2);
INSERT INTO obce VALUES (4709, 'CZ0643', 'Čebín', 870, 838, 38.8, 40.7);
INSERT INTO obce VALUES (4710, 'CZ0643', 'Černvír', 82, 79, 42.6, 47.6);
INSERT INTO obce VALUES (4711, 'CZ0643', 'Česká', 378, 417, 38.9, 42.4);
INSERT INTO obce VALUES (4712, 'CZ0643', 'Čučice', 203, 208, 38.2, 45.0);
INSERT INTO obce VALUES (4713, 'CZ0643', 'Deblín', 509, 488, 38.3, 40.1);
INSERT INTO obce VALUES (4714, 'CZ0643', 'Dolní Kounice', 1152, 1148, 37.3, 40.7);
INSERT INTO obce VALUES (4715, 'CZ0643', 'Dolní Loučky', 601, 613, 38.9, 41.5);
INSERT INTO obce VALUES (4716, 'CZ0643', 'Domašov', 280, 296, 38.8, 38.8);
INSERT INTO obce VALUES (4717, 'CZ0643', 'Doubravník', 405, 407, 41.4, 41.4);
INSERT INTO obce VALUES (4718, 'CZ0643', 'Drahonín', 54, 61, 38.3, 38.1);
INSERT INTO obce VALUES (4719, 'CZ0643', 'Drásov', 668, 640, 37.8, 41.3);
INSERT INTO obce VALUES (4720, 'CZ0643', 'Hajany', 174, 170, 40.5, 42.5);
INSERT INTO obce VALUES (4721, 'CZ0643', 'Heroltice', 97, 92, 39.5, 41.6);
INSERT INTO obce VALUES (4722, 'CZ0643', 'Hlína', 243, 182, 38.6, 40.7);
INSERT INTO obce VALUES (4723, 'CZ0643', 'Hluboké Dvory', 43, 32, 48.4, 51.6);
INSERT INTO obce VALUES (4724, 'CZ0643', 'Holasice', 452, 451, 38.1, 43.3);
INSERT INTO obce VALUES (4725, 'CZ0643', 'Horní Loučky', 151, 146, 39.4, 45.6);
INSERT INTO obce VALUES (4726, 'CZ0643', 'Hostěnice', 304, 291, 37.3, 39.4);
INSERT INTO obce VALUES (4727, 'CZ0643', 'Hradčany', 271, 273, 38.3, 41.7);
INSERT INTO obce VALUES (4728, 'CZ0643', 'Hrušovany u Brna', 1573, 1674, 36.8, 39.1);
INSERT INTO obce VALUES (4729, 'CZ0643', 'Hvozdec', 123, 130, 40.5, 40.7);
INSERT INTO obce VALUES (4730, 'CZ0643', 'Chudčice', 456, 414, 39.0, 40.4);
INSERT INTO obce VALUES (4731, 'CZ0643', 'Ivaň', 345, 353, 39.8, 44.0);
INSERT INTO obce VALUES (4732, 'CZ0643', 'Ivančice', 4566, 4780, 39.7, 42.7);
INSERT INTO obce VALUES (4733, 'CZ0643', 'Javůrek', 117, 137, 41.3, 42.3);
INSERT INTO obce VALUES (4734, 'CZ0643', 'Jinačovice', 304, 303, 40.5, 41.4);
INSERT INTO obce VALUES (4735, 'CZ0643', 'Jiříkovice', 438, 452, 38.5, 40.0);
INSERT INTO obce VALUES (4736, 'CZ0643', 'Kaly', 128, 120, 44.1, 44.0);
INSERT INTO obce VALUES (4737, 'CZ0643', 'Kanice', 377, 375, 37.7, 39.8);
INSERT INTO obce VALUES (4738, 'CZ0643', 'Katov', 104, 98, 37.0, 38.7);
INSERT INTO obce VALUES (4739, 'CZ0643', 'Ketkovice', 302, 316, 40.9, 42.1);
INSERT INTO obce VALUES (4740, 'CZ0643', 'Kobylnice', 464, 487, 39.3, 39.2);
INSERT INTO obce VALUES (4741, 'CZ0643', 'Kovalovice', 287, 305, 39.5, 42.3);
INSERT INTO obce VALUES (4742, 'CZ0643', 'Kratochvilka', 235, 199, 39.1, 45.4);
INSERT INTO obce VALUES (4743, 'CZ0643', 'Křižínkov', 103, 83, 43.0, 45.5);
INSERT INTO obce VALUES (4744, 'CZ0643', 'Kupařovice', 128, 127, 34.0, 38.3);
INSERT INTO obce VALUES (4745, 'CZ0643', 'Kuřim', 5190, 5442, 37.5, 40.0);
INSERT INTO obce VALUES (4746, 'CZ0643', 'Kuřimská Nová Ves', 65, 62, 42.8, 44.7);
INSERT INTO obce VALUES (4747, 'CZ0643', 'Kuřimské Jestřabí', 60, 80, 41.9, 46.2);
INSERT INTO obce VALUES (4748, 'CZ0643', 'Lažánky', 342, 338, 40.8, 44.6);
INSERT INTO obce VALUES (4749, 'CZ0643', 'Ledce', 109, 104, 40.7, 44.2);
INSERT INTO obce VALUES (4750, 'CZ0643', 'Lelekovice', 845, 878, 39.1, 41.6);
INSERT INTO obce VALUES (4751, 'CZ0643', 'Lesní Hluboké', 102, 95, 41.8, 37.8);
INSERT INTO obce VALUES (4752, 'CZ0643', 'Litostrov', 62, 62, 35.4, 42.8);
INSERT INTO obce VALUES (4753, 'CZ0643', 'Loděnice', 234, 208, 38.9, 43.4);
INSERT INTO obce VALUES (4754, 'CZ0643', 'Lomnice', 668, 680, 37.8, 40.9);
INSERT INTO obce VALUES (4755, 'CZ0643', 'Lomnička', 234, 237, 35.8, 38.7);
INSERT INTO obce VALUES (4756, 'CZ0643', 'Lubné', 21, 28, 46.7, 42.4);
INSERT INTO obce VALUES (4757, 'CZ0643', 'Lukovany', 274, 297, 37.4, 42.4);
INSERT INTO obce VALUES (4758, 'CZ0643', 'Malešovice', 205, 172, 33.3, 35.3);
INSERT INTO obce VALUES (4759, 'CZ0643', 'Malhostovice', 453, 425, 40.8, 43.1);
INSERT INTO obce VALUES (4760, 'CZ0643', 'Maršov', 245, 249, 38.7, 40.4);
INSERT INTO obce VALUES (4761, 'CZ0643', 'Medlov', 304, 344, 36.2, 40.2);
INSERT INTO obce VALUES (4762, 'CZ0643', 'Mělčany', 223, 222, 38.9, 42.0);
INSERT INTO obce VALUES (4763, 'CZ0643', 'Měnín', 846, 873, 37.0, 39.3);
INSERT INTO obce VALUES (4764, 'CZ0643', 'Modřice', 2190, 2231, 39.8, 41.6);
INSERT INTO obce VALUES (4765, 'CZ0643', 'Mokrá-Horákov', 1296, 1391, 38.8, 40.1);
INSERT INTO obce VALUES (4766, 'CZ0643', 'Moravany', 909, 1032, 35.1, 37.4);
INSERT INTO obce VALUES (4767, 'CZ0643', 'Moravské Bránice', 460, 503, 38.8, 41.2);
INSERT INTO obce VALUES (4768, 'CZ0643', 'Moravské Knínice', 422, 434, 40.1, 42.0);
INSERT INTO obce VALUES (4769, 'CZ0643', 'Moutnice', 607, 596, 38.3, 40.9);
INSERT INTO obce VALUES (4770, 'CZ0643', 'Nebovidy', 287, 300, 40.9, 40.9);
INSERT INTO obce VALUES (4771, 'CZ0643', 'Nedvědice', 691, 680, 40.0, 42.0);
INSERT INTO obce VALUES (4772, 'CZ0643', 'Nelepeč-Žernůvka', 28, 52, 51.7, 64.6);
INSERT INTO obce VALUES (4773, 'CZ0643', 'Němčičky', 172, 172, 35.9, 35.7);
INSERT INTO obce VALUES (4774, 'CZ0643', 'Neslovice', 454, 455, 36.6, 40.8);
INSERT INTO obce VALUES (4775, 'CZ0643', 'Nesvačilka', 161, 158, 39.8, 42.4);
INSERT INTO obce VALUES (4776, 'CZ0643', 'Níhov', 97, 106, 36.4, 41.7);
INSERT INTO obce VALUES (4777, 'CZ0643', 'Nosislav', 629, 631, 38.1, 42.1);
INSERT INTO obce VALUES (4778, 'CZ0643', 'Nová Ves', 377, 386, 38.2, 39.7);
INSERT INTO obce VALUES (4779, 'CZ0643', 'Nové Bránice', 369, 584, 37.7, 39.2);
INSERT INTO obce VALUES (4780, 'CZ0643', 'Odrovice', 84, 73, 39.7, 38.7);
INSERT INTO obce VALUES (4781, 'CZ0643', 'Ochoz u Brna', 631, 629, 41.0, 42.2);
INSERT INTO obce VALUES (4782, 'CZ0643', 'Ochoz u Tišnova', 49, 60, 45.7, 40.1);
INSERT INTO obce VALUES (4783, 'CZ0643', 'Olší', 151, 141, 35.2, 39.8);
INSERT INTO obce VALUES (4784, 'CZ0643', 'Omice', 381, 363, 40.4, 42.7);
INSERT INTO obce VALUES (4785, 'CZ0643', 'Opatovice', 491, 483, 38.5, 43.1);
INSERT INTO obce VALUES (4786, 'CZ0643', 'Ořechov', 1195, 1207, 40.1, 42.5);
INSERT INTO obce VALUES (4787, 'CZ0643', 'Osiky', 68, 60, 43.8, 47.2);
INSERT INTO obce VALUES (4788, 'CZ0643', 'Oslavany', 2313, 2304, 39.1, 41.8);
INSERT INTO obce VALUES (4789, 'CZ0643', 'Ostopovice', 719, 776, 39.8, 43.4);
INSERT INTO obce VALUES (4790, 'CZ0643', 'Ostrovačice', 307, 334, 38.6, 42.2);
INSERT INTO obce VALUES (4791, 'CZ0643', 'Otmarov', 121, 120, 36.9, 36.6);
INSERT INTO obce VALUES (4792, 'CZ0643', 'Pasohlávky', 366, 368, 36.7, 38.4);
INSERT INTO obce VALUES (4793, 'CZ0643', 'Pernštejnské Jestřabí', 86, 87, 45.4, 46.2);
INSERT INTO obce VALUES (4794, 'CZ0643', 'Podolí', 658, 594, 38.7, 42.7);
INSERT INTO obce VALUES (4795, 'CZ0643', 'Pohořelice', 2220, 2335, 39.0, 42.3);
INSERT INTO obce VALUES (4796, 'CZ0643', 'Ponětovice', 177, 195, 35.8, 39.3);
INSERT INTO obce VALUES (4797, 'CZ0643', 'Popovice', 181, 171, 40.1, 38.6);
INSERT INTO obce VALUES (4798, 'CZ0643', 'Popůvky', 500, 558, 37.6, 36.4);
INSERT INTO obce VALUES (4799, 'CZ0643', 'Pozořice', 1074, 1086, 37.9, 41.8);
INSERT INTO obce VALUES (4800, 'CZ0643', 'Prace', 446, 460, 38.9, 41.1);
INSERT INTO obce VALUES (4801, 'CZ0643', 'Pravlov', 289, 276, 38.3, 40.5);
INSERT INTO obce VALUES (4802, 'CZ0643', 'Prštice', 453, 461, 39.5, 43.6);
INSERT INTO obce VALUES (5893, 'CZ0724', 'Křekov', 80, 86, 33.6, 43.0);
INSERT INTO obce VALUES (4803, 'CZ0643', 'Předklášteří', 704, 768, 40.4, 45.5);
INSERT INTO obce VALUES (4804, 'CZ0643', 'Přibice', 543, 511, 38.8, 42.3);
INSERT INTO obce VALUES (4805, 'CZ0643', 'Příbram na Moravě', 282, 297, 41.8, 44.7);
INSERT INTO obce VALUES (4806, 'CZ0643', 'Přibyslavice', 225, 231, 40.2, 42.9);
INSERT INTO obce VALUES (4807, 'CZ0643', 'Přísnotice', 386, 412, 40.4, 42.0);
INSERT INTO obce VALUES (4808, 'CZ0643', 'Radostice', 368, 350, 38.5, 42.2);
INSERT INTO obce VALUES (4809, 'CZ0643', 'Rajhrad', 1469, 1543, 39.3, 43.0);
INSERT INTO obce VALUES (4810, 'CZ0643', 'Rajhradice', 586, 640, 39.2, 40.3);
INSERT INTO obce VALUES (4811, 'CZ0643', 'Rašov', 112, 88, 41.9, 45.6);
INSERT INTO obce VALUES (4812, 'CZ0643', 'Rebešovice', 391, 395, 37.3, 38.2);
INSERT INTO obce VALUES (4813, 'CZ0643', 'Rohozec', 110, 110, 40.0, 44.6);
INSERT INTO obce VALUES (4814, 'CZ0643', 'Rojetín', 34, 40, 43.3, 37.0);
INSERT INTO obce VALUES (4815, 'CZ0643', 'Rosice', 2691, 2815, 38.0, 41.7);
INSERT INTO obce VALUES (4816, 'CZ0643', 'Rozdrojovice', 422, 428, 38.2, 40.7);
INSERT INTO obce VALUES (4817, 'CZ0643', 'Rudka', 173, 177, 37.4, 42.4);
INSERT INTO obce VALUES (4818, 'CZ0643', 'Řícmanice', 371, 344, 38.7, 41.0);
INSERT INTO obce VALUES (4819, 'CZ0643', 'Říčany', 875, 923, 39.3, 42.9);
INSERT INTO obce VALUES (4820, 'CZ0643', 'Říčky', 159, 170, 41.3, 38.8);
INSERT INTO obce VALUES (4821, 'CZ0643', 'Řikonín', 21, 13, 42.2, 55.2);
INSERT INTO obce VALUES (4822, 'CZ0643', 'Senorady', 196, 202, 42.1, 44.9);
INSERT INTO obce VALUES (4823, 'CZ0643', 'Sentice', 279, 279, 39.4, 39.8);
INSERT INTO obce VALUES (4824, 'CZ0643', 'Silůvky', 450, 409, 38.9, 41.8);
INSERT INTO obce VALUES (4825, 'CZ0643', 'Sivice', 483, 497, 39.1, 41.1);
INSERT INTO obce VALUES (4826, 'CZ0643', 'Skalička', 53, 49, 34.6, 39.9);
INSERT INTO obce VALUES (4827, 'CZ0643', 'Skryje', 27, 36, 45.9, 48.8);
INSERT INTO obce VALUES (4828, 'CZ0643', 'Sobotovice', 231, 244, 39.2, 43.3);
INSERT INTO obce VALUES (4829, 'CZ0643', 'Sokolnice', 1030, 1125, 38.0, 41.4);
INSERT INTO obce VALUES (4830, 'CZ0643', 'Stanoviště', 166, 179, 37.5, 39.9);
INSERT INTO obce VALUES (4831, 'CZ0643', 'Strhaře', 66, 64, 40.7, 43.3);
INSERT INTO obce VALUES (4832, 'CZ0643', 'Střelice', 1361, 1345, 39.4, 43.9);
INSERT INTO obce VALUES (4833, 'CZ0643', 'Svatoslav', 196, 218, 40.8, 43.3);
INSERT INTO obce VALUES (4834, 'CZ0643', 'Synalov', 53, 49, 41.7, 47.6);
INSERT INTO obce VALUES (4835, 'CZ0643', 'Syrovice', 652, 625, 35.8, 39.1);
INSERT INTO obce VALUES (4836, 'CZ0643', 'Šerkovice', 119, 116, 38.0, 42.1);
INSERT INTO obce VALUES (4837, 'CZ0643', 'Šlapanice', 3412, 3581, 39.9, 42.2);
INSERT INTO obce VALUES (4838, 'CZ0643', 'Štěpánovice', 225, 218, 39.2, 41.8);
INSERT INTO obce VALUES (4839, 'CZ0643', 'Šumice', 123, 114, 38.6, 39.8);
INSERT INTO obce VALUES (4840, 'CZ0643', 'Telnice', 700, 729, 37.2, 40.4);
INSERT INTO obce VALUES (4841, 'CZ0643', 'Těšany', 600, 622, 37.6, 40.9);
INSERT INTO obce VALUES (4842, 'CZ0643', 'Tetčice', 478, 521, 39.7, 40.9);
INSERT INTO obce VALUES (4843, 'CZ0643', 'Tišnov', 4060, 4515, 39.1, 42.6);
INSERT INTO obce VALUES (4844, 'CZ0643', 'Tišnovská Nová Ves', 35, 38, 46.7, 38.1);
INSERT INTO obce VALUES (4845, 'CZ0643', 'Trboušany', 158, 174, 41.3, 42.0);
INSERT INTO obce VALUES (4846, 'CZ0643', 'Troskotovice', 326, 339, 37.0, 40.5);
INSERT INTO obce VALUES (4847, 'CZ0643', 'Troubsko', 1066, 1093, 37.8, 40.3);
INSERT INTO obce VALUES (4848, 'CZ0643', 'Tvarožná', 608, 624, 38.5, 41.5);
INSERT INTO obce VALUES (4849, 'CZ0643', 'Újezd u Brna', 1512, 1585, 39.2, 43.0);
INSERT INTO obce VALUES (4850, 'CZ0643', 'Újezd u Rosic', 132, 116, 40.7, 44.8);
INSERT INTO obce VALUES (4851, 'CZ0643', 'Újezd u Tišnova', 63, 61, 41.7, 44.2);
INSERT INTO obce VALUES (4852, 'CZ0643', 'Unín', 112, 108, 36.2, 40.1);
INSERT INTO obce VALUES (4853, 'CZ0643', 'Unkovice', 347, 319, 38.1, 39.7);
INSERT INTO obce VALUES (4854, 'CZ0643', 'Úsuší', 113, 92, 34.5, 41.6);
INSERT INTO obce VALUES (4855, 'CZ0643', 'Velatice', 282, 300, 38.6, 40.6);
INSERT INTO obce VALUES (4856, 'CZ0643', 'Veverská Bítýška', 1429, 1554, 38.4, 41.0);
INSERT INTO obce VALUES (4857, 'CZ0643', 'Veverské Knínice', 453, 441, 37.2, 40.9);
INSERT INTO obce VALUES (4858, 'CZ0643', 'Viničné Šumice', 587, 623, 39.0, 41.6);
INSERT INTO obce VALUES (4859, 'CZ0643', 'Vlasatice', 404, 399, 38.6, 41.3);
INSERT INTO obce VALUES (4860, 'CZ0643', 'Vohančice', 81, 84, 38.1, 40.7);
INSERT INTO obce VALUES (4861, 'CZ0643', 'Vojkovice', 538, 561, 38.8, 40.2);
INSERT INTO obce VALUES (4862, 'CZ0643', 'Vranov', 352, 355, 41.1, 42.1);
INSERT INTO obce VALUES (4863, 'CZ0643', 'Vranovice', 1008, 1042, 37.6, 41.0);
INSERT INTO obce VALUES (4864, 'CZ0643', 'Vratislávka', 39, 45, 42.4, 41.0);
INSERT INTO obce VALUES (4865, 'CZ0643', 'Všechovice', 109, 109, 40.4, 42.2);
INSERT INTO obce VALUES (4866, 'CZ0643', 'Vysoké Popovice', 322, 340, 40.4, 41.4);
INSERT INTO obce VALUES (4867, 'CZ0643', 'Zakřany', 355, 376, 38.6, 41.8);
INSERT INTO obce VALUES (4868, 'CZ0643', 'Zálesná Zhoř', 33, 32, 42.4, 42.7);
INSERT INTO obce VALUES (4869, 'CZ0643', 'Zastávka', 1234, 1391, 39.3, 43.0);
INSERT INTO obce VALUES (4870, 'CZ0643', 'Zbraslav', 629, 620, 38.0, 42.2);
INSERT INTO obce VALUES (4871, 'CZ0643', 'Zbýšov', 1923, 2014, 39.5, 41.6);
INSERT INTO obce VALUES (4872, 'CZ0643', 'Zhoř', 35, 24, 29.6, 40.4);
INSERT INTO obce VALUES (4873, 'CZ0643', 'Žabčice', 803, 804, 38.4, 42.5);
INSERT INTO obce VALUES (4874, 'CZ0643', 'Žatčany', 400, 397, 36.8, 41.5);
INSERT INTO obce VALUES (4875, 'CZ0643', 'Žďárec', 200, 170, 36.2, 40.8);
INSERT INTO obce VALUES (4876, 'CZ0643', 'Želešice', 760, 740, 39.2, 41.2);
INSERT INTO obce VALUES (4877, 'CZ0643', 'Železné', 202, 197, 39.0, 37.7);
INSERT INTO obce VALUES (4878, 'CZ0643', 'Židlochovice', 1725, 1748, 38.4, 43.2);
INSERT INTO obce VALUES (4879, 'CZ0644', 'Bavory', 200, 203, 37.6, 40.1);
INSERT INTO obce VALUES (4880, 'CZ0644', 'Boleradice', 425, 465, 40.0, 41.4);
INSERT INTO obce VALUES (4881, 'CZ0644', 'Borkovany', 388, 374, 39.3, 42.9);
INSERT INTO obce VALUES (4882, 'CZ0644', 'Bořetice', 651, 689, 37.6, 41.6);
INSERT INTO obce VALUES (4883, 'CZ0644', 'Brod nad Dyjí', 222, 258, 40.4, 42.6);
INSERT INTO obce VALUES (4884, 'CZ0644', 'Brumovice', 451, 501, 39.0, 42.7);
INSERT INTO obce VALUES (4885, 'CZ0644', 'Břeclav', 11638, 12526, 38.8, 42.3);
INSERT INTO obce VALUES (4886, 'CZ0644', 'Březí', 773, 771, 37.3, 40.7);
INSERT INTO obce VALUES (4887, 'CZ0644', 'Bulhary', 393, 407, 38.3, 40.9);
INSERT INTO obce VALUES (4888, 'CZ0644', 'Diváky', 259, 253, 37.8, 40.8);
INSERT INTO obce VALUES (4889, 'CZ0644', 'Dobré Pole', 193, 217, 38.0, 36.9);
INSERT INTO obce VALUES (4890, 'CZ0644', 'Dolní Dunajovice', 832, 891, 38.7, 41.8);
INSERT INTO obce VALUES (4891, 'CZ0644', 'Dolní Věstonice', 157, 141, 41.6, 46.2);
INSERT INTO obce VALUES (4892, 'CZ0644', 'Drnholec', 836, 835, 38.5, 41.0);
INSERT INTO obce VALUES (4893, 'CZ0644', 'Hlohovec', 651, 659, 36.9, 42.8);
INSERT INTO obce VALUES (4894, 'CZ0644', 'Horní Bojanovice', 303, 340, 39.5, 41.7);
INSERT INTO obce VALUES (4895, 'CZ0644', 'Horní Věstonice', 215, 217, 38.9, 43.3);
INSERT INTO obce VALUES (4896, 'CZ0644', 'Hrušky', 737, 764, 39.1, 41.1);
INSERT INTO obce VALUES (4897, 'CZ0644', 'Hustopeče', 2913, 3059, 38.2, 41.3);
INSERT INTO obce VALUES (4898, 'CZ0644', 'Jevišovka', 298, 306, 37.4, 38.1);
INSERT INTO obce VALUES (4899, 'CZ0644', 'Kašnice', 116, 109, 42.6, 45.4);
INSERT INTO obce VALUES (4900, 'CZ0644', 'Klentnice', 219, 306, 37.1, 47.7);
INSERT INTO obce VALUES (4901, 'CZ0644', 'Klobouky u Brna', 1139, 1159, 38.8, 43.2);
INSERT INTO obce VALUES (4902, 'CZ0644', 'Kobylí', 1019, 1097, 39.5, 43.9);
INSERT INTO obce VALUES (4903, 'CZ0644', 'Kostice', 893, 951, 39.8, 42.8);
INSERT INTO obce VALUES (4904, 'CZ0644', 'Krumvíř', 574, 595, 38.9, 43.8);
INSERT INTO obce VALUES (4905, 'CZ0644', 'Křepice', 649, 626, 37.3, 40.0);
INSERT INTO obce VALUES (4906, 'CZ0644', 'Kurdějov', 202, 181, 39.6, 40.7);
INSERT INTO obce VALUES (4907, 'CZ0644', 'Ladná', 612, 642, 39.7, 43.5);
INSERT INTO obce VALUES (4908, 'CZ0644', 'Lanžhot', 1802, 1944, 39.1, 42.3);
INSERT INTO obce VALUES (4909, 'CZ0644', 'Lednice', 1143, 1175, 39.7, 42.2);
INSERT INTO obce VALUES (4910, 'CZ0644', 'Mikulov', 3604, 3850, 38.8, 41.8);
INSERT INTO obce VALUES (4911, 'CZ0644', 'Milovice', 213, 228, 39.0, 41.6);
INSERT INTO obce VALUES (4912, 'CZ0644', 'Moravská Nová Ves', 1221, 1339, 39.3, 42.1);
INSERT INTO obce VALUES (4913, 'CZ0644', 'Moravský Žižkov', 714, 724, 37.5, 42.2);
INSERT INTO obce VALUES (4914, 'CZ0644', 'Morkůvky', 249, 213, 39.7, 43.4);
INSERT INTO obce VALUES (4915, 'CZ0644', 'Němčičky', 293, 308, 41.1, 44.5);
INSERT INTO obce VALUES (4916, 'CZ0644', 'Nikolčice', 406, 393, 38.9, 40.6);
INSERT INTO obce VALUES (4917, 'CZ0644', 'Novosedly', 570, 593, 37.9, 39.3);
INSERT INTO obce VALUES (4918, 'CZ0644', 'Nový Přerov', 155, 184, 34.4, 38.3);
INSERT INTO obce VALUES (4919, 'CZ0644', 'Pavlov', 267, 284, 40.7, 43.2);
INSERT INTO obce VALUES (4920, 'CZ0644', 'Perná', 377, 373, 37.7, 41.0);
INSERT INTO obce VALUES (4921, 'CZ0644', 'Podivín', 1410, 1490, 39.1, 43.4);
INSERT INTO obce VALUES (4922, 'CZ0644', 'Popice', 458, 506, 38.0, 40.2);
INSERT INTO obce VALUES (4923, 'CZ0644', 'Pouzdřany', 359, 376, 38.8, 42.9);
INSERT INTO obce VALUES (4924, 'CZ0644', 'Přítluky', 383, 367, 39.2, 44.2);
INSERT INTO obce VALUES (4925, 'CZ0644', 'Rakvice', 1109, 1089, 38.7, 42.4);
INSERT INTO obce VALUES (4926, 'CZ0644', 'Sedlec', 424, 407, 39.6, 42.7);
INSERT INTO obce VALUES (4927, 'CZ0644', 'Starovice', 396, 414, 37.6, 39.9);
INSERT INTO obce VALUES (4928, 'CZ0644', 'Starovičky', 394, 393, 38.1, 40.5);
INSERT INTO obce VALUES (4929, 'CZ0644', 'Strachotín', 374, 398, 39.7, 41.3);
INSERT INTO obce VALUES (4930, 'CZ0644', 'Šakvice', 654, 703, 39.0, 43.4);
INSERT INTO obce VALUES (4931, 'CZ0644', 'Šitbořice', 967, 965, 38.7, 41.3);
INSERT INTO obce VALUES (4932, 'CZ0644', 'Tvrdonice', 1048, 1081, 39.4, 41.6);
INSERT INTO obce VALUES (4933, 'CZ0644', 'Týnec', 522, 535, 37.6, 41.9);
INSERT INTO obce VALUES (4934, 'CZ0644', 'Uherčice', 518, 507, 38.6, 41.4);
INSERT INTO obce VALUES (4935, 'CZ0644', 'Valtice', 1744, 1842, 39.4, 42.3);
INSERT INTO obce VALUES (4936, 'CZ0644', 'Velké Bílovice', 1876, 1985, 38.8, 41.2);
INSERT INTO obce VALUES (4937, 'CZ0644', 'Velké Hostěrádky', 236, 216, 37.6, 42.0);
INSERT INTO obce VALUES (4938, 'CZ0644', 'Velké Němčice', 863, 861, 38.1, 40.4);
INSERT INTO obce VALUES (4939, 'CZ0644', 'Velké Pavlovice', 1483, 1585, 39.0, 43.2);
INSERT INTO obce VALUES (4940, 'CZ0644', 'Vrbice', 566, 567, 38.3, 42.2);
INSERT INTO obce VALUES (4941, 'CZ0644', 'Zaječí', 694, 719, 37.5, 39.6);
INSERT INTO obce VALUES (4942, 'CZ0645', 'Archlebov', 418, 451, 41.4, 44.9);
INSERT INTO obce VALUES (4943, 'CZ0645', 'Blatnice pod Svatým Antonínkem', 1032, 1090, 41.5, 43.4);
INSERT INTO obce VALUES (4944, 'CZ0645', 'Blatnička', 231, 215, 38.1, 42.3);
INSERT INTO obce VALUES (4945, 'CZ0645', 'Bukovany', 379, 387, 39.8, 43.1);
INSERT INTO obce VALUES (4946, 'CZ0645', 'Bzenec', 2085, 2237, 38.5, 41.9);
INSERT INTO obce VALUES (4947, 'CZ0645', 'Čejč', 634, 632, 37.7, 42.2);
INSERT INTO obce VALUES (4948, 'CZ0645', 'Čejkovice', 1215, 1281, 38.3, 42.5);
INSERT INTO obce VALUES (4949, 'CZ0645', 'Čeložnice', 199, 208, 40.7, 43.9);
INSERT INTO obce VALUES (4950, 'CZ0645', 'Dambořice', 652, 680, 36.4, 40.9);
INSERT INTO obce VALUES (4951, 'CZ0645', 'Dolní Bojanovice', 1477, 1448, 37.6, 40.4);
INSERT INTO obce VALUES (4952, 'CZ0645', 'Domanín', 495, 508, 37.6, 41.1);
INSERT INTO obce VALUES (4953, 'CZ0645', 'Dražůvky', 136, 155, 38.0, 39.4);
INSERT INTO obce VALUES (4954, 'CZ0645', 'Dubňany', 3260, 3249, 39.1, 42.7);
INSERT INTO obce VALUES (4955, 'CZ0645', 'Hodonín', 12386, 13140, 39.1, 42.5);
INSERT INTO obce VALUES (4956, 'CZ0645', 'Hovorany', 1034, 1162, 38.7, 43.2);
INSERT INTO obce VALUES (4957, 'CZ0645', 'Hroznová Lhota', 600, 649, 38.8, 42.3);
INSERT INTO obce VALUES (4958, 'CZ0645', 'Hrubá Vrbka', 315, 333, 41.6, 42.1);
INSERT INTO obce VALUES (4959, 'CZ0645', 'Hýsly', 185, 204, 37.5, 39.2);
INSERT INTO obce VALUES (4960, 'CZ0645', 'Javorník', 353, 368, 38.0, 41.3);
INSERT INTO obce VALUES (4961, 'CZ0645', 'Ježov', 345, 373, 38.9, 43.9);
INSERT INTO obce VALUES (4962, 'CZ0645', 'Josefov', 225, 190, 35.5, 41.4);
INSERT INTO obce VALUES (4963, 'CZ0645', 'Karlín', 93, 103, 42.4, 45.9);
INSERT INTO obce VALUES (4964, 'CZ0645', 'Kelčany', 110, 133, 39.5, 42.4);
INSERT INTO obce VALUES (4965, 'CZ0645', 'Kněždub', 548, 579, 39.2, 42.7);
INSERT INTO obce VALUES (4966, 'CZ0645', 'Kostelec', 432, 414, 37.4, 40.1);
INSERT INTO obce VALUES (4967, 'CZ0645', 'Kozojídky', 241, 259, 39.3, 39.2);
INSERT INTO obce VALUES (4968, 'CZ0645', 'Kuželov', 203, 203, 39.4, 40.3);
INSERT INTO obce VALUES (4969, 'CZ0645', 'Kyjov', 5749, 5848, 40.6, 44.9);
INSERT INTO obce VALUES (4970, 'CZ0645', 'Labuty', 103, 91, 40.5, 45.3);
INSERT INTO obce VALUES (4971, 'CZ0645', 'Lipov', 727, 822, 39.1, 41.3);
INSERT INTO obce VALUES (4972, 'CZ0645', 'Louka', 497, 490, 40.0, 44.4);
INSERT INTO obce VALUES (4973, 'CZ0645', 'Lovčice', 375, 401, 39.5, 43.3);
INSERT INTO obce VALUES (4974, 'CZ0645', 'Lužice', 1358, 1426, 40.1, 43.0);
INSERT INTO obce VALUES (4975, 'CZ0645', 'Malá Vrbka', 100, 101, 38.6, 45.1);
INSERT INTO obce VALUES (4976, 'CZ0645', 'Mikulčice', 976, 1028, 38.5, 41.1);
INSERT INTO obce VALUES (4977, 'CZ0645', 'Milotice', 968, 959, 36.7, 40.2);
INSERT INTO obce VALUES (4978, 'CZ0645', 'Moravany', 390, 372, 39.8, 44.3);
INSERT INTO obce VALUES (4979, 'CZ0645', 'Moravský Písek', 1050, 1121, 39.0, 41.6);
INSERT INTO obce VALUES (4980, 'CZ0645', 'Mouchnice', 181, 172, 39.2, 41.8);
INSERT INTO obce VALUES (4981, 'CZ0645', 'Mutěnice', 1829, 1802, 37.5, 41.2);
INSERT INTO obce VALUES (4982, 'CZ0645', 'Násedlovice', 395, 431, 39.2, 42.4);
INSERT INTO obce VALUES (4983, 'CZ0645', 'Nechvalín', 183, 177, 37.0, 40.0);
INSERT INTO obce VALUES (4984, 'CZ0645', 'Nenkovice', 206, 233, 39.8, 42.7);
INSERT INTO obce VALUES (4985, 'CZ0645', 'Nová Lhota', 360, 339, 40.8, 43.0);
INSERT INTO obce VALUES (4986, 'CZ0645', 'Nový Poddvorov', 87, 95, 39.5, 44.9);
INSERT INTO obce VALUES (4987, 'CZ0645', 'Ostrovánky', 100, 118, 39.9, 43.7);
INSERT INTO obce VALUES (4988, 'CZ0645', 'Petrov', 650, 661, 38.8, 42.6);
INSERT INTO obce VALUES (4989, 'CZ0645', 'Prušánky', 1060, 1073, 38.7, 42.5);
INSERT INTO obce VALUES (4990, 'CZ0645', 'Radějov', 402, 409, 41.5, 43.7);
INSERT INTO obce VALUES (4991, 'CZ0645', 'Ratíškovice', 1969, 2074, 38.7, 42.3);
INSERT INTO obce VALUES (4992, 'CZ0645', 'Rohatec', 1731, 1765, 40.1, 43.5);
INSERT INTO obce VALUES (4993, 'CZ0645', 'Skalka', 87, 79, 39.8, 48.1);
INSERT INTO obce VALUES (4994, 'CZ0645', 'Skoronice', 254, 275, 39.0, 40.7);
INSERT INTO obce VALUES (4995, 'CZ0645', 'Sobůlky', 418, 476, 39.7, 42.0);
INSERT INTO obce VALUES (4996, 'CZ0645', 'Starý Poddvorov', 465, 504, 37.2, 41.5);
INSERT INTO obce VALUES (4997, 'CZ0645', 'Stavěšice', 174, 190, 40.7, 44.9);
INSERT INTO obce VALUES (4998, 'CZ0645', 'Strážnice', 2812, 2943, 38.4, 42.9);
INSERT INTO obce VALUES (4999, 'CZ0645', 'Strážovice', 274, 270, 38.2, 42.8);
INSERT INTO obce VALUES (5000, 'CZ0645', 'Sudoměřice', 580, 649, 38.3, 40.8);
INSERT INTO obce VALUES (5001, 'CZ0645', 'Suchov', 263, 249, 40.1, 44.7);
INSERT INTO obce VALUES (5002, 'CZ0645', 'Svatobořice-Mistřín', 1801, 1773, 37.3, 42.0);
INSERT INTO obce VALUES (5003, 'CZ0645', 'Syrovín', 196, 180, 40.5, 43.6);
INSERT INTO obce VALUES (5004, 'CZ0645', 'Šardice', 1103, 1124, 39.1, 41.7);
INSERT INTO obce VALUES (5005, 'CZ0645', 'Tasov', 273, 273, 38.3, 41.3);
INSERT INTO obce VALUES (5006, 'CZ0645', 'Těmice', 428, 454, 37.6, 39.0);
INSERT INTO obce VALUES (5007, 'CZ0645', 'Terezín', 198, 229, 38.5, 42.3);
INSERT INTO obce VALUES (5008, 'CZ0645', 'Tvarožná Lhota', 455, 457, 38.6, 43.0);
INSERT INTO obce VALUES (5009, 'CZ0645', 'Uhřice', 352, 364, 39.1, 41.9);
INSERT INTO obce VALUES (5010, 'CZ0645', 'Vacenovice', 1112, 1095, 38.0, 40.5);
INSERT INTO obce VALUES (5011, 'CZ0645', 'Velká nad Veličkou', 1503, 1503, 39.4, 42.5);
INSERT INTO obce VALUES (5012, 'CZ0645', 'Veselí nad Moravou', 5716, 5997, 38.9, 42.5);
INSERT INTO obce VALUES (5013, 'CZ0645', 'Věteřov', 281, 254, 38.3, 44.8);
INSERT INTO obce VALUES (5014, 'CZ0645', 'Vlkoš', 544, 512, 39.4, 42.2);
INSERT INTO obce VALUES (5015, 'CZ0645', 'Vnorovy', 1471, 1543, 38.9, 41.9);
INSERT INTO obce VALUES (5016, 'CZ0645', 'Vracov', 2193, 2361, 38.3, 41.9);
INSERT INTO obce VALUES (5017, 'CZ0645', 'Vřesovice', 300, 303, 42.7, 45.5);
INSERT INTO obce VALUES (5018, 'CZ0645', 'Žádovice', 395, 365, 40.7, 44.0);
INSERT INTO obce VALUES (5019, 'CZ0645', 'Žarošice', 508, 528, 37.4, 42.2);
INSERT INTO obce VALUES (5020, 'CZ0645', 'Ždánice', 1320, 1310, 39.0, 43.0);
INSERT INTO obce VALUES (5021, 'CZ0645', 'Želetice', 258, 261, 40.1, 43.3);
INSERT INTO obce VALUES (5022, 'CZ0645', 'Žeravice', 526, 533, 38.5, 42.2);
INSERT INTO obce VALUES (5023, 'CZ0645', 'Žeraviny', 95, 97, 41.7, 44.0);
INSERT INTO obce VALUES (5024, 'CZ0646', 'Bohaté Málkovice', 125, 139, 38.2, 40.3);
INSERT INTO obce VALUES (5025, 'CZ0646', 'Bohdalice-Pavlovice', 408, 423, 36.4, 39.9);
INSERT INTO obce VALUES (5026, 'CZ0646', 'Bošovice', 562, 574, 38.8, 40.6);
INSERT INTO obce VALUES (5027, 'CZ0646', 'Brankovice', 421, 460, 38.2, 41.0);
INSERT INTO obce VALUES (5028, 'CZ0646', 'Březina', 3, 0, 60.2, 0.0);
INSERT INTO obce VALUES (5029, 'CZ0646', 'Bučovice', 3217, 3245, 38.7, 41.6);
INSERT INTO obce VALUES (5030, 'CZ0646', 'Dětkovice', 127, 135, 40.3, 42.5);
INSERT INTO obce VALUES (5031, 'CZ0646', 'Dobročkovice', 93, 105, 39.3, 45.1);
INSERT INTO obce VALUES (5032, 'CZ0646', 'Dražovice', 389, 426, 38.4, 41.3);
INSERT INTO obce VALUES (5033, 'CZ0646', 'Drnovice', 1138, 1179, 39.5, 42.2);
INSERT INTO obce VALUES (5034, 'CZ0646', 'Drysice', 284, 282, 38.0, 39.8);
INSERT INTO obce VALUES (5035, 'CZ0646', 'Habrovany', 411, 393, 40.2, 43.0);
INSERT INTO obce VALUES (5036, 'CZ0646', 'Heršpice', 344, 344, 37.8, 40.4);
INSERT INTO obce VALUES (5037, 'CZ0646', 'Hlubočany', 271, 243, 38.5, 41.5);
INSERT INTO obce VALUES (5038, 'CZ0646', 'Hodějice', 434, 469, 40.4, 42.3);
INSERT INTO obce VALUES (5039, 'CZ0646', 'Holubice', 466, 420, 37.3, 42.0);
INSERT INTO obce VALUES (5040, 'CZ0646', 'Hostěrádky-Rešov', 397, 435, 41.6, 41.6);
INSERT INTO obce VALUES (5041, 'CZ0646', 'Hoštice-Heroltice', 307, 287, 39.5, 42.1);
INSERT INTO obce VALUES (5042, 'CZ0646', 'Hrušky', 372, 397, 39.3, 40.7);
INSERT INTO obce VALUES (5043, 'CZ0646', 'Hvězdlice', 282, 317, 43.1, 51.2);
INSERT INTO obce VALUES (5044, 'CZ0646', 'Chvalkovice', 135, 128, 42.3, 46.2);
INSERT INTO obce VALUES (5045, 'CZ0646', 'Ivanovice na Hané', 1442, 1514, 38.6, 42.8);
INSERT INTO obce VALUES (5046, 'CZ0646', 'Ježkovice', 177, 189, 40.4, 41.9);
INSERT INTO obce VALUES (5047, 'CZ0646', 'Kobeřice u Brna', 310, 330, 37.9, 40.2);
INSERT INTO obce VALUES (5048, 'CZ0646', 'Kojátky', 173, 172, 35.8, 39.7);
INSERT INTO obce VALUES (5049, 'CZ0646', 'Komořany', 352, 322, 36.6, 41.5);
INSERT INTO obce VALUES (5050, 'CZ0646', 'Kozlany', 156, 161, 40.4, 46.0);
INSERT INTO obce VALUES (5051, 'CZ0646', 'Kožušice', 53, 54, 42.6, 38.9);
INSERT INTO obce VALUES (5052, 'CZ0646', 'Krásensko', 205, 203, 38.8, 41.9);
INSERT INTO obce VALUES (5053, 'CZ0646', 'Křenovice', 893, 926, 38.6, 42.1);
INSERT INTO obce VALUES (5054, 'CZ0646', 'Křižanovice', 381, 378, 38.3, 41.2);
INSERT INTO obce VALUES (5055, 'CZ0646', 'Křižanovice u Vyškova', 70, 82, 39.2, 43.4);
INSERT INTO obce VALUES (5056, 'CZ0646', 'Kučerov', 231, 241, 39.5, 41.7);
INSERT INTO obce VALUES (5057, 'CZ0646', 'Letonice', 710, 692, 39.6, 40.8);
INSERT INTO obce VALUES (5058, 'CZ0646', 'Lovčičky', 285, 291, 39.8, 43.1);
INSERT INTO obce VALUES (5059, 'CZ0646', 'Luleč', 384, 418, 38.9, 41.3);
INSERT INTO obce VALUES (5060, 'CZ0646', 'Lysovice', 142, 130, 42.6, 40.3);
INSERT INTO obce VALUES (5061, 'CZ0646', 'Malínky', 68, 64, 41.7, 43.8);
INSERT INTO obce VALUES (5062, 'CZ0646', 'Medlovice', 153, 176, 35.7, 38.7);
INSERT INTO obce VALUES (5063, 'CZ0646', 'Milešovice', 332, 334, 37.9, 39.9);
INSERT INTO obce VALUES (5064, 'CZ0646', 'Milonice', 176, 175, 41.1, 43.5);
INSERT INTO obce VALUES (5065, 'CZ0646', 'Moravské Málkovice', 309, 291, 37.7, 39.7);
INSERT INTO obce VALUES (5066, 'CZ0646', 'Mouřínov', 223, 228, 39.4, 44.1);
INSERT INTO obce VALUES (5067, 'CZ0646', 'Němčany', 345, 376, 39.3, 41.8);
INSERT INTO obce VALUES (5068, 'CZ0646', 'Nemochovice', 139, 138, 38.7, 44.4);
INSERT INTO obce VALUES (5069, 'CZ0646', 'Nemojany', 316, 318, 41.4, 42.4);
INSERT INTO obce VALUES (5070, 'CZ0646', 'Nemotice', 173, 168, 39.6, 45.9);
INSERT INTO obce VALUES (5071, 'CZ0646', 'Nesovice', 578, 570, 39.6, 43.6);
INSERT INTO obce VALUES (5072, 'CZ0646', 'Nevojice', 210, 189, 40.9, 41.5);
INSERT INTO obce VALUES (5073, 'CZ0646', 'Nížkovice', 332, 322, 40.2, 45.6);
INSERT INTO obce VALUES (5074, 'CZ0646', 'Nové Sady', 46, 42, 43.2, 53.1);
INSERT INTO obce VALUES (5075, 'CZ0646', 'Olšany', 257, 268, 38.0, 38.3);
INSERT INTO obce VALUES (5076, 'CZ0646', 'Orlovice', 160, 159, 39.4, 43.4);
INSERT INTO obce VALUES (5077, 'CZ0646', 'Otnice', 713, 718, 38.4, 39.8);
INSERT INTO obce VALUES (5078, 'CZ0646', 'Podbřežice', 114, 114, 38.4, 42.0);
INSERT INTO obce VALUES (5079, 'CZ0646', 'Podivice', 100, 97, 39.4, 40.7);
INSERT INTO obce VALUES (5080, 'CZ0646', 'Podomí', 222, 209, 39.1, 42.2);
INSERT INTO obce VALUES (5081, 'CZ0646', 'Prusy-Boškůvky', 343, 306, 37.9, 42.0);
INSERT INTO obce VALUES (5082, 'CZ0646', 'Pustiměř', 793, 849, 37.0, 40.1);
INSERT INTO obce VALUES (5083, 'CZ0646', 'Račice-Pístovice', 515, 546, 39.5, 42.1);
INSERT INTO obce VALUES (5084, 'CZ0646', 'Radslavice', 229, 208, 36.3, 42.0);
INSERT INTO obce VALUES (5085, 'CZ0646', 'Rašovice', 317, 301, 38.6, 41.6);
INSERT INTO obce VALUES (5086, 'CZ0646', 'Rostěnice-Zvonovice', 252, 250, 36.8, 37.9);
INSERT INTO obce VALUES (5087, 'CZ0646', 'Rousínov', 2627, 2679, 39.3, 41.6);
INSERT INTO obce VALUES (5088, 'CZ0646', 'Ruprechtov', 282, 296, 39.2, 43.3);
INSERT INTO obce VALUES (5089, 'CZ0646', 'Rybníček', 135, 141, 37.9, 39.5);
INSERT INTO obce VALUES (5090, 'CZ0646', 'Slavkov u Brna', 3030, 3190, 38.6, 41.8);
INSERT INTO obce VALUES (5091, 'CZ0646', 'Snovídky', 184, 182, 38.2, 40.9);
INSERT INTO obce VALUES (5092, 'CZ0646', 'Studnice', 223, 243, 43.4, 43.7);
INSERT INTO obce VALUES (5093, 'CZ0646', 'Šaratice', 506, 472, 38.5, 41.7);
INSERT INTO obce VALUES (5094, 'CZ0646', 'Švábenice', 494, 488, 36.2, 39.0);
INSERT INTO obce VALUES (5095, 'CZ0646', 'Topolany', 153, 163, 41.8, 44.6);
INSERT INTO obce VALUES (5096, 'CZ0646', 'Tučapy', 269, 242, 40.5, 43.6);
INSERT INTO obce VALUES (5097, 'CZ0646', 'Uhřice', 134, 121, 36.2, 42.1);
INSERT INTO obce VALUES (5098, 'CZ0646', 'Vážany', 224, 236, 38.2, 41.1);
INSERT INTO obce VALUES (5099, 'CZ0646', 'Vážany nad Litavou', 325, 344, 41.4, 42.3);
INSERT INTO obce VALUES (5100, 'CZ0646', 'Velešovice', 607, 591, 37.3, 39.1);
INSERT INTO obce VALUES (5101, 'CZ0646', 'Vyškov', 10594, 11253, 38.9, 42.1);
INSERT INTO obce VALUES (5102, 'CZ0646', 'Zbýšov', 268, 276, 36.3, 41.0);
INSERT INTO obce VALUES (5103, 'CZ0646', 'Zelená Hora', 109, 122, 43.2, 41.2);
INSERT INTO obce VALUES (5104, 'CZ0647', 'Bantice', 145, 139, 34.5, 37.2);
INSERT INTO obce VALUES (5105, 'CZ0647', 'Běhařovice', 212, 180, 41.7, 45.7);
INSERT INTO obce VALUES (5106, 'CZ0647', 'Bezkov', 114, 107, 38.7, 40.9);
INSERT INTO obce VALUES (5107, 'CZ0647', 'Bítov', 79, 73, 43.3, 49.8);
INSERT INTO obce VALUES (5108, 'CZ0647', 'Blanné', 44, 44, 42.3, 42.9);
INSERT INTO obce VALUES (5109, 'CZ0647', 'Blížkovice', 619, 609, 37.6, 40.0);
INSERT INTO obce VALUES (5110, 'CZ0647', 'Bohutice', 290, 311, 40.3, 42.6);
INSERT INTO obce VALUES (5111, 'CZ0647', 'Bojanovice', 100, 83, 35.9, 44.2);
INSERT INTO obce VALUES (5112, 'CZ0647', 'Borotice', 223, 195, 36.1, 35.6);
INSERT INTO obce VALUES (5113, 'CZ0647', 'Boskovštejn', 75, 76, 40.2, 42.7);
INSERT INTO obce VALUES (5114, 'CZ0647', 'Božice', 753, 786, 37.7, 39.4);
INSERT INTO obce VALUES (5115, 'CZ0647', 'Břežany', 426, 489, 37.5, 41.0);
INSERT INTO obce VALUES (5116, 'CZ0647', 'Citonice', 272, 280, 36.3, 38.5);
INSERT INTO obce VALUES (5117, 'CZ0647', 'Ctidružice', 161, 165, 42.6, 44.3);
INSERT INTO obce VALUES (5118, 'CZ0647', 'Čejkovice', 113, 104, 37.3, 41.8);
INSERT INTO obce VALUES (5119, 'CZ0647', 'Čermákovice', 43, 49, 45.1, 49.3);
INSERT INTO obce VALUES (5120, 'CZ0647', 'Černín', 68, 66, 45.9, 45.8);
INSERT INTO obce VALUES (5121, 'CZ0647', 'Damnice', 161, 164, 39.0, 41.3);
INSERT INTO obce VALUES (5122, 'CZ0647', 'Dobelice', 138, 135, 39.1, 41.3);
INSERT INTO obce VALUES (5123, 'CZ0647', 'Dobřínsko', 185, 210, 38.8, 39.6);
INSERT INTO obce VALUES (5124, 'CZ0647', 'Dobšice', 1227, 1244, 37.2, 38.5);
INSERT INTO obce VALUES (5125, 'CZ0647', 'Dolenice', 72, 72, 42.5, 43.3);
INSERT INTO obce VALUES (5126, 'CZ0647', 'Dolní Dubňany', 237, 241, 40.1, 41.8);
INSERT INTO obce VALUES (5127, 'CZ0647', 'Dyjákovice', 427, 404, 36.6, 39.5);
INSERT INTO obce VALUES (5128, 'CZ0647', 'Dyjákovičky', 238, 256, 38.6, 40.1);
INSERT INTO obce VALUES (5129, 'CZ0647', 'Dyje', 201, 213, 38.6, 40.3);
INSERT INTO obce VALUES (5130, 'CZ0647', 'Džbánice', 78, 81, 37.8, 40.7);
INSERT INTO obce VALUES (5131, 'CZ0647', 'Grešlové Mýto', 108, 94, 37.2, 43.2);
INSERT INTO obce VALUES (5132, 'CZ0647', 'Havraníky', 183, 162, 39.9, 42.1);
INSERT INTO obce VALUES (5133, 'CZ0647', 'Hevlín', 704, 676, 35.7, 39.8);
INSERT INTO obce VALUES (5134, 'CZ0647', 'Hluboké Mašůvky', 385, 383, 40.9, 40.4);
INSERT INTO obce VALUES (5135, 'CZ0647', 'Hnanice', 161, 162, 35.0, 34.5);
INSERT INTO obce VALUES (5136, 'CZ0647', 'Hodonice', 930, 934, 33.3, 36.4);
INSERT INTO obce VALUES (5137, 'CZ0647', 'Horní Břečkov', 136, 137, 43.4, 40.6);
INSERT INTO obce VALUES (5138, 'CZ0647', 'Horní Dubňany', 160, 148, 40.3, 43.1);
INSERT INTO obce VALUES (5139, 'CZ0647', 'Horní Dunajovice', 316, 334, 39.3, 41.3);
INSERT INTO obce VALUES (5140, 'CZ0647', 'Horní Kounice', 144, 143, 39.2, 39.8);
INSERT INTO obce VALUES (5141, 'CZ0647', 'Hostěradice', 733, 717, 38.3, 41.2);
INSERT INTO obce VALUES (5142, 'CZ0647', 'Hostim', 208, 203, 44.5, 50.5);
INSERT INTO obce VALUES (5143, 'CZ0647', 'Hrabětice', 451, 444, 38.4, 41.1);
INSERT INTO obce VALUES (5144, 'CZ0647', 'Hrádek', 479, 462, 37.6, 39.9);
INSERT INTO obce VALUES (5145, 'CZ0647', 'Hrušovany nad Jevišovkou', 1622, 1646, 37.6, 40.3);
INSERT INTO obce VALUES (5146, 'CZ0647', 'Chvalatice', 54, 48, 44.5, 55.4);
INSERT INTO obce VALUES (5147, 'CZ0647', 'Chvalovice', 246, 239, 34.8, 38.5);
INSERT INTO obce VALUES (5148, 'CZ0647', 'Jamolice', 228, 209, 37.9, 41.9);
INSERT INTO obce VALUES (5149, 'CZ0647', 'Jaroslavice', 671, 614, 36.9, 40.0);
INSERT INTO obce VALUES (5150, 'CZ0647', 'Jevišovice', 574, 572, 40.0, 44.4);
INSERT INTO obce VALUES (5151, 'CZ0647', 'Jezeřany-Maršovice', 384, 359, 38.1, 42.1);
INSERT INTO obce VALUES (5152, 'CZ0647', 'Jiřice u Miroslavi', 207, 219, 38.0, 42.1);
INSERT INTO obce VALUES (5153, 'CZ0647', 'Jiřice u Moravských Budějovic', 31, 37, 39.2, 44.3);
INSERT INTO obce VALUES (5154, 'CZ0647', 'Kadov', 68, 73, 47.6, 41.7);
INSERT INTO obce VALUES (5155, 'CZ0647', 'Korolupy', 98, 89, 36.5, 45.9);
INSERT INTO obce VALUES (5156, 'CZ0647', 'Kravsko', 250, 290, 38.4, 42.1);
INSERT INTO obce VALUES (5157, 'CZ0647', 'Krhovice', 251, 246, 36.3, 38.4);
INSERT INTO obce VALUES (5158, 'CZ0647', 'Křepice', 65, 63, 39.8, 43.6);
INSERT INTO obce VALUES (5159, 'CZ0647', 'Křídlůvky', 109, 121, 38.2, 45.1);
INSERT INTO obce VALUES (5160, 'CZ0647', 'Kubšice', 79, 68, 41.3, 40.9);
INSERT INTO obce VALUES (5161, 'CZ0647', 'Kuchařovice', 480, 484, 36.9, 40.1);
INSERT INTO obce VALUES (5162, 'CZ0647', 'Kyjovice', 63, 81, 42.2, 41.1);
INSERT INTO obce VALUES (5163, 'CZ0647', 'Lančov', 108, 123, 37.5, 40.6);
INSERT INTO obce VALUES (5164, 'CZ0647', 'Lechovice', 229, 223, 37.6, 37.3);
INSERT INTO obce VALUES (5165, 'CZ0647', 'Lesná', 130, 123, 41.7, 44.6);
INSERT INTO obce VALUES (5166, 'CZ0647', 'Lesonice', 90, 86, 43.4, 45.1);
INSERT INTO obce VALUES (5167, 'CZ0647', 'Litobratřice', 253, 260, 37.5, 38.4);
INSERT INTO obce VALUES (5168, 'CZ0647', 'Lubnice', 38, 33, 43.4, 47.0);
INSERT INTO obce VALUES (5169, 'CZ0647', 'Lukov', 130, 129, 38.9, 41.9);
INSERT INTO obce VALUES (5170, 'CZ0647', 'Mackovice', 189, 200, 37.0, 38.9);
INSERT INTO obce VALUES (5171, 'CZ0647', 'Mašovice', 241, 235, 35.6, 40.4);
INSERT INTO obce VALUES (5172, 'CZ0647', 'Medlice', 101, 88, 42.1, 44.4);
INSERT INTO obce VALUES (5173, 'CZ0647', 'Mikulovice', 310, 325, 39.6, 39.9);
INSERT INTO obce VALUES (5174, 'CZ0647', 'Milíčovice', 103, 101, 38.8, 42.6);
INSERT INTO obce VALUES (5175, 'CZ0647', 'Miroslav', 1479, 1502, 39.0, 42.1);
INSERT INTO obce VALUES (5176, 'CZ0647', 'Miroslavské Knínice', 171, 168, 43.6, 46.0);
INSERT INTO obce VALUES (5177, 'CZ0647', 'Morašice', 110, 118, 43.1, 48.1);
INSERT INTO obce VALUES (5178, 'CZ0647', 'Moravský Krumlov', 2851, 3143, 39.7, 41.6);
INSERT INTO obce VALUES (5179, 'CZ0647', 'Našiměřice', 111, 88, 36.4, 37.7);
INSERT INTO obce VALUES (5180, 'CZ0647', 'Němčičky', 47, 44, 40.9, 50.6);
INSERT INTO obce VALUES (5181, 'CZ0647', 'Nový Šaldorf-Sedlešovice', 606, 620, 36.2, 37.6);
INSERT INTO obce VALUES (5182, 'CZ0647', 'Olbramkostel', 280, 267, 37.3, 40.7);
INSERT INTO obce VALUES (5183, 'CZ0647', 'Olbramovice', 554, 515, 36.7, 38.6);
INSERT INTO obce VALUES (5184, 'CZ0647', 'Oleksovice', 346, 343, 37.8, 40.0);
INSERT INTO obce VALUES (5185, 'CZ0647', 'Onšov', 41, 34, 40.7, 47.9);
INSERT INTO obce VALUES (5186, 'CZ0647', 'Oslnovice', 41, 48, 40.5, 46.5);
INSERT INTO obce VALUES (5187, 'CZ0647', 'Pavlice', 240, 236, 39.3, 40.9);
INSERT INTO obce VALUES (5188, 'CZ0647', 'Petrovice', 172, 171, 40.5, 43.7);
INSERT INTO obce VALUES (5189, 'CZ0647', 'Plaveč', 208, 237, 44.7, 50.9);
INSERT INTO obce VALUES (5190, 'CZ0647', 'Plenkovice', 180, 184, 38.0, 40.1);
INSERT INTO obce VALUES (5191, 'CZ0647', 'Podhradí nad Dyjí', 22, 22, 50.6, 61.2);
INSERT INTO obce VALUES (5192, 'CZ0647', 'Podmolí', 76, 80, 40.6, 41.3);
INSERT INTO obce VALUES (5193, 'CZ0647', 'Podmyče', 58, 37, 36.4, 44.7);
INSERT INTO obce VALUES (5194, 'CZ0647', 'Práče', 394, 435, 33.8, 34.3);
INSERT INTO obce VALUES (5195, 'CZ0647', 'Pravice', 168, 160, 38.3, 40.3);
INSERT INTO obce VALUES (5196, 'CZ0647', 'Prokopov', 57, 54, 40.1, 42.4);
INSERT INTO obce VALUES (5197, 'CZ0647', 'Prosiměřice', 372, 418, 36.2, 44.5);
INSERT INTO obce VALUES (5198, 'CZ0647', 'Přeskače', 49, 50, 39.2, 45.9);
INSERT INTO obce VALUES (5199, 'CZ0647', 'Rešice', 182, 182, 40.6, 43.9);
INSERT INTO obce VALUES (5200, 'CZ0647', 'Rozkoš', 81, 96, 41.7, 44.7);
INSERT INTO obce VALUES (5201, 'CZ0647', 'Rudlice', 52, 51, 41.4, 50.7);
INSERT INTO obce VALUES (5202, 'CZ0647', 'Rybníky', 227, 200, 39.8, 42.9);
INSERT INTO obce VALUES (5203, 'CZ0647', 'Skalice', 247, 318, 39.1, 46.6);
INSERT INTO obce VALUES (5204, 'CZ0647', 'Slatina', 120, 127, 42.3, 43.3);
INSERT INTO obce VALUES (5205, 'CZ0647', 'Slup', 234, 218, 38.9, 41.1);
INSERT INTO obce VALUES (5206, 'CZ0647', 'Stálky', 70, 80, 37.3, 42.2);
INSERT INTO obce VALUES (5207, 'CZ0647', 'Starý Petřín', 115, 115, 37.8, 42.3);
INSERT INTO obce VALUES (5208, 'CZ0647', 'Stošíkovice na Louce', 103, 111, 36.2, 36.2);
INSERT INTO obce VALUES (5209, 'CZ0647', 'Strachotice', 507, 506, 35.7, 38.1);
INSERT INTO obce VALUES (5210, 'CZ0647', 'Střelice', 75, 77, 46.7, 50.3);
INSERT INTO obce VALUES (5211, 'CZ0647', 'Suchohrdly', 601, 608, 36.6, 39.6);
INSERT INTO obce VALUES (5212, 'CZ0647', 'Suchohrdly u Miroslavi', 243, 233, 37.4, 40.9);
INSERT INTO obce VALUES (5213, 'CZ0647', 'Šafov', 93, 70, 37.5, 37.9);
INSERT INTO obce VALUES (5214, 'CZ0647', 'Šanov', 740, 684, 38.0, 37.6);
INSERT INTO obce VALUES (5215, 'CZ0647', 'Šatov', 576, 591, 38.5, 41.4);
INSERT INTO obce VALUES (5216, 'CZ0647', 'Štítary', 335, 330, 39.5, 39.0);
INSERT INTO obce VALUES (5217, 'CZ0647', 'Šumná', 309, 301, 39.0, 43.6);
INSERT INTO obce VALUES (5218, 'CZ0647', 'Tasovice', 654, 633, 35.3, 40.2);
INSERT INTO obce VALUES (5219, 'CZ0647', 'Tavíkovice', 328, 275, 42.1, 41.7);
INSERT INTO obce VALUES (5220, 'CZ0647', 'Těšetice', 259, 248, 38.1, 39.8);
INSERT INTO obce VALUES (5221, 'CZ0647', 'Trnové Pole', 62, 62, 37.6, 46.1);
INSERT INTO obce VALUES (5222, 'CZ0647', 'Trstěnice', 261, 281, 39.4, 41.1);
INSERT INTO obce VALUES (5223, 'CZ0647', 'Tulešice', 98, 89, 43.7, 47.5);
INSERT INTO obce VALUES (5224, 'CZ0647', 'Tvořihráz', 186, 189, 40.3, 42.8);
INSERT INTO obce VALUES (5225, 'CZ0647', 'Uherčice', 201, 222, 38.1, 39.4);
INSERT INTO obce VALUES (5226, 'CZ0647', 'Újezd', 35, 45, 44.1, 47.4);
INSERT INTO obce VALUES (5227, 'CZ0647', 'Únanov', 583, 572, 38.5, 40.1);
INSERT INTO obce VALUES (5228, 'CZ0647', 'Valtrovice', 196, 200, 36.2, 36.8);
INSERT INTO obce VALUES (5229, 'CZ0647', 'Vedrovice', 418, 415, 39.7, 42.5);
INSERT INTO obce VALUES (5230, 'CZ0647', 'Velký Karlov', 206, 235, 39.1, 40.0);
INSERT INTO obce VALUES (5231, 'CZ0647', 'Vémyslice', 369, 327, 38.4, 43.8);
INSERT INTO obce VALUES (5232, 'CZ0647', 'Vevčice', 38, 36, 43.1, 50.8);
INSERT INTO obce VALUES (5233, 'CZ0647', 'Višňové', 561, 564, 38.7, 42.7);
INSERT INTO obce VALUES (5234, 'CZ0647', 'Vítonice', 124, 120, 33.4, 38.0);
INSERT INTO obce VALUES (5235, 'CZ0647', 'Vracovice', 85, 104, 40.1, 34.2);
INSERT INTO obce VALUES (5236, 'CZ0647', 'Vranov nad Dyjí', 444, 402, 40.0, 43.5);
INSERT INTO obce VALUES (5237, 'CZ0647', 'Vranovská Ves', 137, 132, 35.7, 38.5);
INSERT INTO obce VALUES (5238, 'CZ0647', 'Vratěnín', 148, 153, 36.2, 41.7);
INSERT INTO obce VALUES (5239, 'CZ0647', 'Vrbovec', 568, 580, 35.5, 38.1);
INSERT INTO obce VALUES (5240, 'CZ0647', 'Výrovice', 89, 83, 37.5, 40.6);
INSERT INTO obce VALUES (5241, 'CZ0647', 'Vysočany', 55, 50, 44.1, 46.5);
INSERT INTO obce VALUES (5242, 'CZ0647', 'Zálesí', 90, 83, 43.8, 46.7);
INSERT INTO obce VALUES (5243, 'CZ0647', 'Zblovice', 30, 18, 45.2, 47.0);
INSERT INTO obce VALUES (5244, 'CZ0647', 'Znojmo', 16562, 18163, 39.3, 42.9);
INSERT INTO obce VALUES (5245, 'CZ0647', 'Želetice', 144, 131, 41.0, 41.9);
INSERT INTO obce VALUES (5246, 'CZ0647', 'Žerotice', 147, 155, 38.8, 43.0);
INSERT INTO obce VALUES (5247, 'CZ0647', 'Žerůtky', 142, 111, 39.7, 42.3);
INSERT INTO obce VALUES (5248, 'CZ0711', 'Bělá pod Pradědem', 923, 890, 38.6, 41.7);
INSERT INTO obce VALUES (5249, 'CZ0711', 'Bernartice', 475, 445, 36.5, 40.6);
INSERT INTO obce VALUES (5250, 'CZ0711', 'Bílá Voda', 164, 142, 32.7, 36.1);
INSERT INTO obce VALUES (5251, 'CZ0711', 'Černá Voda', 318, 299, 38.5, 45.6);
INSERT INTO obce VALUES (5252, 'CZ0711', 'Česká Ves', 1275, 1308, 38.1, 39.2);
INSERT INTO obce VALUES (5253, 'CZ0711', 'Hradec-Nová Ves', 150, 156, 39.2, 40.7);
INSERT INTO obce VALUES (5254, 'CZ0711', 'Javorník', 1467, 1507, 38.7, 42.0);
INSERT INTO obce VALUES (5255, 'CZ0711', 'Jeseník', 5840, 6228, 39.7, 43.0);
INSERT INTO obce VALUES (5256, 'CZ0711', 'Kobylá nad Vidnavkou', 205, 240, 41.3, 43.0);
INSERT INTO obce VALUES (5257, 'CZ0711', 'Lipová-lázně', 1227, 1276, 38.7, 41.8);
INSERT INTO obce VALUES (5258, 'CZ0711', 'Mikulovice', 1315, 1375, 39.4, 41.9);
INSERT INTO obce VALUES (5259, 'CZ0711', 'Ostružná', 97, 86, 42.3, 42.4);
INSERT INTO obce VALUES (5260, 'CZ0711', 'Písečná', 533, 510, 38.6, 39.6);
INSERT INTO obce VALUES (5261, 'CZ0711', 'Skorošice', 385, 393, 40.8, 42.2);
INSERT INTO obce VALUES (5262, 'CZ0711', 'Stará Červená Voda', 328, 340, 38.4, 40.4);
INSERT INTO obce VALUES (5263, 'CZ0711', 'Supíkovice', 377, 339, 38.0, 40.6);
INSERT INTO obce VALUES (5264, 'CZ0711', 'Uhelná', 272, 260, 39.8, 43.2);
INSERT INTO obce VALUES (5265, 'CZ0711', 'Vápenná', 775, 616, 38.7, 42.1);
INSERT INTO obce VALUES (5266, 'CZ0711', 'Velká Kraš', 426, 394, 37.2, 41.3);
INSERT INTO obce VALUES (5267, 'CZ0711', 'Velké Kunětice', 292, 300, 38.3, 38.3);
INSERT INTO obce VALUES (5268, 'CZ0711', 'Vidnava', 706, 698, 37.4, 42.4);
INSERT INTO obce VALUES (5269, 'CZ0711', 'Vlčice', 220, 219, 38.0, 41.5);
INSERT INTO obce VALUES (5270, 'CZ0711', 'Zlaté Hory', 2088, 2080, 39.4, 42.7);
INSERT INTO obce VALUES (5271, 'CZ0711', 'Žulová', 640, 656, 38.2, 41.5);
INSERT INTO obce VALUES (5272, 'CZ0712', 'Babice', 222, 208, 39.1, 41.8);
INSERT INTO obce VALUES (5273, 'CZ0712', 'Bělkovice-Lašťany', 1057, 1042, 37.3, 40.8);
INSERT INTO obce VALUES (5274, 'CZ0712', 'Bílá Lhota', 558, 560, 39.7, 42.4);
INSERT INTO obce VALUES (5275, 'CZ0712', 'Bílsko', 109, 103, 39.1, 43.0);
INSERT INTO obce VALUES (5276, 'CZ0712', 'Blatec', 301, 300, 37.9, 40.5);
INSERT INTO obce VALUES (5277, 'CZ0712', 'Bohuňovice', 1240, 1290, 38.5, 40.4);
INSERT INTO obce VALUES (5278, 'CZ0712', 'Bouzov', 755, 774, 38.8, 43.2);
INSERT INTO obce VALUES (5279, 'CZ0712', 'Bukovany', 298, 283, 35.9, 39.2);
INSERT INTO obce VALUES (5280, 'CZ0712', 'Bystročice', 322, 359, 39.6, 40.2);
INSERT INTO obce VALUES (5281, 'CZ0712', 'Bystrovany', 489, 481, 35.0, 37.1);
INSERT INTO obce VALUES (5282, 'CZ0712', 'Červenka', 675, 743, 38.3, 40.8);
INSERT INTO obce VALUES (5283, 'CZ0712', 'Daskabát', 283, 313, 41.7, 44.2);
INSERT INTO obce VALUES (5284, 'CZ0712', 'Dlouhá Loučka', 941, 966, 38.5, 41.3);
INSERT INTO obce VALUES (5285, 'CZ0712', 'Dolany', 1244, 1255, 37.0, 39.6);
INSERT INTO obce VALUES (5286, 'CZ0712', 'Doloplazy', 631, 676, 37.4, 38.8);
INSERT INTO obce VALUES (5287, 'CZ0712', 'Domašov nad Bystřicí', 237, 281, 37.9, 37.9);
INSERT INTO obce VALUES (5288, 'CZ0712', 'Domašov u Šternberka', 149, 150, 38.5, 41.1);
INSERT INTO obce VALUES (5289, 'CZ0712', 'Drahanovice', 848, 832, 39.4, 42.9);
INSERT INTO obce VALUES (5290, 'CZ0712', 'Dub nad Moravou', 779, 782, 38.0, 40.3);
INSERT INTO obce VALUES (5291, 'CZ0712', 'Dubčany', 103, 110, 37.4, 40.2);
INSERT INTO obce VALUES (5292, 'CZ0712', 'Grygov', 712, 729, 37.8, 43.1);
INSERT INTO obce VALUES (5293, 'CZ0712', 'Haňovice', 236, 226, 39.3, 42.8);
INSERT INTO obce VALUES (5294, 'CZ0712', 'Hlásnice', 97, 91, 32.7, 42.1);
INSERT INTO obce VALUES (5295, 'CZ0712', 'Hlubočky', 2211, 2198, 39.7, 42.0);
INSERT INTO obce VALUES (5296, 'CZ0712', 'Hlušovice', 356, 353, 32.7, 35.2);
INSERT INTO obce VALUES (5297, 'CZ0712', 'Hněvotín', 717, 720, 37.8, 38.6);
INSERT INTO obce VALUES (5298, 'CZ0712', 'Hnojice', 296, 305, 38.8, 40.8);
INSERT INTO obce VALUES (5299, 'CZ0712', 'Horka nad Moravou', 1111, 1160, 38.4, 42.4);
INSERT INTO obce VALUES (5300, 'CZ0712', 'Horní Loděnice', 189, 173, 34.0, 33.9);
INSERT INTO obce VALUES (5301, 'CZ0712', 'Hraničné Petrovice', 77, 68, 42.0, 42.0);
INSERT INTO obce VALUES (5302, 'CZ0712', 'Huzová', 306, 314, 38.3, 38.6);
INSERT INTO obce VALUES (5303, 'CZ0712', 'Charváty', 423, 423, 37.6, 37.6);
INSERT INTO obce VALUES (5304, 'CZ0712', 'Cholina', 350, 371, 39.3, 41.3);
INSERT INTO obce VALUES (5305, 'CZ0712', 'Jívová', 287, 269, 39.5, 40.6);
INSERT INTO obce VALUES (5306, 'CZ0712', 'Komárov', 82, 76, 40.0, 42.7);
INSERT INTO obce VALUES (5307, 'CZ0712', 'Kožušany-Tážaly', 425, 415, 40.1, 41.1);
INSERT INTO obce VALUES (5308, 'CZ0712', 'Krčmaň', 222, 247, 40.8, 40.5);
INSERT INTO obce VALUES (5309, 'CZ0712', 'Křelov-Břuchotín', 733, 786, 40.0, 40.4);
INSERT INTO obce VALUES (5310, 'CZ0712', 'Libavá', 584, 546, 33.8, 36.0);
INSERT INTO obce VALUES (5311, 'CZ0712', 'Liboš', 298, 311, 38.2, 39.8);
INSERT INTO obce VALUES (5312, 'CZ0712', 'Lipina', 84, 66, 42.0, 43.4);
INSERT INTO obce VALUES (5313, 'CZ0712', 'Lipinka', 107, 101, 40.9, 42.3);
INSERT INTO obce VALUES (5314, 'CZ0712', 'Litovel', 4950, 5040, 39.6, 42.1);
INSERT INTO obce VALUES (5315, 'CZ0712', 'Loučany', 325, 303, 40.2, 44.8);
INSERT INTO obce VALUES (5316, 'CZ0712', 'Loučka', 109, 97, 40.8, 48.6);
INSERT INTO obce VALUES (5317, 'CZ0712', 'Luběnice', 221, 198, 41.9, 43.5);
INSERT INTO obce VALUES (5318, 'CZ0712', 'Luká', 385, 415, 41.4, 45.8);
INSERT INTO obce VALUES (5319, 'CZ0712', 'Lutín', 1574, 1656, 38.1, 39.8);
INSERT INTO obce VALUES (5320, 'CZ0712', 'Lužice', 164, 173, 39.0, 41.7);
INSERT INTO obce VALUES (5321, 'CZ0712', 'Majetín', 581, 532, 38.0, 41.6);
INSERT INTO obce VALUES (5322, 'CZ0712', 'Medlov', 772, 808, 37.4, 41.3);
INSERT INTO obce VALUES (5323, 'CZ0712', 'Měrotín', 134, 141, 41.6, 42.4);
INSERT INTO obce VALUES (5324, 'CZ0712', 'Mladeč', 438, 328, 40.9, 41.9);
INSERT INTO obce VALUES (5325, 'CZ0712', 'Mladějovice', 351, 321, 36.8, 40.6);
INSERT INTO obce VALUES (5326, 'CZ0712', 'Moravský Beroun', 1636, 1662, 37.2, 39.2);
INSERT INTO obce VALUES (5327, 'CZ0712', 'Mrsklesy', 288, 293, 39.6, 41.2);
INSERT INTO obce VALUES (5328, 'CZ0712', 'Mutkov', 32, 20, 44.6, 43.3);
INSERT INTO obce VALUES (5329, 'CZ0712', 'Náklo', 771, 743, 37.6, 41.0);
INSERT INTO obce VALUES (5330, 'CZ0712', 'Náměšť na Hané', 998, 1006, 39.7, 44.5);
INSERT INTO obce VALUES (5331, 'CZ0712', 'Norberčany', 193, 147, 38.8, 41.7);
INSERT INTO obce VALUES (5332, 'CZ0712', 'Nová Hradečná', 385, 396, 37.3, 40.6);
INSERT INTO obce VALUES (5333, 'CZ0712', 'Olbramice', 110, 102, 41.4, 44.4);
INSERT INTO obce VALUES (5334, 'CZ0712', 'Olomouc', 47401, 52961, 39.5, 42.8);
INSERT INTO obce VALUES (5335, 'CZ0712', 'Paseka', 625, 630, 36.6, 39.3);
INSERT INTO obce VALUES (5336, 'CZ0712', 'Pňovice', 436, 422, 37.3, 40.1);
INSERT INTO obce VALUES (5337, 'CZ0712', 'Přáslavice', 668, 681, 38.3, 41.6);
INSERT INTO obce VALUES (5338, 'CZ0712', 'Příkazy', 589, 623, 39.6, 42.7);
INSERT INTO obce VALUES (5339, 'CZ0712', 'Řídeč', 100, 94, 36.2, 38.8);
INSERT INTO obce VALUES (5340, 'CZ0712', 'Samotišky', 627, 633, 38.7, 41.0);
INSERT INTO obce VALUES (5341, 'CZ0712', 'Senice na Hané', 903, 909, 39.6, 41.8);
INSERT INTO obce VALUES (5342, 'CZ0712', 'Senička', 168, 185, 37.8, 40.7);
INSERT INTO obce VALUES (5343, 'CZ0712', 'Skrbeň', 575, 598, 36.7, 40.3);
INSERT INTO obce VALUES (5344, 'CZ0712', 'Slatinice', 776, 737, 39.9, 42.6);
INSERT INTO obce VALUES (5345, 'CZ0712', 'Slavětín', 92, 112, 39.5, 40.2);
INSERT INTO obce VALUES (5346, 'CZ0712', 'Strukov', 78, 74, 46.8, 43.0);
INSERT INTO obce VALUES (5347, 'CZ0712', 'Střeň', 297, 272, 37.9, 42.3);
INSERT INTO obce VALUES (5348, 'CZ0712', 'Suchonice', 77, 95, 40.1, 42.6);
INSERT INTO obce VALUES (5349, 'CZ0712', 'Svésedlice', 94, 84, 39.1, 42.8);
INSERT INTO obce VALUES (5350, 'CZ0712', 'Štarnov', 315, 317, 39.2, 40.2);
INSERT INTO obce VALUES (5351, 'CZ0712', 'Štěpánov', 1635, 1740, 39.4, 41.0);
INSERT INTO obce VALUES (5352, 'CZ0712', 'Šternberk', 6652, 7093, 39.5, 42.8);
INSERT INTO obce VALUES (5353, 'CZ0712', 'Šumvald', 864, 868, 38.6, 40.9);
INSERT INTO obce VALUES (5354, 'CZ0712', 'Těšetice', 630, 650, 39.4, 41.0);
INSERT INTO obce VALUES (5355, 'CZ0712', 'Tovéř', 272, 299, 39.1, 39.0);
INSERT INTO obce VALUES (5356, 'CZ0712', 'Troubelice', 938, 974, 37.6, 40.1);
INSERT INTO obce VALUES (5357, 'CZ0712', 'Tršice', 817, 815, 37.9, 42.4);
INSERT INTO obce VALUES (5358, 'CZ0712', 'Újezd', 694, 689, 39.3, 42.0);
INSERT INTO obce VALUES (5359, 'CZ0712', 'Uničov', 5875, 6126, 39.6, 42.7);
INSERT INTO obce VALUES (5360, 'CZ0712', 'Ústín', 191, 189, 40.4, 41.6);
INSERT INTO obce VALUES (5361, 'CZ0712', 'Velká Bystřice', 1471, 1543, 38.1, 41.1);
INSERT INTO obce VALUES (5362, 'CZ0712', 'Velký Týnec', 1205, 1227, 37.9, 40.5);
INSERT INTO obce VALUES (5363, 'CZ0712', 'Velký Újezd', 617, 628, 37.6, 41.1);
INSERT INTO obce VALUES (5364, 'CZ0712', 'Věrovany', 662, 692, 39.3, 41.9);
INSERT INTO obce VALUES (5365, 'CZ0712', 'Vilémov', 232, 233, 39.7, 42.8);
INSERT INTO obce VALUES (5366, 'CZ0712', 'Želechovice', 118, 118, 40.7, 40.2);
INSERT INTO obce VALUES (5367, 'CZ0712', 'Žerotín', 224, 216, 38.5, 42.4);
INSERT INTO obce VALUES (5368, 'CZ0713', 'Alojzov', 113, 129, 42.9, 45.8);
INSERT INTO obce VALUES (5369, 'CZ0713', 'Bedihošť', 532, 502, 37.6, 41.1);
INSERT INTO obce VALUES (5370, 'CZ0713', 'Bílovice-Lutotín', 264, 255, 38.6, 40.1);
INSERT INTO obce VALUES (5371, 'CZ0713', 'Biskupice', 134, 144, 36.8, 38.2);
INSERT INTO obce VALUES (5372, 'CZ0713', 'Bohuslavice', 226, 240, 35.6, 39.7);
INSERT INTO obce VALUES (5373, 'CZ0713', 'Bousín', 55, 73, 43.6, 44.7);
INSERT INTO obce VALUES (5374, 'CZ0713', 'Brodek u Konice', 429, 481, 40.7, 43.8);
INSERT INTO obce VALUES (5375, 'CZ0713', 'Brodek u Prostějova', 766, 767, 36.6, 40.3);
INSERT INTO obce VALUES (5376, 'CZ0713', 'Březsko', 116, 95, 41.7, 45.9);
INSERT INTO obce VALUES (5377, 'CZ0713', 'Budětsko', 208, 194, 39.8, 44.1);
INSERT INTO obce VALUES (5378, 'CZ0713', 'Buková', 162, 166, 38.2, 46.1);
INSERT INTO obce VALUES (5379, 'CZ0713', 'Čehovice', 263, 267, 38.7, 43.1);
INSERT INTO obce VALUES (5380, 'CZ0713', 'Čechy pod Kosířem', 521, 518, 38.0, 43.2);
INSERT INTO obce VALUES (5381, 'CZ0713', 'Čelčice', 271, 280, 37.8, 42.1);
INSERT INTO obce VALUES (5382, 'CZ0713', 'Čelechovice na Hané', 635, 640, 40.8, 42.7);
INSERT INTO obce VALUES (5383, 'CZ0713', 'Dětkovice', 255, 268, 42.5, 41.6);
INSERT INTO obce VALUES (5384, 'CZ0713', 'Dobrochov', 149, 155, 35.7, 40.2);
INSERT INTO obce VALUES (5385, 'CZ0713', 'Dobromilice', 437, 441, 35.0, 38.8);
INSERT INTO obce VALUES (5386, 'CZ0713', 'Doloplazy', 264, 279, 38.1, 41.4);
INSERT INTO obce VALUES (5387, 'CZ0713', 'Drahany', 276, 251, 39.7, 42.5);
INSERT INTO obce VALUES (5388, 'CZ0713', 'Držovice', 681, 653, 40.3, 42.7);
INSERT INTO obce VALUES (5389, 'CZ0713', 'Dřevnovice', 244, 238, 36.0, 38.0);
INSERT INTO obce VALUES (5390, 'CZ0713', 'Dzbel', 128, 130, 42.8, 40.9);
INSERT INTO obce VALUES (5391, 'CZ0713', 'Hačky', 54, 51, 44.7, 50.5);
INSERT INTO obce VALUES (5392, 'CZ0713', 'Hluchov', 164, 186, 40.3, 43.0);
INSERT INTO obce VALUES (5393, 'CZ0713', 'Horní Štěpánov', 471, 522, 38.5, 41.5);
INSERT INTO obce VALUES (5394, 'CZ0713', 'Hradčany-Kobeřice', 207, 253, 36.2, 36.9);
INSERT INTO obce VALUES (5395, 'CZ0713', 'Hrdibořice', 112, 109, 38.8, 44.3);
INSERT INTO obce VALUES (5396, 'CZ0713', 'Hrubčice', 385, 407, 39.3, 41.0);
INSERT INTO obce VALUES (5397, 'CZ0713', 'Hruška', 138, 118, 38.9, 44.8);
INSERT INTO obce VALUES (5398, 'CZ0713', 'Hvozd', 319, 306, 38.8, 43.7);
INSERT INTO obce VALUES (5399, 'CZ0713', 'Ivaň', 263, 247, 40.0, 41.2);
INSERT INTO obce VALUES (5400, 'CZ0713', 'Jesenec', 161, 139, 46.2, 51.3);
INSERT INTO obce VALUES (5401, 'CZ0713', 'Kladky', 176, 195, 40.6, 44.3);
INSERT INTO obce VALUES (5402, 'CZ0713', 'Klenovice na Hané', 418, 430, 37.7, 39.7);
INSERT INTO obce VALUES (5403, 'CZ0713', 'Klopotovice', 142, 124, 40.2, 42.3);
INSERT INTO obce VALUES (5404, 'CZ0713', 'Konice', 1412, 1472, 39.0, 41.8);
INSERT INTO obce VALUES (5405, 'CZ0713', 'Kostelec na Hané', 1412, 1514, 38.9, 41.7);
INSERT INTO obce VALUES (5406, 'CZ0713', 'Koválovice-Osíčany', 156, 146, 39.3, 44.9);
INSERT INTO obce VALUES (5407, 'CZ0713', 'Kralice na Hané', 724, 739, 38.7, 39.0);
INSERT INTO obce VALUES (5408, 'CZ0713', 'Krumsín', 305, 316, 38.9, 40.8);
INSERT INTO obce VALUES (5409, 'CZ0713', 'Laškov', 301, 279, 42.2, 45.6);
INSERT INTO obce VALUES (5410, 'CZ0713', 'Lešany', 187, 203, 41.7, 42.7);
INSERT INTO obce VALUES (5411, 'CZ0713', 'Lipová', 386, 377, 41.8, 43.7);
INSERT INTO obce VALUES (5412, 'CZ0713', 'Ludmírov', 277, 293, 39.4, 44.9);
INSERT INTO obce VALUES (5413, 'CZ0713', 'Malé Hradisko', 179, 201, 42.1, 47.1);
INSERT INTO obce VALUES (5414, 'CZ0713', 'Mořice', 235, 250, 37.2, 42.9);
INSERT INTO obce VALUES (5415, 'CZ0713', 'Mostkovice', 740, 776, 39.9, 43.9);
INSERT INTO obce VALUES (5416, 'CZ0713', 'Myslejovice', 324, 321, 40.4, 45.5);
INSERT INTO obce VALUES (5417, 'CZ0713', 'Němčice nad Hanou', 1092, 1044, 38.2, 42.3);
INSERT INTO obce VALUES (5418, 'CZ0713', 'Nezamyslice', 731, 696, 37.2, 40.3);
INSERT INTO obce VALUES (5419, 'CZ0713', 'Niva', 160, 187, 40.2, 41.5);
INSERT INTO obce VALUES (5420, 'CZ0713', 'Obědkovice', 136, 136, 38.6, 39.8);
INSERT INTO obce VALUES (5421, 'CZ0713', 'Ohrozim', 237, 235, 39.0, 39.6);
INSERT INTO obce VALUES (5422, 'CZ0713', 'Ochoz', 94, 94, 38.4, 40.4);
INSERT INTO obce VALUES (5423, 'CZ0713', 'Olšany u Prostějova', 744, 822, 38.6, 39.6);
INSERT INTO obce VALUES (5424, 'CZ0713', 'Ondratice', 199, 154, 38.3, 46.7);
INSERT INTO obce VALUES (5425, 'CZ0713', 'Otaslavice', 643, 671, 40.4, 42.6);
INSERT INTO obce VALUES (5426, 'CZ0713', 'Otinoves', 151, 143, 40.0, 47.8);
INSERT INTO obce VALUES (5427, 'CZ0713', 'Pavlovice u Kojetína', 125, 127, 38.6, 43.9);
INSERT INTO obce VALUES (5428, 'CZ0713', 'Pěnčín', 376, 392, 37.7, 39.9);
INSERT INTO obce VALUES (5429, 'CZ0713', 'Pivín', 363, 368, 35.8, 40.0);
INSERT INTO obce VALUES (5430, 'CZ0713', 'Plumlov', 1230, 1241, 39.6, 43.6);
INSERT INTO obce VALUES (5431, 'CZ0713', 'Polomí', 74, 69, 37.7, 49.3);
INSERT INTO obce VALUES (5432, 'CZ0713', 'Prostějov', 21403, 23921, 39.9, 43.1);
INSERT INTO obce VALUES (5433, 'CZ0713', 'Prostějovičky', 135, 135, 37.9, 40.6);
INSERT INTO obce VALUES (5434, 'CZ0713', 'Protivanov', 501, 523, 37.9, 41.8);
INSERT INTO obce VALUES (5435, 'CZ0713', 'Přemyslovice', 644, 645, 39.9, 43.2);
INSERT INTO obce VALUES (5436, 'CZ0713', 'Ptení', 567, 555, 39.0, 42.9);
INSERT INTO obce VALUES (5437, 'CZ0713', 'Raková u Konice', 94, 112, 41.7, 38.5);
INSERT INTO obce VALUES (5438, 'CZ0713', 'Rakůvka', 51, 56, 40.1, 41.8);
INSERT INTO obce VALUES (5439, 'CZ0713', 'Rozstání', 326, 312, 41.7, 46.7);
INSERT INTO obce VALUES (5440, 'CZ0713', 'Seloutky', 236, 247, 40.3, 43.9);
INSERT INTO obce VALUES (5441, 'CZ0713', 'Skalka', 124, 115, 41.9, 44.4);
INSERT INTO obce VALUES (5442, 'CZ0713', 'Skřípov', 179, 173, 39.6, 42.9);
INSERT INTO obce VALUES (5443, 'CZ0713', 'Slatinky', 262, 281, 35.6, 39.4);
INSERT INTO obce VALUES (5444, 'CZ0713', 'Smržice', 858, 781, 38.3, 42.3);
INSERT INTO obce VALUES (5445, 'CZ0713', 'Srbce', 42, 34, 44.1, 41.5);
INSERT INTO obce VALUES (5446, 'CZ0713', 'Stařechovice', 270, 279, 39.5, 40.7);
INSERT INTO obce VALUES (5447, 'CZ0713', 'Stínava', 67, 85, 39.8, 45.1);
INSERT INTO obce VALUES (5448, 'CZ0713', 'Stražisko', 216, 226, 43.3, 42.0);
INSERT INTO obce VALUES (5449, 'CZ0713', 'Suchdol', 335, 309, 39.8, 44.0);
INSERT INTO obce VALUES (5450, 'CZ0713', 'Šubířov', 135, 120, 42.0, 45.5);
INSERT INTO obce VALUES (5451, 'CZ0713', 'Tištín', 246, 258, 38.9, 42.1);
INSERT INTO obce VALUES (5452, 'CZ0713', 'Tvorovice', 156, 157, 39.7, 43.4);
INSERT INTO obce VALUES (5453, 'CZ0713', 'Určice', 662, 686, 38.6, 40.8);
INSERT INTO obce VALUES (5454, 'CZ0713', 'Víceměřice', 376, 205, 44.8, 40.6);
INSERT INTO obce VALUES (5455, 'CZ0713', 'Vícov', 236, 250, 40.0, 40.9);
INSERT INTO obce VALUES (5456, 'CZ0713', 'Vincencov', 48, 63, 46.1, 45.9);
INSERT INTO obce VALUES (5457, 'CZ0713', 'Vitčice', 81, 85, 39.2, 47.1);
INSERT INTO obce VALUES (5458, 'CZ0713', 'Vranovice-Kelčice', 308, 313, 38.3, 41.4);
INSERT INTO obce VALUES (5459, 'CZ0713', 'Vrbátky', 810, 850, 37.8, 39.8);
INSERT INTO obce VALUES (5460, 'CZ0713', 'Vrchoslavice', 287, 309, 38.0, 38.9);
INSERT INTO obce VALUES (5461, 'CZ0713', 'Vřesovice', 242, 234, 37.6, 39.3);
INSERT INTO obce VALUES (5462, 'CZ0713', 'Výšovice', 229, 262, 38.2, 38.2);
INSERT INTO obce VALUES (5463, 'CZ0713', 'Zdětín', 157, 153, 40.8, 39.6);
INSERT INTO obce VALUES (5464, 'CZ0713', 'Želeč', 267, 279, 39.8, 45.8);
INSERT INTO obce VALUES (5465, 'CZ0714', 'Bělotín', 866, 874, 37.0, 38.2);
INSERT INTO obce VALUES (5466, 'CZ0714', 'Beňov', 353, 348, 40.9, 43.1);
INSERT INTO obce VALUES (5467, 'CZ0714', 'Bezuchov', 89, 99, 38.5, 43.4);
INSERT INTO obce VALUES (5468, 'CZ0714', 'Bohuslávky', 160, 173, 43.4, 41.7);
INSERT INTO obce VALUES (5469, 'CZ0714', 'Bochoř', 507, 510, 37.2, 42.7);
INSERT INTO obce VALUES (5470, 'CZ0714', 'Brodek u Přerova', 1011, 1057, 38.6, 42.7);
INSERT INTO obce VALUES (5471, 'CZ0714', 'Buk', 190, 168, 40.3, 44.0);
INSERT INTO obce VALUES (5472, 'CZ0714', 'Býškovice', 190, 199, 36.7, 38.5);
INSERT INTO obce VALUES (5473, 'CZ0714', 'Císařov', 159, 142, 37.7, 39.0);
INSERT INTO obce VALUES (5474, 'CZ0714', 'Citov', 265, 263, 37.7, 40.5);
INSERT INTO obce VALUES (5475, 'CZ0714', 'Čechy', 168, 175, 40.3, 43.5);
INSERT INTO obce VALUES (5476, 'CZ0714', 'Čelechovice', 59, 56, 34.2, 41.1);
INSERT INTO obce VALUES (5477, 'CZ0714', 'Černotín', 355, 386, 39.2, 40.2);
INSERT INTO obce VALUES (5478, 'CZ0714', 'Dobrčice', 98, 107, 41.5, 42.4);
INSERT INTO obce VALUES (5479, 'CZ0714', 'Dolní Nětčice', 135, 132, 41.0, 46.0);
INSERT INTO obce VALUES (5480, 'CZ0714', 'Dolní Těšice', 25, 30, 42.9, 43.8);
INSERT INTO obce VALUES (5481, 'CZ0714', 'Dolní Újezd', 601, 589, 38.5, 40.8);
INSERT INTO obce VALUES (5482, 'CZ0714', 'Domaželice', 287, 279, 37.4, 38.3);
INSERT INTO obce VALUES (5483, 'CZ0714', 'Dřevohostice', 801, 768, 40.7, 41.2);
INSERT INTO obce VALUES (5484, 'CZ0714', 'Grymov', 77, 90, 38.0, 40.3);
INSERT INTO obce VALUES (5485, 'CZ0714', 'Hlinsko', 91, 114, 41.4, 43.9);
INSERT INTO obce VALUES (5486, 'CZ0714', 'Horní Moštěnice', 805, 808, 37.6, 41.6);
INSERT INTO obce VALUES (5487, 'CZ0714', 'Horní Nětčice', 108, 117, 41.6, 42.2);
INSERT INTO obce VALUES (5488, 'CZ0714', 'Horní Těšice', 74, 74, 41.5, 43.1);
INSERT INTO obce VALUES (5489, 'CZ0714', 'Horní Újezd', 224, 207, 40.6, 45.8);
INSERT INTO obce VALUES (5490, 'CZ0714', 'Hrabůvka', 149, 157, 43.1, 42.0);
INSERT INTO obce VALUES (5491, 'CZ0714', 'Hradčany', 133, 140, 38.8, 40.4);
INSERT INTO obce VALUES (5492, 'CZ0714', 'Hranice', 9269, 9889, 38.3, 41.7);
INSERT INTO obce VALUES (5493, 'CZ0714', 'Hustopeče nad Bečvou', 839, 957, 37.8, 39.4);
INSERT INTO obce VALUES (5494, 'CZ0714', 'Jezernice', 323, 311, 38.8, 44.3);
INSERT INTO obce VALUES (5495, 'CZ0714', 'Jindřichov', 231, 238, 40.1, 43.8);
INSERT INTO obce VALUES (5496, 'CZ0714', 'Kladníky', 61, 85, 38.6, 39.1);
INSERT INTO obce VALUES (5497, 'CZ0714', 'Klokočí', 124, 112, 39.2, 42.6);
INSERT INTO obce VALUES (5498, 'CZ0714', 'Kojetín', 3214, 3253, 38.2, 41.6);
INSERT INTO obce VALUES (5499, 'CZ0714', 'Kokory', 557, 618, 39.0, 42.4);
INSERT INTO obce VALUES (5500, 'CZ0714', 'Křenovice', 206, 219, 41.5, 41.0);
INSERT INTO obce VALUES (5501, 'CZ0714', 'Křtomil', 208, 219, 38.9, 41.7);
INSERT INTO obce VALUES (5502, 'CZ0714', 'Lazníčky', 87, 109, 40.7, 41.9);
INSERT INTO obce VALUES (5503, 'CZ0714', 'Lazníky', 266, 263, 39.5, 42.2);
INSERT INTO obce VALUES (5504, 'CZ0714', 'Lhota', 163, 163, 39.1, 43.2);
INSERT INTO obce VALUES (5505, 'CZ0714', 'Lhotka', 27, 22, 44.3, 43.4);
INSERT INTO obce VALUES (5506, 'CZ0714', 'Lipník nad Bečvou', 4083, 4273, 38.1, 41.8);
INSERT INTO obce VALUES (5507, 'CZ0714', 'Lipová', 134, 141, 40.0, 42.5);
INSERT INTO obce VALUES (5508, 'CZ0714', 'Líšná', 125, 116, 42.1, 44.3);
INSERT INTO obce VALUES (5509, 'CZ0714', 'Lobodice', 354, 329, 39.1, 44.0);
INSERT INTO obce VALUES (5510, 'CZ0714', 'Malhotice', 170, 174, 37.6, 39.2);
INSERT INTO obce VALUES (5511, 'CZ0714', 'Měrovice nad Hanou', 329, 349, 38.4, 39.5);
INSERT INTO obce VALUES (5512, 'CZ0714', 'Milenov', 206, 199, 38.1, 41.7);
INSERT INTO obce VALUES (5513, 'CZ0714', 'Milotice nad Bečvou', 136, 140, 39.3, 41.1);
INSERT INTO obce VALUES (5514, 'CZ0714', 'Nahošovice', 80, 96, 36.7, 43.0);
INSERT INTO obce VALUES (5515, 'CZ0714', 'Nelešovice', 100, 100, 37.2, 41.1);
INSERT INTO obce VALUES (5516, 'CZ0714', 'Oldřichov', 66, 65, 34.9, 41.2);
INSERT INTO obce VALUES (5517, 'CZ0714', 'Olšovec', 239, 240, 38.3, 40.3);
INSERT INTO obce VALUES (5518, 'CZ0714', 'Opatovice', 400, 384, 37.9, 41.0);
INSERT INTO obce VALUES (5519, 'CZ0714', 'Oplocany', 158, 146, 41.0, 47.7);
INSERT INTO obce VALUES (5520, 'CZ0714', 'Oprostovice', 49, 51, 43.9, 45.8);
INSERT INTO obce VALUES (5521, 'CZ0714', 'Osek nad Bečvou', 685, 593, 37.9, 39.3);
INSERT INTO obce VALUES (5522, 'CZ0714', 'Paršovice', 198, 200, 37.3, 39.2);
INSERT INTO obce VALUES (5523, 'CZ0714', 'Partutovice', 261, 248, 38.3, 38.5);
INSERT INTO obce VALUES (5524, 'CZ0714', 'Pavlovice u Přerova', 363, 392, 40.5, 51.8);
INSERT INTO obce VALUES (5525, 'CZ0714', 'Podolí', 109, 105, 38.8, 42.0);
INSERT INTO obce VALUES (5526, 'CZ0714', 'Polkovice', 252, 260, 39.4, 40.7);
INSERT INTO obce VALUES (5527, 'CZ0714', 'Polom', 146, 145, 34.1, 37.8);
INSERT INTO obce VALUES (5528, 'CZ0714', 'Potštát', 600, 580, 39.4, 42.7);
INSERT INTO obce VALUES (5529, 'CZ0714', 'Prosenice', 450, 448, 40.0, 42.0);
INSERT INTO obce VALUES (5530, 'CZ0714', 'Provodovice', 70, 80, 42.2, 42.2);
INSERT INTO obce VALUES (5531, 'CZ0714', 'Přerov', 22478, 23776, 40.1, 43.5);
INSERT INTO obce VALUES (5532, 'CZ0714', 'Přestavlky', 133, 120, 40.8, 45.4);
INSERT INTO obce VALUES (5533, 'CZ0714', 'Radíkov', 75, 71, 40.8, 39.0);
INSERT INTO obce VALUES (5534, 'CZ0714', 'Radkova Lhota', 83, 106, 53.1, 57.2);
INSERT INTO obce VALUES (5535, 'CZ0714', 'Radkovy', 82, 76, 40.7, 40.5);
INSERT INTO obce VALUES (5536, 'CZ0714', 'Radotín', 87, 89, 37.2, 40.6);
INSERT INTO obce VALUES (5537, 'CZ0714', 'Radslavice', 541, 567, 38.5, 40.0);
INSERT INTO obce VALUES (5538, 'CZ0714', 'Radvanice', 136, 157, 39.0, 38.0);
INSERT INTO obce VALUES (5539, 'CZ0714', 'Rakov', 201, 199, 37.0, 39.4);
INSERT INTO obce VALUES (5540, 'CZ0714', 'Rokytnice', 653, 816, 38.8, 42.9);
INSERT INTO obce VALUES (5541, 'CZ0714', 'Rouské', 116, 120, 39.1, 41.4);
INSERT INTO obce VALUES (5542, 'CZ0714', 'Říkovice', 246, 236, 37.8, 40.8);
INSERT INTO obce VALUES (5543, 'CZ0714', 'Skalička', 235, 313, 38.3, 38.7);
INSERT INTO obce VALUES (5544, 'CZ0714', 'Soběchleby', 302, 307, 38.4, 38.9);
INSERT INTO obce VALUES (5545, 'CZ0714', 'Sobíšky', 80, 72, 40.3, 44.5);
INSERT INTO obce VALUES (5546, 'CZ0714', 'Stará Ves', 298, 332, 37.2, 40.2);
INSERT INTO obce VALUES (5547, 'CZ0714', 'Stříbrnice', 118, 126, 42.2, 42.7);
INSERT INTO obce VALUES (5548, 'CZ0714', 'Střítež nad Ludinou', 415, 413, 39.9, 42.0);
INSERT INTO obce VALUES (5549, 'CZ0714', 'Sušice', 158, 167, 43.5, 43.9);
INSERT INTO obce VALUES (5550, 'CZ0714', 'Šišma', 93, 83, 44.4, 45.7);
INSERT INTO obce VALUES (5551, 'CZ0714', 'Špičky', 139, 145, 37.5, 42.2);
INSERT INTO obce VALUES (5552, 'CZ0714', 'Teplice nad Bečvou', 181, 166, 39.6, 43.0);
INSERT INTO obce VALUES (5553, 'CZ0714', 'Tovačov', 1216, 1338, 40.1, 44.2);
INSERT INTO obce VALUES (5554, 'CZ0714', 'Troubky', 1020, 1029, 40.2, 44.2);
INSERT INTO obce VALUES (5555, 'CZ0714', 'Tučín', 206, 224, 41.8, 43.9);
INSERT INTO obce VALUES (5556, 'CZ0714', 'Turovice', 111, 102, 37.5, 43.7);
INSERT INTO obce VALUES (5557, 'CZ0714', 'Týn nad Bečvou', 432, 424, 40.5, 42.4);
INSERT INTO obce VALUES (5558, 'CZ0714', 'Uhřičice', 317, 305, 40.8, 41.9);
INSERT INTO obce VALUES (5559, 'CZ0714', 'Ústí', 286, 249, 39.5, 41.2);
INSERT INTO obce VALUES (5560, 'CZ0714', 'Veselíčko', 404, 430, 38.4, 41.8);
INSERT INTO obce VALUES (5561, 'CZ0714', 'Věžky', 104, 105, 41.1, 43.5);
INSERT INTO obce VALUES (5562, 'CZ0714', 'Vlkoš', 356, 374, 39.3, 43.6);
INSERT INTO obce VALUES (5563, 'CZ0714', 'Všechovice', 435, 436, 37.2, 41.2);
INSERT INTO obce VALUES (5564, 'CZ0714', 'Výkleky', 135, 139, 40.0, 38.8);
INSERT INTO obce VALUES (5565, 'CZ0714', 'Zábeštní Lhota', 71, 86, 39.0, 40.2);
INSERT INTO obce VALUES (5566, 'CZ0714', 'Zámrsky', 114, 109, 41.3, 40.0);
INSERT INTO obce VALUES (5567, 'CZ0714', 'Žákovice', 100, 114, 39.7, 39.0);
INSERT INTO obce VALUES (5568, 'CZ0714', 'Želatovice', 290, 264, 37.8, 43.7);
INSERT INTO obce VALUES (5569, 'CZ0715', 'Bludov', 1591, 1590, 39.9, 42.0);
INSERT INTO obce VALUES (5570, 'CZ0715', 'Bohdíkov', 700, 715, 38.5, 40.9);
INSERT INTO obce VALUES (5571, 'CZ0715', 'Bohuslavice', 251, 258, 38.2, 39.4);
INSERT INTO obce VALUES (5572, 'CZ0715', 'Bohutín', 402, 407, 39.2, 41.6);
INSERT INTO obce VALUES (5573, 'CZ0715', 'Branná', 156, 134, 38.5, 41.4);
INSERT INTO obce VALUES (5574, 'CZ0715', 'Bratrušov', 292, 281, 39.1, 41.2);
INSERT INTO obce VALUES (5575, 'CZ0715', 'Brníčko', 325, 302, 38.5, 42.2);
INSERT INTO obce VALUES (5576, 'CZ0715', 'Bušín', 220, 211, 40.4, 40.5);
INSERT INTO obce VALUES (5577, 'CZ0715', 'Dlouhomilov', 242, 247, 42.7, 44.9);
INSERT INTO obce VALUES (5578, 'CZ0715', 'Dolní Studénky', 661, 646, 40.7, 42.7);
INSERT INTO obce VALUES (5579, 'CZ0715', 'Drozdov', 170, 170, 39.1, 41.2);
INSERT INTO obce VALUES (5580, 'CZ0715', 'Dubicko', 524, 546, 37.8, 39.1);
INSERT INTO obce VALUES (5581, 'CZ0715', 'Hanušovice', 1707, 1741, 38.6, 40.9);
INSERT INTO obce VALUES (5582, 'CZ0715', 'Horní Studénky', 186, 175, 39.3, 42.0);
INSERT INTO obce VALUES (5583, 'CZ0715', 'Hoštejn', 212, 224, 37.9, 37.4);
INSERT INTO obce VALUES (5584, 'CZ0715', 'Hraběšice', 55, 71, 39.6, 36.0);
INSERT INTO obce VALUES (5585, 'CZ0715', 'Hrabišín', 443, 422, 39.2, 39.3);
INSERT INTO obce VALUES (5586, 'CZ0715', 'Hrabová', 277, 243, 40.1, 42.9);
INSERT INTO obce VALUES (5587, 'CZ0715', 'Hynčina', 99, 93, 42.6, 41.8);
INSERT INTO obce VALUES (5588, 'CZ0715', 'Chromeč', 285, 298, 40.1, 40.6);
INSERT INTO obce VALUES (5589, 'CZ0715', 'Jakubovice', 107, 88, 36.5, 41.9);
INSERT INTO obce VALUES (5590, 'CZ0715', 'Janoušov', 22, 29, 42.6, 42.8);
INSERT INTO obce VALUES (5591, 'CZ0715', 'Jedlí', 337, 357, 41.4, 44.5);
INSERT INTO obce VALUES (5592, 'CZ0715', 'Jestřebí', 285, 301, 38.4, 43.6);
INSERT INTO obce VALUES (5593, 'CZ0715', 'Jindřichov', 719, 653, 38.1, 41.2);
INSERT INTO obce VALUES (5594, 'CZ0715', 'Kamenná', 277, 270, 40.9, 42.8);
INSERT INTO obce VALUES (5595, 'CZ0715', 'Klopina', 303, 330, 39.0, 39.8);
INSERT INTO obce VALUES (5596, 'CZ0715', 'Kolšov', 366, 397, 39.8, 41.8);
INSERT INTO obce VALUES (5597, 'CZ0715', 'Kopřivná', 160, 130, 37.2, 38.7);
INSERT INTO obce VALUES (5598, 'CZ0715', 'Kosov', 148, 157, 33.9, 37.6);
INSERT INTO obce VALUES (5599, 'CZ0715', 'Krchleby', 100, 95, 38.0, 42.5);
INSERT INTO obce VALUES (5600, 'CZ0715', 'Lesnice', 302, 334, 39.2, 40.1);
INSERT INTO obce VALUES (5601, 'CZ0715', 'Leština', 638, 636, 39.0, 41.3);
INSERT INTO obce VALUES (5602, 'CZ0715', 'Libina', 1728, 1778, 39.1, 42.2);
INSERT INTO obce VALUES (5603, 'CZ0715', 'Líšnice', 153, 150, 42.2, 42.3);
INSERT INTO obce VALUES (5604, 'CZ0715', 'Loštice', 1469, 1591, 39.8, 43.8);
INSERT INTO obce VALUES (5605, 'CZ0715', 'Loučná nad Desnou', 918, 891, 39.9, 43.4);
INSERT INTO obce VALUES (5606, 'CZ0715', 'Lukavice', 460, 474, 37.9, 39.3);
INSERT INTO obce VALUES (5607, 'CZ0715', 'Malá Morava', 297, 283, 38.2, 40.2);
INSERT INTO obce VALUES (5608, 'CZ0715', 'Maletín', 196, 173, 35.2, 38.7);
INSERT INTO obce VALUES (5609, 'CZ0715', 'Mírov', 205, 215, 37.1, 37.4);
INSERT INTO obce VALUES (5610, 'CZ0715', 'Mohelnice', 4736, 4879, 38.7, 42.1);
INSERT INTO obce VALUES (5611, 'CZ0715', 'Moravičany', 595, 649, 40.8, 42.3);
INSERT INTO obce VALUES (5612, 'CZ0715', 'Nemile', 304, 310, 38.8, 41.0);
INSERT INTO obce VALUES (5613, 'CZ0715', 'Nový Malín', 1616, 1556, 34.5, 37.8);
INSERT INTO obce VALUES (5614, 'CZ0715', 'Olšany', 564, 547, 37.9, 41.0);
INSERT INTO obce VALUES (5615, 'CZ0715', 'Oskava', 715, 695, 39.4, 42.8);
INSERT INTO obce VALUES (5616, 'CZ0715', 'Palonín', 173, 162, 38.5, 44.8);
INSERT INTO obce VALUES (5617, 'CZ0715', 'Pavlov', 310, 308, 38.3, 40.3);
INSERT INTO obce VALUES (5618, 'CZ0715', 'Petrov nad Desnou', 575, 598, 39.8, 42.3);
INSERT INTO obce VALUES (5619, 'CZ0715', 'Písařov', 351, 360, 39.0, 42.4);
INSERT INTO obce VALUES (5620, 'CZ0715', 'Police', 111, 112, 40.1, 44.5);
INSERT INTO obce VALUES (5621, 'CZ0715', 'Postřelmov', 1539, 1688, 39.7, 41.5);
INSERT INTO obce VALUES (5622, 'CZ0715', 'Postřelmůvek', 168, 174, 38.1, 43.2);
INSERT INTO obce VALUES (5623, 'CZ0715', 'Rájec', 238, 232, 40.7, 40.6);
INSERT INTO obce VALUES (5624, 'CZ0715', 'Rapotín', 1599, 1653, 38.1, 39.7);
INSERT INTO obce VALUES (5625, 'CZ0715', 'Rejchartice', 103, 89, 34.6, 35.2);
INSERT INTO obce VALUES (5626, 'CZ0715', 'Rohle', 338, 339, 40.6, 41.7);
INSERT INTO obce VALUES (5627, 'CZ0715', 'Rovensko', 383, 373, 37.6, 39.1);
INSERT INTO obce VALUES (5628, 'CZ0715', 'Ruda nad Moravou', 1344, 1307, 38.3, 41.3);
INSERT INTO obce VALUES (5629, 'CZ0715', 'Sobotín', 624, 619, 39.5, 42.9);
INSERT INTO obce VALUES (5630, 'CZ0715', 'Staré Město', 947, 932, 38.4, 41.3);
INSERT INTO obce VALUES (5631, 'CZ0715', 'Stavenice', 76, 73, 41.6, 45.7);
INSERT INTO obce VALUES (5632, 'CZ0715', 'Sudkov', 591, 565, 37.9, 42.0);
INSERT INTO obce VALUES (5633, 'CZ0715', 'Svébohov', 203, 237, 41.4, 40.8);
INSERT INTO obce VALUES (5634, 'CZ0715', 'Šléglov', 15, 17, 43.5, 45.3);
INSERT INTO obce VALUES (5635, 'CZ0715', 'Štíty', 1026, 1005, 37.9, 41.1);
INSERT INTO obce VALUES (5636, 'CZ0715', 'Šumperk', 13183, 14309, 40.3, 44.0);
INSERT INTO obce VALUES (5637, 'CZ0715', 'Třeština', 176, 178, 39.9, 41.4);
INSERT INTO obce VALUES (5638, 'CZ0715', 'Úsov', 606, 612, 37.8, 41.3);
INSERT INTO obce VALUES (5639, 'CZ0715', 'Velké Losiny', 1359, 1406, 40.9, 43.7);
INSERT INTO obce VALUES (5640, 'CZ0715', 'Vernířovice', 103, 91, 42.7, 44.6);
INSERT INTO obce VALUES (5641, 'CZ0715', 'Vikantice', 45, 44, 38.9, 45.8);
INSERT INTO obce VALUES (5642, 'CZ0715', 'Vikýřovice', 1097, 1139, 38.1, 40.0);
INSERT INTO obce VALUES (5643, 'CZ0715', 'Vyšehoří', 106, 109, 38.4, 40.2);
INSERT INTO obce VALUES (5644, 'CZ0715', 'Zábřeh', 6768, 7265, 39.2, 42.2);
INSERT INTO obce VALUES (5645, 'CZ0715', 'Zborov', 113, 111, 40.6, 40.9);
INSERT INTO obce VALUES (5646, 'CZ0715', 'Zvole', 389, 379, 38.9, 42.4);
INSERT INTO obce VALUES (5647, 'CZ0721', 'Bařice-Velké Těšany', 246, 244, 39.5, 42.9);
INSERT INTO obce VALUES (5648, 'CZ0721', 'Bezměrov', 280, 290, 38.0, 39.6);
INSERT INTO obce VALUES (5649, 'CZ0721', 'Blazice', 110, 107, 40.6, 43.6);
INSERT INTO obce VALUES (5650, 'CZ0721', 'Bořenovice', 81, 91, 43.6, 42.3);
INSERT INTO obce VALUES (5651, 'CZ0721', 'Brusné', 198, 163, 39.1, 45.2);
INSERT INTO obce VALUES (5652, 'CZ0721', 'Břest', 457, 471, 40.1, 41.5);
INSERT INTO obce VALUES (5653, 'CZ0721', 'Bystřice pod Hostýnem', 4158, 4507, 39.5, 42.9);
INSERT INTO obce VALUES (5654, 'CZ0721', 'Cetechovice', 94, 109, 42.1, 50.4);
INSERT INTO obce VALUES (5655, 'CZ0721', 'Dřínov', 216, 232, 38.7, 45.2);
INSERT INTO obce VALUES (5656, 'CZ0721', 'Holešov', 5976, 6299, 39.8, 43.2);
INSERT INTO obce VALUES (5657, 'CZ0721', 'Honětice', 40, 24, 42.2, 51.2);
INSERT INTO obce VALUES (5658, 'CZ0721', 'Horní Lapač', 140, 121, 34.9, 37.6);
INSERT INTO obce VALUES (5659, 'CZ0721', 'Hoštice', 74, 62, 41.9, 47.7);
INSERT INTO obce VALUES (5660, 'CZ0721', 'Hulín', 3570, 3662, 39.0, 42.3);
INSERT INTO obce VALUES (5661, 'CZ0721', 'Chomýž', 180, 181, 36.9, 42.9);
INSERT INTO obce VALUES (5662, 'CZ0721', 'Chropyně', 2446, 2635, 38.6, 40.9);
INSERT INTO obce VALUES (5663, 'CZ0721', 'Chvalčov', 786, 854, 39.9, 43.7);
INSERT INTO obce VALUES (5664, 'CZ0721', 'Chvalnov-Lísky', 141, 124, 41.4, 44.6);
INSERT INTO obce VALUES (5665, 'CZ0721', 'Jankovice', 196, 180, 38.6, 40.2);
INSERT INTO obce VALUES (5666, 'CZ0721', 'Jarohněvice', 154, 144, 36.1, 36.7);
INSERT INTO obce VALUES (5667, 'CZ0721', 'Karolín', 115, 113, 38.4, 42.6);
INSERT INTO obce VALUES (5668, 'CZ0721', 'Komárno', 156, 165, 42.3, 43.8);
INSERT INTO obce VALUES (5669, 'CZ0721', 'Koryčany', 1389, 1523, 40.6, 44.2);
INSERT INTO obce VALUES (5670, 'CZ0721', 'Kostelany', 270, 255, 41.5, 43.4);
INSERT INTO obce VALUES (5671, 'CZ0721', 'Kostelec u Holešova', 472, 460, 39.1, 44.0);
INSERT INTO obce VALUES (5672, 'CZ0721', 'Kroměříž', 13768, 15259, 39.8, 44.0);
INSERT INTO obce VALUES (5673, 'CZ0721', 'Kunkovice', 22, 24, 56.9, 63.3);
INSERT INTO obce VALUES (5674, 'CZ0721', 'Kurovice', 124, 123, 38.7, 44.3);
INSERT INTO obce VALUES (5675, 'CZ0721', 'Kvasice', 1149, 1128, 39.7, 42.5);
INSERT INTO obce VALUES (5676, 'CZ0721', 'Kyselovice', 229, 254, 40.1, 43.7);
INSERT INTO obce VALUES (5677, 'CZ0721', 'Lechotice', 211, 208, 36.8, 38.3);
INSERT INTO obce VALUES (5678, 'CZ0721', 'Litenčice', 237, 251, 37.4, 39.4);
INSERT INTO obce VALUES (5679, 'CZ0721', 'Loukov', 500, 489, 37.3, 40.6);
INSERT INTO obce VALUES (5680, 'CZ0721', 'Lubná', 219, 219, 38.4, 40.4);
INSERT INTO obce VALUES (5681, 'CZ0721', 'Ludslavice', 223, 246, 40.2, 43.1);
INSERT INTO obce VALUES (5682, 'CZ0721', 'Lutopecny', 303, 293, 39.0, 41.2);
INSERT INTO obce VALUES (5683, 'CZ0721', 'Martinice', 360, 368, 38.2, 38.9);
INSERT INTO obce VALUES (5684, 'CZ0721', 'Míškovice', 251, 278, 37.4, 39.4);
INSERT INTO obce VALUES (5685, 'CZ0721', 'Morkovice-Slížany', 1491, 1481, 38.4, 40.5);
INSERT INTO obce VALUES (5686, 'CZ0721', 'Mrlínek', 150, 139, 38.3, 43.4);
INSERT INTO obce VALUES (5687, 'CZ0721', 'Němčice', 193, 175, 38.5, 45.2);
INSERT INTO obce VALUES (5688, 'CZ0721', 'Nítkovice', 135, 133, 38.7, 41.8);
INSERT INTO obce VALUES (5689, 'CZ0721', 'Nová Dědina', 212, 217, 38.4, 42.5);
INSERT INTO obce VALUES (5690, 'CZ0721', 'Osíčko', 245, 233, 38.0, 41.1);
INSERT INTO obce VALUES (5691, 'CZ0721', 'Pacetluky', 109, 115, 40.6, 43.2);
INSERT INTO obce VALUES (5692, 'CZ0721', 'Pačlavice', 420, 459, 41.5, 47.3);
INSERT INTO obce VALUES (5693, 'CZ0721', 'Počenice-Tetětice', 372, 395, 40.3, 40.0);
INSERT INTO obce VALUES (5694, 'CZ0721', 'Podhradní Lhota', 275, 247, 39.1, 42.8);
INSERT INTO obce VALUES (5695, 'CZ0721', 'Prasklice', 121, 126, 43.5, 47.7);
INSERT INTO obce VALUES (5696, 'CZ0721', 'Pravčice', 360, 361, 39.1, 40.2);
INSERT INTO obce VALUES (5697, 'CZ0721', 'Prusinovice', 618, 644, 37.5, 42.1);
INSERT INTO obce VALUES (5698, 'CZ0721', 'Přílepy', 469, 453, 37.4, 41.2);
INSERT INTO obce VALUES (5699, 'CZ0721', 'Rajnochovice', 272, 264, 37.8, 43.0);
INSERT INTO obce VALUES (5700, 'CZ0721', 'Rataje', 560, 554, 38.3, 39.2);
INSERT INTO obce VALUES (5701, 'CZ0721', 'Roštění', 354, 370, 39.0, 43.1);
INSERT INTO obce VALUES (5702, 'CZ0721', 'Roštín', 341, 359, 40.8, 42.7);
INSERT INTO obce VALUES (5703, 'CZ0721', 'Rusava', 306, 292, 41.1, 42.6);
INSERT INTO obce VALUES (5704, 'CZ0721', 'Rymice', 289, 306, 38.2, 41.8);
INSERT INTO obce VALUES (5705, 'CZ0721', 'Skaštice', 198, 186, 37.8, 39.5);
INSERT INTO obce VALUES (5706, 'CZ0721', 'Slavkov pod Hostýnem', 276, 294, 39.4, 42.6);
INSERT INTO obce VALUES (5707, 'CZ0721', 'Soběsuky', 183, 182, 38.1, 40.1);
INSERT INTO obce VALUES (5708, 'CZ0721', 'Střílky', 331, 321, 39.9, 44.4);
INSERT INTO obce VALUES (5709, 'CZ0721', 'Střížovice', 138, 122, 37.1, 38.2);
INSERT INTO obce VALUES (5710, 'CZ0721', 'Sulimov', 83, 81, 38.0, 41.5);
INSERT INTO obce VALUES (5711, 'CZ0721', 'Šelešovice', 158, 175, 38.9, 41.1);
INSERT INTO obce VALUES (5712, 'CZ0721', 'Troubky-Zdislavice', 258, 261, 40.8, 40.7);
INSERT INTO obce VALUES (5713, 'CZ0721', 'Třebětice', 143, 135, 39.1, 44.1);
INSERT INTO obce VALUES (5714, 'CZ0721', 'Uhřice', 100, 98, 37.6, 39.6);
INSERT INTO obce VALUES (5715, 'CZ0721', 'Věžky', 190, 202, 39.6, 41.6);
INSERT INTO obce VALUES (5716, 'CZ0721', 'Vítonice', 238, 234, 39.6, 42.1);
INSERT INTO obce VALUES (5717, 'CZ0721', 'Vrbka', 105, 111, 39.2, 42.9);
INSERT INTO obce VALUES (5718, 'CZ0721', 'Zahnašovice', 172, 153, 39.9, 44.0);
INSERT INTO obce VALUES (5719, 'CZ0721', 'Záříčí', 358, 393, 41.5, 43.2);
INSERT INTO obce VALUES (5720, 'CZ0721', 'Zástřizly', 69, 64, 41.4, 40.2);
INSERT INTO obce VALUES (5721, 'CZ0721', 'Zborovice', 801, 802, 39.8, 41.5);
INSERT INTO obce VALUES (5722, 'CZ0721', 'Zdounky', 1058, 1091, 37.9, 39.7);
INSERT INTO obce VALUES (5723, 'CZ0721', 'Zlobice', 310, 292, 37.5, 42.1);
INSERT INTO obce VALUES (5724, 'CZ0721', 'Žalkovice', 292, 292, 37.8, 41.7);
INSERT INTO obce VALUES (5725, 'CZ0721', 'Žeranovice', 385, 389, 36.1, 41.1);
INSERT INTO obce VALUES (5726, 'CZ0722', 'Babice', 878, 912, 39.5, 41.0);
INSERT INTO obce VALUES (5727, 'CZ0722', 'Bánov', 1075, 1063, 38.0, 42.4);
INSERT INTO obce VALUES (5728, 'CZ0722', 'Bílovice', 852, 900, 38.2, 40.5);
INSERT INTO obce VALUES (5729, 'CZ0722', 'Bojkovice', 2232, 2404, 38.9, 43.6);
INSERT INTO obce VALUES (5730, 'CZ0722', 'Boršice', 1100, 1151, 39.0, 42.5);
INSERT INTO obce VALUES (5731, 'CZ0722', 'Boršice u Blatnice', 448, 441, 38.0, 41.7);
INSERT INTO obce VALUES (5732, 'CZ0722', 'Břestek', 398, 408, 38.7, 42.1);
INSERT INTO obce VALUES (5733, 'CZ0722', 'Březolupy', 843, 828, 37.9, 43.0);
INSERT INTO obce VALUES (5734, 'CZ0722', 'Březová', 568, 514, 38.0, 41.7);
INSERT INTO obce VALUES (5735, 'CZ0722', 'Buchlovice', 1212, 1290, 42.5, 47.0);
INSERT INTO obce VALUES (5736, 'CZ0722', 'Bystřice pod Lopeníkem', 393, 407, 40.9, 46.5);
INSERT INTO obce VALUES (5737, 'CZ0722', 'Částkov', 194, 188, 39.2, 42.7);
INSERT INTO obce VALUES (5738, 'CZ0722', 'Dolní Němčí', 1479, 1547, 38.4, 41.3);
INSERT INTO obce VALUES (5739, 'CZ0722', 'Drslavice', 263, 257, 38.7, 42.2);
INSERT INTO obce VALUES (5740, 'CZ0722', 'Hluk', 2178, 2290, 38.7, 41.7);
INSERT INTO obce VALUES (5741, 'CZ0722', 'Horní Němčí', 425, 438, 39.2, 42.5);
INSERT INTO obce VALUES (5742, 'CZ0722', 'Hostějov', 18, 13, 40.7, 43.6);
INSERT INTO obce VALUES (5743, 'CZ0722', 'Hostětín', 117, 124, 41.9, 42.5);
INSERT INTO obce VALUES (5744, 'CZ0722', 'Hradčovice', 508, 533, 38.2, 42.3);
INSERT INTO obce VALUES (5745, 'CZ0722', 'Huštěnovice', 494, 494, 40.7, 42.7);
INSERT INTO obce VALUES (5746, 'CZ0722', 'Jalubí', 909, 892, 37.5, 40.8);
INSERT INTO obce VALUES (5747, 'CZ0722', 'Jankovice', 244, 228, 41.1, 43.8);
INSERT INTO obce VALUES (5748, 'CZ0722', 'Kněžpole', 566, 555, 37.1, 41.4);
INSERT INTO obce VALUES (5749, 'CZ0722', 'Komňa', 296, 283, 40.0, 40.3);
INSERT INTO obce VALUES (5750, 'CZ0722', 'Korytná', 485, 494, 40.5, 44.3);
INSERT INTO obce VALUES (5751, 'CZ0722', 'Kostelany nad Moravou', 449, 467, 38.6, 41.3);
INSERT INTO obce VALUES (5752, 'CZ0722', 'Košíky', 214, 202, 39.1, 42.7);
INSERT INTO obce VALUES (5753, 'CZ0722', 'Kudlovice', 467, 475, 38.2, 39.2);
INSERT INTO obce VALUES (5754, 'CZ0722', 'Kunovice', 2627, 2871, 39.9, 42.0);
INSERT INTO obce VALUES (5755, 'CZ0722', 'Lopeník', 89, 86, 47.8, 44.0);
INSERT INTO obce VALUES (5756, 'CZ0722', 'Medlovice', 250, 234, 33.9, 39.8);
INSERT INTO obce VALUES (5757, 'CZ0722', 'Mistřice', 591, 587, 37.6, 40.3);
INSERT INTO obce VALUES (5758, 'CZ0722', 'Modrá', 323, 331, 39.2, 42.1);
INSERT INTO obce VALUES (5759, 'CZ0722', 'Nedachlebice', 403, 412, 41.1, 43.2);
INSERT INTO obce VALUES (5760, 'CZ0722', 'Nedakonice', 776, 789, 38.5, 40.3);
INSERT INTO obce VALUES (5761, 'CZ0722', 'Nezdenice', 368, 392, 42.8, 51.9);
INSERT INTO obce VALUES (5762, 'CZ0722', 'Nivnice', 1578, 1707, 39.2, 41.6);
INSERT INTO obce VALUES (5763, 'CZ0722', 'Ořechov', 361, 369, 37.5, 42.9);
INSERT INTO obce VALUES (5764, 'CZ0722', 'Ostrožská Lhota', 775, 790, 38.7, 42.4);
INSERT INTO obce VALUES (5765, 'CZ0722', 'Ostrožská Nová Ves', 1646, 1725, 39.6, 42.2);
INSERT INTO obce VALUES (5766, 'CZ0722', 'Osvětimany', 421, 434, 38.8, 44.2);
INSERT INTO obce VALUES (5767, 'CZ0722', 'Pašovice', 349, 361, 39.1, 43.4);
INSERT INTO obce VALUES (5768, 'CZ0722', 'Pitín', 473, 490, 37.6, 42.2);
INSERT INTO obce VALUES (5769, 'CZ0722', 'Podolí', 435, 424, 38.4, 40.2);
INSERT INTO obce VALUES (5770, 'CZ0722', 'Polešovice', 975, 1020, 39.6, 42.3);
INSERT INTO obce VALUES (5771, 'CZ0722', 'Popovice', 523, 527, 39.4, 45.1);
INSERT INTO obce VALUES (5772, 'CZ0722', 'Prakšice', 481, 491, 38.5, 41.0);
INSERT INTO obce VALUES (5773, 'CZ0722', 'Rudice', 213, 245, 39.5, 44.8);
INSERT INTO obce VALUES (5774, 'CZ0722', 'Salaš', 203, 178, 39.8, 43.0);
INSERT INTO obce VALUES (5775, 'CZ0722', 'Slavkov', 341, 365, 39.4, 45.3);
INSERT INTO obce VALUES (5776, 'CZ0722', 'Staré Hutě', 69, 63, 42.6, 43.9);
INSERT INTO obce VALUES (5777, 'CZ0722', 'Staré Město', 3336, 3506, 39.7, 42.4);
INSERT INTO obce VALUES (5778, 'CZ0722', 'Starý Hrozenkov', 437, 452, 38.1, 41.8);
INSERT INTO obce VALUES (5779, 'CZ0722', 'Strání', 1778, 1859, 38.9, 41.6);
INSERT INTO obce VALUES (5780, 'CZ0722', 'Stříbrnice', 213, 203, 39.9, 45.9);
INSERT INTO obce VALUES (5781, 'CZ0722', 'Stupava', 76, 69, 45.6, 50.5);
INSERT INTO obce VALUES (5782, 'CZ0722', 'Suchá Loz', 570, 585, 38.6, 41.5);
INSERT INTO obce VALUES (5783, 'CZ0722', 'Sušice', 307, 286, 39.1, 43.2);
INSERT INTO obce VALUES (5784, 'CZ0722', 'Svárov', 123, 129, 39.8, 42.9);
INSERT INTO obce VALUES (5785, 'CZ0722', 'Šumice', 869, 873, 39.4, 42.8);
INSERT INTO obce VALUES (5786, 'CZ0722', 'Topolná', 792, 850, 36.9, 41.7);
INSERT INTO obce VALUES (5787, 'CZ0722', 'Traplice', 549, 592, 39.9, 40.0);
INSERT INTO obce VALUES (5788, 'CZ0722', 'Tučapy', 96, 131, 38.5, 42.0);
INSERT INTO obce VALUES (5789, 'CZ0722', 'Tupesy', 557, 543, 37.4, 41.5);
INSERT INTO obce VALUES (5790, 'CZ0722', 'Uherské Hradiště', 12114, 13437, 39.8, 43.2);
INSERT INTO obce VALUES (5791, 'CZ0722', 'Uherský Brod', 8451, 8666, 39.3, 43.0);
INSERT INTO obce VALUES (5792, 'CZ0722', 'Uherský Ostroh', 2182, 2314, 39.9, 42.9);
INSERT INTO obce VALUES (5793, 'CZ0722', 'Újezdec', 128, 122, 38.1, 38.6);
INSERT INTO obce VALUES (5794, 'CZ0722', 'Vápenice', 97, 92, 38.6, 45.7);
INSERT INTO obce VALUES (5795, 'CZ0722', 'Vážany', 200, 213, 40.2, 43.1);
INSERT INTO obce VALUES (5796, 'CZ0722', 'Velehrad', 600, 723, 39.9, 44.9);
INSERT INTO obce VALUES (5797, 'CZ0722', 'Veletiny', 276, 277, 39.7, 44.3);
INSERT INTO obce VALUES (5798, 'CZ0722', 'Vlčnov', 1492, 1587, 38.9, 41.8);
INSERT INTO obce VALUES (5799, 'CZ0722', 'Vyškovec', 85, 64, 43.0, 40.5);
INSERT INTO obce VALUES (5800, 'CZ0722', 'Záhorovice', 550, 521, 38.3, 41.0);
INSERT INTO obce VALUES (5801, 'CZ0722', 'Zlámanec', 167, 148, 39.9, 43.6);
INSERT INTO obce VALUES (5802, 'CZ0722', 'Zlechov', 814, 836, 39.4, 42.4);
INSERT INTO obce VALUES (5803, 'CZ0722', 'Žítková', 85, 101, 38.8, 44.2);
INSERT INTO obce VALUES (5804, 'CZ0723', 'Branky', 462, 459, 37.2, 38.6);
INSERT INTO obce VALUES (5805, 'CZ0723', 'Bystřička', 468, 485, 39.3, 42.4);
INSERT INTO obce VALUES (5806, 'CZ0723', 'Dolní Bečva', 899, 928, 39.0, 42.6);
INSERT INTO obce VALUES (5807, 'CZ0723', 'Francova Lhota', 821, 792, 37.2, 41.2);
INSERT INTO obce VALUES (5808, 'CZ0723', 'Halenkov', 1195, 1224, 37.5, 41.5);
INSERT INTO obce VALUES (5809, 'CZ0723', 'Horní Bečva', 1240, 1226, 40.7, 44.0);
INSERT INTO obce VALUES (5810, 'CZ0723', 'Horní Lideč', 690, 711, 35.3, 38.2);
INSERT INTO obce VALUES (5811, 'CZ0723', 'Hošťálková', 1048, 1051, 38.1, 40.0);
INSERT INTO obce VALUES (5812, 'CZ0723', 'Hovězí', 1199, 1197, 38.0, 40.7);
INSERT INTO obce VALUES (5813, 'CZ0723', 'Huslenky', 1054, 1062, 38.8, 41.4);
INSERT INTO obce VALUES (5814, 'CZ0723', 'Hutisko-Solanec', 983, 1022, 40.2, 41.6);
INSERT INTO obce VALUES (5815, 'CZ0723', 'Choryně', 360, 358, 37.0, 39.9);
INSERT INTO obce VALUES (5816, 'CZ0723', 'Jablůnka', 1002, 1008, 39.5, 42.5);
INSERT INTO obce VALUES (5817, 'CZ0723', 'Janová', 384, 393, 38.3, 42.2);
INSERT INTO obce VALUES (5818, 'CZ0723', 'Jarcová', 389, 392, 37.9, 42.3);
INSERT INTO obce VALUES (5819, 'CZ0723', 'Karolinka', 1348, 1346, 39.1, 44.2);
INSERT INTO obce VALUES (5820, 'CZ0723', 'Kateřinice', 485, 473, 38.3, 41.8);
INSERT INTO obce VALUES (5821, 'CZ0723', 'Kelč', 1355, 1339, 36.9, 39.8);
INSERT INTO obce VALUES (5822, 'CZ0723', 'Kladeruby', 211, 223, 37.9, 39.2);
INSERT INTO obce VALUES (5823, 'CZ0723', 'Kunovice', 305, 322, 38.6, 41.8);
INSERT INTO obce VALUES (5824, 'CZ0723', 'Lačnov', 428, 448, 36.6, 39.5);
INSERT INTO obce VALUES (5825, 'CZ0723', 'Leskovec', 328, 331, 38.4, 42.7);
INSERT INTO obce VALUES (5826, 'CZ0723', 'Lešná', 944, 1033, 38.8, 39.5);
INSERT INTO obce VALUES (5827, 'CZ0723', 'Lhota u Vsetína', 375, 393, 39.4, 43.4);
INSERT INTO obce VALUES (5828, 'CZ0723', 'Lidečko', 934, 896, 36.2, 39.1);
INSERT INTO obce VALUES (5829, 'CZ0723', 'Liptál', 715, 741, 39.9, 41.3);
INSERT INTO obce VALUES (5830, 'CZ0723', 'Loučka', 374, 398, 37.5, 41.5);
INSERT INTO obce VALUES (5831, 'CZ0723', 'Lužná', 290, 295, 38.7, 42.0);
INSERT INTO obce VALUES (5832, 'CZ0723', 'Malá Bystřice', 166, 161, 42.1, 45.7);
INSERT INTO obce VALUES (5833, 'CZ0723', 'Mikulůvka', 336, 368, 38.7, 42.9);
INSERT INTO obce VALUES (5834, 'CZ0723', 'Nový Hrozenkov', 1397, 1347, 38.3, 41.6);
INSERT INTO obce VALUES (5835, 'CZ0723', 'Oznice', 212, 193, 38.1, 41.9);
INSERT INTO obce VALUES (5836, 'CZ0723', 'Podolí', 124, 113, 36.2, 40.2);
INSERT INTO obce VALUES (5837, 'CZ0723', 'Police', 283, 271, 37.8, 41.7);
INSERT INTO obce VALUES (5838, 'CZ0723', 'Pozděchov', 280, 277, 41.2, 43.0);
INSERT INTO obce VALUES (5839, 'CZ0723', 'Prlov', 278, 266, 37.2, 41.8);
INSERT INTO obce VALUES (5840, 'CZ0723', 'Prostřední Bečva', 815, 872, 40.1, 42.1);
INSERT INTO obce VALUES (5841, 'CZ0723', 'Pržno', 361, 322, 41.2, 43.8);
INSERT INTO obce VALUES (5842, 'CZ0723', 'Ratiboř', 877, 892, 38.7, 41.0);
INSERT INTO obce VALUES (5843, 'CZ0723', 'Rožnov pod Radhoštěm', 8056, 8815, 39.3, 43.0);
INSERT INTO obce VALUES (5844, 'CZ0723', 'Růžďka', 453, 484, 38.3, 43.0);
INSERT INTO obce VALUES (5845, 'CZ0723', 'Seninka', 176, 146, 38.0, 45.5);
INSERT INTO obce VALUES (5846, 'CZ0723', 'Střelná', 306, 312, 38.0, 40.7);
INSERT INTO obce VALUES (5847, 'CZ0723', 'Střítež nad Bečvou', 416, 424, 39.1, 41.7);
INSERT INTO obce VALUES (5848, 'CZ0723', 'Študlov', 260, 247, 36.0, 41.4);
INSERT INTO obce VALUES (5849, 'CZ0723', 'Ústí', 298, 313, 40.2, 40.9);
INSERT INTO obce VALUES (5850, 'CZ0723', 'Valašská Bystřice', 1146, 1145, 39.1, 41.1);
INSERT INTO obce VALUES (5851, 'CZ0723', 'Valašská Polanka', 699, 674, 36.3, 39.9);
INSERT INTO obce VALUES (5852, 'CZ0723', 'Valašská Senice', 239, 253, 38.9, 39.8);
INSERT INTO obce VALUES (5853, 'CZ0723', 'Valašské Meziříčí', 13204, 13972, 38.9, 42.2);
INSERT INTO obce VALUES (5854, 'CZ0723', 'Valašské Příkazy', 137, 141, 36.7, 38.2);
INSERT INTO obce VALUES (5855, 'CZ0723', 'Velká Lhota', 238, 237, 39.1, 38.9);
INSERT INTO obce VALUES (5856, 'CZ0723', 'Velké Karlovice', 1297, 1302, 40.2, 43.4);
INSERT INTO obce VALUES (5857, 'CZ0723', 'Vidče', 842, 830, 38.5, 41.0);
INSERT INTO obce VALUES (5858, 'CZ0723', 'Vigantice', 476, 490, 39.8, 41.9);
INSERT INTO obce VALUES (5859, 'CZ0723', 'Vsetín', 13167, 14391, 39.3, 42.7);
INSERT INTO obce VALUES (5860, 'CZ0723', 'Zašová', 1477, 1443, 38.8, 41.2);
INSERT INTO obce VALUES (5861, 'CZ0723', 'Zděchov', 294, 313, 39.1, 44.2);
INSERT INTO obce VALUES (5862, 'CZ0723', 'Zubří', 2782, 2754, 39.5, 40.9);
INSERT INTO obce VALUES (5863, 'CZ0724', 'Bělov', 144, 142, 38.6, 40.0);
INSERT INTO obce VALUES (5864, 'CZ0724', 'Biskupice', 358, 362, 37.9, 41.2);
INSERT INTO obce VALUES (5865, 'CZ0724', 'Bohuslavice nad Vláří', 193, 199, 39.3, 42.6);
INSERT INTO obce VALUES (5866, 'CZ0724', 'Bohuslavice u Zlína', 408, 391, 39.1, 43.3);
INSERT INTO obce VALUES (5867, 'CZ0724', 'Bratřejov', 378, 386, 37.3, 42.4);
INSERT INTO obce VALUES (5868, 'CZ0724', 'Brumov-Bylnice', 2954, 2909, 38.1, 41.2);
INSERT INTO obce VALUES (5869, 'CZ0724', 'Březnice', 611, 603, 39.7, 41.7);
INSERT INTO obce VALUES (5870, 'CZ0724', 'Březová', 248, 255, 38.1, 42.0);
INSERT INTO obce VALUES (5871, 'CZ0724', 'Březůvky', 324, 335, 40.4, 41.0);
INSERT INTO obce VALUES (5872, 'CZ0724', 'Dešná', 94, 86, 38.1, 40.6);
INSERT INTO obce VALUES (5873, 'CZ0724', 'Dobrkovice', 126, 136, 40.1, 44.2);
INSERT INTO obce VALUES (5874, 'CZ0724', 'Dolní Lhota', 294, 315, 36.9, 37.5);
INSERT INTO obce VALUES (5875, 'CZ0724', 'Doubravy', 235, 244, 38.4, 40.3);
INSERT INTO obce VALUES (5876, 'CZ0724', 'Drnovice', 238, 208, 36.9, 42.1);
INSERT INTO obce VALUES (5877, 'CZ0724', 'Držková', 183, 169, 38.1, 41.1);
INSERT INTO obce VALUES (5878, 'CZ0724', 'Fryšták', 1769, 1904, 39.1, 41.9);
INSERT INTO obce VALUES (5879, 'CZ0724', 'Halenkovice', 906, 895, 38.6, 40.9);
INSERT INTO obce VALUES (5880, 'CZ0724', 'Haluzice', 45, 35, 42.9, 49.7);
INSERT INTO obce VALUES (5881, 'CZ0724', 'Horní Lhota', 281, 276, 37.7, 40.4);
INSERT INTO obce VALUES (5882, 'CZ0724', 'Hostišová', 246, 229, 35.2, 37.7);
INSERT INTO obce VALUES (5883, 'CZ0724', 'Hrobice', 246, 248, 39.4, 43.6);
INSERT INTO obce VALUES (5884, 'CZ0724', 'Hřivínův Újezd', 250, 287, 39.9, 42.2);
INSERT INTO obce VALUES (5885, 'CZ0724', 'Hvozdná', 586, 580, 37.6, 40.0);
INSERT INTO obce VALUES (5886, 'CZ0724', 'Jasenná', 465, 478, 38.4, 41.1);
INSERT INTO obce VALUES (5887, 'CZ0724', 'Jestřabí', 159, 139, 39.4, 43.7);
INSERT INTO obce VALUES (5888, 'CZ0724', 'Kaňovice', 123, 145, 38.5, 42.7);
INSERT INTO obce VALUES (5889, 'CZ0724', 'Karlovice', 115, 128, 39.9, 43.5);
INSERT INTO obce VALUES (5890, 'CZ0724', 'Kašava', 451, 464, 37.1, 39.6);
INSERT INTO obce VALUES (5891, 'CZ0724', 'Kelníky', 87, 75, 41.3, 45.6);
INSERT INTO obce VALUES (5894, 'CZ0724', 'Lhota', 433, 381, 36.5, 40.6);
INSERT INTO obce VALUES (5895, 'CZ0724', 'Lhotsko', 134, 127, 36.3, 42.7);
INSERT INTO obce VALUES (5896, 'CZ0724', 'Lípa', 336, 373, 38.7, 44.1);
INSERT INTO obce VALUES (5897, 'CZ0724', 'Lipová', 158, 172, 37.4, 42.2);
INSERT INTO obce VALUES (5898, 'CZ0724', 'Loučka', 203, 268, 45.4, 53.4);
INSERT INTO obce VALUES (5899, 'CZ0724', 'Ludkovice', 358, 347, 38.0, 42.1);
INSERT INTO obce VALUES (5900, 'CZ0724', 'Luhačovice', 2624, 2714, 40.0, 45.3);
INSERT INTO obce VALUES (5901, 'CZ0724', 'Lukov', 823, 925, 38.5, 45.3);
INSERT INTO obce VALUES (5902, 'CZ0724', 'Lukoveček', 206, 212, 39.8, 43.4);
INSERT INTO obce VALUES (5903, 'CZ0724', 'Lutonina', 190, 201, 39.3, 42.8);
INSERT INTO obce VALUES (5904, 'CZ0724', 'Machová', 281, 269, 37.2, 40.3);
INSERT INTO obce VALUES (5905, 'CZ0724', 'Mysločovice', 307, 324, 39.2, 41.0);
INSERT INTO obce VALUES (5906, 'CZ0724', 'Napajedla', 3698, 3790, 39.8, 42.9);
INSERT INTO obce VALUES (5907, 'CZ0724', 'Návojná', 363, 354, 39.3, 40.7);
INSERT INTO obce VALUES (5908, 'CZ0724', 'Nedašov', 714, 687, 35.6, 37.9);
INSERT INTO obce VALUES (5909, 'CZ0724', 'Nedašova Lhota', 380, 365, 34.2, 38.0);
INSERT INTO obce VALUES (5910, 'CZ0724', 'Neubuz', 219, 226, 37.1, 40.3);
INSERT INTO obce VALUES (5911, 'CZ0724', 'Oldřichovice', 185, 191, 36.5, 38.7);
INSERT INTO obce VALUES (5912, 'CZ0724', 'Ostrata', 177, 192, 38.9, 42.7);
INSERT INTO obce VALUES (5913, 'CZ0724', 'Otrokovice', 9055, 9463, 39.3, 43.1);
INSERT INTO obce VALUES (5914, 'CZ0724', 'Petrůvka', 158, 163, 42.8, 45.3);
INSERT INTO obce VALUES (5915, 'CZ0724', 'Podhradí', 97, 99, 36.4, 41.6);
INSERT INTO obce VALUES (5916, 'CZ0724', 'Podkopná Lhota', 160, 149, 40.5, 47.5);
INSERT INTO obce VALUES (5917, 'CZ0724', 'Pohořelice', 404, 421, 39.6, 44.7);
INSERT INTO obce VALUES (5918, 'CZ0724', 'Poteč', 401, 364, 35.2, 40.9);
INSERT INTO obce VALUES (5919, 'CZ0724', 'Pozlovice', 549, 619, 38.5, 40.3);
INSERT INTO obce VALUES (5920, 'CZ0724', 'Provodov', 362, 386, 41.2, 42.7);
INSERT INTO obce VALUES (5921, 'CZ0724', 'Racková', 376, 410, 35.6, 38.6);
INSERT INTO obce VALUES (5922, 'CZ0724', 'Rokytnice', 296, 287, 42.3, 44.1);
INSERT INTO obce VALUES (5923, 'CZ0724', 'Rudimov', 128, 123, 38.3, 44.2);
INSERT INTO obce VALUES (5924, 'CZ0724', 'Sazovice', 348, 373, 37.1, 39.0);
INSERT INTO obce VALUES (5925, 'CZ0724', 'Sehradice', 371, 386, 39.1, 41.5);
INSERT INTO obce VALUES (5926, 'CZ0724', 'Slavičín', 3331, 3516, 39.4, 42.7);
INSERT INTO obce VALUES (5927, 'CZ0724', 'Slopné', 282, 293, 38.0, 42.1);
INSERT INTO obce VALUES (5928, 'CZ0724', 'Slušovice', 1438, 1533, 36.3, 38.7);
INSERT INTO obce VALUES (5929, 'CZ0724', 'Spytihněv', 862, 857, 39.3, 41.7);
INSERT INTO obce VALUES (5930, 'CZ0724', 'Šanov', 246, 258, 39.1, 42.8);
INSERT INTO obce VALUES (5931, 'CZ0724', 'Šarovy', 107, 137, 39.9, 39.7);
INSERT INTO obce VALUES (5932, 'CZ0724', 'Štítná nad Vláří-Popov', 1172, 1131, 38.7, 41.4);
INSERT INTO obce VALUES (5933, 'CZ0724', 'Tečovice', 685, 638, 39.6, 40.8);
INSERT INTO obce VALUES (5934, 'CZ0724', 'Tichov', 172, 163, 35.7, 40.1);
INSERT INTO obce VALUES (5935, 'CZ0724', 'Tlumačov', 1270, 1254, 39.0, 41.1);
INSERT INTO obce VALUES (5936, 'CZ0724', 'Trnava', 578, 573, 38.0, 41.9);
INSERT INTO obce VALUES (5937, 'CZ0724', 'Ublo', 126, 133, 38.7, 43.3);
INSERT INTO obce VALUES (5938, 'CZ0724', 'Újezd', 611, 602, 37.4, 39.4);
INSERT INTO obce VALUES (5939, 'CZ0724', 'Valašské Klobouky', 2490, 2651, 37.7, 41.2);
INSERT INTO obce VALUES (5940, 'CZ0724', 'Velký Ořechov', 349, 393, 37.1, 40.0);
INSERT INTO obce VALUES (5941, 'CZ0724', 'Veselá', 385, 388, 36.1, 39.9);
INSERT INTO obce VALUES (5942, 'CZ0724', 'Vizovice', 2253, 2408, 38.2, 40.4);
INSERT INTO obce VALUES (5943, 'CZ0724', 'Vlachova Lhota', 120, 112, 36.7, 43.1);
INSERT INTO obce VALUES (5944, 'CZ0724', 'Vlachovice', 712, 780, 38.2, 41.4);
INSERT INTO obce VALUES (5945, 'CZ0724', 'Vlčková', 193, 183, 39.5, 43.4);
INSERT INTO obce VALUES (5946, 'CZ0724', 'Všemina', 536, 573, 37.6, 39.8);
INSERT INTO obce VALUES (5947, 'CZ0724', 'Vysoké Pole', 406, 399, 35.8, 38.1);
INSERT INTO obce VALUES (5948, 'CZ0724', 'Zádveřice-Raková', 671, 706, 39.3, 41.4);
INSERT INTO obce VALUES (5949, 'CZ0724', 'Zlín', 36023, 39691, 40.4, 44.1);
INSERT INTO obce VALUES (5950, 'CZ0724', 'Želechovice nad Dřevnicí', 966, 960, 40.8, 44.5);
INSERT INTO obce VALUES (5951, 'CZ0724', 'Žlutava', 559, 555, 37.5, 38.9);
INSERT INTO obce VALUES (5952, 'CZ0801', 'Andělská Hora', 170, 199, 40.5, 38.6);
INSERT INTO obce VALUES (5953, 'CZ0801', 'Bílčice', 124, 112, 40.1, 42.9);
INSERT INTO obce VALUES (5954, 'CZ0801', 'Bohušov', 227, 213, 35.4, 41.0);
INSERT INTO obce VALUES (5955, 'CZ0801', 'Brantice', 660, 644, 37.4, 40.4);
INSERT INTO obce VALUES (5956, 'CZ0801', 'Bruntál', 8294, 8970, 37.2, 40.1);
INSERT INTO obce VALUES (5957, 'CZ0801', 'Břidličná', 1776, 1778, 38.9, 41.8);
INSERT INTO obce VALUES (5958, 'CZ0801', 'Býkov-Láryšov', 62, 89, 39.6, 38.4);
INSERT INTO obce VALUES (5959, 'CZ0801', 'Čaková', 157, 150, 36.8, 40.1);
INSERT INTO obce VALUES (5960, 'CZ0801', 'Dětřichov nad Bystřicí', 240, 224, 39.9, 42.0);
INSERT INTO obce VALUES (5961, 'CZ0801', 'Dívčí Hrad', 145, 127, 35.1, 39.7);
INSERT INTO obce VALUES (5962, 'CZ0801', 'Dlouhá Stráň', 44, 44, 44.1, 43.8);
INSERT INTO obce VALUES (5963, 'CZ0801', 'Dolní Moravice', 213, 222, 37.7, 40.9);
INSERT INTO obce VALUES (5964, 'CZ0801', 'Dvorce', 703, 747, 39.5, 40.8);
INSERT INTO obce VALUES (5965, 'CZ0801', 'Heřmanovice', 177, 176, 40.6, 41.1);
INSERT INTO obce VALUES (5966, 'CZ0801', 'Hlinka', 115, 121, 35.8, 37.2);
INSERT INTO obce VALUES (5967, 'CZ0801', 'Holčovice', 378, 336, 39.1, 40.3);
INSERT INTO obce VALUES (5968, 'CZ0801', 'Horní Benešov', 1237, 1220, 37.4, 39.8);
INSERT INTO obce VALUES (5969, 'CZ0801', 'Horní Město', 491, 482, 39.3, 40.8);
INSERT INTO obce VALUES (5970, 'CZ0801', 'Horní Životice', 174, 162, 37.8, 39.1);
INSERT INTO obce VALUES (5971, 'CZ0801', 'Hošťálkovy', 285, 285, 40.9, 44.4);
INSERT INTO obce VALUES (5972, 'CZ0801', 'Janov', 148, 163, 43.5, 47.5);
INSERT INTO obce VALUES (5973, 'CZ0801', 'Jindřichov', 776, 682, 37.8, 41.1);
INSERT INTO obce VALUES (5974, 'CZ0801', 'Jiříkov', 180, 137, 36.4, 41.3);
INSERT INTO obce VALUES (5975, 'CZ0801', 'Karlova Studánka', 101, 108, 36.1, 44.7);
INSERT INTO obce VALUES (5976, 'CZ0801', 'Karlovice', 571, 551, 38.4, 41.6);
INSERT INTO obce VALUES (5977, 'CZ0801', 'Krasov', 189, 153, 37.9, 44.1);
INSERT INTO obce VALUES (5978, 'CZ0801', 'Krnov', 12080, 12979, 38.9, 42.7);
INSERT INTO obce VALUES (5979, 'CZ0801', 'Křišťanovice', 141, 128, 41.5, 39.9);
INSERT INTO obce VALUES (5980, 'CZ0801', 'Leskovec nad Moravicí', 234, 219, 37.7, 42.9);
INSERT INTO obce VALUES (5981, 'CZ0801', 'Lichnov', 563, 514, 35.2, 39.2);
INSERT INTO obce VALUES (5982, 'CZ0801', 'Liptaň', 231, 242, 40.4, 41.4);
INSERT INTO obce VALUES (5983, 'CZ0801', 'Lomnice', 261, 282, 39.7, 39.0);
INSERT INTO obce VALUES (5984, 'CZ0801', 'Ludvíkov', 167, 160, 40.0, 41.6);
INSERT INTO obce VALUES (5985, 'CZ0801', 'Malá Morávka', 326, 330, 40.5, 43.4);
INSERT INTO obce VALUES (5986, 'CZ0801', 'Malá Štáhle', 73, 78, 41.1, 40.5);
INSERT INTO obce VALUES (5987, 'CZ0801', 'Město Albrechtice', 1769, 1810, 38.4, 42.7);
INSERT INTO obce VALUES (5988, 'CZ0801', 'Mezina', 145, 140, 37.7, 39.1);
INSERT INTO obce VALUES (5989, 'CZ0801', 'Milotice nad Opavou', 208, 218, 39.0, 38.2);
INSERT INTO obce VALUES (5990, 'CZ0801', 'Moravskoslezský Kočov', 269, 243, 37.6, 39.2);
INSERT INTO obce VALUES (5991, 'CZ0801', 'Nová Pláň', 20, 23, 33.4, 32.5);
INSERT INTO obce VALUES (5992, 'CZ0801', 'Nové Heřminovy', 139, 132, 39.0, 43.6);
INSERT INTO obce VALUES (5993, 'CZ0801', 'Oborná', 185, 167, 37.0, 38.6);
INSERT INTO obce VALUES (5994, 'CZ0801', 'Osoblaha', 558, 575, 36.4, 41.4);
INSERT INTO obce VALUES (5995, 'CZ0801', 'Petrovice', 68, 67, 48.2, 47.3);
INSERT INTO obce VALUES (5996, 'CZ0801', 'Razová', 267, 248, 37.5, 39.3);
INSERT INTO obce VALUES (5997, 'CZ0801', 'Roudno', 93, 86, 44.5, 50.0);
INSERT INTO obce VALUES (5998, 'CZ0801', 'Rudná pod Pradědem', 220, 178, 38.2, 40.1);
INSERT INTO obce VALUES (5999, 'CZ0801', 'Rusín', 69, 58, 43.8, 45.6);
INSERT INTO obce VALUES (6000, 'CZ0801', 'Rýmařov', 4286, 4425, 39.2, 42.2);
INSERT INTO obce VALUES (6001, 'CZ0801', 'Ryžoviště', 323, 343, 40.7, 41.5);
INSERT INTO obce VALUES (6002, 'CZ0801', 'Slezské Pavlovice', 92, 99, 40.9, 40.1);
INSERT INTO obce VALUES (6003, 'CZ0801', 'Slezské Rudoltice', 342, 291, 34.3, 38.9);
INSERT INTO obce VALUES (6004, 'CZ0801', 'Stará Ves', 257, 271, 40.8, 41.6);
INSERT INTO obce VALUES (6005, 'CZ0801', 'Staré Heřminovy', 100, 121, 44.6, 41.8);
INSERT INTO obce VALUES (6006, 'CZ0801', 'Staré Město', 415, 411, 37.1, 36.8);
INSERT INTO obce VALUES (6007, 'CZ0801', 'Světlá Hora', 755, 730, 37.9, 39.6);
INSERT INTO obce VALUES (6008, 'CZ0801', 'Svobodné Heřmanice', 265, 265, 36.8, 39.1);
INSERT INTO obce VALUES (6009, 'CZ0801', 'Široká Niva', 310, 282, 40.6, 40.6);
INSERT INTO obce VALUES (6010, 'CZ0801', 'Třemešná', 502, 432, 39.5, 42.4);
INSERT INTO obce VALUES (6011, 'CZ0801', 'Tvrdkov', 123, 110, 43.2, 47.3);
INSERT INTO obce VALUES (6012, 'CZ0801', 'Úvalno', 479, 500, 38.4, 40.7);
INSERT INTO obce VALUES (6013, 'CZ0801', 'Václavov u Bruntálu', 268, 247, 36.9, 37.7);
INSERT INTO obce VALUES (6014, 'CZ0801', 'Valšov', 126, 120, 39.4, 39.8);
INSERT INTO obce VALUES (6015, 'CZ0801', 'Velká Štáhle', 177, 175, 37.4, 42.6);
INSERT INTO obce VALUES (6016, 'CZ0801', 'Vrbno pod Pradědem', 2806, 2934, 39.5, 42.9);
INSERT INTO obce VALUES (6017, 'CZ0801', 'Vysoká', 177, 174, 35.8, 39.7);
INSERT INTO obce VALUES (6018, 'CZ0801', 'Zátor', 588, 617, 38.1, 39.1);
INSERT INTO obce VALUES (6019, 'CZ0802', 'Baška', 1729, 1745, 38.6, 42.1);
INSERT INTO obce VALUES (6020, 'CZ0802', 'Bílá', 144, 143, 42.9, 45.2);
INSERT INTO obce VALUES (6021, 'CZ0802', 'Bocanovice', 215, 226, 36.9, 40.1);
INSERT INTO obce VALUES (6022, 'CZ0802', 'Brušperk', 1842, 1943, 40.0, 43.0);
INSERT INTO obce VALUES (6023, 'CZ0802', 'Bruzovice', 370, 378, 38.8, 42.1);
INSERT INTO obce VALUES (6024, 'CZ0802', 'Bukovec', 702, 681, 34.5, 39.0);
INSERT INTO obce VALUES (6025, 'CZ0802', 'Bystřice', 2555, 2697, 38.2, 42.2);
INSERT INTO obce VALUES (6026, 'CZ0802', 'Čeladná', 1164, 1197, 39.9, 44.0);
INSERT INTO obce VALUES (6027, 'CZ0802', 'Dobrá', 1519, 1520, 39.2, 42.6);
INSERT INTO obce VALUES (6028, 'CZ0802', 'Dobratice', 525, 582, 38.5, 41.1);
INSERT INTO obce VALUES (6029, 'CZ0802', 'Dolní Domaslavice', 560, 583, 38.1, 40.3);
INSERT INTO obce VALUES (6030, 'CZ0802', 'Dolní Lomná', 413, 451, 39.5, 39.3);
INSERT INTO obce VALUES (6031, 'CZ0802', 'Dolní Tošanovice', 157, 159, 36.4, 41.8);
INSERT INTO obce VALUES (6032, 'CZ0802', 'Fryčovice', 1155, 1206, 39.6, 41.6);
INSERT INTO obce VALUES (6033, 'CZ0802', 'Frýdek-Místek', 28839, 29743, 38.6, 41.3);
INSERT INTO obce VALUES (6034, 'CZ0802', 'Frýdlant nad Ostravicí', 4627, 5054, 40.2, 43.0);
INSERT INTO obce VALUES (6035, 'CZ0802', 'Hnojník', 716, 755, 39.2, 43.3);
INSERT INTO obce VALUES (6036, 'CZ0802', 'Horní Domaslavice', 326, 341, 38.0, 40.7);
INSERT INTO obce VALUES (6037, 'CZ0802', 'Horní Lomná', 201, 170, 35.9, 42.6);
INSERT INTO obce VALUES (6038, 'CZ0802', 'Horní Tošanovice', 258, 259, 36.1, 41.9);
INSERT INTO obce VALUES (6039, 'CZ0802', 'Hrádek', 851, 930, 39.0, 39.9);
INSERT INTO obce VALUES (6040, 'CZ0802', 'Hrčava', 125, 128, 39.9, 40.1);
INSERT INTO obce VALUES (6041, 'CZ0802', 'Hukvaldy', 946, 982, 41.4, 43.9);
INSERT INTO obce VALUES (6042, 'CZ0802', 'Jablunkov', 2719, 2946, 36.8, 41.0);
INSERT INTO obce VALUES (6043, 'CZ0802', 'Janovice', 893, 895, 39.2, 43.0);
INSERT INTO obce VALUES (6044, 'CZ0802', 'Kaňovice', 131, 145, 38.6, 39.7);
INSERT INTO obce VALUES (6045, 'CZ0802', 'Komorní Lhotka', 596, 591, 41.5, 44.9);
INSERT INTO obce VALUES (6046, 'CZ0802', 'Košařiska', 196, 195, 36.7, 40.9);
INSERT INTO obce VALUES (6047, 'CZ0802', 'Kozlovice', 1446, 1478, 38.9, 41.1);
INSERT INTO obce VALUES (6048, 'CZ0802', 'Krásná', 324, 336, 41.1, 43.5);
INSERT INTO obce VALUES (6049, 'CZ0802', 'Krmelín', 1012, 1076, 38.8, 41.2);
INSERT INTO obce VALUES (6050, 'CZ0802', 'Kunčice pod Ondřejníkem', 1045, 1092, 39.7, 42.0);
INSERT INTO obce VALUES (6051, 'CZ0802', 'Lhotka', 252, 244, 37.7, 40.3);
INSERT INTO obce VALUES (6052, 'CZ0802', 'Lučina', 623, 582, 39.0, 43.9);
INSERT INTO obce VALUES (6053, 'CZ0802', 'Malenovice', 287, 275, 37.3, 36.8);
INSERT INTO obce VALUES (6054, 'CZ0802', 'Metylovice', 825, 833, 39.5, 41.9);
INSERT INTO obce VALUES (6055, 'CZ0802', 'Milíkov', 639, 633, 38.1, 42.2);
INSERT INTO obce VALUES (6056, 'CZ0802', 'Morávka', 549, 527, 40.1, 43.7);
INSERT INTO obce VALUES (6057, 'CZ0802', 'Mosty u Jablunkova', 1974, 1962, 39.1, 41.9);
INSERT INTO obce VALUES (6058, 'CZ0802', 'Návsí', 1878, 1999, 37.4, 41.1);
INSERT INTO obce VALUES (6059, 'CZ0802', 'Nižní Lhoty', 123, 137, 40.0, 42.7);
INSERT INTO obce VALUES (6060, 'CZ0802', 'Nošovice', 480, 514, 39.0, 38.9);
INSERT INTO obce VALUES (6061, 'CZ0802', 'Nýdek', 974, 999, 40.3, 42.6);
INSERT INTO obce VALUES (6062, 'CZ0802', 'Ostravice', 1196, 1132, 39.4, 43.7);
INSERT INTO obce VALUES (6063, 'CZ0802', 'Palkovice', 1529, 1561, 38.8, 40.4);
INSERT INTO obce VALUES (6064, 'CZ0802', 'Paskov', 1934, 2012, 37.5, 39.7);
INSERT INTO obce VALUES (6065, 'CZ0802', 'Pazderna', 137, 129, 37.5, 41.6);
INSERT INTO obce VALUES (6066, 'CZ0802', 'Písečná', 451, 440, 36.9, 38.2);
INSERT INTO obce VALUES (6067, 'CZ0802', 'Písek', 881, 897, 36.8, 39.4);
INSERT INTO obce VALUES (6068, 'CZ0802', 'Pražmo', 470, 514, 38.8, 40.4);
INSERT INTO obce VALUES (6069, 'CZ0802', 'Pržno', 566, 448, 38.3, 39.2);
INSERT INTO obce VALUES (6070, 'CZ0802', 'Pstruží', 439, 426, 38.6, 40.8);
INSERT INTO obce VALUES (6071, 'CZ0802', 'Raškovice', 873, 920, 39.0, 42.5);
INSERT INTO obce VALUES (6072, 'CZ0802', 'Ropice', 692, 772, 38.1, 40.5);
INSERT INTO obce VALUES (6073, 'CZ0802', 'Řeka', 233, 240, 40.4, 41.6);
INSERT INTO obce VALUES (6074, 'CZ0802', 'Řepiště', 855, 858, 40.1, 41.1);
INSERT INTO obce VALUES (6075, 'CZ0802', 'Sedliště', 707, 704, 37.4, 39.0);
INSERT INTO obce VALUES (6076, 'CZ0802', 'Smilovice', 364, 327, 37.5, 42.6);
INSERT INTO obce VALUES (6077, 'CZ0802', 'Soběšovice', 413, 426, 41.0, 43.1);
INSERT INTO obce VALUES (6078, 'CZ0802', 'Staré Hamry', 272, 271, 40.1, 44.5);
INSERT INTO obce VALUES (6079, 'CZ0802', 'Staré Město', 663, 680, 39.1, 41.5);
INSERT INTO obce VALUES (6080, 'CZ0802', 'Staříč', 962, 994, 37.6, 40.4);
INSERT INTO obce VALUES (6081, 'CZ0802', 'Střítež', 504, 509, 38.1, 39.3);
INSERT INTO obce VALUES (6082, 'CZ0802', 'Sviadnov', 758, 793, 39.3, 42.4);
INSERT INTO obce VALUES (6083, 'CZ0802', 'Třanovice', 505, 515, 36.9, 41.2);
INSERT INTO obce VALUES (6084, 'CZ0802', 'Třinec', 18187, 19218, 39.2, 42.8);
INSERT INTO obce VALUES (6085, 'CZ0802', 'Vělopolí', 139, 139, 38.0, 37.3);
INSERT INTO obce VALUES (6086, 'CZ0802', 'Vendryně', 2028, 2143, 38.7, 41.4);
INSERT INTO obce VALUES (6087, 'CZ0802', 'Vojkovice', 280, 283, 38.5, 39.3);
INSERT INTO obce VALUES (6088, 'CZ0802', 'Vyšní Lhoty', 464, 453, 35.4, 39.0);
INSERT INTO obce VALUES (6089, 'CZ0802', 'Žabeň', 326, 344, 40.0, 42.8);
INSERT INTO obce VALUES (6090, 'CZ0802', 'Žermanice', 135, 134, 36.6, 40.5);
INSERT INTO obce VALUES (6091, 'CZ0803', 'Albrechtice', 2001, 1990, 39.1, 41.0);
INSERT INTO obce VALUES (6092, 'CZ0803', 'Bohumín', 11280, 11538, 38.4, 42.2);
INSERT INTO obce VALUES (6093, 'CZ0803', 'Český Těšín', 12358, 13141, 38.2, 41.1);
INSERT INTO obce VALUES (6094, 'CZ0803', 'Dětmarovice', 1921, 2049, 40.4, 42.0);
INSERT INTO obce VALUES (6095, 'CZ0803', 'Dolní Lutyně', 2437, 2556, 40.0, 42.1);
INSERT INTO obce VALUES (6096, 'CZ0803', 'Doubrava', 685, 670, 39.1, 42.0);
INSERT INTO obce VALUES (6097, 'CZ0803', 'Havířov', 40591, 42305, 39.6, 42.7);
INSERT INTO obce VALUES (6098, 'CZ0803', 'Horní Bludovice', 975, 1007, 39.0, 41.9);
INSERT INTO obce VALUES (6099, 'CZ0803', 'Horní Suchá', 2293, 2232, 38.9, 42.2);
INSERT INTO obce VALUES (6100, 'CZ0803', 'Chotěbuz', 578, 573, 38.6, 42.0);
INSERT INTO obce VALUES (6101, 'CZ0803', 'Karviná', 30787, 31161, 39.3, 42.6);
INSERT INTO obce VALUES (6102, 'CZ0803', 'Orlová', 15982, 16448, 37.3, 40.0);
INSERT INTO obce VALUES (6103, 'CZ0803', 'Petrovice u Karviné', 3069, 2381, 40.7, 42.2);
INSERT INTO obce VALUES (6104, 'CZ0803', 'Petřvald', 3431, 3617, 39.6, 42.8);
INSERT INTO obce VALUES (6105, 'CZ0803', 'Rychvald', 3429, 3579, 40.3, 42.9);
INSERT INTO obce VALUES (6106, 'CZ0803', 'Stonava', 996, 876, 38.9, 42.8);
INSERT INTO obce VALUES (6107, 'CZ0803', 'Těrlicko', 2055, 2146, 41.0, 42.5);
INSERT INTO obce VALUES (6108, 'CZ0804', 'Albrechtičky', 341, 352, 39.1, 43.6);
INSERT INTO obce VALUES (6109, 'CZ0804', 'Bartošovice', 803, 817, 38.3, 40.5);
INSERT INTO obce VALUES (6110, 'CZ0804', 'Bernartice nad Odrou', 468, 455, 35.6, 39.9);
INSERT INTO obce VALUES (6111, 'CZ0804', 'Bílov', 280, 286, 37.5, 40.4);
INSERT INTO obce VALUES (6112, 'CZ0804', 'Bílovec', 3695, 3848, 38.2, 41.0);
INSERT INTO obce VALUES (6113, 'CZ0804', 'Bítov', 214, 197, 41.2, 45.8);
INSERT INTO obce VALUES (6114, 'CZ0804', 'Bordovice', 287, 276, 40.2, 41.8);
INSERT INTO obce VALUES (6115, 'CZ0804', 'Bravantice', 450, 382, 36.0, 39.9);
INSERT INTO obce VALUES (6116, 'CZ0804', 'Frenštát pod Radhoštěm', 5337, 5787, 38.6, 42.5);
INSERT INTO obce VALUES (6117, 'CZ0804', 'Fulnek', 2937, 3011, 38.3, 41.1);
INSERT INTO obce VALUES (6118, 'CZ0804', 'Heřmanice u Oder', 170, 173, 36.3, 36.0);
INSERT INTO obce VALUES (6119, 'CZ0804', 'Heřmánky', 84, 83, 38.4, 44.0);
INSERT INTO obce VALUES (6120, 'CZ0804', 'Hladké Životice', 475, 484, 37.5, 39.2);
INSERT INTO obce VALUES (6121, 'CZ0804', 'Hodslavice', 845, 890, 38.9, 41.4);
INSERT INTO obce VALUES (6122, 'CZ0804', 'Hostašovice', 369, 371, 38.3, 42.9);
INSERT INTO obce VALUES (6123, 'CZ0804', 'Jakubčovice nad Odrou', 358, 332, 37.6, 41.4);
INSERT INTO obce VALUES (6124, 'CZ0804', 'Jeseník nad Odrou', 926, 974, 37.6, 40.0);
INSERT INTO obce VALUES (6125, 'CZ0804', 'Jistebník', 750, 770, 38.8, 41.4);
INSERT INTO obce VALUES (6126, 'CZ0804', 'Kateřinice', 301, 335, 39.0, 41.8);
INSERT INTO obce VALUES (6127, 'CZ0804', 'Kopřivnice', 11320, 11724, 37.4, 39.7);
INSERT INTO obce VALUES (6128, 'CZ0804', 'Kujavy', 280, 257, 36.3, 39.6);
INSERT INTO obce VALUES (6129, 'CZ0804', 'Kunín', 932, 957, 35.9, 38.1);
INSERT INTO obce VALUES (6130, 'CZ0804', 'Lichnov', 744, 689, 39.0, 42.3);
INSERT INTO obce VALUES (6131, 'CZ0804', 'Luboměř', 195, 191, 38.2, 45.1);
INSERT INTO obce VALUES (6132, 'CZ0804', 'Mankovice', 282, 308, 36.5, 39.2);
INSERT INTO obce VALUES (6133, 'CZ0804', 'Mořkov', 1222, 1253, 39.2, 41.9);
INSERT INTO obce VALUES (6134, 'CZ0804', 'Mošnov', 366, 339, 38.8, 42.5);
INSERT INTO obce VALUES (6135, 'CZ0804', 'Nový Jičín', 12370, 13492, 38.3, 41.5);
INSERT INTO obce VALUES (6136, 'CZ0804', 'Odry', 3634, 3737, 37.7, 41.0);
INSERT INTO obce VALUES (6137, 'CZ0804', 'Petřvald', 872, 924, 39.4, 42.6);
INSERT INTO obce VALUES (6138, 'CZ0804', 'Příbor', 4310, 4437, 38.7, 42.2);
INSERT INTO obce VALUES (6139, 'CZ0804', 'Pustějov', 479, 517, 38.6, 41.0);
INSERT INTO obce VALUES (6140, 'CZ0804', 'Rybí', 563, 577, 38.7, 41.3);
INSERT INTO obce VALUES (6141, 'CZ0804', 'Sedlnice', 690, 717, 38.8, 39.5);
INSERT INTO obce VALUES (6142, 'CZ0804', 'Skotnice', 354, 348, 40.0, 40.4);
INSERT INTO obce VALUES (6143, 'CZ0804', 'Slatina', 356, 377, 39.3, 40.9);
INSERT INTO obce VALUES (6144, 'CZ0804', 'Spálov', 433, 472, 38.4, 42.4);
INSERT INTO obce VALUES (6145, 'CZ0804', 'Starý Jičín', 1301, 1268, 39.3, 41.1);
INSERT INTO obce VALUES (6146, 'CZ0804', 'Studénka', 4933, 5196, 39.3, 42.0);
INSERT INTO obce VALUES (6147, 'CZ0804', 'Suchdol nad Odrou', 1307, 1295, 37.8, 40.5);
INSERT INTO obce VALUES (6148, 'CZ0804', 'Šenov u Nového Jičína', 1026, 1067, 38.5, 41.7);
INSERT INTO obce VALUES (6149, 'CZ0804', 'Štramberk', 1649, 1681, 40.5, 43.8);
INSERT INTO obce VALUES (6150, 'CZ0804', 'Tichá', 825, 870, 38.6, 41.4);
INSERT INTO obce VALUES (6151, 'CZ0804', 'Tísek', 472, 480, 37.9, 40.1);
INSERT INTO obce VALUES (6152, 'CZ0804', 'Trnávka', 372, 336, 38.2, 42.2);
INSERT INTO obce VALUES (6153, 'CZ0804', 'Trojanovice', 1169, 1143, 39.4, 42.3);
INSERT INTO obce VALUES (6154, 'CZ0804', 'Velké Albrechtice', 506, 508, 37.7, 39.4);
INSERT INTO obce VALUES (6155, 'CZ0804', 'Veřovice', 975, 1004, 39.2, 41.2);
INSERT INTO obce VALUES (6156, 'CZ0804', 'Vražné', 428, 421, 37.4, 40.2);
INSERT INTO obce VALUES (6157, 'CZ0804', 'Vrchy', 111, 99, 38.9, 39.1);
INSERT INTO obce VALUES (6158, 'CZ0804', 'Závišice', 449, 427, 37.1, 40.4);
INSERT INTO obce VALUES (6159, 'CZ0804', 'Ženklava', 504, 495, 35.8, 38.9);
INSERT INTO obce VALUES (6160, 'CZ0804', 'Životice u Nového Jičína', 312, 303, 38.5, 41.5);
INSERT INTO obce VALUES (6161, 'CZ0805', 'Bělá', 324, 357, 40.4, 43.6);
INSERT INTO obce VALUES (6162, 'CZ0805', 'Bohuslavice', 823, 811, 37.7, 39.9);
INSERT INTO obce VALUES (6163, 'CZ0805', 'Bolatice', 2149, 2223, 38.0, 40.4);
INSERT INTO obce VALUES (6164, 'CZ0805', 'Branka u Opavy', 536, 552, 37.8, 40.2);
INSERT INTO obce VALUES (6165, 'CZ0805', 'Bratříkovice', 80, 67, 37.5, 45.0);
INSERT INTO obce VALUES (6166, 'CZ0805', 'Brumovice', 699, 730, 39.2, 40.3);
INSERT INTO obce VALUES (6167, 'CZ0805', 'Březová', 703, 683, 36.9, 38.8);
INSERT INTO obce VALUES (6168, 'CZ0805', 'Budišov nad Budišovkou', 1513, 1552, 38.8, 42.2);
INSERT INTO obce VALUES (6169, 'CZ0805', 'Budišovice', 309, 309, 38.5, 38.4);
INSERT INTO obce VALUES (6170, 'CZ0805', 'Čermná ve Slezsku', 182, 174, 33.4, 34.9);
INSERT INTO obce VALUES (6171, 'CZ0805', 'Darkovice', 623, 656, 38.5, 40.7);
INSERT INTO obce VALUES (6172, 'CZ0805', 'Děhylov', 336, 347, 41.6, 40.8);
INSERT INTO obce VALUES (6173, 'CZ0805', 'Dobroslavice', 351, 370, 43.1, 41.4);
INSERT INTO obce VALUES (6174, 'CZ0805', 'Dolní Benešov', 2073, 2123, 38.8, 41.9);
INSERT INTO obce VALUES (6175, 'CZ0805', 'Dolní Životice', 639, 518, 41.1, 39.6);
INSERT INTO obce VALUES (6176, 'CZ0805', 'Háj ve Slezsku', 1611, 1678, 40.7, 44.4);
INSERT INTO obce VALUES (6177, 'CZ0805', 'Hať', 1247, 1324, 38.9, 40.8);
INSERT INTO obce VALUES (6178, 'CZ0805', 'Hlavnice', 310, 323, 35.4, 40.1);
INSERT INTO obce VALUES (6179, 'CZ0805', 'Hlubočec', 289, 275, 39.2, 39.6);
INSERT INTO obce VALUES (6180, 'CZ0805', 'Hlučín', 6896, 7340, 39.4, 42.7);
INSERT INTO obce VALUES (6181, 'CZ0805', 'Hněvošice', 509, 519, 37.7, 41.3);
INSERT INTO obce VALUES (6182, 'CZ0805', 'Holasovice', 702, 675, 38.0, 40.7);
INSERT INTO obce VALUES (6183, 'CZ0805', 'Hrabyně', 574, 586, 44.4, 45.2);
INSERT INTO obce VALUES (6184, 'CZ0805', 'Hradec nad Moravicí', 2646, 2766, 38.4, 40.8);
INSERT INTO obce VALUES (6185, 'CZ0805', 'Chlebičov', 524, 570, 38.3, 40.7);
INSERT INTO obce VALUES (6186, 'CZ0805', 'Chuchelná', 627, 676, 38.8, 41.5);
INSERT INTO obce VALUES (6187, 'CZ0805', 'Chvalíkovice', 343, 350, 37.3, 39.3);
INSERT INTO obce VALUES (6188, 'CZ0805', 'Jakartovice', 564, 538, 39.1, 41.7);
INSERT INTO obce VALUES (6189, 'CZ0805', 'Jezdkovice', 118, 105, 39.2, 39.4);
INSERT INTO obce VALUES (6190, 'CZ0805', 'Kobeřice', 1649, 1625, 37.3, 39.9);
INSERT INTO obce VALUES (6191, 'CZ0805', 'Kozmice', 881, 923, 39.6, 43.0);
INSERT INTO obce VALUES (6192, 'CZ0805', 'Kravaře', 3367, 3454, 38.6, 41.1);
INSERT INTO obce VALUES (6193, 'CZ0805', 'Kružberk', 145, 138, 38.3, 43.4);
INSERT INTO obce VALUES (6194, 'CZ0805', 'Kyjovice', 401, 413, 43.6, 46.0);
INSERT INTO obce VALUES (6195, 'CZ0805', 'Lhotka u Litultovic', 96, 94, 35.9, 38.9);
INSERT INTO obce VALUES (6196, 'CZ0805', 'Litultovice', 400, 409, 37.6, 41.3);
INSERT INTO obce VALUES (6197, 'CZ0805', 'Ludgeřovice', 2335, 2369, 40.3, 43.9);
INSERT INTO obce VALUES (6198, 'CZ0805', 'Markvartovice', 931, 943, 38.1, 41.8);
INSERT INTO obce VALUES (6199, 'CZ0805', 'Melč', 336, 310, 37.5, 43.3);
INSERT INTO obce VALUES (6200, 'CZ0805', 'Mikolajice', 136, 118, 38.2, 41.8);
INSERT INTO obce VALUES (6201, 'CZ0805', 'Mladecko', 87, 84, 39.1, 45.3);
INSERT INTO obce VALUES (6202, 'CZ0805', 'Mokré Lazce', 567, 579, 37.9, 40.7);
INSERT INTO obce VALUES (6203, 'CZ0805', 'Moravice', 147, 103, 41.7, 44.5);
INSERT INTO obce VALUES (6204, 'CZ0805', 'Neplachovice', 458, 467, 37.9, 39.8);
INSERT INTO obce VALUES (6205, 'CZ0805', 'Nové Lublice', 99, 98, 39.2, 43.2);
INSERT INTO obce VALUES (6206, 'CZ0805', 'Nové Sedlice', 242, 264, 37.7, 40.5);
INSERT INTO obce VALUES (6207, 'CZ0805', 'Oldřišov', 649, 689, 37.3, 39.5);
INSERT INTO obce VALUES (6208, 'CZ0805', 'Opava', 28157, 30283, 38.8, 42.4);
INSERT INTO obce VALUES (6209, 'CZ0805', 'Otice', 661, 694, 37.4, 41.2);
INSERT INTO obce VALUES (6210, 'CZ0805', 'Píšť', 1048, 1059, 39.1, 43.1);
INSERT INTO obce VALUES (6211, 'CZ0805', 'Pustá Polom', 707, 748, 38.8, 42.6);
INSERT INTO obce VALUES (6212, 'CZ0805', 'Radkov', 244, 253, 39.4, 40.2);
INSERT INTO obce VALUES (6213, 'CZ0805', 'Raduň', 486, 484, 37.4, 41.9);
INSERT INTO obce VALUES (6214, 'CZ0805', 'Rohov', 314, 315, 36.7, 40.1);
INSERT INTO obce VALUES (6215, 'CZ0805', 'Skřipov', 508, 509, 38.6, 40.8);
INSERT INTO obce VALUES (6216, 'CZ0805', 'Slavkov', 903, 959, 36.1, 40.9);
INSERT INTO obce VALUES (6217, 'CZ0805', 'Služovice', 416, 393, 36.0, 40.9);
INSERT INTO obce VALUES (6218, 'CZ0805', 'Sosnová', 214, 212, 36.9, 39.6);
INSERT INTO obce VALUES (6219, 'CZ0805', 'Staré Těchanovice', 75, 67, 37.2, 39.6);
INSERT INTO obce VALUES (6220, 'CZ0805', 'Stěbořice', 698, 689, 37.8, 40.8);
INSERT INTO obce VALUES (6221, 'CZ0805', 'Strahovice', 453, 463, 36.2, 37.9);
INSERT INTO obce VALUES (6222, 'CZ0805', 'Sudice', 334, 336, 37.1, 40.2);
INSERT INTO obce VALUES (6223, 'CZ0805', 'Svatoňovice', 145, 163, 34.5, 37.3);
INSERT INTO obce VALUES (6224, 'CZ0805', 'Šilheřovice', 784, 821, 38.6, 40.7);
INSERT INTO obce VALUES (6225, 'CZ0805', 'Štáblovice', 317, 308, 37.9, 41.9);
INSERT INTO obce VALUES (6226, 'CZ0805', 'Štěpánkovice', 1510, 1601, 37.7, 39.9);
INSERT INTO obce VALUES (6227, 'CZ0805', 'Štítina', 584, 602, 38.2, 41.6);
INSERT INTO obce VALUES (6228, 'CZ0805', 'Těškovice', 395, 425, 39.7, 43.1);
INSERT INTO obce VALUES (6229, 'CZ0805', 'Třebom', 122, 102, 37.9, 41.5);
INSERT INTO obce VALUES (6230, 'CZ0805', 'Uhlířov', 175, 174, 37.8, 38.0);
INSERT INTO obce VALUES (6231, 'CZ0805', 'Velké Heraltice', 766, 810, 39.3, 41.3);
INSERT INTO obce VALUES (6232, 'CZ0805', 'Velké Hoštice', 847, 939, 38.1, 39.6);
INSERT INTO obce VALUES (6233, 'CZ0805', 'Větřkovice', 386, 354, 39.5, 42.7);
INSERT INTO obce VALUES (6234, 'CZ0805', 'Vítkov', 3004, 3119, 38.7, 42.6);
INSERT INTO obce VALUES (6235, 'CZ0805', 'Vršovice', 259, 230, 34.5, 40.8);
INSERT INTO obce VALUES (6236, 'CZ0805', 'Vřesina', 684, 736, 38.9, 40.6);
INSERT INTO obce VALUES (6237, 'CZ0805', 'Závada', 277, 309, 38.4, 40.4);
INSERT INTO obce VALUES (6238, 'CZ0806', 'Čavisov', 232, 239, 37.4, 41.0);
INSERT INTO obce VALUES (6239, 'CZ0806', 'Dolní Lhota', 685, 693, 39.7, 42.4);
INSERT INTO obce VALUES (6240, 'CZ0806', 'Horní Lhota', 344, 382, 39.4, 40.1);
INSERT INTO obce VALUES (6241, 'CZ0806', 'Klimkovice', 2019, 2089, 39.1, 42.1);
INSERT INTO obce VALUES (6242, 'CZ0806', 'Olbramice', 306, 291, 38.3, 40.3);
INSERT INTO obce VALUES (6243, 'CZ0806', 'Ostrava', 148183, 157823, 38.9, 42.4);
INSERT INTO obce VALUES (6244, 'CZ0806', 'Stará Ves nad Ondřejnicí', 1285, 1340, 40.2, 41.8);
INSERT INTO obce VALUES (6245, 'CZ0806', 'Šenov', 2854, 2986, 39.7, 42.8);
INSERT INTO obce VALUES (6246, 'CZ0806', 'Václavovice', 894, 889, 39.3, 42.3);
INSERT INTO obce VALUES (6247, 'CZ0806', 'Velká Polom', 871, 905, 38.6, 41.9);
INSERT INTO obce VALUES (6248, 'CZ0806', 'Vratimov', 3343, 3507, 40.4, 43.1);
INSERT INTO obce VALUES (6249, 'CZ0806', 'Vřesina', 1311, 1373, 40.5, 42.4);
INSERT INTO obce VALUES (6250, 'CZ0806', 'Zbyslavice', 290, 291, 38.4, 44.4);


--
-- Name: obce_id_seq; Type: SEQUENCE SET; Schema: public; Owner: pavel
--

SELECT pg_catalog.setval('obce_id_seq', 6250, true);


--
-- Data for Name: okresy; Type: TABLE DATA; Schema: public; Owner: pavel
--

INSERT INTO okresy VALUES ('CZ0201', 'Benešov');
INSERT INTO okresy VALUES ('CZ0202', 'Beroun');
INSERT INTO okresy VALUES ('CZ0203', 'Kladno');
INSERT INTO okresy VALUES ('CZ0204', 'Kolín');
INSERT INTO okresy VALUES ('CZ0205', 'Kutná Hora');
INSERT INTO okresy VALUES ('CZ0206', 'Mělník');
INSERT INTO okresy VALUES ('CZ0207', 'Mladá Boleslav');
INSERT INTO okresy VALUES ('CZ0208', 'Nymburk');
INSERT INTO okresy VALUES ('CZ020B', 'Příbram');
INSERT INTO okresy VALUES ('CZ020C', 'Rakovník');
INSERT INTO okresy VALUES ('CZ0311', 'České Budějovice');
INSERT INTO okresy VALUES ('CZ0312', 'Český Krumlov');
INSERT INTO okresy VALUES ('CZ0313', 'Jindřichův Hradec');
INSERT INTO okresy VALUES ('CZ0314', 'Písek');
INSERT INTO okresy VALUES ('CZ0315', 'Prachatice');
INSERT INTO okresy VALUES ('CZ0316', 'Strakonice');
INSERT INTO okresy VALUES ('CZ0317', 'Tábor');
INSERT INTO okresy VALUES ('CZ0321', 'Domažlice');
INSERT INTO okresy VALUES ('CZ0322', 'Klatovy');
INSERT INTO okresy VALUES ('CZ0326', 'Rokycany');
INSERT INTO okresy VALUES ('CZ0327', 'Tachov');
INSERT INTO okresy VALUES ('CZ0411', 'Cheb');
INSERT INTO okresy VALUES ('CZ0412', 'Karlovy Vary');
INSERT INTO okresy VALUES ('CZ0413', 'Sokolov');
INSERT INTO okresy VALUES ('CZ0421', 'Děčín');
INSERT INTO okresy VALUES ('CZ0422', 'Chomutov');
INSERT INTO okresy VALUES ('CZ0423', 'Litoměřice');
INSERT INTO okresy VALUES ('CZ0424', 'Louny');
INSERT INTO okresy VALUES ('CZ0425', 'Most');
INSERT INTO okresy VALUES ('CZ0426', 'Teplice');
INSERT INTO okresy VALUES ('CZ0427', 'Ústí nad Labem');
INSERT INTO okresy VALUES ('CZ0511', 'Česká Lípa');
INSERT INTO okresy VALUES ('CZ0512', 'Jablonec nad Nisou');
INSERT INTO okresy VALUES ('CZ0513', 'Liberec');
INSERT INTO okresy VALUES ('CZ0514', 'Semily');
INSERT INTO okresy VALUES ('CZ0521', 'Hradec Králové');
INSERT INTO okresy VALUES ('CZ0522', 'Jičín');
INSERT INTO okresy VALUES ('CZ0523', 'Náchod');
INSERT INTO okresy VALUES ('CZ0524', 'Rychnov nad Kněžnou');
INSERT INTO okresy VALUES ('CZ0525', 'Trutnov');
INSERT INTO okresy VALUES ('CZ0531', 'Chrudim');
INSERT INTO okresy VALUES ('CZ0532', 'Pardubice');
INSERT INTO okresy VALUES ('CZ0533', 'Svitavy');
INSERT INTO okresy VALUES ('CZ0534', 'Ústí nad Orlicí');
INSERT INTO okresy VALUES ('CZ0631', 'Havlíčkův Brod');
INSERT INTO okresy VALUES ('CZ0632', 'Jihlava');
INSERT INTO okresy VALUES ('CZ0633', 'Pelhřimov');
INSERT INTO okresy VALUES ('CZ0634', 'Třebíč');
INSERT INTO okresy VALUES ('CZ0635', 'Žďár nad Sázavou');
INSERT INTO okresy VALUES ('CZ0641', 'Blansko');
INSERT INTO okresy VALUES ('CZ0644', 'Břeclav');
INSERT INTO okresy VALUES ('CZ0645', 'Hodonín');
INSERT INTO okresy VALUES ('CZ0646', 'Vyškov');
INSERT INTO okresy VALUES ('CZ0647', 'Znojmo');
INSERT INTO okresy VALUES ('CZ0711', 'Jeseník');
INSERT INTO okresy VALUES ('CZ0712', 'Olomouc');
INSERT INTO okresy VALUES ('CZ0713', 'Prostějov');
INSERT INTO okresy VALUES ('CZ0714', 'Přerov');
INSERT INTO okresy VALUES ('CZ0715', 'Šumperk');
INSERT INTO okresy VALUES ('CZ0721', 'Kroměříž');
INSERT INTO okresy VALUES ('CZ0722', 'Uherské Hradiště');
INSERT INTO okresy VALUES ('CZ0723', 'Vsetín');
INSERT INTO okresy VALUES ('CZ0724', 'Zlín');
INSERT INTO okresy VALUES ('CZ0801', 'Bruntál');
INSERT INTO okresy VALUES ('CZ0802', 'Frýdek-Místek');
INSERT INTO okresy VALUES ('CZ0803', 'Karviná');
INSERT INTO okresy VALUES ('CZ0804', 'Nový Jičín');
INSERT INTO okresy VALUES ('CZ0805', 'Opava');
INSERT INTO okresy VALUES ('CZ0209', 'Praha-východ');
INSERT INTO okresy VALUES ('CZ020A', 'Praha-západ');
INSERT INTO okresy VALUES ('CZ0323', 'Plzeň-město');
INSERT INTO okresy VALUES ('CZ0324', 'Plzeň-jih');
INSERT INTO okresy VALUES ('CZ0325', 'Plzeň-sever');
INSERT INTO okresy VALUES ('CZ0642', 'Brno-město');
INSERT INTO okresy VALUES ('CZ0643', 'Brno-venkov');
INSERT INTO okresy VALUES ('CZ0806', 'Ostrava-město');
INSERT INTO okresy VALUES ('CZ0100', 'Praha');


--
-- Name: _obce_pkey; Type: CONSTRAINT; Schema: public; Owner: pavel; Tablespace: 
--

ALTER TABLE ONLY obce
    ADD CONSTRAINT _obce_pkey PRIMARY KEY (id);


--
-- Name: okresy_pkey; Type: CONSTRAINT; Schema: public; Owner: pavel; Tablespace: 
--

ALTER TABLE ONLY okresy
    ADD CONSTRAINT okresy_pkey PRIMARY KEY (id);


--
-- Name: obce_okres_id_idx; Type: INDEX; Schema: public; Owner: pavel; Tablespace: 
--

CREATE INDEX obce_okres_id_idx ON obce USING btree (okres_id);


--
-- Name: okresy_nuts_idx; Type: INDEX; Schema: public; Owner: pavel; Tablespace: 
--

CREATE UNIQUE INDEX okresy_nuts_idx ON okresy USING btree (id);


--
-- Name: obce_okres_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: pavel
--

ALTER TABLE ONLY obce
    ADD CONSTRAINT obce_okres_id_fk FOREIGN KEY (okres_id) REFERENCES okresy(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

COMMIT;