{% if data %}
{# Below will change object'w owner #}
{% if data.owner != o_data.owner %}
ALTER COLLATION {{ conn|qtIdent(o_data.schema, o_data.name) }}
  OWNER TO {{ data.owner }};
{% endif %}
{# Below will change object's comment  #}
{% if data.description != o_data.description %}
COMMENT ON COLLATION {{ conn|qtIdent(o_data.schema, o_data.name) }}
  IS '{{ data.description }}';
{% endif %}
{# Below will change object name #}
{% if data.name != o_data.name %}
ALTER COLLATION {{ conn|qtIdent(o_data.schema, o_data.name) }}
  RENAME TO {{ conn|qtIdent(data.name) }};
{% endif %}
{# Below will change the schema for object, with extra if condition we will also make sure that object has correct name  #}
{% if data.schema != o_data.schema %}
ALTER COLLATION {% if data.name != o_data.name %}{{ conn|qtIdent(o_data.schema, data.name) }}{% else %}{{ conn|qtIdent(o_data.schema, o_data.name) }}{% endif %}
 SET SCHEMA {{ conn|qtIdent(data.schema) }};
{% endif %}
{% endif %}


