{% import 'macros/security.macros' as SECLABLE %}
{% import 'macros/privilege.macros' as PRIVILEGE %}
{% if data %}
CREATE {% if data.relpersistence %}UNLOGGED {% endif %}TABLE {{conn|qtIdent(data.schema, data.name)}}
{% if data.typname %}

  OF {{ conn|qtIdent(data.typname) }}
{% endif %}
{% if data.like_relation %}
{% if data.coll_inherits %} ({% endif %}
 LIKE {{ data.like_relation }}{% if data.like_default_value %}
 INCLUDING DEFAULTS {% endif %}{% if data.like_constraints %}
 INCLUDING CONSTRAINTS {% endif %}{% if data.like_indexes %}
 INCLUDING INDEXES {% endif %}{% if data.like_storage %}
 INCLUDING STORAGE {% endif %}{% if data.like_comments %}
 INCLUDING STORAGE {% endif %}
{% if data.coll_inherits %}) {% endif %}
{% endif %}
{% if data.coll_inherits %}

INHERITS ({% for val in data.coll_inherits %}{% if loop.index != 1 %}, {% endif %}{{val}}{% endfor %})
{% endif %}
WITH (
  OIDS = {% if data.relhasoids %}TRUE{% else %}FALSE
{% endif %}
{% if data.fillfactor %}
, FILLFACTOR = {{ data.fillfactor }}
{% endif %}
{% if data.tblautovacuum %}
, autovacuum_enabled = {% if data.autovacuum_enabled %}true{% else %}false
{% endif %}
{% if data.autovacuum_vacuum_threshold %}
, autovacuum_vacuum_threshold = {{data.autovacuum_vacuum_threshold}}
{% endif %}
{% if data.autovacuum_analyze_threshold %}
, autovacuum_analyze_threshold = {{data.autovacuum_analyze_threshold}}
{% endif %}
{% if data.autovacuum_vacuum_scale_factor %}
, autovacuum_vacuum_scale_factor = {{data.autovacuum_vacuum_scale_factor}}
{% endif %}
{% if data.autovacuum_analyze_scale_factor %}
, autovacuum_analyze_scale_factor = {{data.autovacuum_analyze_scale_factor}}
{% endif %}
{% if data.autovacuum_vacuum_cost_delay %}
, autovacuum_vacuum_cost_delay = {{data.autovacuum_vacuum_cost_delay}}
{% endif %}
{% if data.autovacuum_vacuum_cost_limit %}
, autovacuum_vacuum_cost_limit = {{data.autovacuum_vacuum_cost_limit}}
{% endif %}
{% if data.autovacuum_freeze_min_age %}
, autovacuum_freeze_min_age = {{data.autovacuum_freeze_min_age}}
{% endif %}
{% if data.autovacuum_freeze_max_age %}
, autovacuum_freeze_max_age = {{data.autovacuum_freeze_max_age}}
{% endif %}
{% if data.autovacuum_freeze_table_age %}
, autovacuum_freeze_table_age = {{data.autovacuum_freeze_table_age}}
{% endif %}
{% endif %}
{% if data.toasttblautovacuum %}
, toast.autovacuum_enabled = {% if data.toast_autovacuum_enabled %}true{% else %}false
{% endif %}
{% if data.toast_autovacuum_vacuum_threshold %}
, toast.autovacuum_vacuum_threshold = {{data.toast_autovacuum_vacuum_threshold}}
{% endif %}
{% if data.toast_autovacuum_vacuum_scale_factor %}
, toast.autovacuum_vacuum_scale_factor = {{data.toast_autovacuum_vacuum_scale_factor}}
{% endif %}
{% if data.toast_autovacuum_vacuum_cost_delay %}
, toast.autovacuum_vacuum_cost_delay = {{data.toast_autovacuum_vacuum_cost_delay}}
{% endif %}
{% if data.toast_autovacuum_vacuum_cost_limit %}
, toast.autovacuum_vacuum_cost_limit = {{data.toast_autovacuum_vacuum_cost_limit}}
{% endif %}
{% if data.toast_autovacuum_freeze_min_age %}
, toast.autovacuum_freeze_min_age = {{data.toast_autovacuum_freeze_min_age}}
{% endif %}
{% if data.toast_autovacuum_freeze_max_age %}
, toast.autovacuum_freeze_max_age = {{data.toast_autovacuum_freeze_max_age}}
{% endif %}
{% if data.toast_autovacuum_freeze_table_age %}
, toast.autovacuum_freeze_table_age = {{data.toast_autovacuum_freeze_table_age}}
{% endif %}
{% endif %}

)

{### SQL for Tablespace ###}
{% if data.spcname %}
TABLESPACE {{ conn|qtIdent(data.spcname) }};

{% endif %}
{#########################################}
{#########################################}
{#########################################}
{### SQL for OWNER ###}
{% if data.relowner %}
ALTER TABLE {{conn|qtIdent(data.schema, data.name)}}
  OWNER to {{conn|qtIdent(data.relowner)}};

{% endif %}
{### Security Labels on Table ###}
{% if data.seclabels and data.seclabels|length > 0 %}
{% for r in data.seclabels %}
{{ SECLABLE.APPLY(conn, 'TABLE', data.name, r.provider, r.security_label) }}
{% endfor %}

{% endif %}
{###  ACL on Table ###}
{% if data.relacl %}
{% for priv in data.relacl %}
{{ PRIVILEGE.APPLY(conn, 'TABLE', priv.grantee, data.name, priv.without_grant, priv.with_grant) }}
{% endfor %}
{% endif %}
{### SQL for COMMENT ###}
{% if data.description %}
COMMENT ON TABLE {{conn|qtIdent(data.schema, data.name)}}
  IS {{data.description|qtLiteral}};

{% endif %}
{#=== END MAIN IF ===#}
{% endif %}